#define TARGET_ANDROID
#define COMPILER_GCC
#define NO_MAKE_EXE
#define NO_MAKE_EXE_JAVA

#define OUTPUT_EXE     %(NAME)
#define OUTPUT_ANDROID   %(NAME).apk
#define OUTPUT_ANDROID_LIB   %(NAME).jar
#define OUTPUT_CON     %(NAME)
#define OUTPUT_DLL     lib%(NAME).so
#define OUTPUT_DLL_LIB lib%(NAME).so
#define OUTPUT_LIB     lib%(NAME).a

CONFIG

ANDROID_LIBC_DIR = %(CONFIG_ANDROID_NDK)/platforms/android-%(CONFIG_ANDROID_VERSION)/%(ANDROID_ARCH)/usr
ANDROID_GCC_DIR = %(CONFIG_ANDROID_NDK)/toolchains/%(ANDROID_TOOL_DIR)/prebuilt/%(CONFIG_ANDROID_PLATFORM)/bin

IFNDEF CONFIG_ANDROID_NDK
  ECHO Android NDK path not defined ! (CONFIG_ANDROID_NDK)
ENDIF

IFNDEF CONFIG_ANDROID_VERSION
  ECHO Android target version not defined ! (CONFIG_ANDROID_VERSION)
  CONFIG_ANDROID_VERSION = 15
ENDIF

IFNDEF CONFIG_ANDROID_SDK
  ECHO Android target SDK not defined, using CONFIG_ANDROID_SDK = %(CONFIG_ANDROID_VERSION)
  CONFIG_ANDROID_SDK = %(CONFIG_ANDROID_VERSION)
ENDIF

IFNDEF CONFIG_ANDROID_PLATFORM
  ECHO Android NDK build platform not defined ! (CONFIG_ANDROID_PLATFORM)
ENDIF

FILE %(PATH)settings.gradle
FOR EACH EXE_ANDROID,DLL_ANDROID
  PRINTNL include '%(PROJECT_NAME)'
  PRINTNL project(':%(PROJECT_NAME)').projectDir = new File('%(BUILDPATH)%(NAME)')
ENDFOR

FILE %(PATH)build.gradle
PRINTNL task wrapper(type: Wrapper) {
PRINTNL     gradleVersion = '2.2.1'
PRINTNL }
PRINTNL 
PRINTNL buildscript {
PRINTNL     repositories {
PRINTNL         mavenCentral()
PRINTNL     }
PRINTNL     dependencies {
PRINTNL         classpath 'com.android.tools.build:gradle:1.0.0'
PRINTNL     }
PRINTNL }

FILE %(PATH)gradle/wrapper/gradle-wrapper.properties
PRINTNL distributionUrl=https\://services.gradle.org/distributions/gradle-2.2.1-all.zip

FOR EACH WORKSPACE
  FOR EACH USE
    IF %(TYPE)==EXE_ANDROID
      IF %(PROJECT_VENDOR)==""
        PROJECT_VENDOR = CoreCodec
      ENDIF
      IF %(PROJECT_NAME)==""
        PROJECT_NAME = %(NAME)
      ENDIF
      
      MODULES = 
      // LIBs first
      FOR EACH USE
        IF %(TYPE)==LIB
          ../MODULES += %(NAME)
          FOR EACH SOURCE
            FOR EACH MIME_TYPE
              ../../../MIME_TYPES += %(NAME)
            ENDFOR
          ENDFOR
        ENDIF
        FOR EACH USE
          IF %(TYPE)==LIB
            ../../MODULES += %(NAME)
          FOR EACH SOURCE
            FOR EACH MIME_TYPE
              ../../../../MIME_TYPES += %(NAME)
            ENDFOR
          ENDFOR
          ENDIF
        ENDFOR
      ENDFOR
       // DLLs next
      FOR EACH USE
        IF %(TYPE)==DLL
          ../MODULES += %(NAME)
          FOR EACH SOURCE
            FOR EACH MIME_TYPE
              ../../../MIME_TYPES += %(NAME)
            ENDFOR
          ENDFOR
        ENDIF
        FOR EACH USE
          IF %(TYPE)==LIB
            FOR EACH SOURCE
              FOR EACH MIME_TYPE
                ../../../../MIME_TYPES += %(NAME)
              ENDFOR
            ENDFOR
          ENDIF
          IF %(TYPE)==DLL
            ../../MODULES += %(NAME)
            FOR EACH SOURCE
              FOR EACH MIME_TYPE
                ../../../../MIME_TYPES += %(NAME)
              ENDFOR
            ENDFOR
          ENDIF
        ENDFOR
      ENDFOR

      IF %(MODULES)!=""
        FILE %(BUILDPATH)%(NAME)/jni/Application.mk
        PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
        PRINTNL APP_PROJECT_PATH := $(call my-dir)/%(!OUTPUTPATH)
        PRINTNL APP_OPTIM := %(TARGOPTIM)
        PRINTNL APP_PLATFORM := android-%(CONFIG_ANDROID_VERSION)
        IF %(ANDROID_ABI)!=""
          PRINTNL APP_ABI := %(ANDROID_ABI)
        ENDIF
        PRINTNL APP_MODULES      := %(MODULES)
        PRINTNL APP_BUILD_SCRIPT := $(call my-dir)/Android.mk
        
        FILE %(BUILDPATH)%(NAME)/jni/Android.mk
        PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
        PRINTNL LOCAL_PATH := $(call my-dir)
        PRINTNL TARGET_ARCH := %(TARGARCH)
        PRINTNL TARGET_ARCH_ABI := %(ANDROID_ABI)
        PRINTNL TARGET_arm_release_CFLAGS += -fvisibility=hidden -D_HIDDEN
        PRINTNL TARGET_arm_release_CPPFLAGS += -fvisibility=hidden -D_HIDDEN
        FOR EACH USE
          // LIBs first
          IF %(TYPE)==LIB
            #include "android_mk.inc"
          ENDIF
          FOR EACH USE
            IF %(TYPE)==LIB
              #include "android_mk.inc"
            ENDIF
          ENDFOR
          // DLLs next
          IF %(TYPE)==DLL
            #include "android_mk.inc"
          ENDIF
          FOR EACH USE
            IF %(TYPE)==DLL
              #include "android_mk.inc"
            ENDIF
          ENDFOR
        ENDFOR
      ENDIF

//      FILEBIN %(BUILDPATH)%(NAME)/build_ndk.sh
//      SCRIPT
//      PRINTNL #!/bin/sh
//      PRINTNL 
//      PRINTNL # you can use V=1 for more traces and -B to force a rebuild
//      PRINTNL 
//      PRINTNL (cd %(CONFIG_ANDROID_NDK); make APP=%(:``|BUILDDIR) $1 $2 $3 $4 $5 $6)

      MKDIR %(BUILDPATH)%(NAME)/gen/
      MKDIR %(BUILDPATH)%(NAME)/res/

      FOR EACH INSTALL
        COPY %(|NAME) %(BUILDPATH)%(../NAME)/res/raw/%(<NAME).%(>NAME)
      ENDFOR
      FOR EACH USE
        FOR EACH INSTALL
          COPY %(|NAME) %(BUILDPATH)%(../../NAME)/res/raw/%(<NAME).%(>NAME)
        ENDFOR
      ENDFOR
      
      IF %(ANDROID_VALUE)!=""
        FOR EACH ANDROID_VALUE
          COPY %(|NAME) %(BUILDPATH)%(../NAME)/res/values/%(<NAME).%(>NAME)
        ENDFOR
      ENDIF
      IF %(ICON)!=""
        COPY %(|ICON)_64x64.png %(BUILDPATH)%(NAME)/res/drawable/%(<ICON)_64x64.png
      ENDIF
      
      FILE %(BUILDPATH)%(NAME)/.classpath
      PRINTNL <?xml version="1.0" encoding="UTF-8"?>
      PRINTNL <classpath>
      PRINTNL 	<classpathentry kind="con" path="com.android.ide.eclipse.adt.ANDROID_FRAMEWORK"/>
      PRINTNL 	<classpathentry exported="true" kind="con" path="com.android.ide.eclipse.adt.LIBRARIES"/>
      PRINTNL 	<classpathentry exported="true" kind="con" path="com.android.ide.eclipse.adt.DEPENDENCIES"/>
      PRINTNL 	<classpathentry kind="src" path="gen"/>
      FOR EACH SOURCEDIR
        PRINTNL 	<classpathentry kind="src" path="%(NAME)"/>
      ENDFOR
      PRINTNL 	<classpathentry kind="output" path="bin/classes"/>
      PRINTNL </classpath>
      MKDIR %(OUTPUTPATH)

      FILE %(BUILDPATH)%(NAME)/.project
      PRINTNL <?xml version="1.0" encoding="UTF-8"?>
      PRINTNL <projectDescription>
      PRINTNL 	<name>%(PROJECT_NAME)</name>
      PRINTNL 	<comment></comment>
      PRINTNL 	<projects>
      PRINTNL 	</projects>
      PRINTNL 	<buildSpec>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.ResourceManagerBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.PreCompilerBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>org.eclipse.jdt.core.javabuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.ApkBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 	</buildSpec>
      PRINTNL 	<natures>
      PRINTNL 		<nature>com.android.ide.eclipse.adt.AndroidNature</nature>
      PRINTNL 		<nature>org.eclipse.jdt.core.javanature</nature>
      PRINTNL 	</natures>
      PRINTNL 	<linkedResources>
      FOR EACH SOURCEDIR
        PRINTNL 		<link>
        PRINTNL 			<name>%(NAME)</name>
        PRINTNL 			<type>2</type>
        PRINTNL 			<location>%(|PATH)%(<NAME)</location>
        PRINTNL 		</link>
      ENDFOR
      PRINTNL 	</linkedResources>
      PRINTNL </projectDescription>
      
      FILE %(BUILDPATH)%(NAME)/project.properties
      PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
      PRINTNL 
      PRINTNL # Project target.
      PRINTNL target=android-%(CONFIG_ANDROID_SDK)
      LIB_INC_NUM = 0
      FOR EACH USE
        IF (%(TYPE)==DLL_ANDROID)
          INC ../LIB_INC_NUM
          PRINTNL android.library.reference.%(../LIB_INC_NUM)=../%(NAME)
        ENDIF
      ENDFOR
      
      FILE %(BUILDPATH)%(NAME)/.settings/org.eclipse.jdt.core.prefs
      PRINTNL eclipse.preferences.version=1
      PRINTNL org.eclipse.jdt.core.compiler.codegen.targetPlatform=1.6
      PRINTNL org.eclipse.jdt.core.compiler.compliance=1.6
      PRINTNL org.eclipse.jdt.core.compiler.source=1.6
      
      FILE %(BUILDPATH)%(NAME)/AndroidManifest.xml
      PRINTNL <?xml version="1.0" encoding="utf-8"?>
      PRINTNL <manifest xmlns:android="http://schemas.android.com/apk/res/android"
      IF %(PROJECT_PACKAGE)!=""
        PRINTNL     package="%(PROJECT_PACKAGE)"
      ELSE
        PRINTNL     package="com.%(PROJECT_VENDOR).%(`PROJECT_NAME)"
      ENDIF
      IF %(ANDROID_UID)!=""
        PRINTNL     android:sharedUserId="%(ANDROID_UID)"
        IF %(ANDROID_UID_NAME)!=""
          PRINTNL     android:sharedUserLabel="%(ANDROID_UID_NAME)"
        ENDIF
      ENDIF
      IF %(PROJECT_BUILD)!=""
        PRINTNL     android:versionCode="%(PROJECT_BUILD)"
        IF %(PROJECT_VERSION)!=""
          PRINTNL     android:versionName="%(PROJECT_VERSION).%(PROJECT_BUILD)"
        ENDIF
      ELIF %(PROJECT_VERSION)!=""
        PRINTNL     android:versionName="%(PROJECT_VERSION)"
      ENDIF
      PRINTNL     >
      PRINTNL     <uses-sdk
      PRINTNL         android:minSdkVersion="%(CONFIG_ANDROID_VERSION)"
      PRINTNL         android:targetSdkVersion="%(CONFIG_ANDROID_SDK)" />
      FOR EACH ANDROID_PERMISSION
        PRINTNL     <uses-permission android:name="%(NAME)"/>
      ENDFOR
      PRINTNL     <application
      IF %(ICON)!=""
        PRINTNL         android:icon="@drawable/%(<ICON)_64x64"
      ENDIF
      IF %(ANDROID_THEME)!=""
        PRINTNL         android:theme="@style/%(ANDROID_THEME)"
      ENDIF
      PRINTNL         android:label="%(PROJECT_NAME)" >
      FOR EACH SOURCEDIR
        FOR EACH LAUNCHER
          PRINTNL       <activity android:name="%(```/NAME).%(<NAME)"
          PRINTNL             android:configChanges="mcc|mnc|keyboardHidden|orientation|fontScale|screenSize|screenLayout"
          if %(ANDROID_MODE)!=""
            PRINTNL             android:launchMode="%(ANDROID_MODE)"
          ENDIF
          PRINTNL             android:windowSoftInputMode="stateHidden"
          IF %(../../MIME_TYPES)!=""
            PRINTNL             android:exported="true"
          ENDIF
          PRINTNL       >
          PRINTNL         <intent-filter>
          PRINTNL           <action android:name="android.intent.action.MAIN"/>
          PRINTNL           <category android:name="android.intent.category.LAUNCHER"/>
          PRINTNL         </intent-filter>
          IF %(../../MIME_TYPES)!=""
            FOR EACH ../../MIME_TYPES
              PRINTNL         <intent-filter>
              PRINTNL           <data android:mimeType="%(NAME)"/>
              PRINTNL           <action android:name="android.intent.action.VIEW"/>
              PRINTNL           <category android:name="android.intent.category.DEFAULT"/>
              PRINTNL         </intent-filter>
            ENDFOR
          ENDIF
          PRINTNL       </activity>
        ENDFOR

        FOR EACH ACTIVITY
          DIRPUSH %(!PATH)
            PRINTNL       <activity android:name="%(```/NAME).%(<NAME)"
            PRINTNL             android:configChanges="mcc|mnc|keyboardHidden|orientation|fontScale|screenSize|screenLayout" />
          DIRPOP
        ENDFOR

        FOR EACH SERVICE
          DIRPUSH %(!PATH)
            PRINTNL       <service android:name="%(```/NAME).%(<NAME)" />
          DIRPOP
        ENDFOR

      ENDFOR
      PRINTNL     </application>
      PRINTNL 
      PRINTNL </manifest> 


      FILE %(BUILDPATH)%(NAME)/build.gradle
      IF %(MODULES)!=""
        PRINTNL import org.apache.tools.ant.taskdefs.condition.Os
      ENDIF
      PRINTNL apply plugin: 'com.android.application'
      PRINTNL android {
      PRINTNL     compileSdkVersion %(CONFIG_ANDROID_SDK)
      PRINTNL     buildToolsVersion '20.0.0'
      PRINTNL     defaultConfig {
      PRINTNL         minSdkVersion %(CONFIG_ANDROID_VERSION)
      PRINTNL         targetSdkVersion %(CONFIG_ANDROID_SDK)
      PRINTNL     }

      PRINTNL 
      PRINTNL     sourceSets {
      PRINTNL         main {
      PRINTNL             manifest.srcFile 'AndroidManifest.xml'
      PRINTNL             java.srcDirs = [
      FOR EACH SOURCEDIR
        PRINTNL                 '%(!NAME)',
      ENDFOR
      PRINTNL             ]
      PRINTNL             jniLibs.srcDirs = ['libs']
      PRINTNL             res.srcDirs = ['res']
      PRINTNL             assets.srcDirs = ['assets']
      PRINTNL         }
      PRINTNL     }

      IF %(MODULES)!=""
        PRINTNL     // call regular ndk-build(.cmd) script from app directory
        PRINTNL     task ndkBuild(type: Exec) {
        PRINTNL         if (Os.isFamily(Os.FAMILY_WINDOWS)) {
        PRINTNL             commandLine '%(~`+CONFIG_ANDROID_NDK)ndk-build.cmd'
        PRINTNL         } else {
        PRINTNL             commandLine '%(+CONFIG_ANDROID_NDK)ndk-build'
        PRINTNL         }
        PRINTNL     }
        PRINTNL 
        PRINTNL     tasks.withType(JavaCompile) {
        PRINTNL         compileTask -> compileTask.dependsOn ndkBuild
        PRINTNL     }
      ENDIF
      PRINTNL }
      PRINTNL 
      PRINTNL dependencies {
        FOR EACH USE
          IF %(TYPE)==DLL_ANDROID
            PRINTNL    compile project(':%(PROJECT_NAME)')
          ENDIF
          FOR EACH USE
            IF %(TYPE)==DLL_ANDROID
              PRINTNL    compile project(':%(PROJECT_NAME)')
            ENDIF
          ENDFOR
        ENDFOR
      PRINTNL }

    ELIF %(TYPE)==DLL_ANDROID)
      IF %(PROJECT_VENDOR)==""
        PROJECT_VENDOR = CoreCodec
      ENDIF
      IF %(PROJECT_NAME)==""
        PROJECT_NAME = %(NAME)
      ENDIF
      
      MODULES = 
      // LIBs first
      FOR EACH USE
        IF %(TYPE)==LIB
          ../MODULES += %(NAME)
          FOR EACH SOURCE
            FOR EACH MIME_TYPE
              ../../../MIME_TYPES += %(NAME)
            ENDFOR
          ENDFOR
        ENDIF
        FOR EACH USE
          IF %(TYPE)==LIB
            ../../MODULES += %(NAME)
          ENDIF
        ENDFOR
      ENDFOR
       // DLLs next
      FOR EACH USE
        IF %(TYPE)==DLL
          ../MODULES += %(NAME)
          FOR EACH SOURCE
            FOR EACH MIME_TYPE
              ../../../MIME_TYPES += %(NAME)
            ENDFOR
          ENDFOR
        ENDIF
        FOR EACH USE
          IF %(TYPE)==DLL
            ../../MODULES += %(NAME)
          ENDIF
        ENDFOR
      ENDFOR

      IF %(MODULES)!=""
        FILE %(BUILDPATH)%(NAME)/jni/Application.mk
        PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
        PRINTNL APP_PROJECT_PATH := $(call my-dir)/%(!OUTPUTPATH)
        PRINTNL APP_OPTIM := %(TARGOPTIM)
        PRINTNL APP_PLATFORM := android-%(CONFIG_ANDROID_VERSION)
        IF %(ANDROID_ABI)!=""
          PRINTNL APP_ABI := %(ANDROID_ABI)
        ENDIF
        PRINTNL APP_MODULES      := %(MODULES)
        PRINTNL APP_BUILD_SCRIPT := $(call my-dir)/Android.mk
        
        FILE %(BUILDPATH)%(NAME)/jni/Android.mk
        PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
        PRINTNL LOCAL_PATH := $(call my-dir)
        FOR EACH USE
          // LIBs first
          IF %(TYPE)==LIB
            #include "android_mk.inc"
          ENDIF
          FOR EACH USE
            IF %(TYPE)==LIB
              #include "android_mk.inc"
            ENDIF
          ENDFOR
          // DLLs next
          IF %(TYPE)==DLL
            #include "android_mk.inc"
          ENDIF
          FOR EACH USE
            IF %(TYPE)==DLL
              #include "android_mk.inc"
            ENDIF
          ENDFOR
        ENDFOR
      ENDIF

      MKDIR %(BUILDPATH)%(NAME)/gen/
      MKDIR %(BUILDPATH)%(NAME)/res/

      FOR EACH INSTALL
        COPY %(|NAME) %(BUILDPATH)%(../NAME)/res/raw/%(<NAME).%(>NAME)
      ENDFOR
      FOR EACH USE
        FOR EACH INSTALL
          COPY %(|NAME) %(BUILDPATH)%(../../NAME)/res/raw/%(<NAME).%(>NAME)
        ENDFOR
      ENDFOR
      
      IF %(ANDROID_VALUE)!=""
        FOR EACH ANDROID_VALUE
          COPY %(|NAME) %(BUILDPATH)%(../NAME)/res/values/%(<NAME).%(>NAME)
        ENDFOR
      ENDIF
      IF %(ICON)!=""
        COPY %(|ICON)_64x64.png %(BUILDPATH)%(NAME)/res/drawable/%(<ICON)_64x64.png
      ENDIF

      FILE %(BUILDPATH)%(NAME)/.classpath
      PRINTNL <?xml version="1.0" encoding="UTF-8"?>
      PRINTNL <classpath>
      PRINTNL 	<classpathentry kind="con" path="com.android.ide.eclipse.adt.ANDROID_FRAMEWORK"/>
      PRINTNL 	<classpathentry exported="true" kind="con" path="com.android.ide.eclipse.adt.LIBRARIES"/>
      PRINTNL 	<classpathentry exported="true" kind="con" path="com.android.ide.eclipse.adt.DEPENDENCIES"/>
      PRINTNL 	<classpathentry kind="src" path="gen"/>
      FOR EACH SOURCEDIR
        PRINTNL 	<classpathentry kind="src" path="%(NAME)"/>
      ENDFOR
      PRINTNL 	<classpathentry kind="output" path="bin/classes"/>
      PRINTNL </classpath>
      MKDIR %(OUTPUTPATH)
      
      FILE %(BUILDPATH)%(NAME)/.project
      PRINTNL <?xml version="1.0" encoding="UTF-8"?>
      PRINTNL <projectDescription>
      PRINTNL 	<name>%(PROJECT_NAME)</name>
      PRINTNL 	<comment></comment>
      PRINTNL 	<projects>
      PRINTNL 	</projects>
      PRINTNL 	<buildSpec>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.ResourceManagerBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.PreCompilerBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>org.eclipse.jdt.core.javabuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 		<buildCommand>
      PRINTNL 			<name>com.android.ide.eclipse.adt.ApkBuilder</name>
      PRINTNL 			<arguments>
      PRINTNL 			</arguments>
      PRINTNL 		</buildCommand>
      PRINTNL 	</buildSpec>
      PRINTNL 	<natures>
      PRINTNL 		<nature>com.android.ide.eclipse.adt.AndroidNature</nature>
      PRINTNL 		<nature>org.eclipse.jdt.core.javanature</nature>
      PRINTNL 	</natures>
      PRINTNL 	<linkedResources>
      FOR EACH SOURCEDIR
        PRINTNL 		<link>
        PRINTNL 			<name>%(NAME)</name>
        PRINTNL 			<type>2</type>
        PRINTNL 			<location>%(|PATH)%(<NAME)</location>
        PRINTNL 		</link>
      ENDFOR
      PRINTNL 	</linkedResources>
      PRINTNL </projectDescription>
      
      FILE %(BUILDPATH)%(NAME)/project.properties
      PRINTNL # DO NOT EDIT, FILE GENERATED BY COREMAKE
      PRINTNL 
      PRINTNL # Project target.
      PRINTNL target=android-%(CONFIG_ANDROID_SDK)
      PRINTNL android.library=true
      LIB_INC_NUM = 0
      FOR EACH USE
        IF (%(TYPE)==DLL_ANDROID)
          INC ../LIB_INC_NUM
          PRINTNL android.library.reference.%(../LIB_INC_NUM)=../%(NAME)
        ENDIF
      ENDFOR
      
      FILE %(BUILDPATH)%(NAME)/.settings/org.eclipse.jdt.core.prefs
      PRINTNL eclipse.preferences.version=1
      PRINTNL org.eclipse.jdt.core.compiler.codegen.targetPlatform=1.6
      PRINTNL org.eclipse.jdt.core.compiler.compliance=1.6
      PRINTNL org.eclipse.jdt.core.compiler.source=1.6

      FILE %(BUILDPATH)%(NAME)/AndroidManifest.xml
      PRINTNL <?xml version="1.0" encoding="utf-8"?>
      PRINTNL <manifest xmlns:android="http://schemas.android.com/apk/res/android"
      IF %(PROJECT_PACKAGE)!=""
        PRINTNL     package="%(PROJECT_PACKAGE)"
      ELSE
        PRINTNL     package="com.%(PROJECT_VENDOR).%(`PROJECT_NAME)"
      ENDIF
      IF %(ANDROID_UID)!=""
        PRINTNL     android:sharedUserId="%(ANDROID_UID)"
        IF %(ANDROID_UID_NAME)!=""
          PRINTNL     android:sharedUserLabel="%(ANDROID_UID_NAME)"
        ENDIF
      ENDIF
      IF %(PROJECT_BUILD)!=""
        PRINTNL     android:versionCode="%(PROJECT_BUILD)"
        IF %(PROJECT_VERSION)!=""
          PRINTNL     android:versionName="%(PROJECT_VERSION).%(PROJECT_BUILD)"
        ENDIF
      ELIF %(PROJECT_VERSION)!=""
        PRINTNL     android:versionName="%(PROJECT_VERSION)"
      ENDIF
      PRINTNL     >
      PRINTNL     <uses-sdk
      PRINTNL         android:minSdkVersion="%(CONFIG_ANDROID_VERSION)"
      PRINTNL         android:targetSdkVersion="%(CONFIG_ANDROID_SDK)" />
      FOR EACH ANDROID_PERMISSION
        PRINTNL     <uses-permission android:name="%(NAME)"/>
      ENDFOR
      PRINTNL     <application
      IF %(ICON)!=""
        PRINTNL         android:icon="@drawable/%(<ICON)_64x64"
      ENDIF
      IF %(ANDROID_THEME)!=""
        PRINTNL         android:theme="@style/%(ANDROID_THEME)"
      ENDIF
      PRINTNL         >
      FOR EACH SOURCEDIR
        FOR EACH LAUNCHER
          PRINTNL       <activity android:name="%(```/NAME).%(<NAME)"
          PRINTNL             android:configChanges="mcc|mnc|keyboardHidden|orientation|fontScale|screenSize|screenLayout"
          if %(ANDROID_MODE)!=""
            PRINTNL             android:launchMode="%(ANDROID_MODE)"
          ENDIF
          PRINTNL             android:windowSoftInputMode="stateHidden"
          IF %(../../MIME_TYPES)!=""
            PRINTNL             android:exported="true"
          ENDIF
          PRINTNL       >
          PRINTNL         <intent-filter>
          PRINTNL           <action android:name="android.intent.action.MAIN"/>
          PRINTNL           <category android:name="android.intent.category.LAUNCHER"/>
          PRINTNL         </intent-filter>
          IF %(../../MIME_TYPES)!=""
            FOR EACH ../../MIME_TYPES
              PRINTNL         <intent-filter>
              PRINTNL           <data android:mimeType="%(NAME)"/>
              PRINTNL           <action android:name="android.intent.action.VIEW"/>
              PRINTNL           <category android:name="android.intent.category.DEFAULT"/>
              PRINTNL         </intent-filter>
            ENDFOR
          ENDIF
          PRINTNL       </activity>
        ENDFOR

        FOR EACH ACTIVITY
          DIRPUSH %(!PATH)
            PRINTNL       <activity android:name="%(```/NAME).%(<NAME)"
            PRINTNL             android:configChanges="mcc|mnc|keyboardHidden|orientation|fontScale|screenSize|screenLayout" />
          DIRPOP
        ENDFOR

        FOR EACH SERVICE
          DIRPUSH %(!PATH)
            PRINTNL       <service android:name="%(```/NAME).%(<NAME)" />
          DIRPOP
        ENDFOR

      ENDFOR
      PRINTNL     </application>
      PRINTNL 
      PRINTNL </manifest> 

      FILE %(BUILDPATH)%(NAME)/build.gradle
      IF %(MODULES)!=""
        PRINTNL import org.apache.tools.ant.taskdefs.condition.Os
      ENDIF
      PRINTNL apply plugin: 'com.android.library'
      PRINTNL android {
      PRINTNL     compileSdkVersion %(CONFIG_ANDROID_SDK)
      PRINTNL     buildToolsVersion '20.0.0'
      PRINTNL     defaultConfig {
      PRINTNL         minSdkVersion %(CONFIG_ANDROID_VERSION)
      PRINTNL         targetSdkVersion %(CONFIG_ANDROID_SDK)
      PRINTNL     }

      PRINTNL 
      PRINTNL     sourceSets {
      PRINTNL         main {
      PRINTNL             manifest.srcFile 'AndroidManifest.xml'
      PRINTNL             java.srcDirs = [
      FOR EACH SOURCEDIR
        PRINTNL                 '%(!NAME)',
      ENDFOR
      PRINTNL             ]
      PRINTNL             jniLibs.srcDir 'src/main/libs'
      PRINTNL             res.srcDirs = ['res']
      PRINTNL             assets.srcDirs = ['assets']
      PRINTNL         }
      PRINTNL     }

      IF %(MODULES)!=""
        PRINTNL     // call regular ndk-build(.cmd) script from app directory
        PRINTNL     task ndkBuild(type: Exec) {
        PRINTNL         if (Os.isFamily(Os.FAMILY_WINDOWS)) {
        PRINTNL             commandLine '%(~`+CONFIG_ANDROID_NDK)ndk-build.cmd'
        PRINTNL         } else {
        PRINTNL             commandLine '%(+CONFIG_ANDROID_NDK)ndk-build'
        PRINTNL         }
        PRINTNL     }
        PRINTNL 
        PRINTNL     tasks.withType(JavaCompile) {
        PRINTNL         compileTask -> compileTask.dependsOn ndkBuild
        PRINTNL     }
      ENDIF
      PRINTNL }
      PRINTNL 
      PRINTNL dependencies {
        FOR EACH USE
          IF %(TYPE)==DLL_ANDROID
            PRINTNL    compile project(':%(PROJECT_NAME)')
          ENDIF
          FOR EACH USE
            IF %(TYPE)==DLL_ANDROID
              PRINTNL    compile project(':%(PROJECT_NAME)')
            ENDIF
          ENDFOR
        ENDFOR
      PRINTNL }
    ENDIF
  ENDFOR
ENDFOR

CC = %(ANDROID_GCC_DIR)/%(ANDROID_GCC_PREFIX)-gcc
AR = %(ANDROID_GCC_DIR)/%(ANDROID_GCC_PREFIX)-ar
STRIP = %(ANDROID_GCC_DIR)/%(ANDROID_GCC_PREFIX)-strip 
STRIPFLAGS = -s -x
OS_INCLUDE += %(ANDROID_LIBC_DIR)/include
CCFLAGS += -DANDROID
SHFLAGS += %(ANDROID_LIBC_DIR)/lib/libc.so %(ANDROID_LIBC_DIR)/lib/libstdc++.so
IF %(ANDROID_ABI)=="armeabi-v7a-hard"
  SHFLAGS += %(ANDROID_LIBC_DIR)/lib/libm_hard.a -Wl,--no-warn-mismatch
ELSE
  SHFLAGS += %(ANDROID_LIBC_DIR)/lib/libm.so
ENDIF
SHFLAGS += -Wl,--no-undefined  -Wl,-rpath-link=%(ANDROID_LIBC_DIR)/lib -L%(ANDROID_LIBC_DIR)/lib
IF %(ANDROID_GCC_LIB)!=""
  SHFLAGS1 += %(ANDROID_GCC_DIR)/../lib/%(ANDROID_GCC_LIB)
ENDIF

#include "gcc_conf.inc"
