package models

import (
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
    ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e "github.com/microsoft/kiota-abstractions-go/store"
)

// DefenderDetectedMalwareActions specify Defender’s actions to take on detected Malware per threat level.
type DefenderDetectedMalwareActions struct {
    // Stores model information.
    backingStore ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore
}
// NewDefenderDetectedMalwareActions instantiates a new defenderDetectedMalwareActions and sets the default values.
func NewDefenderDetectedMalwareActions()(*DefenderDetectedMalwareActions) {
    m := &DefenderDetectedMalwareActions{
    }
    m.backingStore = ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStoreFactoryInstance();
    m.SetAdditionalData(make(map[string]any))
    return m
}
// CreateDefenderDetectedMalwareActionsFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
func CreateDefenderDetectedMalwareActionsFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewDefenderDetectedMalwareActions(), nil
}
// GetAdditionalData gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *DefenderDetectedMalwareActions) GetAdditionalData()(map[string]any) {
    val , err :=  m.backingStore.Get("additionalData")
    if err != nil {
        panic(err)
    }
    if val == nil {
        var value = make(map[string]any);
        m.SetAdditionalData(value);
    }
    return val.(map[string]any)
}
// GetBackingStore gets the backingStore property value. Stores model information.
func (m *DefenderDetectedMalwareActions) GetBackingStore()(ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore) {
    return m.backingStore
}
// GetFieldDeserializers the deserialization information for the current model
func (m *DefenderDetectedMalwareActions) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := make(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error))
    res["highSeverity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseDefenderThreatAction)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetHighSeverity(val.(*DefenderThreatAction))
        }
        return nil
    }
    res["lowSeverity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseDefenderThreatAction)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLowSeverity(val.(*DefenderThreatAction))
        }
        return nil
    }
    res["moderateSeverity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseDefenderThreatAction)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetModerateSeverity(val.(*DefenderThreatAction))
        }
        return nil
    }
    res["@odata.type"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetOdataType(val)
        }
        return nil
    }
    res["severeSeverity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseDefenderThreatAction)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSevereSeverity(val.(*DefenderThreatAction))
        }
        return nil
    }
    return res
}
// GetHighSeverity gets the highSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) GetHighSeverity()(*DefenderThreatAction) {
    val, err := m.GetBackingStore().Get("highSeverity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*DefenderThreatAction)
    }
    return nil
}
// GetLowSeverity gets the lowSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) GetLowSeverity()(*DefenderThreatAction) {
    val, err := m.GetBackingStore().Get("lowSeverity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*DefenderThreatAction)
    }
    return nil
}
// GetModerateSeverity gets the moderateSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) GetModerateSeverity()(*DefenderThreatAction) {
    val, err := m.GetBackingStore().Get("moderateSeverity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*DefenderThreatAction)
    }
    return nil
}
// GetOdataType gets the @odata.type property value. The OdataType property
func (m *DefenderDetectedMalwareActions) GetOdataType()(*string) {
    val, err := m.GetBackingStore().Get("odataType")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetSevereSeverity gets the severeSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) GetSevereSeverity()(*DefenderThreatAction) {
    val, err := m.GetBackingStore().Get("severeSeverity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*DefenderThreatAction)
    }
    return nil
}
// Serialize serializes information the current object
func (m *DefenderDetectedMalwareActions) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    if m.GetHighSeverity() != nil {
        cast := (*m.GetHighSeverity()).String()
        err := writer.WriteStringValue("highSeverity", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetLowSeverity() != nil {
        cast := (*m.GetLowSeverity()).String()
        err := writer.WriteStringValue("lowSeverity", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetModerateSeverity() != nil {
        cast := (*m.GetModerateSeverity()).String()
        err := writer.WriteStringValue("moderateSeverity", &cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteStringValue("@odata.type", m.GetOdataType())
        if err != nil {
            return err
        }
    }
    if m.GetSevereSeverity() != nil {
        cast := (*m.GetSevereSeverity()).String()
        err := writer.WriteStringValue("severeSeverity", &cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteAdditionalData(m.GetAdditionalData())
        if err != nil {
            return err
        }
    }
    return nil
}
// SetAdditionalData sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *DefenderDetectedMalwareActions) SetAdditionalData(value map[string]any)() {
    err := m.GetBackingStore().Set("additionalData", value)
    if err != nil {
        panic(err)
    }
}
// SetBackingStore sets the backingStore property value. Stores model information.
func (m *DefenderDetectedMalwareActions) SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)() {
    m.backingStore = value
}
// SetHighSeverity sets the highSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) SetHighSeverity(value *DefenderThreatAction)() {
    err := m.GetBackingStore().Set("highSeverity", value)
    if err != nil {
        panic(err)
    }
}
// SetLowSeverity sets the lowSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) SetLowSeverity(value *DefenderThreatAction)() {
    err := m.GetBackingStore().Set("lowSeverity", value)
    if err != nil {
        panic(err)
    }
}
// SetModerateSeverity sets the moderateSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) SetModerateSeverity(value *DefenderThreatAction)() {
    err := m.GetBackingStore().Set("moderateSeverity", value)
    if err != nil {
        panic(err)
    }
}
// SetOdataType sets the @odata.type property value. The OdataType property
func (m *DefenderDetectedMalwareActions) SetOdataType(value *string)() {
    err := m.GetBackingStore().Set("odataType", value)
    if err != nil {
        panic(err)
    }
}
// SetSevereSeverity sets the severeSeverity property value. Defender’s default action to take on detected Malware threats.
func (m *DefenderDetectedMalwareActions) SetSevereSeverity(value *DefenderThreatAction)() {
    err := m.GetBackingStore().Set("severeSeverity", value)
    if err != nil {
        panic(err)
    }
}
// DefenderDetectedMalwareActionsable 
type DefenderDetectedMalwareActionsable interface {
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.AdditionalDataHolder
    ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackedModel
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetBackingStore()(ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)
    GetHighSeverity()(*DefenderThreatAction)
    GetLowSeverity()(*DefenderThreatAction)
    GetModerateSeverity()(*DefenderThreatAction)
    GetOdataType()(*string)
    GetSevereSeverity()(*DefenderThreatAction)
    SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)()
    SetHighSeverity(value *DefenderThreatAction)()
    SetLowSeverity(value *DefenderThreatAction)()
    SetModerateSeverity(value *DefenderThreatAction)()
    SetOdataType(value *string)()
    SetSevereSeverity(value *DefenderThreatAction)()
}
