package models

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

// WindowsMalwareInformation malware information entity.
type WindowsMalwareInformation struct {
    Entity
}
// NewWindowsMalwareInformation instantiates a new windowsMalwareInformation and sets the default values.
func NewWindowsMalwareInformation()(*WindowsMalwareInformation) {
    m := &WindowsMalwareInformation{
        Entity: *NewEntity(),
    }
    return m
}
// CreateWindowsMalwareInformationFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
func CreateWindowsMalwareInformationFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewWindowsMalwareInformation(), nil
}
// GetAdditionalInformationUrl gets the additionalInformationUrl property value. Indicates an informational URL to learn more about the malware
func (m *WindowsMalwareInformation) GetAdditionalInformationUrl()(*string) {
    val, err := m.GetBackingStore().Get("additionalInformationUrl")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetCategory gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
func (m *WindowsMalwareInformation) GetCategory()(*WindowsMalwareCategory) {
    val, err := m.GetBackingStore().Get("category")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*WindowsMalwareCategory)
    }
    return nil
}
// GetDeviceMalwareStates gets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
func (m *WindowsMalwareInformation) GetDeviceMalwareStates()([]MalwareStateForWindowsDeviceable) {
    val, err := m.GetBackingStore().Get("deviceMalwareStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]MalwareStateForWindowsDeviceable)
    }
    return nil
}
// GetDisplayName gets the displayName property value. Indicates the name of the malware
func (m *WindowsMalwareInformation) GetDisplayName()(*string) {
    val, err := m.GetBackingStore().Get("displayName")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
func (m *WindowsMalwareInformation) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["additionalInformationUrl"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAdditionalInformationUrl(val)
        }
        return nil
    }
    res["category"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseWindowsMalwareCategory)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCategory(val.(*WindowsMalwareCategory))
        }
        return nil
    }
    res["deviceMalwareStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateMalwareStateForWindowsDeviceFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]MalwareStateForWindowsDeviceable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(MalwareStateForWindowsDeviceable)
                }
            }
            m.SetDeviceMalwareStates(res)
        }
        return nil
    }
    res["displayName"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDisplayName(val)
        }
        return nil
    }
    res["lastDetectionDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastDetectionDateTime(val)
        }
        return nil
    }
    res["severity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseWindowsMalwareSeverity)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSeverity(val.(*WindowsMalwareSeverity))
        }
        return nil
    }
    return res
}
// GetLastDetectionDateTime gets the lastDetectionDateTime property value. Indicates the last time the malware was detected in UTC
func (m *WindowsMalwareInformation) GetLastDetectionDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("lastDetectionDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetSeverity gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
func (m *WindowsMalwareInformation) GetSeverity()(*WindowsMalwareSeverity) {
    val, err := m.GetBackingStore().Get("severity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*WindowsMalwareSeverity)
    }
    return nil
}
// Serialize serializes information the current object
func (m *WindowsMalwareInformation) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteStringValue("additionalInformationUrl", m.GetAdditionalInformationUrl())
        if err != nil {
            return err
        }
    }
    if m.GetCategory() != nil {
        cast := (*m.GetCategory()).String()
        err = writer.WriteStringValue("category", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetDeviceMalwareStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetDeviceMalwareStates()))
        for i, v := range m.GetDeviceMalwareStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("deviceMalwareStates", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("displayName", m.GetDisplayName())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("lastDetectionDateTime", m.GetLastDetectionDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetSeverity() != nil {
        cast := (*m.GetSeverity()).String()
        err = writer.WriteStringValue("severity", &cast)
        if err != nil {
            return err
        }
    }
    return nil
}
// SetAdditionalInformationUrl sets the additionalInformationUrl property value. Indicates an informational URL to learn more about the malware
func (m *WindowsMalwareInformation) SetAdditionalInformationUrl(value *string)() {
    err := m.GetBackingStore().Set("additionalInformationUrl", value)
    if err != nil {
        panic(err)
    }
}
// SetCategory sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
func (m *WindowsMalwareInformation) SetCategory(value *WindowsMalwareCategory)() {
    err := m.GetBackingStore().Set("category", value)
    if err != nil {
        panic(err)
    }
}
// SetDeviceMalwareStates sets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
func (m *WindowsMalwareInformation) SetDeviceMalwareStates(value []MalwareStateForWindowsDeviceable)() {
    err := m.GetBackingStore().Set("deviceMalwareStates", value)
    if err != nil {
        panic(err)
    }
}
// SetDisplayName sets the displayName property value. Indicates the name of the malware
func (m *WindowsMalwareInformation) SetDisplayName(value *string)() {
    err := m.GetBackingStore().Set("displayName", value)
    if err != nil {
        panic(err)
    }
}
// SetLastDetectionDateTime sets the lastDetectionDateTime property value. Indicates the last time the malware was detected in UTC
func (m *WindowsMalwareInformation) SetLastDetectionDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("lastDetectionDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetSeverity sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
func (m *WindowsMalwareInformation) SetSeverity(value *WindowsMalwareSeverity)() {
    err := m.GetBackingStore().Set("severity", value)
    if err != nil {
        panic(err)
    }
}
// WindowsMalwareInformationable 
type WindowsMalwareInformationable interface {
    Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetAdditionalInformationUrl()(*string)
    GetCategory()(*WindowsMalwareCategory)
    GetDeviceMalwareStates()([]MalwareStateForWindowsDeviceable)
    GetDisplayName()(*string)
    GetLastDetectionDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetSeverity()(*WindowsMalwareSeverity)
    SetAdditionalInformationUrl(value *string)()
    SetCategory(value *WindowsMalwareCategory)()
    SetDeviceMalwareStates(value []MalwareStateForWindowsDeviceable)()
    SetDisplayName(value *string)()
    SetLastDetectionDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetSeverity(value *WindowsMalwareSeverity)()
}
