// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilFindingRevealed uses the Amazon Macie 2 API operation
// GetSensitiveDataOccurrences to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Macie2) WaitUntilFindingRevealed(input *GetSensitiveDataOccurrencesInput) error {
	return c.WaitUntilFindingRevealedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilFindingRevealedWithContext is an extended version of WaitUntilFindingRevealed.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie2) WaitUntilFindingRevealedWithContext(ctx aws.Context, input *GetSensitiveDataOccurrencesInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilFindingRevealed",
		MaxAttempts: 60,
		Delay:       request.ConstantWaiterDelay(2 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUCCESS",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "ERROR",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetSensitiveDataOccurrencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSensitiveDataOccurrencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
