/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBFileChooserButton;
import com.ca.commons.cbutil.CBPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class CBAutoGUI
extends JDialog
implements ActionListener {
    String commandName;
    Vector menuItems;
    Vector commonItems;
    final JEditorPane output = new JEditorPane();
    JTabbedPane tabPane;
    CBPanel commonOptions;
    PrimaryOption common;
    static String lastDirectory = "";
    boolean guiInitialised = false;
    boolean debug = true;
    static boolean standAlone = false;

    public static void main(String[] args) {
        standAlone = true;
        String fileName = "keytool.txt";
        if (args.length >= 1) {
            fileName = args[0];
        }
        CBAutoGUI MrGui = new CBAutoGUI(null, fileName);
        MrGui.show(null);
    }

    public CBAutoGUI(Frame owner, String fileName) {
        super(owner);
        this.menuItems = new Vector(8);
        this.commonItems = new Vector(8);
        this.common = new PrimaryOption("common options");
        this.processFile(fileName);
        this.setSize(650, 550);
    }

    static Object getNamedObject(Vector v, String s) {
        s = s.trim();
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).toString().trim().equalsIgnoreCase(s)) continue;
            return v.get(i);
        }
        return null;
    }

    public void setOption(String optionName) {
        if (optionName == null || optionName.length() == 0) {
            if (this.tabPane.getTabCount() > 0) {
                optionName = this.tabPane.getTitleAt(0).trim();
            } else {
                this.error("no tabs set! - nothing to display");
                return;
            }
        }
        if ((optionName = optionName.trim()).length() == 0) {
            return;
        }
        if (optionName.charAt(0) == '-') {
            optionName = optionName.substring(1);
        }
        if (optionName.length() == 0) {
            return;
        }
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (!optionName.equalsIgnoreCase(this.tabPane.getTitleAt(i).trim())) continue;
            this.tabPane.setSelectedIndex(i);
            return;
        }
    }

    public void setDefaultValue(String primaryOptionName, String secondaryOptionName, String defaultValue) {
        SecondaryOption secondary;
        primaryOptionName = CBAutoGUI.formatOptionName(primaryOptionName);
        secondaryOptionName = CBAutoGUI.formatOptionName(secondaryOptionName);
        PrimaryOption primary = (PrimaryOption)CBAutoGUI.getNamedObject(this.menuItems, primaryOptionName);
        if (primary == null) {
            primary = this.common;
        }
        if ((secondary = primary.get(secondaryOptionName)) != null) {
            secondary.setDefaultValue(defaultValue);
        }
    }

    public void show(String option) {
        if (this.debug) {
            System.out.println("showing GUI with option : " + (option == null ? " (no tab set) " : option));
        }
        if (!this.guiInitialised) {
            this.initialiseGUI();
        } else {
            this.clearPasswords();
        }
        this.setOption(option);
        this.setVisible(true);
    }

    public void initialiseGUI() {
        if (this.debug) {
            System.out.println("initialising GUI");
        }
        this.setTitle("GUI interface to " + this.commandName);
        CBPanel display = new CBPanel();
        this.addTabbedPanes(display);
        this.addCommonOptions(display);
        JPanel buttons = new JPanel();
        display.makeWide();
        display.add(new JLabel(""));
        display.makeLight();
        JButton OK = new JButton("Execute");
        display.add(OK);
        JButton Cancel = new JButton("Cancel");
        display.add(Cancel);
        display.makeWide();
        display.addLine(new JLabel(""));
        display.makeHeavy();
        OK.addActionListener(this);
        Cancel.addActionListener(this);
        this.output.setBorder(new TitledBorder(new LineBorder(Color.black, 2), "output"));
        this.output.setPreferredSize(new Dimension(400, 150));
        display.addLine(new JScrollPane(this.output));
        this.getContentPane().add(display);
        this.setVisible(true);
        this.guiInitialised = true;
    }

    public void addTabbedPanes(CBPanel display) {
        if (this.menuItems.size() == 0) {
            return;
        }
        this.tabPane = new JTabbedPane();
        for (int i = 0; i < this.menuItems.size(); ++i) {
            PrimaryOption primary = (PrimaryOption)this.menuItems.get(i);
            CBPanel panel = new CBPanel();
            panel.makeLight();
            this.tabPane.addTab(primary.toString(), panel);
            boolean newLine = false;
            for (int j = 0; j < primary.size(); ++j) {
                SecondaryOption secondary = primary.get(j);
                if (secondary.isLabel()) {
                    this.addSecondaryToPanel(panel, secondary, newLine);
                    newLine = false;
                    continue;
                }
                this.addSecondaryToPanel(panel, secondary, newLine);
                newLine = !newLine;
            }
            panel.newLine();
            panel.add(new JLabel("                     "));
            panel.makeHeavy();
            panel.addWide(new JLabel(" "), 5);
        }
        display.addLine(this.tabPane);
    }

    public void addCommonOptions(CBPanel display) {
        if (this.commonItems.size() == 0) {
            return;
        }
        this.commonOptions = new CBPanel();
        for (int i = 0; i < this.commonItems.size(); ++i) {
            SecondaryOption secondary = (SecondaryOption)this.commonItems.get(i);
            this.addSecondaryToPanel(this.commonOptions, secondary, i % 2 != 0);
        }
        this.commonOptions.newLine();
        this.commonOptions.add(new JLabel("                    "));
        this.commonOptions.makeHeavy();
        this.commonOptions.addWide(new JLabel(" "), 5);
        display.addLine(this.commonOptions);
    }

    void clearPasswords() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component c = this.tabPane.getComponent(i);
            this.clearPasswords(c);
        }
        this.clearPasswords(this.commonOptions);
    }

    void clearPasswords(Component c) {
        if (c instanceof Container) {
            Container con = (Container)c;
            for (int i = 0; i < con.getComponentCount(); ++i) {
                Component comp = con.getComponent(i);
                if (!(comp instanceof JPasswordField)) continue;
                ((JPasswordField)comp).setText("");
            }
        }
    }

    void addSecondaryToPanel(CBPanel panel, SecondaryOption secondary, boolean newLine) {
        if (secondary.isHidden()) {
            return;
        }
        JLabel comp1 = null;
        JComponent comp2 = null;
        CBFileChooserButton fileChooser = null;
        String defaultValue = secondary.getDefaultValue();
        if (secondary.isLabel()) {
            JLabel label = new JLabel(secondary.toString());
            Font current = label.getFont();
            label.setFont(new Font(current.getName(), 1, current.getSize() + 2));
            panel.addLine(label);
            newLine = true;
            return;
        }
        if (secondary.isPassword()) {
            comp1 = new JLabel(secondary.toString());
            panel.add(comp1);
            comp2 = new JPasswordField();
            panel.addGreedyWide(comp2, 2);
        } else if (secondary.isCheckBox()) {
            comp1 = new JLabel(secondary.toString());
            panel.add(comp1);
            comp2 = new JCheckBox();
            panel.add(comp2);
            if (!"".equals(defaultValue)) {
                ((JCheckBox)comp2).setSelected(true);
            }
            panel.add(new JLabel(""));
        } else if (secondary.isFile()) {
            comp1 = new JLabel(secondary.toString());
            panel.add(comp1);
            comp2 = new JTextField(defaultValue, 30);
            panel.addGreedyWide(comp2);
            fileChooser = new CBFileChooserButton((JTextComponent)comp2, this, "File");
            panel.add(fileChooser);
            if (defaultValue.length() > 0) {
                fileChooser.setLocalDirectoryUse(true);
                fileChooser.setStartingDirectory(defaultValue);
            }
        } else {
            comp1 = new JLabel(secondary.toString());
            panel.add(comp1);
            comp2 = new JTextField(defaultValue, 40);
            panel.addGreedyWide(comp2, 2);
        }
        if (comp1 != null) {
            comp1.setToolTipText(secondary.getTip());
        }
        if (newLine) {
            panel.newLine();
        }
    }

    void processFile(String fileName) {
        if (this.debug) {
            System.out.println("processing file '" + fileName + "'");
        }
        PrimaryOption currentItem = null;
        try {
            BufferedReader readText = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            String line = "";
            boolean count = false;
            while ((line = readText.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (this.commandName == null) {
                    if (this.debug) {
                        System.out.println("read commandName as '" + line + "'");
                    }
                    this.commandName = line;
                    continue;
                }
                if (line.toLowerCase().startsWith("primary: ")) {
                    line = line.substring(9).trim();
                    if (this.debug) {
                        System.out.println("read primary option as '" + line + "'");
                    }
                    currentItem = new PrimaryOption(line);
                    this.menuItems.add(currentItem);
                    continue;
                }
                if (line.toLowerCase().startsWith("common: ")) {
                    line = line.substring(8).trim();
                    if (this.debug) {
                        System.out.println("read common option as '" + line + "'");
                    }
                    SecondaryOption op = this.getSecondaryOption(line);
                    this.common.add(op);
                    this.commonItems.add(op);
                    continue;
                }
                if (line.toLowerCase().startsWith("secondary: ") && currentItem != null) {
                    line = line.substring(11).trim();
                    if (this.debug) {
                        System.out.println("read secondary option as '" + line + "'");
                    }
                    currentItem.add(this.getSecondaryOption(line));
                    continue;
                }
                this.error("WARNING: ignoring line '" + line + "'");
            }
        }
        catch (Exception e) {
            this.error("unable to open file:\n" + e.toString());
            e.printStackTrace();
        }
    }

    SecondaryOption getSecondaryOption(String line) {
        int pos = line.indexOf(32);
        if (pos < 0) {
            pos = line.length();
        }
        String name = line.substring(0, pos);
        boolean isPwd = false;
        boolean hasArg = true;
        boolean isLabel = false;
        boolean isHidden = false;
        boolean isFile = false;
        String tooltip = null;
        String defaultValue = null;
        if (line.charAt(0) == '\"') {
            isLabel = true;
            name = line.substring(1, line.length() - 1);
        } else if (pos != line.length()) {
            int pos2;
            String lowC = line.substring(pos).toLowerCase();
            if (lowC.indexOf("tip=") != -1) {
                pos = lowC.indexOf("tip=");
                pos2 = line.indexOf("\"", (pos = line.indexOf("\"", pos)) + 1);
                if (pos2 == -1) {
                    pos2 = line.length();
                }
                tooltip = line.substring(pos + 1, pos2);
                lowC = line.substring(0, pos).toLowerCase() + line.substring(pos2);
            }
            if (lowC.indexOf("default=") != -1) {
                pos = lowC.indexOf("default=");
                pos2 = line.indexOf("\"", (pos = line.indexOf("\"", pos)) + 1);
                if (pos2 == -1) {
                    pos2 = line.length();
                }
                defaultValue = line.substring(pos + 1, pos2);
                lowC = line.substring(0, pos).toLowerCase() + line.substring(pos2);
            }
            if (lowC.indexOf("nostring") != -1) {
                hasArg = false;
            }
            if (lowC.indexOf("ispassword") != -1) {
                isPwd = true;
            }
            if (lowC.indexOf("hidden") != -1) {
                isHidden = true;
            }
            if (lowC.indexOf("file") != -1) {
                isFile = true;
            }
        }
        return new SecondaryOption(name, isPwd, hasArg, isLabel, isHidden, isFile, tooltip, defaultValue);
    }

    public void error(String msg) {
        System.err.println(msg);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand().trim();
        if (cmd.equalsIgnoreCase("Execute")) {
            this.execute();
        } else if (cmd.equalsIgnoreCase("Cancel")) {
            this.cancel();
        } else if (cmd.equalsIgnoreCase("Help")) {
            this.help();
        } else {
            this.error("Unknown command in OpenConWin\n" + cmd);
        }
    }

    public void execute() {
        this.execute(2000);
    }

    public void execute(int millisecTimeout) {
        final int timeout = millisecTimeout;
        CBPanel current = (CBPanel)this.tabPane.getSelectedComponent();
        Vector<String> args = new Vector<String>();
        String title = this.tabPane.getTitleAt(this.tabPane.getSelectedIndex());
        PrimaryOption command = (PrimaryOption)CBAutoGUI.getNamedObject(this.menuItems, title);
        args.add(command.toCommandString());
        Component[] comps = current.getComponents();
        this.setArguments(args, comps, command);
        comps = this.commonOptions.getComponents();
        this.setArguments(args, comps, this.common);
        String commandString = this.commandName;
        if (commandString.startsWith("%JAVA%")) {
            commandString = System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + commandString.substring(6);
        }
        final String finalName = commandString + " " + command.toCommandString();
        for (int i = 0; i < args.size(); ++i) {
            commandString = commandString + " " + args.get(i).toString();
        }
        final String finalCommand = commandString;
        this.output.setText("running command:\n  " + finalName);
        final Thread worker = new Thread("Execute " + finalName){

            @Override
            public void run() {
                try {
                    Runtime runMe = Runtime.getRuntime();
                    Process goBoy = runMe.exec(finalCommand);
                    CBAutoGUI.this.output.read(goBoy.getInputStream(), (Object)"text");
                    CBAutoGUI.this.output.setText(CBAutoGUI.this.output.getText() + "\n\nCommand " + finalName + " Executed.\n");
                }
                catch (IOException e) {
                    CBAutoGUI.this.output.setText(CBAutoGUI.this.output.getText() + "\n\nIOException reading command Output\n" + e.toString());
                }
            }
        };
        Thread waiter = new Thread("Execute Watcher for " + finalCommand){

            @Override
            public void run() {
                block4: {
                    try {
                        Thread.currentThread();
                        Thread.sleep(timeout);
                        if (worker == null || !worker.isAlive()) break block4;
                        worker.interrupt();
                        try {
                            Thread.currentThread();
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        CBAutoGUI.this.output.setText(CBAutoGUI.this.output.getText() + "\n\nError - unable to complete command " + finalName + "\n   - request timed out in " + timeout + " milliseconds.\n");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        worker.start();
        waiter.start();
    }

    void setArguments(Vector args, Component[] comps, PrimaryOption command) {
        Component oldC = comps[0];
        for (int i = 1; i < comps.length; ++i) {
            Component newC = comps[i];
            if (oldC instanceof JLabel) {
                JComponent temp;
                String newArg = null;
                if (newC instanceof JPasswordField) {
                    String hack;
                    temp = (JPasswordField)newC;
                    char[] pass = ((JPasswordField)temp).getPassword();
                    if (pass.length > 0 && (hack = new String(pass)).trim().length() > 0) {
                        newArg = hack.trim();
                    }
                } else if (newC instanceof JTextField) {
                    temp = (JTextField)newC;
                    if (((JTextComponent)temp).getText().trim().length() > 0) {
                        newArg = ((JTextComponent)temp).getText().trim();
                    }
                } else if (newC instanceof JCheckBox && ((AbstractButton)(temp = (JCheckBox)newC)).isSelected()) {
                    newArg = "";
                }
                if (newArg != null) {
                    String secondaryOptionName = ((JLabel)oldC).getText().trim();
                    SecondaryOption opt = command.get(secondaryOptionName);
                    if (opt == null) {
                        this.error("Error - unknown option " + secondaryOptionName);
                    } else {
                        args.add(opt.toCommandString());
                        args.add(newArg);
                    }
                }
            }
            oldC = newC;
        }
        Vector hiddenOps = command.getHiddenOptions();
        for (int i = 0; i < hiddenOps.size(); ++i) {
            SecondaryOption opt = (SecondaryOption)hiddenOps.get(i);
            args.add(opt.toCommandString());
        }
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
        if (standAlone) {
            System.exit(0);
        }
    }

    public void help() {
    }

    public static String formatOptionName(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        return "  " + (name.charAt(0) == '-' ? name.substring(1) : name);
    }

    class SecondaryOption
    extends Option {
        boolean password;
        boolean label;
        boolean hasArgument;
        boolean hidden;
        boolean file;
        String defaultValue;

        public SecondaryOption(String optionString, boolean pwd, boolean arg, boolean lbl, boolean hide, boolean isFile, String tooltip, String defVal) {
            super(optionString);
            this.defaultValue = "";
            this.password = pwd;
            this.hasArgument = arg;
            this.label = lbl;
            this.hidden = hide;
            this.file = isFile;
            if (tooltip != null) {
                this.tip = tooltip;
            }
            if (defVal != null) {
                this.defaultValue = defVal;
            }
        }

        public void setDefaultValue(String s) {
            if (this.defaultValue != null) {
                this.defaultValue = s;
            }
        }

        public String getDefaultValue() {
            return this.defaultValue == null ? "" : this.defaultValue;
        }

        @Override
        public String toCommandString() {
            return this.name;
        }

        public boolean isPassword() {
            return this.password;
        }

        public boolean isLabel() {
            return this.label;
        }

        public boolean isCheckBox() {
            return !this.hasArgument;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isFile() {
            return this.file;
        }
    }

    class PrimaryOption
    extends Option {
        Vector options;

        public PrimaryOption(String optionName) {
            super(optionName);
            this.options = new Vector(8);
        }

        public void add(SecondaryOption option) {
            this.options.add(option);
        }

        public int size() {
            return this.options.size();
        }

        public SecondaryOption get(int i) {
            return (SecondaryOption)this.options.get(i);
        }

        public SecondaryOption get(String s) {
            SecondaryOption op = (SecondaryOption)CBAutoGUI.getNamedObject(this.options, s);
            if (op == null && s.charAt(0) != '-') {
                op = (SecondaryOption)CBAutoGUI.getNamedObject(this.options, "-" + s);
            }
            return op;
        }

        public Vector getHiddenOptions() {
            Vector<SecondaryOption> ret = new Vector<SecondaryOption>();
            for (int i = 0; i < this.options.size(); ++i) {
                SecondaryOption test = (SecondaryOption)this.options.get(i);
                if (!test.isHidden()) continue;
                ret.add(test);
            }
            return ret;
        }

        @Override
        public String toCommandString() {
            return this.name;
        }
    }

    abstract class Option {
        String name;
        String tip = "";

        public Option(String optionString) {
            this.name = optionString;
        }

        public String toCommandString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setTip(String t) {
            if (t != null) {
                this.tip = t;
            }
        }

        public String getTip() {
            return this.tip;
        }

        public String toString() {
            return CBAutoGUI.formatOptionName(this.name);
        }
    }
}

