/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer;

import com.ca.commons.cbutil.CBArray;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.DXOps;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.viewer.ChangeObjectClassWin;
import com.ca.directory.jxplorer.viewer.PluggableEditor;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeNameAndType;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeTableModel;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeTypeCellRenderer;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValueCellEditor;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValueCellRenderer;
import com.ca.directory.jxplorer.viewer.tableviewer.SmartPopupTableTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;

public class TableAttributeEditor
extends JPanel
implements DataSink,
PluggableEditor {
    private static Logger log = Logger.getLogger(TableAttributeEditor.class.getName());
    JTable attributeTable;
    AttributeTableModel tableData;
    JScrollPane tableScroller;
    CBButton submit;
    CBButton reset;
    CBButton changeClass;
    CBButton opAttrs;
    JFrame owner;
    JDialog virtualEntryDialog = null;
    boolean virtualEntry = false;
    DXEntry currentEntry = null;
    DXEntry originalEntry = null;
    DN currentDN = null;
    DN entryWithPendingChanges = null;
    public DataBrokerQueryInterface dataSource;
    DXEntry classChangedOriginalEntry = null;
    SmartPopupTableTool popupTableTool;
    ClassLoader myLoader;
    final AttributeValueCellEditor myEditor;
    public String title = CBIntText.get("Table Editor");
    private boolean showingOperationalAttributes = false;

    public TableAttributeEditor(JFrame MyOwner) {
        this.owner = MyOwner;
        this.tableData = new AttributeTableModel();
        this.attributeTable = new JTable(this.tableData);
        this.popupTableTool = new SmartPopupTableTool(this.attributeTable, this.tableData, (JXplorerBrowser)this.owner);
        AttributeTypeCellRenderer typeRenderer = new AttributeTypeCellRenderer();
        this.attributeTable.setDefaultRenderer(AttributeNameAndType.class, typeRenderer);
        AttributeValueCellRenderer valueRenderer = new AttributeValueCellRenderer();
        this.attributeTable.setDefaultRenderer(AttributeValue.class, valueRenderer);
        this.myEditor = new AttributeValueCellEditor(this.owner);
        this.attributeTable.setDefaultEditor(AttributeValue.class, this.myEditor);
        this.attributeTable.getTableHeader().setReorderingAllowed(false);
        this.currentDN = null;
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.submit = new CBButton(CBIntText.get("Submit"), CBIntText.get("Submit your changes to the Directory."));
        buttonPanel.add(this.submit);
        this.reset = new CBButton(CBIntText.get("Reset"), CBIntText.get("Reset this entry i.e. cancels any changes."));
        buttonPanel.add(this.reset);
        this.changeClass = new CBButton(CBIntText.get("Change Classes"), CBIntText.get("Change the Object Class of this entry."));
        buttonPanel.add(this.changeClass);
        this.opAttrs = new CBButton(CBIntText.get("Properties"), CBIntText.get("View the Operational Attributes of this entry."));
        buttonPanel.add(this.opAttrs);
        this.opAttrs.setDefaultCapable(false);
        this.submit.setDefaultCapable(false);
        this.reset.setDefaultCapable(false);
        this.changeClass.setDefaultCapable(false);
        this.setLayout(new BorderLayout(10, 10));
        this.tableScroller = new JScrollPane();
        this.attributeTable.setBackground(Color.white);
        this.tableScroller.setPreferredSize(new Dimension(300, 285));
        this.tableScroller.setViewportView(this.attributeTable);
        this.add((Component)this.tableScroller, "Center");
        this.add((Component)buttonPanel, "South");
        this.title = "true".equals(JXConfig.getProperty("lock.read.only")) ? CBIntText.get("Table Viewer") : CBIntText.get("Table Editor");
        this.setVisible(true);
        this.opAttrs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableAttributeEditor.this.displayOperationalAttributes();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableAttributeEditor.this.myEditor.stopCellEditing();
                TableAttributeEditor.this.displayEntry(TableAttributeEditor.this.originalEntry, TableAttributeEditor.this.dataSource, false);
            }
        });
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableAttributeEditor.this.doSubmit();
            }
        });
        this.changeClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableAttributeEditor.this.changeClass();
            }
        });
        this.attributeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!this.doPopupStuff(e)) {
                    super.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.doPopupStuff(e)) {
                    super.mouseReleased(e);
                }
            }

            public boolean doPopupStuff(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return false;
                }
                int row = TableAttributeEditor.this.attributeTable.rowAtPoint(new Point(e.getX(), e.getY()));
                TableAttributeEditor.this.attributeTable.clearSelection();
                TableAttributeEditor.this.attributeTable.addRowSelectionInterval(row, row);
                TableAttributeEditor.this.attributeTable.repaint();
                TableAttributeEditor.this.popupTableTool.registerCurrentRow((AttributeNameAndType)TableAttributeEditor.this.attributeTable.getValueAt(row, 0), (AttributeValue)TableAttributeEditor.this.attributeTable.getValueAt(row, 1), row, TableAttributeEditor.this.tableData.getRDN());
                TableAttributeEditor.this.popupTableTool.show(TableAttributeEditor.this.attributeTable, e.getX(), e.getY());
                TableAttributeEditor.this.popupTableTool.registerCellEditor(TableAttributeEditor.this.myEditor);
                return true;
            }
        });
    }

    public void changeClass() {
        DXEntry newEntry;
        DN newDN;
        this.myEditor.stopCellEditing();
        if (this.virtualEntry) {
            this.doVirtualEntryDisplay();
            return;
        }
        if (this.classChangedOriginalEntry == null) {
            this.classChangedOriginalEntry = this.tableData.getOldEntry();
        }
        if (!(newDN = (newEntry = this.tableData.getNewEntry()).getDN()).equals(this.classChangedOriginalEntry.getDN())) {
            this.checkForUnsavedChanges();
            this.classChangedOriginalEntry = this.tableData.getNewEntry();
        }
        if (this.dataSource.getSchemaOps() == null) {
            JOptionPane.showMessageDialog(this.owner, CBIntText.get("Because there is no schema currently published by the\ndirectory, changing an entry's object class is unavailable."), CBIntText.get("No Schema"), 1);
            return;
        }
        ChangeObjectClassWin userData = new ChangeObjectClassWin(this.dataSource, newDN, newEntry.getAsNonNullAttributes(), this, CBUtility.getParentFrame(this), false);
        userData.setSize(400, 250);
        CBUtility.center(userData, this.owner);
        userData.setVisible(true);
    }

    public void doSubmit() {
        if (this.dataSource == null) {
            CBUtility.error("No dataSource available to write changes to in Table Attribute Editor");
            return;
        }
        this.myEditor.stopCellEditing();
        if ("false".equalsIgnoreCase(JXConfig.getProperty("option.ignoreSchemaOnSubmission")) && !this.tableData.checkMandatoryAttributesSet()) {
            CBUtility.error(this, CBIntText.get("All Mandatory Attributes must have values!"), null);
            return;
        }
        this.writeTableData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOperationalAttributes() {
        JXplorerBrowser jx = null;
        if (!(this.owner instanceof JXplorerBrowser)) {
            return;
        }
        jx = (JXplorerBrowser)this.owner;
        this.showingOperationalAttributes = !this.showingOperationalAttributes;
        String[] opAttrs = new String[]{"+", "createTimeStamp", "creatorsName", "entryFlags", "federationBoundary", "localEntryID", "modifiersName", "modifyTimeStamp", "structuralObjectClass", "subordinateCount", "subschemaSubentry"};
        DXEntry entry = null;
        if (this.showingOperationalAttributes) {
            try {
                entry = jx.getSearchBroker().unthreadedReadEntry(this.currentDN, opAttrs);
                StringBuffer buffy = new StringBuffer("DN: " + this.currentDN.toString() + "\n\n");
                NamingEnumeration ne = null;
                try {
                    ne = entry.getAll();
                    while (ne.hasMore()) {
                        DXAttribute att = (DXAttribute)ne.next();
                        buffy.append(att.getName() + ": " + att.get().toString() + "\n");
                        this.tableData.insertOperationalAttribute(att);
                    }
                }
                finally {
                    if (ne != null) {
                        ne.close();
                    }
                }
                this.tableData.fireTableDataChanged();
            }
            catch (NamingException e) {
                CBUtility.error(this, CBIntText.get("Unable to read entry " + this.currentDN), (Exception)e);
            }
        } else {
            this.tableData.removeOperationalAttributes();
            this.tableData.fireTableDataChanged();
        }
    }

    public void doVirtualEntryDisplay() {
        this.virtualEntryDialog = new JDialog(this.owner, CBIntText.get("Virtual Entry"), true);
        CBButton btnYes = new CBButton(CBIntText.get("Yes"), CBIntText.get("Click yes to make a Virtual Entry."));
        CBButton btnNo = new CBButton(CBIntText.get("No"), CBIntText.get("Click no to cancel without making a Virtual Entry."));
        Container pane = this.virtualEntryDialog.getContentPane();
        pane.setLayout(new BorderLayout());
        CBPanel panel1 = new CBPanel();
        CBPanel panel2 = new CBPanel();
        CBPanel panel3 = new CBPanel();
        panel1.add(new JLabel(CBIntText.get("This entry is a Virtual Entry.  Are you sure you want to give this entry an object class?")));
        panel2.add(btnYes);
        panel2.add(btnNo);
        panel3.makeWide();
        panel3.addln(panel1);
        panel3.addln(panel2);
        pane.add(panel3);
        btnYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableAttributeEditor.this.processVirtualEntry();
            }
        });
        btnNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableAttributeEditor.this.shutVirtualEntryDialog();
            }
        });
        this.virtualEntryDialog.setSize(475, 125);
        CBUtility.center(this.virtualEntryDialog, this.owner);
        this.virtualEntryDialog.setVisible(true);
    }

    public void processVirtualEntry() {
        ChangeObjectClassWin userData = null;
        if (this.dataSource.getSchemaOps() == null) {
            JOptionPane.showMessageDialog(this.owner, CBIntText.get("Because there is no schema currently published by the\ndirectory, changing an entry's object class is unavailable."), CBIntText.get("No Schema"), 1);
            return;
        }
        this.shutVirtualEntryDialog();
        userData = new ChangeObjectClassWin(this.dataSource, this.currentEntry.getDN(), null, this, this.owner, true);
        userData.setSize(400, 250);
        CBUtility.center(userData, this.owner);
        userData.setVisible(true);
        while (userData.isVisible()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                userData.dispose();
            }
        }
        if (userData.newObjectClasses != null) {
            try {
                DXOps dxOps = new DXOps(this.dataSource.getLdapContext());
                dxOps.addAttribute(this.currentEntry.getDN(), (Attribute)userData.newObjectClasses);
                this.dataSource.getEntry(this.currentEntry.getDN());
            }
            catch (NamingException e) {
                CBUtility.error(this, CBIntText.get("Unable to add new object classes to {0}.", new String[]{this.currentEntry.getDN().toString()}), (Exception)e);
            }
        }
    }

    public void shutVirtualEntryDialog() {
        if (this.virtualEntryDialog != null) {
            this.virtualEntryDialog.setVisible(false);
            this.virtualEntryDialog.dispose();
        }
    }

    @Override
    public void displayEntry(DXEntry entry, DataBrokerQueryInterface ds) {
        this.displayEntry(entry, ds, true);
    }

    private void displayEntry(DXEntry entry, DataBrokerQueryInterface ds, boolean storeOriginalEntry) {
        this.myEditor.stopCellEditing();
        if (entry != null && storeOriginalEntry && entry.getStatus() == 0) {
            this.originalEntry = new DXEntry(entry);
        }
        this.currentEntry = entry;
        this.dataSource = ds;
        if (entry != null && entry.size() == 0) {
            this.tableData.clear();
            this.submit.setEnabled(false);
            this.reset.setEnabled(false);
            this.changeClass.setText(CBIntText.get("Add Class"));
            this.changeClass.setEnabled(true);
            this.opAttrs.setEnabled(false);
            this.virtualEntry = true;
            return;
        }
        this.virtualEntry = false;
        if (entry != null) {
            this.currentDN = entry.getDN();
        }
        this.changeClass.setText(CBIntText.get("Change Class"));
        if (!(this.classChangedOriginalEntry == null || entry != null && entry.getDN().equals(this.classChangedOriginalEntry.getDN()))) {
            this.classChangedOriginalEntry = null;
        }
        if (this.tableData.changedByUser()) {
            boolean prompt = false;
            DXEntry oldEntry = this.tableData.getOldEntry();
            if (oldEntry != null) {
                if (entry == null) {
                    prompt = true;
                } else if (!oldEntry.getDN().isEmpty() && !entry.getDN().equals(oldEntry.getDN())) {
                    DN newParent;
                    DN oldParent = oldEntry.getDN().getParent();
                    if (!oldParent.equals(newParent = entry.getDN().getParent())) {
                        prompt = true;
                    } else if (!entry.getDN().getLowestRDN().equals(this.tableData.getRDN())) {
                        prompt = true;
                    }
                }
                if (prompt) {
                    this.checkForUnsavedChanges();
                }
            }
        }
        this.myEditor.setDataSource(ds);
        if (this.dataSource == null || entry == null || !this.dataSource.isModifiable()) {
            this.setReadWrite(false, entry);
        } else {
            this.setReadWrite(true, entry);
        }
        if (entry != null) {
            entry.expandAllAttributes();
            this.currentDN = entry.getDN();
            this.tableData.insertAttributes(entry);
            this.popupTableTool.setDN(this.currentDN);
            this.myEditor.setDN(this.currentDN);
        } else {
            this.tableData.clear();
        }
        this.tableScroller.getVerticalScrollBar().setValue(0);
    }

    protected void setReadWrite(boolean writeable, DXEntry entry) {
        this.submit.setEnabled(writeable);
        this.reset.setEnabled(writeable);
        this.changeClass.setEnabled(writeable);
        this.opAttrs.setEnabled(writeable);
        this.myEditor.setEnabled(writeable);
        this.popupTableTool.setReadWrite(writeable);
        if (entry != null && entry.get("objectclass") != null) {
            this.changeClass.setEnabled(true);
        }
    }

    @Override
    public JComponent getDisplayComponent() {
        this.validate();
        this.repaint();
        return this;
    }

    public String[] getAttributeValuesAsStringArray(Attribute a) throws NamingException {
        if (a == null) {
            return new String[0];
        }
        DXNamingEnumeration e = new DXNamingEnumeration(a.getAll());
        if (e == null) {
            return new String[0];
        }
        return e.toStringArray();
    }

    public boolean objectClassesChanged(DXAttributes a, DXAttributes b) {
        boolean result = false;
        try {
            Object[] A = this.getAttributeValuesAsStringArray(a.getAllObjectClasses());
            Object[] B = this.getAttributeValuesAsStringArray(b.getAllObjectClasses());
            Object[] test = CBArray.difference(A, B);
            if (test.length > 0) {
                result = true;
            }
            if ((test = CBArray.difference(B, A)).length > 0) {
                result = true;
            }
            return result;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Error in TableAttributeEditor:objectClassesChanged ", e);
            return true;
        }
    }

    public void writeTableData() {
        this.myEditor.stopCellEditing();
        if (this.dataSource == null) {
            CBUtility.error("no datasource to write data to in writeTableData()");
            return;
        }
        DXEntry oldEntry = this.tableData.getOldEntry();
        DXEntry newEntry = this.tableData.getNewEntry();
        if (this.classChangedOriginalEntry != null) {
            oldEntry = this.classChangedOriginalEntry;
            this.classChangedOriginalEntry = null;
            if (this.objectClassesChanged(oldEntry, newEntry)) {
                oldEntry.removeEmptyAttributes();
                newEntry.setStatus(oldEntry.getStatus());
                Object[] delSet = CBArray.difference(oldEntry.toIDStringArray(), newEntry.toIDStringArray());
                if (delSet != null && delSet.length > 0) {
                    for (int i = 0; i < delSet.length; ++i) {
                        newEntry.put(new DXAttribute(delSet[i].toString()));
                    }
                }
            }
        }
        this.dataSource.modifyEntry(oldEntry, newEntry);
    }

    @Override
    public Component getPrintComponent() {
        return this.attributeTable;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public void setName(String title) {
        this.title = title;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(Theme.getInstance().getDirImages() + "table.gif");
    }

    @Override
    public String getToolTip() {
        return CBIntText.get("The table editor is generally used for editing data, it also functions perfectly well as a simple, but robust, entry viewer.");
    }

    @Override
    public DataSink getDataSink() {
        return this;
    }

    @Override
    public boolean canCreateEntry() {
        return true;
    }

    @Override
    public void registerComponents(JMenuBar menu, JToolBar buttons, JTree tree, JPopupMenu treeMenu, JFrame jx) {
    }

    @Override
    public void unload() {
    }

    @Override
    public ImageIcon getTreeIcon(String rdn) {
        return null;
    }

    @Override
    public JPopupMenu getPopupMenu(String rdn) {
        return null;
    }

    @Override
    public boolean hideSubEntries(String rdn) {
        return false;
    }

    public void registerClassLoader(ClassLoader loader) {
        this.myLoader = loader;
        this.myEditor.registerClassLoader(loader);
    }

    @Override
    public void setVisible(boolean state) {
        super.setVisible(state);
        if (!state && this.tableData.changedByUser()) {
            this.checkForUnsavedChanges();
        }
    }

    @Override
    public void checkForUnsavedChanges() {
        if (this.dataSource == null || !this.dataSource.isActive()) {
            return;
        }
        if (this.tableData.changedByUser()) {
            String save = CBIntText.get("Save");
            String discard = CBIntText.get("Discard");
            int result = JOptionPane.showOptionDialog(this.owner, CBIntText.get("Submit changes to the Directory?"), CBIntText.get("Save Data"), -1, 3, null, new Object[]{save, discard}, save);
            if (result == 0) {
                this.writeTableData();
            }
        }
    }
}

