from base64 import b64decode
import os

WHEEL_DATA = """
UEsDBBQAAAAIAJqbSk0AAAAAAgAAAAAAAAATAAAAcHJvamVjdC9fX2luaXRfXy5weQMAUEsDBBQAAAAI
AMCcSk2nQ1nDbAAAAKkAAAAeAAAAcHJvamVjdC0wLjEuZGlzdC1pbmZvL01FVEFEQVRB800tSUxJLEnU
DUstKs7Mz7NSMNIz5PJLzE21Uigoys9KTS7hgksZAKWCS3NzE4sqrRRC/bz9/MP9uDzyc1N1CxLTUxFC
jqUlGflF6Hzd1NzEzByEqE9mcmpeMZK2gJzEkrT8olyECBecwQUAUEsDBBQAAAAIAMCcSk0tTdW3ZAAA
AHQAAAAbAAAAcHJvamVjdC0wLjEuZGlzdC1pbmZvL1dIRUVMC89ITc3RDUstKs7Mz7NSMNQz4OVyT81L
LUosyS+yUkhKySwuiS8HKVLQMNAzNtIz1OTlCsrPL9H1LNYNKC1KzclMslIoKSpN5eUKSUy3UiioNNLN
y89L1U3Mq4QLGSMJ8XIBAFBLAwQUAAAACADAnEpNPHpKdQoAAAAIAAAAIwAAAHByb2plY3QtMC4xLmRp
c3QtaW5mby90b3BfbGV2ZWwudHh0KyjKz0pNLuECAFBLAwQUAAAACADAnEpNsHuO+vsAAABqAQAAHAAA
AHByb2plY3QtMC4xLmRpc3QtaW5mby9SRUNPUkR1zLt2gjAAANDdbwloKC+HDhhQCygEaQMsOWqDIK9U
Alq/vkMPo/cDLr91V3YWc0rLthSUyvwX9MVR0fR31bAdzK/mdnU4SjT+aIikuYgNmEVVo+133CXZ5q04
DOtPsJjx/0hayFD+LnshlW3ezXdObNlWbE1nk5AwX4vA7HVtt3m4I+MjkvzwpH2NT/MWpdFgXCKSxTcM
oL58sZKt4/hTiUOHQkiN+xCwHNter61qM6hUhBORPipke/UQerraKmcAof6iFB2nNRtZLYuHmOq4Xiun
Nvm5Bq7nr477pQRLFSXWpb7HTQYL1VAHG3fpk6TAfBFHDgoiG4DZH1BLAQIUABQAAAAIAJqbSk0AAAAA
AgAAAAAAAAATAAAAAAAAAAAAAAC2gQAAAABwcm9qZWN0L19faW5pdF9fLnB5UEsBAhQAFAAAAAgAwJxK
TadDWcNsAAAAqQAAAB4AAAAAAAAAAAAAALaBMwAAAHByb2plY3QtMC4xLmRpc3QtaW5mby9NRVRBREFU
QVBLAQIUABQAAAAIAMCcSk0tTdW3ZAAAAHQAAAAbAAAAAAAAAAAAAAC2gdsAAABwcm9qZWN0LTAuMS5k
aXN0LWluZm8vV0hFRUxQSwECFAAUAAAACADAnEpNPHpKdQoAAAAIAAAAIwAAAAAAAAAAAAAAtoF4AQAA
cHJvamVjdC0wLjEuZGlzdC1pbmZvL3RvcF9sZXZlbC50eHRQSwECFAAUAAAACADAnEpNsHuO+vsAAABq
AQAAHAAAAAAAAAAAAAAAtAHDAQAAcHJvamVjdC0wLjEuZGlzdC1pbmZvL1JFQ09SRFBLBQYAAAAABQAF
AHEBAAD4AgAAAAA=
"""

def reqs():
    reqfile = "backend_reqs.txt"
    if not os.path.exists(reqfile):
        return
    with open(reqfile, "r") as f:
        for line in f:
            line = line.strip()
            if line and not line.startswith('#'):
                yield line

def build_wheel(
    wheel_directory,
    config_settings=None,
    metadata_directory=None
):
    # Check all requirements are present
    for r in reqs():
        __import__(r)

    name = "project-0.1-py3-none-any.whl"
    path = os.path.join(wheel_directory, name)
    with open(path, "wb") as f:
        f.write(b64decode(WHEEL_DATA))
    return "project-0.1-py3-none-any.whl"

def get_requires_for_build_wheel(config_settings=None):
        return list(reqs())
