// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/clouddebugger/v2/data.proto

package clouddebugger // import "google.golang.org/genproto/googleapis/devtools/clouddebugger/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import v1 "google.golang.org/genproto/googleapis/devtools/source/v1"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Enumerates references to which the message applies.
type StatusMessage_Reference int32

const (
	// Status doesn't refer to any particular input.
	StatusMessage_UNSPECIFIED StatusMessage_Reference = 0
	// Status applies to the breakpoint and is related to its location.
	StatusMessage_BREAKPOINT_SOURCE_LOCATION StatusMessage_Reference = 3
	// Status applies to the breakpoint and is related to its condition.
	StatusMessage_BREAKPOINT_CONDITION StatusMessage_Reference = 4
	// Status applies to the breakpoint and is related to its expressions.
	StatusMessage_BREAKPOINT_EXPRESSION StatusMessage_Reference = 7
	// Status applies to the breakpoint and is related to its age.
	StatusMessage_BREAKPOINT_AGE StatusMessage_Reference = 8
	// Status applies to the entire variable.
	StatusMessage_VARIABLE_NAME StatusMessage_Reference = 5
	// Status applies to variable value (variable name is valid).
	StatusMessage_VARIABLE_VALUE StatusMessage_Reference = 6
)

var StatusMessage_Reference_name = map[int32]string{
	0: "UNSPECIFIED",
	3: "BREAKPOINT_SOURCE_LOCATION",
	4: "BREAKPOINT_CONDITION",
	7: "BREAKPOINT_EXPRESSION",
	8: "BREAKPOINT_AGE",
	5: "VARIABLE_NAME",
	6: "VARIABLE_VALUE",
}
var StatusMessage_Reference_value = map[string]int32{
	"UNSPECIFIED":                0,
	"BREAKPOINT_SOURCE_LOCATION": 3,
	"BREAKPOINT_CONDITION":       4,
	"BREAKPOINT_EXPRESSION":      7,
	"BREAKPOINT_AGE":             8,
	"VARIABLE_NAME":              5,
	"VARIABLE_VALUE":             6,
}

func (x StatusMessage_Reference) String() string {
	return proto.EnumName(StatusMessage_Reference_name, int32(x))
}
func (StatusMessage_Reference) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{1, 0}
}

// Actions that can be taken when a breakpoint hits.
// Agents should reject breakpoints with unsupported or unknown action values.
type Breakpoint_Action int32

const (
	// Capture stack frame and variables and update the breakpoint.
	// The data is only captured once. After that the breakpoint is set
	// in a final state.
	Breakpoint_CAPTURE Breakpoint_Action = 0
	// Log each breakpoint hit. The breakpoint remains active until
	// deleted or expired.
	Breakpoint_LOG Breakpoint_Action = 1
)

var Breakpoint_Action_name = map[int32]string{
	0: "CAPTURE",
	1: "LOG",
}
var Breakpoint_Action_value = map[string]int32{
	"CAPTURE": 0,
	"LOG":     1,
}

func (x Breakpoint_Action) String() string {
	return proto.EnumName(Breakpoint_Action_name, int32(x))
}
func (Breakpoint_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{5, 0}
}

// Log severity levels.
type Breakpoint_LogLevel int32

const (
	// Information log message.
	Breakpoint_INFO Breakpoint_LogLevel = 0
	// Warning log message.
	Breakpoint_WARNING Breakpoint_LogLevel = 1
	// Error log message.
	Breakpoint_ERROR Breakpoint_LogLevel = 2
)

var Breakpoint_LogLevel_name = map[int32]string{
	0: "INFO",
	1: "WARNING",
	2: "ERROR",
}
var Breakpoint_LogLevel_value = map[string]int32{
	"INFO":    0,
	"WARNING": 1,
	"ERROR":   2,
}

func (x Breakpoint_LogLevel) String() string {
	return proto.EnumName(Breakpoint_LogLevel_name, int32(x))
}
func (Breakpoint_LogLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{5, 1}
}

// Represents a message with parameters.
type FormatMessage struct {
	// Format template for the message. The `format` uses placeholders `$0`,
	// `$1`, etc. to reference parameters. `$$` can be used to denote the `$`
	// character.
	//
	// Examples:
	//
	// *   `Failed to load '$0' which helps debug $1 the first time it
	//     is loaded.  Again, $0 is very important.`
	// *   `Please pay $$10 to use $0 instead of $1.`
	Format string `protobuf:"bytes,1,opt,name=format,proto3" json:"format,omitempty"`
	// Optional parameters to be embedded into the message.
	Parameters           []string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FormatMessage) Reset()         { *m = FormatMessage{} }
func (m *FormatMessage) String() string { return proto.CompactTextString(m) }
func (*FormatMessage) ProtoMessage()    {}
func (*FormatMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{0}
}
func (m *FormatMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FormatMessage.Unmarshal(m, b)
}
func (m *FormatMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FormatMessage.Marshal(b, m, deterministic)
}
func (dst *FormatMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FormatMessage.Merge(dst, src)
}
func (m *FormatMessage) XXX_Size() int {
	return xxx_messageInfo_FormatMessage.Size(m)
}
func (m *FormatMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_FormatMessage.DiscardUnknown(m)
}

var xxx_messageInfo_FormatMessage proto.InternalMessageInfo

func (m *FormatMessage) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *FormatMessage) GetParameters() []string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// Represents a contextual status message.
// The message can indicate an error or informational status, and refer to
// specific parts of the containing object.
// For example, the `Breakpoint.status` field can indicate an error referring
// to the `BREAKPOINT_SOURCE_LOCATION` with the message `Location not found`.
type StatusMessage struct {
	// Distinguishes errors from informational messages.
	IsError bool `protobuf:"varint,1,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	// Reference to which the message applies.
	RefersTo StatusMessage_Reference `protobuf:"varint,2,opt,name=refers_to,json=refersTo,proto3,enum=google.devtools.clouddebugger.v2.StatusMessage_Reference" json:"refers_to,omitempty"`
	// Status message text.
	Description          *FormatMessage `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StatusMessage) Reset()         { *m = StatusMessage{} }
func (m *StatusMessage) String() string { return proto.CompactTextString(m) }
func (*StatusMessage) ProtoMessage()    {}
func (*StatusMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{1}
}
func (m *StatusMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusMessage.Unmarshal(m, b)
}
func (m *StatusMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusMessage.Marshal(b, m, deterministic)
}
func (dst *StatusMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusMessage.Merge(dst, src)
}
func (m *StatusMessage) XXX_Size() int {
	return xxx_messageInfo_StatusMessage.Size(m)
}
func (m *StatusMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusMessage.DiscardUnknown(m)
}

var xxx_messageInfo_StatusMessage proto.InternalMessageInfo

func (m *StatusMessage) GetIsError() bool {
	if m != nil {
		return m.IsError
	}
	return false
}

func (m *StatusMessage) GetRefersTo() StatusMessage_Reference {
	if m != nil {
		return m.RefersTo
	}
	return StatusMessage_UNSPECIFIED
}

func (m *StatusMessage) GetDescription() *FormatMessage {
	if m != nil {
		return m.Description
	}
	return nil
}

// Represents a location in the source code.
type SourceLocation struct {
	// Path to the source file within the source context of the target binary.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Line inside the file. The first line in the file has the value `1`.
	Line int32 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	// Column within a line. The first column in a line as the value `1`.
	// Agents that do not support setting breakpoints on specific columns ignore
	// this field.
	Column               int32    `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SourceLocation) Reset()         { *m = SourceLocation{} }
func (m *SourceLocation) String() string { return proto.CompactTextString(m) }
func (*SourceLocation) ProtoMessage()    {}
func (*SourceLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{2}
}
func (m *SourceLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceLocation.Unmarshal(m, b)
}
func (m *SourceLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceLocation.Marshal(b, m, deterministic)
}
func (dst *SourceLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceLocation.Merge(dst, src)
}
func (m *SourceLocation) XXX_Size() int {
	return xxx_messageInfo_SourceLocation.Size(m)
}
func (m *SourceLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceLocation.DiscardUnknown(m)
}

var xxx_messageInfo_SourceLocation proto.InternalMessageInfo

func (m *SourceLocation) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *SourceLocation) GetLine() int32 {
	if m != nil {
		return m.Line
	}
	return 0
}

func (m *SourceLocation) GetColumn() int32 {
	if m != nil {
		return m.Column
	}
	return 0
}

// Represents a variable or an argument possibly of a compound object type.
// Note how the following variables are represented:
//
// 1) A simple variable:
//
//     int x = 5
//
//     { name: "x", value: "5", type: "int" }  // Captured variable
//
// 2) A compound object:
//
//     struct T {
//         int m1;
//         int m2;
//     };
//     T x = { 3, 7 };
//
//     {  // Captured variable
//         name: "x",
//         type: "T",
//         members { name: "m1", value: "3", type: "int" },
//         members { name: "m2", value: "7", type: "int" }
//     }
//
// 3) A pointer where the pointee was captured:
//
//     T x = { 3, 7 };
//     T* p = &x;
//
//     {   // Captured variable
//         name: "p",
//         type: "T*",
//         value: "0x00500500",
//         members { name: "m1", value: "3", type: "int" },
//         members { name: "m2", value: "7", type: "int" }
//     }
//
// 4) A pointer where the pointee was not captured:
//
//     T* p = new T;
//
//     {   // Captured variable
//         name: "p",
//         type: "T*",
//         value: "0x00400400"
//         status { is_error: true, description { format: "unavailable" } }
//     }
//
// The status should describe the reason for the missing value,
// such as `<optimized out>`, `<inaccessible>`, `<pointers limit reached>`.
//
// Note that a null pointer should not have members.
//
// 5) An unnamed value:
//
//     int* p = new int(7);
//
//     {   // Captured variable
//         name: "p",
//         value: "0x00500500",
//         type: "int*",
//         members { value: "7", type: "int" } }
//
// 6) An unnamed pointer where the pointee was not captured:
//
//     int* p = new int(7);
//     int** pp = &p;
//
//     {  // Captured variable
//         name: "pp",
//         value: "0x00500500",
//         type: "int**",
//         members {
//             value: "0x00400400",
//             type: "int*"
//             status {
//                 is_error: true,
//                 description: { format: "unavailable" } }
//             }
//         }
//     }
//
// To optimize computation, memory and network traffic, variables that
// repeat in the output multiple times can be stored once in a shared
// variable table and be referenced using the `var_table_index` field.  The
// variables stored in the shared table are nameless and are essentially
// a partition of the complete variable. To reconstruct the complete
// variable, merge the referencing variable with the referenced variable.
//
// When using the shared variable table, the following variables:
//
//     T x = { 3, 7 };
//     T* p = &x;
//     T& r = x;
//
//     { name: "x", var_table_index: 3, type: "T" }  // Captured variables
//     { name: "p", value "0x00500500", type="T*", var_table_index: 3 }
//     { name: "r", type="T&", var_table_index: 3 }
//
//     {  // Shared variable table entry #3:
//         members { name: "m1", value: "3", type: "int" },
//         members { name: "m2", value: "7", type: "int" }
//     }
//
// Note that the pointer address is stored with the referencing variable
// and not with the referenced variable. This allows the referenced variable
// to be shared between pointers and references.
//
// The type field is optional. The debugger agent may or may not support it.
type Variable struct {
	// Name of the variable, if any.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Simple value of the variable.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Variable type (e.g. `MyClass`). If the variable is split with
	// `var_table_index`, `type` goes next to `value`. The interpretation of
	// a type is agent specific. It is recommended to include the dynamic type
	// rather than a static type of an object.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// Members contained or pointed to by the variable.
	Members []*Variable `protobuf:"bytes,3,rep,name=members,proto3" json:"members,omitempty"`
	// Reference to a variable in the shared variable table. More than
	// one variable can reference the same variable in the table. The
	// `var_table_index` field is an index into `variable_table` in Breakpoint.
	VarTableIndex *wrappers.Int32Value `protobuf:"bytes,4,opt,name=var_table_index,json=varTableIndex,proto3" json:"var_table_index,omitempty"`
	// Status associated with the variable. This field will usually stay
	// unset. A status of a single variable only applies to that variable or
	// expression. The rest of breakpoint data still remains valid. Variables
	// might be reported in error state even when breakpoint is not in final
	// state.
	//
	// The message may refer to variable name with `refers_to` set to
	// `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
	// In either case variable value and members will be unset.
	//
	// Example of error message applied to name: `Invalid expression syntax`.
	//
	// Example of information message applied to value: `Not captured`.
	//
	// Examples of error message applied to value:
	//
	// *   `Malformed string`,
	// *   `Field f not found in class C`
	// *   `Null pointer dereference`
	Status               *StatusMessage `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Variable) Reset()         { *m = Variable{} }
func (m *Variable) String() string { return proto.CompactTextString(m) }
func (*Variable) ProtoMessage()    {}
func (*Variable) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{3}
}
func (m *Variable) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Variable.Unmarshal(m, b)
}
func (m *Variable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Variable.Marshal(b, m, deterministic)
}
func (dst *Variable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Variable.Merge(dst, src)
}
func (m *Variable) XXX_Size() int {
	return xxx_messageInfo_Variable.Size(m)
}
func (m *Variable) XXX_DiscardUnknown() {
	xxx_messageInfo_Variable.DiscardUnknown(m)
}

var xxx_messageInfo_Variable proto.InternalMessageInfo

func (m *Variable) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Variable) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Variable) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Variable) GetMembers() []*Variable {
	if m != nil {
		return m.Members
	}
	return nil
}

func (m *Variable) GetVarTableIndex() *wrappers.Int32Value {
	if m != nil {
		return m.VarTableIndex
	}
	return nil
}

func (m *Variable) GetStatus() *StatusMessage {
	if m != nil {
		return m.Status
	}
	return nil
}

// Represents a stack frame context.
type StackFrame struct {
	// Demangled function name at the call site.
	Function string `protobuf:"bytes,1,opt,name=function,proto3" json:"function,omitempty"`
	// Source location of the call site.
	Location *SourceLocation `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Set of arguments passed to this function.
	// Note that this might not be populated for all stack frames.
	Arguments []*Variable `protobuf:"bytes,3,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// Set of local variables at the stack frame location.
	// Note that this might not be populated for all stack frames.
	Locals               []*Variable `protobuf:"bytes,4,rep,name=locals,proto3" json:"locals,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StackFrame) Reset()         { *m = StackFrame{} }
func (m *StackFrame) String() string { return proto.CompactTextString(m) }
func (*StackFrame) ProtoMessage()    {}
func (*StackFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{4}
}
func (m *StackFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StackFrame.Unmarshal(m, b)
}
func (m *StackFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StackFrame.Marshal(b, m, deterministic)
}
func (dst *StackFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StackFrame.Merge(dst, src)
}
func (m *StackFrame) XXX_Size() int {
	return xxx_messageInfo_StackFrame.Size(m)
}
func (m *StackFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_StackFrame.DiscardUnknown(m)
}

var xxx_messageInfo_StackFrame proto.InternalMessageInfo

func (m *StackFrame) GetFunction() string {
	if m != nil {
		return m.Function
	}
	return ""
}

func (m *StackFrame) GetLocation() *SourceLocation {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *StackFrame) GetArguments() []*Variable {
	if m != nil {
		return m.Arguments
	}
	return nil
}

func (m *StackFrame) GetLocals() []*Variable {
	if m != nil {
		return m.Locals
	}
	return nil
}

// Represents the breakpoint specification, status and results.
type Breakpoint struct {
	// Breakpoint identifier, unique in the scope of the debuggee.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Action that the agent should perform when the code at the
	// breakpoint location is hit.
	Action Breakpoint_Action `protobuf:"varint,13,opt,name=action,proto3,enum=google.devtools.clouddebugger.v2.Breakpoint_Action" json:"action,omitempty"`
	// Breakpoint source location.
	Location *SourceLocation `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Condition that triggers the breakpoint.
	// The condition is a compound boolean expression composed using expressions
	// in a programming language at the source location.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// List of read-only expressions to evaluate at the breakpoint location.
	// The expressions are composed using expressions in the programming language
	// at the source location. If the breakpoint action is `LOG`, the evaluated
	// expressions are included in log statements.
	Expressions []string `protobuf:"bytes,4,rep,name=expressions,proto3" json:"expressions,omitempty"`
	// Only relevant when action is `LOG`. Defines the message to log when
	// the breakpoint hits. The message may include parameter placeholders `$0`,
	// `$1`, etc. These placeholders are replaced with the evaluated value
	// of the appropriate expression. Expressions not referenced in
	// `log_message_format` are not logged.
	//
	// Example: `Message received, id = $0, count = $1` with
	// `expressions` = `[ message.id, message.count ]`.
	LogMessageFormat string `protobuf:"bytes,14,opt,name=log_message_format,json=logMessageFormat,proto3" json:"log_message_format,omitempty"`
	// Indicates the severity of the log. Only relevant when action is `LOG`.
	LogLevel Breakpoint_LogLevel `protobuf:"varint,15,opt,name=log_level,json=logLevel,proto3,enum=google.devtools.clouddebugger.v2.Breakpoint_LogLevel" json:"log_level,omitempty"`
	// When true, indicates that this is a final result and the
	// breakpoint state will not change from here on.
	IsFinalState bool `protobuf:"varint,5,opt,name=is_final_state,json=isFinalState,proto3" json:"is_final_state,omitempty"`
	// Time this breakpoint was created by the server in seconds resolution.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time this breakpoint was finalized as seen by the server in seconds
	// resolution.
	FinalTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=final_time,json=finalTime,proto3" json:"final_time,omitempty"`
	// E-mail address of the user that created this breakpoint
	UserEmail string `protobuf:"bytes,16,opt,name=user_email,json=userEmail,proto3" json:"user_email,omitempty"`
	// Breakpoint status.
	//
	// The status includes an error flag and a human readable message.
	// This field is usually unset. The message can be either
	// informational or an error message. Regardless, clients should always
	// display the text message back to the user.
	//
	// Error status indicates complete failure of the breakpoint.
	//
	// Example (non-final state): `Still loading symbols...`
	//
	// Examples (final state):
	//
	// *   `Invalid line number` referring to location
	// *   `Field f not found in class C` referring to condition
	Status *StatusMessage `protobuf:"bytes,10,opt,name=status,proto3" json:"status,omitempty"`
	// The stack at breakpoint time, where stack_frames[0] represents the most
	// recently entered function.
	StackFrames []*StackFrame `protobuf:"bytes,7,rep,name=stack_frames,json=stackFrames,proto3" json:"stack_frames,omitempty"`
	// Values of evaluated expressions at breakpoint time.
	// The evaluated expressions appear in exactly the same order they
	// are listed in the `expressions` field.
	// The `name` field holds the original expression text, the `value` or
	// `members` field holds the result of the evaluated expression.
	// If the expression cannot be evaluated, the `status` inside the `Variable`
	// will indicate an error and contain the error text.
	EvaluatedExpressions []*Variable `protobuf:"bytes,8,rep,name=evaluated_expressions,json=evaluatedExpressions,proto3" json:"evaluated_expressions,omitempty"`
	// The `variable_table` exists to aid with computation, memory and network
	// traffic optimization.  It enables storing a variable once and reference
	// it from multiple variables, including variables stored in the
	// `variable_table` itself.
	// For example, the same `this` object, which may appear at many levels of
	// the stack, can have all of its data stored once in this table.  The
	// stack frame variables then would hold only a reference to it.
	//
	// The variable `var_table_index` field is an index into this repeated field.
	// The stored objects are nameless and get their name from the referencing
	// variable. The effective variable is a merge of the referencing variable
	// and the referenced variable.
	VariableTable []*Variable `protobuf:"bytes,9,rep,name=variable_table,json=variableTable,proto3" json:"variable_table,omitempty"`
	// A set of custom breakpoint properties, populated by the agent, to be
	// displayed to the user.
	Labels               map[string]string `protobuf:"bytes,17,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Breakpoint) Reset()         { *m = Breakpoint{} }
func (m *Breakpoint) String() string { return proto.CompactTextString(m) }
func (*Breakpoint) ProtoMessage()    {}
func (*Breakpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{5}
}
func (m *Breakpoint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Breakpoint.Unmarshal(m, b)
}
func (m *Breakpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Breakpoint.Marshal(b, m, deterministic)
}
func (dst *Breakpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Breakpoint.Merge(dst, src)
}
func (m *Breakpoint) XXX_Size() int {
	return xxx_messageInfo_Breakpoint.Size(m)
}
func (m *Breakpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_Breakpoint.DiscardUnknown(m)
}

var xxx_messageInfo_Breakpoint proto.InternalMessageInfo

func (m *Breakpoint) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Breakpoint) GetAction() Breakpoint_Action {
	if m != nil {
		return m.Action
	}
	return Breakpoint_CAPTURE
}

func (m *Breakpoint) GetLocation() *SourceLocation {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *Breakpoint) GetCondition() string {
	if m != nil {
		return m.Condition
	}
	return ""
}

func (m *Breakpoint) GetExpressions() []string {
	if m != nil {
		return m.Expressions
	}
	return nil
}

func (m *Breakpoint) GetLogMessageFormat() string {
	if m != nil {
		return m.LogMessageFormat
	}
	return ""
}

func (m *Breakpoint) GetLogLevel() Breakpoint_LogLevel {
	if m != nil {
		return m.LogLevel
	}
	return Breakpoint_INFO
}

func (m *Breakpoint) GetIsFinalState() bool {
	if m != nil {
		return m.IsFinalState
	}
	return false
}

func (m *Breakpoint) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Breakpoint) GetFinalTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinalTime
	}
	return nil
}

func (m *Breakpoint) GetUserEmail() string {
	if m != nil {
		return m.UserEmail
	}
	return ""
}

func (m *Breakpoint) GetStatus() *StatusMessage {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Breakpoint) GetStackFrames() []*StackFrame {
	if m != nil {
		return m.StackFrames
	}
	return nil
}

func (m *Breakpoint) GetEvaluatedExpressions() []*Variable {
	if m != nil {
		return m.EvaluatedExpressions
	}
	return nil
}

func (m *Breakpoint) GetVariableTable() []*Variable {
	if m != nil {
		return m.VariableTable
	}
	return nil
}

func (m *Breakpoint) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Represents the debugged application. The application may include one or more
// replicated processes executing the same code. Each of these processes is
// attached with a debugger agent, carrying out the debugging commands.
// Agents attached to the same debuggee identify themselves as such by using
// exactly the same Debuggee message value when registering.
type Debuggee struct {
	// Unique identifier for the debuggee generated by the controller service.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Project the debuggee is associated with.
	// Use project number or id when registering a Google Cloud Platform project.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Uniquifier to further distinguish the application.
	// It is possible that different applications might have identical values in
	// the debuggee message, thus, incorrectly identified as a single application
	// by the Controller service. This field adds salt to further distinguish the
	// application. Agents should consider seeding this field with value that
	// identifies the code, binary, configuration and environment.
	Uniquifier string `protobuf:"bytes,3,opt,name=uniquifier,proto3" json:"uniquifier,omitempty"`
	// Human readable description of the debuggee.
	// Including a human-readable project name, environment name and version
	// information is recommended.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// If set to `true`, indicates that Controller service does not detect any
	// activity from the debuggee agents and the application is possibly stopped.
	IsInactive bool `protobuf:"varint,5,opt,name=is_inactive,json=isInactive,proto3" json:"is_inactive,omitempty"`
	// Version ID of the agent.
	// Schema: `domain/language-platform/vmajor.minor` (for example
	// `google.com/java-gcp/v1.1`).
	AgentVersion string `protobuf:"bytes,6,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// If set to `true`, indicates that the agent should disable itself and
	// detach from the debuggee.
	IsDisabled bool `protobuf:"varint,7,opt,name=is_disabled,json=isDisabled,proto3" json:"is_disabled,omitempty"`
	// Human readable message to be displayed to the user about this debuggee.
	// Absence of this field indicates no status. The message can be either
	// informational or an error status.
	Status *StatusMessage `protobuf:"bytes,8,opt,name=status,proto3" json:"status,omitempty"`
	// References to the locations and revisions of the source code used in the
	// deployed application.
	SourceContexts []*v1.SourceContext `protobuf:"bytes,9,rep,name=source_contexts,json=sourceContexts,proto3" json:"source_contexts,omitempty"`
	// References to the locations and revisions of the source code used in the
	// deployed application.
	ExtSourceContexts []*v1.ExtendedSourceContext `protobuf:"bytes,13,rep,name=ext_source_contexts,json=extSourceContexts,proto3" json:"ext_source_contexts,omitempty"` // Deprecated: Do not use.
	// A set of custom debuggee properties, populated by the agent, to be
	// displayed to the user.
	Labels               map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Debuggee) Reset()         { *m = Debuggee{} }
func (m *Debuggee) String() string { return proto.CompactTextString(m) }
func (*Debuggee) ProtoMessage()    {}
func (*Debuggee) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_821f79f55e9f1289, []int{6}
}
func (m *Debuggee) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Debuggee.Unmarshal(m, b)
}
func (m *Debuggee) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Debuggee.Marshal(b, m, deterministic)
}
func (dst *Debuggee) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Debuggee.Merge(dst, src)
}
func (m *Debuggee) XXX_Size() int {
	return xxx_messageInfo_Debuggee.Size(m)
}
func (m *Debuggee) XXX_DiscardUnknown() {
	xxx_messageInfo_Debuggee.DiscardUnknown(m)
}

var xxx_messageInfo_Debuggee proto.InternalMessageInfo

func (m *Debuggee) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Debuggee) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *Debuggee) GetUniquifier() string {
	if m != nil {
		return m.Uniquifier
	}
	return ""
}

func (m *Debuggee) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Debuggee) GetIsInactive() bool {
	if m != nil {
		return m.IsInactive
	}
	return false
}

func (m *Debuggee) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

func (m *Debuggee) GetIsDisabled() bool {
	if m != nil {
		return m.IsDisabled
	}
	return false
}

func (m *Debuggee) GetStatus() *StatusMessage {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Debuggee) GetSourceContexts() []*v1.SourceContext {
	if m != nil {
		return m.SourceContexts
	}
	return nil
}

// Deprecated: Do not use.
func (m *Debuggee) GetExtSourceContexts() []*v1.ExtendedSourceContext {
	if m != nil {
		return m.ExtSourceContexts
	}
	return nil
}

func (m *Debuggee) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*FormatMessage)(nil), "google.devtools.clouddebugger.v2.FormatMessage")
	proto.RegisterType((*StatusMessage)(nil), "google.devtools.clouddebugger.v2.StatusMessage")
	proto.RegisterType((*SourceLocation)(nil), "google.devtools.clouddebugger.v2.SourceLocation")
	proto.RegisterType((*Variable)(nil), "google.devtools.clouddebugger.v2.Variable")
	proto.RegisterType((*StackFrame)(nil), "google.devtools.clouddebugger.v2.StackFrame")
	proto.RegisterType((*Breakpoint)(nil), "google.devtools.clouddebugger.v2.Breakpoint")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.clouddebugger.v2.Breakpoint.LabelsEntry")
	proto.RegisterType((*Debuggee)(nil), "google.devtools.clouddebugger.v2.Debuggee")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.clouddebugger.v2.Debuggee.LabelsEntry")
	proto.RegisterEnum("google.devtools.clouddebugger.v2.StatusMessage_Reference", StatusMessage_Reference_name, StatusMessage_Reference_value)
	proto.RegisterEnum("google.devtools.clouddebugger.v2.Breakpoint_Action", Breakpoint_Action_name, Breakpoint_Action_value)
	proto.RegisterEnum("google.devtools.clouddebugger.v2.Breakpoint_LogLevel", Breakpoint_LogLevel_name, Breakpoint_LogLevel_value)
}

func init() {
	proto.RegisterFile("google/devtools/clouddebugger/v2/data.proto", fileDescriptor_data_821f79f55e9f1289)
}

var fileDescriptor_data_821f79f55e9f1289 = []byte{
	// 1293 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdd, 0x72, 0xda, 0x46,
	0x14, 0x0e, 0x3f, 0x06, 0xe9, 0x60, 0x30, 0xd9, 0x26, 0x1d, 0xc5, 0x4d, 0x1d, 0x86, 0xe6, 0xc2,
	0xd3, 0x66, 0x20, 0x21, 0xd3, 0x4e, 0xd2, 0x5c, 0x01, 0x96, 0x5d, 0x26, 0x04, 0xc8, 0x62, 0xd3,
	0x4e, 0x27, 0x33, 0x9a, 0x35, 0x5a, 0x54, 0x35, 0x42, 0xa2, 0xbb, 0x0b, 0x75, 0xee, 0xf3, 0x18,
	0x7d, 0x82, 0x4e, 0xdf, 0xa0, 0x6f, 0xd0, 0x97, 0xe8, 0x7d, 0x9f, 0xa0, 0x97, 0x9d, 0x5d, 0xad,
	0x88, 0x48, 0x9a, 0x12, 0x37, 0xb9, 0xdb, 0xfd, 0xce, 0x39, 0xdf, 0x8a, 0x6f, 0xbf, 0x73, 0x24,
	0xe0, 0x0b, 0x2f, 0x8a, 0xbc, 0x80, 0x36, 0x5d, 0xba, 0x12, 0x51, 0x14, 0xf0, 0xe6, 0x34, 0x88,
	0x96, 0xae, 0x4b, 0xcf, 0x97, 0x9e, 0x47, 0x59, 0x73, 0xd5, 0x6a, 0xba, 0x44, 0x90, 0xc6, 0x82,
	0x45, 0x22, 0x42, 0xb5, 0x38, 0xb9, 0x91, 0x24, 0x37, 0x36, 0x92, 0x1b, 0xab, 0xd6, 0xfe, 0x4d,
	0x4d, 0x47, 0x16, 0x7e, 0x93, 0x84, 0x61, 0x24, 0x88, 0xf0, 0xa3, 0x90, 0xc7, 0xf5, 0xfb, 0x8d,
	0xd7, 0x0f, 0xe3, 0xd1, 0x92, 0x4d, 0x69, 0x73, 0x75, 0x4f, 0xaf, 0x9c, 0x69, 0x14, 0x0a, 0x7a,
	0x21, 0x74, 0xfe, 0x81, 0xce, 0x57, 0xbb, 0xf3, 0xe5, 0xac, 0xe9, 0x2e, 0x99, 0x22, 0xd4, 0xf1,
	0x5b, 0xaf, 0xc7, 0x85, 0x3f, 0xa7, 0x5c, 0x90, 0xf9, 0xe2, 0x6d, 0x04, 0x3f, 0x33, 0xb2, 0x58,
	0x50, 0xa6, 0x1f, 0xa8, 0x7e, 0x02, 0xe5, 0xe3, 0x88, 0xcd, 0x89, 0x78, 0x42, 0x39, 0x27, 0x1e,
	0x45, 0x1f, 0x43, 0x61, 0xa6, 0x00, 0x2b, 0x53, 0xcb, 0x1c, 0x9a, 0x58, 0xef, 0xd0, 0x01, 0xc0,
	0x82, 0x30, 0x32, 0xa7, 0x82, 0x32, 0x6e, 0x65, 0x6b, 0xb9, 0x43, 0x13, 0xa7, 0x90, 0xfa, 0xcb,
	0x1c, 0x94, 0xc7, 0x82, 0x88, 0x25, 0x4f, 0x98, 0x6e, 0x80, 0xe1, 0x73, 0x87, 0x32, 0x16, 0x31,
	0xc5, 0x65, 0xe0, 0xa2, 0xcf, 0x6d, 0xb9, 0x45, 0x13, 0x30, 0x19, 0x9d, 0x51, 0xc6, 0x1d, 0x11,
	0x59, 0xd9, 0x5a, 0xe6, 0xb0, 0xd2, 0x7a, 0xd8, 0xd8, 0x26, 0x6d, 0x63, 0x83, 0xbe, 0x81, 0x25,
	0x01, 0x0d, 0xa7, 0x14, 0x1b, 0x31, 0xd7, 0x69, 0x84, 0x9e, 0x42, 0xc9, 0xa5, 0x7c, 0xca, 0xfc,
	0x85, 0xd4, 0xc8, 0xca, 0xd5, 0x32, 0x87, 0xa5, 0x56, 0x73, 0x3b, 0xf3, 0x86, 0x04, 0x38, 0xcd,
	0x51, 0xff, 0x2d, 0x03, 0xe6, 0xfa, 0x28, 0xb4, 0x07, 0xa5, 0xb3, 0xc1, 0x78, 0x64, 0x77, 0x7b,
	0xc7, 0x3d, 0xfb, 0xa8, 0x7a, 0x05, 0x1d, 0xc0, 0x7e, 0x07, 0xdb, 0xed, 0xc7, 0xa3, 0x61, 0x6f,
	0x70, 0xea, 0x8c, 0x87, 0x67, 0xb8, 0x6b, 0x3b, 0xfd, 0x61, 0xb7, 0x7d, 0xda, 0x1b, 0x0e, 0xaa,
	0x39, 0x64, 0xc1, 0xb5, 0x54, 0xbc, 0x3b, 0x1c, 0x1c, 0xf5, 0x54, 0x24, 0x8f, 0x6e, 0xc0, 0xf5,
	0x54, 0xc4, 0xfe, 0x6e, 0x84, 0xed, 0xf1, 0x58, 0x86, 0x8a, 0x08, 0x41, 0x25, 0x15, 0x6a, 0x9f,
	0xd8, 0x55, 0x03, 0x5d, 0x85, 0xf2, 0xa4, 0x8d, 0x7b, 0xed, 0x4e, 0xdf, 0x76, 0x06, 0xed, 0x27,
	0x76, 0x75, 0x47, 0xa6, 0xad, 0xa1, 0x49, 0xbb, 0x7f, 0x66, 0x57, 0x0b, 0xf5, 0x11, 0x54, 0xc6,
	0xca, 0x48, 0xfd, 0x68, 0xaa, 0x8c, 0x82, 0x10, 0xe4, 0x17, 0x44, 0xfc, 0xa0, 0xaf, 0x53, 0xad,
	0x25, 0x16, 0xf8, 0x21, 0x55, 0xd2, 0xef, 0x60, 0xb5, 0x96, 0x17, 0x3f, 0x8d, 0x82, 0xe5, 0x3c,
	0x96, 0x6d, 0x07, 0xeb, 0x5d, 0xfd, 0x97, 0x2c, 0x18, 0x13, 0xc2, 0x7c, 0x72, 0x1e, 0x50, 0x59,
	0x18, 0x92, 0x39, 0x4d, 0xc8, 0xe4, 0x1a, 0x5d, 0x83, 0x9d, 0x15, 0x09, 0x96, 0x31, 0x9b, 0x89,
	0xe3, 0x8d, 0xcc, 0x14, 0x2f, 0x16, 0xd4, 0x2a, 0xc4, 0x99, 0x72, 0x8d, 0x8e, 0xa0, 0x38, 0xa7,
	0xf3, 0x73, 0x69, 0xa0, 0x5c, 0x2d, 0x77, 0x58, 0x6a, 0x7d, 0xbe, 0xfd, 0x6a, 0x92, 0xa3, 0x71,
	0x52, 0x8a, 0xba, 0xb0, 0xb7, 0x22, 0xcc, 0x11, 0x12, 0x75, 0xfc, 0xd0, 0xa5, 0x17, 0x56, 0x5e,
	0x5d, 0xf4, 0x27, 0x09, 0x5b, 0x62, 0xf6, 0x46, 0x2f, 0x14, 0xf7, 0x5b, 0x13, 0xf9, 0x3c, 0xb8,
	0xbc, 0x22, 0xec, 0x54, 0x96, 0xf4, 0x64, 0x05, 0x3a, 0x81, 0x02, 0x57, 0x76, 0xb2, 0x76, 0xde,
	0xd5, 0x24, 0x1b, 0xf6, 0xc3, 0xba, 0xbc, 0xfe, 0x32, 0x0b, 0x30, 0x16, 0x64, 0xfa, 0xfc, 0x58,
	0xb6, 0x02, 0xda, 0x07, 0x63, 0xb6, 0x0c, 0xa7, 0xca, 0x7e, 0xb1, 0x48, 0xeb, 0x3d, 0xea, 0x83,
	0x11, 0xe8, 0x5b, 0x51, 0x5a, 0x95, 0x5a, 0x77, 0xdf, 0xe1, 0xd4, 0x8d, 0xdb, 0xc4, 0x6b, 0x06,
	0xf4, 0x0d, 0x98, 0x84, 0x79, 0xcb, 0x39, 0x0d, 0xc5, 0xff, 0x91, 0xf3, 0x55, 0x31, 0xea, 0x40,
	0x41, 0xb2, 0x06, 0xdc, 0xca, 0x5f, 0x9a, 0x46, 0x57, 0xd6, 0xff, 0x34, 0x00, 0x3a, 0x8c, 0x92,
	0xe7, 0x8b, 0xc8, 0x0f, 0x05, 0xaa, 0x40, 0xd6, 0x77, 0xb5, 0x00, 0x59, 0xdf, 0x45, 0x8f, 0xa1,
	0x40, 0x62, 0x51, 0xca, 0xaa, 0xdb, 0xef, 0x6f, 0x3f, 0xe2, 0x15, 0x5b, 0xa3, 0xad, 0x4a, 0xb1,
	0xa6, 0xf8, 0xc0, 0x3a, 0xde, 0x04, 0x73, 0x1a, 0x85, 0xae, 0xbf, 0x9e, 0x18, 0x26, 0x7e, 0x05,
	0xa0, 0x1a, 0x94, 0xe8, 0xc5, 0x82, 0x51, 0xce, 0xe5, 0x14, 0x57, 0x02, 0x99, 0x38, 0x0d, 0xa1,
	0x3b, 0x80, 0x82, 0xc8, 0x73, 0xe6, 0xb1, 0x2f, 0x1c, 0x3d, 0x3c, 0x2b, 0x8a, 0xa8, 0x1a, 0x44,
	0x9e, 0x36, 0x4c, 0x3c, 0x62, 0x10, 0x06, 0x53, 0x66, 0x07, 0x74, 0x45, 0x03, 0x6b, 0x4f, 0x69,
	0xf1, 0xe5, 0xa5, 0xb4, 0xe8, 0x47, 0x5e, 0x5f, 0x16, 0xcb, 0x5f, 0x10, 0xaf, 0xd0, 0x6d, 0xa8,
	0xf8, 0xdc, 0x99, 0xf9, 0x21, 0x09, 0x1c, 0xe9, 0x4a, 0xaa, 0x3c, 0x6d, 0xe0, 0x5d, 0x9f, 0x1f,
	0x4b, 0x50, 0x1a, 0x97, 0xa2, 0x47, 0x50, 0x9a, 0x32, 0x4a, 0x04, 0x75, 0xe4, 0x3b, 0xc2, 0x2a,
	0x29, 0xe1, 0xf6, 0xdf, 0x68, 0x99, 0xd3, 0xe4, 0x05, 0x82, 0x21, 0x4e, 0x97, 0x00, 0x7a, 0x08,
	0x10, 0xf3, 0xab, 0xda, 0xdd, 0xad, 0xb5, 0xa6, 0xca, 0x56, 0xa5, 0x9f, 0x02, 0x2c, 0x39, 0x65,
	0x0e, 0x9d, 0x13, 0x3f, 0xb0, 0xaa, 0xb1, 0xc0, 0x12, 0xb1, 0x25, 0x90, 0x6a, 0x44, 0x78, 0xaf,
	0x46, 0x44, 0x43, 0xd8, 0xe5, 0xb2, 0x0f, 0x9d, 0x99, 0x6c, 0x44, 0x6e, 0x15, 0x95, 0x97, 0xef,
	0xbc, 0x13, 0x9d, 0xee, 0x5e, 0x5c, 0xe2, 0xeb, 0x35, 0x47, 0x0e, 0x5c, 0xa7, 0x72, 0x96, 0x11,
	0x41, 0x5d, 0x27, 0x6d, 0x02, 0xe3, 0xd2, 0x5d, 0x72, 0x6d, 0x4d, 0x64, 0xa7, 0x9c, 0xf3, 0x14,
	0x2a, 0x2b, 0x9d, 0x11, 0x4f, 0x33, 0xcb, 0xbc, 0x34, 0x73, 0x39, 0x61, 0x50, 0xb3, 0x0d, 0x8d,
	0xa0, 0x10, 0x90, 0x73, 0x1a, 0x70, 0xeb, 0xaa, 0xa2, 0x7a, 0x70, 0x39, 0x6f, 0xa9, 0x52, 0x3b,
	0x14, 0xec, 0x05, 0xd6, 0x3c, 0xfb, 0x0f, 0xa1, 0x94, 0x82, 0x51, 0x15, 0x72, 0xcf, 0xe9, 0x0b,
	0xdd, 0xd9, 0x72, 0xf9, 0xef, 0xe3, 0xff, 0xeb, 0xec, 0x83, 0x4c, 0xfd, 0x00, 0x0a, 0x71, 0xe7,
	0xa2, 0x12, 0x14, 0xbb, 0xed, 0xd1, 0xe9, 0x19, 0xb6, 0xab, 0x57, 0x50, 0x11, 0x72, 0xfd, 0xe1,
	0x49, 0x35, 0x53, 0xbf, 0x03, 0x46, 0xe2, 0x66, 0x64, 0x40, 0xbe, 0x37, 0x38, 0x1e, 0x56, 0xaf,
	0xc8, 0xdc, 0x6f, 0xdb, 0x78, 0xd0, 0x1b, 0x9c, 0x54, 0x33, 0xc8, 0x84, 0x1d, 0x1b, 0xe3, 0x21,
	0xae, 0x66, 0xeb, 0x7f, 0xe5, 0xc1, 0x38, 0x8a, 0x9f, 0x9b, 0xbe, 0x31, 0x5f, 0x2c, 0x28, 0x2e,
	0x58, 0xf4, 0x23, 0x9d, 0x0a, 0xfd, 0x18, 0xc9, 0x56, 0x7e, 0xb7, 0x2c, 0x43, 0xff, 0xa7, 0xa5,
	0x3f, 0xf3, 0x29, 0xd3, 0xfd, 0x9d, 0x42, 0x64, 0x83, 0xa7, 0x3f, 0x19, 0xf2, 0x2a, 0x21, 0x0d,
	0xa1, 0x5b, 0x50, 0xf2, 0xb9, 0xe3, 0x87, 0x72, 0xfa, 0xac, 0x92, 0xde, 0x02, 0x9f, 0xf7, 0x34,
	0x82, 0x3e, 0x83, 0x32, 0xf1, 0x68, 0x28, 0x9c, 0x15, 0x65, 0xf2, 0x66, 0xf5, 0x3b, 0x6f, 0x57,
	0x81, 0x93, 0x18, 0xd3, 0x2c, 0xae, 0xcf, 0xe5, 0x3d, 0xb9, 0x56, 0x31, 0x61, 0x39, 0xd2, 0x48,
	0xaa, 0x11, 0x8c, 0xf7, 0x6b, 0x84, 0xa7, 0xb0, 0xb7, 0xf9, 0x2d, 0xc9, 0xb5, 0xaf, 0x0e, 0xdf,
	0x60, 0x8c, 0xf3, 0x1a, 0xab, 0x7b, 0x7a, 0x3c, 0x76, 0xe3, 0x02, 0x5c, 0xe1, 0xe9, 0x2d, 0x47,
	0x2e, 0x7c, 0x44, 0x2f, 0x84, 0xf3, 0x3a, 0x6d, 0x59, 0xd1, 0xde, 0xfd, 0x0f, 0x5a, 0xfb, 0x42,
	0xd0, 0xd0, 0xa5, 0xee, 0x06, 0x7d, 0x27, 0x6b, 0x65, 0xf0, 0x55, 0x7a, 0x21, 0xc6, 0x9b, 0xa7,
	0x0c, 0xd6, 0xe6, 0x2d, 0x29, 0xe2, 0xaf, 0xb6, 0x2b, 0x90, 0x18, 0xe2, 0x03, 0x5b, 0xb7, 0xf3,
	0x7b, 0x06, 0x6e, 0x4f, 0xa3, 0xf9, 0xd6, 0x07, 0xe8, 0x98, 0x47, 0x44, 0x90, 0x91, 0x1c, 0x80,
	0xa3, 0xcc, 0xf7, 0x4f, 0x74, 0xba, 0x17, 0x05, 0x24, 0xf4, 0x1a, 0x11, 0xf3, 0x9a, 0x1e, 0x0d,
	0xd5, 0x78, 0x6c, 0xc6, 0x21, 0xb2, 0xf0, 0xf9, 0xdb, 0xff, 0x69, 0x3c, 0xda, 0x00, 0xfe, 0xce,
	0x64, 0x7e, 0xcd, 0x5a, 0x27, 0x31, 0x65, 0x57, 0x46, 0x92, 0x9f, 0xcb, 0x1a, 0x93, 0xd6, 0x1f,
	0x49, 0xe8, 0x99, 0x0a, 0x3d, 0x4b, 0x42, 0xcf, 0x26, 0xad, 0xf3, 0x82, 0x3a, 0xf2, 0xfe, 0x3f,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x0a, 0xe0, 0xe9, 0x2c, 0xdb, 0x0c, 0x00, 0x00,
}
