'use client';
'use strict';

require('dayjs');
var shiftTimezone = require('../../../utils/shift-timezone.cjs');

function dateStringParser(dateString, timezone) {
  if (dateString === null) {
    return null;
  }
  const date = shiftTimezone.shiftTimezone("add", new Date(dateString), timezone);
  if (Number.isNaN(date.getTime()) || !dateString) {
    return null;
  }
  return date;
}

exports.dateStringParser = dateStringParser;
//# sourceMappingURL=date-string-parser.cjs.map
