import * as React from "react";
import {
  mergeOptions,
  defaultOptions
} from "./options";
const providerlessContextValue = {
  adapter: {},
  options: defaultOptions
};
const QueryParamContext = React.createContext(
  providerlessContextValue
);
function useQueryParamContext() {
  const value = React.useContext(QueryParamContext);
  if (value === void 0 || value === providerlessContextValue) {
    throw new Error("useQueryParams must be used within a QueryParamProvider");
  }
  return value;
}
function QueryParamProviderInner({
  children,
  adapter,
  options
}) {
  const { adapter: parentAdapter, options: parentOptions } = React.useContext(QueryParamContext);
  const value = React.useMemo(() => {
    return {
      adapter: adapter != null ? adapter : parentAdapter,
      options: mergeOptions(
        parentOptions,
        options
      )
    };
  }, [adapter, options, parentAdapter, parentOptions]);
  return /* @__PURE__ */ React.createElement(QueryParamContext.Provider, {
    value
  }, children);
}
function QueryParamProvider({
  children,
  adapter,
  options
}) {
  const Adapter = adapter;
  return Adapter ? /* @__PURE__ */ React.createElement(Adapter, null, (adapter2) => /* @__PURE__ */ React.createElement(QueryParamProviderInner, {
    adapter: adapter2,
    options
  }, children)) : /* @__PURE__ */ React.createElement(QueryParamProviderInner, {
    options
  }, children);
}
var QueryParamProvider_default = QueryParamProvider;
export {
  QueryParamContext,
  QueryParamProvider,
  QueryParamProvider_default as default,
  useQueryParamContext
};
//# sourceMappingURL=QueryParamProvider.js.map
