// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/pbproxystate/cluster.proto

package pbproxystate

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// +kubebuilder:validation:Enum=DISCOVERY_TYPE_LOGICAL;DISCOVERY_TYPE_STRICT
// +kubebuilder:validation:Type=string
type DiscoveryType int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	DiscoveryType_DISCOVERY_TYPE_LOGICAL DiscoveryType = 0
	DiscoveryType_DISCOVERY_TYPE_STRICT  DiscoveryType = 1
)

// Enum value maps for DiscoveryType.
var (
	DiscoveryType_name = map[int32]string{
		0: "DISCOVERY_TYPE_LOGICAL",
		1: "DISCOVERY_TYPE_STRICT",
	}
	DiscoveryType_value = map[string]int32{
		"DISCOVERY_TYPE_LOGICAL": 0,
		"DISCOVERY_TYPE_STRICT":  1,
	}
)

func (x DiscoveryType) Enum() *DiscoveryType {
	p := new(DiscoveryType)
	*p = x
	return p
}

func (x DiscoveryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryType) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_enumTypes[0].Descriptor()
}

func (DiscoveryType) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_cluster_proto_enumTypes[0]
}

func (x DiscoveryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryType.Descriptor instead.
func (DiscoveryType) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{0}
}

type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the name of the cluster.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// group is either a failover group or endpoint group. If this cluster needs to failover to other clusters, use the failover group. If this cluster routes directly to endpoints, use the endpoint group.
	//
	// Types that are assignable to Group:
	//
	//	*Cluster_FailoverGroup
	//	*Cluster_EndpointGroup
	Group isCluster_Group `protobuf_oneof:"group"`
	// escape_hatch_cluster_json configures a user configured escape hatch cluster.
	EscapeHatchClusterJson string `protobuf:"bytes,4,opt,name=escape_hatch_cluster_json,json=escapeHatchClusterJson,proto3" json:"escape_hatch_cluster_json,omitempty"`
	// alt_stat_name is the name used for observability in place of cluster name if provided.
	AltStatName string `protobuf:"bytes,5,opt,name=alt_stat_name,json=altStatName,proto3" json:"alt_stat_name,omitempty"`
	// protocol is the local path protocol or the service protocol.
	Protocol Protocol `protobuf:"varint,6,opt,name=protocol,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.Protocol" json:"protocol,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Cluster) GetGroup() isCluster_Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (x *Cluster) GetFailoverGroup() *FailoverGroup {
	if x, ok := x.GetGroup().(*Cluster_FailoverGroup); ok {
		return x.FailoverGroup
	}
	return nil
}

func (x *Cluster) GetEndpointGroup() *EndpointGroup {
	if x, ok := x.GetGroup().(*Cluster_EndpointGroup); ok {
		return x.EndpointGroup
	}
	return nil
}

func (x *Cluster) GetEscapeHatchClusterJson() string {
	if x != nil {
		return x.EscapeHatchClusterJson
	}
	return ""
}

func (x *Cluster) GetAltStatName() string {
	if x != nil {
		return x.AltStatName
	}
	return ""
}

func (x *Cluster) GetProtocol() Protocol {
	if x != nil {
		return x.Protocol
	}
	return Protocol_PROTOCOL_UNSPECIFIED
}

type isCluster_Group interface {
	isCluster_Group()
}

type Cluster_FailoverGroup struct {
	FailoverGroup *FailoverGroup `protobuf:"bytes,2,opt,name=failover_group,json=failoverGroup,proto3,oneof"`
}

type Cluster_EndpointGroup struct {
	EndpointGroup *EndpointGroup `protobuf:"bytes,3,opt,name=endpoint_group,json=endpointGroup,proto3,oneof"`
}

func (*Cluster_FailoverGroup) isCluster_Group() {}

func (*Cluster_EndpointGroup) isCluster_Group() {}

type FailoverGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// endpoint_groups is an ordered list of which groups to failover to.
	EndpointGroups []*EndpointGroup     `protobuf:"bytes,1,rep,name=endpoint_groups,json=endpointGroups,proto3" json:"endpoint_groups,omitempty"`
	Config         *FailoverGroupConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *FailoverGroup) Reset() {
	*x = FailoverGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailoverGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailoverGroup) ProtoMessage() {}

func (x *FailoverGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailoverGroup.ProtoReflect.Descriptor instead.
func (*FailoverGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *FailoverGroup) GetEndpointGroups() []*EndpointGroup {
	if x != nil {
		return x.EndpointGroups
	}
	return nil
}

func (x *FailoverGroup) GetConfig() *FailoverGroupConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type FailoverGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UseAltStatName bool `protobuf:"varint,1,opt,name=use_alt_stat_name,json=useAltStatName,proto3" json:"use_alt_stat_name,omitempty"`
	// +kubebuilder:validation:Type=string
	ConnectTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
}

func (x *FailoverGroupConfig) Reset() {
	*x = FailoverGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailoverGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailoverGroupConfig) ProtoMessage() {}

func (x *FailoverGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailoverGroupConfig.ProtoReflect.Descriptor instead.
func (*FailoverGroupConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *FailoverGroupConfig) GetUseAltStatName() bool {
	if x != nil {
		return x.UseAltStatName
	}
	return false
}

func (x *FailoverGroupConfig) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

type EndpointGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is used to name the cluster created. This is only required when used inside of a FailoverGroup.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to Group:
	//
	//	*EndpointGroup_Dynamic
	//	*EndpointGroup_Static
	//	*EndpointGroup_Dns
	//	*EndpointGroup_Passthrough
	Group isEndpointGroup_Group `protobuf_oneof:"group"`
}

func (x *EndpointGroup) Reset() {
	*x = EndpointGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndpointGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointGroup) ProtoMessage() {}

func (x *EndpointGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointGroup.ProtoReflect.Descriptor instead.
func (*EndpointGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *EndpointGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *EndpointGroup) GetGroup() isEndpointGroup_Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (x *EndpointGroup) GetDynamic() *DynamicEndpointGroup {
	if x, ok := x.GetGroup().(*EndpointGroup_Dynamic); ok {
		return x.Dynamic
	}
	return nil
}

func (x *EndpointGroup) GetStatic() *StaticEndpointGroup {
	if x, ok := x.GetGroup().(*EndpointGroup_Static); ok {
		return x.Static
	}
	return nil
}

func (x *EndpointGroup) GetDns() *DNSEndpointGroup {
	if x, ok := x.GetGroup().(*EndpointGroup_Dns); ok {
		return x.Dns
	}
	return nil
}

func (x *EndpointGroup) GetPassthrough() *PassthroughEndpointGroup {
	if x, ok := x.GetGroup().(*EndpointGroup_Passthrough); ok {
		return x.Passthrough
	}
	return nil
}

type isEndpointGroup_Group interface {
	isEndpointGroup_Group()
}

type EndpointGroup_Dynamic struct {
	// dynamic endpoint group is used to reach mesh destinations that are dynamically configured from Consul's catalog.
	Dynamic *DynamicEndpointGroup `protobuf:"bytes,1,opt,name=dynamic,proto3,oneof"`
}

type EndpointGroup_Static struct {
	// static endpoint group is used to reach local app ports.
	Static *StaticEndpointGroup `protobuf:"bytes,2,opt,name=static,proto3,oneof"`
}

type EndpointGroup_Dns struct {
	// dns is used to reach mesh and non-mesh destinations using a hostname.
	Dns *DNSEndpointGroup `protobuf:"bytes,3,opt,name=dns,proto3,oneof"`
}

type EndpointGroup_Passthrough struct {
	// passthrough is used to reach destinations that don't have endpoints saved in Consul.
	Passthrough *PassthroughEndpointGroup `protobuf:"bytes,4,opt,name=passthrough,proto3,oneof"`
}

func (*EndpointGroup_Dynamic) isEndpointGroup_Group() {}

func (*EndpointGroup_Static) isEndpointGroup_Group() {}

func (*EndpointGroup_Dns) isEndpointGroup_Group() {}

func (*EndpointGroup_Passthrough) isEndpointGroup_Group() {}

type DynamicEndpointGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// config configures how to connect to the endpoints.
	Config *DynamicEndpointGroupConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// outbound_tls will configure what TLS information to use when connecting to an upstream.
	OutboundTls *TransportSocket `protobuf:"bytes,2,opt,name=outbound_tls,json=outboundTls,proto3" json:"outbound_tls,omitempty"`
}

func (x *DynamicEndpointGroup) Reset() {
	*x = DynamicEndpointGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicEndpointGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicEndpointGroup) ProtoMessage() {}

func (x *DynamicEndpointGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicEndpointGroup.ProtoReflect.Descriptor instead.
func (*DynamicEndpointGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *DynamicEndpointGroup) GetConfig() *DynamicEndpointGroupConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *DynamicEndpointGroup) GetOutboundTls() *TransportSocket {
	if x != nil {
		return x.OutboundTls
	}
	return nil
}

type PassthroughEndpointGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// config configures how to connect to the endpoints.
	Config *PassthroughEndpointGroupConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// outbound_tls will configure what TLS information to use when connecting to an upstream.
	OutboundTls *TransportSocket `protobuf:"bytes,2,opt,name=outbound_tls,json=outboundTls,proto3" json:"outbound_tls,omitempty"`
}

func (x *PassthroughEndpointGroup) Reset() {
	*x = PassthroughEndpointGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PassthroughEndpointGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PassthroughEndpointGroup) ProtoMessage() {}

func (x *PassthroughEndpointGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PassthroughEndpointGroup.ProtoReflect.Descriptor instead.
func (*PassthroughEndpointGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *PassthroughEndpointGroup) GetConfig() *PassthroughEndpointGroupConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PassthroughEndpointGroup) GetOutboundTls() *TransportSocket {
	if x != nil {
		return x.OutboundTls
	}
	return nil
}

type DNSEndpointGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// config configures how to connect to the endpoints.
	Config *DNSEndpointGroupConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// outbound_tls will configure what TLS information to use when connecting to an upstream.
	OutboundTls *TransportSocket `protobuf:"bytes,2,opt,name=outbound_tls,json=outboundTls,proto3" json:"outbound_tls,omitempty"`
}

func (x *DNSEndpointGroup) Reset() {
	*x = DNSEndpointGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DNSEndpointGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNSEndpointGroup) ProtoMessage() {}

func (x *DNSEndpointGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNSEndpointGroup.ProtoReflect.Descriptor instead.
func (*DNSEndpointGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *DNSEndpointGroup) GetConfig() *DNSEndpointGroupConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *DNSEndpointGroup) GetOutboundTls() *TransportSocket {
	if x != nil {
		return x.OutboundTls
	}
	return nil
}

// StaticEndpointGroup is used to reach local app ports.
type StaticEndpointGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// config configures how to connect to the endpoints.
	Config *StaticEndpointGroupConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *StaticEndpointGroup) Reset() {
	*x = StaticEndpointGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticEndpointGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticEndpointGroup) ProtoMessage() {}

func (x *StaticEndpointGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticEndpointGroup.ProtoReflect.Descriptor instead.
func (*StaticEndpointGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *StaticEndpointGroup) GetConfig() *StaticEndpointGroupConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type DestinationCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the name of the cluster. This will be used to look up a cluster in the clusters map.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DestinationCluster) Reset() {
	*x = DestinationCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationCluster) ProtoMessage() {}

func (x *DestinationCluster) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationCluster.ProtoReflect.Descriptor instead.
func (*DestinationCluster) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *DestinationCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type L4WeightedClusterGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// clusters to route to by weight.
	Clusters []*L4WeightedDestinationCluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
}

func (x *L4WeightedClusterGroup) Reset() {
	*x = L4WeightedClusterGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L4WeightedClusterGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L4WeightedClusterGroup) ProtoMessage() {}

func (x *L4WeightedClusterGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L4WeightedClusterGroup.ProtoReflect.Descriptor instead.
func (*L4WeightedClusterGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *L4WeightedClusterGroup) GetClusters() []*L4WeightedDestinationCluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

type L7WeightedClusterGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// clusters to route to by weight.
	Clusters []*L7WeightedDestinationCluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
}

func (x *L7WeightedClusterGroup) Reset() {
	*x = L7WeightedClusterGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L7WeightedClusterGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L7WeightedClusterGroup) ProtoMessage() {}

func (x *L7WeightedClusterGroup) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L7WeightedClusterGroup.ProtoReflect.Descriptor instead.
func (*L7WeightedClusterGroup) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *L7WeightedClusterGroup) GetClusters() []*L7WeightedDestinationCluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

type L4WeightedDestinationCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the name of the cluster. This will be used to look up a cluster in the clusters map.
	Name   string                  `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Weight *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (x *L4WeightedDestinationCluster) Reset() {
	*x = L4WeightedDestinationCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L4WeightedDestinationCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L4WeightedDestinationCluster) ProtoMessage() {}

func (x *L4WeightedDestinationCluster) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L4WeightedDestinationCluster.ProtoReflect.Descriptor instead.
func (*L4WeightedDestinationCluster) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *L4WeightedDestinationCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *L4WeightedDestinationCluster) GetWeight() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Weight
	}
	return nil
}

type L7WeightedDestinationCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the name of the cluster. This will be used to look up a cluster in the clusters map.
	Name            string                  `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Weight          *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=weight,proto3" json:"weight,omitempty"`
	HeaderMutations []*HeaderMutation       `protobuf:"bytes,3,rep,name=header_mutations,json=headerMutations,proto3" json:"header_mutations,omitempty"`
}

func (x *L7WeightedDestinationCluster) Reset() {
	*x = L7WeightedDestinationCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L7WeightedDestinationCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L7WeightedDestinationCluster) ProtoMessage() {}

func (x *L7WeightedDestinationCluster) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L7WeightedDestinationCluster.ProtoReflect.Descriptor instead.
func (*L7WeightedDestinationCluster) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *L7WeightedDestinationCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *L7WeightedDestinationCluster) GetWeight() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Weight
	}
	return nil
}

func (x *L7WeightedDestinationCluster) GetHeaderMutations() []*HeaderMutation {
	if x != nil {
		return x.HeaderMutations
	}
	return nil
}

type DynamicEndpointGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +kubebuilder:validation:Format=duration
	ConnectTimeout        *durationpb.Duration `protobuf:"bytes,1,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	DisablePanicThreshold bool                 `protobuf:"varint,2,opt,name=disable_panic_threshold,json=disablePanicThreshold,proto3" json:"disable_panic_threshold,omitempty"`
	// Types that are assignable to LbPolicy:
	//
	//	*DynamicEndpointGroupConfig_LeastRequest
	//	*DynamicEndpointGroupConfig_RoundRobin
	//	*DynamicEndpointGroupConfig_Random
	//	*DynamicEndpointGroupConfig_RingHash
	//	*DynamicEndpointGroupConfig_Maglev
	LbPolicy                  isDynamicEndpointGroupConfig_LbPolicy `protobuf_oneof:"lb_policy"`
	CircuitBreakers           *CircuitBreakers                      `protobuf:"bytes,8,opt,name=circuit_breakers,json=circuitBreakers,proto3" json:"circuit_breakers,omitempty"`
	OutlierDetection          *OutlierDetection                     `protobuf:"bytes,9,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	UpstreamConnectionOptions *UpstreamConnectionOptions            `protobuf:"bytes,10,opt,name=upstream_connection_options,json=upstreamConnectionOptions,proto3" json:"upstream_connection_options,omitempty"`
	UseAltStatName            bool                                  `protobuf:"varint,11,opt,name=use_alt_stat_name,json=useAltStatName,proto3" json:"use_alt_stat_name,omitempty"`
}

func (x *DynamicEndpointGroupConfig) Reset() {
	*x = DynamicEndpointGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicEndpointGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicEndpointGroupConfig) ProtoMessage() {}

func (x *DynamicEndpointGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicEndpointGroupConfig.ProtoReflect.Descriptor instead.
func (*DynamicEndpointGroupConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *DynamicEndpointGroupConfig) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetDisablePanicThreshold() bool {
	if x != nil {
		return x.DisablePanicThreshold
	}
	return false
}

func (m *DynamicEndpointGroupConfig) GetLbPolicy() isDynamicEndpointGroupConfig_LbPolicy {
	if m != nil {
		return m.LbPolicy
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetLeastRequest() *LBPolicyLeastRequest {
	if x, ok := x.GetLbPolicy().(*DynamicEndpointGroupConfig_LeastRequest); ok {
		return x.LeastRequest
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetRoundRobin() *LBPolicyRoundRobin {
	if x, ok := x.GetLbPolicy().(*DynamicEndpointGroupConfig_RoundRobin); ok {
		return x.RoundRobin
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetRandom() *LBPolicyRandom {
	if x, ok := x.GetLbPolicy().(*DynamicEndpointGroupConfig_Random); ok {
		return x.Random
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetRingHash() *LBPolicyRingHash {
	if x, ok := x.GetLbPolicy().(*DynamicEndpointGroupConfig_RingHash); ok {
		return x.RingHash
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetMaglev() *LBPolicyMaglev {
	if x, ok := x.GetLbPolicy().(*DynamicEndpointGroupConfig_Maglev); ok {
		return x.Maglev
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetCircuitBreakers() *CircuitBreakers {
	if x != nil {
		return x.CircuitBreakers
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetOutlierDetection() *OutlierDetection {
	if x != nil {
		return x.OutlierDetection
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetUpstreamConnectionOptions() *UpstreamConnectionOptions {
	if x != nil {
		return x.UpstreamConnectionOptions
	}
	return nil
}

func (x *DynamicEndpointGroupConfig) GetUseAltStatName() bool {
	if x != nil {
		return x.UseAltStatName
	}
	return false
}

type isDynamicEndpointGroupConfig_LbPolicy interface {
	isDynamicEndpointGroupConfig_LbPolicy()
}

type DynamicEndpointGroupConfig_LeastRequest struct {
	LeastRequest *LBPolicyLeastRequest `protobuf:"bytes,3,opt,name=least_request,json=leastRequest,proto3,oneof"`
}

type DynamicEndpointGroupConfig_RoundRobin struct {
	RoundRobin *LBPolicyRoundRobin `protobuf:"bytes,4,opt,name=round_robin,json=roundRobin,proto3,oneof"`
}

type DynamicEndpointGroupConfig_Random struct {
	Random *LBPolicyRandom `protobuf:"bytes,5,opt,name=random,proto3,oneof"`
}

type DynamicEndpointGroupConfig_RingHash struct {
	RingHash *LBPolicyRingHash `protobuf:"bytes,6,opt,name=ring_hash,json=ringHash,proto3,oneof"`
}

type DynamicEndpointGroupConfig_Maglev struct {
	Maglev *LBPolicyMaglev `protobuf:"bytes,7,opt,name=maglev,proto3,oneof"`
}

func (*DynamicEndpointGroupConfig_LeastRequest) isDynamicEndpointGroupConfig_LbPolicy() {}

func (*DynamicEndpointGroupConfig_RoundRobin) isDynamicEndpointGroupConfig_LbPolicy() {}

func (*DynamicEndpointGroupConfig_Random) isDynamicEndpointGroupConfig_LbPolicy() {}

func (*DynamicEndpointGroupConfig_RingHash) isDynamicEndpointGroupConfig_LbPolicy() {}

func (*DynamicEndpointGroupConfig_Maglev) isDynamicEndpointGroupConfig_LbPolicy() {}

type LBPolicyLeastRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChoiceCount *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=choice_count,json=choiceCount,proto3" json:"choice_count,omitempty"`
}

func (x *LBPolicyLeastRequest) Reset() {
	*x = LBPolicyLeastRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LBPolicyLeastRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LBPolicyLeastRequest) ProtoMessage() {}

func (x *LBPolicyLeastRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LBPolicyLeastRequest.ProtoReflect.Descriptor instead.
func (*LBPolicyLeastRequest) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{14}
}

func (x *LBPolicyLeastRequest) GetChoiceCount() *wrapperspb.UInt32Value {
	if x != nil {
		return x.ChoiceCount
	}
	return nil
}

type LBPolicyRoundRobin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LBPolicyRoundRobin) Reset() {
	*x = LBPolicyRoundRobin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LBPolicyRoundRobin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LBPolicyRoundRobin) ProtoMessage() {}

func (x *LBPolicyRoundRobin) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LBPolicyRoundRobin.ProtoReflect.Descriptor instead.
func (*LBPolicyRoundRobin) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{15}
}

type LBPolicyRandom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LBPolicyRandom) Reset() {
	*x = LBPolicyRandom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LBPolicyRandom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LBPolicyRandom) ProtoMessage() {}

func (x *LBPolicyRandom) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LBPolicyRandom.ProtoReflect.Descriptor instead.
func (*LBPolicyRandom) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{16}
}

type LBPolicyRingHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinimumRingSize *wrapperspb.UInt64Value `protobuf:"bytes,1,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
	MaximumRingSize *wrapperspb.UInt64Value `protobuf:"bytes,2,opt,name=maximum_ring_size,json=maximumRingSize,proto3" json:"maximum_ring_size,omitempty"`
}

func (x *LBPolicyRingHash) Reset() {
	*x = LBPolicyRingHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LBPolicyRingHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LBPolicyRingHash) ProtoMessage() {}

func (x *LBPolicyRingHash) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LBPolicyRingHash.ProtoReflect.Descriptor instead.
func (*LBPolicyRingHash) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{17}
}

func (x *LBPolicyRingHash) GetMinimumRingSize() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MinimumRingSize
	}
	return nil
}

func (x *LBPolicyRingHash) GetMaximumRingSize() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MaximumRingSize
	}
	return nil
}

type LBPolicyMaglev struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LBPolicyMaglev) Reset() {
	*x = LBPolicyMaglev{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LBPolicyMaglev) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LBPolicyMaglev) ProtoMessage() {}

func (x *LBPolicyMaglev) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LBPolicyMaglev.ProtoReflect.Descriptor instead.
func (*LBPolicyMaglev) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{18}
}

type CircuitBreakers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UpstreamLimits *UpstreamLimits `protobuf:"bytes,1,opt,name=upstream_limits,json=upstreamLimits,proto3" json:"upstream_limits,omitempty"`
}

func (x *CircuitBreakers) Reset() {
	*x = CircuitBreakers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CircuitBreakers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CircuitBreakers) ProtoMessage() {}

func (x *CircuitBreakers) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CircuitBreakers.ProtoReflect.Descriptor instead.
func (*CircuitBreakers) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{19}
}

func (x *CircuitBreakers) GetUpstreamLimits() *UpstreamLimits {
	if x != nil {
		return x.UpstreamLimits
	}
	return nil
}

type UpstreamLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxConnections        *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=max_connections,json=maxConnections,proto3" json:"max_connections,omitempty"`
	MaxPendingRequests    *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=max_pending_requests,json=maxPendingRequests,proto3" json:"max_pending_requests,omitempty"`
	MaxConcurrentRequests *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=max_concurrent_requests,json=maxConcurrentRequests,proto3" json:"max_concurrent_requests,omitempty"`
}

func (x *UpstreamLimits) Reset() {
	*x = UpstreamLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamLimits) ProtoMessage() {}

func (x *UpstreamLimits) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamLimits.ProtoReflect.Descriptor instead.
func (*UpstreamLimits) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{20}
}

func (x *UpstreamLimits) GetMaxConnections() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConnections
	}
	return nil
}

func (x *UpstreamLimits) GetMaxPendingRequests() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxPendingRequests
	}
	return nil
}

func (x *UpstreamLimits) GetMaxConcurrentRequests() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConcurrentRequests
	}
	return nil
}

type OutlierDetection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +kubebuilder:validation:Format=duration
	Interval                 *durationpb.Duration    `protobuf:"bytes,1,opt,name=interval,proto3" json:"interval,omitempty"`
	Consecutive_5Xx          *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=consecutive_5xx,json=consecutive5xx,proto3" json:"consecutive_5xx,omitempty"`
	EnforcingConsecutive_5Xx *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=enforcing_consecutive_5xx,json=enforcingConsecutive5xx,proto3" json:"enforcing_consecutive_5xx,omitempty"`
	MaxEjectionPercent       *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=max_ejection_percent,json=maxEjectionPercent,proto3" json:"max_ejection_percent,omitempty"`
	// +kubebuilder:validation:Format=duration
	BaseEjectionTime *durationpb.Duration `protobuf:"bytes,5,opt,name=base_ejection_time,json=baseEjectionTime,proto3" json:"base_ejection_time,omitempty"`
}

func (x *OutlierDetection) Reset() {
	*x = OutlierDetection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutlierDetection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutlierDetection) ProtoMessage() {}

func (x *OutlierDetection) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutlierDetection.ProtoReflect.Descriptor instead.
func (*OutlierDetection) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{21}
}

func (x *OutlierDetection) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *OutlierDetection) GetConsecutive_5Xx() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Consecutive_5Xx
	}
	return nil
}

func (x *OutlierDetection) GetEnforcingConsecutive_5Xx() *wrapperspb.UInt32Value {
	if x != nil {
		return x.EnforcingConsecutive_5Xx
	}
	return nil
}

func (x *OutlierDetection) GetMaxEjectionPercent() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxEjectionPercent
	}
	return nil
}

func (x *OutlierDetection) GetBaseEjectionTime() *durationpb.Duration {
	if x != nil {
		return x.BaseEjectionTime
	}
	return nil
}

type UpstreamConnectionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TcpKeepaliveTime     *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=tcp_keepalive_time,json=tcpKeepaliveTime,proto3" json:"tcp_keepalive_time,omitempty"`
	TcpKeepaliveInterval *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=tcp_keepalive_interval,json=tcpKeepaliveInterval,proto3" json:"tcp_keepalive_interval,omitempty"`
	TcpKeepaliveProbes   *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=tcp_keepalive_probes,json=tcpKeepaliveProbes,proto3" json:"tcp_keepalive_probes,omitempty"`
}

func (x *UpstreamConnectionOptions) Reset() {
	*x = UpstreamConnectionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamConnectionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamConnectionOptions) ProtoMessage() {}

func (x *UpstreamConnectionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamConnectionOptions.ProtoReflect.Descriptor instead.
func (*UpstreamConnectionOptions) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{22}
}

func (x *UpstreamConnectionOptions) GetTcpKeepaliveTime() *wrapperspb.UInt32Value {
	if x != nil {
		return x.TcpKeepaliveTime
	}
	return nil
}

func (x *UpstreamConnectionOptions) GetTcpKeepaliveInterval() *wrapperspb.UInt32Value {
	if x != nil {
		return x.TcpKeepaliveInterval
	}
	return nil
}

func (x *UpstreamConnectionOptions) GetTcpKeepaliveProbes() *wrapperspb.UInt32Value {
	if x != nil {
		return x.TcpKeepaliveProbes
	}
	return nil
}

type PassthroughEndpointGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +kubebuilder:validation:Format=duration
	ConnectTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
}

func (x *PassthroughEndpointGroupConfig) Reset() {
	*x = PassthroughEndpointGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PassthroughEndpointGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PassthroughEndpointGroupConfig) ProtoMessage() {}

func (x *PassthroughEndpointGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PassthroughEndpointGroupConfig.ProtoReflect.Descriptor instead.
func (*PassthroughEndpointGroupConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{23}
}

func (x *PassthroughEndpointGroupConfig) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

type DNSEndpointGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +kubebuilder:validation:Format=duration
	ConnectTimeout            *durationpb.Duration       `protobuf:"bytes,1,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	DisablePanicThreshold     bool                       `protobuf:"varint,2,opt,name=disable_panic_threshold,json=disablePanicThreshold,proto3" json:"disable_panic_threshold,omitempty"`
	DiscoveryType             DiscoveryType              `protobuf:"varint,3,opt,name=discovery_type,json=discoveryType,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.DiscoveryType" json:"discovery_type,omitempty"`
	CircuitBreakers           *CircuitBreakers           `protobuf:"bytes,4,opt,name=circuit_breakers,json=circuitBreakers,proto3" json:"circuit_breakers,omitempty"`
	OutlierDetection          *OutlierDetection          `protobuf:"bytes,5,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	UpstreamConnectionOptions *UpstreamConnectionOptions `protobuf:"bytes,6,opt,name=upstream_connection_options,json=upstreamConnectionOptions,proto3" json:"upstream_connection_options,omitempty"`
	UseAltStatName            bool                       `protobuf:"varint,7,opt,name=use_alt_stat_name,json=useAltStatName,proto3" json:"use_alt_stat_name,omitempty"`
}

func (x *DNSEndpointGroupConfig) Reset() {
	*x = DNSEndpointGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DNSEndpointGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNSEndpointGroupConfig) ProtoMessage() {}

func (x *DNSEndpointGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNSEndpointGroupConfig.ProtoReflect.Descriptor instead.
func (*DNSEndpointGroupConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{24}
}

func (x *DNSEndpointGroupConfig) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *DNSEndpointGroupConfig) GetDisablePanicThreshold() bool {
	if x != nil {
		return x.DisablePanicThreshold
	}
	return false
}

func (x *DNSEndpointGroupConfig) GetDiscoveryType() DiscoveryType {
	if x != nil {
		return x.DiscoveryType
	}
	return DiscoveryType_DISCOVERY_TYPE_LOGICAL
}

func (x *DNSEndpointGroupConfig) GetCircuitBreakers() *CircuitBreakers {
	if x != nil {
		return x.CircuitBreakers
	}
	return nil
}

func (x *DNSEndpointGroupConfig) GetOutlierDetection() *OutlierDetection {
	if x != nil {
		return x.OutlierDetection
	}
	return nil
}

func (x *DNSEndpointGroupConfig) GetUpstreamConnectionOptions() *UpstreamConnectionOptions {
	if x != nil {
		return x.UpstreamConnectionOptions
	}
	return nil
}

func (x *DNSEndpointGroupConfig) GetUseAltStatName() bool {
	if x != nil {
		return x.UseAltStatName
	}
	return false
}

type StaticEndpointGroupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +kubebuilder:validation:Format=duration
	ConnectTimeout  *durationpb.Duration `protobuf:"bytes,1,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	CircuitBreakers *CircuitBreakers     `protobuf:"bytes,2,opt,name=circuit_breakers,json=circuitBreakers,proto3" json:"circuit_breakers,omitempty"`
}

func (x *StaticEndpointGroupConfig) Reset() {
	*x = StaticEndpointGroupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticEndpointGroupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticEndpointGroupConfig) ProtoMessage() {}

func (x *StaticEndpointGroupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticEndpointGroupConfig.ProtoReflect.Descriptor instead.
func (*StaticEndpointGroupConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP(), []int{25}
}

func (x *StaticEndpointGroupConfig) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *StaticEndpointGroupConfig) GetCircuitBreakers() *CircuitBreakers {
	if x != nil {
		return x.CircuitBreakers
	}
	return nil
}

var File_pbmesh_v2beta1_pbproxystate_cluster_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDesc = []byte{
	0x0a, 0x29, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x70, 0x62, 0x6d,
	0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9f, 0x03, 0x0a, 0x07,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x0e, 0x66,
	0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00,
	0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x62, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x48, 0x00, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x19, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x5f, 0x68, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6a, 0x73, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x48, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x22,
	0x0a, 0x0d, 0x61, 0x6c, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x50, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xcc, 0x01,
	0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x62, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x57, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x84, 0x01, 0x0a,
	0x13, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x11, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0e, 0x75, 0x73, 0x65, 0x41, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x42, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x22, 0xa1, 0x03, 0x0a, 0x0d, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x07, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x07,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x12, 0x59, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x63, 0x12, 0x50, 0x0a, 0x03, 0x64, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x4e, 0x53,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52,
	0x03, 0x64, 0x6e, 0x73, 0x12, 0x68, 0x0a, 0x0b, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75,
	0x67, 0x68, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48,
	0x00, 0x52, 0x0b, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x42, 0x07,
	0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xd6, 0x01, 0x0a, 0x14, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x5e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5e, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x6c, 0x73,
	0x22, 0xde, 0x01, 0x0a, 0x18, 0x50, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x62, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x74,
	0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5e, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x6c,
	0x73, 0x22, 0xce, 0x01, 0x0a, 0x10, 0x44, 0x4e, 0x53, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x44, 0x4e, 0x53, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5e, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54,
	0x6c, 0x73, 0x22, 0x74, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5d, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x28, 0x0a, 0x12, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x7e, 0x0a, 0x16, 0x4c, 0x34, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x64, 0x0a, 0x08,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x34, 0x57, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x22, 0x7e, 0x0a, 0x16, 0x4c, 0x37, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x64, 0x0a, 0x08,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x37, 0x57, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x22, 0x68, 0x0a, 0x1c, 0x4c, 0x34, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x22, 0xcf, 0x01, 0x0a,
	0x1c, 0x4c, 0x37, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x34, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x80,
	0x08, 0x0a, 0x1a, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x6e,
	0x69, 0x63, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x15, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x6e, 0x69, 0x63,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x67, 0x0a, 0x0d, 0x6c, 0x65, 0x61,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x42,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x61, 0x0a, 0x0b, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x62, 0x69,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x6f, 0x75,
	0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x52, 0x6f, 0x62, 0x69, 0x6e, 0x12, 0x54, 0x0a, 0x06, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x4c, 0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x61, 0x6e, 0x64, 0x6f,
	0x6d, 0x48, 0x00, 0x52, 0x06, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x12, 0x5b, 0x0a, 0x09, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x42, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x48, 0x00, 0x52, 0x08,
	0x72, 0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x12, 0x54, 0x0a, 0x06, 0x6d, 0x61, 0x67, 0x6c,
	0x65, 0x76, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x61,
	0x67, 0x6c, 0x65, 0x76, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x61, 0x67, 0x6c, 0x65, 0x76, 0x12, 0x66,
	0x0a, 0x10, 0x63, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x65,
	0x72, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x42, 0x72, 0x65,
	0x61, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x0f, 0x63, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x69, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x6c, 0x69, 0x65,
	0x72, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4f,
	0x75, 0x74, 0x6c, 0x69, 0x65, 0x72, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x6f, 0x75, 0x74, 0x6c, 0x69, 0x65, 0x72, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x85, 0x01, 0x0a, 0x1b, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x19,
	0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x11, 0x75, 0x73, 0x65,
	0x5f, 0x61, 0x6c, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x62, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x57, 0x0a, 0x14, 0x4c, 0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x65, 0x61,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x0c, 0x63, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63,
	0x68, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x14, 0x0a, 0x12, 0x4c, 0x42,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69, 0x6e,
	0x22, 0x10, 0x0a, 0x0e, 0x4c, 0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x61, 0x6e, 0x64,
	0x6f, 0x6d, 0x22, 0xa6, 0x01, 0x0a, 0x10, 0x4c, 0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x12, 0x48, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x48, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x10, 0x0a, 0x0e, 0x4c,
	0x42, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4d, 0x61, 0x67, 0x6c, 0x65, 0x76, 0x22, 0x76, 0x0a,
	0x0f, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73,
	0x12, 0x63, 0x0a, 0x0f, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0e, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x22, 0xfd, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0e, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x4e, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6d, 0x61, 0x78,
	0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12,
	0x54, 0x0a, 0x17, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15,
	0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x83, 0x03, 0x0a, 0x10, 0x4f, 0x75, 0x74, 0x6c, 0x69, 0x65,
	0x72, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x08, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x35, 0x78, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x76, 0x65, 0x35, 0x78, 0x78, 0x12, 0x58, 0x0a, 0x19, 0x65, 0x6e, 0x66, 0x6f,
	0x72, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x35, 0x78, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x65, 0x6e, 0x66, 0x6f, 0x72,
	0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65, 0x35,
	0x78, 0x78, 0x12, 0x4e, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12,
	0x6d, 0x61, 0x78, 0x45, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x12, 0x47, 0x0a, 0x12, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x65, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x8b, 0x02, 0x0a, 0x19,
	0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x12, 0x74, 0x63, 0x70,
	0x5f, 0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x10, 0x74, 0x63, 0x70, 0x4b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x16, 0x74, 0x63, 0x70, 0x5f, 0x6b, 0x65, 0x65,
	0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x14, 0x74, 0x63, 0x70, 0x4b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x4e, 0x0a, 0x14, 0x74, 0x63, 0x70,
	0x5f, 0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x74, 0x63, 0x70, 0x4b, 0x65, 0x65, 0x70, 0x61, 0x6c,
	0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x1e, 0x50, 0x61, 0x73,
	0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22,
	0xfc, 0x04, 0x0a, 0x16, 0x44, 0x4e, 0x53, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x0f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x36,
	0x0a, 0x17, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x6e, 0x69, 0x63, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x6e, 0x69, 0x63, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x60, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x66, 0x0a, 0x10, 0x63, 0x69, 0x72, 0x63,
	0x75, 0x69, 0x74, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x52,
	0x0f, 0x63, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73,
	0x12, 0x69, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x6c, 0x69, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4f, 0x75, 0x74, 0x6c, 0x69, 0x65, 0x72,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x6c, 0x69,
	0x65, 0x72, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a, 0x1b,
	0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x55,
	0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x19, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x11, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x75, 0x73, 0x65, 0x41, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc7,
	0x01, 0x0a, 0x19, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x0f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x12, 0x66, 0x0a, 0x10, 0x63, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x5f, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x0f, 0x63, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x2a, 0x46, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x49, 0x53,
	0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x4f, 0x47, 0x49,
	0x43, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45,
	0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x10, 0x01,
	0x42, 0xd2, 0x02, 0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x0c, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x2f, 0x70, 0x62,
	0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xa2, 0x02, 0x05, 0x48, 0x43, 0x4d, 0x56,
	0x50, 0xaa, 0x02, 0x2a, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xca, 0x02,
	0x2a, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x50,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xe2, 0x02, 0x36, 0x48, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d,
	0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x50, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73, 0x68, 0x3a, 0x3a,
	0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3a, 0x3a, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescData = file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDesc
)

func file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDescData
}

var file_pbmesh_v2beta1_pbproxystate_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_pbmesh_v2beta1_pbproxystate_cluster_proto_goTypes = []interface{}{
	(DiscoveryType)(0),                     // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.DiscoveryType
	(*Cluster)(nil),                        // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.Cluster
	(*FailoverGroup)(nil),                  // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroup
	(*FailoverGroupConfig)(nil),            // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroupConfig
	(*EndpointGroup)(nil),                  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup
	(*DynamicEndpointGroup)(nil),           // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroup
	(*PassthroughEndpointGroup)(nil),       // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroup
	(*DNSEndpointGroup)(nil),               // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroup
	(*StaticEndpointGroup)(nil),            // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroup
	(*DestinationCluster)(nil),             // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationCluster
	(*L4WeightedClusterGroup)(nil),         // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedClusterGroup
	(*L7WeightedClusterGroup)(nil),         // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedClusterGroup
	(*L4WeightedDestinationCluster)(nil),   // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedDestinationCluster
	(*L7WeightedDestinationCluster)(nil),   // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedDestinationCluster
	(*DynamicEndpointGroupConfig)(nil),     // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig
	(*LBPolicyLeastRequest)(nil),           // 15: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyLeastRequest
	(*LBPolicyRoundRobin)(nil),             // 16: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRoundRobin
	(*LBPolicyRandom)(nil),                 // 17: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRandom
	(*LBPolicyRingHash)(nil),               // 18: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRingHash
	(*LBPolicyMaglev)(nil),                 // 19: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyMaglev
	(*CircuitBreakers)(nil),                // 20: hashicorp.consul.mesh.v2beta1.pbproxystate.CircuitBreakers
	(*UpstreamLimits)(nil),                 // 21: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamLimits
	(*OutlierDetection)(nil),               // 22: hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection
	(*UpstreamConnectionOptions)(nil),      // 23: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamConnectionOptions
	(*PassthroughEndpointGroupConfig)(nil), // 24: hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroupConfig
	(*DNSEndpointGroupConfig)(nil),         // 25: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig
	(*StaticEndpointGroupConfig)(nil),      // 26: hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroupConfig
	(Protocol)(0),                          // 27: hashicorp.consul.mesh.v2beta1.pbproxystate.Protocol
	(*durationpb.Duration)(nil),            // 28: google.protobuf.Duration
	(*TransportSocket)(nil),                // 29: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	(*wrapperspb.UInt32Value)(nil),         // 30: google.protobuf.UInt32Value
	(*HeaderMutation)(nil),                 // 31: hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMutation
	(*wrapperspb.UInt64Value)(nil),         // 32: google.protobuf.UInt64Value
}
var file_pbmesh_v2beta1_pbproxystate_cluster_proto_depIdxs = []int32{
	2,  // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.Cluster.failover_group:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroup
	4,  // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.Cluster.endpoint_group:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup
	27, // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.Cluster.protocol:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.Protocol
	4,  // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroup.endpoint_groups:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup
	3,  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroup.config:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroupConfig
	28, // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.FailoverGroupConfig.connect_timeout:type_name -> google.protobuf.Duration
	5,  // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup.dynamic:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroup
	8,  // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup.static:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroup
	7,  // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup.dns:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroup
	6,  // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointGroup.passthrough:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroup
	14, // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroup.config:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig
	29, // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroup.outbound_tls:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	24, // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroup.config:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroupConfig
	29, // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroup.outbound_tls:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	25, // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroup.config:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig
	29, // 15: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroup.outbound_tls:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	26, // 16: hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroup.config:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroupConfig
	12, // 17: hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedClusterGroup.clusters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedDestinationCluster
	13, // 18: hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedClusterGroup.clusters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedDestinationCluster
	30, // 19: hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedDestinationCluster.weight:type_name -> google.protobuf.UInt32Value
	30, // 20: hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedDestinationCluster.weight:type_name -> google.protobuf.UInt32Value
	31, // 21: hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedDestinationCluster.header_mutations:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMutation
	28, // 22: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.connect_timeout:type_name -> google.protobuf.Duration
	15, // 23: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.least_request:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyLeastRequest
	16, // 24: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.round_robin:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRoundRobin
	17, // 25: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.random:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRandom
	18, // 26: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.ring_hash:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRingHash
	19, // 27: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.maglev:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyMaglev
	20, // 28: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.circuit_breakers:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.CircuitBreakers
	22, // 29: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.outlier_detection:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection
	23, // 30: hashicorp.consul.mesh.v2beta1.pbproxystate.DynamicEndpointGroupConfig.upstream_connection_options:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamConnectionOptions
	30, // 31: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyLeastRequest.choice_count:type_name -> google.protobuf.UInt32Value
	32, // 32: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRingHash.minimum_ring_size:type_name -> google.protobuf.UInt64Value
	32, // 33: hashicorp.consul.mesh.v2beta1.pbproxystate.LBPolicyRingHash.maximum_ring_size:type_name -> google.protobuf.UInt64Value
	21, // 34: hashicorp.consul.mesh.v2beta1.pbproxystate.CircuitBreakers.upstream_limits:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamLimits
	30, // 35: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamLimits.max_connections:type_name -> google.protobuf.UInt32Value
	30, // 36: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamLimits.max_pending_requests:type_name -> google.protobuf.UInt32Value
	30, // 37: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamLimits.max_concurrent_requests:type_name -> google.protobuf.UInt32Value
	28, // 38: hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection.interval:type_name -> google.protobuf.Duration
	30, // 39: hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection.consecutive_5xx:type_name -> google.protobuf.UInt32Value
	30, // 40: hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection.enforcing_consecutive_5xx:type_name -> google.protobuf.UInt32Value
	30, // 41: hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection.max_ejection_percent:type_name -> google.protobuf.UInt32Value
	28, // 42: hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection.base_ejection_time:type_name -> google.protobuf.Duration
	30, // 43: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamConnectionOptions.tcp_keepalive_time:type_name -> google.protobuf.UInt32Value
	30, // 44: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamConnectionOptions.tcp_keepalive_interval:type_name -> google.protobuf.UInt32Value
	30, // 45: hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamConnectionOptions.tcp_keepalive_probes:type_name -> google.protobuf.UInt32Value
	28, // 46: hashicorp.consul.mesh.v2beta1.pbproxystate.PassthroughEndpointGroupConfig.connect_timeout:type_name -> google.protobuf.Duration
	28, // 47: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig.connect_timeout:type_name -> google.protobuf.Duration
	0,  // 48: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig.discovery_type:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DiscoveryType
	20, // 49: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig.circuit_breakers:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.CircuitBreakers
	22, // 50: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig.outlier_detection:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.OutlierDetection
	23, // 51: hashicorp.consul.mesh.v2beta1.pbproxystate.DNSEndpointGroupConfig.upstream_connection_options:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.UpstreamConnectionOptions
	28, // 52: hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroupConfig.connect_timeout:type_name -> google.protobuf.Duration
	20, // 53: hashicorp.consul.mesh.v2beta1.pbproxystate.StaticEndpointGroupConfig.circuit_breakers:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.CircuitBreakers
	54, // [54:54] is the sub-list for method output_type
	54, // [54:54] is the sub-list for method input_type
	54, // [54:54] is the sub-list for extension type_name
	54, // [54:54] is the sub-list for extension extendee
	0,  // [0:54] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_pbproxystate_cluster_proto_init() }
func file_pbmesh_v2beta1_pbproxystate_cluster_proto_init() {
	if File_pbmesh_v2beta1_pbproxystate_cluster_proto != nil {
		return
	}
	file_pbmesh_v2beta1_pbproxystate_header_mutations_proto_init()
	file_pbmesh_v2beta1_pbproxystate_protocol_proto_init()
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailoverGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailoverGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndpointGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicEndpointGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PassthroughEndpointGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DNSEndpointGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticEndpointGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L4WeightedClusterGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L7WeightedClusterGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L4WeightedDestinationCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L7WeightedDestinationCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicEndpointGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LBPolicyLeastRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LBPolicyRoundRobin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LBPolicyRandom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LBPolicyRingHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LBPolicyMaglev); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CircuitBreakers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpstreamLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutlierDetection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpstreamConnectionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PassthroughEndpointGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DNSEndpointGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticEndpointGroupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Cluster_FailoverGroup)(nil),
		(*Cluster_EndpointGroup)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*EndpointGroup_Dynamic)(nil),
		(*EndpointGroup_Static)(nil),
		(*EndpointGroup_Dns)(nil),
		(*EndpointGroup_Passthrough)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*DynamicEndpointGroupConfig_LeastRequest)(nil),
		(*DynamicEndpointGroupConfig_RoundRobin)(nil),
		(*DynamicEndpointGroupConfig_Random)(nil),
		(*DynamicEndpointGroupConfig_RingHash)(nil),
		(*DynamicEndpointGroupConfig_Maglev)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_pbproxystate_cluster_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_pbproxystate_cluster_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_pbproxystate_cluster_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_pbproxystate_cluster_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_pbproxystate_cluster_proto = out.File
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_rawDesc = nil
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_goTypes = nil
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_depIdxs = nil
}
