package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TaobaoFilmGetHotShows invokes the appmallsservice.TaobaoFilmGetHotShows API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgethotshows.html
func (client *Client) TaobaoFilmGetHotShows(request *TaobaoFilmGetHotShowsRequest) (response *TaobaoFilmGetHotShowsResponse, err error) {
	response = CreateTaobaoFilmGetHotShowsResponse()
	err = client.DoAction(request, response)
	return
}

// TaobaoFilmGetHotShowsWithChan invokes the appmallsservice.TaobaoFilmGetHotShows API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgethotshows.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetHotShowsWithChan(request *TaobaoFilmGetHotShowsRequest) (<-chan *TaobaoFilmGetHotShowsResponse, <-chan error) {
	responseChan := make(chan *TaobaoFilmGetHotShowsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TaobaoFilmGetHotShows(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TaobaoFilmGetHotShowsWithCallback invokes the appmallsservice.TaobaoFilmGetHotShows API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgethotshows.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetHotShowsWithCallback(request *TaobaoFilmGetHotShowsRequest, callback func(response *TaobaoFilmGetHotShowsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TaobaoFilmGetHotShowsResponse
		var err error
		defer close(result)
		response, err = client.TaobaoFilmGetHotShows(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TaobaoFilmGetHotShowsRequest is the request struct for api TaobaoFilmGetHotShows
type TaobaoFilmGetHotShowsRequest struct {
	*requests.RpcRequest
	CityCode   requests.Integer `position:"Query" name:"CityCode"`
	ParamsJson string           `position:"Query" name:"ParamsJson"`
}

// TaobaoFilmGetHotShowsResponse is the response struct for api TaobaoFilmGetHotShows
type TaobaoFilmGetHotShowsResponse struct {
	*responses.BaseResponse
	ErrorCode string      `json:"ErrorCode" xml:"ErrorCode"`
	Msg       string      `json:"Msg" xml:"Msg"`
	SubCode   string      `json:"SubCode" xml:"SubCode"`
	SubMsg    string      `json:"SubMsg" xml:"SubMsg"`
	LogsId    string      `json:"LogsId" xml:"LogsId"`
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Shows     []ShowsItem `json:"Shows" xml:"Shows"`
}

// CreateTaobaoFilmGetHotShowsRequest creates a request to invoke TaobaoFilmGetHotShows API
func CreateTaobaoFilmGetHotShowsRequest() (request *TaobaoFilmGetHotShowsRequest) {
	request = &TaobaoFilmGetHotShowsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "TaobaoFilmGetHotShows", "", "")
	return
}

// CreateTaobaoFilmGetHotShowsResponse creates a response to parse from TaobaoFilmGetHotShows response
func CreateTaobaoFilmGetHotShowsResponse() (response *TaobaoFilmGetHotShowsResponse) {
	response = &TaobaoFilmGetHotShowsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
