package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CollectedVnNumber invokes the cloudcallcenter.CollectedVnNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/collectedvnnumber.html
func (client *Client) CollectedVnNumber(request *CollectedVnNumberRequest) (response *CollectedVnNumberResponse, err error) {
	response = CreateCollectedVnNumberResponse()
	err = client.DoAction(request, response)
	return
}

// CollectedVnNumberWithChan invokes the cloudcallcenter.CollectedVnNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/collectedvnnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CollectedVnNumberWithChan(request *CollectedVnNumberRequest) (<-chan *CollectedVnNumberResponse, <-chan error) {
	responseChan := make(chan *CollectedVnNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CollectedVnNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CollectedVnNumberWithCallback invokes the cloudcallcenter.CollectedVnNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/collectedvnnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CollectedVnNumberWithCallback(request *CollectedVnNumberRequest, callback func(response *CollectedVnNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CollectedVnNumberResponse
		var err error
		defer close(result)
		response, err = client.CollectedVnNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CollectedVnNumberRequest is the request struct for api CollectedVnNumber
type CollectedVnNumberRequest struct {
	*requests.RpcRequest
	ConversationId string `position:"Query" name:"ConversationId"`
	Number         string `position:"Query" name:"Number"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// CollectedVnNumberResponse is the response struct for api CollectedVnNumber
type CollectedVnNumberResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TextResponse  string `json:"TextResponse" xml:"TextResponse"`
	Interruptible bool   `json:"Interruptible" xml:"Interruptible"`
	Action        string `json:"Action" xml:"Action"`
	ActionParams  string `json:"ActionParams" xml:"ActionParams"`
}

// CreateCollectedVnNumberRequest creates a request to invoke CollectedVnNumber API
func CreateCollectedVnNumberRequest() (request *CollectedVnNumberRequest) {
	request = &CollectedVnNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CollectedVnNumber", "", "")
	request.Method = requests.GET
	return
}

// CreateCollectedVnNumberResponse creates a response to parse from CollectedVnNumber response
func CreateCollectedVnNumberResponse() (response *CollectedVnNumberResponse) {
	response = &CollectedVnNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
