package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaTableThemeLevel invokes the dataworks_public.GetMetaTableThemeLevel API synchronously
func (client *Client) GetMetaTableThemeLevel(request *GetMetaTableThemeLevelRequest) (response *GetMetaTableThemeLevelResponse, err error) {
	response = CreateGetMetaTableThemeLevelResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaTableThemeLevelWithChan invokes the dataworks_public.GetMetaTableThemeLevel API asynchronously
func (client *Client) GetMetaTableThemeLevelWithChan(request *GetMetaTableThemeLevelRequest) (<-chan *GetMetaTableThemeLevelResponse, <-chan error) {
	responseChan := make(chan *GetMetaTableThemeLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaTableThemeLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaTableThemeLevelWithCallback invokes the dataworks_public.GetMetaTableThemeLevel API asynchronously
func (client *Client) GetMetaTableThemeLevelWithCallback(request *GetMetaTableThemeLevelRequest, callback func(response *GetMetaTableThemeLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaTableThemeLevelResponse
		var err error
		defer close(result)
		response, err = client.GetMetaTableThemeLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaTableThemeLevelRequest is the request struct for api GetMetaTableThemeLevel
type GetMetaTableThemeLevelRequest struct {
	*requests.RpcRequest
	DataSourceType string `position:"Query" name:"DataSourceType"`
	TableGuid      string `position:"Query" name:"TableGuid"`
}

// GetMetaTableThemeLevelResponse is the response struct for api GetMetaTableThemeLevel
type GetMetaTableThemeLevelResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool   `json:"Success" xml:"Success"`
	Entity         Entity `json:"Entity" xml:"Entity"`
}

// CreateGetMetaTableThemeLevelRequest creates a request to invoke GetMetaTableThemeLevel API
func CreateGetMetaTableThemeLevelRequest() (request *GetMetaTableThemeLevelRequest) {
	request = &GetMetaTableThemeLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaTableThemeLevel", "", "")
	request.Method = requests.GET
	return
}

// CreateGetMetaTableThemeLevelResponse creates a response to parse from GetMetaTableThemeLevel response
func CreateGetMetaTableThemeLevelResponse() (response *GetMetaTableThemeLevelResponse) {
	response = &GetMetaTableThemeLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
