package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthenticators invokes the idaas_doraemon.ListAuthenticators API synchronously
func (client *Client) ListAuthenticators(request *ListAuthenticatorsRequest) (response *ListAuthenticatorsResponse, err error) {
	response = CreateListAuthenticatorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthenticatorsWithChan invokes the idaas_doraemon.ListAuthenticators API asynchronously
func (client *Client) ListAuthenticatorsWithChan(request *ListAuthenticatorsRequest) (<-chan *ListAuthenticatorsResponse, <-chan error) {
	responseChan := make(chan *ListAuthenticatorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthenticators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthenticatorsWithCallback invokes the idaas_doraemon.ListAuthenticators API asynchronously
func (client *Client) ListAuthenticatorsWithCallback(request *ListAuthenticatorsRequest, callback func(response *ListAuthenticatorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthenticatorsResponse
		var err error
		defer close(result)
		response, err = client.ListAuthenticators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthenticatorsRequest is the request struct for api ListAuthenticators
type ListAuthenticatorsRequest struct {
	*requests.RpcRequest
	UserId                string           `position:"Query" name:"UserId"`
	PageNumber            requests.Integer `position:"Query" name:"PageNumber"`
	PageSize              requests.Integer `position:"Query" name:"PageSize"`
	AuthenticatorType     string           `position:"Query" name:"AuthenticatorType"`
	ApplicationExternalId string           `position:"Query" name:"ApplicationExternalId"`
}

// ListAuthenticatorsResponse is the response struct for api ListAuthenticators
type ListAuthenticatorsResponse struct {
	*responses.BaseResponse
	RequestId     string                 `json:"RequestId" xml:"RequestId"`
	PageNumber    int64                  `json:"PageNumber" xml:"PageNumber"`
	TotalCount    int64                  `json:"TotalCount" xml:"TotalCount"`
	PageSize      int64                  `json:"PageSize" xml:"PageSize"`
	Authenticator []AuthenticatorListDTO `json:"Authenticator" xml:"Authenticator"`
}

// CreateListAuthenticatorsRequest creates a request to invoke ListAuthenticators API
func CreateListAuthenticatorsRequest() (request *ListAuthenticatorsRequest) {
	request = &ListAuthenticatorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "ListAuthenticators", "", "")
	request.Method = requests.POST
	return
}

// CreateListAuthenticatorsResponse creates a response to parse from ListAuthenticators response
func CreateListAuthenticatorsResponse() (response *ListAuthenticatorsResponse) {
	response = &ListAuthenticatorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
