# Security Policy

## Supported Versions

We support the latest version of this library. We do not guarantee support of previous versions. If a defect is reported, it will generally be fixed on the latest version 
(provided it exists) irrespective of whether it was introduced in a prior version.

## Reporting a Vulnerability

If you discover a vulnerability against this package, please report it in the issues tab with a `vulnerability` label. We will examine promptly.

If you would like to disclose the vulnerability privately, you may reach the maintainers in our [channel](https://gophers.slack.com/archives/CBP4N9BEU) on the gophers slack.

## Security Scorecard

This project submits security [results](https://scorecard.dev/viewer/?uri=github.com/gofrs/uuid) to the [OpenSSF Scorecard](https://securityscorecards.dev/). 

### Actively Maintained

One heuristic these scorecards measure to gauge whether a package is safe for consumption is an "Actively Maintained" metric. Because this library implements UUIDs,
it is very stable - there is not much maintenance required other than adding/updating newer UUID versions, keeping up to date with latest versions of Go, and responding
to reported exploits. As a result, periods of low active maintenance are to be expected. 
