/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.ConfigurableUserClassFilePermissions;
import org.gradle.api.internal.file.AbstractFilePermissions;
import org.gradle.api.internal.file.ConfigurableUserClassFilePermissionsInternal;
import org.gradle.api.internal.file.DefaultConfigurableUserClassFilePermissions;
import org.gradle.api.model.ObjectFactory;

public class DefaultConfigurableFilePermissions
extends AbstractFilePermissions
implements ConfigurableFilePermissions {
    private final ConfigurableUserClassFilePermissionsInternal user;
    private final ConfigurableUserClassFilePermissionsInternal group;
    private final ConfigurableUserClassFilePermissionsInternal other;

    public static int getDefaultUnixNumeric(boolean isDirectory) {
        return isDirectory ? 493 : 420;
    }

    @Inject
    public DefaultConfigurableFilePermissions(ObjectFactory objectFactory, int unixNumeric) {
        this.user = (ConfigurableUserClassFilePermissionsInternal)objectFactory.newInstance(DefaultConfigurableUserClassFilePermissions.class, new Object[]{DefaultConfigurableFilePermissions.getUserPartOf(unixNumeric)});
        this.group = (ConfigurableUserClassFilePermissionsInternal)objectFactory.newInstance(DefaultConfigurableUserClassFilePermissions.class, new Object[]{DefaultConfigurableFilePermissions.getGroupPartOf(unixNumeric)});
        this.other = (ConfigurableUserClassFilePermissionsInternal)objectFactory.newInstance(DefaultConfigurableUserClassFilePermissions.class, new Object[]{DefaultConfigurableFilePermissions.getOtherPartOf(unixNumeric)});
    }

    public ConfigurableUserClassFilePermissions getUser() {
        return this.user;
    }

    public void user(Action<? super ConfigurableUserClassFilePermissions> configureAction) {
        configureAction.execute((Object)this.user);
    }

    public ConfigurableUserClassFilePermissions getGroup() {
        return this.group;
    }

    public void group(Action<? super ConfigurableUserClassFilePermissions> configureAction) {
        configureAction.execute((Object)this.group);
    }

    public ConfigurableUserClassFilePermissions getOther() {
        return this.other;
    }

    public void other(Action<? super ConfigurableUserClassFilePermissions> configureAction) {
        configureAction.execute((Object)this.other);
    }

    public void unix(String unixNumericOrSymbolic) {
        try {
            String normalizedPermissions = DefaultConfigurableFilePermissions.normalizeUnixPermissions(unixNumericOrSymbolic);
            if (normalizedPermissions.length() == 3) {
                this.unix(DefaultConfigurableFilePermissions.toUnixNumericPermissions(normalizedPermissions));
            } else {
                this.user.unix(DefaultConfigurableFilePermissions.getUserPartOf(normalizedPermissions));
                this.group.unix(DefaultConfigurableFilePermissions.getGroupPartOf(normalizedPermissions));
                this.other.unix(DefaultConfigurableFilePermissions.getOtherPartOf(normalizedPermissions));
            }
        }
        catch (IllegalArgumentException cause) {
            throw new InvalidUserDataException("'" + unixNumericOrSymbolic + "' isn't a proper Unix permission. " + cause.getMessage());
        }
    }

    public void unix(int unixNumeric) {
        if (unixNumeric < 0 || unixNumeric >= 512) {
            throw new IllegalArgumentException(unixNumeric + " is not a valid unix numeric permission from the range of [0, 512)");
        }
        this.user.unix(DefaultConfigurableFilePermissions.getUserPartOf(unixNumeric));
        this.group.unix(DefaultConfigurableFilePermissions.getGroupPartOf(unixNumeric));
        this.other.unix(DefaultConfigurableFilePermissions.getOtherPartOf(unixNumeric));
    }

    private static String normalizeUnixPermissions(String permissions) {
        String trimmed = permissions.trim();
        if (trimmed.length() == 4 && trimmed.startsWith("0")) {
            return trimmed.substring(1);
        }
        if (trimmed.length() != 3 && trimmed.length() != 9) {
            throw new IllegalArgumentException("Trimmed length must be either 3 (for numeric notation) or 9 (for symbolic notation).");
        }
        return trimmed;
    }

    private static int toUnixNumericPermissions(String permissions) {
        try {
            return Integer.parseInt(permissions, 8);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't be parsed as octal number.");
        }
    }
}

