/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaExecutableUtils;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;

public abstract class SpecificInstallationToolchainSpec
extends DefaultToolchainSpec {
    private final File javaHome;

    @Inject
    public SpecificInstallationToolchainSpec(File javaHome) {
        this.javaHome = javaHome;
        this.finalizeProperties();
    }

    public static SpecificInstallationToolchainSpec fromJavaHome(ObjectFactory objectFactory, File javaHome) {
        if (javaHome.exists()) {
            if (javaHome.isDirectory()) {
                return (SpecificInstallationToolchainSpec)((Object)objectFactory.newInstance(SpecificInstallationToolchainSpec.class, new Object[]{javaHome}));
            }
            throw new InvalidUserDataException("The configured Java home is not a directory (" + javaHome.getAbsolutePath() + ")");
        }
        throw new InvalidUserDataException("The configured Java home does not exist (" + javaHome.getAbsolutePath() + ")");
    }

    public static SpecificInstallationToolchainSpec fromJavaExecutable(ObjectFactory objectFactory, String executable) {
        return (SpecificInstallationToolchainSpec)((Object)objectFactory.newInstance(SpecificInstallationToolchainSpec.class, new Object[]{JavaExecutableUtils.resolveJavaHomeOfExecutable(executable)}));
    }

    public Key toKey() {
        return new Key(this.javaHome);
    }

    public boolean isConfigured() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public String getDisplayName() {
        return MoreObjects.toStringHelper((String)"SpecificToolchain ").add("javaHome", (Object)this.javaHome).toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static class Key
    implements JavaToolchainSpecInternal.Key {
        private final File javaHome;

        public Key(File javaHome) {
            this.javaHome = javaHome;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.javaHome, key.javaHome);
        }

        public int hashCode() {
            return Objects.hash(this.javaHome);
        }
    }
}

