/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.configurations.ProjectComponentObservationListener;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.BuildTreeLocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.event.ListenerManager;
import org.gradle.util.Path;

public class DefaultLocalComponentRegistry
implements LocalComponentRegistry {
    private final Path currentProjectPath;
    private final Path currentBuildPath;
    private final ProjectComponentObservationListener projectComponentObservationListener;
    private final BuildTreeLocalComponentProvider componentProvider;

    @Inject
    public DefaultLocalComponentRegistry(DomainObjectContext domainObjectContext, ListenerManager listenerManager, BuildTreeLocalComponentProvider componentProvider) {
        this.currentProjectPath = DefaultLocalComponentRegistry.getProjectBuildTreePath(domainObjectContext);
        this.currentBuildPath = domainObjectContext.getBuildPath();
        this.projectComponentObservationListener = (ProjectComponentObservationListener)listenerManager.getBroadcaster(ProjectComponentObservationListener.class);
        this.componentProvider = componentProvider;
    }

    @Override
    public LocalComponentGraphResolveState getComponent(ProjectComponentIdentifier projectIdentifier) {
        Path targetProjectPath = ((ProjectComponentIdentifierInternal)projectIdentifier).getIdentityPath();
        if (!targetProjectPath.equals((Object)this.currentProjectPath) && projectIdentifier.getBuild().getBuildPath().equals(this.currentBuildPath.getPath())) {
            this.projectComponentObservationListener.projectObserved(this.currentProjectPath, targetProjectPath);
        }
        return this.componentProvider.getComponent(projectIdentifier, this.currentBuildPath);
    }

    @Nullable
    private static Path getProjectBuildTreePath(DomainObjectContext domainObjectContext) {
        ProjectIdentity id = domainObjectContext.getProjectIdentity();
        if (id != null) {
            return id.getBuildTreePath();
        }
        return null;
    }
}

