/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflictFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Describables;
import org.gradle.internal.UncheckedException;

public class DefaultConflictHandler
implements ModuleConflictHandler {
    private static final Logger LOGGER = Logging.getLogger(DefaultConflictHandler.class);
    private final ModuleConflictResolver<ComponentState> resolver;
    private final ConflictContainer<ModuleIdentifier, ComponentState> conflicts = new ConflictContainer();
    private final ModuleReplacementsData moduleReplacements;

    public DefaultConflictHandler(ModuleConflictResolver<ComponentState> resolver, ModuleReplacementsData moduleReplacements) {
        this.resolver = resolver;
        this.moduleReplacements = moduleReplacements;
    }

    @Override
    public ModuleConflictResolver<ComponentState> getResolver() {
        return this.resolver;
    }

    @Override
    public PotentialConflict registerCandidate(CandidateModule candidate) {
        ModuleReplacementsData.Replacement replacement = this.moduleReplacements.getReplacementFor(candidate.getId());
        ModuleIdentifier replacedBy = replacement == null ? null : replacement.getTarget();
        return PotentialConflictFactory.potentialConflict(this.conflicts.newElement(candidate.getId(), candidate.getVersions(), replacedBy));
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        assert (this.hasConflicts());
        ConflictContainer.Conflict conflict = this.conflicts.popConflict();
        DefaultConflictResolverDetails details = new DefaultConflictResolverDetails(conflict.candidates);
        this.resolver.select(details);
        if (details.hasFailure()) {
            throw UncheckedException.throwAsUncheckedException((Throwable)details.getFailure());
        }
        ComponentResolutionState selected = (ComponentResolutionState)details.getSelected();
        DefaultConflictResolutionResult result = new DefaultConflictResolutionResult(conflict.participants, selected);
        resolutionAction.execute((Object)result);
        if (selected != null) {
            this.maybeSetReason(conflict.participants, selected);
        }
        LOGGER.debug("Selected {} from conflicting modules {}.", (Object)selected, conflict.candidates);
    }

    private void maybeSetReason(Set<ModuleIdentifier> partifipants, ComponentResolutionState selected) {
        for (ModuleIdentifier identifier : partifipants) {
            ModuleReplacementsData.Replacement replacement = this.moduleReplacements.getReplacementFor(identifier);
            if (replacement == null) continue;
            String reason = replacement.getReason();
            ComponentSelectionDescriptorInternal moduleReplacement = ComponentSelectionReasons.SELECTED_BY_RULE.withDescription((Describable)Describables.of((Object)identifier, (Object)"replaced with", (Object)replacement.getTarget()));
            if (reason != null) {
                moduleReplacement = moduleReplacement.withDescription((Describable)Describables.of((Object)reason));
            }
            selected.addCause(moduleReplacement);
        }
    }
}

