module CommandLine (
  get_args )
where

import System.Console.CmdArgs (
  (&=),
  cmdArgs,
  def,
  details,
  help,
  program,
  summary )


-- Get the version from Cabal.
import Paths_mailbox_count ( version )
import Data.Version ( showVersion )

import OptionalConfiguration (
  OptionalConfiguration(
    OptionalConfiguration,
    database,
    detail,
    detail_query,
    host,
    password,
    port,
    summary_query,
    username )
  )


description :: String
description = "Count mailboxes in a SQL database."

program_name :: String
program_name = "mailbox-count"

my_summary :: String
my_summary = program_name ++ "-" ++ (showVersion version)

database_help :: String
database_help =
  "The name of the database (or file, if SQLite) to which we should connect"

detail_help :: String
detail_help =
  "Produce a detailed report listing all mailboxes by domain"

detail_query_help :: String
detail_query_help =
  "SQL query used to produce the detail report"

host_help :: String
host_help =
  "Hostname where the database is located (postgres-only)"

password_help :: String
password_help =
  "Password used to connect to the database (postgres-only)"

port_help :: String
port_help =
  "Port number used to connect to the database (postgres-only)"

summary_query_help :: String
summary_query_help =
  "SQL query used to produce the summary report"

username_help :: String
username_help =
  "Username used to connect to the database (postgres-only)"

arg_spec :: OptionalConfiguration
arg_spec =
  OptionalConfiguration {
    database = def &= help database_help,
    detail   = def &= help detail_help,
    detail_query   = def &= help detail_query_help,
    host     = def &= help host_help,
    password = def &= help password_help,
    port     = def &= help port_help,
    summary_query   = def &= help summary_query_help,
    username = def &= help username_help }
    &= program program_name
    &= summary my_summary
    &= details [description]

get_args :: IO OptionalConfiguration
get_args = cmdArgs arg_spec
