/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef jit_MIROpsGenerated_h
#define jit_MIROpsGenerated_h

/* This file is generated by jit/GenerateMIRFiles.py. Do not edit! */

#define MIR_OPCODE_LIST(_)\
_(Start)\
_(OsrEntry)\
_(Nop)\
_(LimitedTruncate)\
_(Constant)\
_(WasmNullConstant)\
_(WasmFloatConstant)\
_(Parameter)\
_(Callee)\
_(IsConstructing)\
_(TableSwitch)\
_(Goto)\
_(Test)\
_(Return)\
_(Throw)\
_(ThrowWithStack)\
_(NewArray)\
_(NewArrayDynamicLength)\
_(NewTypedArray)\
_(NewTypedArrayDynamicLength)\
_(NewTypedArrayFromArray)\
_(NewTypedArrayFromArrayBuffer)\
_(NewObject)\
_(NewPlainObject)\
_(NewArrayObject)\
_(NewIterator)\
_(ObjectState)\
_(ArrayState)\
_(BindFunction)\
_(NewBoundFunction)\
_(BoundFunctionNumArgs)\
_(GuardBoundFunctionIsConstructor)\
_(MutateProto)\
_(InitPropGetterSetter)\
_(InitElemGetterSetter)\
_(Call)\
_(CallClassHook)\
_(ApplyArgs)\
_(ApplyArgsObj)\
_(ApplyArray)\
_(ConstructArgs)\
_(ConstructArray)\
_(Bail)\
_(Unreachable)\
_(EncodeSnapshot)\
_(AssertRecoveredOnBailout)\
_(AssertFloat32)\
_(Compare)\
_(SameValueDouble)\
_(SameValue)\
_(Box)\
_(Unbox)\
_(AssertRange)\
_(AssertClass)\
_(AssertShape)\
_(CreateThis)\
_(CreateArgumentsObject)\
_(CreateInlinedArgumentsObject)\
_(GetInlinedArgument)\
_(GetInlinedArgumentHole)\
_(GetArgumentsObjectArg)\
_(SetArgumentsObjectArg)\
_(LoadArgumentsObjectArg)\
_(LoadArgumentsObjectArgHole)\
_(InArgumentsObjectArg)\
_(ArgumentsObjectLength)\
_(ArrayFromArgumentsObject)\
_(GuardArgumentsObjectFlags)\
_(LoadScriptedProxyHandler)\
_(CheckScriptedProxyGetResult)\
_(IdToStringOrSymbol)\
_(ReturnFromCtor)\
_(ToDouble)\
_(ToFloat32)\
_(WasmUnsignedToDouble)\
_(WasmUnsignedToFloat32)\
_(WrapInt64ToInt32)\
_(ExtendInt32ToInt64)\
_(WasmBuiltinTruncateToInt64)\
_(WasmTruncateToInt64)\
_(WasmTruncateToInt32)\
_(WasmAnyRefFromJSValue)\
_(WasmAnyRefFromJSObject)\
_(WasmAnyRefFromJSString)\
_(WasmNewI31Ref)\
_(WasmI31RefGet)\
_(Int32ToIntPtr)\
_(NonNegativeIntPtrToInt32)\
_(IntPtrToDouble)\
_(AdjustDataViewLength)\
_(Int64ToFloatingPoint)\
_(BuiltinInt64ToFloatingPoint)\
_(ToNumberInt32)\
_(BooleanToInt32)\
_(TruncateToInt32)\
_(WasmBuiltinTruncateToInt32)\
_(ToBigInt)\
_(ToInt64)\
_(TruncateBigIntToInt64)\
_(Int64ToBigInt)\
_(ToString)\
_(BitNot)\
_(TypeOf)\
_(TypeOfName)\
_(TypeOfIs)\
_(ToAsyncIter)\
_(ToPropertyKeyCache)\
_(BitAnd)\
_(BitOr)\
_(BitXor)\
_(Lsh)\
_(Rsh)\
_(Ursh)\
_(SignExtendInt32)\
_(SignExtendInt64)\
_(MinMax)\
_(MinMaxArray)\
_(Abs)\
_(Clz)\
_(Ctz)\
_(Popcnt)\
_(Sqrt)\
_(CopySign)\
_(Atan2)\
_(Hypot)\
_(Pow)\
_(PowHalf)\
_(Random)\
_(Sign)\
_(MathFunction)\
_(Add)\
_(Sub)\
_(Mul)\
_(Div)\
_(WasmBuiltinDivI64)\
_(Mod)\
_(WasmBuiltinModD)\
_(WasmBuiltinModI64)\
_(BigIntAdd)\
_(BigIntSub)\
_(BigIntMul)\
_(BigIntDiv)\
_(BigIntMod)\
_(BigIntPow)\
_(BigIntBitAnd)\
_(BigIntBitOr)\
_(BigIntBitXor)\
_(BigIntLsh)\
_(BigIntRsh)\
_(BigIntIncrement)\
_(BigIntDecrement)\
_(BigIntNegate)\
_(BigIntBitNot)\
_(Int32ToStringWithBase)\
_(NumberParseInt)\
_(DoubleParseInt)\
_(Concat)\
_(LinearizeString)\
_(LinearizeForCharAccess)\
_(LinearizeForCodePointAccess)\
_(ToRelativeStringIndex)\
_(CharCodeAt)\
_(CharCodeAtOrNegative)\
_(CodePointAt)\
_(CodePointAtOrNegative)\
_(NegativeToNaN)\
_(NegativeToUndefined)\
_(FromCharCode)\
_(FromCharCodeEmptyIfNegative)\
_(FromCharCodeUndefinedIfNegative)\
_(FromCodePoint)\
_(StringIncludes)\
_(StringIndexOf)\
_(StringLastIndexOf)\
_(StringStartsWith)\
_(StringEndsWith)\
_(StringConvertCase)\
_(CharCodeConvertCase)\
_(StringTrimStartIndex)\
_(StringTrimEndIndex)\
_(StringSplit)\
_(BoxNonStrictThis)\
_(ImplicitThis)\
_(Phi)\
_(Beta)\
_(NaNToZero)\
_(OsrValue)\
_(OsrEnvironmentChain)\
_(OsrArgumentsObject)\
_(OsrReturnValue)\
_(BinaryCache)\
_(UnaryCache)\
_(CheckOverRecursed)\
_(InterruptCheck)\
_(WasmInterruptCheck)\
_(WasmTrap)\
_(WasmTrapIfNull)\
_(LexicalCheck)\
_(ThrowRuntimeLexicalError)\
_(ThrowMsg)\
_(GlobalDeclInstantiation)\
_(RegExp)\
_(RegExpMatcher)\
_(RegExpSearcher)\
_(RegExpSearcherLastLimit)\
_(RegExpExecMatch)\
_(RegExpExecTest)\
_(RegExpHasCaptureGroups)\
_(RegExpPrototypeOptimizable)\
_(RegExpInstanceOptimizable)\
_(GetFirstDollarIndex)\
_(StringReplace)\
_(Substr)\
_(ModuleMetadata)\
_(DynamicImport)\
_(Lambda)\
_(FunctionWithProto)\
_(SetFunName)\
_(Slots)\
_(Elements)\
_(InitializedLength)\
_(SetInitializedLength)\
_(ArrayLength)\
_(SetArrayLength)\
_(FunctionLength)\
_(FunctionName)\
_(GetNextEntryForIterator)\
_(ArrayBufferByteLength)\
_(ArrayBufferViewLength)\
_(ArrayBufferViewByteOffset)\
_(ArrayBufferViewElements)\
_(ResizableTypedArrayByteOffsetMaybeOutOfBounds)\
_(ResizableTypedArrayLength)\
_(ResizableDataViewByteLength)\
_(GrowableSharedArrayBufferByteLength)\
_(TypedArrayElementSize)\
_(GuardHasAttachedArrayBuffer)\
_(GuardResizableArrayBufferViewInBounds)\
_(GuardResizableArrayBufferViewInBoundsOrDetached)\
_(GuardNumberToIntPtrIndex)\
_(KeepAliveObject)\
_(DebugEnterGCUnsafeRegion)\
_(DebugLeaveGCUnsafeRegion)\
_(Not)\
_(BoundsCheck)\
_(BoundsCheckLower)\
_(SpectreMaskIndex)\
_(LoadElement)\
_(LoadElementAndUnbox)\
_(LoadElementHole)\
_(StoreElement)\
_(StoreHoleValueElement)\
_(StoreElementHole)\
_(ArrayPopShift)\
_(ArrayPush)\
_(ArraySlice)\
_(ArgumentsSlice)\
_(FrameArgumentsSlice)\
_(InlineArgumentsSlice)\
_(NormalizeSliceTerm)\
_(ArrayJoin)\
_(ObjectKeys)\
_(ObjectKeysLength)\
_(LoadUnboxedScalar)\
_(LoadDataViewElement)\
_(LoadTypedArrayElementHole)\
_(StoreUnboxedScalar)\
_(StoreDataViewElement)\
_(StoreTypedArrayElementHole)\
_(EffectiveAddress)\
_(ClampToUint8)\
_(LoadFixedSlot)\
_(LoadFixedSlotAndUnbox)\
_(LoadDynamicSlotAndUnbox)\
_(StoreFixedSlot)\
_(GetPropertyCache)\
_(HomeObjectSuperBase)\
_(GetPropSuperCache)\
_(BindNameCache)\
_(CallBindVar)\
_(GuardShape)\
_(GuardFuse)\
_(GuardMultipleShapes)\
_(GuardProto)\
_(GuardNullProto)\
_(GuardIsNativeObject)\
_(GuardGlobalGeneration)\
_(GuardIsProxy)\
_(GuardIsNotDOMProxy)\
_(GuardIsNotProxy)\
_(ProxyGet)\
_(ProxyGetByValue)\
_(ProxyHasProp)\
_(ProxySet)\
_(ProxySetByValue)\
_(CallSetArrayLength)\
_(MegamorphicLoadSlot)\
_(MegamorphicLoadSlotByValue)\
_(MegamorphicStoreSlot)\
_(MegamorphicHasProp)\
_(SmallObjectVariableKeyHasProp)\
_(GuardIsNotArrayBufferMaybeShared)\
_(GuardIsTypedArray)\
_(GuardIsFixedLengthTypedArray)\
_(GuardIsResizableTypedArray)\
_(GuardHasProxyHandler)\
_(NurseryObject)\
_(GuardValue)\
_(GuardNullOrUndefined)\
_(GuardIsNotObject)\
_(GuardFunctionFlags)\
_(GuardFunctionIsNonBuiltinCtor)\
_(GuardFunctionKind)\
_(GuardFunctionScript)\
_(GuardObjectIdentity)\
_(GuardSpecificFunction)\
_(GuardSpecificAtom)\
_(GuardSpecificSymbol)\
_(GuardSpecificInt32)\
_(GuardStringToIndex)\
_(GuardStringToInt32)\
_(GuardStringToDouble)\
_(GuardNoDenseElements)\
_(GuardTagNotEqual)\
_(LoadDynamicSlot)\
_(FunctionEnvironment)\
_(NewLexicalEnvironmentObject)\
_(NewClassBodyEnvironmentObject)\
_(NewVarEnvironmentObject)\
_(HomeObject)\
_(AddAndStoreSlot)\
_(AllocateAndStoreSlot)\
_(AddSlotAndCallAddPropHook)\
_(StoreDynamicSlot)\
_(GetNameCache)\
_(CallGetIntrinsicValue)\
_(DeleteProperty)\
_(DeleteElement)\
_(SetPropertyCache)\
_(MegamorphicSetElement)\
_(SetDOMProperty)\
_(GetDOMProperty)\
_(GetDOMMember)\
_(ObjectToIterator)\
_(ValueToIterator)\
_(IteratorHasIndices)\
_(LoadSlotByIteratorIndex)\
_(StoreSlotByIteratorIndex)\
_(LoadDOMExpandoValue)\
_(LoadDOMExpandoValueGuardGeneration)\
_(LoadDOMExpandoValueIgnoreGeneration)\
_(GuardDOMExpandoMissingOrGuardShape)\
_(StringLength)\
_(Floor)\
_(Ceil)\
_(Round)\
_(Trunc)\
_(NearbyInt)\
_(GetIteratorCache)\
_(OptimizeSpreadCallCache)\
_(IteratorMore)\
_(IsNoIter)\
_(IteratorEnd)\
_(CloseIterCache)\
_(OptimizeGetIteratorCache)\
_(InCache)\
_(InArray)\
_(GuardElementNotHole)\
_(NewPrivateName)\
_(CheckPrivateFieldCache)\
_(HasOwnCache)\
_(InstanceOf)\
_(InstanceOfCache)\
_(ArgumentsLength)\
_(GetFrameArgument)\
_(GetFrameArgumentHole)\
_(NewTarget)\
_(Rest)\
_(PostWriteBarrier)\
_(PostWriteElementBarrier)\
_(AssertCanElidePostWriteBarrier)\
_(NewNamedLambdaObject)\
_(NewCallObject)\
_(NewStringObject)\
_(IsCallable)\
_(IsConstructor)\
_(IsCrossRealmArrayConstructor)\
_(IsObject)\
_(IsNullOrUndefined)\
_(HasClass)\
_(GuardToClass)\
_(GuardToEitherClass)\
_(GuardToFunction)\
_(IsArray)\
_(IsTypedArray)\
_(ObjectClassToString)\
_(CheckReturn)\
_(CheckThis)\
_(AsyncResolve)\
_(AsyncReject)\
_(GeneratorReturn)\
_(AsyncAwait)\
_(CheckThisReinit)\
_(Generator)\
_(CanSkipAwait)\
_(MaybeExtractAwaitValue)\
_(IncrementWarmUpCounter)\
_(AtomicIsLockFree)\
_(CompareExchangeTypedArrayElement)\
_(AtomicExchangeTypedArrayElement)\
_(AtomicTypedArrayElementBinop)\
_(Debugger)\
_(CheckIsObj)\
_(CheckObjCoercible)\
_(CheckClassHeritage)\
_(DebugCheckSelfHosted)\
_(IsPackedArray)\
_(GuardArrayIsPacked)\
_(GetPrototypeOf)\
_(ObjectWithProto)\
_(ObjectStaticProto)\
_(ConstantProto)\
_(BuiltinObject)\
_(SuperFunction)\
_(InitHomeObject)\
_(IsTypedArrayConstructor)\
_(LoadValueTag)\
_(LoadWrapperTarget)\
_(GuardHasGetterSetter)\
_(GuardIsExtensible)\
_(GuardInt32IsNonNegative)\
_(GuardInt32Range)\
_(GuardIndexIsNotDenseElement)\
_(GuardIndexIsValidUpdateOrAdd)\
_(CallAddOrUpdateSparseElement)\
_(CallGetSparseElement)\
_(CallNativeGetElement)\
_(CallNativeGetElementSuper)\
_(CallObjectHasSparseElement)\
_(BigIntAsIntN)\
_(BigIntAsUintN)\
_(GuardNonGCThing)\
_(ToHashableNonGCThing)\
_(ToHashableString)\
_(ToHashableValue)\
_(HashNonGCThing)\
_(HashString)\
_(HashSymbol)\
_(HashBigInt)\
_(HashObject)\
_(HashValue)\
_(SetObjectHasNonBigInt)\
_(SetObjectHasBigInt)\
_(SetObjectHasValue)\
_(SetObjectHasValueVMCall)\
_(SetObjectSize)\
_(MapObjectHasNonBigInt)\
_(MapObjectHasBigInt)\
_(MapObjectHasValue)\
_(MapObjectHasValueVMCall)\
_(MapObjectGetNonBigInt)\
_(MapObjectGetBigInt)\
_(MapObjectGetValue)\
_(MapObjectGetValueVMCall)\
_(MapObjectSize)\
_(PostIntPtrConversion)\
_(WasmNeg)\
_(WasmBinaryBitwise)\
_(WasmLoadInstance)\
_(WasmStoreInstance)\
_(WasmHeapReg)\
_(WasmBoundsCheck)\
_(WasmBoundsCheckRange32)\
_(WasmExtendU32Index)\
_(WasmWrapU32Index)\
_(WasmAddOffset)\
_(WasmAlignmentCheck)\
_(WasmLoad)\
_(WasmStore)\
_(AsmJSLoadHeap)\
_(AsmJSStoreHeap)\
_(WasmFence)\
_(WasmCompareExchangeHeap)\
_(WasmAtomicExchangeHeap)\
_(WasmAtomicBinopHeap)\
_(WasmLoadInstanceDataField)\
_(WasmLoadGlobalCell)\
_(WasmLoadTableElement)\
_(WasmStoreInstanceDataField)\
_(WasmStoreGlobalCell)\
_(WasmStoreStackResult)\
_(WasmDerivedPointer)\
_(WasmDerivedIndexPointer)\
_(WasmStoreRef)\
_(WasmPostWriteBarrierImmediate)\
_(WasmPostWriteBarrierIndex)\
_(WasmParameter)\
_(WasmReturn)\
_(WasmReturnVoid)\
_(WasmStackArg)\
_(WasmRegisterResult)\
_(WasmFloatRegisterResult)\
_(WasmRegister64Result)\
_(WasmStackResultArea)\
_(WasmStackResult)\
_(WasmCallCatchable)\
_(WasmCallUncatchable)\
_(WasmCallLandingPrePad)\
_(WasmReturnCall)\
_(WasmSelect)\
_(WasmReinterpret)\
_(Rotate)\
_(WasmStackSwitchToMain)\
_(WasmStackSwitchToSuspendable)\
_(WasmStackContinueOnSuspendable)\
_(WasmBinarySimd128)\
_(WasmBinarySimd128WithConstant)\
_(WasmShiftSimd128)\
_(WasmShuffleSimd128)\
_(WasmReplaceLaneSimd128)\
_(WasmUnarySimd128)\
_(WasmTernarySimd128)\
_(WasmScalarToSimd128)\
_(WasmReduceSimd128)\
_(WasmLoadLaneSimd128)\
_(WasmStoreLaneSimd128)\
_(UnreachableResult)\
_(IonToWasmCall)\
_(WasmLoadField)\
_(WasmLoadFieldKA)\
_(WasmLoadElementKA)\
_(WasmStoreFieldKA)\
_(WasmStoreFieldRefKA)\
_(WasmStoreElementKA)\
_(WasmStoreElementRefKA)\
_(WasmRefIsSubtypeOfConcrete)\
_(WasmRefIsSubtypeOfAbstract)\
_(WasmNewStructObject)\
_(WasmNewArrayObject)

#define MIR_OPCODE_CLASS_GENERATED \
class MStart : public MNullaryInstruction {\
  explicit MStart() : MNullaryInstruction(classOpcode) {\
  }\
 public:\
  INSTRUCTION_HEADER(Start)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MOsrEntry : public MNullaryInstruction {\
  explicit MOsrEntry() : MNullaryInstruction(classOpcode) {\
    setResultType(MIRType::Pointer);\
  }\
 public:\
  INSTRUCTION_HEADER(OsrEntry)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MNop : public MNullaryInstruction {\
  explicit MNop() : MNullaryInstruction(classOpcode) {\
  }\
 public:\
  INSTRUCTION_HEADER(Nop)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  ALLOW_CLONE(MNop)\
};\
\
class MCallee : public MNullaryInstruction {\
  explicit MCallee() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(Callee)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsConstructing : public MNullaryInstruction {\
  explicit MIsConstructing() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsConstructing)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MThrow : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MThrow(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
  }\
 public:\
  INSTRUCTION_HEADER(Throw)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MThrowWithStack : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MThrowWithStack(MDefinition* value, MDefinition* stack) : MBinaryInstruction(classOpcode, value, stack) {\
  }\
 public:\
  INSTRUCTION_HEADER(ThrowWithStack)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, stack))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNewArrayDynamicLength : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::Heap initialHeap_;\
  explicit MNewArrayDynamicLength(MDefinition* length, JSObject* templateObject, gc::Heap initialHeap) : MUnaryInstruction(classOpcode, length), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewArrayDynamicLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, length))\
  AliasSet getAliasSet() const override;\
};\
\
class MNewTypedArrayDynamicLength : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::Heap initialHeap_;\
  explicit MNewTypedArrayDynamicLength(MDefinition* length, JSObject* templateObject, gc::Heap initialHeap) : MUnaryInstruction(classOpcode, length), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewTypedArrayDynamicLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, length))\
  AliasSet getAliasSet() const override;\
};\
\
class MNewTypedArrayFromArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::Heap initialHeap_;\
  explicit MNewTypedArrayFromArray(MDefinition* array, JSObject* templateObject, gc::Heap initialHeap) : MUnaryInstruction(classOpcode, array), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewTypedArrayFromArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, array))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNewTypedArrayFromArrayBuffer : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, BoxPolicy<2>>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::Heap initialHeap_;\
  explicit MNewTypedArrayFromArrayBuffer(MDefinition* arrayBuffer, MDefinition* byteOffset, MDefinition* length, JSObject* templateObject, gc::Heap initialHeap) : MTernaryInstruction(classOpcode, arrayBuffer, byteOffset, length), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewTypedArrayFromArrayBuffer)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, arrayBuffer), (1, byteOffset), (2, length))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNewBoundFunction : public MNullaryInstruction {\
  CompilerGCPointer<JSObject*> templateObj_;\
  explicit MNewBoundFunction(JSObject* templateObj) : MNullaryInstruction(classOpcode), templateObj_(templateObj) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObj() const { return templateObj_; }\
  INSTRUCTION_HEADER(NewBoundFunction)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MBoundFunctionNumArgs : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MBoundFunctionNumArgs(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(BoundFunctionNumArgs)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardBoundFunctionIsConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardBoundFunctionIsConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardBoundFunctionIsConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMutateProto : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MMutateProto(MDefinition* object, MDefinition* value) : MBinaryInstruction(classOpcode, object, value) {\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(MutateProto)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MInitPropGetterSetter : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MInitPropGetterSetter(MDefinition* object, MDefinition* value, PropertyName* name) : MBinaryInstruction(classOpcode, object, value), name_(name) {\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(InitPropGetterSetter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
};\
\
class MInitElemGetterSetter : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, ObjectPolicy<2>>::Data {\
  explicit MInitElemGetterSetter(MDefinition* object, MDefinition* id, MDefinition* value) : MTernaryInstruction(classOpcode, object, id, value) {\
  }\
 public:\
  INSTRUCTION_HEADER(InitElemGetterSetter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, id), (2, value))\
};\
\
class MEncodeSnapshot : public MNullaryInstruction {\
  explicit MEncodeSnapshot() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(EncodeSnapshot)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MSameValueDouble : public MBinaryInstruction, public MixPolicy<DoublePolicy<0>, DoublePolicy<1>>::Data {\
  explicit MSameValueDouble(MDefinition* left, MDefinition* right) : MBinaryInstruction(classOpcode, left, right) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SameValueDouble)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, left), (1, right))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MSameValueDouble)\
};\
\
class MSameValue : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MSameValue(MDefinition* left, MDefinition* right) : MBinaryInstruction(classOpcode, left, right) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SameValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, left), (1, right))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MSameValue)\
};\
\
class MCreateThis : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MCreateThis(MDefinition* callee, MDefinition* newTarget) : MBinaryInstruction(classOpcode, callee, newTarget) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CreateThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, callee), (1, newTarget))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGetArgumentsObjectArg : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  size_t argno_;\
  explicit MGetArgumentsObjectArg(MDefinition* argsObject, size_t argno) : MUnaryInstruction(classOpcode, argsObject), argno_(argno) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  size_t argno() const { return argno_; }\
  INSTRUCTION_HEADER(GetArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MSetArgumentsObjectArg : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  size_t argno_;\
  explicit MSetArgumentsObjectArg(MDefinition* argsObject, MDefinition* value, size_t argno) : MBinaryInstruction(classOpcode, argsObject, value), argno_(argno) {\
  }\
 public:\
  size_t argno() const { return argno_; }\
  INSTRUCTION_HEADER(SetArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject), (1, value))\
  AliasSet getAliasSet() const override;\
};\
\
class MLoadArgumentsObjectArg : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MLoadArgumentsObjectArg(MDefinition* argsObject, MDefinition* index) : MBinaryInstruction(classOpcode, argsObject, index) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLoadArgumentsObjectArgHole : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MLoadArgumentsObjectArgHole(MDefinition* argsObject, MDefinition* index) : MBinaryInstruction(classOpcode, argsObject, index) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadArgumentsObjectArgHole)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MInArgumentsObjectArg : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MInArgumentsObjectArg(MDefinition* argsObject, MDefinition* index) : MBinaryInstruction(classOpcode, argsObject, index) {\
    setGuard();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(InArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArgumentsObjectLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArgumentsObjectLength(MDefinition* argsObject) : MUnaryInstruction(classOpcode, argsObject) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArgumentsObjectLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArrayFromArgumentsObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MArrayFromArgumentsObject(MDefinition* argsObject, Shape* shape) : MUnaryInstruction(classOpcode, argsObject), shape_(shape) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(ArrayFromArgumentsObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGuardArgumentsObjectFlags : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  uint32_t flags_;\
  explicit MGuardArgumentsObjectFlags(MDefinition* argsObject, uint32_t flags) : MUnaryInstruction(classOpcode, argsObject), flags_(flags) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  uint32_t flags() const { return flags_; }\
  INSTRUCTION_HEADER(GuardArgumentsObjectFlags)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MLoadScriptedProxyHandler : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MLoadScriptedProxyHandler(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadScriptedProxyHandler)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MCheckScriptedProxyGetResult : public MTernaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>, BoxPolicy<2>>::Data {\
  explicit MCheckScriptedProxyGetResult(MDefinition* target, MDefinition* id, MDefinition* value) : MTernaryInstruction(classOpcode, target, id, value) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(CheckScriptedProxyGetResult)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, target), (1, id), (2, value))\
  AliasSet getAliasSet() const override;\
};\
\
class MIdToStringOrSymbol : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MIdToStringOrSymbol(MDefinition* idVal) : MUnaryInstruction(classOpcode, idVal) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(IdToStringOrSymbol)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, idVal))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MReturnFromCtor : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MReturnFromCtor(MDefinition* value, MDefinition* object) : MBinaryInstruction(classOpcode, value, object) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ReturnFromCtor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmUnsignedToDouble : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmUnsignedToDouble(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setMovable();\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmUnsignedToDouble)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmAnyRefFromJSValue : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MWasmAnyRefFromJSValue(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setResultType(MIRType::WasmAnyRef);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmAnyRefFromJSValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmAnyRefFromJSObject : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmAnyRefFromJSObject(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setResultType(MIRType::WasmAnyRef);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmAnyRefFromJSObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmAnyRefFromJSString : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmAnyRefFromJSString(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setResultType(MIRType::WasmAnyRef);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmAnyRefFromJSString)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmNewI31Ref : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmNewI31Ref(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::WasmAnyRef);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmNewI31Ref)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmI31RefGet : public MUnaryInstruction, public NoTypePolicy::Data {\
  wasm::FieldWideningOp wideningOp_;\
  explicit MWasmI31RefGet(MDefinition* input, wasm::FieldWideningOp wideningOp) : MUnaryInstruction(classOpcode, input), wideningOp_(wideningOp) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  wasm::FieldWideningOp wideningOp() const { return wideningOp_; }\
  INSTRUCTION_HEADER(WasmI31RefGet)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MBooleanToInt32 : public MUnaryInstruction, public BooleanPolicy<0>::Data {\
  explicit MBooleanToInt32(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(BooleanToInt32)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MTypeOfName : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MTypeOfName(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(TypeOfName)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MToAsyncIter : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MToAsyncIter(MDefinition* iterator, MDefinition* nextMethod) : MBinaryInstruction(classOpcode, iterator, nextMethod) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ToAsyncIter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iterator), (1, nextMethod))\
};\
\
class MToPropertyKeyCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MToPropertyKeyCache(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ToPropertyKeyCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
};\
\
class MAtan2 : public MBinaryInstruction, public MixPolicy<DoublePolicy<0>, DoublePolicy<1>>::Data {\
  explicit MAtan2(MDefinition* y, MDefinition* x) : MBinaryInstruction(classOpcode, y, x) {\
    setMovable();\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(Atan2)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, y), (1, x))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MAtan2)\
};\
\
class MRandom : public MNullaryInstruction {\
  explicit MRandom() : MNullaryInstruction(classOpcode) {\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(Random)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override;\
  ALLOW_CLONE(MRandom)\
};\
\
class MInt32ToStringWithBase : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, UnboxedInt32Policy<1>>::Data {\
  bool lowerCase_;\
  explicit MInt32ToStringWithBase(MDefinition* input, MDefinition* base, bool lowerCase) : MBinaryInstruction(classOpcode, input, base), lowerCase_(lowerCase) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  bool lowerCase() const { return lowerCase_; }\
  INSTRUCTION_HEADER(Int32ToStringWithBase)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input), (1, base))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MNumberParseInt : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MNumberParseInt(MDefinition* string, MDefinition* radix) : MBinaryInstruction(classOpcode, string, radix) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(NumberParseInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, radix))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MDoubleParseInt : public MUnaryInstruction, public DoublePolicy<0>::Data {\
  explicit MDoubleParseInt(MDefinition* number) : MUnaryInstruction(classOpcode, number) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(DoubleParseInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, number))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLinearizeString : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MLinearizeString(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(LinearizeString)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLinearizeForCharAccess : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MLinearizeForCharAccess(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(LinearizeForCharAccess)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLinearizeForCodePointAccess : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MLinearizeForCodePointAccess(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(LinearizeForCodePointAccess)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MToRelativeStringIndex : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MToRelativeStringIndex(MDefinition* index, MDefinition* length) : MBinaryInstruction(classOpcode, index, length) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ToRelativeStringIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index), (1, length))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MCharCodeAt : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCharCodeAt(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(CharCodeAt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MCharCodeAt)\
};\
\
class MCharCodeAtOrNegative : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCharCodeAtOrNegative(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(CharCodeAtOrNegative)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MCodePointAt : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCodePointAt(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(CodePointAt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MCodePointAt)\
};\
\
class MCodePointAtOrNegative : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCodePointAtOrNegative(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(CodePointAtOrNegative)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MNegativeToNaN : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MNegativeToNaN(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(NegativeToNaN)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MNegativeToUndefined : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MNegativeToUndefined(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(NegativeToUndefined)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MFromCharCode : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MFromCharCode(MDefinition* code) : MUnaryInstruction(classOpcode, code) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FromCharCode)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, code))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MFromCharCode)\
};\
\
class MFromCharCodeEmptyIfNegative : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MFromCharCodeEmptyIfNegative(MDefinition* code) : MUnaryInstruction(classOpcode, code) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FromCharCodeEmptyIfNegative)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, code))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MFromCharCodeEmptyIfNegative)\
};\
\
class MFromCharCodeUndefinedIfNegative : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MFromCharCodeUndefinedIfNegative(MDefinition* code) : MUnaryInstruction(classOpcode, code) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(FromCharCodeUndefinedIfNegative)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, code))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MFromCodePoint : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MFromCodePoint(MDefinition* codePoint) : MUnaryInstruction(classOpcode, codePoint) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FromCodePoint)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, codePoint))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MFromCodePoint)\
};\
\
class MStringIncludes : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringIncludes(MDefinition* string, MDefinition* searchString) : MBinaryInstruction(classOpcode, string, searchString) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(StringIncludes)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, searchString))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MStringIndexOf : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringIndexOf(MDefinition* string, MDefinition* searchString) : MBinaryInstruction(classOpcode, string, searchString) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(StringIndexOf)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, searchString))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MStringLastIndexOf : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringLastIndexOf(MDefinition* string, MDefinition* searchString) : MBinaryInstruction(classOpcode, string, searchString) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(StringLastIndexOf)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, searchString))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MStringStartsWith : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringStartsWith(MDefinition* string, MDefinition* searchString) : MBinaryInstruction(classOpcode, string, searchString) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(StringStartsWith)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, searchString))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MStringEndsWith : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringEndsWith(MDefinition* string, MDefinition* searchString) : MBinaryInstruction(classOpcode, string, searchString) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(StringEndsWith)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, searchString))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MStringTrimStartIndex : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MStringTrimStartIndex(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(StringTrimStartIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MStringTrimEndIndex : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MStringTrimEndIndex(MDefinition* string, MDefinition* start) : MBinaryInstruction(classOpcode, string, start) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(StringTrimEndIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, start))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MStringSplit : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringSplit(MDefinition* string, MDefinition* separator) : MBinaryInstruction(classOpcode, string, separator) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(StringSplit)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, separator))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MBoxNonStrictThis : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  CompilerGCPointer<JSObject*> globalThis_;\
  explicit MBoxNonStrictThis(MDefinition* def, JSObject* globalThis) : MUnaryInstruction(classOpcode, def), globalThis_(globalThis) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* globalThis() const { return globalThis_; }\
  INSTRUCTION_HEADER(BoxNonStrictThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MImplicitThis : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MImplicitThis(MDefinition* envChain, PropertyName* name) : MUnaryInstruction(classOpcode, envChain), name_(name) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(ImplicitThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, envChain))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MUnaryCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MUnaryCache(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(UnaryCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
};\
\
class MCheckOverRecursed : public MNullaryInstruction {\
  explicit MCheckOverRecursed() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(CheckOverRecursed)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MInterruptCheck : public MNullaryInstruction {\
  explicit MInterruptCheck() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(InterruptCheck)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MWasmTrapIfNull : public MUnaryInstruction, public NoTypePolicy::Data {\
  wasm::Trap trap_;\
  wasm::BytecodeOffset bytecodeOffset_;\
  explicit MWasmTrapIfNull(MDefinition* ref, wasm::Trap trap, wasm::BytecodeOffset bytecodeOffset) : MUnaryInstruction(classOpcode, ref), trap_(trap), bytecodeOffset_(bytecodeOffset) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  wasm::Trap trap() const { return trap_; }\
  wasm::BytecodeOffset bytecodeOffset() const { return bytecodeOffset_; }\
  INSTRUCTION_HEADER(WasmTrapIfNull)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, ref))\
};\
\
class MThrowRuntimeLexicalError : public MNullaryInstruction {\
  unsigned errorNumber_;\
  explicit MThrowRuntimeLexicalError(unsigned errorNumber) : MNullaryInstruction(classOpcode), errorNumber_(errorNumber) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  unsigned errorNumber() const { return errorNumber_; }\
  INSTRUCTION_HEADER(ThrowRuntimeLexicalError)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override;\
};\
\
class MGlobalDeclInstantiation : public MNullaryInstruction {\
  explicit MGlobalDeclInstantiation() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(GlobalDeclInstantiation)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MRegExp : public MNullaryInstruction {\
  CompilerGCPointer<RegExpObject*> source_;\
  bool hasShared_;\
  explicit MRegExp(RegExpObject* source, bool hasShared) : MNullaryInstruction(classOpcode), source_(source), hasShared_(hasShared) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  RegExpObject* source() const { return source_; }\
  bool hasShared() const { return hasShared_; }\
  INSTRUCTION_HEADER(RegExp)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpMatcher : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MRegExpMatcher(MDefinition* regexp, MDefinition* string, MDefinition* lastIndex) : MTernaryInstruction(classOpcode, regexp, string, lastIndex) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpMatcher)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string), (2, lastIndex))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpSearcher : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MRegExpSearcher(MDefinition* regexp, MDefinition* string, MDefinition* lastIndex) : MTernaryInstruction(classOpcode, regexp, string, lastIndex) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpSearcher)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string), (2, lastIndex))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpSearcherLastLimit : public MNullaryInstruction {\
  explicit MRegExpSearcherLastLimit() : MNullaryInstruction(classOpcode) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpSearcherLastLimit)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MRegExpExecMatch : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>>::Data {\
  explicit MRegExpExecMatch(MDefinition* regexp, MDefinition* string) : MBinaryInstruction(classOpcode, regexp, string) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpExecMatch)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpExecTest : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>>::Data {\
  explicit MRegExpExecTest(MDefinition* regexp, MDefinition* string) : MBinaryInstruction(classOpcode, regexp, string) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpExecTest)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpHasCaptureGroups : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>>::Data {\
  explicit MRegExpHasCaptureGroups(MDefinition* regexp, MDefinition* input) : MBinaryInstruction(classOpcode, regexp, input) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpHasCaptureGroups)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, input))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpPrototypeOptimizable : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MRegExpPrototypeOptimizable(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpPrototypeOptimizable)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MRegExpInstanceOptimizable : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MRegExpInstanceOptimizable(MDefinition* object, MDefinition* proto) : MBinaryInstruction(classOpcode, object, proto) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpInstanceOptimizable)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, proto))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MSubstr : public MTernaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MSubstr(MDefinition* string, MDefinition* begin, MDefinition* length) : MTernaryInstruction(classOpcode, string, begin, length) {\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(Substr)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, begin), (2, length))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MModuleMetadata : public MNullaryInstruction {\
  CompilerGCPointer<JSObject*> module_;\
  explicit MModuleMetadata(JSObject* module) : MNullaryInstruction(classOpcode), module_(module) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* module() const { return module_; }\
  INSTRUCTION_HEADER(ModuleMetadata)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MDynamicImport : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MDynamicImport(MDefinition* specifier, MDefinition* options) : MBinaryInstruction(classOpcode, specifier, options) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(DynamicImport)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, specifier), (1, options))\
};\
\
class MSetFunName : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  uint8_t prefixKind_;\
  explicit MSetFunName(MDefinition* fun, MDefinition* name, uint8_t prefixKind) : MBinaryInstruction(classOpcode, fun, name), prefixKind_(prefixKind) {\
    setResultType(MIRType::None);\
  }\
 public:\
  uint8_t prefixKind() const { return prefixKind_; }\
  INSTRUCTION_HEADER(SetFunName)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, fun), (1, name))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MSlots : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MSlots(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Slots);\
  }\
 public:\
  INSTRUCTION_HEADER(Slots)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  AliasType mightAlias(const MDefinition* store) const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MSlots)\
};\
\
class MElements : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MElements(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Elements);\
  }\
 public:\
  INSTRUCTION_HEADER(Elements)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MElements)\
};\
\
class MInitializedLength : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MInitializedLength(MDefinition* elements) : MUnaryInstruction(classOpcode, elements) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(InitializedLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MInitializedLength)\
};\
\
class MSetInitializedLength : public MBinaryInstruction, public NoTypePolicy::Data {\
  explicit MSetInitializedLength(MDefinition* elements, MDefinition* index) : MBinaryInstruction(classOpcode, elements, index) {\
  }\
 public:\
  INSTRUCTION_HEADER(SetInitializedLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements), (1, index))\
  AliasSet getAliasSet() const override;\
  ALLOW_CLONE(MSetInitializedLength)\
};\
\
class MArrayLength : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MArrayLength(MDefinition* elements) : MUnaryInstruction(classOpcode, elements) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MArrayLength)\
};\
\
class MSetArrayLength : public MBinaryInstruction, public NoTypePolicy::Data {\
  explicit MSetArrayLength(MDefinition* elements, MDefinition* index) : MBinaryInstruction(classOpcode, elements, index) {\
  }\
 public:\
  INSTRUCTION_HEADER(SetArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements), (1, index))\
  AliasSet getAliasSet() const override;\
};\
\
class MFunctionLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MFunctionLength(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setGuard();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(FunctionLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MFunctionName : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MFunctionName(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setGuard();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FunctionName)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArrayBufferByteLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferByteLength(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferByteLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArrayBufferViewLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferViewLength(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferViewLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MArrayBufferViewByteOffset : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferViewByteOffset(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferViewByteOffset)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MArrayBufferViewElements : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferViewElements(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Elements);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferViewElements)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MArrayBufferViewElements)\
};\
\
class MResizableTypedArrayByteOffsetMaybeOutOfBounds : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MResizableTypedArrayByteOffsetMaybeOutOfBounds(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ResizableTypedArrayByteOffsetMaybeOutOfBounds)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MResizableTypedArrayLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  MemoryBarrierRequirement requiresMemoryBarrier_;\
  explicit MResizableTypedArrayLength(MDefinition* object, MemoryBarrierRequirement requiresMemoryBarrier) : MUnaryInstruction(classOpcode, object), requiresMemoryBarrier_(requiresMemoryBarrier) {\
    setGuard();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  MemoryBarrierRequirement requiresMemoryBarrier() const { return requiresMemoryBarrier_; }\
  INSTRUCTION_HEADER(ResizableTypedArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MResizableDataViewByteLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  MemoryBarrierRequirement requiresMemoryBarrier_;\
  explicit MResizableDataViewByteLength(MDefinition* object, MemoryBarrierRequirement requiresMemoryBarrier) : MUnaryInstruction(classOpcode, object), requiresMemoryBarrier_(requiresMemoryBarrier) {\
    setGuard();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  MemoryBarrierRequirement requiresMemoryBarrier() const { return requiresMemoryBarrier_; }\
  INSTRUCTION_HEADER(ResizableDataViewByteLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MGrowableSharedArrayBufferByteLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGrowableSharedArrayBufferByteLength(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(GrowableSharedArrayBufferByteLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
};\
\
class MTypedArrayElementSize : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MTypedArrayElementSize(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(TypedArrayElementSize)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MGuardHasAttachedArrayBuffer : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardHasAttachedArrayBuffer(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardHasAttachedArrayBuffer)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardResizableArrayBufferViewInBounds : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardResizableArrayBufferViewInBounds(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardResizableArrayBufferViewInBounds)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardResizableArrayBufferViewInBoundsOrDetached : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardResizableArrayBufferViewInBoundsOrDetached(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardResizableArrayBufferViewInBoundsOrDetached)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MKeepAliveObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MKeepAliveObject(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(KeepAliveObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
};\
\
class MDebugEnterGCUnsafeRegion : public MNullaryInstruction {\
  explicit MDebugEnterGCUnsafeRegion() : MNullaryInstruction(classOpcode) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(DebugEnterGCUnsafeRegion)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MDebugLeaveGCUnsafeRegion : public MNullaryInstruction {\
  explicit MDebugLeaveGCUnsafeRegion() : MNullaryInstruction(classOpcode) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(DebugLeaveGCUnsafeRegion)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MArrayPush : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MArrayPush(MDefinition* object, MDefinition* value) : MBinaryInstruction(classOpcode, object, value) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayPush)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  AliasSet getAliasSet() const override;\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MArrayPush)\
};\
\
class MArraySlice : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>, UnboxedInt32Policy<2>>::Data {\
  CompilerGCPointer<JSObject*> templateObj_;\
  gc::Heap initialHeap_;\
  explicit MArraySlice(MDefinition* object, MDefinition* begin, MDefinition* end, JSObject* templateObj, gc::Heap initialHeap) : MTernaryInstruction(classOpcode, object, begin, end), templateObj_(templateObj), initialHeap_(initialHeap) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObj() const { return templateObj_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(ArraySlice)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, begin), (2, end))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MArgumentsSlice : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>, UnboxedInt32Policy<2>>::Data {\
  CompilerGCPointer<JSObject*> templateObj_;\
  gc::Heap initialHeap_;\
  explicit MArgumentsSlice(MDefinition* object, MDefinition* begin, MDefinition* end, JSObject* templateObj, gc::Heap initialHeap) : MTernaryInstruction(classOpcode, object, begin, end), templateObj_(templateObj), initialHeap_(initialHeap) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObj() const { return templateObj_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(ArgumentsSlice)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, begin), (2, end))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MFrameArgumentsSlice : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, UnboxedInt32Policy<1>>::Data {\
  CompilerGCPointer<JSObject*> templateObj_;\
  gc::Heap initialHeap_;\
  explicit MFrameArgumentsSlice(MDefinition* begin, MDefinition* count, JSObject* templateObj, gc::Heap initialHeap) : MBinaryInstruction(classOpcode, begin, count), templateObj_(templateObj), initialHeap_(initialHeap) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObj() const { return templateObj_; }\
  gc::Heap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(FrameArgumentsSlice)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, begin), (1, count))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNormalizeSliceTerm : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MNormalizeSliceTerm(MDefinition* value, MDefinition* length) : MBinaryInstruction(classOpcode, value, length) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(NormalizeSliceTerm)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, length))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArrayJoin : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>>::Data {\
  explicit MArrayJoin(MDefinition* array, MDefinition* sep) : MBinaryInstruction(classOpcode, array, sep) {\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayJoin)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, array), (1, sep))\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MObjectKeys : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MObjectKeys(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ObjectKeys)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override;\
};\
\
class MObjectKeysLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MObjectKeysLength(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ObjectKeysLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MObjectKeysLength)\
};\
\
class MHomeObjectSuperBase : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MHomeObjectSuperBase(MDefinition* homeObject) : MUnaryInstruction(classOpcode, homeObject) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(HomeObjectSuperBase)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, homeObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MBindNameCache : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MBindNameCache(MDefinition* envChain) : MUnaryInstruction(classOpcode, envChain) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(BindNameCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, envChain))\
};\
\
class MCallBindVar : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MCallBindVar(MDefinition* environmentChain) : MUnaryInstruction(classOpcode, environmentChain) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(CallBindVar)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, environmentChain))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardShape : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MGuardShape(MDefinition* object, Shape* shape) : MUnaryInstruction(classOpcode, object), shape_(shape) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(GuardShape)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  AliasType mightAlias(const MDefinition* store) const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardFuse : public MNullaryInstruction {\
  RealmFuses::FuseIndex fuseIndex_;\
  explicit MGuardFuse(RealmFuses::FuseIndex fuseIndex) : MNullaryInstruction(classOpcode), fuseIndex_(fuseIndex) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::None);\
  }\
 public:\
  RealmFuses::FuseIndex fuseIndex() const { return fuseIndex_; }\
  INSTRUCTION_HEADER(GuardFuse)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardMultipleShapes : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MGuardMultipleShapes(MDefinition* object, MDefinition* shapeList) : MBinaryInstruction(classOpcode, object, shapeList) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardMultipleShapes)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, shapeList))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsNativeObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNativeObject(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNativeObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardGlobalGeneration : public MNullaryInstruction {\
  uint32_t expected_;\
  const void* generationAddr_;\
  explicit MGuardGlobalGeneration(uint32_t expected, const void* generationAddr) : MNullaryInstruction(classOpcode), expected_(expected), generationAddr_(generationAddr) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::None);\
  }\
 public:\
  uint32_t expected() const { return expected_; }\
  const void* generationAddr() const { return generationAddr_; }\
  INSTRUCTION_HEADER(GuardGlobalGeneration)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardIsProxy : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsProxy(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsProxy)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsNotDOMProxy : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNotDOMProxy(MDefinition* proxy) : MUnaryInstruction(classOpcode, proxy) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotDOMProxy)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsNotProxy : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNotProxy(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotProxy)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MProxyGet : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  jsid id_;\
  explicit MProxyGet(MDefinition* proxy, jsid id) : MUnaryInstruction(classOpcode, proxy), id_(id) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  jsid id() const { return id_; }\
  INSTRUCTION_HEADER(ProxyGet)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxyGetByValue : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MProxyGetByValue(MDefinition* proxy, MDefinition* idVal) : MBinaryInstruction(classOpcode, proxy, idVal) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ProxyGetByValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, idVal))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxyHasProp : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  bool hasOwn_;\
  explicit MProxyHasProp(MDefinition* proxy, MDefinition* idVal, bool hasOwn) : MBinaryInstruction(classOpcode, proxy, idVal), hasOwn_(hasOwn) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  bool hasOwn() const { return hasOwn_; }\
  INSTRUCTION_HEADER(ProxyHasProp)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, idVal))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxySet : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  jsid id_;\
  bool strict_;\
  explicit MProxySet(MDefinition* proxy, MDefinition* rhs, jsid id, bool strict) : MBinaryInstruction(classOpcode, proxy, rhs), id_(id), strict_(strict) {\
  }\
 public:\
  jsid id() const { return id_; }\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(ProxySet)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxySetByValue : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, BoxPolicy<2>>::Data {\
  bool strict_;\
  explicit MProxySetByValue(MDefinition* proxy, MDefinition* idVal, MDefinition* rhs, bool strict) : MTernaryInstruction(classOpcode, proxy, idVal, rhs), strict_(strict) {\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(ProxySetByValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, idVal), (2, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallSetArrayLength : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  bool strict_;\
  explicit MCallSetArrayLength(MDefinition* obj, MDefinition* rhs, bool strict) : MBinaryInstruction(classOpcode, obj, rhs), strict_(strict) {\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(CallSetArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, obj), (1, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicLoadSlot : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  PropertyKey name_;\
  explicit MMegamorphicLoadSlot(MDefinition* object, PropertyKey name) : MUnaryInstruction(classOpcode, object), name_(name) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  PropertyKey name() const { return name_; }\
  INSTRUCTION_HEADER(MegamorphicLoadSlot)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicLoadSlotByValue : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MMegamorphicLoadSlotByValue(MDefinition* object, MDefinition* idVal) : MBinaryInstruction(classOpcode, object, idVal) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(MegamorphicLoadSlotByValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, idVal))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicStoreSlot : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  PropertyKey name_;\
  bool strict_;\
  explicit MMegamorphicStoreSlot(MDefinition* object, MDefinition* rhs, PropertyKey name, bool strict) : MBinaryInstruction(classOpcode, object, rhs), name_(name), strict_(strict) {\
  }\
 public:\
  PropertyKey name() const { return name_; }\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(MegamorphicStoreSlot)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicHasProp : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  bool hasOwn_;\
  explicit MMegamorphicHasProp(MDefinition* object, MDefinition* idVal, bool hasOwn) : MBinaryInstruction(classOpcode, object, idVal), hasOwn_(hasOwn) {\
    setGuard();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  bool hasOwn() const { return hasOwn_; }\
  INSTRUCTION_HEADER(MegamorphicHasProp)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, idVal))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MSmallObjectVariableKeyHasProp : public MUnaryInstruction, public StringPolicy<0>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MSmallObjectVariableKeyHasProp(MDefinition* idStr, Shape* shape) : MUnaryInstruction(classOpcode, idStr), shape_(shape) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(SmallObjectVariableKeyHasProp)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, idStr))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardIsNotArrayBufferMaybeShared : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNotArrayBufferMaybeShared(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotArrayBufferMaybeShared)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsTypedArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsTypedArray(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsTypedArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsFixedLengthTypedArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsFixedLengthTypedArray(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsFixedLengthTypedArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsResizableTypedArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsResizableTypedArray(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsResizableTypedArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardHasProxyHandler : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  const void* handler_;\
  explicit MGuardHasProxyHandler(MDefinition* object, const void* handler) : MUnaryInstruction(classOpcode, object), handler_(handler) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  const void* handler() const { return handler_; }\
  INSTRUCTION_HEADER(GuardHasProxyHandler)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MNurseryObject : public MNullaryInstruction {\
  uint32_t nurseryIndex_;\
  explicit MNurseryObject(uint32_t nurseryIndex) : MNullaryInstruction(classOpcode), nurseryIndex_(nurseryIndex) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  uint32_t nurseryIndex() const { return nurseryIndex_; }\
  INSTRUCTION_HEADER(NurseryObject)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardNullOrUndefined : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MGuardNullOrUndefined(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardNullOrUndefined)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsNotObject : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MGuardIsNotObject(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardFunctionIsNonBuiltinCtor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardFunctionIsNonBuiltinCtor(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardFunctionIsNonBuiltinCtor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardFunctionKind : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  FunctionFlags::FunctionKind expected_;\
  bool bailOnEquality_;\
  explicit MGuardFunctionKind(MDefinition* function, FunctionFlags::FunctionKind expected, bool bailOnEquality) : MUnaryInstruction(classOpcode, function), expected_(expected), bailOnEquality_(bailOnEquality) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  FunctionFlags::FunctionKind expected() const { return expected_; }\
  bool bailOnEquality() const { return bailOnEquality_; }\
  INSTRUCTION_HEADER(GuardFunctionKind)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardFunctionScript : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<BaseScript*> expected_;\
  uint16_t nargs_;\
  FunctionFlags flags_;\
  explicit MGuardFunctionScript(MDefinition* function, BaseScript* expected, uint16_t nargs, FunctionFlags flags) : MUnaryInstruction(classOpcode, function), expected_(expected), nargs_(nargs), flags_(flags) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  BaseScript* expected() const { return expected_; }\
  uint16_t nargs() const { return nargs_; }\
  FunctionFlags flags() const { return flags_; }\
  INSTRUCTION_HEADER(GuardFunctionScript)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardSpecificAtom : public MUnaryInstruction, public StringPolicy<0>::Data {\
  CompilerGCPointer<JSAtom*> atom_;\
  explicit MGuardSpecificAtom(MDefinition* str, JSAtom* atom) : MUnaryInstruction(classOpcode, str), atom_(atom) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  JSAtom* atom() const { return atom_; }\
  INSTRUCTION_HEADER(GuardSpecificAtom)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, str))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardSpecificInt32 : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  int32_t expected_;\
  explicit MGuardSpecificInt32(MDefinition* num, int32_t expected) : MUnaryInstruction(classOpcode, num), expected_(expected) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  int32_t expected() const { return expected_; }\
  INSTRUCTION_HEADER(GuardSpecificInt32)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, num))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MGuardStringToIndex : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MGuardStringToIndex(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardStringToIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardStringToInt32 : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MGuardStringToInt32(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardStringToInt32)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardStringToDouble : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MGuardStringToDouble(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardStringToDouble)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardNoDenseElements : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardNoDenseElements(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardNoDenseElements)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
};\
\
class MFunctionEnvironment : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MFunctionEnvironment(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(FunctionEnvironment)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MNewLexicalEnvironmentObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MNewLexicalEnvironmentObject(MDefinition* templateObj) : MUnaryInstruction(classOpcode, templateObj) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(NewLexicalEnvironmentObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, templateObj))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MNewClassBodyEnvironmentObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MNewClassBodyEnvironmentObject(MDefinition* templateObj) : MUnaryInstruction(classOpcode, templateObj) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(NewClassBodyEnvironmentObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, templateObj))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MNewVarEnvironmentObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MNewVarEnvironmentObject(MDefinition* templateObj) : MUnaryInstruction(classOpcode, templateObj) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(NewVarEnvironmentObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, templateObj))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MHomeObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MHomeObject(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(HomeObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MAllocateAndStoreSlot : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  uint32_t slotOffset_;\
  CompilerGCPointer<Shape*> shape_;\
  uint32_t numNewSlots_;\
  explicit MAllocateAndStoreSlot(MDefinition* object, MDefinition* value, uint32_t slotOffset, Shape* shape, uint32_t numNewSlots) : MBinaryInstruction(classOpcode, object, value), slotOffset_(slotOffset), shape_(shape), numNewSlots_(numNewSlots) {\
  }\
 public:\
  uint32_t slotOffset() const { return slotOffset_; }\
  Shape* shape() const { return shape_; }\
  uint32_t numNewSlots() const { return numNewSlots_; }\
  INSTRUCTION_HEADER(AllocateAndStoreSlot)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MAddSlotAndCallAddPropHook : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MAddSlotAndCallAddPropHook(MDefinition* object, MDefinition* value, Shape* shape) : MBinaryInstruction(classOpcode, object, value), shape_(shape) {\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(AddSlotAndCallAddPropHook)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGetNameCache : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGetNameCache(MDefinition* envObj) : MUnaryInstruction(classOpcode, envObj) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetNameCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, envObj))\
};\
\
class MCallGetIntrinsicValue : public MNullaryInstruction {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MCallGetIntrinsicValue(PropertyName* name) : MNullaryInstruction(classOpcode), name_(name) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(CallGetIntrinsicValue)\
  TRIVIAL_NEW_WRAPPERS\
  bool possiblyCalls() const override { return true; }\
};\
\
class MDeleteProperty : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  bool strict_;\
  explicit MDeleteProperty(MDefinition* value, PropertyName* name, bool strict) : MUnaryInstruction(classOpcode, value), name_(name), strict_(strict) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(DeleteProperty)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MDeleteElement : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  bool strict_;\
  explicit MDeleteElement(MDefinition* value, MDefinition* index, bool strict) : MBinaryInstruction(classOpcode, value, index), strict_(strict) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(DeleteElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, index))\
};\
\
class MValueToIterator : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MValueToIterator(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ValueToIterator)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MIteratorHasIndices : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MIteratorHasIndices(MDefinition* object, MDefinition* iterator) : MBinaryInstruction(classOpcode, object, iterator) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IteratorHasIndices)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, iterator))\
  AliasSet getAliasSet() const override;\
};\
\
class MLoadSlotByIteratorIndex : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MLoadSlotByIteratorIndex(MDefinition* object, MDefinition* iterator) : MBinaryInstruction(classOpcode, object, iterator) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadSlotByIteratorIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, iterator))\
  AliasSet getAliasSet() const override;\
};\
\
class MStoreSlotByIteratorIndex : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>, BoxPolicy<2>>::Data {\
  explicit MStoreSlotByIteratorIndex(MDefinition* object, MDefinition* iterator, MDefinition* value) : MTernaryInstruction(classOpcode, object, iterator, value) {\
  }\
 public:\
  INSTRUCTION_HEADER(StoreSlotByIteratorIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, iterator), (2, value))\
  AliasSet getAliasSet() const override;\
};\
\
class MLoadDOMExpandoValue : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MLoadDOMExpandoValue(MDefinition* proxy) : MUnaryInstruction(classOpcode, proxy) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadDOMExpandoValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLoadDOMExpandoValueIgnoreGeneration : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MLoadDOMExpandoValueIgnoreGeneration(MDefinition* proxy) : MUnaryInstruction(classOpcode, proxy) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadDOMExpandoValueIgnoreGeneration)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardDOMExpandoMissingOrGuardShape : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MGuardDOMExpandoMissingOrGuardShape(MDefinition* expando, Shape* shape) : MUnaryInstruction(classOpcode, expando), shape_(shape) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(GuardDOMExpandoMissingOrGuardShape)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, expando))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MStringLength : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MStringLength(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(StringLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MStringLength)\
};\
\
class MOptimizeSpreadCallCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MOptimizeSpreadCallCache(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(OptimizeSpreadCallCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MIteratorMore : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIteratorMore(MDefinition* iterator) : MUnaryInstruction(classOpcode, iterator) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(IteratorMore)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iterator))\
};\
\
class MIsNoIter : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MIsNoIter(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsNoIter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MIteratorEnd : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIteratorEnd(MDefinition* iterator) : MUnaryInstruction(classOpcode, iterator) {\
  }\
 public:\
  INSTRUCTION_HEADER(IteratorEnd)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iterator))\
};\
\
class MCloseIterCache : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  uint8_t completionKind_;\
  explicit MCloseIterCache(MDefinition* iter, uint8_t completionKind) : MUnaryInstruction(classOpcode, iter), completionKind_(completionKind) {\
  }\
 public:\
  uint8_t completionKind() const { return completionKind_; }\
  INSTRUCTION_HEADER(CloseIterCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iter))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MOptimizeGetIteratorCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MOptimizeGetIteratorCache(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(OptimizeGetIteratorCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MNewPrivateName : public MNullaryInstruction {\
  CompilerGCPointer<JSAtom*> name_;\
  explicit MNewPrivateName(JSAtom* name) : MNullaryInstruction(classOpcode), name_(name) {\
    setResultType(MIRType::Symbol);\
  }\
 public:\
  JSAtom* name() const { return name_; }\
  INSTRUCTION_HEADER(NewPrivateName)\
  TRIVIAL_NEW_WRAPPERS\
  bool possiblyCalls() const override { return true; }\
};\
\
class MInstanceOfCache : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MInstanceOfCache(MDefinition* obj, MDefinition* proto) : MBinaryInstruction(classOpcode, obj, proto) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(InstanceOfCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, obj), (1, proto))\
};\
\
class MArgumentsLength : public MNullaryInstruction {\
  explicit MArgumentsLength() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArgumentsLength)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MGetFrameArgument : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MGetFrameArgument(MDefinition* index) : MUnaryInstruction(classOpcode, index) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetFrameArgument)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGetFrameArgumentHole : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MGetFrameArgumentHole(MDefinition* index, MDefinition* length) : MBinaryInstruction(classOpcode, index, length) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetFrameArgumentHole)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index), (1, length))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MNewTarget : public MNullaryInstruction {\
  explicit MNewTarget() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(NewTarget)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MRest : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  unsigned numFormals_;\
  CompilerGCPointer<Shape*> shape_;\
  explicit MRest(MDefinition* numActuals, unsigned numFormals, Shape* shape) : MUnaryInstruction(classOpcode, numActuals), numFormals_(numFormals), shape_(shape) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  unsigned numFormals() const { return numFormals_; }\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(Rest)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, numActuals))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MAssertCanElidePostWriteBarrier : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MAssertCanElidePostWriteBarrier(MDefinition* object, MDefinition* value) : MBinaryInstruction(classOpcode, object, value) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(AssertCanElidePostWriteBarrier)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MNewNamedLambdaObject : public MNullaryInstruction {\
  CompilerGCPointer<NamedLambdaObject*> templateObj_;\
  explicit MNewNamedLambdaObject(NamedLambdaObject* templateObj) : MNullaryInstruction(classOpcode), templateObj_(templateObj) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  NamedLambdaObject* templateObj() const { return templateObj_; }\
  INSTRUCTION_HEADER(NewNamedLambdaObject)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MIsConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsCrossRealmArrayConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsCrossRealmArrayConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsCrossRealmArrayConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsObject : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MIsObject(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsNullOrUndefined : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MIsNullOrUndefined(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsNullOrUndefined)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool canConsumeFloat32(MUse* use) const override { return true; }\
};\
\
class MObjectClassToString : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MObjectClassToString(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(ObjectClassToString)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCheckReturn : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MCheckReturn(MDefinition* returnValue, MDefinition* thisValue) : MBinaryInstruction(classOpcode, returnValue, thisValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckReturn)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, returnValue), (1, thisValue))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCheckThis : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckThis(MDefinition* thisValue) : MUnaryInstruction(classOpcode, thisValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, thisValue))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MAsyncResolve : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MAsyncResolve(MDefinition* generator, MDefinition* value) : MBinaryInstruction(classOpcode, generator, value) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(AsyncResolve)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, generator), (1, value))\
};\
\
class MAsyncReject : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, BoxPolicy<2>>::Data {\
  explicit MAsyncReject(MDefinition* generator, MDefinition* reason, MDefinition* stack) : MTernaryInstruction(classOpcode, generator, reason, stack) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(AsyncReject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, generator), (1, reason), (2, stack))\
};\
\
class MGeneratorReturn : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MGeneratorReturn(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(GeneratorReturn)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MAsyncAwait : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MAsyncAwait(MDefinition* value, MDefinition* generator) : MBinaryInstruction(classOpcode, value, generator) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(AsyncAwait)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, generator))\
};\
\
class MCheckThisReinit : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckThisReinit(MDefinition* thisValue) : MUnaryInstruction(classOpcode, thisValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckThisReinit)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, thisValue))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCanSkipAwait : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCanSkipAwait(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(CanSkipAwait)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MIncrementWarmUpCounter : public MNullaryInstruction {\
  CompilerGCPointer<JSScript*> script_;\
  explicit MIncrementWarmUpCounter(JSScript* script) : MNullaryInstruction(classOpcode), script_(script) {\
  }\
 public:\
  JSScript* script() const { return script_; }\
  INSTRUCTION_HEADER(IncrementWarmUpCounter)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MCheckIsObj : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  uint8_t checkKind_;\
  explicit MCheckIsObj(MDefinition* value, uint8_t checkKind) : MUnaryInstruction(classOpcode, value), checkKind_(checkKind) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  uint8_t checkKind() const { return checkKind_; }\
  INSTRUCTION_HEADER(CheckIsObj)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCheckObjCoercible : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckObjCoercible(MDefinition* checkValue) : MUnaryInstruction(classOpcode, checkValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckObjCoercible)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, checkValue))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCheckClassHeritage : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckClassHeritage(MDefinition* heritage) : MUnaryInstruction(classOpcode, heritage) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckClassHeritage)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, heritage))\
};\
\
class MDebugCheckSelfHosted : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MDebugCheckSelfHosted(MDefinition* checkValue) : MUnaryInstruction(classOpcode, checkValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(DebugCheckSelfHosted)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, checkValue))\
};\
\
class MIsPackedArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsPackedArray(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsPackedArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
};\
\
class MGuardArrayIsPacked : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardArrayIsPacked(MDefinition* array) : MUnaryInstruction(classOpcode, array) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardArrayIsPacked)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, array))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGetPrototypeOf : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGetPrototypeOf(MDefinition* target) : MUnaryInstruction(classOpcode, target) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetPrototypeOf)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, target))\
};\
\
class MObjectWithProto : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MObjectWithProto(MDefinition* prototype) : MUnaryInstruction(classOpcode, prototype) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ObjectWithProto)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, prototype))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MBuiltinObject : public MNullaryInstruction {\
  BuiltinObjectKind builtinObjectKind_;\
  explicit MBuiltinObject(BuiltinObjectKind builtinObjectKind) : MNullaryInstruction(classOpcode), builtinObjectKind_(builtinObjectKind) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  BuiltinObjectKind builtinObjectKind() const { return builtinObjectKind_; }\
  INSTRUCTION_HEADER(BuiltinObject)\
  TRIVIAL_NEW_WRAPPERS\
  bool possiblyCalls() const override { return true; }\
};\
\
class MSuperFunction : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MSuperFunction(MDefinition* callee) : MUnaryInstruction(classOpcode, callee) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(SuperFunction)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, callee))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MInitHomeObject : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MInitHomeObject(MDefinition* function, MDefinition* homeObject) : MBinaryInstruction(classOpcode, function, homeObject) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(InitHomeObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function), (1, homeObject))\
  AliasSet getAliasSet() const override;\
};\
\
class MIsTypedArrayConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsTypedArrayConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsTypedArrayConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MLoadValueTag : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MLoadValueTag(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadValueTag)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLoadWrapperTarget : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  bool fallible_;\
  explicit MLoadWrapperTarget(MDefinition* object, bool fallible) : MUnaryInstruction(classOpcode, object), fallible_(fallible) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  bool fallible() const { return fallible_; }\
  INSTRUCTION_HEADER(LoadWrapperTarget)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardHasGetterSetter : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  jsid propId_;\
  CompilerGCPointer<GetterSetter*> getterSetter_;\
  explicit MGuardHasGetterSetter(MDefinition* object, jsid propId, GetterSetter* getterSetter) : MUnaryInstruction(classOpcode, object), propId_(propId), getterSetter_(getterSetter) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  jsid propId() const { return propId_; }\
  GetterSetter* getterSetter() const { return getterSetter_; }\
  INSTRUCTION_HEADER(GuardHasGetterSetter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGuardIsExtensible : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsExtensible(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsExtensible)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardInt32IsNonNegative : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MGuardInt32IsNonNegative(MDefinition* index) : MUnaryInstruction(classOpcode, index) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardInt32IsNonNegative)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardInt32Range : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  int32_t minimum_;\
  int32_t maximum_;\
  explicit MGuardInt32Range(MDefinition* input, int32_t minimum, int32_t maximum) : MUnaryInstruction(classOpcode, input), minimum_(minimum), maximum_(maximum) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  int32_t minimum() const { return minimum_; }\
  int32_t maximum() const { return maximum_; }\
  INSTRUCTION_HEADER(GuardInt32Range)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIndexIsNotDenseElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MGuardIndexIsNotDenseElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIndexIsNotDenseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIndexIsValidUpdateOrAdd : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MGuardIndexIsValidUpdateOrAdd(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIndexIsValidUpdateOrAdd)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MCallAddOrUpdateSparseElement : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>, BoxPolicy<2>>::Data {\
  bool strict_;\
  explicit MCallAddOrUpdateSparseElement(MDefinition* object, MDefinition* index, MDefinition* value, bool strict) : MTernaryInstruction(classOpcode, object, index, value), strict_(strict) {\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(CallAddOrUpdateSparseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index), (2, value))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallGetSparseElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCallGetSparseElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CallGetSparseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallNativeGetElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCallNativeGetElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CallNativeGetElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallNativeGetElementSuper : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>, BoxPolicy<2>>::Data {\
  explicit MCallNativeGetElementSuper(MDefinition* object, MDefinition* index, MDefinition* receiver) : MTernaryInstruction(classOpcode, object, index, receiver) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CallNativeGetElementSuper)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index), (2, receiver))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallObjectHasSparseElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCallObjectHasSparseElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setGuard();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(CallObjectHasSparseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MBigIntAsIntN : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, BigIntPolicy<1>>::Data {\
  explicit MBigIntAsIntN(MDefinition* bits, MDefinition* input) : MBinaryInstruction(classOpcode, bits, input) {\
    setMovable();\
    setResultType(MIRType::BigInt);\
  }\
 public:\
  INSTRUCTION_HEADER(BigIntAsIntN)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, bits), (1, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MBigIntAsIntN)\
};\
\
class MBigIntAsUintN : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, BigIntPolicy<1>>::Data {\
  explicit MBigIntAsUintN(MDefinition* bits, MDefinition* input) : MBinaryInstruction(classOpcode, bits, input) {\
    setMovable();\
    setResultType(MIRType::BigInt);\
  }\
 public:\
  INSTRUCTION_HEADER(BigIntAsUintN)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, bits), (1, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MBigIntAsUintN)\
};\
\
class MGuardNonGCThing : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MGuardNonGCThing(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardNonGCThing)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MToHashableNonGCThing : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MToHashableNonGCThing(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ToHashableNonGCThing)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MToHashableString : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MToHashableString(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(ToHashableString)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MToHashableValue : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MToHashableValue(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ToHashableValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MHashNonGCThing : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MHashNonGCThing(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(HashNonGCThing)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MHashString : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MHashString(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(HashString)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MHashSymbol : public MUnaryInstruction, public SymbolPolicy<0>::Data {\
  explicit MHashSymbol(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(HashSymbol)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MHashBigInt : public MUnaryInstruction, public BigIntPolicy<0>::Data {\
  explicit MHashBigInt(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(HashBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MHashObject : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MHashObject(MDefinition* set, MDefinition* input) : MBinaryInstruction(classOpcode, set, input) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(HashObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set), (1, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MHashValue : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MHashValue(MDefinition* set, MDefinition* input) : MBinaryInstruction(classOpcode, set, input) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(HashValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set), (1, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MSetObjectHasNonBigInt : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MSetObjectHasNonBigInt(MDefinition* set, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, set, value, hash) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SetObjectHasNonBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MSetObjectHasBigInt : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MSetObjectHasBigInt(MDefinition* set, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, set, value, hash) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SetObjectHasBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MSetObjectHasValue : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MSetObjectHasValue(MDefinition* set, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, set, value, hash) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SetObjectHasValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MSetObjectHasValueVMCall : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MSetObjectHasValueVMCall(MDefinition* set, MDefinition* value) : MBinaryInstruction(classOpcode, set, value) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SetObjectHasValueVMCall)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set), (1, value))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MSetObjectSize : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MSetObjectSize(MDefinition* set) : MUnaryInstruction(classOpcode, set) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(SetObjectSize)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, set))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectHasNonBigInt : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MMapObjectHasNonBigInt(MDefinition* map, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, map, value, hash) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectHasNonBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectHasBigInt : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MMapObjectHasBigInt(MDefinition* map, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, map, value, hash) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectHasBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectHasValue : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MMapObjectHasValue(MDefinition* map, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, map, value, hash) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectHasValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectHasValueVMCall : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MMapObjectHasValueVMCall(MDefinition* map, MDefinition* value) : MBinaryInstruction(classOpcode, map, value) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectHasValueVMCall)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMapObjectGetNonBigInt : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MMapObjectGetNonBigInt(MDefinition* map, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, map, value, hash) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectGetNonBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectGetBigInt : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MMapObjectGetBigInt(MDefinition* map, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, map, value, hash) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectGetBigInt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectGetValue : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MMapObjectGetValue(MDefinition* map, MDefinition* value, MDefinition* hash) : MTernaryInstruction(classOpcode, map, value, hash) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectGetValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value), (2, hash))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MMapObjectGetValueVMCall : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MMapObjectGetValueVMCall(MDefinition* map, MDefinition* value) : MBinaryInstruction(classOpcode, map, value) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectGetValueVMCall)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map), (1, value))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMapObjectSize : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MMapObjectSize(MDefinition* map) : MUnaryInstruction(classOpcode, map) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(MapObjectSize)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, map))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmBoundsCheckRange32 : public MTernaryInstruction, public NoTypePolicy::Data {\
  wasm::BytecodeOffset bytecodeOffset_;\
  explicit MWasmBoundsCheckRange32(MDefinition* index, MDefinition* length, MDefinition* limit, wasm::BytecodeOffset bytecodeOffset) : MTernaryInstruction(classOpcode, index, length, limit), bytecodeOffset_(bytecodeOffset) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  wasm::BytecodeOffset bytecodeOffset() const { return bytecodeOffset_; }\
  INSTRUCTION_HEADER(WasmBoundsCheckRange32)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index), (1, length), (2, limit))\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmExtendU32Index : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmExtendU32Index(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int64);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmExtendU32Index)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmWrapU32Index : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmWrapU32Index(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmWrapU32Index)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmFence : public MNullaryInstruction {\
  explicit MWasmFence() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(WasmFence)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  ALLOW_CLONE(MWasmFence)\
};\
\
class MWasmStackSwitchToMain : public MTernaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmStackSwitchToMain(MDefinition* suspender, MDefinition* fn, MDefinition* data) : MTernaryInstruction(classOpcode, suspender, fn, data) {\
  }\
 public:\
  INSTRUCTION_HEADER(WasmStackSwitchToMain)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, suspender), (1, fn), (2, data))\
};\
\
class MWasmStackSwitchToSuspendable : public MTernaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmStackSwitchToSuspendable(MDefinition* suspender, MDefinition* fn, MDefinition* data) : MTernaryInstruction(classOpcode, suspender, fn, data) {\
  }\
 public:\
  INSTRUCTION_HEADER(WasmStackSwitchToSuspendable)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, suspender), (1, fn), (2, data))\
};\
\
class MWasmStackContinueOnSuspendable : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmStackContinueOnSuspendable(MDefinition* suspender) : MUnaryInstruction(classOpcode, suspender) {\
  }\
 public:\
  INSTRUCTION_HEADER(WasmStackContinueOnSuspendable)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, suspender))\
};\
\
class MWasmShiftSimd128 : public MBinaryInstruction, public NoTypePolicy::Data {\
  wasm::SimdOp simdOp_;\
  explicit MWasmShiftSimd128(MDefinition* lhs, MDefinition* rhs, wasm::SimdOp simdOp) : MBinaryInstruction(classOpcode, lhs, rhs), simdOp_(simdOp) {\
    setMovable();\
    setResultType(MIRType::Simd128);\
  }\
 public:\
  wasm::SimdOp simdOp() const { return simdOp_; }\
  INSTRUCTION_HEADER(WasmShiftSimd128)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, lhs), (1, rhs))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
  ALLOW_CLONE(MWasmShiftSimd128)\
};\
\
class MWasmShuffleSimd128 : public MBinaryInstruction, public NoTypePolicy::Data {\
  SimdShuffle shuffle_;\
  explicit MWasmShuffleSimd128(MDefinition* lhs, MDefinition* rhs, SimdShuffle shuffle) : MBinaryInstruction(classOpcode, lhs, rhs), shuffle_(shuffle) {\
    setMovable();\
    setResultType(MIRType::Simd128);\
  }\
 public:\
  SimdShuffle shuffle() const { return shuffle_; }\
  INSTRUCTION_HEADER(WasmShuffleSimd128)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, lhs), (1, rhs))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
  ALLOW_CLONE(MWasmShuffleSimd128)\
};\
\
class MWasmUnarySimd128 : public MUnaryInstruction, public NoTypePolicy::Data {\
  wasm::SimdOp simdOp_;\
  explicit MWasmUnarySimd128(MDefinition* src, wasm::SimdOp simdOp) : MUnaryInstruction(classOpcode, src), simdOp_(simdOp) {\
    setMovable();\
    setResultType(MIRType::Simd128);\
  }\
 public:\
  wasm::SimdOp simdOp() const { return simdOp_; }\
  INSTRUCTION_HEADER(WasmUnarySimd128)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, src))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
  ALLOW_CLONE(MWasmUnarySimd128)\
};\


#define NON_GC_POINTER_TYPE_ASSERTIONS_GENERATED \
static_assert(!std::is_base_of_v<gc::Cell, BuiltinObjectKind>, "Ensure that BuiltinObjectKind is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, FunctionFlags>, "Ensure that FunctionFlags is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, FunctionFlags::FunctionKind>, "Ensure that FunctionFlags::FunctionKind is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, MemoryBarrierRequirement>, "Ensure that MemoryBarrierRequirement is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, PropertyKey>, "Ensure that PropertyKey is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, RealmFuses::FuseIndex>, "Ensure that RealmFuses::FuseIndex is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, SimdShuffle>, "Ensure that SimdShuffle is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, bool>, "Ensure that bool is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, const void>, "Ensure that const void is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, gc::Heap>, "Ensure that gc::Heap is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, int32_t>, "Ensure that int32_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, jsid>, "Ensure that jsid is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, size_t>, "Ensure that size_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, uint16_t>, "Ensure that uint16_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, uint32_t>, "Ensure that uint32_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, uint8_t>, "Ensure that uint8_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, unsigned>, "Ensure that unsigned is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, wasm::BytecodeOffset>, "Ensure that wasm::BytecodeOffset is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, wasm::FieldWideningOp>, "Ensure that wasm::FieldWideningOp is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, wasm::SimdOp>, "Ensure that wasm::SimdOp is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, wasm::Trap>, "Ensure that wasm::Trap is added to the gc_pointer_types list in GenerateMIRFiles.py.");



#endif // jit_MIROpsGenerated_h
