Minutes from 159th OpenVDB TSC meeting, January 17th, 2023

Attendees: *Jeff* L., *Andre* P, *Dan* B., *Ken* M., *Nick* A., *Greg*
H., *Rich* J.

Additional Attendees: Peyton Murray

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) Python Bindings
5) Hollow VDB
6) UUID Update
7) ASWF Annual Meeting
8) VDB Merge Max
9) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait.

3) Forum

There is one question about the sharp edges reconstruction that exists
in Houdini but not the core library.  This has been discussed
previously where we will be happy with someone porting the available
code into the core library.

4) Python Bindings

Peyton added some automatons to cmake to support python.  But
pyopenvdb exists, so we can't publish.  We need the owner's permission
to take over, but have not been able to get consistent reply.   So
perhaps we should publish as openvdb bindings on PyPi.  We have a PR
to make all the python bindings pybind11.  Changing the name to
openvdb seems totally fine.  Peyton will put it on hold until the
pybind11 is done.  Renaming the module is most useful if we changed
the API.  We could deprecate the old pyopenvdb vs openvdb?  Maybe
pybind11 could publish to openvdb and old one publishes to pyopenvdb?

Conclusion: pybind11 will publish to openvdb and we do not have to overtake
the pyopenvdb package.

Peyton will summarize this on the existing automation PR.

5) Hollow VDB

Discussion of the problem with dual contouring not matching the
interpolation.  In magnification this can become quite severe so the
oracle will set entire tiles to the wrong sign.  However,
mangnification is also the case where there is little need for the
dual contouring other than avoiding building a fat band.  The plan is
to investigate resampling top-down a narrow band for the magnification
case and see how well it works.

This would be the rebuild changes behaviour depending on magnification
vs minification.


6) UUID Update

Can the UUID in the file system be an arbitrary tag?  It is just a
random string.   We can support blank strings to mean no uuid that
always fails comparison checks.  std::random_device can throw so we
need a sensible action in that case.

Why do we have UUID in vdb tools?  It currently is only 32 bits of
entropy, so has to be changed to cycle from std::random_device
instead.

7) ASWF Annual Meeting

The meeting is on February 17th.  TSC updates are now optional.  We
have to ask to present rather than mandatory presentation.  There are
10, 20, and 40 minutes timeslots.  Do we have any updates?

Conclusion: We will not have a presentation as our forward looking
report hasn't changed overmuch.

There is both a public part, and a governing board meeting that is
closed.  The second half requires a set of bullet points.  

Do we do a siggraph presentation?

Bullet points are due January 19th.  We should point out that the paid
runners in github actions made a big improvement for our last release.

We can commit to making Boost optional.

We can list as likely having pybind11, hollow VDB, half support, and
vdb blend-fillet.

We should consider a siggraph course this year.  Next meeting is to
discuss farther.

8) VDB Merge Max

VDB Combine and Max produce different activation rules.   Inactive
non-background values in particular are causing issues.  If an
inactive voxel has the larger value, does it copy the inactivity?

This seems to be something that should be an option?   Should inactive
voxels contribute at all?

Max seems it should be order independent with the inactivity copying,
which seems contrary to the usual symmetry for Max.

How do we expose an option?  Do we say Max with Active and Max
without?  Maybe a transfer active state toggle?

Unioning the two active states seems best? Or still needs to be an
option?  Or do we just ignore inactive entirely? 

What is should an empty grid with background value of ten which you
max with a grid with topology with values less than ten result in?  Is
it the same topology set to 10?  Or is it blown away empty grid with
background value of 10?

VDB Combine explicitly sets a union topology.  By definition, it
unions topology and then applies the per-voxel operation.

In general, we need a tool to set inactive values to background value.

This ties back to inactive voxels containing non-background values.  A
lot of tools just use inactive as mask.   And a lot of tools act as if
inactive doesn't exist.

So long as we document the choices we are okay with any particular
answer to this.  Outside that is undefined behavior.  

9) Next meeting

Next meeting is on January 24th, 2023. 2pm-3pm EDT (GMT-4).
