/*
 * STAN -- Stream Analyser -- http://www.roqe.org/stan
 * Copyright (c) 2001-2004 Konrad Rieck <kr@roqe.org> 
 * All rights reserved.
 * ---
 * $Id: bintree.h,v 1.4 2003/12/10 20:29:29 kr Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    ``This product includes software developed by Konrad Rieck.''
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _BINTREE_H
#define _BINTREE_H

typedef struct bnode bnode_t;

struct bnode {
   size_t run;
   size_t count_false, count_true;
   bnode_t *left, *right, *parent;
};

void bfree(bnode_t * bnode);
void btraverse(bnode_t ** bnode, void (*func) (bnode_t *), int order);
void init_bintree();
void free_bintree();
bnode_t **blocate(bnode_t ** bnode, size_t run);
size_t bhigh(bnode_t ** bnode);
void bprint(bnode_t * bnode);
void binsert(bnode_t ** bnode, size_t run, int bit);
size_t bdepth(bnode_t ** bnode);
bnode_t **bmax(bnode_t ** bnode);
bnode_t **bmin(bnode_t ** bnode);
bnode_t **bsuccessor(bnode_t ** bnode);
bnode_t **bpredecessor(bnode_t ** bnode);
size_t bsize_total(bnode_t ** bnode, int bit);
size_t bsize_bnodes(bnode_t ** bnode, int bit);

#endif /* _BINTREE_H */
