/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.classfile.ClassLoaderData;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.HashtableEntry;

public class PlaceholderEntry
extends HashtableEntry {
    private static AddressField loaderDataField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("PlaceholderEntry");
        loaderDataField = type.getAddressField("_loader_data");
    }

    public Oop loader() {
        return this.loaderData().getClassLoader();
    }

    public ClassLoaderData loaderData() {
        return ClassLoaderData.instantiateWrapperFor(loaderDataField.getValue(this.addr));
    }

    public PlaceholderEntry(Address addr) {
        super(addr);
    }

    public Symbol klass() {
        return Symbol.create(this.literalValue());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                PlaceholderEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

