/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.javax.rmi;

import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class PortableRemoteObject
implements PortableRemoteObjectDelegate {
    @Override
    public void exportObject(Remote remote) throws RemoteException {
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (Util.getTie(remote) != null) {
            throw new ExportException(remote.getClass().getName() + " already exported");
        }
        Tie tie = Utility.loadTie(remote);
        if (tie != null) {
            Util.registerTarget(tie, remote);
        } else {
            UnicastRemoteObject.exportObject(remote);
        }
    }

    @Override
    public Remote toStub(Remote remote) throws NoSuchObjectException {
        Remote remote2 = null;
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (StubAdapter.isStub(remote)) {
            return remote;
        }
        if (remote instanceof RemoteStub) {
            return remote;
        }
        Tie tie = Util.getTie(remote);
        if (tie != null) {
            remote2 = Utility.loadStub(tie, null, null, true);
        } else if (Utility.loadTie(remote) == null) {
            remote2 = RemoteObject.toStub(remote);
        }
        if (remote2 == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return remote2;
    }

    @Override
    public void unexportObject(Remote remote) throws NoSuchObjectException {
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (StubAdapter.isStub(remote) || remote instanceof RemoteStub) {
            throw new NoSuchObjectException("Can only unexport a server object.");
        }
        Tie tie = Util.getTie(remote);
        if (tie != null) {
            Util.unexportObject(remote);
        } else if (Utility.loadTie(remote) == null) {
            UnicastRemoteObject.unexportObject(remote, true);
        } else {
            throw new NoSuchObjectException("Object not exported.");
        }
    }

    @Override
    public java.lang.Object narrow(java.lang.Object object, Class clazz) throws ClassCastException {
        java.lang.Object var3_3 = null;
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new NullPointerException("invalid argument");
        }
        try {
            if (clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
            if (clazz.isInterface() && clazz != Serializable.class && clazz != Externalizable.class) {
                Object object2 = (Object)object;
                String string = RepositoryId.createForAnyType(clazz);
                if (object2._is_a(string)) {
                    return Utility.loadStub(object2, clazz);
                }
                throw new ClassCastException("Object is not of remote type " + clazz.getName());
            }
            throw new ClassCastException("Class " + clazz.getName() + " is not a valid remote interface");
        }
        catch (Exception exception) {
            ClassCastException classCastException = new ClassCastException();
            classCastException.initCause(exception);
            throw classCastException;
        }
    }

    @Override
    public void connect(Remote remote, Remote remote2) throws RemoteException {
        if (remote == null || remote2 == null) {
            throw new NullPointerException("invalid argument");
        }
        ORB oRB = null;
        try {
            if (StubAdapter.isStub(remote2)) {
                oRB = StubAdapter.getORB(remote2);
            } else {
                Tie tie = Util.getTie(remote2);
                if (tie != null) {
                    oRB = tie.orb();
                }
            }
        }
        catch (SystemException systemException) {
            throw new RemoteException("'source' object not connected", systemException);
        }
        boolean bl = false;
        Tie tie = null;
        if (StubAdapter.isStub(remote)) {
            bl = true;
        } else {
            tie = Util.getTie(remote);
            if (tie != null) {
                bl = true;
            }
        }
        if (!bl) {
            if (oRB != null) {
                throw new RemoteException("'source' object exported to IIOP, 'target' is JRMP");
            }
        } else {
            if (oRB == null) {
                throw new RemoteException("'source' object is JRMP, 'target' is IIOP");
            }
            try {
                if (tie != null) {
                    try {
                        ORB oRB2 = tie.orb();
                        if (oRB2 == oRB) {
                            return;
                        }
                        throw new RemoteException("'target' object was already connected");
                    }
                    catch (SystemException systemException) {
                        tie.orb(oRB);
                    }
                } else {
                    StubAdapter.connect(remote, oRB);
                }
            }
            catch (SystemException systemException) {
                throw new RemoteException("'target' object was already connected", systemException);
            }
        }
    }
}

