#!/usr/bin/env python3


"""

""" """

This file is part of csharp-gentoodotnetinfo - .NET information tool for Gentoo.
Copyright (c) 2023, Maciej Barć <xgqt@riseup.net>
Licensed under the GNU GPL v2 License
SPDX-License-Identifier: GPL-2.0-or-later

csharp-gentoodotnetinfo is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

csharp-gentoodotnetinfo is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with csharp-gentoodotnetinfo.  If not, see <https://www.gnu.org/licenses/>.
"""


from os import chdir
from os import path

from dataclasses import dataclass
from shutil import which
from subprocess import run
from sys import argv


@dataclass
class Make():
    """! Configure make with passed in settings."""

    subproject_path: str
    dotnet_executable: str
    dotnet_output_directory: str

    def run(self, targets):
        """! Run make."""

        make_executable = which("gmake") or which("make")

        run(
            [
                make_executable,
                "-s",
                "-C",
                self.subproject_path,
                f"DOTNET={self.dotnet_executable}",
                f"DOTNET-OUTPUT={self.dotnet_output_directory}",
            ] + targets,
            check=True,
        )


def main():
    """! Main."""

    script_path = path.realpath(__file__)
    script_root = path.dirname(script_path)

    source_root = path.realpath(path.join(script_root, ".."))
    build_path = path.join(source_root, "..", "..", "Build")

    build_dir_path = path.join(build_path, "v1_dotnet_BuildDir")

    dotnet_executable = argv[1]
    make_targets = argv[2::]

    subproject_path = path.join(source_root, "gentoo-dotnet-info-app")
    dotnet_output_directory = path.join(build_dir_path, "output")

    print(f" * Entering directory: {subproject_path}")
    chdir(subproject_path)

    make = Make(subproject_path, dotnet_executable, dotnet_output_directory)

    make.run(make_targets)


if __name__ == "__main__":
    main()
