<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

September 21, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [X] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [ ] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Thomas Mansencal - Weta Digital
  * [X] Simran Spiller

Apologies:
  * Mark Titchener

# **OCIO TSC Meeting Notes**

* Some pending pull requests (1130, 1133 and 1134):
    - Patrick: Three PRs needing review, ready to merge
      - 1130: Cache processing - also topics related to context variables.
      - 1133: Improved grading ops - no feature changes, just fixing some 
        issues.
      - 1134: Not new, but some changes to VFX ref platform (CY2021). Updated 
        Makefile to adhere to that. Not a feature.

* Some ‘small’ pull requests (1146 and 1551) which help contributors testing 
  using the Windows platform:
    - Patrick: Important for Windows platform, to be merged ASAP
      - Removing MFC dependency.
      - Improvement for Python 3.8 support, small change (From Simran).
    - Michael: 1140: PROCESS.md proposal needs additional reviewers.

* Building on Windows requires the build/config type to be specified up to 
  three times, how to default to CMAKE_BUILD_TYPE? (issue #1153):
    - Mark: CMake build type not respected on windows. Different way to 
      describe targets. On Linux generates Makefiles, but on Windows 
      generates MSVC project, where debug, release etc. is decided. Huge pain 
      in Windows. Have to keep the same flags for all dependencies. If you 
      build one thing with different flags, and one package is wrong, the whole 
      thing will fail. If we give pre-built binaries, they are stuck with the 
      build modes we provide. Other projects have turned own project into meta 
      builder that first builds dependencies, and then builds package.
    - Michael: OCIO_INSTALL_EXT_PACKAGES does something similar, but not in one 
      single solution.
    - Mark: Only works if they are all in one MSVC project, Needs meta project. 
      Usually not worth it. Either users are on their own, or we provide 
      instructions on how to build.
    - Michael: Can documenting the process for now.
    - Patrick: Not a fix, but workaround. Ninja could also work.
    - Mark: Same linking issue regardless of generator. MSVC linker used with 
      Ninja or VSProject. All will have the same problems. How Windows builds 
      dynamic libraries and sets optimization flags.
    - Patrick: Perhaps something is missing in OCIO project.
    - Mark: Because we statically link all these dependencies. Hard to enforce 
      passing the same flags though. Especially if sub-projects have own cmake 
      projects, since one can break the entire chain. Have to massage each. 
      yaml-cpp is the first offender for breaking the linkage.
    - Patrick: Already have a problem with one dependency not using 
      CMAKE_BUILD_TYPE.
    - Mark: On Windows doesn't matter at all. XCode generator has similar 
      problem on macOS.
    - Patrick: Document on Windows for now, and add something missing if we 
      find better solution later. New VS 2019 also introducing problems by 
      itself.
    - Thomas: Should follow VFX platform, mandates VS version now. If you want 
      to be compliant on Windows, use 2017.
    - Michael: CI VMs use 2019, no option to use other version without a 
      container. hopefully can find solution in CI working group.
    - Simran: There is in fact an option with GHA: the windows-2016 virtual 
      environment has VS 2017. But it's some 2017 version that GitHub updates 
      every now and then, no control over the exact compiler version (but will 
      always be 2017).

* TSC opinions on C++/Python API Docs Generation (Issue #1148):
    - Sean: Just RTD was problematic. Everything else working well. All 
      features listed in issue work well locally, but RTD can't do what we 
      need. Other projects have made hacks with skeleton python bindings, but 
      unless you automate it, it drifts.
    - Doug: One thing discussing in documenting wg - we want to know who our 
      customer is. Feedback is that biggest customer of web based API docs is 
      python developers since C++ devs will often just go to the headers and 
      dev env. If Python user is target, and since there are some significant 
      differences, question came up as to whether we should target python 
      specifically. IS C++ docs needed? Question to raise, not suggesting one 
      or the other.
    - Carl: As C++ dev, we generally just look at header since html docs are 
      usually pretty lacking.
    - Mark: Useful for showing someone relevant part of docs, link to html.
    - Carl: As long as it's well documented. In v1 was primarily looking at 
      python docs. Would prefer html, but at end of day, well documented header 
      is most accurate. Local host of docs may not be up to date. API 
      differences, etc.
    - Thomas: Other example is if you look at Qt. There is no python docs, but 
      python developer uses C++ docs to work on python. May not even need python 
      docs. Possibility to use C++ docs.
    - Mark: Easier now that they are similar, but were different before. We'll 
      have similar problems with more pythonic API.
    - Carol: All of us are going do what we're comfortable with, but for new 
      users a well documented python API will be very helpful.
    - Sean: This is why I proposed using matching C++ and Python, which still 
      allows for overriding python docstrings where they differ. Just RTD 
      getting in the way.
    - Mark: Still no appetite to offline doc build and upload to branch?
    - Sean: Could put website on RTD and docs on GH branches, but lose API 
      versioning. If we only do python docs, could be something different. 
      Either have to make scripts to generate skeleton code, or someone working 
      fulltime on skelton code.
    - Mark: Is RTD appetite for us not wanting us to host ourselves? Could be 
      our instance of RTD.
    - Thomas: Might be worth looking at what matplotlib does. Building docs 
      themselves and supporting versions. NumPy and SciPy too.
    - Sean: If we do something custom there are many possibilities.
    - Doug: RTD is very responsive. Updates quickly.
    - Michael: Can we push docs to RTD?
    - Thomas: Was not possible when I looked, but may now. Can pay for hosting. 
      Might be possible.
    - Michael: Could use Sean's work, but just rework deployment.
    - Sean: Agree.
    - Mark: RTD business account could solve it.
    - Sean: Not sure if we can build all of OCIO. Would have to do dependencies.
    - John: Might be a good Andy question on RTD. Most projects using free 
      tier, but if it's something projects want, can investigate. Some services 
      have non-profit discounts.
    - Carl: OIIO is on RTD; should check with Larry.
    - Thomas: Basic price $50/month. Advanced $100/month.
    - Michael: Any objection to Sean's approach with new deployment method? 
    - Doug: Any current example of Python API override? Transitioning from 
      previous system, so unless you see the output, it's hard to make final 
      call. We've been discussing doxygen limitations. Either not converting 
      header files properly, or some underlying problems.
    - Patrick: API documentation quite broken now since mix of doxygen and 
      previous approach. In C++ API, greatly increases size of headers. Would 
      be good to have commitment if we stick to doxygen or stick to previous 
      format since we have to mix right now. Not pleasant currently. Decision 
      of syntax.
    - Sean: Shouldn't need to mix rst and doxygen. Right now docs cmake target 
      not generating API docs at all, since those features break RTD. From user 
      standpoint should be handled on backend.
    - Doug: Other point is how verbose we want to be if we convert to doxygen. 
      Old docs were pretty minimal, for functions not needing explanation. 
      Adding obvious comments will bloat the headers. Is that a change we want 
      to make?
    - Sean: Need to see what autodoc and breathe do. May do something default.
    - Mark: Can docs be separated from header?
    - Sean: Probably possible, current solution based on what breathe supports 
      on sphinx side. Not sure.
    - Patrick: Can a test be shared for analysis?
    - Sean: Will do some cleanup and push something.

* Foundry SDK usage in CI environment:
    - Josh: Foundry asked about OCIO needing Foundry license for CI. Was that 
      requested?
    - Not that anyone is aware of. May be useful in future depending on how 
      Foundry distribute plugins.

* Ongoing priorities for stabilization period:
    - Doug: Two components. Were looking to get feedback from implementors. Had 
      some feedback with a logged issue. One main goal at SIGGRAPH was to raise 
      awareness. Hopefully that message went out and starting to be looked at. 
      Hopefully comments start trickling in are assigned to dev roadmaps.
        - As people do have time to contribute, we'd like help with some 
          issues. Will be posted to GH as help-wanted label issues. High 
          priority items we need help with.
