// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package abi

import (
	"math/big"
	"strings"

	ethereum "energi.world/core/gen3"
	"energi.world/core/gen3/accounts/abi"
	"energi.world/core/gen3/accounts/abi/bind"
	"energi.world/core/gen3/common"
	"energi.world/core/gen3/core/types"
	"energi.world/core/gen3/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = abi.U256
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// CheckpointRegistryV2ABI is the input ABI used to generate the binding from.
const CheckpointRegistryV2ABI = "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_proxy\",\"type\":\"address\"},{\"internalType\":\"contractIGovernedProxy\",\"name\":\"_mnregistry_proxy\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_cpp_signer\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"},{\"indexed\":false,\"internalType\":\"contractICheckpoint\",\"name\":\"checkpoint\",\"type\":\"address\"}],\"name\":\"Checkpoint\",\"type\":\"event\"},{\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"fallback\"},{\"constant\":true,\"inputs\":[],\"name\":\"CPP_signer\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"checkpoints\",\"outputs\":[{\"internalType\":\"contractICheckpoint[]\",\"name\":\"\",\"type\":\"address[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_newImpl\",\"type\":\"address\"}],\"name\":\"destroy\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_oldImpl\",\"type\":\"address\"}],\"name\":\"migrate\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"mnregistry_proxy\",\"outputs\":[{\"internalType\":\"contractIGovernedProxy\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"},{\"internalType\":\"bytes\",\"name\":\"signature\",\"type\":\"bytes\"}],\"name\":\"propose\",\"outputs\":[{\"internalType\":\"contractICheckpoint\",\"name\":\"checkpoint\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"proxy\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractICheckpoint\",\"name\":\"checkpoint\",\"type\":\"address\"},{\"internalType\":\"bytes\",\"name\":\"signature\",\"type\":\"bytes\"}],\"name\":\"sign\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"}],\"name\":\"signatureBase\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"sigbase\",\"type\":\"bytes32\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"v1storage\",\"outputs\":[{\"internalType\":\"contractStorageCheckpointRegistryV1\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"

// CheckpointRegistryV2Bin is the compiled bytecode used for deploying new contracts.
const CheckpointRegistryV2Bin = `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`

// DeployCheckpointRegistryV2 deploys a new Ethereum contract, binding an instance of CheckpointRegistryV2 to it.
func DeployCheckpointRegistryV2(auth *bind.TransactOpts, backend bind.ContractBackend, _proxy common.Address, _mnregistry_proxy common.Address, _cpp_signer common.Address) (common.Address, *types.Transaction, *CheckpointRegistryV2, error) {
	parsed, err := abi.JSON(strings.NewReader(CheckpointRegistryV2ABI))
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	address, tx, contract, err := bind.DeployContract(auth, parsed, common.FromHex(CheckpointRegistryV2Bin), backend, _proxy, _mnregistry_proxy, _cpp_signer)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &CheckpointRegistryV2{CheckpointRegistryV2Caller: CheckpointRegistryV2Caller{contract: contract}, CheckpointRegistryV2Transactor: CheckpointRegistryV2Transactor{contract: contract}, CheckpointRegistryV2Filterer: CheckpointRegistryV2Filterer{contract: contract}}, nil
}

// CheckpointRegistryV2Bin is the compiled bytecode of contract after deployment.
const CheckpointRegistryV2RuntimeBin = `608060405260043610620000c15760003560e01c8063c20fa2ee1162000073578063d59f17581162000055578063d59f1758146200021f578063ec5568891462000246578063fe7334e8146200025e57620000c1565b8063c20fa2ee14620001d5578063ce5494bb14620001fa57620000c1565b806351fae95911620000a957806351fae95914620001555780635a48c0b0146200017a578063851f220914620001a157620000c1565b8062f55d9d14620000fe5780632d0593051462000125575b6040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401620000f59062000fe2565b60405180910390fd5b3480156200010b57600080fd5b50620001236200011d36600462000b87565b62000276565b005b3480156200013257600080fd5b506200013d620002ee565b6040516200014c919062000f3e565b60405180910390f35b3480156200016257600080fd5b50620001236200017436600462000b2b565b6200030a565b3480156200018757600080fd5b506200019262000399565b6040516200014c919062000e9b565b348015620001ae57600080fd5b50620001c6620001c036600462000aec565b62000467565b6040516200014c919062000eb5565b348015620001e257600080fd5b506200013d620001f436600462000bc9565b6200049c565b3480156200020757600080fd5b50620001236200021936600462000b87565b62000708565b3480156200022c57600080fd5b50620002376200076a565b6040516200014c919062000e8b565b3480156200025357600080fd5b506200023762000786565b3480156200026b57600080fd5b506200013d620007a2565b60005473ffffffffffffffffffffffffffffffffffffffff163314620002ca576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401620000f59062000fac565b620002d581620007be565b8073ffffffffffffffffffffffffffffffffffffffff16ff5b60015473ffffffffffffffffffffffffffffffffffffffff1681565b6040517f76cd7cbc00000000000000000000000000000000000000000000000000000000815273ffffffffffffffffffffffffffffffffffffffff8416906376cd7cbc9062000360908590859060040162000f2a565b600060405180830381600087803b1580156200037b57600080fd5b505af115801562000390573d6000803e3d6000fd5b50505050505050565b600154604080517fd9592ead000000000000000000000000000000000000000000000000000000008152905160609273ffffffffffffffffffffffffffffffffffffffff169163d9592ead916004808301926000929190829003018186803b1580156200040557600080fd5b505afa1580156200041a573d6000803e3d6000fd5b505050506040513d6000823e601f3d9081017fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe016820160405262000462919081019062000aab565b905090565b600082826040516020016200047e92919062000e54565b60405160208183030381529060405280519060200120905092915050565b600080620004ab868662000467565b905060418314620004ea576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401620000f59062000fd0565b600080620004fb8587018762000aec565b600354919350915073ffffffffffffffffffffffffffffffffffffffff16600184888860408181106200052a57fe5b6040805160008152602001908190526200055294939091013560f81c91508790879062000ee4565b6020604051602081039080840390855afa15801562000575573d6000803e3d6000fd5b5050506020604051035173ffffffffffffffffffffffffffffffffffffffff1614620005cf576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401620000f59062000fbe565b600260009054906101000a900473ffffffffffffffffffffffffffffffffffffffff16888885898960405162000605906200099b565b620006169695949392919062000f4e565b604051809103906000f08015801562000633573d6000803e3d6000fd5b506001546040517f0a3b0a4f00000000000000000000000000000000000000000000000000000000815291955073ffffffffffffffffffffffffffffffffffffffff1690630a3b0a4f906200068d90879060040162000f3e565b600060405180830381600087803b158015620006a857600080fd5b505af1158015620006bd573d6000803e3d6000fd5b50505050877f7f582e7a234c68b135245365b0c69d608f9235392a1ef801b46f04ca5d6cdad48886604051620006f592919062000ec5565b60405180910390a2505050949350505050565b60005473ffffffffffffffffffffffffffffffffffffffff1633146200075c576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401620000f59062000fac565b62000767816200084d565b50565b60035473ffffffffffffffffffffffffffffffffffffffff1681565b60005473ffffffffffffffffffffffffffffffffffffffff1681565b60025473ffffffffffffffffffffffffffffffffffffffff1681565b6001546040517f13af403500000000000000000000000000000000000000000000000000000000815273ffffffffffffffffffffffffffffffffffffffff909116906313af4035906200081690849060040162000f3e565b600060405180830381600087803b1580156200083157600080fd5b505af115801562000846573d6000803e3d6000fd5b5050505050565b600160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff166341c0e1b56040518163ffffffff1660e01b8152600401600060405180830381600087803b158015620008b857600080fd5b505af1158015620008cd573d6000803e3d6000fd5b505050508073ffffffffffffffffffffffffffffffffffffffff16632d0593056040518163ffffffff1660e01b815260040160206040518083038186803b1580156200091857600080fd5b505afa1580156200092d573d6000803e3d6000fd5b505050506040513d601f19601f8201168201806040525062000953919081019062000ba8565b600180547fffffffffffffffffffffffff00000000000000000000000000000000000000001673ffffffffffffffffffffffffffffffffffffffff9290921691909117905550565b6112c880620010e983390190565b600082601f830112620009bb57600080fd5b8151620009d2620009cc826200101c565b62000ff4565b91508181835260208401935060208101905083856020840282011115620009f857600080fd5b60005b8381101562000a28578162000a11888262000a9e565b8452506020928301929190910190600101620009fb565b5050505092915050565b803562000a3f81620010c6565b92915050565b60008083601f84011262000a5857600080fd5b50813567ffffffffffffffff81111562000a7157600080fd5b60208301915083600182028301111562000a8a57600080fd5b9250929050565b803562000a3f81620010dd565b805162000a3f81620010dd565b60006020828403121562000abe57600080fd5b815167ffffffffffffffff81111562000ad657600080fd5b62000ae484828501620009a9565b949350505050565b6000806040838503121562000b0057600080fd5b600062000b0e858562000a32565b925050602062000b218582860162000a32565b9150509250929050565b60008060006040848603121562000b4157600080fd5b600062000b4f868662000a91565b935050602084013567ffffffffffffffff81111562000b6d57600080fd5b62000b7b8682870162000a45565b92509250509250925092565b60006020828403121562000b9a57600080fd5b600062000ae4848462000a91565b60006020828403121562000bbb57600080fd5b600062000ae4848462000a9e565b6000806000806060858703121562000be057600080fd5b600062000bee878762000a32565b945050602062000c018782880162000a32565b935050604085013567ffffffffffffffff81111562000c1f57600080fd5b62000c2d8782880162000a45565b95989497509550505050565b600062000c47838362000d17565b505060200190565b62000c5a8162001056565b82525050565b600062000c6d8262001044565b62000c79818562001048565b935062000c86836200103e565b8060005b8381101562000cba57815162000ca1888262000c39565b975062000cae836200103e565b92505060010162000c8a565b509495945050505050565b62000c5a8162001063565b62000c5a62000cdf8262001063565b62001063565b600062000cf3838562001048565b935062000d0283858462001092565b62000d0d836200109e565b9093019392505050565b62000c5a8162001066565b600062000d3160098362001048565b7f4e6f742070726f78790000000000000000000000000000000000000000000000815260200192915050565b600062000d6c600e8362001048565b7f496e76616c6964207369676e6572000000000000000000000000000000000000815260200192915050565b600062000da760188362001048565b7f496e76616c6964207369676e6174757265206c656e6774680000000000000000815260200192915050565b600062000de260208362001051565b7f7c7c456e6572676920426c6f636b636861696e20436865636b706f696e747c7c815260200192915050565b600062000e1d600d8362001048565b7f4e6f7420737570706f7274656400000000000000000000000000000000000000815260200192915050565b62000c5a816200108c565b600062000e618262000dd3565b915062000e6f828562000cd0565b60208201915062000e81828462000cd0565b5060200192915050565b6020810162000a3f828462000c4f565b6020808252810162000eae818462000c60565b9392505050565b6020810162000a3f828462000cc5565b6040810162000ed5828562000cc5565b62000eae602083018462000d17565b6080810162000ef4828762000cc5565b62000f03602083018662000e49565b62000f12604083018562000cc5565b62000f21606083018462000cc5565b95945050505050565b6020808252810162000ae481848662000ce5565b6020810162000a3f828462000d17565b60a0810162000f5e828962000d17565b62000f6d602083018862000cc5565b62000f7c604083018762000cc5565b62000f8b606083018662000cc5565b818103608083015262000fa081848662000ce5565b98975050505050505050565b6020808252810162000a3f8162000d22565b6020808252810162000a3f8162000d5d565b6020808252810162000a3f8162000d98565b6020808252810162000a3f8162000e0e565b60405181810167ffffffffffffffff811182821017156200101457600080fd5b604052919050565b600067ffffffffffffffff8211156200103457600080fd5b5060209081020190565b60200190565b5190565b90815260200190565b919050565b600062000a3f8262001073565b90565b600062000a3f8262001056565b73ffffffffffffffffffffffffffffffffffffffff1690565b60ff1690565b82818337506000910152565b601f017fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe01690565b620010d18162001063565b81146200076757600080fd5b620010d1816200106656fe60806040523480156200001157600080fd5b50604051620012c8380380620012c8833981016040819052620000349162000310565b600080546001600160a01b0319166001600160a01b038716179055436001556002849055600383905560048290558051604114620000a9576040517f08c379a0000000000000000000000000000000000000000000000000000000008152600401620000a09062000445565b60405180910390fd5b60008082806020019051620000c29190810190620002d1565b91509150600060018585604081518110620000d957fe5b602001015160f81c60f81b60f81c858560405160008152602001604052604051620001089493929190620003ff565b6020604051602081039080840390855afa1580156200012b573d6000803e3d6000fd5b5050604051601f1901516006805460018101808355600092909252875192945090925062000183917ff652222313e28459528d920b65115c16c04f3efc82aaedc97be59f3f377c0d3f909101906020880190620001b0565b50506006546001600160a01b03909116600090815260056020526040902055506200053395505050505050565b828054600181600116156101000203166002900490600052602060002090601f016020900481019282601f10620001f357805160ff191683800117855562000223565b8280016001018555821562000223579182015b828111156200022357825182559160200191906001019062000206565b506200023192915062000235565b5090565b6200025291905b808211156200023157600081556001016200023c565b90565b805162000262816200050e565b92915050565b600082601f8301126200027a57600080fd5b8151620002916200028b826200047e565b62000457565b91508082526020830160208301858383011115620002ae57600080fd5b620002bb838284620004db565b50505092915050565b8051620002628162000528565b60008060408385031215620002e557600080fd5b6000620002f3858562000255565b9250506020620003068582860162000255565b9150509250929050565b600080600080600060a086880312156200032957600080fd5b6000620003378888620002c4565b95505060206200034a8882890162000255565b94505060406200035d8882890162000255565b9350506060620003708882890162000255565b92505060808601516001600160401b038111156200038d57600080fd5b6200039b8882890162000268565b9150509295509295909350565b620003b38162000252565b82525050565b6000620003c8601883620004a6565b7f496e76616c6964207369676e6174757265206c656e6774680000000000000000815260200192915050565b620003b381620004d5565b608081016200040f8287620003a8565b6200041e6020830186620003f4565b6200042d6040830185620003a8565b6200043c6060830184620003a8565b95945050505050565b602080825281016200026281620003b9565b6040518181016001600160401b03811182821017156200047657600080fd5b604052919050565b60006001600160401b038211156200049557600080fd5b506020601f91909101601f19160190565b90815260200190565b60006200026282620004c9565b60006200026282620004af565b6001600160a01b031690565b60ff1690565b60005b83811015620004f8578181015183820152602001620004de565b8381111562000508576000848401525b50505050565b620005198162000252565b81146200052557600080fd5b50565b6200051981620004bc565b610d8580620005436000396000f3fe608060405234801561001057600080fd5b50600436106100725760003560e01c806376cd7cbc1161005057806376cd7cbc146100cc578063adfaa72e146100e1578063f27959c71461010157610072565b8063124321c4146100775780632bbe2c8814610095578063370158ea146100b5575b600080fd5b61007f610116565b60405161008c9190610b96565b60405180910390f35b6100a86100a336600461088b565b61011c565b60405161008c9190610be2565b6100bd61024f565b60405161008c93929190610c43565b6100df6100da366004610909565b61025d565b005b6100f46100ef36600461088b565b6105c0565b60405161008c9190610b88565b610109610610565b60405161008c9190610b77565b60045481565b73ffffffffffffffffffffffffffffffffffffffff811660009081526005602052604090205460609080610185576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161017c90610c23565b60405180910390fd5b6006600182038154811061019557fe5b600091825260209182902001805460408051601f60027fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff6101006001871615020190941693909304928301859004850281018501909152818152928301828280156102415780601f1061021657610100808354040283529160200191610241565b820191906000526020600020905b81548152906001019060200180831161022457829003601f168201915b50505050509150505b919050565b600254600354600154909192565b6105a060015443031061029c576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161017c90610bf3565b604181146102d6576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161017c90610c33565b6000806102e5838501856108cf565b9150915060006001600454868660408181106102fd57fe5b60408051600081526020019081905261032394939091013560f81c915087908790610ba4565b6020604051602081039080840390855afa158015610345573d6000803e3d6000fd5b5050604080517fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe0015173ffffffffffffffffffffffffffffffffffffffff81166000908152600560205291909120549092501590506103d0576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161017c90610c03565b60008060009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16638abf60776040518163ffffffff1660e01b815260040160206040518083038186803b15801561043957600080fd5b505afa15801561044d573d6000803e3d6000fd5b505050506040513d601f19601f82011682018060405250610471919081019061094b565b6040517f9f8a13d700000000000000000000000000000000000000000000000000000000815290915073ffffffffffffffffffffffffffffffffffffffff821690639f8a13d7906104c6908590600401610b69565b60206040518083038186803b1580156104de57600080fd5b505afa1580156104f2573d6000803e3d6000fd5b505050506040513d601f19601f8201168201806040525061051691908101906108b1565b61054c576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040161017c90610c13565b600680546001810180835560009290925261058a907ff652222313e28459528d920b65115c16c04f3efc82aaedc97be59f3f377c0d3f018888610757565b505060065473ffffffffffffffffffffffffffffffffffffffff9092166000908152600560205260409020919091555050505050565b73ffffffffffffffffffffffffffffffffffffffff8116600090815260056020526040812054156105f35750600061024a565b6105a06001544303106106085750600061024a565b506001919050565b6006546040805182815260208084028201019091526060919081801561064a57816020015b60608152602001906001900390816106355790505b509150805b7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff81019015610752576006818154811061068557fe5b600091825260209182902001805460408051601f60027fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff6101006001871615020190941693909304928301859004850281018501909152818152928301828280156107315780601f1061070657610100808354040283529160200191610731565b820191906000526020600020905b81548152906001019060200180831161071457829003601f168201915b505050505083828151811061074257fe5b602002602001018190525061064f565b505090565b828054600181600116156101000203166002900490600052602060002090601f016020900481019282601f106107b6578280017fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff008235161785556107e3565b828001600101855582156107e3579182015b828111156107e35782358255916020019190600101906107c8565b506107ef9291506107f3565b5090565b61080d91905b808211156107ef57600081556001016107f9565b90565b803561081b81610d10565b92915050565b805161081b81610d27565b803561081b81610d30565b60008083601f84011261084957600080fd5b50813567ffffffffffffffff81111561086157600080fd5b60208301915083600182028301111561087957600080fd5b9250929050565b805161081b81610d39565b60006020828403121561089d57600080fd5b60006108a98484610810565b949350505050565b6000602082840312156108c357600080fd5b60006108a98484610821565b600080604083850312156108e257600080fd5b60006108ee858561082c565b92505060206108ff8582860161082c565b9150509250929050565b6000806020838503121561091c57600080fd5b823567ffffffffffffffff81111561093357600080fd5b61093f85828601610837565b92509250509250929050565b60006020828403121561095d57600080fd5b60006108a98484610880565b60006109758383610a0b565b9392505050565b61098581610c7e565b82525050565b600061099682610c71565b6109a08185610c75565b9350836020820285016109b285610c6b565b8060005b858110156109ec57848403895281516109cf8582610969565b94506109da83610c6b565b60209a909a01999250506001016109b6565b5091979650505050505050565b61098581610c89565b6109858161080d565b6000610a1682610c71565b610a208185610c75565b9350610a30818560208601610cb8565b610a3981610ce8565b9093019392505050565b6000610a50601183610c75565b7f5369676e696e672068617320656e646564000000000000000000000000000000815260200192915050565b6000610a89600e83610c75565b7f416c7265616479207369676e6564000000000000000000000000000000000000815260200192915050565b6000610ac2600d83610c75565b7f4e6f7420616374697665204d4e00000000000000000000000000000000000000815260200192915050565b6000610afb600e83610c75565b7f4e6f74207369676e656420796574000000000000000000000000000000000000815260200192915050565b6000610b34601883610c75565b7f496e76616c6964207369676e6174757265206c656e6774680000000000000000815260200192915050565b61098581610cb2565b6020810161081b828461097c565b60208082528101610975818461098b565b6020810161081b82846109f9565b6020810161081b8284610a02565b60808101610bb28287610a02565b610bbf6020830186610b60565b610bcc6040830185610a02565b610bd96060830184610a02565b95945050505050565b602080825281016109758184610a0b565b6020808252810161081b81610a43565b6020808252810161081b81610a7c565b6020808252810161081b81610ab5565b6020808252810161081b81610aee565b6020808252810161081b81610b27565b60608101610c518286610a02565b610c5e6020830185610a02565b6108a96040830184610a02565b60200190565b5190565b90815260200190565b600061081b82610c99565b151590565b600061081b82610c7e565b73ffffffffffffffffffffffffffffffffffffffff1690565b60ff1690565b60005b83811015610cd3578181015183820152602001610cbb565b83811115610ce2576000848401525b50505050565b601f017fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe01690565b610d1981610c7e565b8114610d2457600080fd5b50565b610d1981610c89565b610d198161080d565b610d1981610c8e56fea365627a7a72315820059207961dfc83712ec1e11a0313b805932ebf320d9d4a1492f74b24fe8e796b6c6578706572696d656e74616cf564736f6c63430005100040a365627a7a723158205f32e2b847f04bab6d4f87f16d72647ffe01c5eeda523bb2dc19b0c8fbea503d6c6578706572696d656e74616cf564736f6c63430005100040`

// CheckpointRegistryV2 is an auto generated Go binding around an Ethereum contract.
type CheckpointRegistryV2 struct {
	CheckpointRegistryV2Caller     // Read-only binding to the contract
	CheckpointRegistryV2Transactor // Write-only binding to the contract
	CheckpointRegistryV2Filterer   // Log filterer for contract events
}

// CheckpointRegistryV2Caller is an auto generated read-only Go binding around an Ethereum contract.
type CheckpointRegistryV2Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// CheckpointRegistryV2Transactor is an auto generated write-only Go binding around an Ethereum contract.
type CheckpointRegistryV2Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// CheckpointRegistryV2Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type CheckpointRegistryV2Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// CheckpointRegistryV2Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type CheckpointRegistryV2Session struct {
	Contract     *CheckpointRegistryV2 // Generic contract binding to set the session for
	CallOpts     bind.CallOpts         // Call options to use throughout this session
	TransactOpts bind.TransactOpts     // Transaction auth options to use throughout this session
}

// CheckpointRegistryV2CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type CheckpointRegistryV2CallerSession struct {
	Contract *CheckpointRegistryV2Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts               // Call options to use throughout this session
}

// CheckpointRegistryV2TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type CheckpointRegistryV2TransactorSession struct {
	Contract     *CheckpointRegistryV2Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts               // Transaction auth options to use throughout this session
}

// CheckpointRegistryV2Raw is an auto generated low-level Go binding around an Ethereum contract.
type CheckpointRegistryV2Raw struct {
	Contract *CheckpointRegistryV2 // Generic contract binding to access the raw methods on
}

// CheckpointRegistryV2CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type CheckpointRegistryV2CallerRaw struct {
	Contract *CheckpointRegistryV2Caller // Generic read-only contract binding to access the raw methods on
}

// CheckpointRegistryV2TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type CheckpointRegistryV2TransactorRaw struct {
	Contract *CheckpointRegistryV2Transactor // Generic write-only contract binding to access the raw methods on
}

// NewCheckpointRegistryV2 creates a new instance of CheckpointRegistryV2, bound to a specific deployed contract.
func NewCheckpointRegistryV2(address common.Address, backend bind.ContractBackend) (*CheckpointRegistryV2, error) {
	contract, err := bindCheckpointRegistryV2(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV2{CheckpointRegistryV2Caller: CheckpointRegistryV2Caller{contract: contract}, CheckpointRegistryV2Transactor: CheckpointRegistryV2Transactor{contract: contract}, CheckpointRegistryV2Filterer: CheckpointRegistryV2Filterer{contract: contract}}, nil
}

// NewCheckpointRegistryV2Caller creates a new read-only instance of CheckpointRegistryV2, bound to a specific deployed contract.
func NewCheckpointRegistryV2Caller(address common.Address, caller bind.ContractCaller) (*CheckpointRegistryV2Caller, error) {
	contract, err := bindCheckpointRegistryV2(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV2Caller{contract: contract}, nil
}

// NewCheckpointRegistryV2Transactor creates a new write-only instance of CheckpointRegistryV2, bound to a specific deployed contract.
func NewCheckpointRegistryV2Transactor(address common.Address, transactor bind.ContractTransactor) (*CheckpointRegistryV2Transactor, error) {
	contract, err := bindCheckpointRegistryV2(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV2Transactor{contract: contract}, nil
}

// NewCheckpointRegistryV2Filterer creates a new log filterer instance of CheckpointRegistryV2, bound to a specific deployed contract.
func NewCheckpointRegistryV2Filterer(address common.Address, filterer bind.ContractFilterer) (*CheckpointRegistryV2Filterer, error) {
	contract, err := bindCheckpointRegistryV2(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV2Filterer{contract: contract}, nil
}

// bindCheckpointRegistryV2 binds a generic wrapper to an already deployed contract.
func bindCheckpointRegistryV2(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(CheckpointRegistryV2ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_CheckpointRegistryV2 *CheckpointRegistryV2Raw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _CheckpointRegistryV2.Contract.CheckpointRegistryV2Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_CheckpointRegistryV2 *CheckpointRegistryV2Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.CheckpointRegistryV2Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_CheckpointRegistryV2 *CheckpointRegistryV2Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.CheckpointRegistryV2Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerRaw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _CheckpointRegistryV2.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_CheckpointRegistryV2 *CheckpointRegistryV2TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_CheckpointRegistryV2 *CheckpointRegistryV2TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.contract.Transact(opts, method, params...)
}

// CPPSigner is a free data retrieval call binding the contract method 0xd59f1758.
//
// Solidity: function CPP_signer() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Caller) CPPSigner(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV2.contract.Call(opts, out, "CPP_signer")
	return *ret0, err
}

// CPPSigner is a free data retrieval call binding the contract method 0xd59f1758.
//
// Solidity: function CPP_signer() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) CPPSigner() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.CPPSigner(&_CheckpointRegistryV2.CallOpts)
}

// CPPSigner is a free data retrieval call binding the contract method 0xd59f1758.
//
// Solidity: function CPP_signer() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerSession) CPPSigner() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.CPPSigner(&_CheckpointRegistryV2.CallOpts)
}

// Checkpoints is a free data retrieval call binding the contract method 0x5a48c0b0.
//
// Solidity: function checkpoints() constant returns(address[])
func (_CheckpointRegistryV2 *CheckpointRegistryV2Caller) Checkpoints(opts *bind.CallOpts) ([]common.Address, error) {
	var (
		ret0 = new([]common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV2.contract.Call(opts, out, "checkpoints")
	return *ret0, err
}

// Checkpoints is a free data retrieval call binding the contract method 0x5a48c0b0.
//
// Solidity: function checkpoints() constant returns(address[])
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) Checkpoints() ([]common.Address, error) {
	return _CheckpointRegistryV2.Contract.Checkpoints(&_CheckpointRegistryV2.CallOpts)
}

// Checkpoints is a free data retrieval call binding the contract method 0x5a48c0b0.
//
// Solidity: function checkpoints() constant returns(address[])
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerSession) Checkpoints() ([]common.Address, error) {
	return _CheckpointRegistryV2.Contract.Checkpoints(&_CheckpointRegistryV2.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Caller) MnregistryProxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV2.contract.Call(opts, out, "mnregistry_proxy")
	return *ret0, err
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) MnregistryProxy() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.MnregistryProxy(&_CheckpointRegistryV2.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerSession) MnregistryProxy() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.MnregistryProxy(&_CheckpointRegistryV2.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Caller) Proxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV2.contract.Call(opts, out, "proxy")
	return *ret0, err
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) Proxy() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.Proxy(&_CheckpointRegistryV2.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerSession) Proxy() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.Proxy(&_CheckpointRegistryV2.CallOpts)
}

// SignatureBase is a free data retrieval call binding the contract method 0x851f2209.
//
// Solidity: function signatureBase(uint256 number, bytes32 hash) constant returns(bytes32 sigbase)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Caller) SignatureBase(opts *bind.CallOpts, number *big.Int, hash [32]byte) ([32]byte, error) {
	var (
		ret0 = new([32]byte)
	)
	out := ret0
	err := _CheckpointRegistryV2.contract.Call(opts, out, "signatureBase", number, hash)
	return *ret0, err
}

// SignatureBase is a free data retrieval call binding the contract method 0x851f2209.
//
// Solidity: function signatureBase(uint256 number, bytes32 hash) constant returns(bytes32 sigbase)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) SignatureBase(number *big.Int, hash [32]byte) ([32]byte, error) {
	return _CheckpointRegistryV2.Contract.SignatureBase(&_CheckpointRegistryV2.CallOpts, number, hash)
}

// SignatureBase is a free data retrieval call binding the contract method 0x851f2209.
//
// Solidity: function signatureBase(uint256 number, bytes32 hash) constant returns(bytes32 sigbase)
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerSession) SignatureBase(number *big.Int, hash [32]byte) ([32]byte, error) {
	return _CheckpointRegistryV2.Contract.SignatureBase(&_CheckpointRegistryV2.CallOpts, number, hash)
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Caller) V1storage(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV2.contract.Call(opts, out, "v1storage")
	return *ret0, err
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) V1storage() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.V1storage(&_CheckpointRegistryV2.CallOpts)
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_CheckpointRegistryV2 *CheckpointRegistryV2CallerSession) V1storage() (common.Address, error) {
	return _CheckpointRegistryV2.Contract.V1storage(&_CheckpointRegistryV2.CallOpts)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2Transactor) Destroy(opts *bind.TransactOpts, _newImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV2.contract.Transact(opts, "destroy", _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Destroy(&_CheckpointRegistryV2.TransactOpts, _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2TransactorSession) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Destroy(&_CheckpointRegistryV2.TransactOpts, _newImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2Transactor) Migrate(opts *bind.TransactOpts, _oldImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV2.contract.Transact(opts, "migrate", _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Migrate(&_CheckpointRegistryV2.TransactOpts, _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2TransactorSession) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Migrate(&_CheckpointRegistryV2.TransactOpts, _oldImpl)
}

// Propose is a paid mutator transaction binding the contract method 0xc20fa2ee.
//
// Solidity: function propose(uint256 number, bytes32 hash, bytes signature) returns(address checkpoint)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Transactor) Propose(opts *bind.TransactOpts, number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV2.contract.Transact(opts, "propose", number, hash, signature)
}

// Propose is a paid mutator transaction binding the contract method 0xc20fa2ee.
//
// Solidity: function propose(uint256 number, bytes32 hash, bytes signature) returns(address checkpoint)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) Propose(number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Propose(&_CheckpointRegistryV2.TransactOpts, number, hash, signature)
}

// Propose is a paid mutator transaction binding the contract method 0xc20fa2ee.
//
// Solidity: function propose(uint256 number, bytes32 hash, bytes signature) returns(address checkpoint)
func (_CheckpointRegistryV2 *CheckpointRegistryV2TransactorSession) Propose(number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Propose(&_CheckpointRegistryV2.TransactOpts, number, hash, signature)
}

// Sign is a paid mutator transaction binding the contract method 0x51fae959.
//
// Solidity: function sign(address checkpoint, bytes signature) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2Transactor) Sign(opts *bind.TransactOpts, checkpoint common.Address, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV2.contract.Transact(opts, "sign", checkpoint, signature)
}

// Sign is a paid mutator transaction binding the contract method 0x51fae959.
//
// Solidity: function sign(address checkpoint, bytes signature) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2Session) Sign(checkpoint common.Address, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Sign(&_CheckpointRegistryV2.TransactOpts, checkpoint, signature)
}

// Sign is a paid mutator transaction binding the contract method 0x51fae959.
//
// Solidity: function sign(address checkpoint, bytes signature) returns()
func (_CheckpointRegistryV2 *CheckpointRegistryV2TransactorSession) Sign(checkpoint common.Address, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV2.Contract.Sign(&_CheckpointRegistryV2.TransactOpts, checkpoint, signature)
}

// CheckpointRegistryV2CheckpointIterator is returned from FilterCheckpoint and is used to iterate over the raw logs and unpacked data for Checkpoint events raised by the CheckpointRegistryV2 contract.
type CheckpointRegistryV2CheckpointIterator struct {
	Event *CheckpointRegistryV2Checkpoint // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *CheckpointRegistryV2CheckpointIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(CheckpointRegistryV2Checkpoint)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(CheckpointRegistryV2Checkpoint)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *CheckpointRegistryV2CheckpointIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *CheckpointRegistryV2CheckpointIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// CheckpointRegistryV2Checkpoint represents a Checkpoint event raised by the CheckpointRegistryV2 contract.
type CheckpointRegistryV2Checkpoint struct {
	Number     *big.Int
	Hash       [32]byte
	Checkpoint common.Address
	Raw        types.Log // Blockchain specific contextual infos
}

// FilterCheckpoint is a free log retrieval operation binding the contract event 0x7f582e7a234c68b135245365b0c69d608f9235392a1ef801b46f04ca5d6cdad4.
//
// Solidity: event Checkpoint(uint256 indexed number, bytes32 hash, address checkpoint)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Filterer) FilterCheckpoint(opts *bind.FilterOpts, number []*big.Int) (*CheckpointRegistryV2CheckpointIterator, error) {

	var numberRule []interface{}
	for _, numberItem := range number {
		numberRule = append(numberRule, numberItem)
	}

	logs, sub, err := _CheckpointRegistryV2.contract.FilterLogs(opts, "Checkpoint", numberRule)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV2CheckpointIterator{contract: _CheckpointRegistryV2.contract, event: "Checkpoint", logs: logs, sub: sub}, nil
}

// WatchCheckpoint is a free log subscription operation binding the contract event 0x7f582e7a234c68b135245365b0c69d608f9235392a1ef801b46f04ca5d6cdad4.
//
// Solidity: event Checkpoint(uint256 indexed number, bytes32 hash, address checkpoint)
func (_CheckpointRegistryV2 *CheckpointRegistryV2Filterer) WatchCheckpoint(opts *bind.WatchOpts, sink chan<- *CheckpointRegistryV2Checkpoint, number []*big.Int) (event.Subscription, error) {

	var numberRule []interface{}
	for _, numberItem := range number {
		numberRule = append(numberRule, numberItem)
	}

	logs, sub, err := _CheckpointRegistryV2.contract.WatchLogs(opts, "Checkpoint", numberRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(CheckpointRegistryV2Checkpoint)
				if err := _CheckpointRegistryV2.contract.UnpackLog(event, "Checkpoint", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}
