// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package abi

import (
	"math/big"
	"strings"

	ethereum "energi.world/core/gen3"
	"energi.world/core/gen3/accounts/abi"
	"energi.world/core/gen3/accounts/abi/bind"
	"energi.world/core/gen3/common"
	"energi.world/core/gen3/core/types"
	"energi.world/core/gen3/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = abi.U256
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// HardforkRegistryV1ABI is the input ABI used to generate the binding from.
const HardforkRegistryV1ABI = "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_proxy\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_hf_signer\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_finalization_confirmations\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"block_number\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"sw_features\",\"type\":\"uint256\"}],\"name\":\"HardforkCreated\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"block_number\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"bytes32\",\"name\":\"block_hash\",\"type\":\"bytes32\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"sw_features\",\"type\":\"uint256\"}],\"name\":\"HardforkFinalized\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"},{\"indexed\":false,\"internalType\":\"bytes32\",\"name\":\"unindexed_name\",\"type\":\"bytes32\"}],\"name\":\"HardforkRemoved\",\"type\":\"event\"},{\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"fallback\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"},{\"internalType\":\"uint256\",\"name\":\"block_number\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"sw_features\",\"type\":\"uint256\"}],\"name\":\"add\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_newImpl\",\"type\":\"address\"}],\"name\":\"destroy\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"enumerate\",\"outputs\":[{\"internalType\":\"bytes32[]\",\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"enumerateActive\",\"outputs\":[{\"internalType\":\"bytes32[]\",\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"enumeratePending\",\"outputs\":[{\"internalType\":\"bytes32[]\",\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"}],\"name\":\"finalize\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"}],\"name\":\"get\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"block_number\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"block_hash\",\"type\":\"bytes32\"},{\"internalType\":\"uint256\",\"name\":\"sw_features\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"hf_signer\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"}],\"name\":\"isActive\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_oldImpl\",\"type\":\"address\"}],\"name\":\"migrate\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"proxy\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"bytes32\",\"name\":\"name\",\"type\":\"bytes32\"}],\"name\":\"remove\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"v1storage\",\"outputs\":[{\"internalType\":\"contractStorageHardforkRegistryV1\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"

// HardforkRegistryV1Bin is the compiled bytecode used for deploying new contracts.
const HardforkRegistryV1Bin = `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`

// DeployHardforkRegistryV1 deploys a new Ethereum contract, binding an instance of HardforkRegistryV1 to it.
func DeployHardforkRegistryV1(auth *bind.TransactOpts, backend bind.ContractBackend, _proxy common.Address, _hf_signer common.Address, _finalization_confirmations *big.Int) (common.Address, *types.Transaction, *HardforkRegistryV1, error) {
	parsed, err := abi.JSON(strings.NewReader(HardforkRegistryV1ABI))
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	address, tx, contract, err := bind.DeployContract(auth, parsed, common.FromHex(HardforkRegistryV1Bin), backend, _proxy, _hf_signer, _finalization_confirmations)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &HardforkRegistryV1{HardforkRegistryV1Caller: HardforkRegistryV1Caller{contract: contract}, HardforkRegistryV1Transactor: HardforkRegistryV1Transactor{contract: contract}, HardforkRegistryV1Filterer: HardforkRegistryV1Filterer{contract: contract}}, nil
}

// HardforkRegistryV1Bin is the compiled bytecode of contract after deployment.
const HardforkRegistryV1RuntimeBin = `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`

// HardforkRegistryV1 is an auto generated Go binding around an Ethereum contract.
type HardforkRegistryV1 struct {
	HardforkRegistryV1Caller     // Read-only binding to the contract
	HardforkRegistryV1Transactor // Write-only binding to the contract
	HardforkRegistryV1Filterer   // Log filterer for contract events
}

// HardforkRegistryV1Caller is an auto generated read-only Go binding around an Ethereum contract.
type HardforkRegistryV1Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// HardforkRegistryV1Transactor is an auto generated write-only Go binding around an Ethereum contract.
type HardforkRegistryV1Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// HardforkRegistryV1Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type HardforkRegistryV1Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// HardforkRegistryV1Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type HardforkRegistryV1Session struct {
	Contract     *HardforkRegistryV1 // Generic contract binding to set the session for
	CallOpts     bind.CallOpts       // Call options to use throughout this session
	TransactOpts bind.TransactOpts   // Transaction auth options to use throughout this session
}

// HardforkRegistryV1CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type HardforkRegistryV1CallerSession struct {
	Contract *HardforkRegistryV1Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts             // Call options to use throughout this session
}

// HardforkRegistryV1TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type HardforkRegistryV1TransactorSession struct {
	Contract     *HardforkRegistryV1Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts             // Transaction auth options to use throughout this session
}

// HardforkRegistryV1Raw is an auto generated low-level Go binding around an Ethereum contract.
type HardforkRegistryV1Raw struct {
	Contract *HardforkRegistryV1 // Generic contract binding to access the raw methods on
}

// HardforkRegistryV1CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type HardforkRegistryV1CallerRaw struct {
	Contract *HardforkRegistryV1Caller // Generic read-only contract binding to access the raw methods on
}

// HardforkRegistryV1TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type HardforkRegistryV1TransactorRaw struct {
	Contract *HardforkRegistryV1Transactor // Generic write-only contract binding to access the raw methods on
}

// NewHardforkRegistryV1 creates a new instance of HardforkRegistryV1, bound to a specific deployed contract.
func NewHardforkRegistryV1(address common.Address, backend bind.ContractBackend) (*HardforkRegistryV1, error) {
	contract, err := bindHardforkRegistryV1(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1{HardforkRegistryV1Caller: HardforkRegistryV1Caller{contract: contract}, HardforkRegistryV1Transactor: HardforkRegistryV1Transactor{contract: contract}, HardforkRegistryV1Filterer: HardforkRegistryV1Filterer{contract: contract}}, nil
}

// NewHardforkRegistryV1Caller creates a new read-only instance of HardforkRegistryV1, bound to a specific deployed contract.
func NewHardforkRegistryV1Caller(address common.Address, caller bind.ContractCaller) (*HardforkRegistryV1Caller, error) {
	contract, err := bindHardforkRegistryV1(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1Caller{contract: contract}, nil
}

// NewHardforkRegistryV1Transactor creates a new write-only instance of HardforkRegistryV1, bound to a specific deployed contract.
func NewHardforkRegistryV1Transactor(address common.Address, transactor bind.ContractTransactor) (*HardforkRegistryV1Transactor, error) {
	contract, err := bindHardforkRegistryV1(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1Transactor{contract: contract}, nil
}

// NewHardforkRegistryV1Filterer creates a new log filterer instance of HardforkRegistryV1, bound to a specific deployed contract.
func NewHardforkRegistryV1Filterer(address common.Address, filterer bind.ContractFilterer) (*HardforkRegistryV1Filterer, error) {
	contract, err := bindHardforkRegistryV1(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1Filterer{contract: contract}, nil
}

// bindHardforkRegistryV1 binds a generic wrapper to an already deployed contract.
func bindHardforkRegistryV1(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(HardforkRegistryV1ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_HardforkRegistryV1 *HardforkRegistryV1Raw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _HardforkRegistryV1.Contract.HardforkRegistryV1Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_HardforkRegistryV1 *HardforkRegistryV1Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.HardforkRegistryV1Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_HardforkRegistryV1 *HardforkRegistryV1Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.HardforkRegistryV1Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_HardforkRegistryV1 *HardforkRegistryV1CallerRaw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _HardforkRegistryV1.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.contract.Transact(opts, method, params...)
}

// Enumerate is a free data retrieval call binding the contract method 0xff9f78b3.
//
// Solidity: function enumerate() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) Enumerate(opts *bind.CallOpts) ([][32]byte, error) {
	var (
		ret0 = new([][32]byte)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "enumerate")
	return *ret0, err
}

// Enumerate is a free data retrieval call binding the contract method 0xff9f78b3.
//
// Solidity: function enumerate() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Enumerate() ([][32]byte, error) {
	return _HardforkRegistryV1.Contract.Enumerate(&_HardforkRegistryV1.CallOpts)
}

// Enumerate is a free data retrieval call binding the contract method 0xff9f78b3.
//
// Solidity: function enumerate() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) Enumerate() ([][32]byte, error) {
	return _HardforkRegistryV1.Contract.Enumerate(&_HardforkRegistryV1.CallOpts)
}

// EnumerateActive is a free data retrieval call binding the contract method 0xe1d6f43a.
//
// Solidity: function enumerateActive() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) EnumerateActive(opts *bind.CallOpts) ([][32]byte, error) {
	var (
		ret0 = new([][32]byte)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "enumerateActive")
	return *ret0, err
}

// EnumerateActive is a free data retrieval call binding the contract method 0xe1d6f43a.
//
// Solidity: function enumerateActive() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1Session) EnumerateActive() ([][32]byte, error) {
	return _HardforkRegistryV1.Contract.EnumerateActive(&_HardforkRegistryV1.CallOpts)
}

// EnumerateActive is a free data retrieval call binding the contract method 0xe1d6f43a.
//
// Solidity: function enumerateActive() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) EnumerateActive() ([][32]byte, error) {
	return _HardforkRegistryV1.Contract.EnumerateActive(&_HardforkRegistryV1.CallOpts)
}

// EnumeratePending is a free data retrieval call binding the contract method 0xca89ad5f.
//
// Solidity: function enumeratePending() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) EnumeratePending(opts *bind.CallOpts) ([][32]byte, error) {
	var (
		ret0 = new([][32]byte)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "enumeratePending")
	return *ret0, err
}

// EnumeratePending is a free data retrieval call binding the contract method 0xca89ad5f.
//
// Solidity: function enumeratePending() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1Session) EnumeratePending() ([][32]byte, error) {
	return _HardforkRegistryV1.Contract.EnumeratePending(&_HardforkRegistryV1.CallOpts)
}

// EnumeratePending is a free data retrieval call binding the contract method 0xca89ad5f.
//
// Solidity: function enumeratePending() constant returns(bytes32[])
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) EnumeratePending() ([][32]byte, error) {
	return _HardforkRegistryV1.Contract.EnumeratePending(&_HardforkRegistryV1.CallOpts)
}

// Get is a free data retrieval call binding the contract method 0x8eaa6ac0.
//
// Solidity: function get(bytes32 name) constant returns(uint256 block_number, bytes32 block_hash, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) Get(opts *bind.CallOpts, name [32]byte) (struct {
	BlockNumber *big.Int
	BlockHash   [32]byte
	SwFeatures  *big.Int
}, error) {
	ret := new(struct {
		BlockNumber *big.Int
		BlockHash   [32]byte
		SwFeatures  *big.Int
	})
	out := ret
	err := _HardforkRegistryV1.contract.Call(opts, out, "get", name)
	return *ret, err
}

// Get is a free data retrieval call binding the contract method 0x8eaa6ac0.
//
// Solidity: function get(bytes32 name) constant returns(uint256 block_number, bytes32 block_hash, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Get(name [32]byte) (struct {
	BlockNumber *big.Int
	BlockHash   [32]byte
	SwFeatures  *big.Int
}, error) {
	return _HardforkRegistryV1.Contract.Get(&_HardforkRegistryV1.CallOpts, name)
}

// Get is a free data retrieval call binding the contract method 0x8eaa6ac0.
//
// Solidity: function get(bytes32 name) constant returns(uint256 block_number, bytes32 block_hash, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) Get(name [32]byte) (struct {
	BlockNumber *big.Int
	BlockHash   [32]byte
	SwFeatures  *big.Int
}, error) {
	return _HardforkRegistryV1.Contract.Get(&_HardforkRegistryV1.CallOpts, name)
}

// HfSigner is a free data retrieval call binding the contract method 0xa216cbe5.
//
// Solidity: function hf_signer() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) HfSigner(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "hf_signer")
	return *ret0, err
}

// HfSigner is a free data retrieval call binding the contract method 0xa216cbe5.
//
// Solidity: function hf_signer() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1Session) HfSigner() (common.Address, error) {
	return _HardforkRegistryV1.Contract.HfSigner(&_HardforkRegistryV1.CallOpts)
}

// HfSigner is a free data retrieval call binding the contract method 0xa216cbe5.
//
// Solidity: function hf_signer() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) HfSigner() (common.Address, error) {
	return _HardforkRegistryV1.Contract.HfSigner(&_HardforkRegistryV1.CallOpts)
}

// IsActive is a free data retrieval call binding the contract method 0x5c36901c.
//
// Solidity: function isActive(bytes32 name) constant returns(bool)
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) IsActive(opts *bind.CallOpts, name [32]byte) (bool, error) {
	var (
		ret0 = new(bool)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "isActive", name)
	return *ret0, err
}

// IsActive is a free data retrieval call binding the contract method 0x5c36901c.
//
// Solidity: function isActive(bytes32 name) constant returns(bool)
func (_HardforkRegistryV1 *HardforkRegistryV1Session) IsActive(name [32]byte) (bool, error) {
	return _HardforkRegistryV1.Contract.IsActive(&_HardforkRegistryV1.CallOpts, name)
}

// IsActive is a free data retrieval call binding the contract method 0x5c36901c.
//
// Solidity: function isActive(bytes32 name) constant returns(bool)
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) IsActive(name [32]byte) (bool, error) {
	return _HardforkRegistryV1.Contract.IsActive(&_HardforkRegistryV1.CallOpts, name)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) Proxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "proxy")
	return *ret0, err
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Proxy() (common.Address, error) {
	return _HardforkRegistryV1.Contract.Proxy(&_HardforkRegistryV1.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) Proxy() (common.Address, error) {
	return _HardforkRegistryV1.Contract.Proxy(&_HardforkRegistryV1.CallOpts)
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1Caller) V1storage(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _HardforkRegistryV1.contract.Call(opts, out, "v1storage")
	return *ret0, err
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1Session) V1storage() (common.Address, error) {
	return _HardforkRegistryV1.Contract.V1storage(&_HardforkRegistryV1.CallOpts)
}

// V1storage is a free data retrieval call binding the contract method 0x2d059305.
//
// Solidity: function v1storage() constant returns(address)
func (_HardforkRegistryV1 *HardforkRegistryV1CallerSession) V1storage() (common.Address, error) {
	return _HardforkRegistryV1.Contract.V1storage(&_HardforkRegistryV1.CallOpts)
}

// Add is a paid mutator transaction binding the contract method 0xaa61604f.
//
// Solidity: function add(bytes32 name, uint256 block_number, uint256 sw_features) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Transactor) Add(opts *bind.TransactOpts, name [32]byte, block_number *big.Int, sw_features *big.Int) (*types.Transaction, error) {
	return _HardforkRegistryV1.contract.Transact(opts, "add", name, block_number, sw_features)
}

// Add is a paid mutator transaction binding the contract method 0xaa61604f.
//
// Solidity: function add(bytes32 name, uint256 block_number, uint256 sw_features) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Add(name [32]byte, block_number *big.Int, sw_features *big.Int) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Add(&_HardforkRegistryV1.TransactOpts, name, block_number, sw_features)
}

// Add is a paid mutator transaction binding the contract method 0xaa61604f.
//
// Solidity: function add(bytes32 name, uint256 block_number, uint256 sw_features) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorSession) Add(name [32]byte, block_number *big.Int, sw_features *big.Int) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Add(&_HardforkRegistryV1.TransactOpts, name, block_number, sw_features)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Transactor) Destroy(opts *bind.TransactOpts, _newImpl common.Address) (*types.Transaction, error) {
	return _HardforkRegistryV1.contract.Transact(opts, "destroy", _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Destroy(&_HardforkRegistryV1.TransactOpts, _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorSession) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Destroy(&_HardforkRegistryV1.TransactOpts, _newImpl)
}

// Finalize is a paid mutator transaction binding the contract method 0x92584d80.
//
// Solidity: function finalize(bytes32 name) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Transactor) Finalize(opts *bind.TransactOpts, name [32]byte) (*types.Transaction, error) {
	return _HardforkRegistryV1.contract.Transact(opts, "finalize", name)
}

// Finalize is a paid mutator transaction binding the contract method 0x92584d80.
//
// Solidity: function finalize(bytes32 name) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Finalize(name [32]byte) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Finalize(&_HardforkRegistryV1.TransactOpts, name)
}

// Finalize is a paid mutator transaction binding the contract method 0x92584d80.
//
// Solidity: function finalize(bytes32 name) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorSession) Finalize(name [32]byte) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Finalize(&_HardforkRegistryV1.TransactOpts, name)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Transactor) Migrate(opts *bind.TransactOpts, _oldImpl common.Address) (*types.Transaction, error) {
	return _HardforkRegistryV1.contract.Transact(opts, "migrate", _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Migrate(&_HardforkRegistryV1.TransactOpts, _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorSession) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Migrate(&_HardforkRegistryV1.TransactOpts, _oldImpl)
}

// Remove is a paid mutator transaction binding the contract method 0x95bc2673.
//
// Solidity: function remove(bytes32 name) returns(bool)
func (_HardforkRegistryV1 *HardforkRegistryV1Transactor) Remove(opts *bind.TransactOpts, name [32]byte) (*types.Transaction, error) {
	return _HardforkRegistryV1.contract.Transact(opts, "remove", name)
}

// Remove is a paid mutator transaction binding the contract method 0x95bc2673.
//
// Solidity: function remove(bytes32 name) returns(bool)
func (_HardforkRegistryV1 *HardforkRegistryV1Session) Remove(name [32]byte) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Remove(&_HardforkRegistryV1.TransactOpts, name)
}

// Remove is a paid mutator transaction binding the contract method 0x95bc2673.
//
// Solidity: function remove(bytes32 name) returns(bool)
func (_HardforkRegistryV1 *HardforkRegistryV1TransactorSession) Remove(name [32]byte) (*types.Transaction, error) {
	return _HardforkRegistryV1.Contract.Remove(&_HardforkRegistryV1.TransactOpts, name)
}

// HardforkRegistryV1HardforkCreatedIterator is returned from FilterHardforkCreated and is used to iterate over the raw logs and unpacked data for HardforkCreated events raised by the HardforkRegistryV1 contract.
type HardforkRegistryV1HardforkCreatedIterator struct {
	Event *HardforkRegistryV1HardforkCreated // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *HardforkRegistryV1HardforkCreatedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(HardforkRegistryV1HardforkCreated)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(HardforkRegistryV1HardforkCreated)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *HardforkRegistryV1HardforkCreatedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *HardforkRegistryV1HardforkCreatedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// HardforkRegistryV1HardforkCreated represents a HardforkCreated event raised by the HardforkRegistryV1 contract.
type HardforkRegistryV1HardforkCreated struct {
	Name        [32]byte
	BlockNumber *big.Int
	SwFeatures  *big.Int
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterHardforkCreated is a free log retrieval operation binding the contract event 0x33bbb09eb0e71b49dacc2c0e0f73dd640a1314f0d08d5f8efa5c12eac770c4c3.
//
// Solidity: event HardforkCreated(bytes32 indexed name, uint256 block_number, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1Filterer) FilterHardforkCreated(opts *bind.FilterOpts, name [][32]byte) (*HardforkRegistryV1HardforkCreatedIterator, error) {

	var nameRule []interface{}
	for _, nameItem := range name {
		nameRule = append(nameRule, nameItem)
	}

	logs, sub, err := _HardforkRegistryV1.contract.FilterLogs(opts, "HardforkCreated", nameRule)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1HardforkCreatedIterator{contract: _HardforkRegistryV1.contract, event: "HardforkCreated", logs: logs, sub: sub}, nil
}

// WatchHardforkCreated is a free log subscription operation binding the contract event 0x33bbb09eb0e71b49dacc2c0e0f73dd640a1314f0d08d5f8efa5c12eac770c4c3.
//
// Solidity: event HardforkCreated(bytes32 indexed name, uint256 block_number, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1Filterer) WatchHardforkCreated(opts *bind.WatchOpts, sink chan<- *HardforkRegistryV1HardforkCreated, name [][32]byte) (event.Subscription, error) {

	var nameRule []interface{}
	for _, nameItem := range name {
		nameRule = append(nameRule, nameItem)
	}

	logs, sub, err := _HardforkRegistryV1.contract.WatchLogs(opts, "HardforkCreated", nameRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(HardforkRegistryV1HardforkCreated)
				if err := _HardforkRegistryV1.contract.UnpackLog(event, "HardforkCreated", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// HardforkRegistryV1HardforkFinalizedIterator is returned from FilterHardforkFinalized and is used to iterate over the raw logs and unpacked data for HardforkFinalized events raised by the HardforkRegistryV1 contract.
type HardforkRegistryV1HardforkFinalizedIterator struct {
	Event *HardforkRegistryV1HardforkFinalized // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *HardforkRegistryV1HardforkFinalizedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(HardforkRegistryV1HardforkFinalized)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(HardforkRegistryV1HardforkFinalized)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *HardforkRegistryV1HardforkFinalizedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *HardforkRegistryV1HardforkFinalizedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// HardforkRegistryV1HardforkFinalized represents a HardforkFinalized event raised by the HardforkRegistryV1 contract.
type HardforkRegistryV1HardforkFinalized struct {
	Name        [32]byte
	BlockNumber *big.Int
	BlockHash   [32]byte
	SwFeatures  *big.Int
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterHardforkFinalized is a free log retrieval operation binding the contract event 0x6dc459fd769bc8043e2a9bf76cf8ca708f41158bb7d40566a9f488a8fc6c87da.
//
// Solidity: event HardforkFinalized(bytes32 indexed name, uint256 block_number, bytes32 block_hash, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1Filterer) FilterHardforkFinalized(opts *bind.FilterOpts, name [][32]byte) (*HardforkRegistryV1HardforkFinalizedIterator, error) {

	var nameRule []interface{}
	for _, nameItem := range name {
		nameRule = append(nameRule, nameItem)
	}

	logs, sub, err := _HardforkRegistryV1.contract.FilterLogs(opts, "HardforkFinalized", nameRule)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1HardforkFinalizedIterator{contract: _HardforkRegistryV1.contract, event: "HardforkFinalized", logs: logs, sub: sub}, nil
}

// WatchHardforkFinalized is a free log subscription operation binding the contract event 0x6dc459fd769bc8043e2a9bf76cf8ca708f41158bb7d40566a9f488a8fc6c87da.
//
// Solidity: event HardforkFinalized(bytes32 indexed name, uint256 block_number, bytes32 block_hash, uint256 sw_features)
func (_HardforkRegistryV1 *HardforkRegistryV1Filterer) WatchHardforkFinalized(opts *bind.WatchOpts, sink chan<- *HardforkRegistryV1HardforkFinalized, name [][32]byte) (event.Subscription, error) {

	var nameRule []interface{}
	for _, nameItem := range name {
		nameRule = append(nameRule, nameItem)
	}

	logs, sub, err := _HardforkRegistryV1.contract.WatchLogs(opts, "HardforkFinalized", nameRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(HardforkRegistryV1HardforkFinalized)
				if err := _HardforkRegistryV1.contract.UnpackLog(event, "HardforkFinalized", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// HardforkRegistryV1HardforkRemovedIterator is returned from FilterHardforkRemoved and is used to iterate over the raw logs and unpacked data for HardforkRemoved events raised by the HardforkRegistryV1 contract.
type HardforkRegistryV1HardforkRemovedIterator struct {
	Event *HardforkRegistryV1HardforkRemoved // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *HardforkRegistryV1HardforkRemovedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(HardforkRegistryV1HardforkRemoved)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(HardforkRegistryV1HardforkRemoved)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *HardforkRegistryV1HardforkRemovedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *HardforkRegistryV1HardforkRemovedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// HardforkRegistryV1HardforkRemoved represents a HardforkRemoved event raised by the HardforkRegistryV1 contract.
type HardforkRegistryV1HardforkRemoved struct {
	Name          [32]byte
	UnindexedName [32]byte
	Raw           types.Log // Blockchain specific contextual infos
}

// FilterHardforkRemoved is a free log retrieval operation binding the contract event 0x9e405a3cec329c3a3b1fce0ce501b60d6a7714e185d57047ab1d1970ba9f8fea.
//
// Solidity: event HardforkRemoved(bytes32 indexed name, bytes32 unindexed_name)
func (_HardforkRegistryV1 *HardforkRegistryV1Filterer) FilterHardforkRemoved(opts *bind.FilterOpts, name [][32]byte) (*HardforkRegistryV1HardforkRemovedIterator, error) {

	var nameRule []interface{}
	for _, nameItem := range name {
		nameRule = append(nameRule, nameItem)
	}

	logs, sub, err := _HardforkRegistryV1.contract.FilterLogs(opts, "HardforkRemoved", nameRule)
	if err != nil {
		return nil, err
	}
	return &HardforkRegistryV1HardforkRemovedIterator{contract: _HardforkRegistryV1.contract, event: "HardforkRemoved", logs: logs, sub: sub}, nil
}

// WatchHardforkRemoved is a free log subscription operation binding the contract event 0x9e405a3cec329c3a3b1fce0ce501b60d6a7714e185d57047ab1d1970ba9f8fea.
//
// Solidity: event HardforkRemoved(bytes32 indexed name, bytes32 unindexed_name)
func (_HardforkRegistryV1 *HardforkRegistryV1Filterer) WatchHardforkRemoved(opts *bind.WatchOpts, sink chan<- *HardforkRegistryV1HardforkRemoved, name [][32]byte) (event.Subscription, error) {

	var nameRule []interface{}
	for _, nameItem := range name {
		nameRule = append(nameRule, nameItem)
	}

	logs, sub, err := _HardforkRegistryV1.contract.WatchLogs(opts, "HardforkRemoved", nameRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(HardforkRegistryV1HardforkRemoved)
				if err := _HardforkRegistryV1.contract.UnpackLog(event, "HardforkRemoved", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}
