/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.Icon;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.inspector.IconManager;

public class XMBean {
    private final MBeansTab mbeansTab;
    private final ObjectName objectName;
    private Icon icon;
    private String text;
    private Boolean broadcaster;
    private final Object broadcasterLock = new Object();
    private MBeanInfo mbeanInfo;
    private final Object mbeanInfoLock = new Object();

    public XMBean(ObjectName objectName, MBeansTab mBeansTab) {
        this.mbeansTab = mBeansTab;
        this.objectName = objectName;
        this.text = objectName.getKeyProperty("name");
        if (this.text == null) {
            this.text = objectName.getDomain();
        }
        this.icon = MBeanServerDelegate.DELEGATE_NAME.equals(objectName) ? IconManager.MBEANSERVERDELEGATE : IconManager.MBEAN;
    }

    MBeanServerConnection getMBeanServerConnection() {
        return this.mbeansTab.getMBeanServerConnection();
    }

    ProxyClient.SnapshotMBeanServerConnection getSnapshotMBeanServerConnection() {
        return this.mbeansTab.getSnapshotMBeanServerConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isBroadcaster() {
        Object object = this.broadcasterLock;
        synchronized (object) {
            if (this.broadcaster == null) {
                try {
                    this.broadcaster = this.getMBeanServerConnection().isInstanceOf(this.getObjectName(), "javax.management.NotificationBroadcaster");
                }
                catch (Exception exception) {
                    if (JConsole.isDebug()) {
                        System.err.println("Couldn't check if MBean [" + this.objectName + "] is a notification broadcaster");
                        exception.printStackTrace();
                    }
                    return false;
                }
            }
            return this.broadcaster;
        }
    }

    public Object invoke(String string) throws Exception {
        Object object = this.getMBeanServerConnection().invoke(this.getObjectName(), string, new Object[0], new String[0]);
        return object;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object object = this.getMBeanServerConnection().invoke(this.getObjectName(), string, objectArray, stringArray);
        return object;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.getMBeanServerConnection().setAttribute(this.getObjectName(), attribute);
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getSnapshotMBeanServerConnection().getAttribute(this.getObjectName(), string);
    }

    public AttributeList getAttributes(String[] stringArray) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getSnapshotMBeanServerConnection().getAttributes(this.getObjectName(), stringArray);
    }

    public AttributeList getAttributes(MBeanAttributeInfo[] mBeanAttributeInfoArray) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String[] stringArray = new String[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            stringArray[i] = mBeanAttributeInfoArray[i].getName();
        }
        return this.getAttributes(stringArray);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Object object = this.mbeanInfoLock;
        synchronized (object) {
            if (this.mbeanInfo == null) {
                this.mbeanInfo = this.getMBeanServerConnection().getMBeanInfo(this.objectName);
            }
            return this.mbeanInfo;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof XMBean)) {
            return false;
        }
        XMBean xMBean = (XMBean)object;
        return this.getObjectName().equals(xMBean.getObjectName());
    }

    public int hashCode() {
        return this.objectName == null ? 0 : this.objectName.hashCode();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getText();
    }
}

