/*
 *  Author: tican
 *
 *  Declarations for Syscriptor.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void video(const int BUF_SIZE)
{
	FILE *file;
	int found;
	char buf[BUF_SIZE];
	char *card, *card2, *card3, *fname;

	fname = "/proc/pci";
	file = fopen(fname, "r");
	if ( !file ) {
		fprintf(stderr, "Could not open %s. Bailing out.\n", fname);
		exit(EXIT_FAILURE);
	}

	puts("");
        printf("  VIDEO\n\n");

	printf("  VGA controller(s):\n");
	found = 0;
	while ( fgets(buf, BUF_SIZE, file) ) {
		card = strstr(buf,"VGA");
		if ( card ) {
			card2 = strchr(card, '.');
			if ( card2 ) {
				found=1;
				card2[0] = 0;
				card3 = strchr(card,':')+1;
				printf(" %s\n", card3);
			}
		}
	}

	if ( !found ) {
		printf("  Could not find your videocard.\n");
	}

	puts("");
	fclose(file);
}
