/* support.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#ifndef _G_SUPPORT_H
#define _G_SUPPORT_H

extern GtkWidget *glade_to_hash(GladeXML *Axml, GHashTable *Ahash, gchar *Akey);
extern GtkWidget *glade_to_hashv(GladeXML *Axml, GHashTable *Ahash, const gchar *Akeyformat, ...);
extern void glade_to_hash_list(GladeXML *Axml, GHashTable *Ahash, const gchar *Afirst, ...);
extern GtkWidget *sc_glade_xml_get_widgetv(GladeXML *Axml, const gchar *Akeyformat, ...);
extern void set_cursor(GtkWidget *Awindow, GdkCursorType Acursortype);
extern void unset_cursor(GtkWidget *Awindow);
extern void maj_progress(GtkProgressBar *AprogressBar, gdouble Apourcent);

extern Tgrave *sc_grave_newempty();
extern Tgrave *sc_grave_load(gchar *Aname);
extern Tgrave *sc_grave_destroy(Tgrave *Awidget);
extern GtkWidget *sc_grave_get_widget(Tgrave *Agrave, gchar *Aname);
extern GtkWidget *sc_grave_get_widgetv(Tgrave *Agrave, gchar *Aformat, ...);
extern gpointer sc_grave_get_data(Tgrave *Agrave, gchar *Aname);
extern gpointer sc_grave_get_datav(Tgrave *Agrave, gchar *Aformat, ...);
extern gpointer sc_grave_set_data(Tgrave *Agrave, gpointer Aptr, gchar *Aname);
extern gpointer sc_grave_set_datav(Tgrave *Agrave, gpointer Aptr, gchar *Aformat, ...);
extern gpointer sc_grave_replace_data(Tgrave *Agrave, gpointer Aptr, gchar *Aname);
extern gpointer sc_grave_replace_datav(Tgrave *Agrave, gpointer Aptr, gchar *Aformat, ...);
extern gpointer sc_grave_del_data(Tgrave *Agrave, gchar *Aname);
extern gpointer sc_grave_del_datav(Tgrave *Agrave, gchar *Aformat, ...);
extern gpointer sc_grave_ref_wtd(Tgrave *Agrave, gchar *Awidgetsrc, gchar *Adatadst);
extern gpointer sc_grave_vet_widgetordata(Tgrave *Agrave, gchar *Aname);
extern void sc_init();
extern void sc_tooltips(GtkWidget *Awindow, gboolean Aetat);

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
