/* main.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

gchar *Glocale = NULL;

/* programme principal ! */
gint main (gint Aargc, gchar *Aargv[])
{
  GError *Lerror = NULL;
  guint64 Laudiolen = 0, Ldatasize = 0, Ldvdsize = 0;
  guint64 Laudiomaxlen = 4800;  /* par defaut, cd audio de 80 minutes */
  guint64 Ldatamaxsize = 700 * 1024 * 1024; /* par defaut, cd de donnee de 700 Mb */
  guint64 Ldvddatamaxsize = G_GINT64_CONSTANT(4700000000); /* pas default, dvd de donnee de 4.7 Gb */
  gchar *Lcurdomain = NULL;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  Lcurdomain = textdomain (GETTEXT_PACKAGE);
  gtk_disable_setlocale();
#endif
  gtk_init (&Aargc, &Aargv);
#ifdef ENABLE_NLS
  Glocale = gtk_set_locale();
#endif

  if (!graveman_init(Aargc, Aargv)) return EXIT_SUCCESS;

  /* on regarde si il y a un fichier de configuration present, si non on en
   * genere un nouveau */
  config_init();
  if (get_config_file(R_OK) == FALSE) {
    Tgrave *Lg = sc_grave_newempty();
    load_all_images();
    manage_config(Lg, SEARCH_LECTEUR + CONF_INIT_DEFAULT + SEARCH_PROG + SEARCH_CHARSETS +
                      WRITE_CONFIG, &Lerror);
    sc_grave_destroy(Lg);
    welcome_to_graveman();
  } else {
    if (read_config(&Lerror)==FALSE) return EXIT_FAILURE;
    load_all_images();
    if (conf_get_boolean("scan_drives") || param_get_boolean("scan_drives"))
    {
      Tgrave *Lg = sc_grave_newempty();
      /* scan for new drives on startup */
      manage_config(Lg, SEARCH_LECTEUR, &Lerror);
      sc_grave_destroy(Lg);
    }
  }
  
  if (Lerror) {
    g_warning("%s", Lerror->message);
  }
  
  manage_main_window (&Laudiolen, &Laudiomaxlen, &Ldatasize, &Ldatamaxsize, &Ldvdsize, &Ldvddatamaxsize); 

  gtk_main ();

  /* on libere avant de quitter */
  if (Lerror) g_error_free(Lerror);

  free_all_images();
  
  return EXIT_SUCCESS;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
