/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.DependencyFilter;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.filter.AndDependencyFilter;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.filter.NotDependencyFilter;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.filter.OrDependencyFilter;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.filter.ScopeDependencyFilter;

public final class DependencyFilterUtils {
    private DependencyFilterUtils() {
    }

    public static DependencyFilter notFilter(DependencyFilter filter) {
        return new NotDependencyFilter(filter);
    }

    public static DependencyFilter andFilter(DependencyFilter ... filters) {
        if (filters != null && filters.length == 1) {
            return filters[0];
        }
        return new AndDependencyFilter(filters);
    }

    public static DependencyFilter andFilter(Collection<DependencyFilter> filters) {
        if (filters != null && filters.size() == 1) {
            return filters.iterator().next();
        }
        return new AndDependencyFilter(filters);
    }

    public static DependencyFilter orFilter(DependencyFilter ... filters) {
        if (filters != null && filters.length == 1) {
            return filters[0];
        }
        return new OrDependencyFilter(filters);
    }

    public static DependencyFilter orFilter(Collection<DependencyFilter> filters) {
        if (filters != null && filters.size() == 1) {
            return filters.iterator().next();
        }
        return new OrDependencyFilter(filters);
    }

    public static DependencyFilter classpathFilter(String ... classpathTypes) {
        return DependencyFilterUtils.classpathFilter(classpathTypes != null ? Arrays.asList(classpathTypes) : null);
    }

    public static DependencyFilter classpathFilter(Collection<String> classpathTypes) {
        HashSet<String> types = new HashSet<String>();
        if (classpathTypes != null) {
            for (String string : classpathTypes) {
                String[] tokens;
                for (String token : tokens = string.split("[+,]")) {
                    if ((token = token.trim()).length() <= 0) continue;
                    types.add(token);
                }
            }
        }
        HashSet<String> included = new HashSet<String>();
        for (String type : types) {
            if ("compile".equals(type)) {
                Collections.addAll(included, "compile", "provided", "system");
                continue;
            }
            if ("runtime".equals(type)) {
                Collections.addAll(included, "compile", "runtime");
                continue;
            }
            if ("test".equals(type)) {
                Collections.addAll(included, "compile", "provided", "system", "runtime", "test");
                continue;
            }
            included.add(type);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, "compile", "provided", "system", "runtime", "test");
        hashSet.removeAll(included);
        return new ScopeDependencyFilter(null, hashSet);
    }
}

