(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require map.Map.
Require bool.Bool.
Require list.Nth.
Require option.Option.
Require list.NthLength.
Require list.Append.
Require list.NthLengthAppend.

(* Why3 assumption *)
Definition unit := unit.

Axiom qtmark : Type.
Parameter qtmark_WhyType : WhyType qtmark.
Existing Instance qtmark_WhyType.

Axiom map : forall (a:Type) (b:Type), Type.
Parameter map_WhyType : forall (a:Type) {a_WT:WhyType a}
  (b:Type) {b_WT:WhyType b}, WhyType (map a b).
Existing Instance map_WhyType.

Parameter get: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b.

Parameter set: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b -> (map a b).

Axiom Select_eq : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (m:(map a b)), forall (a1:a) (a2:a), forall (b1:b), (a1 = a2) ->
  ((get (set m a1 b1) a2) = b1).

Axiom Select_neq : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (m:(map a b)), forall (a1:a) (a2:a),
  forall (b1:b), (~ (a1 = a2)) -> ((get (set m a1 b1) a2) = (get m a2)).

Parameter const: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  b -> (map a b).

Axiom Const : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (b1:b) (a1:a), ((get (const b1: (map a b)) a1) = b1).

(* Why3 assumption *)
Inductive id :=
  | Id : Z -> id.
Axiom id_WhyType : WhyType id.
Existing Instance id_WhyType.

(* Why3 assumption *)
Definition state := (map id Z).

(* Why3 assumption *)
Inductive aexpr :=
  | Anum : Z -> aexpr
  | Avar : id -> aexpr
  | Aadd : aexpr -> aexpr -> aexpr
  | Asub : aexpr -> aexpr -> aexpr
  | Amul : aexpr -> aexpr -> aexpr.
Axiom aexpr_WhyType : WhyType aexpr.
Existing Instance aexpr_WhyType.

(* Why3 assumption *)
Inductive bexpr :=
  | Btrue : bexpr
  | Bfalse : bexpr
  | Band : bexpr -> bexpr -> bexpr
  | Bnot : bexpr -> bexpr
  | Beq : aexpr -> aexpr -> bexpr
  | Ble : aexpr -> aexpr -> bexpr.
Axiom bexpr_WhyType : WhyType bexpr.
Existing Instance bexpr_WhyType.

(* Why3 assumption *)
Inductive com :=
  | Cskip : com
  | Cassign : id -> aexpr -> com
  | Cseq : com -> com -> com
  | Cif : bexpr -> com -> com -> com
  | Cwhile : bexpr -> com -> com.
Axiom com_WhyType : WhyType com.
Existing Instance com_WhyType.

(* Why3 assumption *)
Fixpoint aeval (st:(map id Z)) (e:aexpr) {struct e}: Z :=
  match e with
  | (Anum n) => n
  | (Avar x) => (get st x)
  | (Aadd e1 e2) => ((aeval st e1) + (aeval st e2))%Z
  | (Asub e1 e2) => ((aeval st e1) - (aeval st e2))%Z
  | (Amul e1 e2) => ((aeval st e1) * (aeval st e2))%Z
  end.

Parameter beval: (map id Z) -> bexpr -> bool.

Axiom beval_def : forall (st:(map id Z)) (b:bexpr),
  (match b with
  | Btrue => True
  | Bfalse => False
  | (Bnot b') => ((Init.Datatypes.negb (beval st b')) = true)
  | (Band b1 b2) => ((Init.Datatypes.andb (beval st b1) (beval st
      b2)) = true)
  | (Beq a1 a2) => ((aeval st a1) = (aeval st a2))
  | (Ble a1 a2) => ((aeval st a1) <= (aeval st a2))%Z
  end -> ((beval st b) = true)) /\
  ((~ match b with
  | Btrue => True
  | Bfalse => False
  | (Bnot b') => ((Init.Datatypes.negb (beval st b')) = true)
  | (Band b1 b2) => ((Init.Datatypes.andb (beval st b1) (beval st
      b2)) = true)
  | (Beq a1 a2) => ((aeval st a1) = (aeval st a2))
  | (Ble a1 a2) => ((aeval st a1) <= (aeval st a2))%Z
  end) -> ((beval st b) = false)).

(* Why3 assumption *)
Inductive ceval: (map id Z) -> com -> (map id Z) -> Prop :=
  | E_Skip : forall (m:(map id Z)), (ceval m Cskip m)
  | E_Ass : forall (m:(map id Z)) (a:aexpr) (x:id), (ceval m (Cassign x a)
      (set m x (aeval m a)))
  | E_Seq : forall (cmd1:com) (cmd2:com) (m0:(map id Z)) (m1:(map id Z))
      (m2:(map id Z)), (ceval m0 cmd1 m1) -> ((ceval m1 cmd2 m2) -> (ceval m0
      (Cseq cmd1 cmd2) m2))
  | E_IfTrue : forall (m0:(map id Z)) (m1:(map id Z)) (cond:bexpr) (cmd1:com)
      (cmd2:com), ((beval m0 cond) = true) -> ((ceval m0 cmd1 m1) -> (ceval
      m0 (Cif cond cmd1 cmd2) m1))
  | E_IfFalse : forall (m0:(map id Z)) (m1:(map id Z)) (cond:bexpr)
      (cmd1:com) (cmd2:com), (~ ((beval m0 cond) = true)) -> ((ceval m0 cmd2
      m1) -> (ceval m0 (Cif cond cmd1 cmd2) m1))
  | E_WhileEnd : forall (cond:bexpr) (m:(map id Z)) (body:com), (~ ((beval m
      cond) = true)) -> (ceval m (Cwhile cond body) m)
  | E_WhileLoop : forall (mi:(map id Z)) (mj:(map id Z)) (mf:(map id Z))
      (cond:bexpr) (body:com), ((beval mi cond) = true) -> ((ceval mi body
      mj) -> ((ceval mj (Cwhile cond body) mf) -> (ceval mi (Cwhile cond
      body) mf))).

Axiom ceval_deterministic_aux : forall (c:com) (mi:(map id Z)) (mf1:(map id
  Z)), (ceval mi c mf1) -> forall (mf2:(map id Z)), (ceval mi c mf2) ->
  (mf1 = mf2).

Axiom ceval_deterministic : forall (c:com) (mi:(map id Z)) (mf1:(map id Z))
  (mf2:(map id Z)), (ceval mi c mf1) -> ((ceval mi c mf2) -> (mf1 = mf2)).

(* Why3 assumption *)
Definition pos := Z.

(* Why3 assumption *)
Definition stack := (list Z).

(* Why3 assumption *)
Inductive machine_state :=
  | VMS : Z -> (list Z) -> (map id Z) -> machine_state.
Axiom machine_state_WhyType : WhyType machine_state.
Existing Instance machine_state_WhyType.

(* Why3 assumption *)
Inductive instr :=
  | Iconst : Z -> instr
  | Ivar : id -> instr
  | Isetvar : id -> instr
  | Ibranch : Z -> instr
  | Iadd : instr
  | Isub : instr
  | Imul : instr
  | Ibeq : Z -> instr
  | Ibne : Z -> instr
  | Ible : Z -> instr
  | Ibgt : Z -> instr
  | Ihalt : instr.
Axiom instr_WhyType : WhyType instr.
Existing Instance instr_WhyType.

(* Why3 assumption *)
Definition code := (list instr).

(* Why3 assumption *)
Inductive codeseq_at: (list instr) -> Z -> (list instr) -> Prop :=
  | codeseq_at_intro : forall (c1:(list instr)) (c2:(list instr))
      (c3:(list instr)), (codeseq_at
      (Init.Datatypes.app (Init.Datatypes.app c1 c2) c3)
      (list.Length.length c1) c2).

Axiom codeseq_at_app_right : forall (c:(list instr)) (c1:(list instr))
  (c2:(list instr)) (p:Z), (codeseq_at c p (Init.Datatypes.app c1 c2)) ->
  (codeseq_at c (p + (list.Length.length c1))%Z c2).

Axiom codeseq_at_app_left : forall (c:(list instr)) (c1:(list instr))
  (c2:(list instr)) (p:Z), (codeseq_at c p (Init.Datatypes.app c1 c2)) ->
  (codeseq_at c p c1).

(* Why3 assumption *)
Definition iconst (n:Z): (list instr) :=
  (Init.Datatypes.cons (Iconst n) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ivar (x:id): (list instr) :=
  (Init.Datatypes.cons (Ivar x) Init.Datatypes.nil).

(* Why3 assumption *)
Definition isetvar (x:id): (list instr) :=
  (Init.Datatypes.cons (Isetvar x) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibeq (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibeq ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ible (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ible ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibne (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibne ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibgt (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibgt ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibranch (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibranch ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Inductive transition: (list instr) -> machine_state -> machine_state ->
  Prop :=
  | trans_const : forall (c:(list instr)) (p:Z) (n:Z), (codeseq_at c p
      (iconst n)) -> forall (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      s m) (VMS (p + 1%Z)%Z (Init.Datatypes.cons n s) m))
  | trans_var : forall (c:(list instr)) (p:Z) (x:id), (codeseq_at c p
      (ivar x)) -> forall (s:(list Z)) (m:(map id Z)), (transition c (VMS p s
      m) (VMS (p + 1%Z)%Z (Init.Datatypes.cons (get m x) s) m))
  | trans_set_var : forall (c:(list instr)) (p:Z) (x:id), (codeseq_at c p
      (isetvar x)) -> forall (n:Z) (s:(list Z)) (m:(map id Z)), (transition c
      (VMS p (Init.Datatypes.cons n s) m) (VMS (p + 1%Z)%Z s (set m x n)))
  | trans_add : forall (c:(list instr)) (p:Z), (codeseq_at c p
      (Init.Datatypes.cons Iadd Init.Datatypes.nil)) -> forall (n1:Z) (n2:Z)
      (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) (VMS (p + 1%Z)%Z
      (Init.Datatypes.cons (n1 + n2)%Z s) m))
  | trans_sub : forall (c:(list instr)) (p:Z), (codeseq_at c p
      (Init.Datatypes.cons Isub Init.Datatypes.nil)) -> forall (n1:Z) (n2:Z)
      (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) (VMS (p + 1%Z)%Z
      (Init.Datatypes.cons (n1 - n2)%Z s) m))
  | trans_mul : forall (c:(list instr)) (p:Z), (codeseq_at c p
      (Init.Datatypes.cons Imul Init.Datatypes.nil)) -> forall (n1:Z) (n2:Z)
      (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) (VMS (p + 1%Z)%Z
      (Init.Datatypes.cons (n1 * n2)%Z s) m))
  | trans_beq : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibeq ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 = n2) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_beq1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibeq ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 = n2)) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bne : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibne ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 = n2) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bne1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibne ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 = n2)) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_ble : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ible ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 <= n2)%Z -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_ble1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ible ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 <= n2)%Z) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bgt : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibgt ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 <= n2)%Z -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bgt1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibgt ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 <= n2)%Z) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_branch : forall (c:(list instr)) (p:Z) (ofs:Z), (codeseq_at c p
      (ibranch ofs)) -> forall (s:(list Z)) (m:(map id Z)), (transition c
      (VMS p s m) (VMS ((p + 1%Z)%Z + ofs)%Z s m)).

(* Why3 assumption *)
Inductive transition_star: (list instr) -> machine_state -> machine_state ->
  Prop :=
  | Refl : forall (p:(list instr)) (x:machine_state), (transition_star p x x)
  | Step : forall (p:(list instr)) (x:machine_state) (y:machine_state)
      (z:machine_state), (transition p x y) -> ((transition_star p y z) ->
      (transition_star p x z)).

Axiom transition_star_one : forall (p:(list instr)) (s1:machine_state)
  (s2:machine_state), (transition p s1 s2) -> (transition_star p s1 s2).

Axiom transition_star_transitive : forall (p:(list instr)) (s1:machine_state)
  (s2:machine_state) (s3:machine_state), (transition_star p s1 s2) ->
  ((transition_star p s2 s3) -> (transition_star p s1 s3)).

(* Why3 assumption *)
Definition vm_stuck (c:(list instr)) (msi:machine_state)
  (msf:machine_state): Prop := (transition_star c msi msf) /\
  forall (ms':machine_state), ~ (transition c msf ms').

Axiom func : forall (a:Type) (b:Type), Type.
Parameter func_WhyType : forall (a:Type) {a_WT:WhyType a}
  (b:Type) {b_WT:WhyType b}, WhyType (func a b).
Existing Instance func_WhyType.

(* Why3 assumption *)
Definition pred (a:Type) := (func a bool).

Parameter infix_at: forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, (func a b) -> a -> b.

(* Why3 assumption *)
Inductive clock_state :=
  | VMC : Z -> (list Z) -> (map id Z) -> Z -> clock_state.
Axiom clock_state_WhyType : WhyType clock_state.
Existing Instance clock_state_WhyType.

(* Why3 assumption *)
Definition parameter := ((list instr)* (func clock_state bool))%type.

(* Why3 assumption *)
Definition transition_out (p:((list instr)* (func clock_state bool))%type)
  (mc1:clock_state) (mc2:clock_state): Prop :=
  match p with
  | (c, inside) => (~ ((infix_at inside mc1) = true)) /\
      ((~ ((infix_at inside mc2) = true)) /\
      match mc1 with
      | (VMC p1 s1 m1 c1) =>
          match mc2 with
          | (VMC p2 s2 m2 c2) => (transition c (VMS p1 s1 m1) (VMS p2 s2
              m2)) /\ (c2 = (c1 + 1%Z)%Z)
          end
      end)
  end.

(* Why3 assumption *)
Inductive transition_star1: ((list instr)* (func clock_state bool))%type ->
  clock_state -> clock_state -> Prop :=
  | Refl1 : forall (p:((list instr)* (func clock_state bool))%type)
      (x:clock_state), (transition_star1 p x x)
  | Step1 : forall (p:((list instr)* (func clock_state bool))%type)
      (x:clock_state) (y:clock_state) (z:clock_state), (transition_out p x
      y) -> ((transition_star1 p y z) -> (transition_star1 p x z)).

Axiom transition_star_one1 : forall (p:((list instr)* (func clock_state
  bool))%type) (s1:clock_state) (s2:clock_state), (transition_out p s1 s2) ->
  (transition_star1 p s1 s2).

Axiom transition_star_transitive1 : forall (p:((list instr)* (func
  clock_state bool))%type) (s1:clock_state) (s2:clock_state)
  (s3:clock_state), (transition_star1 p s1 s2) -> ((transition_star1 p s2
  s3) -> (transition_star1 p s1 s3)).

Axiom transition_star_endpoints : forall (c:(list instr)) (p:(func
  clock_state bool)) (s0:clock_state) (s1:clock_state), (transition_star1 (c,
  p) s0 s1) -> ((~ (s0 = s1)) -> ((~ ((infix_at p s0) = true)) /\
  ~ ((infix_at p s1) = true))).

Axiom transition_star_weakening : forall (c:(list instr)) (p:(func
  clock_state bool)) (q:(func clock_state bool)) (s0:clock_state)
  (s1:clock_state), (forall (x:clock_state), ((infix_at q x) = true) ->
  ((infix_at p x) = true)) -> ((transition_star1 (c, p) s0 s1) ->
  (transition_star1 (c, q) s0 s1)).

Axiom transition_deterministic : forall (c:(list instr)) (ms:machine_state)
  (ms':machine_state) (ms'':machine_state), ((transition c ms ms') /\
  (transition c ms ms'')) -> (ms' = ms'').

Axiom transition_out_deterministic : forall (p:((list instr)* (func
  clock_state bool))%type) (mc1:clock_state) (mc2:clock_state)
  (mc3:clock_state), ((transition_out p mc1 mc2) /\ (transition_out p mc1
  mc3)) -> (mc2 = mc3).

Axiom halt_stuck : forall (c:(list instr)) (p:Z) (s:(list Z)) (m:(map id Z)),
  (codeseq_at c p (Init.Datatypes.cons Ihalt Init.Datatypes.nil)) ->
  forall (ms':machine_state), ~ (transition c (VMS p s m) ms').

(* Why3 assumption *)
Definition fst {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b} (p:(a*
  b)%type): a := match p with
  | (x, _) => x
  end.

(* Why3 assumption *)
Definition snd {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b} (p:(a*
  b)%type): b := match p with
  | (_, y) => y
  end.

(* Why3 assumption *)
Definition pred1 := (func clock_state bool).

(* Why3 assumption *)
Definition rel := (func clock_state (func clock_state bool)).

(* Why3 assumption *)
Definition pre (a:Type) := (func a (func Z (func clock_state bool))).

(* Why3 assumption *)
Definition post (a:Type) := (func a (func Z (func clock_state (func
  clock_state bool)))).

(* Why3 assumption *)
Inductive hl
  (a:Type) :=
  | mk_hl : (list instr) -> (func a (func Z (func clock_state bool))) ->
      (func a (func Z (func clock_state (func clock_state bool)))) -> hl a.
Axiom hl_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (hl a).
Existing Instance hl_WhyType.
Implicit Arguments mk_hl [[a]].

(* Why3 assumption *)
Definition post1 {a:Type} {a_WT:WhyType a} (v:(hl a)): (func a (func Z (func
  clock_state (func clock_state bool)))) :=
  match v with
  | (mk_hl x x1 x2) => x2
  end.

(* Why3 assumption *)
Definition pre1 {a:Type} {a_WT:WhyType a} (v:(hl a)): (func a (func Z (func
  clock_state bool))) := match v with
  | (mk_hl x x1 x2) => x1
  end.

(* Why3 assumption *)
Definition code1 {a:Type} {a_WT:WhyType a} (v:(hl a)): (list instr) :=
  match v with
  | (mk_hl x x1 x2) => x
  end.

(* Why3 assumption *)
Definition wp_trans (a:Type) := (func a (func Z (func (func clock_state bool)
  (func clock_state bool)))).

(* Why3 assumption *)
Inductive wp
  (a:Type) :=
  | mk_wp : (list instr) -> (func a (func Z (func (func clock_state bool)
      (func clock_state bool)))) -> wp a.
Axiom wp_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (wp a).
Existing Instance wp_WhyType.
Implicit Arguments mk_wp [[a]].

(* Why3 assumption *)
Definition wp1 {a:Type} {a_WT:WhyType a} (v:(wp a)): (func a (func Z (func
  (func clock_state bool) (func clock_state bool)))) :=
  match v with
  | (mk_wp x x1) => x1
  end.

(* Why3 assumption *)
Definition wcode {a:Type} {a_WT:WhyType a} (v:(wp a)): (list instr) :=
  match v with
  | (mk_wp x x1) => x
  end.

(* Why3 assumption *)
Definition hl_correctness {a:Type} {a_WT:WhyType a} (cs:(hl a)): Prop :=
  forall (x:a) (c_glob:(list instr)) (p:Z) (mc:clock_state)
  (mc':clock_state), ((infix_at (infix_at (infix_at (pre1 cs) x) p)
  mc) = true) -> ((codeseq_at c_glob p (code1 cs)) -> let post2 :=
  (infix_at (infix_at (infix_at (post1 cs) x) p) mc) in (((transition_star1 (
  c_glob, post2) mc mc') /\ ~ ((infix_at post2 mc') = true)) ->
  match mc' with
  | (VMC p1 s m _) => exists ms'':machine_state, (transition c_glob (VMS p1 s
      m) ms'')
  end)).

(* Why3 assumption *)
Definition wp_correctness {a:Type} {a_WT:WhyType a} (code2:(wp a)): Prop :=
  forall (x:a) (c_glob:(list instr)) (p:Z) (post2:(func clock_state bool))
  (mc:clock_state) (mc':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (wp1 code2) x) p) post2)
  mc) = true) -> ((codeseq_at c_glob p (wcode code2)) -> (((transition_star1
  (c_glob, post2) mc mc') /\ ~ ((infix_at post2 mc') = true)) ->
  match mc' with
  | (VMC p1 s m _) => exists ms'':machine_state, (transition c_glob (VMS p1 s
      m) ms'')
  end)).

Parameter seq_wp: forall {a:Type} {a_WT:WhyType a}, Z -> (func a (func Z
  (func (func clock_state bool) (func clock_state bool)))) -> (func (a*
  clock_state)%type (func Z (func (func clock_state bool) (func clock_state
  bool)))) -> (func a (func Z (func (func clock_state bool) (func clock_state
  bool)))).

Axiom seq_wp_def : forall {a:Type} {a_WT:WhyType a}, forall (l1:Z) (w1:(func
  a (func Z (func (func clock_state bool) (func clock_state bool)))))
  (w2:(func (a* clock_state)%type (func Z (func (func clock_state bool) (func
  clock_state bool))))) (x:a) (p:Z) (q:(func clock_state bool))
  (mc:clock_state), ((infix_at (infix_at (infix_at (infix_at (seq_wp l1 w1
  w2) x) p) q) mc) = (infix_at (infix_at (infix_at (infix_at w1 x) p)
  (infix_at (infix_at (infix_at w2 (x, mc)) (p + l1)%Z) q)) mc)).

Axiom seq_wp_lemma : forall {a:Type} {a_WT:WhyType a}, forall (l1:Z)
  (w1:(func a (func Z (func (func clock_state bool) (func clock_state
  bool))))) (w2:(func (a* clock_state)%type (func Z (func (func clock_state
  bool) (func clock_state bool))))) (x:a) (p:Z) (q:(func clock_state bool))
  (mc:clock_state), ((infix_at (infix_at (infix_at (infix_at (seq_wp l1 w1
  w2) x) p) q) mc) = (infix_at (infix_at (infix_at (infix_at w1 x) p)
  (infix_at (infix_at (infix_at w2 (x, mc)) (p + l1)%Z) q)) mc)).

Parameter fork_wp: forall {a:Type} {a_WT:WhyType a}, (func a (func Z (func
  (func clock_state bool) (func clock_state bool)))) -> (func a (func Z (func
  clock_state bool))) -> (func a (func Z (func (func clock_state bool) (func
  clock_state bool)))).

Axiom fork_wp_def : forall {a:Type} {a_WT:WhyType a}, forall (w:(func a (func
  Z (func (func clock_state bool) (func clock_state bool))))) (cond:(func a
  (func Z (func clock_state bool)))) (x:a) (p:Z) (q:(func clock_state bool))
  (ms:clock_state), ((infix_at (infix_at (infix_at (infix_at (fork_wp w cond)
  x) p) q) ms) = true) <-> (((~ ((infix_at (infix_at (infix_at cond x) p)
  ms) = true)) -> ((infix_at q ms) = true)) /\
  (((infix_at (infix_at (infix_at cond x) p) ms) = true) ->
  ((infix_at (infix_at (infix_at (infix_at w x) p) q) ms) = true))).

Axiom fork_wp_lemma : forall {a:Type} {a_WT:WhyType a}, forall (w:(func a
  (func Z (func (func clock_state bool) (func clock_state bool)))))
  (cond:(func a (func Z (func clock_state bool)))) (x:a) (p:Z) (q:(func
  clock_state bool)) (ms:clock_state),
  ((infix_at (infix_at (infix_at (infix_at (fork_wp w cond) x) p) q)
  ms) = true) <-> (((~ ((infix_at (infix_at (infix_at cond x) p)
  ms) = true)) -> ((infix_at q ms) = true)) /\
  (((infix_at (infix_at (infix_at cond x) p) ms) = true) ->
  ((infix_at (infix_at (infix_at (infix_at w x) p) q) ms) = true))).

Parameter towp_wp: forall {a:Type} {a_WT:WhyType a}, (func a (func Z (func
  clock_state bool))) -> (func a (func Z (func clock_state (func clock_state
  bool)))) -> (func a (func Z (func (func clock_state bool) (func clock_state
  bool)))).

Axiom towp_wp_def : forall {a:Type} {a_WT:WhyType a}, forall (pr:(func a
  (func Z (func clock_state bool)))) (ps:(func a (func Z (func clock_state
  (func clock_state bool))))) (x:a) (p:Z) (q:(func clock_state bool))
  (ms:clock_state), ((infix_at (infix_at (infix_at (infix_at (towp_wp pr ps)
  x) p) q) ms) = true) <-> (((infix_at (infix_at (infix_at pr x) p)
  ms) = true) /\ forall (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at ps x) p) ms) ms') = true) ->
  ((infix_at q ms') = true)).

Axiom towp_wp_lemma : forall {a:Type} {a_WT:WhyType a}, forall (pr:(func a
  (func Z (func clock_state bool)))) (ps:(func a (func Z (func clock_state
  (func clock_state bool))))) (x:a) (p:Z) (q:(func clock_state bool))
  (ms:clock_state), ((infix_at (infix_at (infix_at (infix_at (towp_wp pr ps)
  x) p) q) ms) = true) <-> (((infix_at (infix_at (infix_at pr x) p)
  ms) = true) /\ forall (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at ps x) p) ms) ms') = true) ->
  ((infix_at q ms') = true)).

Parameter trivial_pre: forall {a:Type} {a_WT:WhyType a}, (func a (func Z
  (func clock_state bool))).

Axiom trivial_pre_def : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (p:Z)
  (ms:clock_state), ((infix_at (infix_at (infix_at (trivial_pre : (func a
  (func Z (func clock_state bool)))) x) p) ms) = true) <->
  match ms with
  | (VMC p' _ _ _) => (p = p')
  end.

Parameter loop_preservation: forall {a:Type} {a_WT:WhyType a}, (func a (func
  Z (func clock_state bool))) -> (func a (func Z (func clock_state bool))) ->
  (func a (func Z (func clock_state (func clock_state bool)))).

Axiom loop_preservation_def : forall {a:Type} {a_WT:WhyType a},
  forall (inv:(func a (func Z (func clock_state bool)))) (post2:(func a (func
  Z (func clock_state bool)))) (x:a) (p:Z) (ms:clock_state)
  (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (loop_preservation inv post2) x)
  p) ms) ms') = true) <-> ((((infix_at (infix_at (infix_at inv x) p)
  ms') = true) /\ ~ (ms = ms')) \/ ((infix_at (infix_at (infix_at post2 x) p)
  ms') = true)).

Parameter forget_old: forall {a:Type} {a_WT:WhyType a}, (func a (func Z (func
  clock_state bool))) -> (func a (func Z (func clock_state (func clock_state
  bool)))).

Axiom forget_old_def : forall {a:Type} {a_WT:WhyType a}, forall (post2:(func
  a (func Z (func clock_state bool)))) (x:a) (p:Z) (ms:clock_state),
  ((infix_at (infix_at (infix_at (forget_old post2) x) p)
  ms) = (infix_at (infix_at post2 x) p)).

Parameter ifun_post: forall {a:Type} {a_WT:WhyType a}, (func machine_state
  machine_state) -> (func a (func Z (func clock_state (func clock_state
  bool)))).

Axiom ifun_post_def : forall {a:Type} {a_WT:WhyType a}, forall (f:(func
  machine_state machine_state)) (x:a) (p:Z) (mc:clock_state)
  (mc':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (ifun_post f: (func a (func Z
  (func clock_state (func clock_state bool))))) x) p) mc) mc') = true) <->
  match mc with
  | (VMC p1 s m c) =>
      match mc' with
      | (VMC p' s' m' c') => ((VMS p' s' m') = (infix_at f (VMS p1 s m))) /\
          (c' = (c + 1%Z)%Z)
      end
  end.

Parameter iconst_post: forall {a:Type} {a_WT:WhyType a}, Z -> (func a (func Z
  (func clock_state (func clock_state bool)))).

Axiom iconst_post_def : forall {a:Type} {a_WT:WhyType a}, forall (n:Z) (x:a)
  (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (iconst_post n: (func a (func Z
  (func clock_state (func clock_state bool))))) x) p) ms) ms') = true) <->
  forall (s:(list Z)) (m:(map id Z)) (clock:Z), (ms = (VMC p s m clock)) ->
  (ms' = (VMC (p + 1%Z)%Z (Init.Datatypes.cons n s) m (clock + 1%Z)%Z)).

Parameter iconst_fun: Z -> (func machine_state machine_state).

Axiom iconst_fun_def : forall (n:Z) (ms:machine_state),
  ((infix_at (iconst_fun n)
  ms) = match ms with
  | (VMS p s m) => (VMS (p + 1%Z)%Z (Init.Datatypes.cons n s) m)
  end).

Parameter ivar_post: forall {a:Type} {a_WT:WhyType a}, id -> (func a (func Z
  (func clock_state (func clock_state bool)))).

Axiom ivar_post_def : forall {a:Type} {a_WT:WhyType a}, forall (x:id) (a1:a)
  (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (ivar_post x: (func a (func Z
  (func clock_state (func clock_state bool))))) a1) p) ms) ms') = true) <->
  forall (s:(list Z)) (m:(map id Z)) (clock:Z), (ms = (VMC p s m clock)) ->
  (ms' = (VMC (p + 1%Z)%Z (Init.Datatypes.cons (get m x) s) m
  (clock + 1%Z)%Z)).

Parameter ivar_fun: id -> (func machine_state machine_state).

Axiom ivar_fun_def : forall (x:id) (ms:machine_state),
  ((infix_at (ivar_fun x)
  ms) = match ms with
  | (VMS p s m) => (VMS (p + 1%Z)%Z (Init.Datatypes.cons (get m x) s) m)
  end).

(* Why3 assumption *)
Definition binop := (func Z (func Z Z)).

Parameter ibinop_pre: forall {a:Type} {a_WT:WhyType a}, (func a (func Z (func
  clock_state bool))).

Axiom ibinop_pre_def : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (p:Z)
  (ms:clock_state), ((infix_at (infix_at (infix_at (ibinop_pre : (func a
  (func Z (func clock_state bool)))) x) p) ms) = true) <-> exists n1:Z,
  exists n2:Z, exists s:(list Z), exists m:(map id Z), exists clock:Z,
  (ms = (VMC p (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m clock)).

Parameter ibinop_post: forall {a:Type} {a_WT:WhyType a}, (func Z (func Z
  Z)) -> (func a (func Z (func clock_state (func clock_state bool)))).

Axiom ibinop_post_def : forall {a:Type} {a_WT:WhyType a}, forall (op:(func Z
  (func Z Z))) (x:a) (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (ibinop_post op: (func a (func Z
  (func clock_state (func clock_state bool))))) x) p) ms) ms') = true) <->
  forall (n1:Z) (n2:Z) (s:(list Z)) (m:(map id Z)) (clk:Z), (ms = (VMC p
  (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m clk)) ->
  (ms' = (VMC (p + 1%Z)%Z (Init.Datatypes.cons (infix_at (infix_at op n1)
  n2) s) m (clk + 1%Z)%Z)).

Parameter ibinop_fun: (func Z (func Z Z)) -> (func machine_state
  machine_state).

Axiom ibinop_fun_def : forall (op:(func Z (func Z Z))) (ms:machine_state),
  ((infix_at (ibinop_fun op)
  ms) = match ms with
  | (VMS p (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) =>
      (VMS (p + 1%Z)%Z (Init.Datatypes.cons (infix_at (infix_at op n1) n2) s)
      m)
  | _ => ms
  end).

Parameter plus: (func Z (func Z Z)).

Axiom plus_def : forall (x:Z) (y:Z), ((infix_at (infix_at plus x)
  y) = (x + y)%Z).

Parameter sub: (func Z (func Z Z)).

Axiom sub_def : forall (x:Z) (y:Z), ((infix_at (infix_at sub x)
  y) = (x - y)%Z).

Parameter mul: (func Z (func Z Z)).

Axiom mul_def : forall (x:Z) (y:Z), ((infix_at (infix_at mul x)
  y) = (x * y)%Z).

Parameter inil_post: forall {a:Type} {a_WT:WhyType a}, (func a (func Z (func
  clock_state (func clock_state bool)))).

Axiom inil_post_def : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (p:Z)
  (mc:clock_state) (mc':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (inil_post : (func a (func Z (func
  clock_state (func clock_state bool))))) x) p) mc) mc') = true) <->
  (mc = mc').

Parameter ibranch_post: forall {a:Type} {a_WT:WhyType a}, Z -> (func a (func
  Z (func clock_state (func clock_state bool)))).

Axiom ibranch_post_def : forall {a:Type} {a_WT:WhyType a}, forall (ofs:Z)
  (x:a) (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (ibranch_post ofs: (func a (func Z
  (func clock_state (func clock_state bool))))) x) p) ms) ms') = true) <->
  forall (s:(list Z)) (m:(map id Z)) (clk:Z), (ms = (VMC p s m clk)) ->
  (ms' = (VMC ((p + 1%Z)%Z + ofs)%Z s m (clk + 1%Z)%Z)).

Parameter ibranch_fun: Z -> (func machine_state machine_state).

Axiom ibranch_fun_def : forall (ofs:Z) (ms:machine_state),
  ((infix_at (ibranch_fun ofs)
  ms) = match ms with
  | (VMS p s m) => (VMS ((p + 1%Z)%Z + ofs)%Z s m)
  end).

(* Why3 assumption *)
Definition cond := (func Z (func Z bool)).

Parameter icjump_post: forall {a:Type} {a_WT:WhyType a}, (func Z (func Z
  bool)) -> Z -> (func a (func Z (func clock_state (func clock_state
  bool)))).

Axiom icjump_post_def : forall {a:Type} {a_WT:WhyType a}, forall (cond1:(func
  Z (func Z bool))) (ofs:Z) (x:a) (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (icjump_post cond1 ofs: (func a
  (func Z (func clock_state (func clock_state bool))))) x) p) ms)
  ms') = true) <-> forall (n1:Z) (n2:Z) (s:(list Z)) (m:(map id Z)) (c:Z),
  (ms = (VMC p (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m c)) ->
  ((((infix_at (infix_at cond1 n1) n2) = true) ->
  (ms' = (VMC ((p + ofs)%Z + 1%Z)%Z s m (c + 1%Z)%Z))) /\
  ((~ ((infix_at (infix_at cond1 n1) n2) = true)) -> (ms' = (VMC (p + 1%Z)%Z
  s m (c + 1%Z)%Z)))).

Parameter icjump_fun: (func Z (func Z bool)) -> Z -> (func machine_state
  machine_state).

Axiom icjump_fun_def : forall (cond1:(func Z (func Z bool))) (ofs:Z)
  (ms:machine_state),
  match ms with
  | (VMS p (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) =>
      (((infix_at (infix_at cond1 n1) n2) = true) ->
      ((infix_at (icjump_fun cond1 ofs) ms) = (VMS ((p + ofs)%Z + 1%Z)%Z s
      m))) /\ ((~ ((infix_at (infix_at cond1 n1) n2) = true)) ->
      ((infix_at (icjump_fun cond1 ofs) ms) = (VMS (p + 1%Z)%Z s m)))
  | _ => ((infix_at (icjump_fun cond1 ofs) ms) = ms)
  end.

Parameter beq: (func Z (func Z bool)).

Axiom beq_def : forall (x:Z) (y:Z), ((infix_at (infix_at beq x)
  y) = true) <-> (x = y).

Parameter bne: (func Z (func Z bool)).

Axiom bne_def : forall (x:Z) (y:Z), ((infix_at (infix_at bne x)
  y) = true) <-> ~ (x = y).

Parameter ble: (func Z (func Z bool)).

Axiom ble_def : forall (x:Z) (y:Z), ((infix_at (infix_at ble x)
  y) = true) <-> (x <= y)%Z.

Parameter bgt: (func Z (func Z bool)).

Axiom bgt_def : forall (x:Z) (y:Z), ((infix_at (infix_at bgt x)
  y) = true) <-> (y < x)%Z.

Parameter isetvar_pre: forall {a:Type} {a_WT:WhyType a}, (func a (func Z
  (func clock_state bool))).

Axiom isetvar_pre_def : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (p:Z)
  (mc:clock_state), ((infix_at (infix_at (infix_at (isetvar_pre : (func a
  (func Z (func clock_state bool)))) x) p) mc) = true) <-> exists n:Z,
  exists s:(list Z), exists m:(map id Z), exists c:Z, (mc = (VMC p
  (Init.Datatypes.cons n s) m c)).

Parameter isetvar_post: forall {a:Type} {a_WT:WhyType a}, id -> (func a (func
  Z (func clock_state (func clock_state bool)))).

Axiom isetvar_post_def : forall {a:Type} {a_WT:WhyType a}, forall (x:id)
  (a1:a) (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (isetvar_post x: (func a (func Z
  (func clock_state (func clock_state bool))))) a1) p) ms) ms') = true) <->
  forall (s:(list Z)) (n:Z) (m:(map id Z)) (c:Z), (ms = (VMC p
  (Init.Datatypes.cons n s) m c)) -> (ms' = (VMC (p + 1%Z)%Z s (set m x n)
  (c + 1%Z)%Z)).

Parameter isetvar_fun: id -> (func machine_state machine_state).

Axiom isetvar_fun_def : forall (x:id) (ms:machine_state),
  ((infix_at (isetvar_fun x)
  ms) = match ms with
  | (VMS p (Init.Datatypes.cons n s) m) => (VMS (p + 1%Z)%Z s (set m x n))
  | _ => ms
  end).

Parameter aexpr_post: forall {a:Type} {a_WT:WhyType a}, aexpr -> Z -> (func a
  (func Z (func clock_state (func clock_state bool)))).

Axiom aexpr_post_def : forall {a:Type} {a_WT:WhyType a}, forall (a1:aexpr)
  (len:Z) (x:a) (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (aexpr_post a1 len: (func a (func
  Z (func clock_state (func clock_state bool))))) x) p) ms) ms') = true) <->
  match ms with
  | (VMC _ s m c) =>
      match ms' with
      | (VMC p' s' m' c') => (p' = (p + len)%Z) /\
          ((s' = (Init.Datatypes.cons (aeval m a1) s)) /\ ((m' = m) /\
          (c <= c')%Z))
      end
  end.

Parameter bexpr_post: forall {a:Type} {a_WT:WhyType a}, bexpr -> bool -> Z ->
  Z -> (func a (func Z (func clock_state (func clock_state bool)))).

Axiom bexpr_post_def : forall {a:Type} {a_WT:WhyType a}, forall (b:bexpr)
  (cond1:bool) (out_t:Z) (out_f:Z) (x:a) (p:Z) (ms:clock_state)
  (ms':clock_state), (((infix_at (infix_at (infix_at (infix_at (bexpr_post b
  cond1 out_t out_f: (func a (func Z (func clock_state (func clock_state
  bool))))) x) p) ms) ms') = true) ->
  match ms with
  | (VMC _ s m c) =>
      match ms' with
      | (VMC p' s' m' c') => (s' = s) /\ ((m' = m) /\ ((c <= c')%Z /\
          ((((beval m b) = cond1) -> (p' = (p + out_t)%Z)) /\ ((~ ((beval m
          b) = cond1)) -> (p' = (p + out_f)%Z)))))
      end
  end) /\
  (match ms with
  | (VMC _ s m c) =>
      match ms' with
      | (VMC p' s' m' c') => (s' = s) /\ ((m' = m) /\ ((c <= c')%Z /\
          ((((beval m b) = cond1) /\ (p' = (p + out_t)%Z)) \/ ((~ ((beval m
          b) = cond1)) /\ (p' = (p + out_f)%Z)))))
      end
  end -> ((infix_at (infix_at (infix_at (infix_at (bexpr_post b cond1 out_t
  out_f: (func a (func Z (func clock_state (func clock_state bool))))) x) p)
  ms) ms') = true)).

Parameter exec_cond: forall {a:Type} {a_WT:WhyType a}, bexpr -> bool -> (func
  a (func Z (func clock_state bool))).

Axiom exec_cond_def : forall {a:Type} {a_WT:WhyType a}, forall (b1:bexpr)
  (cond1:bool) (x:a) (p:Z) (ms:clock_state),
  ((infix_at (infix_at (infix_at (exec_cond b1 cond1: (func a (func Z (func
  clock_state bool)))) x) p) ms) = true) <->
  match ms with
  | (VMC _ _ m _) => ((beval m b1) = cond1)
  end.

Parameter com_post: forall {a:Type} {a_WT:WhyType a}, com -> Z -> (func a
  (func Z (func clock_state (func clock_state bool)))).

Axiom com_post_def : forall {a:Type} {a_WT:WhyType a}, forall (cmd:com)
  (len:Z) (x:a) (p:Z) (ms:clock_state) (ms':clock_state),
  ((infix_at (infix_at (infix_at (infix_at (com_post cmd len: (func a (func Z
  (func clock_state (func clock_state bool))))) x) p) ms) ms') = true) <->
  match ms with
  | (VMC _ s m c) =>
      match ms' with
      | (VMC p' s' m' c') => (p' = (p + len)%Z) /\ ((s' = s) /\ ((ceval m cmd
          m') /\ (c <= c')%Z))
      end
  end.

Parameter exec_cond_old: forall {a:Type} {a_WT:WhyType a}, bexpr -> bool ->
  (func (a* clock_state)%type (func Z (func clock_state bool))).

Axiom exec_cond_old_def : forall {a:Type} {a_WT:WhyType a}, forall (b1:bexpr)
  (cond1:bool) (x:(a* clock_state)%type) (p:Z) (ms:clock_state),
  ((infix_at (infix_at (infix_at (exec_cond_old b1 cond1: (func (a*
  clock_state)%type (func Z (func clock_state bool)))) x) p) ms) = true) <->
  match (snd x) with
  | (VMC _ _ m _) => ((beval m b1) = cond1)
  end.

Parameter loop_invariant: forall {a:Type} {a_WT:WhyType a}, com -> (func (a*
  clock_state)%type (func Z (func clock_state bool))).

Axiom loop_invariant_def : forall {a:Type} {a_WT:WhyType a}, forall (c:com)
  (x:(a* clock_state)%type) (p:Z) (msi:clock_state),
  ((infix_at (infix_at (infix_at (loop_invariant c: (func (a*
  clock_state)%type (func Z (func clock_state bool)))) x) p) msi) = true) <->
  match (snd x) with
  | (VMC _ s0 m0 c0) =>
      match msi with
      | (VMC pi si mi ci) => (pi = p) /\ ((s0 = si) /\ ((c0 <= ci)%Z /\
          forall (mf:(map id Z)), (ceval mi c mf) -> (ceval m0 c mf)))
      end
  end.

Parameter loop_post: forall {a:Type} {a_WT:WhyType a}, com -> Z -> (func (a*
  clock_state)%type (func Z (func clock_state bool))).

Axiom loop_post_def : forall {a:Type} {a_WT:WhyType a}, forall (c:com)
  (len:Z) (x:(a* clock_state)%type) (p:Z) (msf:clock_state),
  ((infix_at (infix_at (infix_at (loop_post c len: (func (a*
  clock_state)%type (func Z (func clock_state bool)))) x) p) msf) = true) <->
  match (snd x) with
  | (VMC _ s0 m0 c0) =>
      match msf with
      | (VMC pf sf mf cf) => (pf = (p + len)%Z) /\ ((s0 = sf) /\
          ((c0 <= cf)%Z /\ (ceval m0 c mf)))
      end
  end.

(* Why3 goal *)
Theorem WP_parameter_compile_program : forall (prog:com),
  forall (res:(list instr)) (res1:(func unit (func Z (func clock_state
  bool)))) (res2:(func unit (func Z (func clock_state (func clock_state
  bool))))), (((res1 = (trivial_pre : (func unit (func Z (func clock_state
  bool))))) /\ (hl_correctness (mk_hl res res1 res2))) /\
  (res2 = (com_post prog (list.Length.length res): (func unit (func Z (func
  clock_state (func clock_state bool))))))) -> forall (mi:(map id Z)),
  forall (p:(list instr)) (x:machine_state) (y:machine_state)
  (z:machine_state), (transition p x y) -> (((transition_star p y z) /\
  forall (res':(list instr)) (pf:Z) (sf:(list Z)) (mf:(map id Z)) (p':Z)
  (s':(list Z)) (m':(map id Z)), ((VMS pf sf mf) = z) -> (((VMS p' s'
  m') = y) -> ((res' = p) ->
  ((res' = (Init.Datatypes.app res (Init.Datatypes.cons Ihalt Init.Datatypes.nil))) ->
  ((codeseq_at res' 0%Z res) -> ((forall (ms':machine_state), ~ (transition
  res' (VMS pf sf mf) ms')) -> forall (c':Z), let init := (VMC 0%Z
  Init.Datatypes.nil mi 0%Z) in
  (((infix_at (infix_at (infix_at (trivial_pre : (func unit (func Z (func
  clock_state bool)))) tt) 0%Z) init) = true) -> ((transition_star1 (res',
  (infix_at (infix_at (infix_at (com_post prog
  (list.Length.length res): (func unit (func Z (func clock_state (func
  clock_state bool))))) tt) 0%Z) init)) init (VMC p' s' m' c')) ->
  ((sf = Init.Datatypes.nil) /\ ((pf = (list.Length.length res)) /\ (ceval mi
  prog mf))))))))))) -> forall (res':(list instr)) (pf:Z) (sf:(list Z))
  (mf:(map id Z)) (p':Z) (s':(list Z)) (m':(map id Z)), ((VMS pf sf
  mf) = z) -> (((VMS p' s' m') = x) -> ((res' = p) ->
  ((res' = (Init.Datatypes.app res (Init.Datatypes.cons Ihalt Init.Datatypes.nil))) ->
  ((codeseq_at res' 0%Z res) -> ((forall (ms':machine_state), ~ (transition
  res' (VMS pf sf mf) ms')) -> forall (c':Z), let init := (VMC 0%Z
  Init.Datatypes.nil mi 0%Z) in
  (((infix_at (infix_at (infix_at (trivial_pre : (func unit (func Z (func
  clock_state bool)))) tt) 0%Z) init) = true) -> ((transition_star1 (res',
  (infix_at (infix_at (infix_at (com_post prog
  (list.Length.length res): (func unit (func Z (func clock_state (func
  clock_state bool))))) tt) 0%Z) init)) init (VMC p' s' m' c')) ->
  ((sf = Init.Datatypes.nil) /\ ((pf = (list.Length.length res)) /\ (ceval mi
  prog mf))))))))))).
(* Why3 intros prog res res1 res2 ((h1,h2),h3) mi p x y z h4 (h5,h6) res' pf
        sf mf p' s' m' h7 h8 h9 h10 h11 h12 c' init h13 h14. *)
intros prog res res1 res2 ((h1,h2),h3) mi p x y z h4 (h5,h6) res' pf
        sf mf p' s' m' h7 h8 h9 h10 h11 h12 c' init h13 h14.
Require Import Why3.
Ltac cvc := why3 "CVC4,1.4,".
pose (post := infix_at (infix_at (infix_at (com_post prog (Length.length res)) tt) 0%Z) init).
assert (infix_at post (VMC p' s' m' c') <> true) by why3 "CVC4,1.4,".
destruct y.
assert (H0:infix_at post (VMC z0 l m (c'+1)) = true \/
        infix_at post (VMC z0 l m (c'+1)) <> true) by cvc.
destruct H0.
assert (codeseq_at res' z0 (Ihalt :: nil)) by why3 "Z3,4.3.1,".
cvc.
assert (transition_out (res',post) (VMC p' s' m' c') (VMC z0 l m (c'+1))).
unfold transition_out;cvc.
eapply h6 with (c' := (c' + 1)%Z);trivial. cvc. cvc. cvc. subst.
why3 "CVC3,2.4.1,".
Qed.

