/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apiextensionsv1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
)

// CustomResourceConversionApplyConfiguration represents a declarative configuration of the CustomResourceConversion type for use
// with apply.
//
// CustomResourceConversion describes how to convert different versions of a CR.
type CustomResourceConversionApplyConfiguration struct {
	// strategy specifies how custom resources are converted between versions. Allowed values are:
	// - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource.
	// - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
	// is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
	Strategy *apiextensionsv1.ConversionStrategyType `json:"strategy,omitempty"`
	// webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
	Webhook *WebhookConversionApplyConfiguration `json:"webhook,omitempty"`
}

// CustomResourceConversionApplyConfiguration constructs a declarative configuration of the CustomResourceConversion type for use with
// apply.
func CustomResourceConversion() *CustomResourceConversionApplyConfiguration {
	return &CustomResourceConversionApplyConfiguration{}
}

// WithStrategy sets the Strategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Strategy field is set to the value of the last call.
func (b *CustomResourceConversionApplyConfiguration) WithStrategy(value apiextensionsv1.ConversionStrategyType) *CustomResourceConversionApplyConfiguration {
	b.Strategy = &value
	return b
}

// WithWebhook sets the Webhook field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Webhook field is set to the value of the last call.
func (b *CustomResourceConversionApplyConfiguration) WithWebhook(value *WebhookConversionApplyConfiguration) *CustomResourceConversionApplyConfiguration {
	b.Webhook = value
	return b
}
