/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.util.JoinedIterator;
import org.apache.commons.beanutils.BasicDynaClass;

public class Component
extends Value {
    private ArrayList properties = new ArrayList();
    private Class componentClass;
    private BasicDynaClass dynaClass;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;

    public int getPropertySpan() {
        return this.properties.size();
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public void addProperty(Property p) {
        this.properties.add(p);
    }

    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    public int getColumnSpan() {
        int n = 0;
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            n += p.getColumnSpan();
        }
        return n;
    }

    public Iterator getColumnIterator() {
        Iterator[] iters = new Iterator[this.getPropertySpan()];
        Iterator iter = this.getPropertyIterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = ((Property)iter.next()).getColumnIterator();
        }
        return new JoinedIterator(iters);
    }

    public Component(PersistentClass owner) throws MappingException {
        super(owner.getTable());
        this.owner = owner;
    }

    public Component(Table table) throws MappingException {
        super(table);
        this.owner = null;
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isComposite() {
        return true;
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public BasicDynaClass getDynaClass() {
        return this.dynaClass;
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public ArrayList getProperties() {
        return this.properties;
    }

    public void setComponentClass(Class componentClass) {
        this.componentClass = componentClass;
    }

    public void setDynaClass(BasicDynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setOwner(PersistentClass owner) {
        this.owner = owner;
    }

    public void setParentProperty(String parentProperty) {
        this.parentProperty = parentProperty;
    }
}

