/*
 * ------------------------------------
 * NS9750 specific USB definition 
 * ------------------------------------
 */
#include <bus.h>

#define NS9750_USB_BASE		(0x90100000)
#define NS9750_USB_GCTRL	(0x90100000) 
#define         NS9750_USB_GCTRL_HSTDEV                (1)
#define         NS9750_USB_GCTRL_WKUP                   (4)
#define         NS9750_USB_GCTRL_SUSP                   (32)
#define         NS9750_USB_GCTRL_DRST_MASK              (0x600)
#define         NS9750_USB_GCTRL_DRST_SHIFT             (9)
#define         NS9750_USB_GCTRL_DRST_ENA               (0)
#define         NS9750_USB_GCTRL_DRST_RST               (0x200)
#define         NS9750_USB_GCTRL_HRST                   (0x800)
#define         NS9750_USB_GCTRL_DISA                   (0x1000)

#define NS9750_USB_DCTRL	(0x90100004)
#define NS9750_USB_GIEN		(0x9010000C)
#define         NS9750_USB_GIEN_OHCI    (1<<1)
#define         NS9750_USB_GIEN_WAKEUP  (1<<6)
#define         NS9750_USB_GIEN_SETCFG  (1<<7)
#define         NS9750_USB_GIEN_SETINTF (1<<8)
#define         NS9750_USB_GIEN_SSPND   (1<<9)
#define         NS9750_USB_GIEN_SOF     (1<<10)
#define         NS9750_USB_GIEN_URST    (1<<11)
#define         NS9750_USB_GIEN_FIFO    (1<<12)
#define         NS9750_USB_GIEN_DMA1    (1<<14)
#define         NS9750_USB_GIEN_DMA2    (1<<15)
#define         NS9750_USB_GIEN_DMA3    (1<<16)
#define         NS9750_USB_GIEN_DMA4    (1<<17)
#define         NS9750_USB_GIEN_DMA5    (1<<18)
#define         NS9750_USB_GIEN_DMA6    (1<<19)
#define         NS9750_USB_GIEN_DMA7    (1<<20)
#define         NS9750_USB_GIEN_DMA8    (1<<21)
#define         NS9750_USB_GIEN_DMA9    (1<<22)
#define         NS9750_USB_GIEN_DMA10   (1<<23)

#define         NS9750_USB_GIEN_DMA11   (1<<24)
#define         NS9750_USB_GIEN_DMA12   (1<<25)
#define         NS9750_USB_GIEN_DMA13   (1<<26)
#define         NS9750_USB_GIEN_GBL_DMA (1<<27)
#define         NS9750_USB_GIEN_GBL_EN  (1<<31)
/* Relative BBus Sub-Interrupt Numbers */
#define         NS9750_USB_IRQ_OHCI    (1)
#define         NS9750_USB_IRQ_WAKEUP  (6)
#define         NS9750_USB_IRQ_SETCFG  (7)
#define         NS9750_USB_IRQ_SETINTF (8)
#define         NS9750_USB_IRQ_SSPND   (9)
#define         NS9750_USB_IRQ_SOF     (10)
#define         NS9750_USB_IRQ_URST    (11)
#define         NS9750_USB_IRQ_FIFO    (12)
#define         NS9750_USB_IRQ_DMA1    (14)
#define         NS9750_USB_IRQ_DMA2    (15)
#define         NS9750_USB_IRQ_DMA3    (16)
#define         NS9750_USB_IRQ_DMA4    (17)
#define         NS9750_USB_IRQ_DMA5    (18)
#define         NS9750_USB_IRQ_DMA6    (19)
#define         NS9750_USB_IRQ_DMA7    (20)
#define         NS9750_USB_IRQ_DMA8    (21)
#define         NS9750_USB_IRQ_DMA9    (22)
#define         NS9750_USB_IRQ_DMA10   (23)
#define         NS9750_USB_IRQ_DMA11   (24)
#define         NS9750_USB_IRQ_DMA12   (25)
#define         NS9750_USB_IRQ_DMA13   (26)
#define         NS9750_USB_IRQ_GBL_DMA (27)
#define         NS9750_USB_IRQ_GBL_EN  (31)

#define NS9750_USB_GIST         (0x90100010)
#define         NS9750_USB_GIST_OHCI    (1<<1)
#define         NS9750_USB_GIST_WAKEUP  (1<<6)
#define         NS9750_USB_GIST_SETCFG  (1<<7)
#define         NS9750_USB_GIST_SETINTF (1<<8)
#define         NS9750_USB_GIST_SSPND   (1<<9)
#define         NS9750_USB_GIST_SOF     (1<<10)
#define         NS9750_USB_GIST_URST    (1<<11)
#define         NS9750_USB_GIST_FIFO    (1<<12)
#define         NS9750_USB_GIST_DMA1    (1<<14)
#define         NS9750_USB_GIST_DMA2    (1<<15)
#define         NS9750_USB_GIST_DMA3    (1<<16)
#define         NS9750_USB_GIST_DMA4    (1<<17)
#define         NS9750_USB_GIST_DMA5    (1<<18)
#define         NS9750_USB_GIST_DMA6    (1<<19)
#define         NS9750_USB_GIST_DMA7    (1<<20)
#define         NS9750_USB_GIST_DMA8    (1<<21)
#define         NS9750_USB_GIST_DMA9    (1<<22)
#define         NS9750_USB_GIST_DMA10   (1<<23)
#define         NS9750_USB_GIST_DMA11   (1<<24)
#define         NS9750_USB_GIST_DMA12   (1<<25)
#define         NS9750_USB_GIST_DMA13   (1<<26)
#define         NS9750_USB_GIST_GBL_DMA (1<<27)

#define NS9750_USB_DEV_IPR	(0x90100014)

#define NS9750_OHCI_BASE (0x90101000)

BusDevice * NS9750Usb_New(const char *name);
