//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberdatasource?language=objc)
    pub unsafe trait NSScrubberDataSource: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(numberOfItemsForScrubber:))]
        #[unsafe(method_family = none)]
        unsafe fn numberOfItemsForScrubber(&self, scrubber: &NSScrubber) -> NSInteger;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSScrubberItemView",
            feature = "NSView"
        ))]
        #[unsafe(method(scrubber:viewForItemAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn scrubber_viewForItemAtIndex(
            &self,
            scrubber: &NSScrubber,
            index: NSInteger,
        ) -> Retained<NSScrubberItemView>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberdelegate?language=objc)
    pub unsafe trait NSScrubberDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(scrubber:didSelectItemAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn scrubber_didSelectItemAtIndex(
            &self,
            scrubber: &NSScrubber,
            selected_index: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(scrubber:didHighlightItemAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn scrubber_didHighlightItemAtIndex(
            &self,
            scrubber: &NSScrubber,
            highlighted_index: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(scrubber:didChangeVisibleRange:))]
        #[unsafe(method_family = none)]
        unsafe fn scrubber_didChangeVisibleRange(
            &self,
            scrubber: &NSScrubber,
            visible_range: NSRange,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(didBeginInteractingWithScrubber:))]
        #[unsafe(method_family = none)]
        unsafe fn didBeginInteractingWithScrubber(&self, scrubber: &NSScrubber);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(didFinishInteractingWithScrubber:))]
        #[unsafe(method_family = none)]
        unsafe fn didFinishInteractingWithScrubber(&self, scrubber: &NSScrubber);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(didCancelInteractingWithScrubber:))]
        #[unsafe(method_family = none)]
        unsafe fn didCancelInteractingWithScrubber(&self, scrubber: &NSScrubber);
    }
);

/// Determines the interaction mode for a NSScrubber control.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubbermode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSScrubberMode(pub NSInteger);
impl NSScrubberMode {
    #[doc(alias = "NSScrubberModeFixed")]
    pub const Fixed: Self = Self(0);
    #[doc(alias = "NSScrubberModeFree")]
    pub const Free: Self = Self(1);
}

unsafe impl Encode for NSScrubberMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSScrubberMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSScrubberAlignment specifies the preferred alignment of elements within the control.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberalignment?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSScrubberAlignment(pub NSInteger);
impl NSScrubberAlignment {
    #[doc(alias = "NSScrubberAlignmentNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSScrubberAlignmentLeading")]
    pub const Leading: Self = Self(1);
    #[doc(alias = "NSScrubberAlignmentTrailing")]
    pub const Trailing: Self = Self(2);
    #[doc(alias = "NSScrubberAlignmentCenter")]
    pub const Center: Self = Self(3);
}

unsafe impl Encode for NSScrubberAlignment {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSScrubberAlignment {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// `NSScrubberSelectionStyle`is an abstract class that provides decorative accessory views for selected and highlighted items within a NSScrubber control. Class properties provide convenient access to built-in styles. For a completely custom style, subclassers can override
    /// `-makeSelectionView`to create and configure arbitrary
    /// `NSScrubberSelectionView`subclasses.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberselectionstyle?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSScrubberSelectionStyle;
);

extern_conformance!(
    unsafe impl NSCoding for NSScrubberSelectionStyle {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSScrubberSelectionStyle {}
);

impl NSScrubberSelectionStyle {
    extern_methods!(
        #[unsafe(method(outlineOverlayStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn outlineOverlayStyle(
            mtm: MainThreadMarker,
        ) -> Retained<NSScrubberSelectionStyle>;

        #[unsafe(method(roundedBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn roundedBackgroundStyle(
            mtm: MainThreadMarker,
        ) -> Retained<NSScrubberSelectionStyle>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSScrubberItemView",
            feature = "NSView"
        ))]
        #[unsafe(method(makeSelectionView))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeSelectionView(&self) -> Option<Retained<NSScrubberSelectionView>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSScrubberSelectionStyle {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// `NSScrubber`is a control designed for the NSTouchBar environment.
    ///
    /// `NSScrubber`arranges a finite number of "items" (represented by views of type
    /// `NSScrubberItemView`) according to a layout object (see
    /// `NSScrubberLayout`), and provides several methods for navigating and selecting those items.
    ///
    /// Clients provide data to
    /// `NSScrubber`via a data source object (see the
    /// `NSScrubberDataSource`protocol) and react to user interaction via a delegate object (see the
    /// `NSScrubberDelegate`protocol).
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubber?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSScrubber;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSScrubber {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSScrubber {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSScrubber {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSScrubber {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSScrubber {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSScrubber {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSScrubber {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSScrubber {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSScrubber {
    extern_methods!(
        #[unsafe(method(dataSource))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSScrubberDataSource>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`dataSource`][Self::dataSource].
        #[unsafe(method(setDataSource:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDataSource(
            &self,
            data_source: Option<&ProtocolObject<dyn NSScrubberDataSource>>,
        );

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSScrubberDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSScrubberDelegate>>);

        #[cfg(feature = "NSScrubberLayout")]
        #[unsafe(method(scrubberLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrubberLayout(&self) -> Retained<NSScrubberLayout>;

        #[cfg(feature = "NSScrubberLayout")]
        /// Setter for [`scrubberLayout`][Self::scrubberLayout].
        #[unsafe(method(setScrubberLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScrubberLayout(&self, scrubber_layout: &NSScrubberLayout);

        /// Returns the number of items represented by the scrubber control.
        #[unsafe(method(numberOfItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfItems(&self) -> NSInteger;

        /// The index of the currently highlighted item within the control. If there is no highlighted item, the value of this property is (-1).
        #[unsafe(method(highlightedIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlightedIndex(&self) -> NSInteger;

        /// The index of the selected item within the control. If there is no selected item, the value of this property is (-1). Setting this property through the animator proxy will animate the selection change. Programmatic selection changes do not trigger delegate callbacks.
        #[unsafe(method(selectedIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedIndex(&self) -> NSInteger;

        /// Setter for [`selectedIndex`][Self::selectedIndex].
        #[unsafe(method(setSelectedIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedIndex(&self, selected_index: NSInteger);

        /// Describes the interaction mode for the scrubber control. See the
        /// `NSScrubberMode`enumeration for a list of possible values. The default value is
        /// `NSScrubberModeFixed.`
        #[unsafe(method(mode))]
        #[unsafe(method_family = none)]
        pub unsafe fn mode(&self) -> NSScrubberMode;

        /// Setter for [`mode`][Self::mode].
        #[unsafe(method(setMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMode(&self, mode: NSScrubberMode);

        /// If the value of
        /// `itemAlignment`is not
        /// `NSScrubberAlignmentNone,`the scrubber will ensure that some item rests at the preferred alignment within the control following a scrolling or paging interaction. The default value is
        /// `NSScrubberAlignmentNone.`
        #[unsafe(method(itemAlignment))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemAlignment(&self) -> NSScrubberAlignment;

        /// Setter for [`itemAlignment`][Self::itemAlignment].
        #[unsafe(method(setItemAlignment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemAlignment(&self, item_alignment: NSScrubberAlignment);

        /// When
        /// `continuous`is
        /// `YES,`panning over the control in
        /// `NSScrubberModeFixed`will immediately select the item under the user's finger, and scrolling in
        /// `NSScrubberModeFree`will continuously select items as they pass through the current
        /// `itemAlignment.`The default is
        /// `NO.`
        #[unsafe(method(isContinuous))]
        #[unsafe(method_family = none)]
        pub unsafe fn isContinuous(&self) -> bool;

        /// Setter for [`isContinuous`][Self::isContinuous].
        #[unsafe(method(setContinuous:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContinuous(&self, continuous: bool);

        /// When
        /// `floatsSelectionViews`is
        /// `YES,`the selection decorations provided by
        /// `selectionBackgroundStyle`and
        /// `selectionOverlayStyle`will smoothly float between selected items, rather than animating their entrance/exit in-place. The default is
        /// `NO.`
        #[unsafe(method(floatsSelectionViews))]
        #[unsafe(method_family = none)]
        pub unsafe fn floatsSelectionViews(&self) -> bool;

        /// Setter for [`floatsSelectionViews`][Self::floatsSelectionViews].
        #[unsafe(method(setFloatsSelectionViews:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFloatsSelectionViews(&self, floats_selection_views: bool);

        /// Specifies a style of decoration to place behind items that are selected and/or highlighted. The default value is
        /// `nil,`indicating no built-in background decoration.
        #[unsafe(method(selectionBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionBackgroundStyle(&self)
            -> Option<Retained<NSScrubberSelectionStyle>>;

        /// Setter for [`selectionBackgroundStyle`][Self::selectionBackgroundStyle].
        #[unsafe(method(setSelectionBackgroundStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectionBackgroundStyle(
            &self,
            selection_background_style: Option<&NSScrubberSelectionStyle>,
        );

        /// Specifies a style of decoration to place above items that are selected and/or highlighted. The default value is
        /// `nil,`indicating no built-in overlay decoration.
        #[unsafe(method(selectionOverlayStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionOverlayStyle(&self) -> Option<Retained<NSScrubberSelectionStyle>>;

        /// Setter for [`selectionOverlayStyle`][Self::selectionOverlayStyle].
        #[unsafe(method(setSelectionOverlayStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectionOverlayStyle(
            &self,
            selection_overlay_style: Option<&NSScrubberSelectionStyle>,
        );

        /// If
        /// `showsArrowButtons`is
        /// `YES,`the control provides leading and trailing arrow buttons. Tapping an arrow button moves the selection index by one element; pressing and holding repeatedly moves the selection. The default is
        /// `NO.`
        #[unsafe(method(showsArrowButtons))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsArrowButtons(&self) -> bool;

        /// Setter for [`showsArrowButtons`][Self::showsArrowButtons].
        #[unsafe(method(setShowsArrowButtons:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsArrowButtons(&self, shows_arrow_buttons: bool);

        /// If
        /// `showsAdditionalContentIndicators`is
        /// `YES,`the control will draw a fade effect to indicate that there is additional unscrolled content. The default is
        /// `NO.`
        #[unsafe(method(showsAdditionalContentIndicators))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsAdditionalContentIndicators(&self) -> bool;

        /// Setter for [`showsAdditionalContentIndicators`][Self::showsAdditionalContentIndicators].
        #[unsafe(method(setShowsAdditionalContentIndicators:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsAdditionalContentIndicators(
            &self,
            shows_additional_content_indicators: bool,
        );

        #[cfg(feature = "NSColor")]
        /// If set,
        /// `backgroundColor`is displayed behind the scrubber content. The background color is suppressed if the scrubber is assigned a non-nil
        /// `backgroundView.`The default value is
        /// `nil.`
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundColor(&self) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundColor(&self, background_color: Option<&NSColor>);

        /// If non-nil, the
        /// `backgroundView`is displayed below the scrubber content. The view's layout is managed by
        /// `NSScrubber`to match the content area. If this property is non-nil, the
        /// `backgroundColor`property has no effect. The default value is
        /// `nil.`
        #[unsafe(method(backgroundView))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`backgroundView`][Self::backgroundView].
        #[unsafe(method(setBackgroundView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundView(&self, background_view: Option<&NSView>);

        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        /// Invalidate all data within the scrubber control, triggering a reload of all content, and clearing the current selection.
        #[unsafe(method(reloadData))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadData(&self);

        #[cfg(feature = "block2")]
        /// Updates inside the
        /// `performSequentialBatchUpdates`block are processed and displayed all at once, including insertion, removal, moving, reloading items, and changing the selected index. Changes are performed iteratively using the same semantics as
        /// `NSMutableArray.`NSScrubber expects its dataSource to reflect the changes made inside
        /// `-performSequentialBatchUpdates:`immediately after the
        /// `updateBlock`finishes executing.
        #[unsafe(method(performSequentialBatchUpdates:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performSequentialBatchUpdates(
            &self,
            update_block: &block2::DynBlock<dyn Fn() + '_>,
        );

        /// Inserts new items at the specified indexes. NSScrubber will request views for each new index from the
        /// `dataSource.`This method uses the same semantics as
        /// `NSMutableArray;`each index in the set specifies the destination index after all previous insertions have occurred. Therefore, an NSIndexSet of [1,2,3] will result in three new contiguous items.
        #[unsafe(method(insertItemsAtIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertItemsAtIndexes(&self, indexes: &NSIndexSet);

        /// Removes the items at the specified indexes. This method uses the same semantics as
        /// `NSMutableArray.`
        #[unsafe(method(removeItemsAtIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeItemsAtIndexes(&self, indexes: &NSIndexSet);

        /// Reloads the items at the specified indexes. NSScrubber will request new views for each item and smoothly crossfade between them before discarding the original views.
        #[unsafe(method(reloadItemsAtIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn reloadItemsAtIndexes(&self, indexes: &NSIndexSet);

        /// Moves an item from one index to another.
        /// `oldIndex`refers to the item's index prior to the movement, whereas
        /// `newIndex`refers to the item's final location.
        #[unsafe(method(moveItemAtIndex:toIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn moveItemAtIndex_toIndex(&self, old_index: NSInteger, new_index: NSInteger);

        /// Scrolls an item to a given alignment within the control. If
        /// `NSScrubberAlignmentNone`is provided, then the control scrolls the minimum amount necessary to make the item visible. Scrolling is animated if called on the animator proxy.
        #[unsafe(method(scrollItemAtIndex:toAlignment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollItemAtIndex_toAlignment(
            &self,
            index: NSInteger,
            alignment: NSScrubberAlignment,
        );

        #[cfg(feature = "NSScrubberItemView")]
        /// Returns the
        /// `NSScrubberItemView`for the given index, if one currently exists; returns
        /// `nil`otherwise.
        #[unsafe(method(itemViewForItemAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemViewForItemAtIndex(
            &self,
            index: NSInteger,
        ) -> Option<Retained<NSScrubberItemView>>;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        /// Registers a
        /// `NSScrubberItemView`class to be instantiated for the given
        /// `itemIdentifier.`Raises an exception if
        /// `itemViewClass`is not a subclass of
        /// `NSScrubberItemView.`Passing
        /// `nil`for
        /// `itemViewClass`removes a previous registration. Registrations made through this method do not persist through NSCoding.
        #[unsafe(method(registerClass:forItemIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerClass_forItemIdentifier(
            &self,
            item_view_class: Option<&AnyClass>,
            item_identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        /// Register a nib to be instantiated for the given
        /// `itemIdentifier.`The nib must contain a top-level object which is a subclass of NSScrubberItemView; otherwise,
        /// `-makeItemWithIdentifier:`may return
        /// `nil`for this identifier. Passing
        /// `nil`for
        /// `nib`removes a previous registration.
        #[unsafe(method(registerNib:forItemIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerNib_forItemIdentifier(
            &self,
            nib: Option<&NSNib>,
            item_identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(
            feature = "NSScrubberItemView",
            feature = "NSUserInterfaceItemIdentification"
        ))]
        /// Creates or reuses a
        /// `NSScrubberItemView`corresponding to the provided
        /// `itemIdentifier.``NSScrubber`searches, in order: the reuse queue, the list of registered classes, and then the list of registered nibs. If the reuse queue is empty, and there is no Class or Interface Builder archive registered for the
        /// `itemIdentifier,`this method returns
        /// `nil.`
        #[unsafe(method(makeItemWithIdentifier:owner:))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeItemWithIdentifier_owner(
            &self,
            item_identifier: &NSUserInterfaceItemIdentifier,
            owner: Option<&AnyObject>,
        ) -> Option<Retained<NSScrubberItemView>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSScrubber {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSScrubber {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
