/*
 *  CUPS add-on module for Canon LIPSLX/UFR2/NCAP printer.
 *  Copyright CANON INC. 2018
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CNRS_PROC_H_
#define _CNRS_PROC_H_

#define CNRS_ID_START_JOB			0x001
#define CNRS_ID_SEND_DATA			0X002
#define CNRS_ID_END_JOB				0x003
#define CNRS_ID_JOB_CANCEL			0x004

#define	DEF_NO_ERR  0
#define	DEF_ERR    -1

#define OPTION_STRING_MAXLENGTH 1024
#define BUFSIZE		256
#define BAND_HEIGHT 256

#define MODULE_PATH		"/usr/bin"

#ifdef _SFP_
#define MODULE_NAME		"cnrsdrvsfp"
#else
#define MODULE_NAME		"cnrsdrvufr2"
#endif

#define CMD_HEADER_SIZE	4

typedef struct cnrs_pipe_fds_t
{
	int cmd_fd;
	int dat_fd;

} CnRasterPipeFds;


#ifdef DEBUGLOG
#define	INDENT_NONE		0
#define	INDENT_RIGHT	1
#define	INDENT_LEFT		2

void	debuglog(int indent, const char *message, ...);
#else
#undef	debuglog
#define	debuglog(a, b, ...)
#endif


int cnprocCreateProcess(int *pPId, CnRasterPipeFds *pFds, char *argv[] );
int cnprocWriteCommand( CnRasterPipeFds tFds, int nCmdID, char *pData, int nDataSize);
int cnprocWriteData( CnRasterPipeFds tFds, char *pData, int nDataSize );


#endif
