// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// DeleteSentinelPolicyReader is a Reader for the DeleteSentinelPolicy structure.
type DeleteSentinelPolicyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteSentinelPolicyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteSentinelPolicyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteSentinelPolicyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteSentinelPolicyOK creates a DeleteSentinelPolicyOK with default headers values
func NewDeleteSentinelPolicyOK() *DeleteSentinelPolicyOK {
	return &DeleteSentinelPolicyOK{}
}

/*
DeleteSentinelPolicyOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteSentinelPolicyOK struct {
	Payload *models.HashicorpCloudVault20201125DeleteSentinelPolicyResponse
}

// IsSuccess returns true when this delete sentinel policy o k response has a 2xx status code
func (o *DeleteSentinelPolicyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete sentinel policy o k response has a 3xx status code
func (o *DeleteSentinelPolicyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sentinel policy o k response has a 4xx status code
func (o *DeleteSentinelPolicyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete sentinel policy o k response has a 5xx status code
func (o *DeleteSentinelPolicyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sentinel policy o k response a status code equal to that given
func (o *DeleteSentinelPolicyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete sentinel policy o k response
func (o *DeleteSentinelPolicyOK) Code() int {
	return 200
}

func (o *DeleteSentinelPolicyOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sentinel/policy/delete][%d] deleteSentinelPolicyOK  %+v", 200, o.Payload)
}

func (o *DeleteSentinelPolicyOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sentinel/policy/delete][%d] deleteSentinelPolicyOK  %+v", 200, o.Payload)
}

func (o *DeleteSentinelPolicyOK) GetPayload() *models.HashicorpCloudVault20201125DeleteSentinelPolicyResponse {
	return o.Payload
}

func (o *DeleteSentinelPolicyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125DeleteSentinelPolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSentinelPolicyDefault creates a DeleteSentinelPolicyDefault with default headers values
func NewDeleteSentinelPolicyDefault(code int) *DeleteSentinelPolicyDefault {
	return &DeleteSentinelPolicyDefault{
		_statusCode: code,
	}
}

/*
DeleteSentinelPolicyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteSentinelPolicyDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this delete sentinel policy default response has a 2xx status code
func (o *DeleteSentinelPolicyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete sentinel policy default response has a 3xx status code
func (o *DeleteSentinelPolicyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete sentinel policy default response has a 4xx status code
func (o *DeleteSentinelPolicyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete sentinel policy default response has a 5xx status code
func (o *DeleteSentinelPolicyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete sentinel policy default response a status code equal to that given
func (o *DeleteSentinelPolicyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete sentinel policy default response
func (o *DeleteSentinelPolicyDefault) Code() int {
	return o._statusCode
}

func (o *DeleteSentinelPolicyDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sentinel/policy/delete][%d] DeleteSentinelPolicy default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteSentinelPolicyDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sentinel/policy/delete][%d] DeleteSentinelPolicy default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteSentinelPolicyDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *DeleteSentinelPolicyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
