// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Crystal.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Crystal::Crystal( int x_p, int y_p, int my_row_p, Color color ) :
        original_color(color),
        current_color(color)
{
    x = x_p;
    y = y_p;
    width = CELL_WIDTH;
    height = CELL_HEIGHT;
    
    my_row = my_row_p;
    
    my_id = CRYSTAL;
    
    coll_box_x_offset = coll_box_x_offset_c;
    coll_box_y_offset = coll_box_y_offset_c;
    coll_box.w = coll_box_w_c;
    coll_box.h = coll_box_h_c;

    must_deactivate = false;
    active = true;

} // FS::Crystal::Crystal
    
        
// ******************
// *** DESTRUCTOR ***
// ******************
FS::Crystal::~Crystal()
{
    // ?!
    
} // FS::Crystal::~Crystal




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Crystal::reset()
{
    current_color = original_color;
    active = true;
    must_deactivate = false;
    
} // FS::Crystal::reset

// **************************************************
        
void FS::Crystal::update( const ScrollingData& sd )
{
    // Need to scroll whether crystal's active or not - it will
    // be reactivated if the level is restarted.
    scroll_x(sd);   // i.e. MapSprite::scroll_x
    
    if ( active )
    {
        if ( calc_virtual_x(sd, my_row) )   // see CollectableSprite::calc_rects
        {
            if ( !must_deactivate )
            {
                gfx_ptr->draw_texture( current_color + 38, virtual_x, y );
            }
            else
            {
                must_deactivate = false;
                deactivate();   // see Sprite::deactivate
            } // if ... else
        } // if
    } // if
    
} // FS::Crystal::update
                    
// **************************************************
