// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Crystal_h
#define Crystal_h




#include "Collectable_sprite.h"
#include "enums.h"
#include "constants.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
class Crystal : public Collectable_sprite
{
    public:
    
        enum Color 
        {
            color_none_c = -1,
            color_red_c,
            color_yellow_c,
            color_blue_c,
            color_white_c
        }; // enum Color
        
        Crystal( int x_p, int y_p, int my_row_p, Color color );
        ~Crystal();
        
        Color get_color() const { return current_color; }
        void set_color(Color cc) { current_color = cc; }
        void reset();
        
        // Provide implementation of pure virtual function in MapSprite.
        void update( const ScrollingData& sd );
        
    private:
         
        static const int coll_box_x_offset_c = 20;
        static const int coll_box_y_offset_c = 20;
        static const int coll_box_w_c = 10;
        static const int coll_box_h_c = 10;

        Color original_color;
        Color current_color;
        
}; // class Crystal

} // namespace FS




#endif

                
