// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Sprite_h
#define Sprite_h




#include "SDL.h"    // for SDL_Rect
#include <iostream>




class Sprite
{
    public:
            
        Sprite();   // default constructor
        virtual ~Sprite();  // virtual destructor - because Sprite will act as
                            // a base class
        
        bool is_active() const { return active; }
        void activate() { active = true; }
        void deactivate() { active = false; }
        
        int get_x() const { return x; }
        int get_y() const { return y; }
        int get_old_x() const { return old_x; }
        int get_old_y() const { return old_y; }
        int get_width() const { return width; }
        int get_height() const { return height; }

        const SDL_Rect& get_coll_box();
        const SDL_Rect& get_bounding_box();

    protected:
            
        int x;
        int y;
        int old_x;
        int old_y;
        
        int width;
        int height;
        
        bool active;    // is sprite being used?
        float velocity; // pixels per millisecond
        
        SDL_Rect sprite_src_rect;
        SDL_Rect sprite_dest_rect;
        SDL_Rect erase_rect;
        SDL_Rect update_rect;
        
        bool sprite_visible;        
        bool erase_rect_visible;    
        
        int coll_box_x_offset;
        int coll_box_y_offset;
        SDL_Rect coll_box;
        SDL_Rect bounding_box;
        
        // convenience methods for setting up SDL_Rects
        int max(int a, int b) const;
        int min(int a, int b) const;
        void minmax(int a, int b, int & min, int & max) const;
        
        // This function assumes the following: that at least some part of
        // update_rect is in bounds, and that w and h are < screen_width
        // and screen_height respectively.
        void clip_update_rect_xy(int screen_width, int screen_height);
        void clip_update_rect_x(int screen_width);
        void clip_update_rect_y(int screen_height);
        
}; // class Sprite

// Non-member, non-friend helper function.
void print_SDL_Rect(const SDL_Rect& r, const char* name);




#endif

