// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef constants_h
#define constants_h




#include "enums.h"




namespace FS
{

const int SCREEN_WIDTH = 800;
const int SCREEN_HEIGHT = 600;
const int BPP = 8; // i.e. Bits Per Pixel

const int CELL_WIDTH = 50;
const int CELL_HEIGHT = 50;
// these three measured in cells
const int NUM_ROWS = 6;
const int NUM_COLS = 16;
const int MAX_COLS = 40;    // see fsle!

const int MAX_CRYSTALS_HELD = 2;
const int STARTING_NUM_LIVES = 3;
const int NUM_LEVELS = 12;

const int ALBERT_START_X = 375;
const int ALBERT_START_Y = 502;
const int ALBERT_X_OFFSCREEN_TOLERANCE = 50;
const int ALBERT_Y_OFFSCREEN_TOLERANCE = 30;
const float ALBERT_VELOCITY = 0.07;
const float ALBERT_JUMPING_VELOCITY = 0.15;
const int ALBERT_WIDTH = 128;
const int ALBERT_HEIGHT = 128;
const int ALBERT_DURATION = 100;

// Albert's actions
const int WALKING = 1;
const int TURNING = 2;
//const int GETTING_UP = 4;
//const int SITTING_DOWN = 8;
const int LEAVING_WITH_FISH = 4;
const int LEAVING_IN_A_HUFF = 8;
const int JUMPING = 16;
const int FLOATING = 32;
const int SPLASHING = 64;
const int ZAPPING = 128;

// LEAVING_WITH_FISH/LEAVING_IN_A_HUFF|SPLASHING|ZAPPING
const int DISABLING_ACTIONS = 204;  

//const int TURNING_STRIP_NUM_FRAMES = 24;
const int WALKING_STRIP_NUM_FRAMES = 8;
const int JUMPING_STRIP_NUM_FRAMES = 12;
const int SPLASHING_STRIP_NUM_FRAMES = 8;
const int ZAPPING_STRIP_NUM_FRAMES = 5;

const int AIRBORNE_START_FRAME = 5;
const int AIRBORNE_END_FRAME = 9;  

const int UPPER_BANK_MAX_Y = 61;
const int LOWER_BANK_MIN_Y = 537;

// 'Crystals held' displayed in bottom-left of screen in-game.
const int CRYSTALS_HELD_Y = 545;
const int CRYSTALS_HELD_X_OFFSET = 20;
const int CRYSTALS_HELD_X_GAP = -15;

const int BONUS_COLL_BOX_X_OFFSET = 17;
const int BONUS_COLL_BOX_Y_OFFSET = 21;
const int BONUS_COLL_BOX_WIDTH = 10;
const int BONUS_COLL_BOX_HEIGHT = 9;
        
const int FISH_X = 375;
const int FISH_Y = 25;
const int FISH_WIDTH = /*48*/60;
const int FISH_HEIGHT = /*29*/28;

// scoring system
//const int PTS_CRYSTAL = 5;
const int PTS_BROWN_LOG = 10;
const int PTS_ONE_COLOR_LOG = 50;
const int PTS_TWO_COLOR_LOG = 100;
const int PTS_FISH = 500;

// In-game layer system (for drawing sprites)
const int NUM_LAYERS = 5;
enum { LOGS_LAYER, CRYSTALS_LAYER, STARS_LAYER, CAT_LAYER, PAUSE_MENU_LAYER };
// These values determine the size of the 'my_blit_requests' arrays
// in PlayDisplay.
const int LAYER_MAX_BLITS[] = { 100, 50, 40, 1, 1 };
            
// Data for direction, velocity and movement (of logs
// and collectables).
struct ScrollingData
{
    Direction original_directions[NUM_ROWS];
    Direction current_directions[NUM_ROWS];
    float original_velocities[NUM_ROWS];
    float current_velocities[NUM_ROWS];
    int dxs[NUM_ROWS];
    float pixels_carried_over_x[NUM_ROWS];
    int row_lengths_in_cells[NUM_ROWS]; // for your convenience
    int row_lengths_in_pixels[NUM_ROWS];
}; // struct ScrollingData

} // namespace FS




#endif

