/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import javax.inject.Inject;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.ProvidesWorkResult;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

public abstract class AbstractIsolatedCompilerWorkerExecutor
implements CompilerWorkerExecutor {
    private final WorkerFactory workerFactory;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public AbstractIsolatedCompilerWorkerExecutor(WorkerFactory workerFactory, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerFactory = workerFactory;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    abstract IsolatedClassLoaderWorkerRequirement getIsolatedWorkerRequirement(DaemonForkOptions var1);

    @Override
    public DefaultWorkResult execute(CompilerWorkerExecutor.CompilerParameters parameters, DaemonForkOptions daemonForkOptions) {
        IsolatedClassLoaderWorkerRequirement workerRequirement = this.getIsolatedWorkerRequirement(daemonForkOptions);
        BuildOperationAwareWorker worker = this.workerFactory.getWorker((WorkerRequirement)workerRequirement);
        return worker.execute(this.actionExecutionSpecFactory.newIsolatedSpec("compiler daemon", CompilerWorkAction.class, (WorkParameters)parameters, (WorkerRequirement)workerRequirement, true));
    }

    public static class CompilerWorkAction
    implements WorkAction<CompilerWorkerExecutor.CompilerParameters>,
    ProvidesWorkResult {
        private DefaultWorkResult workResult;
        private final CompilerWorkerExecutor.CompilerParameters parameters;
        private final Instantiator instantiator;

        @Inject
        public CompilerWorkAction(CompilerWorkerExecutor.CompilerParameters parameters, Instantiator instantiator) {
            this.parameters = parameters;
            this.instantiator = instantiator;
        }

        public CompilerWorkerExecutor.CompilerParameters getParameters() {
            return this.parameters;
        }

        public void execute() {
            Class compilerClass = (Class)Cast.uncheckedCast((Object)ClassLoaderUtils.classFromContextLoader((String)this.getParameters().getCompilerClassName()));
            Compiler compiler = (Compiler)this.instantiator.newInstance(compilerClass, this.getParameters().getCompilerInstanceParameters());
            this.setWorkResult(compiler.execute((CompileSpec)Cast.uncheckedCast((Object)this.getParameters().getCompileSpec())));
        }

        private void setWorkResult(WorkResult workResult) {
            this.workResult = workResult instanceof DefaultWorkResult ? (DefaultWorkResult)workResult : new DefaultWorkResult(workResult.getDidWork(), null);
        }

        public DefaultWorkResult getWorkResult() {
            return this.workResult;
        }
    }
}

