/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.kbs;

import org.whispersystems.signalservice.api.kbs.PinString;

public final class PinValidityChecker {
    public static boolean valid(String pin) {
        if ((pin = pin.trim()).isEmpty()) {
            return false;
        }
        if (PinString.allNumeric(pin)) {
            return !PinValidityChecker.sequential(pin = PinString.toArabic(pin)) && !PinValidityChecker.sequential(PinValidityChecker.reverse(pin)) && !PinValidityChecker.allTheSame(pin);
        }
        return true;
    }

    private static String reverse(String string) {
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length / 2; ++i) {
            char temp = chars[i];
            chars[i] = chars[chars.length - i - 1];
            chars[chars.length - i - 1] = temp;
        }
        return new String(chars);
    }

    private static boolean sequential(String pin) {
        int length = pin.length();
        if (length == 0) {
            return false;
        }
        char c = pin.charAt(0);
        for (int i = 1; i < length; ++i) {
            char n = pin.charAt(i);
            if (n != c + '\u0001') {
                return false;
            }
            c = n;
        }
        return true;
    }

    private static boolean allTheSame(String pin) {
        int length = pin.length();
        if (length == 0) {
            return false;
        }
        char c = pin.charAt(0);
        for (int i = 1; i < length; ++i) {
            char n = pin.charAt(i);
            if (n == c) continue;
            return false;
        }
        return true;
    }
}

