/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.jobs;

import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.jobs.Job;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProfileJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(DownloadProfileJob.class);
    private final RecipientAddress address;

    public DownloadProfileJob(RecipientAddress address) {
        this.address = address;
    }

    @Override
    public void run(Context context) {
        logger.trace("Refreshing profile for {}", (Object)this.address);
        SignalAccount account = context.getAccount();
        RecipientId recipientId = account.getRecipientStore().resolveRecipient(this.address);
        context.getProfileHelper().refreshRecipientProfile(recipientId);
    }
}

