"use strict"
define("vault/adapters/-json-api",["exports","@ember-data/adapter/json-api"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/adapters/application",["exports","@ember-data/adapter/error","@ember-data/adapter/rest","@ember/service","@ember/object","rsvp","vault/config/environment"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const{APP:o}=a.default,{POLLING_URLS:s,NAMESPACE_ROOT_URLS:u}=o
e.default=n.default.extend({auth:(0,l.service)(),namespaceService:(0,l.service)("namespace"),controlGroup:(0,l.service)(),flashMessages:(0,l.service)(),namespace:"v1/sys",shouldReloadAll:()=>!0,shouldReloadRecord:()=>!0,shouldBackgroundReloadRecord:()=>!1,addHeaders(e,t,n){const l=t.clientToken||this.auth.currentToken,i={}
l&&!t.unauthenticated&&(i["X-Vault-Token"]=l),t.wrapTTL&&(i["X-Vault-Wrap-TTL"]=t.wrapTTL),"PATCH"===n&&(i["Content-Type"]="application/merge-patch+json")
const r=void 0===t.namespace?this.namespaceService.path:t.namespace
r&&!u.some((t=>e.includes(t)))&&(i["X-Vault-Namespace"]=r),t.headers=Object.assign(t.headers||{},i)},_preRequest(e,t,n){this.addHeaders(e,t,n)
return s.some((t=>e.includes(t)))||this.auth.setLastFetch(Date.now()),t.timeout=6e4,t},ajax(e,t,n={}){let l=e,i=t,r=n
const a=this.controlGroup,o=a.tokenForUrl(l)
o&&(l="/v1/sys/wrapping/unwrap",i="POST",r={clientToken:o.token,data:{token:o.token}})
const s=this._preRequest(l,r,t)
return this._super(l,i,s).then(((...e)=>{o&&a.deleteControlGroupToken(o.accessor)
const[t]=e
if(t&&t.warnings&&!r.skipWarnings){const e=this.flashMessages
t.warnings.forEach((t=>{e.info(t)}))}return a.checkForControlGroup(e,t,r.wrapTTL)}))},rawRequest(e,t,n={}){const l=this._preRequest(e,n)
return fetch(e,{method:t||"GET",headers:l.headers||{},body:l.body,signal:l.signal}).then((e=>e.status>=200&&e.status<300?r.default.resolve(e):r.default.reject(e)))},handleResponse(e,n,l,r){const a=this._super(...arguments)
return a instanceof t.default&&((0,i.set)(a,"httpStatus",e),(0,i.set)(a,"path",r.url),l?.data?.error&&!l.errors&&(0,i.set)(a,"errors",[l.data.error])),a}})})),define("vault/adapters/auth-config/_base",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"/v1/auth",pathForType(e){const t=e.split("/").pop()
return"identity-accesslist"===t||"roletag-denylist"===t?`tidy/${t}`:t},buildURL(e,t,n){const l=t||n.belongsTo("backend").id
let i=`${this.namespace}/${l}/config`
return e.includes("aws")&&(i=`${i}/${this.pathForType(e)}`),i},createRecord(e,t,n){const l=n.belongsTo("backend").id
return this._super(...arguments).then((()=>({id:l})))},updateRecord(e,t,n){const l=n.belongsTo("backend").id
return this._super(...arguments).then((()=>({id:l})))}})})),define("vault/adapters/auth-config/aws/client",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/aws/identity-accesslist",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/aws/roletag-denylist",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/azure",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/gcp",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/github",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/jwt",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/kubernetes",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/ldap",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/oidc",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/okta",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-config/radius",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/auth-method",["exports","@ember-data/adapter/error","@ember/object","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({url(e){const t=`${this.buildURL()}/auth`
return e?t+"/"+(0,i.encodePath)(e):t},pathForType:()=>"mounts/auth",findAll(e,l,i,r){const a=r?.adapterOptions?.unauthenticated,o=r?.adapterOptions?.useMountsEndpoint
if(a||o){const e=`/${this.urlPrefix()}/internal/ui/mounts`
return this.ajax(e,"GET",{unauthenticated:a}).then((e=>({data:e.data.auth}))).catch((e=>{if(a)return{data:{}}
throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/internal/ui/mounts"),e}))}return this.ajax(this.url(),"GET").catch((e=>{throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/auth"),e}))},createRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.attr("path")
return this.ajax(this.url(i),"POST",{data:l}).then((()=>(l.config.id=i,{data:{...l,path:i+"/",id:i}})))},urlForDeleteRecord(e,t,n){return this.url(n.id)},exchangeOIDC(e,t,n){return this.ajax(`/v1/auth/${(0,i.encodePath)(e)}/oidc/callback`,"GET",{data:{state:t,code:n}})},pollSAMLToken(e,t,n){return this.ajax(`/v1/auth/${(0,i.encodePath)(e)}/token`,"PUT",{data:{token_poll_id:t,client_verifier:n}})},tune(e,t){const n=`${this.buildURL()}/${this.pathForType()}/${(0,i.encodePath)(e)}tune`
return this.ajax(n,"POST",{data:t})},resetPassword(e,t,n){const l=`/v1/auth/${(0,i.encodePath)(e)}/users/${(0,i.encodePath)(t)}/password`
return this.ajax(l,"POST",{data:{password:n}})}})})),define("vault/adapters/aws-credential",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){const l=n.attr("ttl"),i=n.attr("roleArn"),r=n.attr("credentialType")
let a,o="POST"
const s={}
"iam_user"===r?o="GET":(l&&(s.ttl=l),"assumed_role"===r&&i&&(s.role_arn=i),a=s.ttl||s.role_arn?{data:s}:{})
const u=n.attr("role"),c=`/v1/${u.backend}/creds/${u.name}`
return this.ajax(c,o,a).then((l=>{l.id=n.id,l.modelName=t.modelName,e.pushPayload(t.modelName,l)}))}})})),define("vault/adapters/aws/lease-config",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}queryRecord(e,t,l){const{backend:i}=l
return this.ajax(`${this.buildURL()}/${(0,n.encodePath)(i)}/config/lease`,"GET").then((e=>({...e,id:i,backend:i})))}createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.record.backend
return this.ajax(`${this.buildURL()}/${i}/config/lease`,"POST",{data:l}).then((e=>({...e,id:i})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}}e.default=i})),define("vault/adapters/aws/root-config",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}queryRecord(e,t,l){const{backend:i}=l
return this.ajax(`${this.buildURL()}/${(0,n.encodePath)(i)}/config/root`,"GET").then((e=>({...e,id:i,backend:i})))}createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.record.backend
return this.ajax(`${this.buildURL()}/${i}/config/root`,"POST",{data:l}).then((e=>({...e,id:i})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}}e.default=i})),define("vault/adapters/capabilities",["exports","@ember-data/adapter/error","@ember/object","vault/adapters/application","core/utils/sanitize-path"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends l.default{pathForType(){return"capabilities-self"}_formatPath(e){const{relativeNamespace:t}=this.namespaceService
return t?`${t}/${(0,i.sanitizeStart)(e)}`:e}async findRecord(e,l,r){const a=[this._formatPath(r)]
return this.ajax(this.buildURL(l),"POST",{data:{paths:a},namespace:(0,i.sanitizePath)(this.namespaceService.userRootNamespace)}).catch((e=>{throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/capabilities-self"),e}))}queryRecord(e,t,n){const{id:l}=n
if(l)return this.findRecord(e,t,l).then((e=>(e.path=l,e)))}query(e,l,r){const a=r?.paths.reduce(((e,t)=>{const n=this._formatPath(t)
return n&&(e[n]=t),e}),{})
return this.ajax(this.buildURL(l),"POST",{data:{paths:Object.keys(a)},namespace:(0,i.sanitizePath)(this.namespaceService.userRootNamespace)}).then((e=>(e&&(e.pathMap=a),e))).catch((e=>{throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/capabilities-self"),e}))}}e.default=r})),define("vault/adapters/clients/activity",["exports","vault/utils/query-param-string","vault/adapters/application","core/utils/client-count-utils","@ember/debug"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{formatTimeParam(e,t=!1){let n
if(e)try{n=e.timestamp||(0,l.formatDateObject)(e,t)}catch(i){}return n}formatQueryParams(e){const t={},n=this.formatTimeParam(e?.start_time),l=this.formatTimeParam(e?.end_time,!0)
return n&&(t.start_time=n),l&&(t.end_time=l),t}queryRecord(e,t,n){const l=`${this.buildURL()}/internal/counters/activity`,i={data:this.formatQueryParams(n)}
return n?.namespace&&(i.namespace=n.namespace),this.ajax(l,"GET",i).then((e=>{const t=e||{}
return t.id=t.request_id||"no-data",t}))}async exportData(e){const n=`${this.buildURL()}/internal/counters/activity/export${(0,t.default)({format:e?.format||"csv",start_time:e?.start_time??void 0,end_time:e?.end_time??void 0})}`
let l
try{const t=e?.namespace?{namespace:e.namespace}:{},i=await this.rawRequest(n,"GET",t)
if(200===i.status)return i.blob()
l="no data to export in provided time range."}catch(i){const{errors:e}=await i.json()
l=e?.join(". ")}if(l)throw new Error(l)}findRecord(e,t,n){"clients/activity"!==n&&(0,i.debug)(`findRecord('clients/activity') should pass 'clients/activity' as the id, you passed: '${n}'`)
const l=`${this.buildURL()}/internal/counters/activity`
return this.ajax(l,"GET",{skipWarnings:!0})}}e.default=r})),define("vault/adapters/clients/config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({queryRecord(){return this.ajax(this.urlForQuery(),"GET").then((e=>(e.id=e.request_id,e)))},urlForUpdateRecord(){return this.buildURL()+"/internal/counters/config"},urlForQuery(){return this.buildURL()+"/internal/counters/config"}})})),define("vault/adapters/clients/version-history",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{findAll(){return this.ajax(this.buildURL()+"/version-history","GET",{data:{list:!0}}).then((e=>e))}}e.default=n})),define("vault/adapters/cluster",["exports","@ember-data/adapter/error","@ember/service","rsvp","@ember/debug","ember-inflector","vault/adapters/application"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=["health","seal-status","tokens","token","seal","unseal","init","capabilities-self","license"]
e.default=a.default.extend({version:(0,n.service)(),namespaceService:(0,n.service)("namespace"),shouldBackgroundReloadRecord:()=>!0,findRecord(e,n,i,r){const a={health:this.health(),sealStatus:this.sealStatus().catch((e=>e))}
return this.version.isEnterprise&&this.namespaceService.inRootNamespace&&(a.replicationStatus=this.replicationStatus().catch((e=>e))),(0,l.hash)(a).then((({health:e,sealStatus:n,replicationStatus:a})=>{let o={id:i,name:r.attr("name")}
return o=Object.assign(o,e),n instanceof t.default==!1&&(o=Object.assign(o,{nodes:[n]})),a&&a instanceof t.default==!1?o=Object.assign(o,a.data):a instanceof t.default&&a?.errors.find((e=>"disabled path"===e))&&(o=Object.assign(o,{replication_redacted:!0})),(0,l.resolve)(o)}))},pathForType:e=>"cluster"===e?"clusters":(0,r.pluralize)(e),health(){return this.ajax(this.urlFor("health"),"GET",{data:{standbycode:200,sealedcode:200,uninitcode:200,drsecondarycode:200,performancestandbycode:200},unauthenticated:!0}).catch((()=>({has_chroot_namespace:!0})))},features(){return this.ajax(`${this.urlFor("license")}/features`,"GET",{unauthenticated:!0})},sealStatus(e=!0){return this.ajax(this.urlFor("seal-status"),"GET",{unauthenticated:e})},seal(){return this.ajax(this.urlFor("seal"),"PUT")},unseal(e){return this.ajax(this.urlFor("unseal"),"PUT",{data:e,unauthenticated:!0})},initCluster(e){return this.ajax(this.urlFor("init"),"PUT",{data:e,unauthenticated:!0})},authenticate({backend:e,data:t}){const{role:n,jwt:l,token:i,password:r,username:a,path:o,nonce:s}=t,u=this.urlForAuth(e,a,o),c="token"===e?"GET":"POST",d={unauthenticated:!0}
return"token"===e?d.headers={"X-Vault-Token":i}:d.data="jwt"===e||"oidc"===e?{role:n,jwt:l}:"okta"===e?{password:r,nonce:s}:i?{token:i,password:r}:{password:r},this.ajax(u,c,d)},mfaValidate({mfa_request_id:e,mfa_constraints:t}){const n={data:{mfa_request_id:e,mfa_payload:t.reduce(((e,{selectedMethod:t,passcode:n})=>{let l=[]
return n&&(l="duo"!==t.type||n.includes("passcode=")?[n]:[`passcode=${n}`]),e[t.id]=l,e}),{})}}
return this.ajax("/v1/sys/mfa/validate","POST",n)},urlFor(e){if(!o.includes(e))throw new Error(`Calls to a ${e} endpoint are not currently allowed in the vault cluster adapter`)
return`${this.buildURL()}/${e}`},urlForAuth(e,t,n){const l=e.toLowerCase(),i={github:"login",jwt:"login",oidc:"login",userpass:`login/${encodeURIComponent(t)}`,ldap:`login/${encodeURIComponent(t)}`,okta:`login/${encodeURIComponent(t)}`,radius:`login/${encodeURIComponent(t)}`,token:"lookup-self"}[l],r=n&&"token"!==l?n:l
if(!i)throw new Error(`There is no auth url for ${e}.`)
return`/v1/auth/${r}/${i}`},urlForReplication(e,t,n){let l
return l=t?`${e}/${t}/${n}`:`${n}`,`${this.buildURL()}/replication/${l}`},replicationStatus(){return this.ajax(`${this.buildURL()}/replication/status`,"GET",{unauthenticated:!0})},replicationDrPromote(e,t){const n=t&&t.checkStatus?"GET":"PUT"
return this.ajax(`${this.buildURL()}/replication/dr/secondary/promote`,n,{data:e,unauthenticated:!0})},generateDrOperationToken(e,t){let n="POST",l=`${this.buildURL()}/replication/dr/secondary/generate-operation-token/`
return t?.cancel?(n="DELETE",l+="attempt"):t?.checkStatus?(n="GET",l+="attempt"):l+=e?.pgp_key||e?.attempt?"attempt":"update",this.ajax(l,n,{data:e,unauthenticated:!0})},replicationAction(e,t,n,l){const i="recover"===e||"reindex"===e?this.urlForReplication(t,null,e):this.urlForReplication(t,n,e)
return this.ajax(i,"POST",{data:l})}})})),define("vault/adapters/config-ui/message",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"config/ui/custom-messages"}query(e,t,n){const{authenticated:l,type:i,active:r}=n,a={authenticated:l,list:!0}
return i&&(a.type=i),"boolean"==typeof r&&(a.active=r),super.query(e,t,a)}queryRecord(e,t,n){return this.ajax(`${this.buildURL(t)}/${n}`,"GET")}updateRecord(e,t,n){return this.ajax(`${this.buildURL(t)}/${n.record.id}`,"POST",{data:this.serialize(n.record)})}}e.default=n})),define("vault/adapters/console",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e})})),define("vault/adapters/control-group-config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"config/control-group",urlForDeleteRecord(e,t){return this.buildURL(t)},urlForFindRecord(e,t){return this.buildURL(t)},urlForUpdateRecord(e,t){return this.buildURL(t)}})})),define("vault/adapters/control-group",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"control-group",async findRecord(e,t,n){const l=this.buildURL(t.modelName)
return this.ajax(`${l}/request`,"POST",{data:{accessor:n}}).then((e=>(e.id=n,e)))},urlForUpdateRecord(e,t){return`${this.buildURL(t)}/authorize`}})})),define("vault/adapters/database/connection",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",urlFor(e,t,n=""){if("ROTATE"===n)return`${this.buildURL()}/${e}/rotate-root/${t}`
if("RESET"===n)return`${this.buildURL()}/${e}/reset/${t}`
let l=`${this.buildURL()}/${e}/config`
return t&&(l=`${this.buildURL()}/${e}/config/${t}`),l},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,t){const{backend:n,id:l}=t
return this.ajax(this.urlFor(n,l),"GET",this.optionsForQuery(l)).then((e=>(e.backend=n,l&&(e.id=l),e)))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)},createRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.attr("name"),r=n.attr("backend")
return this.ajax(this.urlFor(r,i),"POST",{data:l}).then((()=>({data:{id:i,name:i,...l}})))},updateRecord(){return this.createRecord(...arguments)},deleteRecord(e,t,n){const l=n.id,i=n.attr("backend")
return this.ajax(this.urlFor(i,l),"DELETE")},rotateRootCredentials(e,t){return this.ajax(this.urlFor(e,t,"ROTATE"),"POST")},resetConnection(e,t){return this.ajax(this.urlFor(e,t,"RESET"),"POST")}})})),define("vault/adapters/database/credential",["exports","rsvp","vault/adapters/application","vault/lib/control-group-error"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",_staticCreds(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/static-creds/${encodeURIComponent(t)}`,"GET").then((e=>({...e,roleType:"static"})))},_dynamicCreds(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/creds/${encodeURIComponent(t)}`,"GET").then((e=>({...e,roleType:"dynamic"})))},fetchByQuery(e,n){const{backend:i,secret:r}=n
return"static"===n.roleType?this._staticCreds(i,r):"dynamic"===n.roleType?this._dynamicCreds(i,r):(0,t.allSettled)([this._staticCreds(i,r),this._dynamicCreds(i,r)]).then((([e,t])=>{if("rejected"===e.state&&"rejected"===t.state){let n=e.reason
if(t.reason instanceof l.default)throw t.reason
throw n?.httpStatus<t.reason?.httpStatus&&(n=t.reason),n}return e.value||t.value}))},queryRecord(e,t,n){return this.fetchByQuery(e,n)},rotateRoleCredentials(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/rotate-role/${encodeURIComponent(t)}`,"POST")}})}))
define("vault/adapters/database/role",["exports","@ember/debug","vault/lib/control-group-error","vault/adapters/application","rsvp","vault/helpers/add-to-array","vault/helpers/remove-from-array"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({namespace:"v1",pathForType(){},urlFor(e,t,n="dynamic"){let l="roles"
"static"===n&&(l="static-roles")
let i=`${this.buildURL()}/${e}/${l}`
return t&&(i=`${this.buildURL()}/${e}/${l}/${t}`),i},staticRoles(e,t){return this.ajax(this.urlFor(e,t,"static"),"GET",this.optionsForQuery(t)).then((n=>t?{...n,type:"static",backend:e,id:t}:n))},dynamicRoles(e,t){return this.ajax(this.urlFor(e,t),"GET",this.optionsForQuery(t)).then((n=>t?{...n,type:"dynamic",backend:e,id:t}:n))},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},queryRecord(e,t,l){const{backend:r,id:a}=l
return"static"===l.type?this.staticRoles(r,a):"dynamic"===l?.type?this.dynamicRoles(r,a):(0,i.allSettled)([this.staticRoles(r,a),this.dynamicRoles(r,a)]).then((([e,t])=>{if("rejected"===e.state&&"rejected"===t.state){let l=e.reason
if(t.reason instanceof n.default)throw t.reason
throw l?.httpStatus<t.reason?.httpStatus&&(l=t.reason),l}const l=e.value?"static":"dynamic",i=e.value||t.value,o={data:{},backend:r,id:a,type:l}
return o.data={...i.data},o}))},query(e,t,n){const{backend:l}=n,r=this.staticRoles(l),a=this.dynamicRoles(l)
return(0,i.allSettled)([r,a]).then((([e,t])=>{const n={backend:l,data:{keys:[]}}
if(e.reason&&t.reason)throw t.reason
let i=[],r=[]
return e.value&&(i=e.value.data.keys),t.value&&(r=t.value.data.keys),n.data={...n.data,keys:[...i,...r],backend:l,staticRoles:i,dynamicRoles:r},n}))},async _updateAllowedRoles(e,{role:t,backend:n,db:l,type:i="add"}){const o=await e.queryRecord("database/connection",{backend:n,id:l}),s=[...o.allowed_roles||[]],u="add"===i?(0,r.addToArray)(s,t):(0,a.removeFromArray)(s,t)
return o.allowed_roles=u,o.save()},async createRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.attr("type"),r=n.attr("backend"),a=n.attr("name"),o=n.attr("database")
try{await this._updateAllowedRoles(e,{role:a,backend:r,db:o[0]})}catch(s){this.checkError(s)}return this.ajax(this.urlFor(r,a,i),"POST",{data:l}).then((()=>({data:{...l,...a}})))},async deleteRecord(e,t,n){const l=n.attr("type"),i=n.attr("backend"),r=n.attr("name"),a=n.attr("database")
try{await this._updateAllowedRoles(e,{role:r,backend:i,db:a[0],type:"remove"})}catch(o){this.checkError(o)}return this.ajax(this.urlFor(i,r,l),"DELETE")},async updateRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.attr("type"),r=n.attr("backend"),a=n.attr("name")
return this.ajax(this.urlFor(r,a,i),"POST",{data:l}).then((()=>l))},checkError(e){if(403!==e.httpStatus)throw new Error(`Could not update allowed roles for selected database: ${e.errors.join(", ")}`)}})})),define("vault/adapters/generated-item-list",["exports","vault/adapters/application","ember-concurrency","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({store:(0,l.service)(),namespace:"v1",urlForItem(){},dynamicApiPath:"",getDynamicApiPath:(0,n.task)((function*(e){const t=yield this.store.peekRecord("auth-method",e)
this.dynamicApiPath=t.apiPath})),fetchByQuery:(0,n.task)((function*(e,t,n){const{id:l}=t,i={}
return n&&(i.list=!0,yield this.getDynamicApiPath.perform(l)),this.ajax(this.urlForItem(l,n,this.dynamicApiPath),"GET",{data:i}).then((e=>({...e,...{id:l,method:l}})))})),query(e,t,n){return this.fetchByQuery.perform(e,n,!0)},queryRecord(e,t,n){return this.fetchByQuery.perform(e,n)}})})),define("vault/adapters/identity/base",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e,urlForQuery(){return this._super(...arguments)+"?list=true"},query(e,t){return this.ajax(this.buildURL(t.modelName,null,null,"query"),"GET")},buildURL(e,t,n,l,i){return"createRecord"===l?this._super(...arguments):this._super(`${e}/id`,t,n,l,i)}})})),define("vault/adapters/identity/entity-alias",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/identity/entity-merge",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({buildURL(){const[,...e]=arguments
return this._super("identity/entity/merge",...e)},createRecord(e,t,n){return this._super(...arguments).then((()=>({id:n.attr("toEntityId")})))}})})),define("vault/adapters/identity/entity",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({lookup(e,t){const n=`/${this.urlPrefix()}/identity/lookup/entity`
return this.ajax(n,"POST",{data:t}).then((t=>{if(!t)return
const n="identity/entity"
return e.push(e.serializerFor(n).normalizeResponse(e,e.modelFor(n),t,t.data.id,"findRecord")),t}))}})})),define("vault/adapters/identity/group-alias",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/identity/group",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({lookup(e,t){const n=`/${this.urlPrefix()}/identity/lookup/group`
return this.ajax(n,"POST",{data:t}).then((t=>{if(!t)return
const n="identity/group"
return e.push(e.serializerFor(n).normalizeResponse(e,e.modelFor(n),t,t.data.id,"findRecord")),t}))}})})),define("vault/adapters/identity/oidc/config",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}queryRecord(){return this.ajax(`${this.buildURL()}/identity/oidc/config`,"GET").then((e=>({...e,id:"identity-oidc-config"})))}createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n)
return this.ajax(`${this.buildURL()}/identity/oidc/config`,"POST",{data:l}).then((e=>({...e})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}}e.default=l})),define("vault/adapters/keymgmt/key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","vault/lib/control-group-error","@ember/service"],(function(e,t,n,l,i){var r,a
function o(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function s(e,t){const n={}
return Object.keys(e).forEach((l=>{t.indexOf(l)>=0&&(n[l]=e[l])})),n}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="store",i=this,(l=a)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0}),o(this,"namespace","v1")}pathForType(){return"key"}buildURL(e,t,n,l,i){let r=super.buildURL(...arguments)
return n?r=r.replace("key",`${n.attr("backend")}/key`):i&&(r=r.replace("key",`${i.backend}/key`)),r}url(e,t,l){const i=`${this.buildURL()}/${e}/key`
return t?"ROTATE"===l?i+"/"+(0,n.encodePath)(t)+"/rotate":"PROVIDERS"===l?i+"/"+(0,n.encodePath)(t)+"/kms":i+"/"+(0,n.encodePath)(t):i}_updateKey(e,t,n){const l=s(n,["deletion_allowed","min_enabled_version"])
return this.ajax(this.url(e,t),"PUT",{data:l})}_createKey(e,t,n){const l=s(n,["type"])
return this.ajax(this.url(e,t),"POST",{data:l})}async createRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.attr("name"),r=n.attr("backend")
if(await this._createKey(r,i,l),n.attr("deletionAllowed"))try{await this._updateKey(r,i,l)}catch{throw new Error(`Key ${i} was created, but not all settings were saved`)}return{data:{...l,id:i,backend:r}}}updateRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.attr("name"),r=n.attr("backend")
return this._updateKey(r,i,l)}distribute(e,t,l,i){return this.ajax(`${this.buildURL()}/${e}/kms/${(0,n.encodePath)(t)}/key/${(0,n.encodePath)(l)}`,"PUT",{data:{...i}})}async getProvider(e,t){try{const n=await this.ajax(this.url(e,t,"PROVIDERS"),"GET",{data:{list:!0}})
return n.data.keys?n.data.keys[0]:null}catch(c){if(404===c.httpStatus)return null
if(403===c.httpStatus)return{permissionsError:!0}
throw c}}getDistribution(e,t,n){const i=`${this.buildURL()}/${e}/kms/${t}/key/${n}`
return this.ajax(i,"GET").then((e=>({...e.data,purposeArray:e.data.purpose.split(",")}))).catch((e=>{if(e instanceof l.default)throw e
return null}))}async queryRecord(e,t,n){const{id:l,backend:i,recordOnly:r=!1}=n,a=await this.ajax(this.url(i,l),"GET")
let o,s
return a.data.id=l,a.data.backend=i,r||(o=await this.getProvider(i,l),o&&!o.permissionsError&&(s=await this.getDistribution(i,o,l))),{...a,provider:o,distribution:s}}async query(e,t,n){const{backend:l,provider:i}=n,r=e.adapterFor("keymgmt/provider"),a=i?r.buildKeysURL(n):this.url(l)
return this.ajax(a,"GET",{data:{list:!0}}).then((e=>(e.backend=l,e)))}async rotateKey(e,t){const n=this.store.peekRecord("keymgmt/key",t),l=await this.ajax(this.url(e,t,"ROTATE"),"PUT")
return await n.reload(),l}removeFromProvider(e){const t=`${this.buildURL()}/${e.backend}/kms/${e.provider}/key/${e.name}`
return this.ajax(t,"DELETE").then((()=>{e.provider=null}))}},u=r.prototype,c="store",d=[i.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,r)
var u,c,d,p,f,m})),define("vault/adapters/keymgmt/provider",["exports","vault/adapters/application","rsvp"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1"),l(this,"listPayload",{data:{list:!0}})}pathForType(){return"kms"}buildURL(e,t,n,l,i){let r=super.buildURL(...arguments)
return n?r=r.replace("kms",`${n.attr("backend")}/kms`):i&&(r=r.replace("kms",`${i.backend}/kms`)),r}buildKeysURL(e){return`${this.buildURL("keymgmt/provider",null,null,"query",e)}/${e.provider}/key`}async createRecord(e,{modelName:t},n){const l=e.serializerFor(t).serialize(n),i=this.buildURL(t,n.attr("name"),n,"updateRecord")
return this.ajax(i,"PUT",{data:l}).then((()=>l))}findRecord(e,t,n){return super.findRecord(...arguments).then((e=>(e.data={...e.data,name:n},e)))}async query(e,t,l){const{backend:i}=l,r=this.buildURL(t.modelName,null,null,"query",l)
return this.ajax(r,"GET",this.listPayload).then((async r=>{const a=await(0,n.all)(r.data.keys.map((n=>this.findRecord(e,t,n,this._mockSnapshot(l.backend)))))
return r.data.keys=a.map((e=>e.data)),r.backend=i,r}))}async queryRecord(e,t,n){return this.findRecord(e,t,n.id,this._mockSnapshot(n.backend))}_mockSnapshot(e){return{attr:t=>"backend"===t?e:null}}}e.default=i})),define("vault/adapters/kmip/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e.replace("kmip/",""),_url(e,t={},l){const{backend:i,scope:r,role:a}=t,o=this.pathForType(e)
let s
switch(o){case"scope":s=`${(0,n.encodePath)(i)}/scope`
break
case"role":s=`${(0,n.encodePath)(i)}/scope/${(0,n.encodePath)(r)}/role`
break
case"credential":s=`${(0,n.encodePath)(i)}/scope/${(0,n.encodePath)(r)}/role/${(0,n.encodePath)(a)}/credential`}return l&&"credential"===o?`/v1/${s}/lookup?serial_number=${(0,n.encodePath)(l)}`:l?`/v1/${s}/${(0,n.encodePath)(l)}`:`/v1/${s}`},urlForQuery(e,t){return this._url(t,e)+"?list=true"},query(e,t,n){return this.ajax(this.urlForQuery(n,t.modelName),"GET").then((e=>{const{...t}=n
return e._requestQuery=t,e}))},queryRecord(e,t,n){const l=n.id
return delete n.id,this.ajax(this._url(t.modelName,n,l),"GET").then((e=>(e.id=l,e={...e,...n})))},buildURL(e,t,n,l,i){return"createRecord"===l?this._super(...arguments):this._super(`${e}`,t,n,l,i)}})})),define("vault/adapters/kmip/ca",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({urlForFindRecord(e,t,n){const l=this.pathForType(t)
return this.buildURL(e,l,n)}})})),define("vault/adapters/kmip/config",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({_url(e,t,n){const l=this.pathForType(t)
return this.buildURL(e,l,n)},urlForFindRecord(){return this._url(...arguments)},urlForCreateRecord(e,t){return this._url(t.id,e,t)},urlForUpdateRecord(){return this._url(...arguments)}})})),define("vault/adapters/kmip/credential",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){let l=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return l=`${l}/generate`,this.ajax(l,"POST",{data:n.serialize()}).then((e=>(e.data.id=e.data.serial_number,e)))},deleteRecord(e,t,n){let l=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return l=`${l}/revoke`,this.ajax(l,"POST",{data:{serial_number:n.id}})}})})),define("vault/adapters/kmip/role",["exports","vault/adapters/kmip/base","@ember/string","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){const l=n.id||n.attr("name"),i=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},l)
return this.ajax(i,"POST",{data:this.serialize(n)}).then((()=>({id:l,name:l,backend:n.record.backend,scope:n.record.scope})))},deleteRecord(e,t,n){const l=n.id||n.attr("name"),i=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},l)
return this.ajax(i,"DELETE")},serialize(e){const t=e.serialize(),i=e.record.nonOperationFields.map(n.decamelize),r=(0,l.getProperties)(t,i)
for(const n in r)null==r[n]&&delete r[n]
return t.operation_all?{operation_all:!0,...r}:t.operation_none?{operation_none:!0,...r}:(delete t.operation_none,delete t.operation_all,t)},updateRecord(){return this.createRecord(...arguments)}})})),define("vault/adapters/kmip/scope",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){const l=n.attr("name")
return this.ajax(this._url(t.modelName,{backend:n.record.backend},l),"POST").then((()=>({id:l,name:l})))},deleteRecord(e,t,n){let l=this._url(t.modelName,{backend:n.record.backend},n.id)
return l=`${l}?force=true`,this.ajax(l,"DELETE")}})})),define("vault/adapters/kubernetes/config",["exports","vault/adapters/secrets-engine-path"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"path","config")}checkConfigVars(e){return this.ajax(`${this._getURL(e,"check")}`,"GET")}}e.default=l})),define("vault/adapters/kubernetes/role",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{getURL(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t?`${l}/${t}`:l}urlForQuery({backend:e}){return this.getURL(e)}urlForUpdateRecord(e,t,n){return this.getURL(n.attr("backend"),e)}urlForDeleteRecord(e,t,n){return this.getURL(n.attr("backend"),e)}query(e,t,n){const{backend:l}=n
return this.ajax(this.getURL(l),"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({name:e,backend:l})))))}queryRecord(e,t,n){const{backend:l,name:i}=n
return this.ajax(this.getURL(l,i),"GET").then((e=>(e.data.backend=l,e.data.name=i,e.data)))}generateCredentials(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}/creds/${t.role}`
return delete t.role,this.ajax(l,"POST",{data:t}).then((e=>{const{lease_id:t,lease_duration:n,data:l}=e
return{lease_id:t,lease_duration:n,...l}}))}}e.default=l})),define("vault/adapters/kv/config",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}urlForFindRecord(e){return`${this.buildURL()}/${e}/config`}}e.default=l})),define("vault/adapters/kv/data",["exports","vault/adapters/application","vault/utils/kv-path","@ember/debug","vault/lib/control-group-error"],(function(e,t,n,l,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(...e){super(...e),r(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${e}`}createRecord(e,t,l){const{backend:i,path:r}=l.record,a=this._url((0,n.kvDataPath)(i,r))
return this.ajax(a,"POST",{data:this.serialize(l)}).then((e=>({data:{id:(0,n.kvDataPath)(i,r,e.data.version),backend:i,path:r,...e.data}})))}fetchSubkeys(e,t,l){const i=this._url((0,n.kvSubkeysPath)(e,t,l))
return this.ajax(i,"GET").then((e=>e.data)).catch((n=>this.parseErrorOrResponse(n,{backend:e,path:t},!0)))}fetchWrapInfo(e){const{backend:t,path:l,version:i,wrapTTL:r}=e,a=(0,n.kvDataPath)(t,l,i)
return this.ajax(this._url(a),"GET",{wrapTTL:r}).then((e=>e.wrap_info))}patchSecret(e,t,l,i){const r=this._url((0,n.kvDataPath)(e,t)),a={options:{cas:i},data:l}
return this.ajax(r,"PATCH",{data:a})}queryRecord(e,t,l){const{backend:i,path:r,version:a}=l
let o=(0,n.kvDataPath)(i,r,a)
return this.ajax(this._url(o),"GET").then((e=>(a||(o=(0,n.kvDataPath)(i,r,e.data.metadata.version)),{...e,data:{id:o,backend:i,path:r,...e.data}}))).catch((e=>this.parseErrorOrResponse(e,{id:o,backend:i,path:r,version:a})))}deleteRecord(e,t,l){const{backend:i,path:r}=l.record,{deleteType:a,deleteVersions:o}=l.adapterOptions
if(!i||!r)throw new Error("The request to delete or undelete is missing required attributes.")
switch(a){case"delete-latest-version":return this.ajax(this._url((0,n.kvDataPath)(i,r)),"DELETE")
case"delete-version":return this.ajax(this._url((0,n.kvDeletePath)(i,r)),"POST",{data:{versions:o}})
case"destroy":return this.ajax(this._url((0,n.kvDestroyPath)(i,r)),"PUT",{data:{versions:o}})
case"undelete":return this.ajax(this._url((0,n.kvUndeletePath)(i,r)),"POST",{data:{versions:o}})}}handleResponse(e,t,n,l){return 404===e&&n.data?.metadata?super.handleResponse(200,t,n,l):super.handleResponse(...arguments)}parseErrorOrResponse(e,t,n=!1){if(e instanceof i.default)throw e
const l=e.httpStatus
if(403===l)return{data:{...t,fail_read_error_code:l}}
if(e.data)return n?e.data:{...e,data:{...t,...e.data}}
throw e}}e.default=a})),define("vault/adapters/kv/metadata",["exports","vault/adapters/application","vault/utils/kv-path"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${e}`}createRecord(e,t,l){const{backend:i,path:r}=l.record,a=(0,n.kvMetadataPath)(i,r),o=this._url(a),s=this.serialize(l)
return this.ajax(o,"POST",{data:s}).then((()=>({id:a,data:s})))}updateRecord(e,t,l){const{backend:i,path:r}=l.record,a=(0,n.kvMetadataPath)(i,r),o=this._url(a),s=this.serialize(l)
return this.ajax(o,"POST",{data:s}).then((()=>({id:a,data:s})))}query(e,t,l){const{backend:i,pathToSecret:r}=l
return this.ajax(this._url((0,n.kvMetadataPath)(i,r)),"GET",{data:{list:!0}}).then((e=>(e.backend=i,e.path=r,e)))}queryRecord(e,t,l){const{backend:i,path:r}=l,a=(0,n.kvMetadataPath)(i,r)
return this.ajax(this._url(a),"GET").then((e=>({id:a,...e,data:{backend:i,path:r,...e.data}})))}deleteRecord(e,t,l){const{backend:i,path:r,fullSecretPath:a}=l.record
return this.ajax(this._url((0,n.kvMetadataPath)(i,a||r)),"DELETE")}deleteMetadata(e,t){return this.ajax(this._url((0,n.kvMetadataPath)(e,t)),"DELETE")}}e.default=i})),define("vault/adapters/ldap/config",["exports","vault/adapters/secrets-engine-path"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"path","config")}async rotateRoot(e){return this.ajax(this._getURL(e,"rotate-root"),"POST")}}e.default=l})),define("vault/adapters/ldap/library",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{_getURL(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}/library`
return t?`${l}/${t}`:l}urlForUpdateRecord(e,t,n){return this._getURL(n.attr("backend"),e)}urlForDeleteRecord(e,t,n){const{backend:l,completeLibraryName:i}=n.record
return this._getURL(l,i)}query(e,t,n){const{backend:l,path_to_library:i}=n,r=this._getURL(l,i)
return this.ajax(r,"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({name:e,backend:l,path_to_library:i}))))).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}queryRecord(e,t,n){const{backend:l,name:i}=n
return this.ajax(this._getURL(l,i),"GET").then((e=>({...e.data,backend:l,name:i})))}fetchStatus(e,t){const n=`${this._getURL(e,t)}/status`
return this.ajax(n,"GET").then((e=>{const n=[]
for(const l in e.data){const i={...e.data[l],account:l,library:t}
n.push(i)}return n}))}checkOutAccount(e,t,n){const l=`${this._getURL(e,t)}/check-out`
return this.ajax(l,"POST",{data:{ttl:n}}).then((e=>{const{lease_id:t,lease_duration:n,renewable:l}=e,{service_account_name:i,password:r}=e.data
return{account:i,password:r,lease_id:t,lease_duration:n,renewable:l}}))}checkInAccount(e,t,n){const l=`${this._getURL(e,t)}/check-in`
return this.ajax(l,"POST",{data:{service_account_names:n}}).then((e=>e.data))}}e.default=l})),define("vault/adapters/ldap/role",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","@ember/service","@ember-data/adapter/error","vault/helpers/add-to-array","vault/utils/sort-objects"],(function(e,t,n,l,i,r,a){var o,s
function u(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.ldapRoleID=e.default=void 0
const c=(e,t)=>`type:${e}::name:${t}`
e.ldapRoleID=c
e.default=(o=class extends t.default{constructor(...e){var t,n,l,i
super(...e),u(this,"namespace","v1"),t=this,n="flashMessages",i=this,(l=s)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}_constructRecord({backend:e,name:t,type:n}){return{id:c(n,t),backend:e,name:t,type:n}}_getURL(e,t,l){const i=`${this.buildURL()}/${(0,n.encodePath)(e)}/${t}`
return l?`${i}/${l}`:i}_pathForRoleType(e,t){return"static"===e?t?"static-cred":"static-role":t?"creds":"role"}_createOrUpdate(e,t,n){const{backend:l,name:i,type:r}=n.record,a=n.serialize()
return this.ajax(this._getURL(l,this._pathForRoleType(r),i),"POST",{data:a}).then((()=>({data:this._constructRecord({backend:l,name:i,type:r})})))}createRecord(){return this._createOrUpdate(...arguments)}updateRecord(){return this._createOrUpdate(...arguments)}urlForDeleteRecord(e,t,n){const{backend:l,type:i,completeRoleName:r}=n.record
return this._getURL(l,this._pathForRoleType(i),r)}async query(e,t,n,l,i){const{showPartialError:r,roleAncestry:a}=i.adapterOptions||{},{backend:o}=n
return a?this._querySubdirectory(o,a):this._queryAll(o,r)}async _queryAll(e,t){let n=[]
const l=[]
for(const i of["static","dynamic"]){const t=this._getURL(e,this._pathForRoleType(i))
try{const l=await this.ajax(t,"GET",{data:{list:!0}}).then((t=>t.data.keys.map((t=>this._constructRecord({backend:e,name:t,type:i})))))
n=(0,r.addManyToArray)(n,l)}catch(o){404!==o.httpStatus&&l.push(o)}}if(l.length){const e=l.reduce(((e,t)=>(t.errors.forEach((n=>{e.push(`${t.path}: ${n}`)})),e)),[])
if(2===l.length){const t=new i.default(e)
throw t.message="Error fetching roles:",t}t&&this.flashMessages.info(`Error fetching roles from ${e.join(", ")}`)}return{data:{keys:(0,a.default)(n,"name")}}}async _querySubdirectory(e,t){const{path_to_role:n,type:l}=t,i=`${this._getURL(e,this._pathForRoleType(l))}/${n}`,r=await this.ajax(i,"GET",{data:{list:!0}}).then((t=>t.data.keys.map((t=>({...this._constructRecord({backend:e,name:t,type:l}),path_to_role:n})))))
return{data:{keys:(0,a.default)(r,"name")}}}queryRecord(e,t,n){const{backend:l,name:i,type:r}=n,a=this._getURL(l,this._pathForRoleType(r),i)
return this.ajax(a,"GET").then((e=>({...e.data,...this._constructRecord({backend:l,name:i,type:r})})))}fetchCredentials(e,t,n){const l=this._getURL(e,this._pathForRoleType(t,!0),n)
return this.ajax(l,"GET").then((e=>{if("dynamic"===t){const{lease_id:n,lease_duration:l,renewable:i}=e
return{...e.data,lease_id:n,lease_duration:l,renewable:i,type:t}}return{...e.data,type:t}}))}rotateStaticPassword(e,t){const n=this._getURL(e,"rotate-role",t)
return this.ajax(n,"POST")}},d=o.prototype,p="flashMessages",f=[l.service],m={configurable:!0,enumerable:!0,writable:!0,initializer:null},b={},Object.keys(m).forEach((function(e){b[e]=m[e]})),b.enumerable=!!b.enumerable,b.configurable=!!b.configurable,("value"in b||b.initializer)&&(b.writable=!0),b=f.slice().reverse().reduce((function(e,t){return t(d,p,e)||e}),b),h&&void 0!==b.initializer&&(b.value=b.initializer?b.initializer.call(h):void 0,b.initializer=void 0),s=void 0===b.initializer?(Object.defineProperty(d,p,b),null):b,o)
var d,p,f,m,h,b})),define("vault/adapters/lease",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({revokePrefix(e){let t=this.buildURL()+"/leases/revoke-prefix/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},forceRevokePrefix(e){let t=this.buildURL()+"/leases/revoke-force/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},renew(e,t){const n=this.buildURL()+"/leases/renew"
return this.ajax(n,"PUT",{data:{lease_id:e,increment:t}})},deleteRecord(e,t,n){const l=n.id
return this.ajax(this.buildURL()+"/leases/revoke","PUT",{data:{lease_id:l}})},queryRecord(e,t,n){const{lease_id:l}=n
return this.ajax(this.buildURL()+"/leases/lookup","PUT",{data:{lease_id:l}})},query(e,t,l){const i=l.prefix||""
return this.ajax(this.buildURL()+"/leases/lookup/"+(0,n.encodePath)(i),"GET",{data:{list:!0}}).then((e=>(i&&(e.prefix=i),e)))}})})),define("vault/adapters/license",["exports","vault/adapters/cluster"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"license/status"})})),define("vault/adapters/mfa-login-enforcement",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}pathForType(){return"identity/mfa/login-enforcement"}_saveRecord(e,{modelName:t},n){const l=e.serializerFor(t).serialize(n)
return this.ajax(this.urlForUpdateRecord(n.attr("name"),t,n),"POST",{data:l}).then((()=>l))}createRecord(){return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}query(e,t,n){const l=this.urlForQuery(n,t.modelName)
return this.ajax(l,"GET",{data:{list:!0}})}}e.default=l})),define("vault/adapters/mfa-method",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}pathForType(){return"identity/mfa/method"}createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),{id:i}=n
return this.ajax(this.buildURL(t.modelName,i,n,"POST"),"POST",{data:l}).then((e=>({data:{...l,id:e?.data?.method_id||i}})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}urlForDeleteRecord(e,t,n){return this.buildURL(t,e,n,"POST")}query(e,t,n){const l=this.urlForQuery(n,t.modelName)
return this.ajax(l,"GET",{data:{list:!0}})}buildURL(e,t,n,l){if("POST"===l){const l=`${super.buildURL(e)}/${n.attr("type")}`
return t?`${l}/${t}`:l}return super.buildURL(...arguments)}}e.default=l})),define("vault/adapters/mfa-setup",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{currentTokenGenerate(e){return this.ajax("/v1/identity/mfa/method/totp/generate","POST",{data:e})}adminDestroy(e){return this.ajax("/v1/identity/mfa/method/totp/admin-destroy","POST",{data:e})}}e.default=n}))
define("vault/adapters/named-path",["exports","vault/adapters/application","@ember/debug"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1"),l(this,"saveMethod","POST")}_saveRecord(e,{modelName:t},n){const l=e.serializerFor(t).serialize(n),i=e.serializerFor(t).primaryKey
return this.ajax(this.urlForUpdateRecord(n.attr("name"),t,n),this.saveMethod,{data:l}).then((()=>(l[i]=n.attr(i),l)))}createRecord(){const[e,{modelName:t},n]=arguments,l=n.attr("name")
if(e.hasRecordForId(t,l))throw new Error(`A record already exists with the name: ${l}`)
return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}findRecord(e,t,n){return super.findRecord(...arguments).then((e=>(e.data.name||(e.data.name=n),e)))}async query(e,t,n){const l=this.urlForQuery(n,t.modelName),{paramKey:i,filterFor:r,allowed_client_id:a}=n,o={list:!0,...a&&{allowed_client_id:a}},s=await this.ajax(l,"GET",{data:o})
if(s.data.key_info&&r&&i&&!r.includes("*")){const e=this.filterListResponse(i,r,s.data.key_info)
return{...s,data:e}}return s}filterListResponse(e,t,n){const l=Object.entries(n).filter((n=>{const l=n[1]
return t.includes(l[e])})),i=Object.fromEntries(l)
return{keys:Object.keys(i),key_info:i}}}e.default=i})),define("vault/adapters/namespace",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"namespaces"}urlForFindAll(e,t){return t.adapterOptions&&t.adapterOptions.forUser?`/${this.urlPrefix()}/internal/ui/namespaces`:`/${this.urlPrefix()}/namespaces?list=true`}urlForCreateRecord(e,t){const n=t.attr("path")
return this.buildURL(e,n)}createRecord(e,t,n){const l=n.attr("path")
return super.createRecord(...arguments).then((()=>({id:l})))}findAll(e,t,n,l){return l.adapterOptions&&void 0!==l.adapterOptions.namespace?this.ajax(this.urlForFindAll("namespace",l),"GET",{namespace:l.adapterOptions.namespace}):super.findAll(...arguments)}query(){return this.ajax(`/${this.urlPrefix()}/namespaces?list=true`)}}e.default=n})),define("vault/adapters/node",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/oidc/assignment",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/assignment"}}e.default=n})),define("vault/adapters/oidc/client",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/client"}}e.default=n})),define("vault/adapters/oidc/key",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/key"}rotate(e,t){const n=t?{verification_ttl:t}:{}
return this.ajax(`${this.urlForUpdateRecord(e,"oidc/key")}/rotate`,"POST",{data:n})}}e.default=n})),define("vault/adapters/oidc/provider",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/provider"}}e.default=n})),define("vault/adapters/oidc/scope",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/scope"}}e.default=n})),define("vault/adapters/path-filter-config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url(e){return`${this.buildURL()}/replication/performance/primary/paths-filter/${e}`},findRecord(e,t,n){return this.ajax(this.url(n),"GET").then((e=>(e.id=n,e)))},createRecord(e,t,n){return this.ajax(this.url(n.id),"PUT",{data:this.serialize(n)})},updateRecord(){return this.createRecord(...arguments)},deleteRecord(e,t,n){return this.ajax(this.url(n.id),"DELETE")}})})),define("vault/adapters/permissions",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({query(){const e=this.namespaceService.userRootNamespace??this.namespaceService.path
return this.ajax(this.urlForQuery(),"GET",{namespace:e})},urlForQuery(){return this.buildURL()+"/internal/ui/resultant-acl"}})})),define("vault/adapters/pki/action",["exports","@ember/debug","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n,l){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends l.default{constructor(...e){super(...e),i(this,"namespace","v1")}urlForCreateRecord(e,t){const{type:l}=t.record,{actionType:i,useIssuer:r,issuerRef:a,mount:o}=t.adapterOptions,s=o||t.record.backend
if(!s||!i)throw new Error("URL for create record is missing required attributes")
const u=`${this.buildURL()}/${(0,n.encodePath)(s)}`
switch(i){case"import":return r?`${u}/issuers/import/bundle`:`${u}/config/ca`
case"generate-root":return r?`${u}/issuers/generate/root/${l}`:`${u}/root/generate/${l}`
case"generate-csr":return r?`${u}/issuers/generate/intermediate/${l}`:`${u}/intermediate/generate/${l}`
case"sign-intermediate":return`${u}/issuer/${(0,n.encodePath)(a)}/sign-intermediate`
case"rotate-root":return`${u}/root/rotate/${l}`}}createRecord(e,t,n){const l=e.serializerFor(t.modelName),i=this.urlForCreateRecord(t.modelName,n),r=l.serialize(n,n.adapterOptions.actionType)
return this.ajax(i,"POST",{data:r}).then((e=>({id:e.request_id,...e})))}}e.default=r})),define("vault/adapters/pki/certificate/base",["exports","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{constructor(...e){super(...e),l(this,"namespace","v1")}getURL(e,n){const l=`${this.buildURL()}/${(0,t.encodePath)(e)}`
return n?`${l}/cert/${n}`:`${l}/certs`}fetchByQuery(e){const{backend:t,id:n}=e,l=n?{}:{list:!0}
return this.ajax(this.getURL(t,n),"GET",{data:l}).then((e=>(e.data.backend=t,n&&(e.data.id=n,e.data.serial_number=n),e)))}query(e,t,n){return this.fetchByQuery(n)}queryRecord(e,t,n){return this.fetchByQuery(n)}updateRecord(e,n,l){const{backend:i,serialNumber:r,certificate:a}=l.record,o=r?{serial_number:r}:{certificate:a}
return this.ajax(`${this.buildURL()}/${(0,t.encodePath)(i)}/revoke`,"POST",{data:o}).then((e=>({data:{...this.serialize(l),...e.data}})))}}e.default=i})),define("vault/adapters/pki/certificate/generate",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/certificate/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{urlForCreateRecord(e,n){const{role:l,backend:i}=n.record
if(!l||!i)throw new Error("URL for create record is missing required attributes")
return`${this.buildURL()}/${(0,t.encodePath)(i)}/issue/${(0,t.encodePath)(l)}`}}e.default=l})),define("vault/adapters/pki/certificate/sign",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/certificate/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{urlForCreateRecord(e,n){const{role:l,backend:i}=n.record
if(!l||!i)throw new Error("URL for create record is missing required attributes")
return`${this.buildURL()}/${(0,t.encodePath)(i)}/sign/${(0,t.encodePath)(l)}`}}e.default=l})),define("vault/adapters/pki/config/acme",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{constructor(...e){super(...e),l(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/acme`}}e.default=i})),define("vault/adapters/pki/config/base",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}findRecord(e,t,n){return this.ajax(this._url(n),"GET").then((e=>e.data))}updateRecord(e,t,n){const l=n.serialize()
return this.ajax(this._url(n.record.id),"POST",{data:l})}}e.default=l})),define("vault/adapters/pki/config/cluster",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{constructor(...e){super(...e),l(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/cluster`}}e.default=i})),define("vault/adapters/pki/config/crl",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{constructor(...e){super(...e),l(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/crl`}}e.default=i})),define("vault/adapters/pki/config/urls",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{constructor(...e){super(...e),l(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/urls`}}e.default=i})),define("vault/adapters/pki/issuer",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","rsvp","vault/utils/parse-pki-cert"],(function(e,t,n,l,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(...e){super(...e),r(this,"namespace","v1")}_getBackend(e){const{record:t,adapterOptions:n}=e
return n?.mount||t.backend}optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}}urlForQuery(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}`
return t?`${l}/issuer/${(0,n.encodePath)(t)}`:`${l}/issuers`}async getIssuerMetadata(e,t,n,l,r){const a=l.data.key_info[r]
try{const l=await this.queryRecord(e,t,{id:r,backend:n.backend}),{data:o}=l,s=await(0,i.verifyCertificates)(o.certificate,o.certificate),u=(0,i.parseCertificate)(o.certificate)
return{...a,...o,isRoot:s,parsedCertificate:{common_name:u.common_name}}}catch(o){return{...a,issuer_id:r}}}updateRecord(e,t,n){const{issuerId:l}=n.record,i=this._getBackend(n),r=this.serialize(n),a=this.urlForQuery(i,l)
return this.ajax(a,"POST",{data:r})}query(e,t,n){const{backend:i,isListView:r}=n,a=this.urlForQuery(i)
return this.ajax(a,"GET",this.optionsForQuery()).then((async i=>{if(r&&i.data.keys.length<=10){const r=await(0,l.all)(i.data.keys.map((l=>this.getIssuerMetadata(e,t,n,i,l)))),a={}
return i.data.keys.forEach((e=>{a[e]=r.find((t=>t.issuer_id===e))})),i.data.key_info=a,i}return i}))}queryRecord(e,t,n){const{backend:l,id:i}=n
return this.ajax(this.urlForQuery(l,i),"GET",this.optionsForQuery(i))}deleteAllIssuers(e){const t=`${this.buildURL()}/${(0,n.encodePath)(e)}/root`
return this.ajax(t,"DELETE")}}e.default=a})),define("vault/adapters/pki/key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}_baseUrl(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}`
return t?l+"/key/"+(0,n.encodePath)(t):l+"/keys"}createRecord(e,t,n){const{record:l,adapterOptions:i}=n
let r=this._baseUrl(l.backend)
return r=i.import?`${r}/import`:`${r}/generate/${l.type}`,this.ajax(r,"POST",{data:this.serialize(n)}).then((e=>e))}updateRecord(e,t,n){const{record:l}=n,{key_name:i}=this.serialize(n),r=this._baseUrl(l.backend,l.id)
return this.ajax(r,"POST",{data:{key_name:i}})}query(e,t,n){const{backend:l}=n
return this.ajax(this._baseUrl(l),"GET",{data:{list:!0}})}queryRecord(e,t,n){const{backend:l,id:i}=n
return this.ajax(this._baseUrl(l,i),"GET")}deleteRecord(e,t,n){const{id:l,record:i}=n
return this.ajax(this._baseUrl(i.backend,l),"DELETE")}}e.default=i})),define("vault/adapters/pki/role",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}_urlForRole(e,t){let l=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t&&(l=l+"/"+(0,n.encodePath)(t)),l}_optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}}createRecord(e,t,n){const l=n.attr("name"),i=this._urlForRole(n.record.backend,l)
return this.ajax(i,"POST",{data:this.serialize(n)}).then((()=>({id:l,name:l,backend:n.record.backend})))}updateRecord(e,t,n){const{name:l,backend:i}=n.record,r=this.serialize(n),a=this._urlForRole(i,l)
return this.ajax(a,"POST",{data:r})}fetchByQuery(e,t){const{id:n,backend:l}=t
return this.ajax(this._urlForRole(l,n),"GET",this._optionsForQuery(n)).then((e=>({...e,...{id:n,name:n,backend:l}})))}query(e,t,n){return this.fetchByQuery(e,n)}queryRecord(e,t,n){return this.fetchByQuery(e,n)}deleteRecord(e,t,n){const{id:l,record:i}=n
return this.ajax(this._urlForRole(i.backend,l),"DELETE")}}e.default=i})),define("vault/adapters/pki/sign-intermediate",["exports","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{constructor(...e){super(...e),l(this,"namespace","v1")}createRecord(e,n,l){const i=e.serializerFor(n.modelName),{backend:r,issuerRef:a}=l.record,o=`${this.buildURL()}/${(0,t.encodePath)(r)}/issuer/${(0,t.encodePath)(a)}/sign-intermediate`,s=i.serialize(l,n)
return this.ajax(o,"POST",{data:s}).then((e=>({id:e.request_id,...e})))}}e.default=i})),define("vault/adapters/pki/tidy",["exports","vault/adapters/application","core/utils/timestamp","vault/utils/path-encoding-helpers"],(function(e,t,n,l){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1")}_baseUrl(e){return`${this.buildURL()}/${(0,l.encodePath)(e)}`}createRecord(e,t,l){const{backend:i}=l.record,{tidyType:r}=l.adapterOptions
if("auto"===r)throw new Error("Auto tidy type models are never new, please use findRecord")
const a=`${i}-${n.default.now().toISOString()}`,o=`${this._baseUrl(i)}/tidy`
return this.ajax(o,"POST",{data:this.serialize(l,r)}).then((e=>(e.id=a,e)))}updateRecord(e,t,n){const l=n.record.id,{tidyType:i}=n.adapterOptions
if("manual"===i)throw new Error("Manual tidy type models are always new, please use createRecord")
const r=`${this._baseUrl(l)}/config/auto-tidy`
return this.ajax(r,"POST",{data:this.serialize(n,i)})}findRecord(e,t,n){return this.ajax(`${this._baseUrl(n)}/config/auto-tidy`,"GET").then((e=>e.data))}cancelTidy(e){const t=`${this._baseUrl(e)}`
return this.ajax(`${t}/tidy-cancel`,"POST")}}e.default=r})),define("vault/adapters/policy",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1/sys",pathForType:e=>e.replace("policy","policies"),createOrUpdate(e,t,n){const l=e.serializerFor("policy").serialize(n),i=n.attr("name")
return this.ajax(this.buildURL(t.modelName,i),"PUT",{data:l}).then((()=>({data:{...this.serialize(n),id:i}})))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments)},query(e,t){return this.ajax(this.buildURL(t.modelName),"GET",{data:{list:!0}})}})})),define("vault/adapters/policy/acl",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/policy/egp",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/policy/rgp",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/raft-join",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({urlForCreateRecord:()=>"/v1/sys/storage/raft/join"})})),define("vault/adapters/replication-mode",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({getStatusUrl(e){return this.buildURL()+`/replication/${e}/status`},fetchStatus(e){const t=this.getStatusUrl(e)
return this.ajax(t,"GET",{unauthenticated:!0}).then((e=>e.data))}})}))
define("vault/adapters/role-aws",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",createOrUpdate(e,t,n,l){const{name:i,backend:r}=n.record,a=e.serializerFor(t.modelName).serialize(n,l),o=this.urlForRole(r,i)
return this.ajax(o,"POST",{data:a}).then((e=>{const t=e||{data:{}}
return t.data.name=i,t.data.backend=i,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForRole(n.record.backend,l),"DELETE")},pathForType:()=>"roles",urlForRole(e,t){let l=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t&&(l=l+"/"+(0,n.encodePath)(t)),l},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,t){const{id:n,backend:l}=t
return this.ajax(this.urlForRole(l,n),"GET",this.optionsForQuery(n)).then((e=>({...e,...{id:n,name:n,backend:l}})))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})})),define("vault/adapters/role-jwt",["exports","vault/adapters/application","@ember/service","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),findRecord(e,t,n,i){let[r,a]=JSON.parse(n)
r=(0,l.encodePath)(r)
const o=i?.adapterOptions.namespace,s=`/v1/auth/${r}/oidc/auth_url`
let u=`${window.location.origin}${this.router.urlFor("vault.cluster.oidc-callback",{auth_path:r})}`
return o&&(u=`${window.location.origin}${this.router.urlFor("vault.cluster.oidc-callback",{auth_path:r},{queryParams:{namespace:o}})}`),this.ajax(s,"POST",{data:{role:a,redirect_uri:u}})}})})),define("vault/adapters/role-saml",["exports","vault/adapters/application","@ember/service","vault/utils/path-encoding-helpers","uuid"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),async generateClientChallenge(e){const t=(new TextEncoder).encode(e),n=await crypto.subtle.digest("SHA-256",t),l=new Uint8Array(n)
return btoa(String.fromCharCode.apply(null,l))},async findRecord(e,t,n,l){let[a,o]=JSON.parse(n)
a=r(a)
let s=`${window.location.origin}/v1/`,u=l?.adapterOptions.namespace
u&&(u=r(u),s=s.concat(u,"/")),s=s.concat("auth/",a,"/callback")
const c=(0,i.v4)(),d=await this.generateClientChallenge(c)
return{...(await this.ajax(`/v1/auth/${a}/sso_service_url`,"PUT",{data:{acs_url:s,role:o,client_challenge:d,client_type:"browser"}})).data,client_verifier:c}}})
function r(e){return e=(e=e.replace(/^\//,"")).replace(/\/$/,""),(0,l.encodePath)(e)}})),define("vault/adapters/role-ssh",["exports","rsvp","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",createOrUpdate(e,t,n,l){const{name:i,backend:r}=n.record,a=e.serializerFor(t.modelName).serialize(n,l),o=this.urlForRole(r,i)
return this.ajax(o,"POST",{data:a}).then((e=>{const t=e||{data:{}}
return t.data.name=i,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForRole(n.record.backend,l),"DELETE")},pathForType:()=>"roles",urlForRole(e,t){let n=`${this.buildURL()}/${(0,l.encodePath)(e)}/roles`
return t&&(n=n+"/"+(0,l.encodePath)(t)),n},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,n){const{id:l,backend:i}=n
let r=(0,t.resolve)()
const a=this.ajax(this.urlForRole(i,l),"GET",this.optionsForQuery(l))
return l||(r=this.findAllZeroAddress(e,n)),(0,t.allSettled)([a,r]).then((e=>{if(!e[0].value)throw e[0].reason
const t={id:l,name:l,backend:i,data:{}}
return e.forEach((e=>{e.value&&(e.value.data.roles?t.data={...t.data,zero_address_roles:e.value.data.roles}:t.data={...t.data,...e.value.data})})),t}))},findAllZeroAddress(e,t){const{backend:n}=t,i=`/v1/${(0,l.encodePath)(n)}/config/zeroaddress`
return this.ajax(i,"GET")},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})})),define("vault/adapters/secret-engine",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","vault/helpers/split-object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url(e){const t=`${this.buildURL()}/mounts`
return e?t+"/"+(0,n.encodePath)(e):t},urlForConfig:e=>`/v1/${e}/config`,internalURL(e){let t=`/${this.urlPrefix()}/internal/ui/mounts`
return e&&(t=`${t}/${(0,n.encodePath)(e)}`),t},pathForType:()=>"mounts",async query(e,t,n){let l,i
try{l=await this.ajax(this.internalURL(n.path),"GET"),"kv"===l?.data?.type&&"2"===l?.data?.options?.version&&(i=await this.ajax(this.urlForConfig(n.path),"GET"),l.data={...l.data,...i.data})}catch(r){if(!n.path||!l)throw r}return l},async createRecord(e,t,n){let i=e.serializerFor(t.modelName).serialize(n)
const r=n.attr("path")
if(i.config.id=r,"kv"===i.type&&2===i.options.version){const e=(0,l.splitObject)(i,["max_versions","delete_version_after","cas_required"])
let t;[t,i]=e,i.id||(i.id=r),await this.ajax(this.url(r),"POST",{data:i})
try{await this.ajax(this.urlForConfig(r),"POST",{data:t})}catch(a){}return{data:{...i,path:r+"/",id:r}}}return this.ajax(this.url(r),"POST",{data:i}).then((()=>({data:{...i,path:r+"/",id:r}})))},updateRecord(e,t,l){const{apiPath:i,options:r,adapterMethod:a}=l.adapterOptions
if(a)return this[a](...arguments)
if(i){const a=e.serializerFor(t.modelName).serialize(l),o=(0,n.encodePath)(l.id)
return this.ajax(`/v1/${o}/${i}`,r.isDelete?"DELETE":"POST",{data:a})}},saveZeroAddressConfig(e,t,l){const i=(0,n.encodePath)(l.id),r=e.peekAll("role-ssh").filter((e=>e.zeroAddress)).map((e=>e.id)).join(","),a=`/v1/${i}/config/zeroaddress`,o={roles:r}
return""===r?this.ajax(a,"DELETE"):this.ajax(a,"POST",{data:o})}})})),define("vault/adapters/secret",["exports","@ember/utils","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),{id:i}=n,r=n.record.path
return this.ajax(this.urlForSecret(n.attr("backend"),r||i),"POST",{data:l}).then((()=>(l.id=r||i,l)))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments)},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForSecret(n.attr("backend"),l),"DELETE")},urlForSecret(e,n){let i=`${this.buildURL()}/${(0,l.encodePath)(e)}/`
return(0,t.isEmpty)(n)||(i+=(0,l.encodePath)(n)),i},pathForType:()=>"mounts",optionsForQuery(e,t,n){const l={}
return"query"===t&&(l.list=!0),n?{data:l,wrapTTL:n}:{data:l}},fetchByQuery(e,t){const{id:n,backend:l,wrapTTL:i}=e
return this.ajax(this.urlForSecret(l,n),"GET",this.optionsForQuery(n,t,i)).then((e=>(i||(e.id=n,e.backend=l),e)))},query(e,t,n){return this.fetchByQuery(n,"query")},queryRecord(e,t,n){return this.fetchByQuery(n,"queryRecord")}})})),define("vault/adapters/secrets-engine-path",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}_getURL(e,t){return`${this.buildURL()}/${(0,n.encodePath)(e)}/${t||this.path}`}urlForUpdateRecord(e,t,n){return this._getURL(n.attr("backend"))}urlForDeleteRecord(e){return this._getURL(e)}queryRecord(e,t,n){const{backend:l}=n
return this.ajax(this._getURL(l),"GET").then((e=>(e.backend=l,e)))}createRecord(){return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}_saveRecord(e,{modelName:t},n){const l=e.serializerFor(t).serialize(n),i=e.serializerFor(t).primaryKey,r=this._getURL(n.attr("backend"))
return this.ajax(r,"POST",{data:l}).then((()=>(l[i]=n.attr(i),l)))}}e.default=i})),define("vault/adapters/server",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n="/v1/sys/storage/raft/configuration"
e.default=t.default.extend({urlForFindAll:()=>n,urlForQuery:()=>n,urlForDeleteRecord:()=>"/v1/sys/storage/raft/remove-peer",deleteRecord(e,t,n){const l=n.attr("nodeId")
return this.ajax("/v1/sys/storage/raft/remove-peer","POST",{data:{server_id:l}})}})})),define("vault/adapters/ssh-otp-credential",["exports","vault/adapters/ssh"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url:e=>`/v1/${e.backend}/creds/${e.name}`})})),define("vault/adapters/ssh-sign",["exports","vault/adapters/ssh"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url:e=>`/v1/${e.backend}/sign/${e.name}`})})),define("vault/adapters/ssh",["exports","@ember/debug","vault/adapters/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",url(){},createRecord(e,t,n,l){const i=e.serializerFor(t.modelName).serialize(n,l),r=n.attr("role")
return this.ajax(this.url(r),"POST",{data:i}).then((l=>{l.id=n.id,l.modelName=t.modelName,e.pushPayload(t.modelName,l)}))}})})),define("vault/adapters/ssh/ca-config",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}queryRecord(e,t,l){const{backend:i}=l
return this.ajax(`${this.buildURL()}/${(0,n.encodePath)(i)}/config/ca`,"GET").then((e=>(e.id=i,e.backend=i,e)))}createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),i=n.record.backend
return this.ajax(`${this.buildURL()}/${i}/config/ca`,"POST",{data:l}).then((e=>({...e,id:i})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}deleteRecord(e,t,n){const l=n.record.backend
return this.ajax(`${this.buildURL()}/${l}/config/ca`,"DELETE")}}e.default=i})),define("vault/adapters/sync/association",["exports","vault/adapters/application","@ember/debug","rsvp"],(function(e,t,n,l){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1/sys/sync")}buildURL(e,t,n,l,i={}){const{destinationType:r,destinationName:a}=n?n.attributes():i
if(!r||!a)return`${super.buildURL()}/associations`
const{action:o}=n?.adapterOptions||{},s=o?`/${o}`:""
return`${super.buildURL()}/destinations/${r}/${a}/associations${s}`}query(e,{modelName:t},n){const l=this.buildURL(t,null,null,"query",n)
return this.ajax(l,"GET")}queryAll(){const e=`${this.buildURL("sync/association")}`
return this.ajax(e,"GET",{data:{list:!0}}).then((e=>{const{total_associations:t,total_secrets:n}=e.data
return{total_associations:t,total_secrets:n}}))}async fetchByDestinations(e){const t=e.map((({name:e,type:t})=>this.query(this.store,{modelName:"sync/association"},{destinationName:e,destinationType:t}))),n=await(0,l.all)(t),i=this.store.serializerFor("sync/association")
return n.map((e=>i.normalizeFetchByDestinations(e)))}fetchSyncStatus({mount:e,secretName:t}){const n=`${this.buildURL()}/destinations`
return this.ajax(n,"GET",{data:{mount:e,secret_name:t}}).then((e=>{const{associated_destinations:t}=e.data,n=[]
for(const l in t){const e=t[l]
n.push({destinationType:e.type,destinationName:e.name,syncStatus:e.sync_status,updatedAt:e.updated_at})}return n}))}_setOrRemove(e,{modelName:t},n){const l=this.buildURL(t,null,n),i=n.serialize(),r=e.serializerFor("sync/association")
return this.ajax(l,"POST",{data:i}).then((e=>{const t=Object.values(e.data.associated_secrets).find((e=>e.mount===i.mount&&e.secret_name===i.secret_name)),n=t?r.generateId(t):void 0
return{...t,id:n,destinationName:e.data.store_name,destinationType:e.data.store_type}}))}createRecord(){return this._setOrRemove(...arguments)}updateRecord(){return this._setOrRemove(...arguments)}}e.default=r})),define("vault/adapters/sync/destination",["exports","vault/adapters/application","ember-inflector"],(function(e,t,n){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),l(this,"namespace","v1/sys")}pathForType(e){return"sync/destination"===e?(0,n.pluralize)(e):e}urlForCreateRecord(e,t){const{name:n}=t.attributes()
return`${super.urlForCreateRecord(e,t)}/${n}`}updateRecord(e,{modelName:t},n){const{name:l}=n.attributes()
return this.ajax(`${this.buildURL(t)}/${l}`,"PATCH",{data:n.serialize()})}urlForDeleteRecord(e,t,n){const{name:l,type:i}=n.attributes()
return`${this.buildURL("sync/destinations")}/${i}/${l}?purge=true`}query(e,{modelName:t}){return this.ajax(this.buildURL(t),"GET",{data:{list:!0}})}createRecord(e,t,n){const l=`${n.record.type}:${n.record.name}`
return super.createRecord(...arguments).then((e=>(e.id=l,e)))}async normalizedQuery(){const e=await this.query(this.store,{modelName:"sync/destination"})
return this.store.serializerFor("sync/destination").extractLazyPaginatedData(e)}}e.default=i})),define("vault/adapters/sync/destinations/aws-sm",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/azure-kv",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/gcp-sm",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/gh",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/vercel-project",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/tools",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n=["lookup","wrap","unwrap","rewrap"],l=["random","hash"]
e.default=t.default.extend({toolUrlFor(e){const t=n.includes(e),i=l.includes(e),r=t?"wrapping":"tools"
if(!t&&!i)throw new Error(`Calls to a ${e} endpoint are not currently allowed in the tool adapter`)
return`${this.buildURL()}/${r}/${e}`},toolAction(e,t,n={}){const{wrapTTL:l,clientToken:i}=n,r=this.toolUrlFor(e),a=l?{data:t,wrapTTL:l,clientToken:i}:{data:t,clientToken:i}
return this.ajax(r,"POST",a)}})})),define("vault/adapters/transform",["exports","rsvp","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",createOrUpdate(e,{modelName:t},n){const{backend:l,name:i,type:r}=n.record,a=e.serializerFor(t).serialize(n),o=this.urlForTransformations(l,i,r)
return this.ajax(o,"POST",{data:a}).then((e=>{const t=e||{}
return t.id=i,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForTransformations(n.record.backend,l),"DELETE")},pathForType:()=>"transform",urlForTransformations(e,t,n){const i=`${this.buildURL()}/${(0,l.encodePath)(e)}`,r=n?`${i}/transformations/${n}`:`${i}/transformation`
return t?`${r}/${(0,l.encodePath)(t)}`:r},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,n){const{id:l,backend:i}=n,r=this.ajax(this.urlForTransformations(i,l),"GET",this.optionsForQuery(l))
return(0,t.allSettled)([r]).then((e=>{if(!e[0].value)throw e[0].reason
const t={id:l,name:l,backend:i,data:{}}
return e.forEach((e=>{if(e.value){let n=e.value.data
n.templates&&(n={...n,template:n.templates},delete n.templates),t.data={...t.data,...n}}})),t}))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})})),define("vault/adapters/transform/alphabet",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"alphabet"})})),define("vault/adapters/transform/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e.replace("transform/",""),createOrUpdate(e,t,n){const{backend:l,name:i}=n.record,r=e.serializerFor(t.modelName).serialize(n),a=this.url(l,t.modelName,i)
return this.ajax(a,"POST",{data:r}).then((e=>{const t=e||{data:{}}
return t.data.name=i,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.url(n.record.backend,t.modelName,l),"DELETE")},url(e,t,l){const i=this.pathForType(t),r=`/${this.namespace}/${(0,n.encodePath)(e)}/${(0,n.encodePath)(i)}`
return l?`${r}/${(0,n.encodePath)(l)}`:r+"?list=true"},fetchByQuery(e){const{backend:t,modelName:n,id:l}=e
return this.ajax(this.url(t,n,l),"GET").then((e=>({...e,backend:t,id:l,name:l})))},query(e,t,n){return this.fetchByQuery(n)},queryRecord(e,t,n){return this.ajax(this.url(n.backend,t.modelName,n.id),"GET").then((e=>({id:n.id,name:n.id,...e})))}})})),define("vault/adapters/transform/role",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"role"})})),define("vault/adapters/transform/template",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"template"})})),define("vault/adapters/transform/transformation",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/adapters/transit-key",["exports","vault/adapters/application","ember-inflector","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",createOrUpdate(e,t,n,l){const i=e.serializerFor(t.modelName).serialize(n,l),r=n.attr("name")
let a=this.urlForSecret(n.record.backend,r)
return"update"===l&&(a+="/config"),this.ajax(a,"POST",{data:i}).then((e=>{const t=e||{}
return t.id=r,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForSecret(n.record.backend,l),"DELETE")},pathForType(e){let t
switch(e){case"cluster":t="clusters"
break
case"secret-engine":t="secrets"
break
default:t=(0,n.pluralize)(e)}return t},urlForSecret(e,t){let n=`${this.buildURL()}/${(0,l.encodePath)(e)}/keys/`
return t&&(n+=(0,l.encodePath)(t)),n},urlForAction(e,t,n,i){const r=`${this.buildURL()}/${(0,l.encodePath)(t)}/${e}`
if("hash"===e||"random"===e)return r
if("datakey"===e&&i)return`${r}/${i}/${(0,l.encodePath)(n)}`
if("export"===e&&i){const[e,t]=i,a=`${r}/${e}-key/${(0,l.encodePath)(n)}`
return t?`${a}/${t}`:a}return`${r}/${(0,l.encodePath)(n)}`},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e){const{id:t,backend:n}=e
return this.ajax(this.urlForSecret(n,t),"GET",this.optionsForQuery(t)).then((e=>(e.id=t,e.backend=n,e)))},query(e,t,n){return this.fetchByQuery(n)},queryRecord(e,t,n){return this.fetchByQuery(n)},keyAction(e,{backend:t,id:n,payload:l},i={}){const r="export"===e?"GET":"POST",{wrapTTL:a}=i
if("rotate"===e)return this.ajax(this.urlForSecret(t,n)+"/rotate",r)
const{param:o}=l
return delete l.param,this.ajax(this.urlForAction(e,t,n,o),r,{data:l,wrapTTL:a})}})})),define("vault/app",["exports","@ember/application","ember-resolver","ember-load-initializers","vault/config/environment"],(function(e,t,n,l,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(...e){super(...e),r(this,"modulePrefix",i.default.modulePrefix),r(this,"podModulePrefix",i.default.podModulePrefix),r(this,"Resolver",n.default),r(this,"engines",{"config-ui":{dependencies:{services:["auth","flash-messages","namespace","router","store","version","custom-messages"]}},"open-api-explorer":{dependencies:{services:["auth","flash-messages","namespace","router","version"]}},replication:{dependencies:{services:["auth","capabilities","flash-messages","namespace","replication-mode","router","store","version","-portal"],externalRoutes:{replication:"vault.cluster.replication.index",vault:"vault.cluster"}}},kmip:{dependencies:{services:["auth","download","flash-messages","namespace","path-help","router","store","version","secret-mount-path"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},kubernetes:{dependencies:{services:["router","store","secret-mount-path","flash-messages"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},ldap:{dependencies:{services:["router","store","secret-mount-path","flash-messages","auth"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},kv:{dependencies:{services:["capabilities","control-group","download","flash-messages","namespace","router","secret-mount-path","store","version"],externalRoutes:{secrets:"vault.cluster.secrets.backends",syncDestination:"vault.cluster.sync.secrets.destinations.destination"}}},pki:{dependencies:{services:["auth","download","flash-messages","namespace","path-help","router","secret-mount-path","store","version"],externalRoutes:{secrets:"vault.cluster.secrets.backends",externalMountIssuer:"vault.cluster.secrets.backend.pki.issuers.issuer.details",secretsListRootConfiguration:"vault.cluster.secrets.backend.configuration"}}},sync:{dependencies:{services:["flash-messages","flags","router","store","version"],externalRoutes:{kvSecretOverview:"vault.cluster.secrets.backend.kv.secret.index",clientCountOverview:"vault.cluster.clients"}}}})}}e.default=a,(0,l.default)(a,i.default.modulePrefix)})),define("vault/breakpoints",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={mobile:"(max-width: 768px)",tablet:"(min-width: 769px)",desktop:"(min-width: 1088px)"}})),define("vault/component-managers/glimmer",["exports","@glimmer/component/-private/ember-component-manager"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/alert-inline",["exports","core/components/alert-inline"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/alphabet-edit",["exports","@ember/component","vault/components/transform-edit-base","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"kkge6QLF",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@baseKey","@path","@mode","@root","@showCurrent"],[[28,[37,2],null,[["display","id"],[[30,0,["model","id"]],[30,0,["model","idForNav"]]]]],"vault.cluster.secrets.backend.list",[30,0,["mode"]],[30,0,["root"]],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,4],[[30,0,["mode"]],"create"],null],[[[1,"        Create Alphabet\\n"]],[]],[[[41,[28,[37,4],[[30,0,["mode"]],"edit"],null],[[[1,"        Edit Alphabet\\n"]],[]],[[[1,"        Alphabet\\n        "],[10,"code"],[12],[1,[30,0,["model","id"]]],[13],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[28,[37,4],[[30,0,["mode"]],"show"],null],[[[1,"  "],[8,[39,5],null,null,[["default"],[[[[1,"\\n    "],[8,[39,6],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["capabilities","canDelete"]],[[[1,"        "],[8,[39,7],[[24,0,"toolbar-button"],[4,[38,8],["click",[28,[37,9],[[30,0],"delete"],null]],null]],[["@text","@color"],["Delete alphabet","secondary"]],null],[1,"\\n        "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[30,0,["capabilities","canUpdate"]],[[[1,"        "],[8,[39,10],null,[["@secret","@mode","@replace"],[[28,[37,11],[[30,0,["model","idPrefix"]],[30,0,["model","id"]]],null],"edit",true]],[["default"],[[[[1,"\\n          Edit alphabet\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,12],[[28,[37,4],[[30,0,["mode"]],"edit"],null],[28,[37,4],[[30,0,["mode"]],"create"],null]],null],[[[1,"  "],[10,"form"],[15,"onsubmit",[28,[37,9],[[30,0],"createOrUpdate",[30,0,["mode"]]],null]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,13],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n      "],[8,[39,14],null,[["@mode","@noun"],[[30,0,["mode"]],"transform alphabet"]],null],[1,"\\n"],[42,[28,[37,16],[[28,[37,16],[[30,0,["model","attrs"]]],null]],null],null,[[[41,[28,[37,17],[[28,[37,4],[[30,2,["name"]],"name"],null],[28,[37,4],[[30,0,["mode"]],"edit"],null]],null],[[[1,"          "],[10,"label"],[15,"for",[30,2,["name"]]],[14,0,"is-label"],[12],[1,"\\n            "],[1,[30,2,["options","label"]]],[1,"\\n          "],[13],[1,"\\n"],[41,[30,2,["options","subText"]],[[[1,"            "],[10,2],[14,0,"sub-text"],[12],[1,[30,2,["options","subText"]]],[13],[1,"\\n"]],[]],null],[1,"          "],[10,"input"],[15,1,[30,2,["name"]]],[14,"autocomplete","off"],[14,"spellcheck","false"],[15,2,[28,[37,12],[[28,[37,18],[[30,0,["model"]],[30,2,["name"]]],null],[30,0,["model","id"]]],null]],[14,"readonly",""],[14,0,"field input is-readOnly"],[15,4,[30,2,["type"]]],[12],[13],[1,"\\n"]],[]],[[[1,"          "],[8,[39,19],null,[["@attr","@model"],[[30,2],[30,0,["model"]]]],null],[1,"\\n"]],[]]]],[2]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,20],null,null,[["default"],[[[[1,"\\n        "],[8,[39,7],[[24,4,"submit"]],[["@text"],[[52,[28,[37,4],[[30,0,["mode"]],"create"],null],"Create alphabet","Save"]]],null],[1,"\\n"],[41,[28,[37,4],[[30,0,["mode"]],"create"],null],[[[1,"          "],[8,[39,7],null,[["@text","@color","@route","@model","@query"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,0,["model","backend"]],[28,[37,2],null,[["tab"],["alphabet"]]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,7],null,[["@text","@color","@route","@models","@query"],["Cancel","secondary","vault.cluster.secrets.backend.show",[28,[37,21],[[30,0,["model","backend"]],[28,[37,11],["alphabet/",[30,0,["model","id"]]],null]],null],[28,[37,2],null,[["tab"],["alphabet"]]]]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[41,[30,0,["model","displayErrors"]],[[[1,"    "],[10,0],[14,0,"has-top-margin-s"],[12],[1,"\\n      "],[8,[39,13],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n"],[42,[28,[37,16],[[28,[37,16],[[30,0,["model","attrs"]]],null]],null],null,[[[41,[28,[37,4],[[30,3,["type"]],"object"],null],[[[1,"        "],[8,[39,22],null,[["@label","@value"],[[28,[37,23],[[28,[37,12],[[30,3,["options","label"]],[28,[37,24],[[28,[37,25],[[30,3,["name"]]],null]],null]],null]],null],[28,[37,26],[[28,[37,18],[[30,0,["model"]],[30,3,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,3,["type"]],"array"],null],[[[1,"        "],[8,[39,22],null,[["@label","@value","@type","@isLink"],[[28,[37,23],[[28,[37,12],[[30,3,["options","label"]],[28,[37,24],[[28,[37,25],[[30,3,["name"]]],null]],null]],null]],null],[28,[37,18],[[30,0,["model"]],[30,3,["name"]]],null],[30,3,["type"]],[28,[37,4],[[30,3,["name"]],"transformations"],null]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,22],null,[["@label","@value"],[[28,[37,23],[[28,[37,12],[[30,3,["options","label"]],[28,[37,24],[[28,[37,25],[[30,3,["name"]]],null]],null]],null]],null],[28,[37,18],[[30,0,["model"]],[30,3,["name"]]],null]]],null],[1,"\\n      "]],[]]]],[]]]],[3]],null],[1,"  "],[13],[1,"\\n"]],[]]]],["p","attr","attr"],false,["page-header","key-value-header","hash","if","eq","toolbar","toolbar-actions","hds/button","on","action","toolbar-secret-link","concat","or","message-error","namespace-reminder","each","-track-array","and","get","form-field","hds/button-set","array","info-table-row","capitalize","humanize","dasherize","stringify"]]',moduleName:"vault/components/alphabet-edit.hbs",isStrictMode:!1})
class r extends n.default{}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/app-footer",["exports","@ember/component","@ember/service","@glimmer/component","vault/config/environment","@ember/template-factory"],(function(e,t,n,l,i,r){var a,o
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,r.createTemplateFactory)({id:"EamfqKGo",block:'[[[8,[39,0],[[24,0,"has-margin-top-auto"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["ExtraBefore"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["isDevelopment"]],[[[1,"      "],[10,0],[14,0,"env-banner"],[12],[1,"\\n        "],[10,0],[14,0,"level-item notification"],[12],[1,"\\n          "],[8,[39,2],null,[["@name"],["git-branch"]],null],[8,[39,2],null,[["@name"],["pencil-tool"]],null],[1,"\\n          Local development\\n          "],[8,[39,2],null,[["@name"],["pencil-tool"]],null],[8,[39,2],null,[["@name"],["git-branch"]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n  "],[8,[30,1,["Link"]],null,[["@href"],[[28,[37,3],[[30,0,["version","version"]]],null]]],[["default"],[[[[1,"\\n    Vault\\n    "],[1,[30,0,["version","version"]]],[1,"\\n  "]],[]]]]],[1,"\\n"],[41,[30,0,["version","isCommunity"]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@href"],["https://hashicorp.com/products/vault/trial?source=vaultui"]],[["default"],[[[[1,"\\n      Upgrade to Vault Enterprise\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[8,[30,1,["Link"]],null,[["@href"],[[28,[37,4],["/vault"],null]]],[["default"],[[[[1,"\\n    Documentation\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["LegalLinks"]],null,null,null],[1,"\\n  "],[8,[30,1,["ExtraAfter"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["isDevelopment"]],[[[1,"      "],[8,[39,5],[[24,"target","_blank"]],[["@text","@isIconOnly","@icon","@color","@route"],["Contributing docs",true,"gift","tertiary","docs"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[1]]]]]],["AF"],false,["hds/app-footer","if","icon","changelog-url-for","doc-link","hds/button"]]',moduleName:"vault/components/app-footer.hbs",isStrictMode:!1})
let u=e.default=(a=class extends l.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="version",i=this,(l=o)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get isDevelopment(){return"development"===i.default.environment}},c=a.prototype,d="version",p=[n.service],f={configurable:!0,enumerable:!0,writable:!0,initializer:null},h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),o=void 0===h.initializer?(Object.defineProperty(c,d,h),null):h,a)
var c,d,p,f,m,h;(0,t.setComponentTemplate)(s,u)})),define("vault/components/auth-config-form/config",["exports","@ember/component","@ember-data/adapter/error","@ember/service","@glimmer/component","ember-concurrency","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"gmQpbhwk",block:'[[[11,"form"],[4,[38,0],["submit",[28,[37,1],[[30,0,["saveModel"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,2],null,[["@mode","@noun"],["save","Auth Method"]],null],[1,"\\n    "],[8,[39,3],null,[["@model"],[[30,1]]],null],[1,"\\n"],[41,[30,1,["attrs"]],[[[42,[28,[37,6],[[28,[37,6],[[30,1,["attrs"]]],null]],null],null,[[[1,"        "],[8,[39,7],null,[["@attr","@model"],[[30,2],[30,1]]],null],[1,"\\n"]],[2]],null]],[]],[[[41,[30,1,["fieldGroups"]],[[[1,"      "],[8,[39,8],null,[["@model","@mode"],[[30,1],[30,0,["mode"]]]],null],[1,"\\n    "]],[]],null]],[]]],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,9],[[16,"disabled",[30,0,["saveModel","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["saveModel","isRunning"]],"loading"]]],null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@model","attr"],false,["on","perform","namespace-reminder","message-error","if","each","-track-array","form-field","form-field-groups","hds/button"]]',moduleName:"vault/components/auth-config-form/config.hbs",isStrictMode:!1})
let m=e.default=(s=class extends i.default{constructor(...e){super(...e),d(this,"flashMessages",u,this),d(this,"router",c,this)}*saveModel(e){e.preventDefault()
try{yield this.args.model.save()}catch(t){if(t instanceof n.default==!1)throw t
return}this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")}},u=p(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(s.prototype,"saveModel",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(s.prototype,"saveModel"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/auth-config-form/options",["exports","@ember/component","@ember-data/adapter/error","vault/components/auth-config-form/config","@ember/service","ember-concurrency","@ember/test-waiters","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u){var c,d,p,f
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,u.createTemplateFactory)({id:"hPeaeOne",block:'[[[11,"form"],[4,[38,0],["submit",[28,[37,1],[[30,0,["saveModel"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,2],null,[["@model","@errorMessage"],[[30,1],[30,0,["errorMessage"]]]],null],[1,"\\n    "],[8,[39,3],null,[["@mode","@noun"],["save","Auth Method"]],null],[1,"\\n\\n"],[42,[28,[37,5],[[28,[37,5],[[30,1,["tuneAttrs"]]],null]],null],null,[[[41,[28,[37,7],[[28,[37,8],[[30,2,["name"]],[30,1,["userLockoutConfig","modelAttrs"]]],null]],null],[[[1,"        "],[8,[39,9],null,[["@attr","@model"],[[30,2],[30,1]]],null],[1,"\\n"]],[]],null]],[2]],null],[1,"\\n"],[41,[30,1,["supportsUserLockoutConfig"]],[[[1,"      "],[10,"hr"],[14,0,"has-top-margin-xl has-bottom-margin-l has-background-gray-200"],[12],[13],[1,"\\n      "],[8,[39,10],null,[["@tag","@size","@weight"],["h2","400","bold"]],[["default"],[[[[1,"User lockout configuration"]],[]]]]],[1,"\\n      "],[8,[39,11],[[24,0,"has-bottom-margin-m"]],[["@tag","@size","@color"],["p","100","faint"]],[["default"],[[[[1,"\\n        Specifies the user lockout settings for this auth mount.\\n      "]],[]]]]],[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,1,["tuneAttrs"]]],null]],null],null,[[[41,[28,[37,8],[[30,3,["name"]],[30,1,["userLockoutConfig","modelAttrs"]]],null],[[[1,"          "],[8,[39,9],null,[["@attr","@model"],[[30,3],[30,1]]],null],[1,"\\n"]],[]],null]],[3]],null]],[]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,12],[[16,"disabled",[30,0,["saveModel","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Update options",[52,[30,0,["saveModel","isRunning"]],"loading"]]],null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@model","attr","attr"],false,["on","perform","message-error","namespace-reminder","each","-track-array","if","not","includes","form-field","hds/text/display","hds/text/body","hds/button"]]',moduleName:"vault/components/auth-config-form/options.hbs",isStrictMode:!1})
let y=e.default=(c=class extends l.default{constructor(...e){super(...e),m(this,"flashMessages",d,this),m(this,"router",p,this),m(this,"errorMessage",f,this)}*saveModel(e){e.preventDefault(),this.errorMessage=null
const t=this.args.model.config.serialize()
t.description=this.args.model.description,this.args.model.supportsUserLockoutConfig&&(t.user_lockout_config={},this.args.model.userLockoutConfig.apiParams.forEach((e=>{Object.keys(t).includes(e)&&(t.user_lockout_config[e]=t[e],delete t[e])}))),"token"===this.args.model.methodType&&delete t.token_type
try{yield this.args.model.tune(t)}catch(l){if(l instanceof n.default)return void(this.errorMessage=(0,s.default)(l))
throw l}this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")}},d=h(c.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(c.prototype,"router",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h(c.prototype,"errorMessage",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h(c.prototype,"saveModel",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"saveModel"),c.prototype),c);(0,t.setComponentTemplate)(b,y)})),define("vault/components/auth-form-options",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/components/auth-form",["exports","@ember/runloop","@ember/service","@ember/object/computed","@ember/string","@ember/component","@ember/object","vault/helpers/supported-auth-backends","ember-concurrency","@ember/test-waiters","uuid"],(function(e,t,n,l,i,r,a,o,s,u,c){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d={token:null,username:null,password:null,customPath:null}
e.default=r.default.extend(d,{router:(0,n.service)(),auth:(0,n.service)(),flashMessages:(0,n.service)(),store:(0,n.service)(),csp:(0,n.service)("csp-event"),version:(0,n.service)(),selectedAuth:null,methods:null,cluster:null,namespace:null,wrappedToken:null,oldNamespace:null,authMethods:(0,a.computed)("version.isEnterprise",(function(){return this.version.isEnterprise?(0,o.allSupportedAuthBackends)():(0,o.supportedAuthBackends)()})),didReceiveAttrs(){this._super(...arguments)
const{wrappedToken:e,oldWrappedToken:n,oldNamespace:l,namespace:i,selectedAuth:r,oldSelectedAuth:a}=this;(0,t.next)((()=>{e||null!==l&&l===i||this.fetchMethods.perform(),this.isDestroyed||this.isDestroying||(this.set("oldNamespace",i),e&&!n&&(this.unwrapToken.perform(e),this.set("oldWrappedToken",e)),a&&a!==r&&this.resetDefaults(),this.set("oldSelectedAuth",r))}))},didRender(){this._super(...arguments)
const e=this.element.querySelector("li.is-active")
e&&e.scrollIntoView(),(0,t.next)((()=>{const e=this.firstMethod()
!this.wrappedToken&&(this.fetchMethods.isIdle&&e&&!this.selectedAuth||this.selectedAuth&&!this.selectedAuthBackend)&&this.set("selectedAuth",e)}))},firstMethod(){const e=this.methodsToShow[0]
if(e)return e.path||e.type},resetDefaults(){this.setProperties(d)},getAuthBackend(e){const{wrappedToken:t,methods:n,selectedAuth:l,selectedAuthIsPath:i}=this,r=e||l
return n||t?i&&!e?n.find((e=>e.path===r)):this.authMethods.find((e=>e.type===r)):{}},selectedAuthIsPath:(0,l.match)("selectedAuth",/\/$/),selectedAuthBackend:(0,a.computed)("wrappedToken","methods","methods.[]","selectedAuth","selectedAuthIsPath",(function(){return this.getAuthBackend()})),providerName:(0,a.computed)("selectedAuthBackend.type",(function(){if(!this.selectedAuthBackend)return
let e=this.selectedAuthBackend.type||"token"
e=e.toLowerCase()
return(0,i.dasherize)(e)})),cspError:(0,a.computed)("csp.connectionViolations.length",(function(){return this.csp.connectionViolations.length?"This is a standby Vault node but can't communicate with the active node via request forwarding. Sign in at the active node to use the Vault UI.":""})),allSupportedMethods:(0,a.computed)("methodsToShow","hasMethodsWithPath","authMethods",(function(){const e=this.hasMethodsWithPath,t=this.methodsToShow
return e?t.concat(this.authMethods):t})),hasMethodsWithPath:(0,a.computed)("methodsToShow",(function(){return this.methodsToShow.isAny("path")})),methodsToShow:(0,a.computed)("methods","authMethods",(function(){const e=(this.methods||[]).filter((e=>this.authMethods.find((t=>t.type.toLowerCase()===e.type.toLowerCase()))))
return e.length?e:this.authMethods})),unwrapToken:(0,s.task)((0,u.waitFor)((function*(e){this.set("selectedAuth","token")
const t=this.store.adapterFor("tools")
try{const n=yield t.toolAction("unwrap",null,{clientToken:e})
this.set("token",n.auth.client_token),this.send("doSubmit")}catch(n){this.set("error",`Token unwrap failed: ${n.errors[0]}`)}}))),fetchMethods:(0,s.task)((0,u.waitFor)((function*(){const e=this.store
try{const n=yield e.findAll("auth-method",{adapterOptions:{unauthenticated:!0}})
this.set("methods",n.map((e=>{const t=e.serialize({includeId:!0})
return{...t,mountDescription:t.description}}))),(0,t.next)((()=>{e.unloadAll("auth-method")}))}catch(n){this.set("error",`There was an error fetching Auth Methods: ${n.errors[0]}`)}}))),showLoading:(0,l.or)("isLoading","authIsRunning","fetchMethods.isRunning","unwrapToken.isRunning"),actions:{doSubmit(e,t,n){t&&t.preventDefault(),n&&this.set("token",n),this.set("error",null)
const l=n?this.getAuthBackend("token"):this.selectedAuthBackend||{},i=(this.authMethods.find((e=>(e.type||"").toLowerCase()===(l.type||"").toLowerCase()))||{}).formAttributes||[],r=this.getProperties(...i)
return e&&Object.assign(r,e),(this.customPath||l.id)&&(r.path=this.customPath||l.id),"okta"===l.type&&(r.nonce=(0,c.v4)(),r.path||(r.path="okta")),this.performAuth(l.type,r)},handleError(e){this.setProperties({isLoading:!1,error:e?this.auth.handleError(e):null})}}})})),define("vault/components/auth-jwt",["exports","ember","@ember/service","vault/components/outer-html","ember-concurrency","@ember/runloop"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.ERROR_WINDOW_CLOSED=e.ERROR_MISSING_PARAMS=e.ERROR_JWT_LOGIN=void 0
const a=e.ERROR_WINDOW_CLOSED="The provider window was closed before authentication was complete. Your web browser may have blocked or closed a pop-up window. Please check your settings and click Sign In to try again.",o=e.ERROR_MISSING_PARAMS="The callback from the provider did not supply all of the required parameters.  Please click Sign In to try again. If the problem persists, you may want to contact your administrator.",s=e.ERROR_JWT_LOGIN="OIDC login is not configured for this mount"
e.default=l.default.extend({store:(0,n.service)(),flagsService:(0,n.service)("flags"),selectedAuthPath:null,selectedAuthType:null,roleName:null,role:null,errorMessage:null,isOIDC:!0,onRoleName(){},onLoading(){},onError(){},onNamespace(){},didReceiveAttrs(){this._super(...arguments)
const e=this._authPath!==this.selectedAuthPath,t=this._authType!==this.selectedAuthType
if(e||t){const t=e?500:0;(0,r.debounce)(this,"fetchRole",t)}this._authPath=this.selectedAuthPath,this._authType=this.selectedAuthType},getWindow(){return this.window||window},async fetchRole(){const e=this.selectedAuthPath||this.selectedAuthType,t=JSON.stringify([e,this.roleName])
this.setProperties({role:null,errorMessage:null,isOIDC:!0})
try{const e=await this.store.findRecord("role-jwt",t,{adapterOptions:{namespace:this.namespace}})
this.set("role",e)}catch(n){const e=(n.errors||[])[0],t=400===n.httpStatus?"Invalid role. Please try again.":`Error fetching role: ${e}`
this.setProperties({isOIDC:e!==s,errorMessage:t})}},cancelLogin(e,t){this.closeWindow(e),this.handleOIDCError(t)},closeWindow(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()},handleOIDCError(e){this.onLoading(!1),this.prepareForOIDC.cancelAll(),this.onError(e)},prepareForOIDC:(0,i.task)((function*(e){const t=this.getWindow()
for(this.onLoading(!0),this.watchPopup.perform(e),this.watchCurrent.perform(e);;){const n=yield(0,i.waitForEvent)(t,"message")
if(n.origin===t.origin&&n.isTrusted&&"oidc-callback"===n.data.source)return this.exchangeOIDC.perform(n.data,e)}})),watchPopup:(0,i.task)((function*(e){for(;;){const n=t.default.testing?50:500
if(yield(0,i.timeout)(n),!e||e.closed)return this.handleOIDCError(a)}})),watchCurrent:(0,i.task)((function*(e){yield(0,i.waitForEvent)(this.getWindow(),"beforeunload"),e.close()})),exchangeOIDC:(0,i.task)((function*(e,t){if(null==e)return
this.onLoading(!0)
let{namespace:n,path:l,state:i,code:r}=e
if(""===n||this.flagsService.hvdManagedNamespaceRoot){const e=i.indexOf(",ns=")
e>=0&&(n=i.substring(e+4),i=i.substring(0,e))}if(!l||!i||!r)return this.cancelLogin(t,o)
const a=this.store.adapterFor("auth-method")
let s
this.onNamespace(n)
try{s=yield a.exchangeOIDC(l,i,r),this.closeWindow(t)}catch(d){return this.cancelLogin(t,d)}const{mfa_requirement:u,client_token:c}=s.auth
yield this.onSubmit({mfa_requirement:u},null,c)})),async startOIDCAuth(){this.onError(null),await this.fetchRole()
const e=this.role&&!this.role.authUrl?"Missing auth_url. Please check that allowed_redirect_uris for the role include this mount path.":this.errorMessage||null
if(e)this.onError(e)
else{const e=this.getWindow(),t=500,n=600,l=e.screen.width/2-t/2,i=e.screen.height/2-n/2,r=e.open(this.role.authUrl,"vaultOIDCWindow",`width=${t},height=${n},resizable,scrollbars=yes,top=${i},left=${l}`)
this.prepareForOIDC.perform(r)}},actions:{onRoleChange(e){this.onRoleName(e.target.value),(0,r.debounce)(this,"fetchRole",500)},signIn(e){if(e.preventDefault(),this.isOIDC)this.startOIDCAuth()
else{const{jwt:e,roleName:t}=this
this.onSubmit({role:t,jwt:e})}}}})})),define("vault/components/auth-saml",["exports","@ember/component","@ember/service","ember-concurrency","@glimmer/component","@glimmer/tracking","@ember/object","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s){var u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.ERROR_WINDOW_CLOSED=e.ERROR_MISSING_PARAMS=void 0
const h=(0,s.createTemplateFactory)({id:"VBpLpyE+",block:'[[[41,[30,0,["canLoginSaml"]],[[[1,"  "],[11,"form"],[24,1,"auth-form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["startSAMLAuth"]],[30,1],[28,[37,3],null,[["role"],[[30,2]]]]],null]],null],[12],[1,"\\n    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[10,"label"],[14,"for","role"],[14,0,"is-label"],[12],[1,"Role"],[13],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[11,"input"],[16,2,[30,2]],[24,"placeholder","Default"],[24,"autocomplete","off"],[24,"spellcheck","false"],[24,3,"role"],[24,1,"role"],[24,0,"input"],[24,4,"text"],[4,[38,1],["input",[30,0,["setRole"]]],null],[12],[13],[1,"\\n      "],[13],[1,"\\n      "],[8,[39,4],[[24,0,"has-top-padding-s"]],[["@type","@message"],["info","Leave blank to sign in with the default role if one is configured."]],null],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[12],[1,"\\n      "],[18,5,null],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,6],[[16,"disabled",[30,3]],[24,1,"auth-submit"],[24,4,"submit"]],[["@text","@icon"],["Sign in with SAML provider",[52,[30,3],"loading"]]],null],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[8,[39,7],null,[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n    "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"Nonsecure context detected"]],[]]]]],[1,"\\n    "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,"\\n      Logging in with a SAML auth method requires a browser in a secure context.\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Description"]],[[24,0,"has-top-margin-xs"]],null,[["default"],[[[[1,"\\n      "],[8,[39,8],null,[["@icon","@text","@href"],["external-link","Read more about secure contexts.","https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[4]]]]],[1,"\\n"]],[]]]],["@onSubmit","@roleName","@disabled","A","&default"],false,["if","on","fn","hash","alert-inline","yield","hds/button","hds/alert","hds/link/standalone"]]',moduleName:"vault/components/auth-saml.hbs",isStrictMode:!1}),b=e.ERROR_WINDOW_CLOSED="The provider window was closed before authentication was complete. Your web browser may have blocked or closed a pop-up window. Please check your settings and click Sign In to try again."
e.ERROR_MISSING_PARAMS="The callback from the provider did not supply all of the required parameters. Please click Sign In to try again. If the problem persists, you may want to contact your administrator."
let y=e.default=(u=class extends i.default{constructor(...e){super(...e),f(this,"store",c,this),f(this,"flags",d,this),f(this,"errorMessage",p,this)}getWindow(){return this.window||window}get canLoginSaml(){return this.getWindow().isSecureContext}async fetchRole(e){const t=this.args.selectedAuthPath||this.args.selectedAuthType,n=JSON.stringify([t,e])
return this.store.findRecord("role-saml",n,{adapterOptions:{namespace:this.args.namespace}})}cancelLogin(e,t){this.closeWindow(e),this.handleSAMLError(t),this.exchangeSAMLTokenPollID.cancelAll()}closeWindow(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()}handleSAMLError(e){this.args.onLoading(!1),this.args.onError(e)}*watchPopup(e){for(;;)if(yield(0,l.timeout)(500),!e||e.closed)return this.exchangeSAMLTokenPollID.cancelAll(),this.handleSAMLError(b)}*watchCurrent(e){yield(0,l.waitForEvent)(this.getWindow(),"beforeunload"),e?.close()}*exchangeSAMLTokenPollID(e,t){this.args.onLoading(!0),this.watchPopup.perform(e),this.watchCurrent.perform(e)
const n=this.args.selectedAuthPath||this.args.selectedAuthType,i=this.store.adapterFor("auth-method")
let r
this.args.onNamespace(this.args.namespace)
for(let s=0;s<180;s++){yield(0,l.timeout)(500)
try{if(r=yield i.pollSAMLToken(n,t.tokenPollID,t.clientVerifier),!r?.auth)continue
const{mfa_requirement:l,client_token:a}=r.auth
return yield this.args.onSubmit({mfa_requirement:l},null,a),void this.closeWindow(e)}catch(a){if(401===a.httpStatus)continue
return this.cancelLogin(e,(0,o.default)(a))}}this.cancelLogin(e,"The authentication request has timed out. Please click Sign In to try again.")}setRole(e){this.args.onRoleName(e.target.value)}async startSAMLAuth(e,t,n){this.args.onError(null),this.args.onLoading(!0),n&&n.preventDefault&&n.preventDefault()
const l=t.role
let i
try{i=await this.fetchRole(l)}catch(u){return void this.handleSAMLError(u)}const r=this.getWindow(),a=r.screen.width/2-250,o=r.screen.height/2-300,s=r.open(i.ssoServiceURL,"vaultSAMLWindow",`width=500,height=600,resizable,scrollbars=yes,top=${o},left=${a}`)
this.exchangeSAMLTokenPollID.perform(s,i)}},c=m(u.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(u.prototype,"flags",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(u.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(u.prototype,"watchPopup",[l.task],Object.getOwnPropertyDescriptor(u.prototype,"watchPopup"),u.prototype),m(u.prototype,"watchCurrent",[l.task],Object.getOwnPropertyDescriptor(u.prototype,"watchCurrent"),u.prototype),m(u.prototype,"exchangeSAMLTokenPollID",[l.task],Object.getOwnPropertyDescriptor(u.prototype,"exchangeSAMLTokenPollID"),u.prototype),m(u.prototype,"setRole",[a.action],Object.getOwnPropertyDescriptor(u.prototype,"setRole"),u.prototype),m(u.prototype,"startSAMLAuth",[a.action],Object.getOwnPropertyDescriptor(u.prototype,"startSAMLAuth"),u.prototype),u);(0,t.setComponentTemplate)(h,y)})),define("vault/components/auth/login-form",["exports","@ember/component","@glimmer/component","ember","@ember/service","ember-concurrency","@ember/test-waiters","@glimmer/tracking","@ember/object","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u){var c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,u.createTemplateFactory)({id:"Wh2sTNtB",block:'[[[41,[30,0,["waitingForOktaNumberChallenge"]],[[[1,"  "],[8,[39,1],null,[["@correctAnswer","@hasError","@onReturnToLogin"],[[30,0,["oktaNumberChallengeAnswer"]],[30,0,["authError"]],[30,0,["onCancel"]]]],null],[1,"\\n"]],[]],[[[1,"  "],[8,[39,2],null,[["@wrappedToken","@cluster","@namespace","@selectedAuth","@error","@performAuth","@authIsRunning","@delayIsIdle"],[[30,1],[30,2],[30,3],[30,4],[30,0,["authError"]],[30,0,["performAuth"]],[30,0,["authenticate","isRunning"]],[30,0,["delayAuthMessageReminder","isIdle"]]]],null],[1,"\\n"]],[]]]],["@wrappedToken","@cluster","@namespace","@selectedAuth"],false,["if","okta-number-challenge","auth-form"]]',moduleName:"vault/components/auth/login-form.hbs",isStrictMode:!1})
let v=e.default=(c=class extends n.default{constructor(...e){super(...e),h(this,"auth",d,this),h(this,"authError",p,this),h(this,"oktaNumberChallengeAnswer",f,this),h(this,"waitingForOktaNumberChallenge",m,this)}performAuth(e,t){this.authenticate.unlinked().perform(e,t)}*delayAuthMessageReminder(){l.default.testing?yield(0,r.timeout)(0):yield(0,r.timeout)(5e3)}*authenticate(e,t){const{selectedAuth:n,cluster:{id:l}}=this.args
try{if("okta"===e?this.pollForOktaNumberChallenge.perform(t.nonce,t.path):this.delayAuthMessageReminder.perform(),t?.mfa_requirement){const n=this.auth._parseMfaResponse(t.mfa_requirement)
return void this.args.onSuccess(n,e,t)}const i=yield this.auth.authenticate({clusterId:l,backend:e,data:t,selectedAuth:n})
this.args.onSuccess(i,e,t)}catch(i){this.auth.mfaError||(this.authError=`Authentication failed: ${this.auth.handleError(i)}`)}}*pollForOktaNumberChallenge(e,t){if(yield(0,r.timeout)(1e3),this.authError)return
this.waitingForOktaNumberChallenge=!0
let n=null
for(;null===n;){if(l.default.testing)return
yield(0,r.timeout)(1e3),n=yield this.auth.getOktaNumberChallengeAnswer(e,t)}this.oktaNumberChallengeAnswer=n}onCancel(){this.authError=null,this.oktaNumberChallengeAnswer=null,this.waitingForOktaNumberChallenge=!1,this.authenticate.cancelAll(),this.pollForOktaNumberChallenge.cancelAll()}},d=b(c.prototype,"auth",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(c.prototype,"authError",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=b(c.prototype,"oktaNumberChallengeAnswer",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m=b(c.prototype,"waitingForOktaNumberChallenge",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),b(c.prototype,"performAuth",[s.action],Object.getOwnPropertyDescriptor(c.prototype,"performAuth"),c.prototype),b(c.prototype,"delayAuthMessageReminder",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"delayAuthMessageReminder"),c.prototype),b(c.prototype,"authenticate",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"authenticate"),c.prototype),b(c.prototype,"pollForOktaNumberChallenge",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"pollForOktaNumberChallenge"),c.prototype),b(c.prototype,"onCancel",[s.action],Object.getOwnPropertyDescriptor(c.prototype,"onCancel"),c.prototype),c);(0,t.setComponentTemplate)(y,v)})),define("vault/components/auth/page",["exports","@ember/component","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"H8kmahh9",block:'[[[41,[30,0,["mfaErrors"]],[[[1,"  "],[10,0],[14,0,"has-top-margin-xxl"],[12],[1,"\\n    "],[8,[39,1],[[24,0,"is-shadowless"]],[["@title","@message","@icon","@bottomBorder","@subTitle"],["Unauthorized","Multi-factor authentication is required, but failed. Go back and try again, or contact your administrator.","alert-circle",true,[28,[37,2],[". ",[30,0,["mfaErrors"]]],null]]],[["default"],[[[[1,"\\n      "],[8,[39,3],[[4,[38,4],["click",[30,0,["onMfaErrorDismiss"]]],null]],[["@text","@icon","@color"],["Go back","chevron-left","tertiary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[8,[39,5],null,null,[["header","subHeader","content","footer"],[[[[1,"\\n"],[41,[30,1],[[[1,"        "],[10,0],[14,0,"box is-shadowless is-flex-v-centered"],[12],[1,"\\n          "],[8,[39,6],[[24,"aria-label","Sign in with Hashicorp Vault"]],null,null],[1,"\\n        "],[13],[1,"\\n"]],[]],[[[1,"        "],[10,0],[14,0,"is-flex-v-centered has-bottom-margin-xxl"],[12],[1,"\\n          "],[10,0],[14,0,"brand-icon-large"],[12],[1,"\\n            "],[8,[39,7],null,[["@name","@size","@stretched"],["vault","24",true]],null],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n"],[41,[30,0,["mfaAuthData"]],[[[1,"            "],[8,[39,3],[[4,[38,4],["click",[28,[37,8],[[28,[37,9],[[30,0,["mfaAuthData"]]],null],null],null]],null]],[["@text","@icon","@isIconOnly","@color"],["Back to login","arrow-left",true,"tertiary"]],null],[1,"\\n"]],[]],null],[1,"          "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n            "],[1,[52,[30,0,["mfaAuthData"]],"Authenticate","Sign in to Vault"]],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n"]],[]]],[1,"    "]],[]],[[[1,"\\n"],[41,[28,[37,10],["Namespaces"],null],[[[41,[51,[30,0,["mfaAuthData"]]],[[[1,"          "],[8,[39,12],[[24,0,"toolbar-namespace-picker"]],null,[["default"],[[[[1,"\\n            "],[10,0],[14,0,"field is-horizontal"],[12],[1,"\\n              "],[10,0],[14,0,"field-label is-normal"],[12],[1,"\\n                "],[10,"label"],[14,0,"is-label"],[14,"for","namespace"],[12],[1,"Namespace"],[13],[1,"\\n              "],[13],[1,"\\n"],[41,[30,0,["flags","hvdManagedNamespaceRoot"]],[[[1,"                "],[10,0],[14,0,"field-label"],[12],[1,"\\n                  "],[10,1],[14,0,"has-text-grey"],[12],[1,"/"],[1,[30,0,["flags","hvdManagedNamespaceRoot"]]],[13],[1,"\\n                "],[13],[1,"\\n"]],[]],null],[1,"              "],[10,0],[14,0,"field-body"],[12],[1,"\\n                "],[10,0],[14,0,"field"],[12],[1,"\\n                  "],[10,0],[14,0,"control"],[12],[1,"\\n                    "],[11,"input"],[16,2,[30,0,["namespaceInput"]]],[16,"placeholder",[52,[30,0,["flags","hvdManagedNamespaceRoot"]],"/ (Default)","/ (Root)"]],[24,"autocomplete","off"],[24,"spellcheck","false"],[24,3,"namespace"],[24,1,"namespace"],[24,0,"input"],[16,"disabled",[30,1]],[24,4,"text"],[4,[38,4],["input",[30,0,["handleNamespaceUpdate"]]],null],[12],[13],[1,"\\n                  "],[13],[1,"\\n                "],[13],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null]],[]],null],[1,"    "]],[]],[[[1,"\\n"],[41,[30,0,["mfaAuthData"]],[[[1,"        "],[8,[39,13],null,[["@clusterId","@authData","@onSuccess","@onError"],[[30,2,["id"]],[30,0,["mfaAuthData"]],[30,0,["onMfaSuccess"]],[28,[37,8],[[28,[37,9],[[30,0,["mfaErrors"]]],null]],null]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,14],null,[["@wrappedToken","@cluster","@namespace","@selectedAuth","@onSuccess"],[[30,3],[30,2],[30,4],[30,5],[30,0,["onAuthResponse"]]]],null],[1,"\\n"]],[]]],[1,"    "]],[]],[[[1,"\\n      "],[10,0],[14,0,"has-short-padding"],[12],[1,"\\n        "],[10,2],[14,0,"help has-text-grey-dark"],[12],[1,"\\n"],[41,[30,1],[[[1,"            Once you log in, you will be redirected back to your application. If you require login credentials, contact your\\n            administrator.\\n"]],[]],[[[1,"            Contact your administrator for login credentials.\\n"]],[]]],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],["@oidcProviderQueryParam","@cluster","@wrappedToken","@namespaceQueryParam","@authMethodQueryParam"],false,["if","empty-state","join","hds/button","on","splash-page","logo-edition","icon","fn","mut","has-feature","unless","toolbar","mfa/mfa-form","auth/login-form"]]',moduleName:"vault/components/auth/page.hbs",isStrictMode:!1})
let m=e.default=(o=class extends n.default{constructor(...e){super(...e),d(this,"flags",s,this),d(this,"mfaErrors",u,this),d(this,"mfaAuthData",c,this)}get namespaceInput(){const e=this.args.namespaceQueryParam
if(this.flags.hvdManagedNamespaceRoot){const t=e.split("/")
return t.length>1?(t.shift(),`/${t.join("/")}`):""}return e}handleNamespaceUpdate(e){this.args.onNamespaceUpdate(e.target.value)}onAuthResponse(e,t,n){const{mfa_requirement:l}=e
l?this.mfaAuthData={mfa_requirement:l,backend:t,data:n}:this.args.onAuthSuccess(e)}onMfaSuccess(e){this.args.onAuthSuccess(e)}onMfaErrorDismiss(){this.mfaAuthData=null,this.mfaErrors=null}},s=p(o.prototype,"flags",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"mfaErrors",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"mfaAuthData",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(o.prototype,"handleNamespaceUpdate",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"handleNamespaceUpdate"),o.prototype),p(o.prototype,"onAuthResponse",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"onAuthResponse"),o.prototype),p(o.prototype,"onMfaSuccess",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"onMfaSuccess"),o.prototype),p(o.prototype,"onMfaErrorDismiss",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"onMfaErrorDismiss"),o.prototype),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/autocomplete-input",["exports","core/components/autocomplete-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/b64-toggle",["exports","@ember/object/computed","@ember/utils","@ember/component","@ember/object","vault/utils/b64"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a="base64",o="utf-8"
e.default=l.default.extend({tagName:"button",attributeBindings:["type","data-test-transit-b64-toggle"],type:"button",classNames:["button","b64-toggle"],classNameBindings:["isInput:is-input:is-textarea"],isInput:!0,value:null,initialEncoding:o,_value:"",currentEncoding:"",lastEncoding:"",isBase64:(0,t.equal)("currentEncoding",a),valuesMatch:(0,i.computed)("value","_value",(function(){const{value:e,_value:t}=this
return!((0,n.isBlank)(e)||(0,n.isBlank)(t))&&e===t})),init(){this._super(...arguments)
const e=this.initialEncoding;(0,i.set)(this,"currentEncoding",e),e===a&&((0,i.set)(this,"_value",this.value),(0,i.set)(this,"lastEncoding",a))},didReceiveAttrs(){this._super(),""!==this.value?(this.isBase64&&!this.valuesMatch&&(0,i.set)(this,"currentEncoding",o),this.lastEncoding===a&&this.valuesMatch&&(0,i.set)(this,"currentEncoding",a)):(0,i.set)(this,"currentEncoding",o)},click(){const e=this.value,t=this.currentEncoding===o
if(!e)return
const n=t?(0,r.encodeString)(e):(0,r.decodeString)(e),l=t?a:o;(0,i.set)(this,"value",n),(0,i.set)(this,"_value",n),(0,i.set)(this,"lastEncoding",l),(0,i.set)(this,"currentEncoding",l)}})})),define("vault/components/basic-dropdown-content",["exports","ember-basic-dropdown/components/basic-dropdown-content"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown-trigger",["exports","ember-basic-dropdown/components/basic-dropdown-trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown-wormhole",["exports","ember-basic-dropdown/components/basic-dropdown-wormhole"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown",["exports","ember-basic-dropdown/components/basic-dropdown"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/certificate-card",["exports","core/components/certificate-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/checkbox-grid",["exports","core/components/checkbox-grid"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/chevron",["exports","core/components/chevron"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/choose-pgp-key-form",["exports","core/components/choose-pgp-key-form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/clients/activity",["exports","@glimmer/component","date-fns","core/utils/date-formatters","vault/utils/chart-helpers","core/utils/client-count-utils","@ember/service","core/utils/sanitize-path"],(function(e,t,n,l,i,r,a,o){var s,u
function c(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(s=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="namespace",r=this,(l=u)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0}),c(this,"average",((e,t)=>(0,i.calculateAverage)(e,t)))}get namespacePathForFilter(){const{namespace:e}=this.args,t=this.namespace.currentNamespace
return(0,o.sanitizePath)(e||t||"root")}get byMonthActivityData(){const{activity:e,mountPath:t}=this.args,n=this.namespacePathForFilter
return t?(0,r.filterByMonthDataForMount)(e.byMonth,n,t):e.byMonth}get byMonthNewClients(){return this.byMonthActivityData?this.byMonthActivityData?.map((e=>e?.new_clients)):[]}get isCurrentMonth(){const{activity:e}=this.args,t=(0,l.parseAPITimestamp)(e.responseTimestamp),i=(0,l.parseAPITimestamp)(e.startTime),r=(0,l.parseAPITimestamp)(e.endTime)
return(0,n.isSameMonth)(i,t)&&(0,n.isSameMonth)(r,t)}get isDateRange(){const{activity:e}=this.args
return!(0,n.isSameMonth)((0,l.parseAPITimestamp)(e.startTime),(0,l.parseAPITimestamp)(e.endTime))}get totalUsageCounts(){const{namespace:e,activity:t,mountPath:n}=this.args
return t?.byNamespace&&e&&n?(0,r.filteredTotalForMount)(t.byNamespace,e,n):t?.total}get upgradesDuringActivity(){const{versionHistory:e,activity:t}=this.args
return(0,r.filterVersionHistory)(e,t.startTime,t.endTime)}},d=s.prototype,p="namespace",f=[a.service],m={configurable:!0,enumerable:!0,writable:!0,initializer:null},b={},Object.keys(m).forEach((function(e){b[e]=m[e]})),b.enumerable=!!b.enumerable,b.configurable=!!b.configurable,("value"in b||b.initializer)&&(b.writable=!0),b=f.slice().reverse().reduce((function(e,t){return t(d,p,e)||e}),b),h&&void 0!==b.initializer&&(b.value=b.initializer?b.initializer.call(h):void 0,b.initializer=void 0),u=void 0===b.initializer?(Object.defineProperty(d,p,b),null):b,s)
var d,p,f,m,h,b})),define("vault/components/clients/attribution",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"zAuQOd0S",block:'[[[10,0],[14,0,"chart-wrapper single-chart-grid"],[12],[1,"\\n  "],[10,0],[14,0,"chart-header has-bottom-margin-m"],[12],[1,"\\n    "],[10,"h2"],[14,0,"chart-title"],[12],[1,[28,[35,0],[[30,0,["noun"]]],null]],[1," attribution"],[13],[1,"\\n    "],[10,2],[14,0,"chart-description"],[12],[1,[30,0,["chartText","description"]]],[13],[1,"\\n  "],[13],[1,"\\n"],[41,[30,1],[[[1,"    "],[10,0],[14,0,"chart-container-wide"],[12],[1,"\\n      "],[8,[39,2],null,[["@dataset","@chartLegend"],[[30,0,["topTenAttribution"]],[30,0,["attributionLegend"]]]],null],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"chart-subTitle"],[12],[1,"\\n      "],[10,2],[14,0,"chart-subtext"],[12],[1,[30,0,["chartText","subtext"]]],[13],[1,"\\n    "],[13],[1,"\\n\\n    "],[10,0],[14,0,"data-details-top"],[12],[1,"\\n      "],[10,"h3"],[14,0,"data-details"],[12],[1,"Top "],[1,[30,0,["noun"]]],[13],[1,"\\n      "],[10,2],[14,0,"data-details is-word-break"],[12],[1,[30,0,["topAttribution","label"]]],[13],[1,"\\n    "],[13],[1,"\\n\\n    "],[10,0],[14,0,"data-details-bottom"],[12],[1,"\\n      "],[10,"h3"],[14,0,"data-details"],[12],[1,"Clients in "],[1,[30,0,["noun"]]],[13],[1,"\\n      "],[10,2],[14,0,"data-details"],[12],[1,[28,[35,3],[[30,0,["topAttribution","clients"]]],null]],[13],[1,"\\n    "],[13],[1,"\\n\\n    "],[10,0],[14,0,"legend"],[12],[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,0,["attributionLegend"]]],null]],null],null,[[[1,"        "],[10,1],[15,0,[29,["legend-colors dot-",[30,3]]]],[12],[13],[10,1],[14,0,"legend-label"],[12],[1,[28,[35,0],[[30,2,["label"]]],null]],[13],[1,"\\n"]],[2,3]],null],[1,"    "],[13],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"chart-empty-state"],[12],[1,"\\n      "],[8,[39,6],null,[["@icon","@title","@bottomBorder"],["skip","No data found",true]],null],[1,"\\n    "],[13],[1,"\\n"]],[]]],[1,"  "],[10,0],[14,0,"timestamp"],[12],[1,"\\n"],[41,[30,4],[[[1,"      Updated\\n      "],[1,[28,[35,7],[[30,4],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[13]],["@attribution","legend","idx","@responseTimestamp"],false,["capitalize","if","clients/horizontal-bar-chart","format-number","each","-track-array","empty-state","date-format"]]',moduleName:"vault/components/clients/attribution.hbs",isStrictMode:!1})
class r extends n.default{get noun(){return this.args.noun||"namespace"}get attributionLegend(){const e=[{key:"entity_clients",label:"entity clients"},{key:"non_entity_clients",label:"non-entity clients"},{key:"acme_clients",label:"ACME clients"}]
return this.args.isSecretsSyncActivated&&e.push({key:"secret_syncs",label:"secrets sync clients"}),e}get sortedAttribution(){return this.args.attribution?this.args.attribution?.slice().sort(((e,t)=>t.clients-e.clients)):[]}get topTenAttribution(){return this.sortedAttribution.slice(0,10)}get topAttribution(){return this.sortedAttribution[0]??null}get chartText(){return"namespace"===this.noun?{subtext:"This data shows the top ten namespaces by total clients for the date range selected.",description:"This data shows the top ten namespaces by total clients and can be used to understand where clients are originating. Namespaces are identified by path."}:{subtext:"The total clients used by the mounts for this date range. This number is useful for identifying overall usage volume.",description:"This data shows the top ten mounts by client count within this namespace, and can be used to understand where clients are originating. Mounts are organized by path."}}}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/clients/chart-container",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"DozgApfl",block:'[[[1,"\\n"],[11,0],[24,0,"chart-wrapper single-chart-grid"],[17,1],[12],[1,"\\n  "],[10,0],[14,0,"chart-header has-bottom-margin-xl"],[12],[1,"\\n    "],[10,"h2"],[14,0,"chart-title"],[12],[1,[30,2]],[13],[1,"\\n    "],[10,2],[14,0,"chart-description"],[12],[1,"\\n      "],[1,[30,3]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n\\n"],[41,[30,4],[[[41,[48,[30,9]],[[[1,"      "],[10,0],[14,0,"chart-subTitle"],[12],[1,"\\n        "],[18,9,null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[41,[48,[30,10]],[[[1,"      "],[18,10,null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[48,[30,11]],[[[1,"      "],[10,0],[14,0,"chart-container-wide"],[12],[1,"\\n        "],[18,11,null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[41,[48,[30,12]],[[[1,"      "],[10,0],[14,0,"legend"],[12],[1,"\\n        "],[18,12,null],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[41,[30,5],[[[1,"      "],[10,0],[14,0,"legend"],[12],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,5]],null]],null],null,[[[1,"          "],[10,1],[15,0,[29,["legend-colors dot-",[30,7]]]],[12],[13],[1,"\\n          "],[10,1],[14,0,"legend-label"],[12],[1,[28,[35,5],[[30,6,["label"]]],null]],[13],[1,"\\n"]],[6,7]],null],[1,"      "],[13],[1,"\\n    "]],[]],null]],[]]],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"chart-empty-state chart-container-wide"],[12],[1,"\\n      "],[18,13,null],[1,"\\n    "],[13],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,8],[[[1,"    "],[10,0],[14,0,"timestamp"],[12],[1,"\\n      Updated\\n      "],[1,[28,[35,6],[[30,8],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[13]],["&attrs","@title","@description","@hasChartData","@legend","legend","idx","@timestamp","&subTitle","&stats","&chart","&legend","&emptyState"],false,["if","has-block","yield","each","-track-array","capitalize","date-format"]]',moduleName:"vault/components/clients/chart-container.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/clients/charts/vertical-bar-basic",["exports","@ember/component","@glimmer/component","@glimmer/tracking","vault/utils/chart-helpers","core/helpers/format-number","core/utils/date-formatters","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u
function c(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,o.createTemplateFactory)({id:"sgUMG9+F",block:'[[[10,0],[14,0,"lineal-chart"],[12],[1,"\\n  "],[8,[39,0],null,null,[["default"],[[[[1,"\\n"],[44,[[28,[37,2],null,[["domain","range","padding"],[[30,0,["xDomain"]],[28,[37,3],[0,[30,1]],null],0.1]]],[28,[37,4],null,[["range","domain"],[[28,[37,3],[[30,0,["chartHeight"]],0],null],[30,0,["yDomain"]]]]],[28,[37,4],null,[["range","domain"],[[28,[37,3],[0,[30,0,["chartHeight"]]],null],[30,0,["yDomain"]]]]]],[[[1,"      "],[10,"svg"],[15,"width",[30,1]],[15,"height",[30,0,["chartHeight"]]],[12],[1,"\\n        "],[10,"title"],[12],[1,[30,5]],[13],[1,"\\n\\n"],[41,[28,[37,6],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[1,"          "],[8,[39,7],[[24,0,"lineal-axis"]],[["@scale","@tickCount","@tickPadding","@tickSizeInner","@tickFormat","@orientation","@includeDomain"],[[30,3],"4",10,[28,[37,8],["-",[30,1]],null],[30,0,["formatTicksY"]],"left",false]],null],[1,"\\n          "],[8,[39,7],[[16,"transform",[29,["translate(0,",[30,3,["range","min"]],")"]]],[24,0,"lineal-axis"]],[["@scale","@orientation","@includeDomain","@tickSize","@tickPadding"],[[30,2],"bottom",false,"0",10]],null],[1,"\\n"]],[]],null],[1,"        "],[8,[39,9],[[16,"transform",[29,["translate(",[28,[30,0,["barOffset"]],[[30,2,["bandwidth"]]],null],",0)"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[24,0,"lineal-chart-bar"]],[["@data","@x","@y","@height","@width","@xScale","@yScale","@heightScale"],[[30,0,["chartData"]],"x","y","y",[30,0,["barWidth"]],[30,2],[30,3],[30,4]]],null],[1,"\\n"],[41,[28,[37,6],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[42,[28,[37,11],[[28,[37,11],[[30,0,["chartData"]]],null]],null],null,[[[1,"            "],[11,"rect"],[24,"role","button"],[16,"aria-label",[29,["Show exact counts for ",[30,6,["legendX"]]]]],[24,"x","0"],[24,"y","0"],[16,"height",[30,0,["chartHeight"]]],[16,"width",[30,2,["bandwidth"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[16,"transform",[29,["translate(",[28,[30,2,["compute"]],[[30,6,["x"]]],null],")"]]],[4,[38,12],["mouseover",[28,[37,13],[[28,[37,14],[[30,0,["activeDatum"]]],null],[30,6]],null]],null],[4,[38,12],["mouseout",[28,[37,13],[[28,[37,14],[[30,0,["activeDatum"]]],null],null],null]],null],[12],[13],[1,"\\n"]],[6]],null]],[]],null],[1,"      "],[13],[1,"\\n"],[41,[30,0,["activeDatum"]],[[[1,"        "],[11,0],[24,0,"lineal-tooltip-position chart-tooltip"],[24,"role","status"],[4,[38,15],null,[["--x","--y"],[[28,[30,0,["tooltipX"]],[[28,[30,2,["compute"]],[[30,0,["activeDatum","x"]]],null],[30,2,["bandwidth"]]],null],[28,[30,0,["tooltipY"]],[[28,[30,4,["compute"]],[[30,0,["activeDatum","y"]]],null]],null]]]],[12],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[10,2],[14,0,"bold"],[12],[1,[30,0,["activeDatum","legendX"]]],[13],[1,"\\n            "],[10,2],[12],[1,[30,0,["activeDatum","tooltip"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"chart-tooltip-arrow"],[12],[13],[1,"\\n        "],[13],[1,"\\n"]],[]],null]],[2,3,4]]],[1,"  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n"],[41,[30,7],[[[1,"  "],[10,"details"],[12],[1,"\\n    "],[10,"summary"],[12],[1,"Underlying data"],[13],[1,"\\n    "],[8,[39,16],null,[["@caption"],["Underlying data"]],[["head","body"],[[[[1,"\\n        "],[8,[30,8,["Tr"]],null,null,[["default"],[[[[1,"\\n          "],[8,[30,8,["Th"]],null,null,[["default"],[[[[1,"Month"]],[]]]]],[1,"\\n          "],[8,[30,8,["Th"]],null,null,[["default"],[[[[1,[52,[30,9],[28,[37,17],[[30,9]],null]]],[1," Count"]],[]]]]],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[8]],[[[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,0,["chartData"]]],null]],null],null,[[[1,"          "],[8,[30,10,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,10,["Td"]],null,null,[["default"],[[[[1,[30,11,["legendX"]]]],[]]]]],[1,"\\n            "],[8,[30,10,["Td"]],null,null,[["default"],[[[[1,[30,11,["legendY"]]]],[]]]]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[11]],null],[1,"      "]],[10]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["width","xScale","yScale","hScale","@chartTitle","d","@showTable","H","@dataKey","B","row"],false,["lineal/fluid","let","scale-band","array","scale-linear","if","and","lineal/axis","concat","lineal/bars","each","-track-array","on","fn","mut","style","hds/table","humanize"]]',moduleName:"vault/components/clients/charts/vertical-bar-basic.hbs",isStrictMode:!1})
let p=e.default=(s=class extends n.default{constructor(...e){var t,n,l,r
super(...e),c(this,"barWidth",i.BAR_WIDTH),t=this,n="activeDatum",r=this,(l=u)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0}),c(this,"barOffset",(e=>(e-this.barWidth)/2)),c(this,"tooltipX",((e,t)=>(e+t/2).toString())),c(this,"tooltipY",(e=>e?`${e}`:"0")),c(this,"formatTicksY",(e=>(0,i.numericalAxisLabel)(e)||e.toString()))}get chartHeight(){return this.args.chartHeight||190}get chartData(){return this.args.data.map((e=>{const t=e.timestamp,n=e[this.args.dataKey]??null
return{x:(0,a.parseAPITimestamp)(t,"M/yy"),y:n,tooltip:null===n?"No data":`${(0,r.formatNumber)([n])} ${this.args.dataKey.replace(/_/g," ")}`,legendX:(0,a.parseAPITimestamp)(t,"MMMM yyyy"),legendY:(n??"No data").toString()}}))}get yDomain(){const e=this.chartData.map((e=>e.y)).flatMap((e=>"number"==typeof e?[e]:[])),t=Math.max(...e)
return[0,t<=4?4:t]}get xDomain(){const e=this.chartData.map((e=>e.x))
return new Set(e)}},f=s.prototype,m="activeDatum",h=[l.tracked],b={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}},v={},Object.keys(b).forEach((function(e){v[e]=b[e]})),v.enumerable=!!v.enumerable,v.configurable=!!v.configurable,("value"in v||v.initializer)&&(v.writable=!0),v=h.slice().reverse().reduce((function(e,t){return t(f,m,e)||e}),v),y&&void 0!==v.initializer&&(v.value=v.initializer?v.initializer.call(y):void 0,v.initializer=void 0),u=void 0===v.initializer?(Object.defineProperty(f,m,v),null):v,s)
var f,m,h,b,y,v;(0,t.setComponentTemplate)(d,p)})),define("vault/components/clients/charts/vertical-bar-grouped",["exports","@ember/component","@glimmer/component","@glimmer/tracking","vault/utils/chart-helpers","core/helpers/format-number","core/utils/date-formatters","d3-array","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s){var u,c
function d(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,s.createTemplateFactory)({id:"aotu5Hb7",block:'[[[41,[28,[37,1],[[30,1],[30,2]],null],[[[1,"  "],[10,0],[14,0,"lineal-chart"],[12],[1,"\\n    "],[8,[39,2],null,null,[["default"],[[[[1,"\\n"],[44,[[28,[37,4],null,[["domain","range","padding"],[[30,0,["xBounds"]],[28,[37,5],[0,[30,3]],null],0.1]]],[28,[37,6],null,[["range","domain"],[[28,[37,5],[[30,0,["chartHeight"]],0],null],[30,0,["yBounds"]]]]],[28,[37,6],null,[["range","domain"],[[28,[37,5],[0,[30,0,["chartHeight"]]],null],[30,0,["yBounds"]]]]]],[[[1,"        "],[10,"svg"],[15,"width",[30,3]],[15,"height",[30,0,["chartHeight"]]],[12],[1,"\\n          "],[10,"title"],[12],[1,[30,7]],[13],[1,"\\n\\n"],[41,[28,[37,1],[[30,4,["isValid"]],[30,5,["isValid"]]],null],[[[1,"            "],[8,[39,7],[[24,0,"lineal-axis"]],[["@includeDomain","@orientation","@scale","@tickCount","@tickFormat","@tickPadding","@tickSizeInner"],[false,"left",[30,5],"4",[30,0,["formatTicksY"]],10,[28,[37,8],["-",[30,3]],null]]],null],[1,"\\n            "],[8,[39,7],[[24,0,"lineal-axis"],[16,"transform",[29,["translate(0,",[30,5,["range","min"]],")"]]]],[["@includeDomain","@orientation","@scale","@tickFormat","@tickPadding","@tickSize"],[false,"bottom",[30,4],[30,0,["formatTicksX"]],10,"0"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[30,2]],null]],null],null,[[[1,"            "],[8,[39,11],[[16,0,[29,["lineal-chart-bar custom-bar-",[30,8,["key"]]]]],[16,"transform",[29,["translate(",[28,[30,0,["barOffset"]],[[30,4,["bandwidth"]],[30,9]],null],",0)"]]]],[["@data","@x","@y","@height","@width","@xScale","@yScale","@heightScale"],[[30,1],"timestamp",[30,8,["key"]],[30,8,["key"]],[30,0,["barWidth"]],[30,4],[30,5],[30,6]]],null],[1,"\\n"]],[8,9]],null],[1,"\\n"],[41,[28,[37,1],[[30,4,["isValid"]],[30,5,["isValid"]]],null],[[[42,[28,[37,10],[[28,[37,10],[[30,0,["aggregatedData"]]],null]],null],null,[[[1,"              "],[11,"rect"],[24,"role","button"],[16,"aria-label",[29,["Show exact counts for ",[30,10,["legendX"]]]]],[24,"x","0"],[24,"y","0"],[16,"height",[30,0,["chartHeight"]]],[16,"width",[30,4,["bandwidth"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[16,"transform",[29,["translate(",[28,[30,4,["compute"]],[[30,10,["x"]]],null],")"]]],[4,[38,12],["mouseover",[28,[37,13],[[28,[37,14],[[30,0,["activeDatum"]]],null],[30,10]],null]],null],[4,[38,12],["mouseout",[28,[37,13],[[28,[37,14],[[30,0,["activeDatum"]]],null],null],null]],null],[12],[13],[1,"\\n"]],[10]],null]],[]],null],[1,"        "],[13],[1,"\\n\\n"],[41,[30,0,["activeDatum"]],[[[1,"          "],[11,0],[24,0,"lineal-tooltip-position chart-tooltip"],[24,"role","status"],[4,[38,15],null,[["--x","--y"],[[28,[30,0,["tooltipX"]],[[28,[30,4,["compute"]],[[30,0,["activeDatum","x"]]],null],[30,4,["bandwidth"]]],null],[28,[30,0,["tooltipY"]],[[28,[30,6,["compute"]],[[30,0,["activeDatum","y"]]],null]],null]]]],[12],[1,"\\n            "],[10,0],[12],[1,"\\n              "],[10,2],[14,0,"bold"],[12],[1,[30,0,["activeDatum","legendX"]]],[13],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[30,0,["activeDatum","legendY"]]],null]],null],null,[[[1,"                "],[10,2],[12],[1,[30,11]],[13],[1,"\\n"]],[11]],null],[41,[30,0,["activeDatum","tooltipUpgrade"]],[[[1,"                "],[10,"br"],[12],[13],[1,"\\n                "],[10,2],[14,0,"has-text-highlight"],[12],[1,[30,0,["activeDatum","tooltipUpgrade"]]],[13],[1,"\\n"]],[]],null],[1,"            "],[13],[1,"\\n            "],[10,0],[14,0,"chart-tooltip-arrow"],[12],[13],[1,"\\n          "],[13],[1,"\\n"]],[]],null]],[4,5,6]]],[1,"    "]],[3]]]]],[1,"\\n  "],[13],[1,"\\n\\n"],[41,[30,12],[[[1,"    "],[10,"details"],[12],[1,"\\n      "],[10,"summary"],[12],[1,[30,7]],[1," data"],[13],[1,"\\n      "],[8,[39,16],null,[["@caption"],["Underlying data"]],[["head","body"],[[[[1,"\\n          "],[8,[30,13,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,13,["Th"]],null,null,[["default"],[[[[1,"Timestamp"]],[]]]]],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[30,0,["dataKeys"]]],null]],null],null,[[[1,"              "],[8,[30,13,["Th"]],null,null,[["default"],[[[[1,[28,[35,17],[[30,14]],null]]],[]]]]],[1,"\\n"]],[14]],null],[1,"          "]],[]]]]],[1,"\\n        "]],[13]],[[[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[30,1]],null]],null],null,[[[1,"            "],[8,[30,15,["Tr"]],null,null,[["default"],[[[[1,"\\n              "],[8,[30,15,["Td"]],null,null,[["default"],[[[[1,[30,16,["timestamp"]]]],[]]]]],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[30,0,["dataKeys"]]],null]],null],null,[[[1,"                "],[8,[30,15,["Td"]],null,null,[["default"],[[[[1,[28,[35,18],[[28,[37,19],[[30,16],[30,17]],null],"-"],null]]],[]]]]],[1,"\\n"]],[17]],null],[1,"            "]],[]]]]],[1,"\\n"]],[16]],null],[1,"        "]],[15]]]]],[1,"\\n    "],[13],[1,"\\n"]],[]],null]],[]],[[[1,"  "],[8,[39,20],null,[["@subTitle","@bottomBorder"],["No data to display",true]],null],[1,"\\n"]],[]]]],["@data","@legend","width","xScale","yScale","hScale","@chartTitle","l","idx","d","stat","@showTable","H","key","B","row","key"],false,["if","and","lineal/fluid","let","scale-band","array","scale-linear","lineal/axis","concat","each","-track-array","lineal/bars","on","fn","mut","style","hds/table","humanize","or","get","empty-state"]]',moduleName:"vault/components/clients/charts/vertical-bar-grouped.hbs",isStrictMode:!1})
let f=e.default=(u=class extends n.default{constructor(...e){var t,n,l,r
super(...e),d(this,"barWidth",i.BAR_WIDTH),t=this,n="activeDatum",r=this,(l=c)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0}),d(this,"barOffset",((e,t=0)=>{const n=this.barWidth+4
return(e-n*this.args.legend.length)/2+t*n})),d(this,"tooltipX",((e,t)=>(e+t/2).toString())),d(this,"tooltipY",(e=>e?`${e}`:"0")),d(this,"formatTicksX",(e=>(0,a.parseAPITimestamp)(e,"M/yy"))),d(this,"formatTicksY",(e=>(0,i.numericalAxisLabel)(e)||e.toString()))}get chartHeight(){return this.args.chartHeight||190}get dataKeys(){return this.args.legend.map((e=>e.key))}label(e){return this.args.legend.find((t=>t.key===e))?.label}get chartData(){let e=[]
for(const t of this.dataKeys){const n=this.args.data.map((e=>({timestamp:e.timestamp,clientType:t,[t]:e[t]}))),l=(0,o.flatGroup)(n,(e=>e.timestamp),(e=>e[t]),(e=>e.clientType))
e=[...e,...l]}return e.map((([e,t,n])=>({timestamp:e,counts:t,clientType:n})))}get aggregatedData(){return this.args.data.map((e=>{const t=this.dataKeys.map((t=>e[t])).filter((e=>Number.isInteger(e))),n=t.length?t.reduce(((e,t)=>e>t?e:t),0):null,l=e.timestamp
return{x:l,y:n??0,legendX:(0,a.parseAPITimestamp)(l,"MMMM yyyy"),legendY:null===n?["No data"]:this.dataKeys.map((t=>`${(0,r.formatNumber)([e[t]])} ${this.label(t)}`)),tooltipUpgrade:this.upgradeMessage(e)}}))}get yBounds(){const e=this.aggregatedData.map((e=>e.y)).flatMap((e=>"number"==typeof e?[e]:[])),t=Math.max(...e)
return[0,t<=4?4:t]}get xBounds(){const e=this.args.data.map((e=>e.timestamp))
return new Set(e)}get upgradeByMonthYear(){const e={}
return Array.isArray(this.args.upgradeData)&&this.args.upgradeData?.reduce(((e,t)=>{if(t.timestampInstalled){e[(0,a.parseAPITimestamp)(t.timestampInstalled,"M/yy")]=t}return e}),e)||e}upgradeMessage(e){const t=this.upgradeByMonthYear[e.month]
if(t){const{version:e,previousVersion:n}=t
return`Vault was upgraded\n        ${n?"from "+n:""} to ${e}`}return null}},m=u.prototype,h="activeDatum",b=[l.tracked],y={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}},g={},Object.keys(y).forEach((function(e){g[e]=y[e]})),g.enumerable=!!g.enumerable,g.configurable=!!g.configurable,("value"in g||g.initializer)&&(g.writable=!0),g=b.slice().reverse().reduce((function(e,t){return t(m,h,e)||e}),g),v&&void 0!==g.initializer&&(g.value=g.initializer?g.initializer.call(v):void 0,g.initializer=void 0),c=void 0===g.initializer?(Object.defineProperty(m,h,g),null):g,u)
var m,h,b,y,v,g;(0,t.setComponentTemplate)(p,f)})),define("vault/components/clients/charts/vertical-bar-stacked",["exports","@ember/component","@glimmer/component","@glimmer/tracking","vault/utils/chart-helpers","core/helpers/format-number","core/utils/date-formatters","d3-array","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s){var u,c
function d(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,s.createTemplateFactory)({id:"VLbBtav3",block:'[[[10,0],[14,0,"lineal-chart"],[12],[1,"\\n  "],[8,[39,0],null,null,[["default"],[[[[1,"\\n"],[44,[[28,[37,2],null,[["domain","range","padding"],[[30,0,["xBounds"]],[28,[37,3],[0,[30,1]],null],0.1]]],[28,[37,4],null,[["range","domain"],[[28,[37,3],[[30,0,["chartHeight"]],0],null],[30,0,["yBounds"]]]]],[28,[37,4],null,[["range","domain"],[[28,[37,3],[0,[30,0,["chartHeight"]]],null],[30,0,["yBounds"]]]]]],[[[1,"      "],[10,"svg"],[15,"width",[30,1]],[15,"height",[30,0,["chartHeight"]]],[12],[1,"\\n        "],[10,"title"],[12],[1,[30,5]],[13],[1,"\\n\\n"],[41,[28,[37,6],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[1,"          "],[8,[39,7],[[24,0,"lineal-axis"]],[["@includeDomain","@orientation","@scale","@tickCount","@tickFormat","@tickPadding","@tickSizeInner"],[false,"left",[30,3],"4",[30,0,["formatTicksY"]],10,[28,[37,8],["-",[30,1]],null]]],null],[1,"\\n          "],[8,[39,7],[[24,0,"lineal-axis"],[16,"transform",[29,["translate(0,",[30,3,["range","min"]],")"]]]],[["@includeDomain","@orientation","@scale","@tickFormat","@tickPadding","@tickSize"],[false,"bottom",[30,2],[30,0,["formatTicksX"]],10,"0"]],null],[1,"\\n"]],[]],null],[1,"\\n        "],[8,[39,9],[[16,"transform",[29,["translate(",[28,[30,0,["barOffset"]],[[30,2,["bandwidth"]]],null],",0)"]]]],[["@data","@x","@y","@width","@xScale","@yScale","@color","@colorScale"],[[30,0,["chartData"]],"timestamp","counts",[30,0,["barWidth"]],[30,2],[30,3],"clientType","blue-bar"]],null],[1,"\\n\\n"],[41,[28,[37,6],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[42,[28,[37,11],[[28,[37,11],[[30,0,["aggregatedData"]]],null]],null],null,[[[1,"            "],[11,"rect"],[24,"role","button"],[16,"aria-label",[29,["Show exact counts for ",[30,6,["legendX"]]]]],[24,"x","0"],[24,"y","0"],[16,"height",[30,0,["chartHeight"]]],[16,"width",[30,2,["bandwidth"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[16,"transform",[29,["translate(",[28,[30,2,["compute"]],[[30,6,["x"]]],null],")"]]],[4,[38,12],["mouseover",[28,[37,13],[[28,[37,14],[[30,0,["activeDatum"]]],null],[30,6]],null]],null],[4,[38,12],["mouseout",[28,[37,13],[[28,[37,14],[[30,0,["activeDatum"]]],null],null],null]],null],[12],[13],[1,"\\n"]],[6]],null]],[]],null],[1,"      "],[13],[1,"\\n\\n"],[41,[30,0,["activeDatum"]],[[[1,"        "],[11,0],[24,0,"lineal-tooltip-position chart-tooltip"],[24,"role","status"],[4,[38,15],null,[["--x","--y"],[[28,[30,0,["tooltipX"]],[[28,[30,2,["compute"]],[[30,0,["activeDatum","x"]]],null],[30,2,["bandwidth"]]],null],[28,[30,0,["tooltipY"]],[[28,[30,4,["compute"]],[[30,0,["activeDatum","y"]]],null]],null]]]],[12],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[10,2],[14,0,"bold"],[12],[1,[30,0,["activeDatum","legendX"]]],[13],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,0,["activeDatum","legendY"]]],null]],null],null,[[[1,"              "],[10,2],[12],[1,[30,7]],[13],[1,"\\n"]],[7]],null],[1,"          "],[13],[1,"\\n          "],[10,0],[14,0,"chart-tooltip-arrow"],[12],[13],[1,"\\n        "],[13],[1,"\\n"]],[]],null],[1,"\\n"]],[2,3,4]]],[1,"  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,8],[[[1,"  "],[10,"details"],[12],[1,"\\n    "],[10,"summary"],[12],[1,[30,5]],[1," data"],[13],[1,"\\n    "],[8,[39,16],null,[["@caption"],["Underlying data"]],[["head","body"],[[[[1,"\\n        "],[8,[30,9,["Tr"]],null,null,[["default"],[[[[1,"\\n          "],[8,[30,9,["Th"]],null,null,[["default"],[[[[1,"Timestamp"]],[]]]]],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,0,["dataKeys"]]],null]],null],null,[[[1,"            "],[8,[30,9,["Th"]],null,null,[["default"],[[[[1,[28,[35,17],[[30,10]],null]]],[]]]]],[1,"\\n"]],[10]],null],[1,"        "]],[]]]]],[1,"\\n      "]],[9]],[[[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,12]],null]],null],null,[[[1,"          "],[8,[30,11,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,11,["Td"]],null,null,[["default"],[[[[1,[30,13,["timestamp"]]]],[]]]]],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,0,["dataKeys"]]],null]],null],null,[[[1,"              "],[8,[30,11,["Td"]],null,null,[["default"],[[[[1,[28,[35,18],[[28,[37,19],[[30,13],[30,14]],null],"-"],null]]],[]]]]],[1,"\\n"]],[14]],null],[1,"          "]],[]]]]],[1,"\\n"]],[13]],null],[1,"      "]],[11]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["width","xScale","yScale","hScale","@chartTitle","d","stat","@showTable","H","key","B","@data","row","key"],false,["lineal/fluid","let","scale-band","array","scale-linear","if","and","lineal/axis","concat","lineal/v-bars","each","-track-array","on","fn","mut","style","hds/table","humanize","or","get"]]',moduleName:"vault/components/clients/charts/vertical-bar-stacked.hbs",isStrictMode:!1})
let f=e.default=(u=class extends n.default{constructor(...e){var t,n,l,r
super(...e),d(this,"barWidth",i.BAR_WIDTH),t=this,n="activeDatum",r=this,(l=c)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0}),d(this,"barOffset",(e=>(e-this.barWidth)/2)),d(this,"tooltipX",((e,t)=>(e+t/2).toString())),d(this,"tooltipY",(e=>e?`${e}`:"0")),d(this,"formatTicksX",(e=>(0,a.parseAPITimestamp)(e,"M/yy"))),d(this,"formatTicksY",(e=>(0,i.numericalAxisLabel)(e)||e.toString()))}get chartHeight(){return this.args.chartHeight||190}get dataKeys(){return this.args.chartLegend.map((e=>e.key))}label(e){return this.args.chartLegend.find((t=>t.key===e)).label}get chartData(){let e=[]
for(const t of this.dataKeys){const n=this.args.data.map((e=>({timestamp:e.timestamp,clientType:t,[t]:e[t]}))),l=(0,o.flatGroup)(n,(e=>e.timestamp),(e=>e[t]),(e=>e.clientType))
e=[...e,...l]}return e.map((([e,t,n])=>({timestamp:e,counts:t,clientType:n})))}get aggregatedData(){return this.args.data.map((e=>{const t=this.dataKeys.map((t=>e[t])).filter((e=>Number.isInteger(e))),n=t.length?t.reduce(((e,t)=>e+t),0):null,l=e.timestamp
return{x:l,y:n??0,legendX:(0,a.parseAPITimestamp)(l,"MMMM yyyy"),legendY:null===n?["No data"]:this.dataKeys.map((t=>`${(0,r.formatNumber)([e[t]])} ${this.label(t)}`))}}))}get yBounds(){const e=this.aggregatedData.map((e=>e.y)).flatMap((e=>"number"==typeof e?[e]:[])),t=Math.max(...e)
return[0,t<=4?4:t]}get xBounds(){const e=this.chartData.map((e=>e.timestamp))
return new Set(e)}},m=u.prototype,h="activeDatum",b=[l.tracked],y={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}},g={},Object.keys(y).forEach((function(e){g[e]=y[e]})),g.enumerable=!!g.enumerable,g.configurable=!!g.configurable,("value"in g||g.initializer)&&(g.writable=!0),g=b.slice().reverse().reduce((function(e,t){return t(m,h,e)||e}),g),v&&void 0!==g.initializer&&(g.value=g.initializer?g.initializer.call(v):void 0,g.initializer=void 0),c=void 0===g.initializer?(Object.defineProperty(m,h,g),null):g,u)
var m,h,b,y,v,g;(0,t.setComponentTemplate)(p,f)})),define("vault/components/clients/config",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v=(0,o.createTemplateFactory)({id:"/079Rx4M",block:'[[[41,[28,[37,1],[[30,1],"edit"],null],[[[1,"  "],[10,"form"],[15,"onsubmit",[28,[37,2],[[30,0],"onSaveChanges"],null]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,3],null,[["@model","@errorMessage"],[[30,2],[30,0,["error"]]]],null],[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,2,["formFields"]]],null]],null],null,[[[41,[28,[37,1],[[30,3,["name"]],"enabled"],null],[[[41,[51,[30,2,["reportingEnabled"]]],[[[1,"            "],[10,"label"],[14,0,"is-label"],[12],[1,"Usage data collection"],[13],[1,"\\n            "],[10,2],[14,0,"sub-text"],[12],[1,"\\n              Enable or disable client tracking. Keep in mind that disabling tracking will delete the data for the current\\n              month.\\n            "],[13],[1,"\\n            "],[10,0],[14,0,"control is-flex has-bottom-margin-l"],[12],[1,"\\n              "],[11,"input"],[24,1,"enabled"],[24,3,"enabled"],[24,0,"toggle is-success is-small"],[16,"checked",[28,[37,1],[[30,2,["enabled"]],"On"],null]],[24,4,"checkbox"],[4,[38,7],["change",[30,0,["toggleEnabled"]]],null],[12],[13],[1,"\\n              "],[10,"label"],[14,"for","enabled"],[14,0,"has-text-weight-bold is-size-8"],[12],[1,"\\n                Data collection is\\n                "],[1,[28,[35,8],[[30,2,["enabled"]]],null]],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n"]],[]],null]],[]],[[[1,"          "],[8,[39,9],null,[["@attr","@model","@modelValidations"],[[30,3],[30,2],[30,0,["validations"]]]],null],[1,"\\n"]],[]]]],[3]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,10],null,null,[["default"],[[[[1,"\\n        "],[8,[39,11],[[16,"disabled",[30,0,["buttonDisabled"]]],[24,4,"submit"]],[["@text"],["Save"]],null],[1,"\\n        "],[8,[39,11],null,[["@text","@color","@route"],["Cancel","secondary","vault.cluster.clients.config"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n\\n"],[41,[30,0,["modalOpen"]],[[[1,"    "],[8,[39,12],[[24,1,"clients-config-modal"]],[["@color","@onClose"],["warning",[28,[37,13],[[28,[37,14],[[30,0,["modalOpen"]]],null],false],null]]],[["default"],[[[[1,"\\n      "],[8,[30,4,["Header"]],null,[["@icon"],["alert-triangle"]],[["default"],[[[[1,"\\n        "],[1,[30,0,["modalTitle"]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Body"]],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,1],[[30,2,["enabled"]],"On"],null],[[[1,"          "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n            Vault will start tracking data starting from today’s date,\\n            "],[1,[28,[35,15],[[28,[37,16],null,null],"MMMM d, yyyy"],null]],[1,". If you’ve previously enabled usage tracking, that historical data will\\n            still be available to you.\\n          "],[13],[1,"\\n"]],[]],[[[1,"          "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n            Turning usage tracking off means that all data for the current month will be deleted. You will still be able to\\n            query previous months.\\n          "],[13],[1,"\\n          "],[10,2],[12],[1,"Are you sure?"],[13],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Footer"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,10],null,null,[["default"],[[[[1,"\\n          "],[8,[39,11],[[4,[38,7],["click",[28,[37,17],[[30,0,["save"]]],null]],null]],[["@text"],["Continue"]],null],[1,"\\n          "],[8,[39,11],[[4,[38,7],["click",[30,5,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[5]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n"]],[]],null]],[]],[[[1,"  "],[10,0],[14,0,"tabs-container box is-bottomless is-marginless is-fullwidth is-paddingless"],[12],[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,0,["infoRows"]]],null]],null],null,[[[1,"      "],[8,[39,18],null,[["@label","@helperText","@value"],[[30,6,["label"]],[30,6,["helperText"]],[28,[37,19],[[30,2],[30,6,["valueKey"]]],null]]],null],[1,"\\n"]],[6]],null],[1,"  "],[13],[1,"\\n"]],[]]]],["@mode","@model","attr","M","F","item"],false,["if","eq","action","message-error","each","-track-array","unless","on","lowercase","form-field","hds/button-set","hds/button","hds/modal","fn","mut","date-format","now","perform","info-table-row","get"]]',moduleName:"vault/components/clients/config.hbs",isStrictMode:!1})
let g=e.default=(s=(0,a.task)((function*(){try{yield this.args.model.save(),this.router.transitionTo("vault.cluster.clients.config")}catch(e){this.error=e.message,this.modalOpen=!1}})).drop(),u=class extends n.default{constructor(...e){super(...e),b(this,"router",c,this),b(this,"mode",d,this),b(this,"modalOpen",p,this),b(this,"validations",f,this),b(this,"error",m,this),b(this,"save",h,this)}get infoRows(){return[{label:"Usage data collection",helperText:"Enable or disable collecting data to track clients.",valueKey:"enabled"},{label:"Retention period",helperText:"The number of months of activity logs to maintain for client tracking.",valueKey:"retentionMonths"}]}get modalTitle(){return`Turn usage tracking ${this.args.model.enabled.toLowerCase()}?`}toggleEnabled(e){this.args.model.enabled=e.target.checked?"On":"Off"}onSaveChanges(e){e.preventDefault()
const{isValid:t,state:n}=this.args.model.validate(),l=this.args.model.changedAttributes()
t?l.enabled?this.modalOpen=!0:this.save.perform():this.validations=n}},c=y(u.prototype,"router",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(u.prototype,"mode",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"show"}}),p=y(u.prototype,"modalOpen",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=y(u.prototype,"validations",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(u.prototype,"error",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=y(u.prototype,"save",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y(u.prototype,"toggleEnabled",[l.action],Object.getOwnPropertyDescriptor(u.prototype,"toggleEnabled"),u.prototype),y(u.prototype,"onSaveChanges",[l.action],Object.getOwnPropertyDescriptor(u.prototype,"onSaveChanges"),u.prototype),u);(0,t.setComponentTemplate)(v,g)})),define("vault/components/clients/counts/error",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"kKiBqZqm",block:'[[[8,[39,0],null,[["@title","@subTitle","@icon"],[[52,[28,[37,2],[[30,1,["httpStatus"]],403],null],"You are not authorized","Error"],[29,["Error ",[30,2,["httpStatus"]]]],"skip"]],[["default"],[[[[1,"\\n"],[41,[28,[37,2],[[30,1,["httpStatus"]],403],null],[[[1,"    "],[10,2],[12],[1,"\\n      You must be granted permissions to view this page. Ask your administrator if you think you should have access to the\\n      "],[10,"code"],[12],[1,[30,1,["path"]]],[13],[1,"\\n      endpoint.\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[10,"ul"],[12],[1,"\\n"],[41,[30,1,["message"]],[[[1,"        "],[10,"li"],[12],[1,[30,1,["message"]]],[13],[1,"\\n        "],[10,"hr"],[12],[13],[1,"\\n"]],[]],null],[42,[28,[37,4],[[28,[37,4],[[30,1,["errors"]]],null]],null],null,[[[1,"        "],[10,"li"],[12],[1,"\\n          "],[1,[30,3]],[1,"\\n        "],[13],[1,"\\n"]],[3]],null],[1,"    "],[13],[1,"\\n"]],[]]]],[]]]]]],["@error","@model","error"],false,["empty-state","if","eq","each","-track-array"]]',moduleName:"vault/components/clients/counts/error.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/clients/counts/nav-bar",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"NLjIhRaC",block:'[[[10,"nav"],[14,0,"tabs has-bottom-margin-s"],[14,"aria-label","navigation for managing client counts"],[12],[1,"\\n  "],[10,"ul"],[12],[1,"\\n    "],[10,"li"],[12],[1,"\\n      "],[8,[39,0],null,[["@route"],["vault.cluster.clients.counts.overview"]],[["default"],[[[[1,"\\n        Overview\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n    "],[10,"li"],[12],[1,"\\n      "],[8,[39,0],null,[["@route"],["vault.cluster.clients.counts.token"]],[["default"],[[[[1,"\\n        Entity/Non-entity clients\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n"],[41,[30,1],[[[1,"      "],[10,"li"],[12],[1,"\\n        "],[8,[39,0],null,[["@route"],["vault.cluster.clients.counts.sync"]],[["default"],[[[[1,"\\n          Secrets sync clients\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,"li"],[12],[1,"\\n      "],[8,[39,0],null,[["@route"],["vault.cluster.clients.counts.acme"]],[["default"],[[[[1,"\\n        ACME clients\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["@showSecretsSyncClientCounts"],false,["link-to","if"]]',moduleName:"vault/components/clients/counts/nav-bar.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())}))
define("vault/components/clients/date-range",["exports","@ember/component","@ember/object","@ember/service","@glimmer/component","@glimmer/tracking","core/utils/client-count-utils","core/utils/date-formatters","core/utils/timestamp","date-fns","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u,c){var d,p,f,m,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function v(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,c.createTemplateFactory)({id:"lKH4KJU2",block:'[[[11,0],[17,1],[12],[1,"\\n  "],[8,[39,0],[[24,0,"has-bottom-margin-xs"]],[["@tag"],["p"]],[["default"],[[[[1,"\\n    Client counting period\\n  "]],[]]]]],[1,"\\n  "],[8,[39,1],null,[["@tag","@color","@size"],["p","faint","300"]],[["default"],[[[[1,"\\n    The dashboard displays client count activity during the specified date range below. Click edit to update the date range.\\n  "]],[]]]]],[1,"\\n\\n  "],[10,0],[14,0,"is-flex-align-baseline"],[12],[1,"\\n"],[41,[28,[37,3],[[30,2],[30,3]],null],[[[1,"      "],[10,2],[14,0,"is-size-6"],[12],[1,[28,[30,0,["formattedDate"]],[[30,2]],null]],[13],[1,"\\n      "],[10,2],[14,0,"has-left-margin-xs"],[12],[1," — "],[13],[1,"\\n      "],[10,2],[14,0,"is-size-6 has-left-margin-xs"],[12],[1,[28,[30,0,["formattedDate"]],[[30,3]],null]],[13],[1,"\\n      "],[8,[39,4],[[24,0,"has-left-margin-xs"],[4,[38,5],["click",[28,[37,6],[[28,[37,7],[[30,0,["showEditModal"]]],null],true],null]],null]],[["@text","@color","@icon","@iconPosition"],["Edit","tertiary","edit","trailing"]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,4],[[4,[38,5],["click",[28,[37,6],[[28,[37,7],[[30,0,["showEditModal"]]],null],true],null]],null]],[["@text","@icon"],["Set date range","edit"]],null],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n\\n"],[41,[30,0,["showEditModal"]],[[[1,"    "],[8,[39,8],null,[["@onClose"],[[30,0,["onClose"]]]],[["default"],[[[[1,"\\n      "],[8,[30,4,["Header"]],null,null,[["default"],[[[[1,"\\n        Edit date range\\n      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Body"]],null,null,[["default"],[[[[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          The start date will be used as the client counting start time and all clients in that month will be considered new.\\n"],[41,[30,0,["version","isEnterprise"]],[[[1,"            We recommend setting this date as your license or billing start date to get the most accurate new and total\\n            client count estimations. These dates are only for querying data in storage. Editing the date range does not\\n            change any license or billing configurations.\\n"]],[]],null],[1,"        "],[13],[1,"\\n        "],[10,0],[14,0,"clients-date-range-display"],[12],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[8,[39,9],[[16,"max",[30,0,["currentMonth"]]],[24,1,"start-month"],[24,3,"start"],[4,[38,5],["change",[30,0,["updateDate"]]],null]],[["@type","@value"],["month",[30,0,["startDate"]]]],[["default"],[[[[1,"\\n              "],[8,[30,5,["Label"]],null,null,[["default"],[[[[1,"Start"]],[]]]]],[1,"\\n            "]],[5]]]]],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[8,[39,9],[[16,"max",[30,0,["currentMonth"]]],[24,1,"end-month"],[24,3,"end"],[4,[38,5],["change",[30,0,["updateDate"]]],null]],[["@type","@value"],["month",[30,0,["endDate"]]]],[["default"],[[[[1,"\\n              "],[8,[30,6,["Label"]],null,null,[["default"],[[[[1,"End"]],[]]]]],[1,"\\n            "]],[6]]]]],[1,"\\n          "],[13],[1,"\\n"],[41,[30,0,["version","isEnterprise"]],[[[1,"            "],[8,[39,4],[[4,[38,5],["click",[30,0,["resetDates"]]],null]],[["@text","@color","@icon"],["Reset","tertiary","reload"]],null],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n"],[41,[30,0,["validationError"]],[[[1,"          "],[8,[39,10],[[24,0,"has-top-margin-xs"]],null,[["default"],[[[[1,[30,0,["validationError"]]]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,3],[[30,0,["version","isEnterprise"]],[30,0,["useDefaultDates"]]],null],[[[1,"          "],[8,[39,11],[[24,0,"has-top-margin-xs"]],[["@type","@color"],["compact","highlight"]],[["default"],[[[[1,"\\n            "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"Dashboard will use the default date range from the API."]],[]]]]],[1,"\\n          "]],[7]]]]],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Footer"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,4],[[4,[38,5],["click",[30,0,["handleSave"]]],null]],[["@text"],["Save"]],null],[1,"\\n        "],[8,[39,4],[[4,[38,5],["click",[30,8,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[8]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n"]],[]],null],[13]],["&attrs","@startTime","@endTime","M","F","F","A","F"],false,["hds/text/display","hds/text/body","if","and","hds/button","on","fn","mut","hds/modal","hds/form/text-input/field","hds/form/error","hds/alert"]]',moduleName:"vault/components/clients/date-range.hbs",isStrictMode:!1})
let w=e.default=(d=class extends i.default{constructor(e,t){super(e,t),b(this,"version",p,this),b(this,"showEditModal",f,this),b(this,"startDate",m,this),b(this,"endDate",h,this),y(this,"currentMonth",(0,u.format)(s.default.now(),"yyyy-MM")),y(this,"formattedDate",(e=>(0,o.parseAPITimestamp)(e,"MMMM yyyy"))),this.setTrackedFromArgs()}setTrackedFromArgs(){this.args.startTime&&(this.startDate=(0,o.parseAPITimestamp)(this.args.startTime,"yyyy-MM")),this.args.endTime&&(this.endDate=(0,o.parseAPITimestamp)(this.args.endTime,"yyyy-MM"))}get useDefaultDates(){return!this.startDate&&!this.endDate}get validationError(){return this.useDefaultDates&&this.version.isEnterprise?null:this.startDate&&this.endDate?this.startDate>this.endDate?"Start date must be before end date.":null:"You must supply both start and end dates."}onClose(){this.setTrackedFromArgs(),this.showEditModal=!1}resetDates(){this.startDate="",this.endDate=""}updateDate(e){const{name:t,value:n}=e.target
"end"===t?this.endDate=n:this.startDate=n}handleSave(){if(this.validationError)return
const e={start_time:void 0,end_time:void 0}
if(this.startDate){const[t,n]=this.startDate.split("-")
t&&n&&(e.start_time=(0,a.formatDateObject)({monthIdx:parseInt(n)-1,year:parseInt(t)},!1))}if(this.endDate){const[t,n]=this.endDate.split("-")
t&&n&&(e.end_time=(0,a.formatDateObject)({monthIdx:parseInt(n)-1,year:parseInt(t)},!0))}this.args.onChange(e),this.onClose()}},p=v(d.prototype,"version",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(d.prototype,"showEditModal",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),m=v(d.prototype,"startDate",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h=v(d.prototype,"endDate",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),v(d.prototype,"onClose",[n.action],Object.getOwnPropertyDescriptor(d.prototype,"onClose"),d.prototype),v(d.prototype,"resetDates",[n.action],Object.getOwnPropertyDescriptor(d.prototype,"resetDates"),d.prototype),v(d.prototype,"updateDate",[n.action],Object.getOwnPropertyDescriptor(d.prototype,"updateDate"),d.prototype),v(d.prototype,"handleSave",[n.action],Object.getOwnPropertyDescriptor(d.prototype,"handleSave"),d.prototype),d);(0,t.setComponentTemplate)(g,w)})),define("vault/components/clients/horizontal-bar-chart",["exports","@ember/component","@glimmer/component","@ember/object","d3-shape","d3-selection","d3-scale","d3-axis","d3-array","vault/utils/chart-helpers","@glimmer/tracking","core/helpers/format-number","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u,c,d,p){var f,m,h,b
function y(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function v(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,p.createTemplateFactory)({id:"li1xMc1l",block:'[[[41,[30,1],[[[1,"  "],[11,"svg"],[24,0,"chart is-horizontal"],[4,[38,1],["mouseleave",[30,0,["removeTooltip"]]],null],[4,[38,2],[[30,0,["renderChart"]],[30,1]],null],[4,[38,3],[[30,0,["renderChart"]],[30,1]],null],[12],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[8,[39,4],null,[["@subTitle","@bottomBorder"],[[28,[37,5],[[30,2],"No data to display"],null],true]],null],[1,"\\n"]],[]]],[41,[30,0,["tooltipTarget"]],[[[6,[39,6],null,[["tagName","tetherTarget","targetAttachment","attachment","offset"],["div",[30,0,["tooltipTarget"]],"bottom middle","bottom middle","35px 0"]],[["default"],[[[[1,"    "],[10,0],[15,0,[29,["chart-tooltip ",[52,[30,0,["isLabel"]]," is-label-fit-content"]]]],[12],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["tooltipText"]]],null]],null],null,[[[1,"        "],[10,2],[12],[1,[30,3]],[13],[1,"\\n"]],[3]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"chart-tooltip-arrow"],[12],[13],[1,"\\n"]],[]]]]]],[]],null]],["@dataset","@noDataMessage","text"],false,["if","on","did-insert","did-update","empty-state","or","modal-dialog","each","-track-array"]]',moduleName:"vault/components/clients/horizontal-bar-chart.hbs",isStrictMode:!1}),w=10,k=95,x=14,P=99
let _=e.default=(f=class extends n.default{constructor(...e){super(...e),y(this,"tooltipTarget",m,this),y(this,"tooltipText",h,this),y(this,"isLabel",b,this)}get labelKey(){return this.args.labelKey||"label"}get xKey(){return this.args.xKey||"clients"}get topNamespace(){return this.args.dataset[(0,s.maxIndex)(this.args.dataset,(e=>e[this.xKey]))]}removeTooltip(){this.tooltipTarget=null}renderChart(e,[t]){const n=t,l=(0,i.stack)().keys(this.args.chartLegend.map((e=>e.key)))(n),c=this.labelKey,p=this.xKey,f=(0,a.scaleLinear)().domain([0,(0,s.max)(n.map((e=>e[p])))]).range([0,75]),m=(0,a.scaleBand)().domain(n.map((e=>e[c]))).range([0,24*n.length]).paddingInner(.765),h=(0,r.select)(e)
h.attr("width","100%").attr("viewBox","0 0 564 "+24*(n.length+1))
const b=h.selectAll("g").remove().exit().data(l).enter().append("g").attr("data-test-group",(e=>`${e.key}`)).attr("transform",`translate(${k}, ${w})`).style("fill",((e,t)=>u.BAR_PALETTE[t]));(0,o.axisLeft)(m).tickSize(0)(h.append("g").attr("data-test-group","y-labels").attr("transform",`translate(${k}, ${w})`)),h.select(".domain").remove()
h.selectAll(".tick text").call((e=>e.text((e=>e.length<15?e:e.slice(0,12)+"...")))),b.selectAll("rect").remove().exit().data((e=>e)).enter().append("rect").attr("class","data-bar").style("cursor","pointer").attr("width",(e=>`${f(Math.abs(e[1]-e[0]))}%`)).attr("height",m.bandwidth()).attr("x",(e=>`${f(e[0])}%`)).attr("y",(({data:e})=>m(e[c]))).attr("rx",3).attr("ry",3)
const y=h.append("g").attr("data-test-group","action-bars").selectAll(".action-bar").remove().exit().data(n).enter().append("rect").style("cursor","pointer").attr("class","action-bar").attr("width","100%").attr("height","24px").attr("x","0").attr("y",(e=>m(e[c]))).style("fill",`${u.GREY}`).style("opacity","0").style("mix-blend-mode","multiply"),v=h.append("g").attr("data-test-group","label-action-bars").selectAll(".label-action-bar").remove().exit().data(n).enter().append("rect").style("cursor","pointer").attr("class","label-action-bar").attr("width",k).attr("height","24px").attr("x","0").attr("y",(e=>m(e[c]))).style("opacity","0").style("mix-blend-mode","multiply")
y.on("mouseover",((e,t)=>{const n=e.currentTarget
this.tooltipTarget=n,this.isLabel=!1,this.tooltipText=[],this.args.chartLegend.forEach((({key:e,label:n})=>{this.tooltipText.push(`${(0,d.formatNumber)([t[e]])} ${n}`)})),(0,r.select)(n).style("opacity",1)})).on("mouseout",(function(){(0,r.select)(this).style("opacity",0)})),v.on("mouseover",((e,t)=>{if(t[c].length>=15){const n=e.currentTarget
this.tooltipTarget=n,this.isLabel=!0,this.tooltipText=[t[c]]}else this.tooltipTarget=null})).on("mouseout",(function(){this.tooltipTarget=null}))
h.append("g").attr("data-test-group","total-values").attr("transform",`translate(${P}, ${x})`).selectAll("text").data(n).enter().append("text").text((e=>(0,d.formatNumber)([e[p]]))).attr("fill","#000").attr("class","total-value").style("font-size",".8rem").attr("text-anchor","start").attr("alignment-baseline","middle").attr("x",(e=>`${f(e[p])}%`)).attr("y",(e=>m(e[c])))}},m=v(f.prototype,"tooltipTarget",[c.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h=v(f.prototype,"tooltipText",[c.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),b=v(f.prototype,"isLabel",[c.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v(f.prototype,"removeTooltip",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"removeTooltip"),f.prototype),v(f.prototype,"renderChart",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"renderChart"),f.prototype),f);(0,t.setComponentTemplate)(g,_)})),define("vault/components/clients/no-data",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"lEAT3AEe",block:'[[[41,[28,[37,1],[[30,1,["reportingEnabled"]],[28,[37,2],[[30,1,["enabled"]],"On"],null]],null],[[[1,"  "],[8,[39,3],[[24,0,"is-shadowless"]],[["@title","@message"],[[29,["No data received ",[52,[30,2],[30,2]]]],"Tracking is turned on and Vault is gathering data. It should appear here within 30 minutes."]],null],[1,"\\n"]],[]],[[[41,[30,1],[[[1,"  "],[8,[39,3],[[24,0,"is-shadowless"]],[["@title","@message"],["Data tracking is disabled","Tracking is disabled, and no data is being collected. To turn it on, edit the configuration."]],[["default"],[[[[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"      "],[8,[39,4],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Go to configuration","vault.cluster.clients.config"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,3],[[24,0,"is-shadowless"]],[["@title","@message"],["Activity configuration data is unavailable","Reporting status is unknown and could be enabled or disabled. Check the Vault logs for more information."]],null],[1,"\\n"]],[]]]],[]]]],["@config","@dateRangeMessage"],false,["if","or","eq","empty-state","hds/link/standalone"]]',moduleName:"vault/components/clients/no-data.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/clients/page-header",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@ember/object","@ember/service","@ember/test-waiters","@glimmer/component","@glimmer/tracking","core/utils/date-formatters","core/utils/sanitize-path","date-fns","ember-concurrency","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u,c,d,p){var f,m,h,b,y,v,g,w
function k(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function x(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function P(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const _=(0,p.createTemplateFactory)({id:"C63X/E6k",block:'[[[8,[39,0],[[24,0,"has-top-padding-l has-bottom-padding-m"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Vault Usage Metrics"]],[]]]]],[1,"\\n  "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n    This dashboard surfaces Vault client usage over time.\\n    "],[8,[39,1],null,[["@href"],[[28,[37,2],["/vault/docs/concepts/client-count"],null]]],[["default"],[[[[1,"Documentation is available here"]],[]]]]],[1,".\\n    Date queries are sent in UTC.\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["Actions"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["showExportButton"]],[[[1,"      "],[8,[39,4],[[4,[38,5],["click",[28,[37,6],[[28,[37,7],[[30,0,["showExportModal"]]],null],true],null]],null]],[["@text","@color","@icon"],["Export activity data","secondary","download"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["showExportModal"]],[[[1,"  "],[8,[39,8],[[24,1,"attribution-csv-download-modal"],[24,0,"has-text-left"]],[["@onClose"],[[30,0,["resetModal"]]]],[["default"],[[[[1,"\\n    "],[8,[30,2,["Header"]],null,[["@icon"],["info"]],[["default"],[[[[1,"\\n      Export activity data\\n    "]],[]]]]],[1,"\\n    "],[8,[30,2,["Body"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["exportChartData","isRunning"]],[[[1,"        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          Your export request is being processed. This may take some time; please do not navigate away from this page.\\n        "],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s has-text-centered"],[12],[1,"\\n          "],[8,[39,9],null,[["@name","@size"],["loading","24"]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],[[[1,"        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          This file will include an export of the clients that had activity within the date range below. See the\\n          "],[8,[39,2],null,[["@path"],["/vault/api-docs/system/internal-counters#activity-export"]],[["default"],[[[[1,"activity export documentation"]],[]]]]],[1,"\\n          for more details.\\n        "],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s is-subtitle-gray"],[12],[1,"SELECTED DATE "],[1,[52,[30,0,["formattedEndDate"]]," RANGE"]],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          "],[1,[30,0,["formattedStartDate"]]],[1,"\\n          "],[1,[52,[30,0,["formattedEndDate"]],"-"]],[1,"\\n          "],[1,[30,0,["formattedEndDate"]]],[13],[1,"\\n\\n        "],[8,[39,10],[[24,0,"has-bottom-margin-s"],[4,[38,5],["change",[30,0,["setExportFormat"]]],null]],null,[["default"],[[[[1,"\\n          "],[8,[30,3,["Label"]],null,null,[["default"],[[[[1,"Export format"]],[]]]]],[1,"\\n          "],[8,[30,3,["Options"]],null,null,[["default"],[[[[1,"\\n            "],[10,"option"],[14,2,"csv"],[15,"selected",[28,[37,11],[[30,0,["exportFormat"]],"csv"],null]],[12],[1,"CSV"],[13],[1,"\\n            "],[10,"option"],[14,2,"jsonl"],[15,"selected",[28,[37,11],[[30,0,["exportFormat"]],"jsonl"],null]],[12],[1,"JSON Lines"],[13],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[3]]]]],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,0,["downloadError"]],[[[1,"        "],[8,[39,12],null,[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n          "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"CSV export failed"]],[]]]]],[1,"\\n          "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,[30,0,["downloadError"]]]],[]]]]],[1,"\\n        "]],[4]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n    "],[8,[30,2,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,13],null,null,[["default"],[[[[1,"\\n        "],[8,[39,4],[[4,[38,5],["click",[28,[37,14],[[30,0,["exportChartData"]],[30,0,["formattedCsvFileName"]]],null]],null]],[["@text"],["Export"]],null],[1,"\\n        "],[8,[39,4],[[4,[38,5],["click",[30,5,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n"],[41,[30,6],[[[1,"        "],[8,[39,12],[[24,0,"has-top-padding-m"]],[["@type","@color"],["compact","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[10,"strong"],[12],[1,"Data contains "],[1,[28,[35,15],[[30,6,["length"]],"upgrade"],null]],[1,":"],[13],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[10,"ul"],[14,0,"bullet"],[12],[1,"\\n"],[42,[28,[37,17],[[28,[37,17],[[30,6]],null]],null],null,[[[1,"                "],[10,"li"],[12],[1,"\\n                  "],[1,[30,8,["version"]]],[1,"\\n                  "],[1,[28,[30,0,["parseAPITimestamp"]],[[30,8,["timestampInstalled"]],"(MMM d, yyyy)"],null]],[1,"\\n                "],[13],[1,"\\n"]],[8]],null],[1,"            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"\\n            Visit our\\n            "],[8,[39,1],null,[["@isHrefExternal","@href"],[true,[28,[37,2],["/vault/docs/concepts/client-count/faq#q-which-vault-version-reflects-the-most-accurate-client-counts"],null]]],[["default"],[[[[1,"\\n              Client count FAQ\\n            "]],[]]]]],[1,"\\n            for more information.\\n          "]],[]]]]],[1,"\\n        "]],[7]]]]],[1,"\\n"]],[]],null],[1,"    "]],[5]]]]],[1,"\\n  "]],[2]]]]],[1,"\\n"]],[]],null]],["PH","M","F","A","F","@upgradesDuringActivity","A","upgrade"],false,["hds/page-header","hds/link/inline","doc-link","if","hds/button","on","fn","mut","hds/modal","icon","hds/form/select/field","eq","hds/alert","hds/button-set","perform","pluralize","each","-track-array"]]',moduleName:"vault/components/clients/page-header.hbs",isStrictMode:!1})
let T=e.default=(f=class extends a.default{constructor(){super(...arguments),k(this,"download",m,this),k(this,"namespace",h,this),k(this,"store",b,this),k(this,"canDownload",y,this),k(this,"showExportModal",v,this),k(this,"exportFormat",g,this),k(this,"downloadError",w,this),x(this,"parseAPITimestamp",((e,t)=>(0,s.parseAPITimestamp)(e,t))),x(this,"exportChartData",(0,n.buildTask)((()=>({context:this,generator:function*(e){try{const t=yield this.getExportData()
this.download.download(e,t,this.exportFormat),this.showExportModal=!1}catch(t){this.downloadError=t.message}}})),{drop:!0},"exportChartData",null)),this.getExportCapabilities(this.args.namespace)}get showExportButton(){return!0!==this.args.noData&&this.canDownload}async getExportCapabilities(e=""){try{const t=e?`${(0,u.sanitizePath)(e)}/sys/internal/counters/activity/export`:"sys/internal/counters/activity/export",n=await this.store.findRecord("capabilities",t)
this.canDownload=n.canSudo}catch(t){this.canDownload=!0}}get formattedStartDate(){return this.args.startTimestamp?(0,s.parseAPITimestamp)(this.args.startTimestamp,"MMMM yyyy"):null}get formattedEndDate(){if(!this.args.startTimestamp&&!this.args.endTimestamp)return null
const e=(0,s.parseAPITimestamp)(this.args.startTimestamp),t=(0,s.parseAPITimestamp)(this.args.endTimestamp)
return(0,c.isSameMonth)(e,t)?null:(0,c.format)(t,"MMMM yyyy")}get formattedCsvFileName(){const e=this.formattedEndDate?`-${this.formattedEndDate}`:"",t=this.formattedStartDate?`_${this.formattedStartDate+e}`:""
return`clients_export${this.namespaceFilter?`_${this.namespaceFilter}`:""}${t}`}get namespaceFilter(){const e=this.namespace.path,{namespace:t}=this.args
return t?(0,u.sanitizePath)(`${e}/${t}`):(0,u.sanitizePath)(e)}async getExportData(){const e=this.store.adapterFor("clients/activity"),{startTimestamp:t,endTimestamp:n}=this.args
return e.exportData({format:"jsonl"===this.exportFormat?"json":"csv",start_time:t,end_time:n,namespace:this.namespaceFilter})}setExportFormat(e){const{value:t}=e.target
this.exportFormat=t}resetModal(){this.showExportModal=!1,this.downloadError=""}},m=P(f.prototype,"download",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=P(f.prototype,"namespace",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=P(f.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=P(f.prototype,"canDownload",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),v=P(f.prototype,"showExportModal",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),g=P(f.prototype,"exportFormat",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"csv"}}),w=P(f.prototype,"downloadError",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),P(f.prototype,"getExportCapabilities",[r.waitFor],Object.getOwnPropertyDescriptor(f.prototype,"getExportCapabilities"),f.prototype),P(f.prototype,"setExportFormat",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"setExportFormat"),f.prototype),P(f.prototype,"resetModal",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"resetModal"),f.prototype),f);(0,t.setComponentTemplate)(_,T)})),define("vault/components/clients/page/acme",["exports","@ember/component","vault/components/clients/activity","@ember/template-factory"],(function(e,t,n,l){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,l.createTemplateFactory)({id:"SCLX4Pni",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,0,["byMonthActivityData"]]],null],[[[1,"  "],[8,[39,2],[[24,0,"is-shadowless"]],[["@title","@message"],["No ACME clients",[29,["There is no ACME client data available for this ",[52,[30,0,["isDateRange"]],"date range","month"],"."]]]],null],[1,"\\n"]],[]],[[[41,[30,0,["isDateRange"]],[[[1,"  "],[8,[39,3],[[24,0,"no-legend"]],[["@title","@description","@timestamp","@hasChartData"],[[30,0,["title"]],[30,0,["description"]],[30,1,["responseTimestamp"]],true]],[["subTitle","chart"],[[[[1,"\\n      "],[8,[39,4],null,[["@label","@subText","@value","@tooltipText","@size"],["Total ACME clients","The total number of ACME requests made to Vault during this time period.",[30,0,["totalUsageCounts","acme_clients"]],"This number is the total for the queried date range. The chart displays a monthly breakdown of total clients per month.","l"]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[8,[39,5],null,[["@chartTitle","@data","@dataKey","@chartHeight"],[[30,0,["title"]],[30,0,["byMonthActivityData"]],"acme_clients",200]],null],[1,"\\n    "]],[]]]]],[1,"\\n\\n"],[41,[30,0,["totalUsageCounts","acme_clients"]],[[[1,"    "],[8,[39,3],[[24,0,"no-legend"]],[["@title","@description","@timestamp","@hasChartData"],["Monthly new","ACME clients which interacted with Vault for the first time each month. Each bar represents the total new ACME clients for that month.",[30,1,["responseTimestamp"]],true]],[["stats","chart"],[[[[1,"\\n"],[44,[[28,[30,0,["average"]],[[30,0,["byMonthNewClients"]],"acme_clients"],null]],[[[41,[30,2],[[[1,"            "],[8,[39,4],[[24,0,"chart-subTitle has-top-padding-l"]],[["@label","@value","@size"],["Average new ACME clients per month",[30,2],"m"]],null],[1,"\\n"]],[]],null]],[2]]],[1,"      "]],[]],[[[1,"\\n        "],[8,[39,5],null,[["@chartTitle","@data","@dataKey","@chartHeight"],["Monthly new",[30,0,["byMonthNewClients"]],"acme_clients",200]],null],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],null]],[]],[[[1,"  "],[8,[39,7],null,[["@title","@description"],[[30,0,["title"]],[30,0,["description"]]]],[["default"],[[[[1,"\\n    "],[8,[39,4],[[24,0,"column"]],[["@label","@value","@size"],["Total ACME clients",[30,0,["totalUsageCounts","acme_clients"]],"l"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]],[]]]],["@activity","avg"],false,["if","not","empty-state","clients/chart-container","stat-text","clients/charts/vertical-bar-basic","let","clients/usage-stats"]]',moduleName:"vault/components/clients/page/acme.hbs",isStrictMode:!1})
class a extends n.default{constructor(...e){super(...e),i(this,"title","ACME usage")}get description(){return`This data can be used to understand how many ACME clients have been used for the queried ${this.isDateRange?"date range":"month"}. Each ACME request is counted as one client.`}}e.default=a,(0,t.setComponentTemplate)(r,a)})),define("vault/components/clients/page/counts",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","date-fns","core/utils/date-formatters","core/utils/client-count-utils","core/utils/sanitize-path","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u){var c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,u.createTemplateFactory)({id:"KYOXnWt1",block:'[[[8,[39,0],null,[["@startTimestamp","@endTimestamp","@namespace","@upgradesDuringActivity","@noData"],[[30,1],[30,2],[30,3],[30,0,["upgradesDuringActivity"]],[28,[37,1],[[30,4,["total","clients"]]],null]]],null],[1,"\\n\\n"],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless is-bottomless is-shadowless"],[12],[1,"\\n  "],[8,[39,2],[[24,0,"has-bottom-margin-l"]],[["@startTime","@endTime","@onChange"],[[30,1],[30,2],[30,0,["onDateChange"]]]],null],[1,"\\n\\n"],[41,[28,[37,4],[[30,4,["id"]],"no-data"],null],[[[1,"    "],[8,[39,5],null,[["@config","@dateRangeMessage"],[[30,5],[30,0,["dateRangeMessage"]]]],null],[1,"\\n"]],[]],[[[41,[30,6],[[[1,"    "],[8,[39,6],null,[["@error"],[[30,6]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,5,["enabled"]],"Off"],null],[[[1,"      "],[8,[39,7],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,7,["Title"]],null,null,[["default"],[[[[1,"Tracking is disabled"]],[]]]]],[1,"\\n        "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"\\n          Tracking is currently disabled and data is not being collected. Historical data can be searched, but you will need\\n          to\\n          "],[8,[39,8],null,[["@route"],["vault.cluster.clients.edit"]],[["default"],[[[[1,"edit the configuration"]],[]]]]],[1,"\\n          to enable tracking again.\\n        "]],[]]]]],[1,"\\n      "]],[7]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,9],[[30,3],[30,0,["namespaces"]],[30,8],[30,0,["mountPaths"]]],null],[[[1,"      "],[8,[39,10],null,[["@tag"],["p"]],[["default"],[[[[1,"\\n        Filters\\n      "]],[]]]]],[1,"\\n      "],[8,[39,11],null,[["@tag","@color"],["p","faint"]],[["default"],[[[[1,"\\n        Apply a filter to look at data from a specific namespace and drill down by mount. The mount filter includes auth\\n        methods, KV engines, and PKI engines. Each mount type generates a different type of client and will not be applicable\\n        to every tab.\\n      "]],[]]]]],[1,"\\n      "],[8,[39,12],[[24,"aria-label","toolbar for filtering client count data"],[24,0,"has-bottom-margin-m"]],null,[["default"],[[[[1,"\\n        "],[8,[39,13],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,9],[[30,3],[30,0,["namespaces"]]],null],[[[1,"            "],[8,[39,14],[[24,0,"is-marginless"]],[["@id","@options","@inputValue","@selectLimit","@disallowNewItems","@fallbackComponent","@onChange","@placeholder","@displayInherit"],["namespace-search-select",[30,0,["namespaces"]],[52,[30,3],[28,[37,15],[[30,3]],null]],"1",true,"input-search",[28,[37,16],[[30,0,["setFilterValue"]],"ns"],null],[29,["Namespace within ",[30,0,["namespacePathForFilter"]]]],true]],null],[1,"\\n            "],[10,0],[14,0,"has-left-margin-xs"],[12],[13],[1,"\\n"]],[]],null],[41,[28,[37,9],[[30,8],[30,0,["mountPaths"]]],null],[[[1,"            "],[8,[39,14],null,[["@id","@options","@inputValue","@selectLimit","@disallowNewItems","@fallbackComponent","@onChange","@placeholder","@displayInherit"],["mounts-search-select",[30,0,["mountPaths"]],[52,[30,8],[28,[37,15],[[30,8]],null]],"1",true,"input-search",[28,[37,16],[[30,0,["setFilterValue"]],"mountPath"],null],[29,["Mount path within ",[30,0,["namespacePathForFilter"]]]],true]],null],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["totalUsageCounts"]],[[[41,[30,0,["upgradeExplanations"]],[[[1,"        "],[8,[39,7],[[24,0,"has-bottom-margin-m"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,9,["Title"]],null,null,[["default"],[[[[1,"\\n            Client count data contains\\n            "],[1,[28,[35,17],[[30,0,["upgradeExplanations","length"]],"upgrade"],null]],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,9,["Description"]],null,null,[["default"],[[[[1,"\\n            Vault was upgraded during this time period. Keep this in mind while looking at the data. Visit our\\n            "],[8,[39,8],null,[["@isHrefExternal","@href"],[true,[28,[37,18],["/vault/docs/concepts/client-count/faq#q-which-vault-version-reflects-the-most-accurate-client-counts"],null]]],[["default"],[[[[1,"\\n              Client count FAQ\\n            "]],[]]]]],[1,"\\n            for more information.\\n          "]],[]]]]],[1,"\\n          "],[8,[30,9,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[10,"ul"],[14,0,"bullet"],[12],[1,"\\n"],[42,[28,[37,20],[[28,[37,20],[[30,0,["upgradeExplanations"]]],null]],null],null,[[[1,"                "],[10,"li"],[12],[1,[30,10]],[13],[1,"\\n"]],[10]],null],[1,"            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[9]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["startTimeDiscrepancy"]],[[[1,"        "],[8,[39,7],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","neutral"]],[["default"],[[[[1,"\\n          "],[8,[30,11,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[1,[30,0,["startTimeDiscrepancy"]]],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[11]]]]],[1,"\\n"]],[]],null],[1,"\\n      "],[8,[39,21],null,[["@showSecretsSyncClientCounts"],[[28,[37,9],[[30,0,["hasSecretsSyncClients"]],[30,0,["flags","showSecretsSync"]]],null]]],null],[1,"\\n\\n"],[1,"      "],[18,12,null],[1,"\\n\\n"]],[]],[[[41,[28,[37,23],[[30,0,["version","isCommunity"]],[28,[37,1],[[30,1]],null]],null],[[[1,"      "],[8,[39,24],null,[["@title","@message"],["No start date found","In order to get the most from this data, please enter a start month above. Vault will calculate new clients starting from that month."]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,24],null,[["@title","@message"],[[29,["No data received ",[52,[30,0,["dateRangeMessage"]],[30,0,["dateRangeMessage"]]]]],[52,[30,0,["version","isCommunity"]],"Select a start date above to query client count data.","Update the filter values or click the button to reset them."]]],[["default"],[[[[1,"\\n        "],[8,[39,25],[[4,[38,26],["click",[30,0,["resetFilters"]]],null]],[["@text","@color","@icon"],["Reset filters","tertiary","reload"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]],[]]],[1,"  "]],[]]]],[]]],[13]],["@startTimestamp","@endTimestamp","@namespace","@activity","@config","@activityError","A","@mountPath","A","info","A","&default"],false,["clients/page-header","not","clients/date-range","if","eq","clients/no-data","clients/counts/error","hds/alert","hds/link/inline","or","hds/text/display","hds/text/body","toolbar","toolbar-filters","search-select","array","fn","pluralize","doc-link","each","-track-array","clients/counts/nav-bar","yield","and","empty-state","hds/button","on"]]',moduleName:"vault/components/clients/page/counts.hbs",isStrictMode:!1})
let v=e.default=(c=class extends n.default{constructor(...e){super(...e),h(this,"flags",d,this),h(this,"version",p,this),h(this,"namespace",f,this),h(this,"store",m,this)}get formattedStartDate(){return this.args.startTimestamp?(0,a.parseAPITimestamp)(this.args.startTimestamp,"MMMM yyyy"):null}get dateRangeMessage(){if(this.args.startTimestamp&&this.args.endTimestamp){const e=(0,r.isSameMonth)((0,a.parseAPITimestamp)(this.args.startTimestamp),(0,a.parseAPITimestamp)(this.args.endTimestamp))?"":`to ${(0,a.parseAPITimestamp)(this.args.endTimestamp,"MMMM yyyy")}`
return`from ${(0,a.parseAPITimestamp)(this.args.startTimestamp,"MMMM yyyy")} ${e}`}return null}get upgradesDuringActivity(){const{versionHistory:e,activity:t}=this.args
return(0,o.filterVersionHistory)(e,t.startTime,t.endTime)}get upgradeExplanations(){return this.upgradesDuringActivity.length?this.upgradesDuringActivity.map((e=>{let t
const n=(0,a.parseAPITimestamp)(e.timestampInstalled,"MMM d, yyyy"),l=e.version||""
switch(!0){case l.includes("1.9"):t="- We introduced changes to non-entity token and local auth mount logic for client counting in 1.9."
break
case l.includes("1.10"):t="- We added monthly breakdowns and mount level attribution starting in 1.10."
break
case l.includes("1.17"):t="- We separated ACME clients from non-entity clients starting in 1.17."
break
default:t=""}return`${l} (upgraded on ${n}) ${t}`})):null}get versionText(){return this.version.isEnterprise?{title:"No billing start date found",message:"In order to get the most from this data, please enter your billing period start month. This will ensure that the resulting data is accurate."}:{title:"No start date found",message:"In order to get the most from this data, please enter a start month above. Vault will calculate new clients starting from that month."}}get namespacePathForFilter(){const{namespace:e}=this.args,t=this.namespace.currentNamespace
return(0,s.sanitizePath)(e||t||"root")}get activityForNamespace(){const{activity:e}=this.args,t=this.namespacePathForFilter
return e?.byNamespace?.find((e=>(0,s.sanitizePath)(e.label)===t))}get totalUsageCounts(){const{namespace:e,mountPath:t,activity:n}=this.args
return t?(0,o.filteredTotalForMount)(n.byNamespace,e,t):n?.total}get namespaces(){return this.args.activity?.byNamespace?this.args.activity.byNamespace.map((e=>({name:e.label,id:e.label}))).filter((e=>(0,s.sanitizePath)(e.name)!==this.namespacePathForFilter)):[]}get mountPaths(){return this.activityForNamespace?.mounts.map((e=>({id:e.label,name:e.label})))||[]}get startTimeDiscrepancy(){const{activity:e,config:t}=this.args,n=(0,a.parseAPITimestamp)(e.startTime),l=(0,a.parseAPITimestamp)(this.args.startTimestamp),i=this.args.startTimestamp===t.billingStartTimestamp?.toISOString()&&this.version.isEnterprise?"Your license start date is":"You requested data from"
return(0,r.isAfter)(n,l)&&!(0,r.isSameMonth)(n,l)?`${i} ${this.formattedStartDate}.\n        We only have data from ${(0,a.parseAPITimestamp)(e.startTime,"MMMM yyyy")},\n        and that is what is being shown here.`:null}get hasSecretsSyncClients(){return this.args.activity?.total?.secret_syncs>0}onDateChange(e){this.args.onFilterChange(e)}setFilterValue(e,[t]){const n={[e]:t}
"ns"!==e||t?"mountPath"!==e||this.args.namespace||(n.ns=this.namespacePathForFilter):n.mountPath=void 0,this.args.onFilterChange(n)}resetFilters(){this.args.onFilterChange({start_time:void 0,end_time:void 0,ns:void 0,mountPath:void 0})}},d=b(c.prototype,"flags",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(c.prototype,"version",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(c.prototype,"namespace",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=b(c.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b(c.prototype,"onDateChange",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"onDateChange"),c.prototype),b(c.prototype,"setFilterValue",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"setFilterValue"),c.prototype),b(c.prototype,"resetFilters",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"resetFilters"),c.prototype),c);(0,t.setComponentTemplate)(y,v)})),define("vault/components/clients/page/overview",["exports","@ember/component","vault/components/clients/activity","@ember/service","core/utils/sanitize-path","@ember/template-factory"],(function(e,t,n,l,i,r){var a,o
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,r.createTemplateFactory)({id:"zxcdyw+m",block:'[[[8,[39,0],null,[["@isSecretsSyncActivated","@byMonthActivityData","@isHistoricalMonth","@isCurrentMonth","@runningTotals","@upgradeData","@responseTimestamp","@mountPath"],[[30,0,["flags","secretsSyncIsActivated"]],[30,0,["byMonthActivityData"]],[28,[37,1],[[28,[37,2],[[30,0,["isCurrentMonth"]]],null],[28,[37,2],[[30,0,["isDateRange"]]],null]],null],[30,0,["isCurrentMonth"]],[30,0,["totalUsageCounts"]],[30,0,["upgradesDuringActivity"]],[30,1,["responseTimestamp"]],[30,2]]],null],[1,"\\n\\n"],[41,[30,0,["hasAttributionData"]],[[[1,"  "],[8,[39,4],null,[["@noun","@attribution","@responseTimestamp","@isSecretsSyncActivated"],["namespace",[30,1,["byNamespace"]],[30,1,["responseTimestamp"]],[30,0,["flags","secretsSyncIsActivated"]]]],null],[1,"\\n"],[41,[30,0,["namespaceMountAttribution"]],[[[1,"    "],[8,[39,4],null,[["@noun","@attribution","@responseTimestamp","@isSecretsSyncActivated"],["mount",[30,0,["namespaceMountAttribution"]],[30,1,["responseTimestamp"]],[30,0,["flags","secretsSyncIsActivated"]]]],null],[1,"\\n"]],[]],null]],[]],null]],["@activity","@mountPath"],false,["clients/running-total","and","not","if","clients/attribution"]]',moduleName:"vault/components/clients/page/overview.hbs",isStrictMode:!1})
let u=e.default=(a=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="flags",i=this,(l=o)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get hasAttributionData(){return!(this.args.mountPath||!this.totalUsageCounts.clients)}get namespaceMountAttribution(){const{activity:e}=this.args,t=this.namespacePathForFilter
return e?.byNamespace?.find((e=>(0,i.sanitizePath)(e.label)===t))?.mounts||[]}},c=a.prototype,d="flags",p=[l.service],f={configurable:!0,enumerable:!0,writable:!0,initializer:null},h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),o=void 0===h.initializer?(Object.defineProperty(c,d,h),null):h,a)
var c,d,p,f,m,h;(0,t.setComponentTemplate)(s,u)})),define("vault/components/clients/page/sync",["exports","@ember/component","vault/components/clients/activity","@ember/service","@ember/template-factory"],(function(e,t,n,l,i){var r,a
function o(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,i.createTemplateFactory)({id:"tKkl4VW/",block:'[[[41,[30,0,["flags","secretsSyncIsActivated"]],[[[41,[28,[37,1],[[30,0,["byMonthActivityData"]]],null],[[[1,"    "],[8,[39,2],[[24,0,"is-shadowless"]],[["@title","@message"],["No secrets sync clients",[29,["There is no sync data available for this ",[52,[30,0,["isDateRange"]],"date range","month"],"."]]]],null],[1,"\\n"]],[]],[[[41,[30,0,["isDateRange"]],[[[1,"    "],[8,[39,3],[[24,0,"no-legend"]],[["@title","@description","@timestamp","@hasChartData"],[[30,0,["title"]],[30,0,["description"]],[30,1,["responseTimestamp"]],true]],[["subTitle","chart"],[[[[1,"\\n        "],[8,[39,4],null,[["@label","@subText","@value","@tooltipText","@size"],["Total sync clients","The total number of secrets synced from Vault to other destinations during this date range.",[30,0,["totalUsageCounts","secret_syncs"]],"This number is the total for the queried date range. The chart displays a monthly breakdown of total sync clients per month.","l"]],null],[1,"\\n      "]],[]],[[[1,"\\n        "],[8,[39,5],null,[["@chartTitle","@data","@dataKey","@chartHeight"],[[30,0,["title"]],[30,0,["byMonthActivityData"]],"secret_syncs",200]],null],[1,"\\n      "]],[]]]]],[1,"\\n\\n"],[41,[30,0,["totalUsageCounts","secret_syncs"]],[[[1,"      "],[8,[39,3],[[24,0,"no-legend"]],[["@title","@description","@timestamp","@hasChartData"],["Monthly new","Secrets sync clients which interacted with Vault for the first time each month. Each bar represents the total new sync clients for that month.",[30,1,["responseTimestamp"]],true]],[["stats","chart"],[[[[1,"\\n"],[44,[[28,[30,0,["average"]],[[30,0,["byMonthNewClients"]],"secret_syncs"],null]],[[[41,[30,2],[[[1,"              "],[8,[39,4],[[24,0,"chart-subTitle has-top-padding-l"]],[["@label","@value","@size"],["Average new sync clients per month",[30,2],"m"]],null],[1,"\\n"]],[]],null]],[2]]],[1,"        "]],[]],[[[1,"\\n          "],[8,[39,5],null,[["@chartTitle","@data","@dataKey","@chartHeight"],["Monthly new",[30,0,["byMonthNewClients"]],"secret_syncs",200]],null],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null]],[]],[[[1,"    "],[8,[39,7],null,[["@title","@description"],[[30,0,["title"]],[30,0,["description"]]]],[["default"],[[[[1,"\\n      "],[8,[39,4],[[24,0,"column"]],[["@label","@value","@size"],["Total sync clients",[30,0,["totalUsageCounts","secret_syncs"]],"l"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]],[]]]],[]],[[[1,"  "],[8,[39,2],[[24,0,"is-shadowless"]],[["@title","@message"],["No Secrets Sync clients","No data is available because Secrets Sync has not been activated."]],[["default"],[[[[1,"\\n    "],[8,[39,8],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Activate Secrets Sync","vault.cluster.sync.secrets.overview"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]],["@activity","avg"],false,["if","not","empty-state","clients/chart-container","stat-text","clients/charts/vertical-bar-basic","let","clients/usage-stats","hds/link/standalone"]]',moduleName:"vault/components/clients/page/sync.hbs",isStrictMode:!1})
let u=e.default=(r=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="flags",i=this,(l=a)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0}),o(this,"title","Secrets sync usage"),o(this,"description","This data can be used to understand how many secrets sync clients have been used for this date range. Each Vault secret that is synced to at least one destination counts as one Vault client.")}},c=r.prototype,d="flags",p=[l.service],f={configurable:!0,enumerable:!0,writable:!0,initializer:null},h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),a=void 0===h.initializer?(Object.defineProperty(c,d,h),null):h,r)
var c,d,p,f,m,h;(0,t.setComponentTemplate)(s,u)})),define("vault/components/clients/page/token",["exports","@ember/component","vault/components/clients/activity","@ember/template-factory"],(function(e,t,n,l){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,l.createTemplateFactory)({id:"2WyhT9gB",block:'[[[41,[28,[37,1],[[30,0,["byMonthActivityData"]],[30,0,["isDateRange"]]],null],[[[1,"  "],[8,[39,2],null,[["@title","@description","@timestamp","@legend","@hasChartData"],["Entity/Non-entity clients usage","This data can be used to understand how many entity and non-entity clients are using Vault each month for this date range. Each client is counted once per month.",[30,1,["responseTimestamp"]],[30,0,["legend"]],true]],[["subTitle","chart"],[[[[1,"\\n      "],[8,[39,3],null,[["@label","@subText","@value","@tooltipText","@size"],["Total clients","The total number of entity and non-entity clients for this date range.",[30,0,["tokenStats","total"]],"This number is the total for the queried date range. The chart displays a monthly breakdown of total clients per month.","l"]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[8,[39,4],null,[["@chartTitle","@data","@chartLegend","@chartHeight"],["Entity/Non-entity clients usage",[30,0,["byMonthActivityData"]],[30,0,["legend"]],250]],null],[1,"\\n    "]],[]]]]],[1,"\\n\\n  "],[8,[39,2],[[16,0,[52,[51,[30,0,["hasNewClients"]]],"no-legend"]]],[["@title","@description","@timestamp","@legend","@hasChartData"],["Monthly new","Entity or non-entity clients which interacted with Vault for the first time during this date range. Each bar represents the total new clients for that month.",[30,1,["responseTimestamp"]],[30,0,["legend"]],[30,0,["hasNewClients"]]]],[["stats","chart","emptyState"],[[[[1,"\\n      "],[8,[39,3],[[24,0,"chart-subTitle has-top-padding-l"]],[["@label","@value","@size"],["Average new entity clients per month",[28,[30,0,["average"]],[[30,0,["byMonthNewClients"]],"entity_clients"],null],"m"]],null],[1,"\\n\\n      "],[8,[39,3],[[24,0,"data-details-top has-top-padding-l"]],[["@label","@value","@size"],["Average new non-entity clients per month",[28,[30,0,["average"]],[[30,0,["byMonthNewClients"]],"non_entity_clients"],null],"m"]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[8,[39,4],null,[["@chartTitle","@data","@chartLegend","@chartHeight"],["Monthly new",[30,0,["byMonthNewClients"]],[30,0,["legend"]],250]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[8,[39,6],[[24,0,"is-shadowless"]],[["@title","@subTitle","@bottomBorder"],["No new clients",[29,["There is no new client data available for this ",[52,[30,0,["countsController","mountPath"]],"auth method","namespace"]," in this date range."]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,7],null,[["@title","@description"],["Entity/Non-entity usage",[29,["Client counts for this\\n    ",[52,[30,2],"mount","namespace and all its children"],".\\n    ",[52,[30,0,["isCurrentMonth"]],"Only totals are available when viewing the current month. To see a breakdown of new and total clients for this month, select the \'Current Billing Period\' filter."]]]]],[["default"],[[[[1,"\\n    "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Total clients",[30,0,["tokenStats","total"]],"l","The number of clients which interacted with Vault during this month. This is Vault’s primary billing metric."]],null],[1,"\\n    "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Entity",[30,0,["tokenStats","entity_clients"]],"l","Representations of a particular user, client, or application that created a token via login."]],null],[1,"\\n    "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Non-entity",[30,0,["tokenStats","non_entity_clients"]],"l","Clients created with a shared set of permissions, but not associated with an entity."]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]],["@activity","@mountPath"],false,["if","and","clients/chart-container","stat-text","clients/charts/vertical-bar-stacked","unless","empty-state","clients/usage-stats"]]',moduleName:"vault/components/clients/page/token.hbs",isStrictMode:!1})
class a extends n.default{constructor(...e){super(...e),i(this,"legend",[{key:"entity_clients",label:"entity clients"},{key:"non_entity_clients",label:"non-entity clients"}])}calculateClientAverages(e){return["entity_clients","non_entity_clients"].reduce(((t,n)=>t+(this.average(e,n)||0)),0)}get hasNewClients(){return this.byMonthNewClients.find((e=>e.entity_clients||e.non_entity_clients))}get tokenStats(){if(this.totalUsageCounts){const{entity_clients:e,non_entity_clients:t}=this.totalUsageCounts
return{total:e+t,entity_clients:e,non_entity_clients:t}}return null}}e.default=a,(0,t.setComponentTemplate)(r,a)})),define("vault/components/clients/running-total",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"wvl0ktZr",block:'[[[41,[28,[37,1],[[30,1,["length"]],1],null],[[[1,"  "],[8,[39,2],null,[["@title","@description","@timestamp","@hasChartData"],["Vault client counts",[30,0,["chartContainerText"]],[30,2],true]],[["subTitle","stats","chart","legend"],[[[[1,"\\n      "],[8,[39,3],null,[["@label","@subText","@value","@size","@tooltipText"],["Running client total","The number of clients which interacted with Vault during this date range.",[30,3,["clients"]],"l","This number is the total for the queried date range. The chart displays a monthly breakdown of total clients per month."]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[10,0],[14,0,"data-details-top has-top-padding-l"],[12],[1,"\\n        "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n          "],[8,[39,3],null,[["@label","@value","@size"],["Entity",[30,3,["entity_clients"]],"m"]],null],[1,"\\n          "],[8,[39,3],[[24,0,"has-left-margin-l"]],[["@label","@value","@size"],["Non-entity",[30,3,["non_entity_clients"]],"m"]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"data-details-bottom is-flex-row"],[12],[1,"\\n        "],[8,[39,3],null,[["@label","@value","@size"],["ACME",[30,3,["acme_clients"]],"m"]],null],[1,"\\n"],[41,[30,4],[[[1,"          "],[8,[39,3],[[24,0,"has-left-margin-l"]],[["@label","@value","@size"],["Secret sync",[30,3,["secret_syncs"]],"m"]],null],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "]],[]],[[[1,"\\n      "],[8,[39,4],null,[["@data","@legend","@upgradeData","@chartHeight","@chartTitle"],[[30,0,["runningTotalData"]],[30,0,["chartLegend"]],[30,5],"250","Vault client counts"]],null],[1,"\\n    "]],[]],[[[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,0,["chartLegend"]]],null]],null],null,[[[1,"        "],[10,1],[15,0,[29,["legend-colors dot-",[30,6,["key"]]]]],[12],[13],[10,1],[14,0,"legend-label"],[12],[1,[28,[35,7],[[30,6,["label"]]],null]],[13],[1,"\\n"]],[6]],null],[1,"    "]],[]]]]],[1,"\\n"]],[]],[[[44,[[28,[37,9],[[30,1],"0"],null]],[[[41,[28,[37,10],[[30,8],[30,7,["new_clients","clients"]]],null],[[[1,"      "],[8,[39,11],null,[["@title","@description"],["Vault client counts",[30,0,["chartContainerText"]]]],[["default"],[[[[1,"\\n        "],[10,0],[14,0,"column"],[12],[1,"\\n          "],[8,[39,3],[[24,0,"has-bottom-margin-l"]],[["@label","@subText","@value","@size"],["New clients","This is the number of clients which were created in Vault for the first time in the selected month.",[30,7,["new_clients","clients"]],"l"]],null],[1,"\\n          "],[10,0],[14,0,"flex row-wrap gap-36"],[12],[1,"\\n            "],[8,[39,3],null,[["@label","@value","@size"],["Entity",[30,7,["new_clients","entity_clients"]],"m"]],null],[1,"\\n            "],[8,[39,3],null,[["@label","@value","@size"],["Non-entity",[30,7,["new_clients","non_entity_clients"]],"m"]],null],[1,"\\n            "],[8,[39,3],null,[["@label","@value","@size"],["ACME",[30,7,["new_clients","acme_clients"]],"m"]],null],[1,"\\n"],[41,[30,4],[[[1,"              "],[8,[39,3],null,[["@label","@value","@size"],["Secret sync",[30,7,["new_clients","secret_syncs"]],"m"]],null],[1,"\\n"]],[]],null],[1,"          "],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"column"],[12],[1,"\\n          "],[8,[39,3],[[24,0,"has-bottom-margin-l"]],[["@label","@subText","@value","@size"],["Total monthly clients","This is the number of total clients which used Vault for the given month, both new and previous.",[30,7,["clients"]],"l"]],null],[1,"\\n          "],[10,0],[14,0,"flex row-wrap gap-36"],[12],[1,"\\n            "],[8,[39,3],null,[["@label","@value","@size"],["Entity",[30,7,["entity_clients"]],"m"]],null],[1,"\\n            "],[8,[39,3],null,[["@label","@value","@size"],["Non-entity",[30,7,["non_entity_clients"]],"m"]],null],[1,"\\n            "],[8,[39,3],null,[["@label","@value","@size"],["ACME",[30,7,["acme_clients"]],"m"]],null],[1,"\\n"],[41,[30,4],[[[1,"              "],[8,[39,3],[[24,0,"column-start-4"]],[["@label","@value","@size"],["Secret sync",[30,7,["secret_syncs"]],"m"]],null],[1,"\\n"]],[]],null],[1,"          "],[13],[1,"\\n        "],[13],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],[[[1,"      "],[8,[39,11],null,[["@title","@description"],["Total usage",[29,["These totals are within this ",[28,[37,12],[[30,9],"namespace and all its children"],null],". ",[52,[30,10],"Only totals are available when viewing the current month. To see a breakdown of new and total clients for this month, select the \'Current billing period\' filter."]]]]],[["default"],[[[[1,"\\n        "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Total clients",[30,3,["clients"]],"l","The number of clients which interacted with Vault during this month. This is Vault’s primary billing metric."]],null],[1,"\\n        "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Entity",[30,3,["entity_clients"]],"l","Representations of a particular user, client, or application that created a token via login."]],null],[1,"\\n        "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Non-entity",[30,3,["non_entity_clients"]],"l","Clients created with a shared set of permissions, but not associated with an entity."]],null],[1,"\\n        "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["ACME",[30,3,["acme_clients"]],"l","Each ACME request counts as one client."]],null],[1,"\\n"],[41,[30,4],[[[1,"          "],[8,[39,3],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Secret sync",[30,3,["secret_syncs"]],"l","A secret with a configured sync destination qualifies as a unique and active client."]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n"]],[]]]],[7]]]],[]]]],["@byMonthActivityData","@responseTimestamp","@runningTotals","@isSecretsSyncActivated","@upgradeData","l","singleMonthData","@isHistoricalMonth","@mountPath","@isCurrentMonth"],false,["if","gt","clients/chart-container","stat-text","clients/charts/vertical-bar-grouped","each","-track-array","capitalize","let","get","and","clients/usage-stats","or"]]',moduleName:"vault/components/clients/running-total.hbs",isStrictMode:!1})
class r extends n.default{get chartContainerText(){const{isSecretsSyncActivated:e}=this.args
return`The total clients in the specified date range, displayed per month. This includes entity, non-entity${e?", ACME and secrets sync clients":" and ACME clients"}. The total client count number is an important consideration for Vault billing.`}get runningTotalData(){return this.args.byMonthActivityData.map((e=>({...e,new_clients:e.new_clients?.clients})))}get chartLegend(){return[{key:"clients",label:"total clients"},{key:"new_clients",label:"new clients"}]}}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/clients/usage-stats",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"qLySXRJF",block:'[[[8,[39,0],[[24,0,"has-padding-m has-bottom-margin-m"]],[["@level","@hasBorder"],["base",true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"flex row-wrap space-between"],[12],[1,"\\n    "],[8,[39,1],null,[["@tag","@weight","@size"],["h3","semibold","400"]],[["default"],[[[[1,"\\n      "],[1,[30,1]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,2],[[24,0,"has-bottom-margin-s"]],[["@href","@text","@icon","@iconPosition"],[[28,[37,3],["/vault/tutorials/monitoring/usage-metrics"],null],"Usage metrics tutorial","learn-link","trailing"]],null],[1,"\\n  "],[13],[1,"\\n"],[41,[30,2],[[[1,"    "],[8,[39,5],null,[["@tag"],["p"]],[["default"],[[[[1,"\\n      "],[1,[30,2]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n  "],[10,"hr"],[14,0,"has-background-gray-100 has-bottom-margin-m"],[12],[13],[1,"\\n\\n  "],[10,0],[14,0,"columns"],[12],[1,"\\n    "],[18,3,null],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["@title","@description","&default"],false,["hds/card/container","hds/text/display","hds/link/standalone","doc-link","if","hds/text/body","yield"]]',moduleName:"vault/components/clients/usage-stats.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/confirm-action",["exports","core/components/confirm-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirm-modal",["exports","core/components/confirm-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirmation-modal",["exports","core/components/confirmation-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/console/command-input",["exports","@ember/component","core/utils/key-codes"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({onExecuteCommand(){},onFullscreen(){},onValueUpdate(){},onShiftCommand(){},value:null,isFullscreen:null,actions:{handleKeyUp(e){const t=e.keyCode,l=e.target.value
switch(t){case n.default.ENTER:this.onExecuteCommand(l)
break
case n.default.UP:case n.default.DOWN:this.onShiftCommand(t)
break
default:this.onValueUpdate(l)}},fullscreen(){this.onFullscreen()}}})})),define("vault/components/console/log-json",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({"data-test-component":"console/log-json",attributeBindings:["data-test-component"]})})),define("vault/components/console/log-list",["exports","@ember/object/computed","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({content:null,list:(0,t.reads)("content.keys")})})),define("vault/components/console/log-object",["exports","@ember/string","@ember/component","@ember/object","columnify"],(function(e,t,n,l,i){function r(e){Object.keys(e).forEach((t=>{let n=e[t]
"string"!=typeof n&&(n=JSON.stringify(n)),e[t]=n}))}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.stringifyObjectValues=r
e.default=n.default.extend({content:null,columns:(0,l.computed)("content",(function(){const e=this.content
return r(e),(0,i.default)(e,{preserveNewLines:!0,headingTransform:function(e){return(0,t.capitalize)(e)}})}))})})),define("vault/components/console/log-text",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({"data-test-component":"console/log-text",attributeBindings:["data-test-component"]})})),define("vault/components/console/output-log",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({"data-test-component":"console/output-log",attributeBindings:["data-test-component"],log:null})})),define("vault/components/console/ui-panel",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/owner","@ember/runloop","@ember/string","ember-concurrency","@ember/test-waiters","vault/lib/control-group-error","vault/lib/console-helpers"],(function(e,t,n,l,i,r,a,o,s,u,c){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,s.buildWaiter)("web-repl")
e.default=l.default.extend({console:(0,t.service)(),router:(0,t.service)(),controlGroup:(0,t.service)(),store:(0,t.service)(),"data-test-component":"console/ui-panel",attributeBindings:["data-test-component"],classNames:"console-ui-panel",classNameBindings:["isFullscreen:fullscreen"],isFullscreen:!1,inputValue:null,cliLog:(0,n.alias)("console.log"),didRender(){this._super(...arguments),this.scrollToBottom()},logAndOutput(e,t){this.console.logAndOutput(e,t),(0,r.schedule)("afterRender",(()=>this.scrollToBottom()))},isRunning:(0,n.or)("executeCommand.isRunning","refreshRoute.isRunning"),executeCommand:(0,o.task)((function*(e,t=!1){this.set("inputValue","")
const n=d.beginAsync(),l=this.console
let i
if((0,c.executeUICommand)(e,(e=>this.logAndOutput(e)),{api:()=>this.routeToExplore.perform(e),clearall:()=>l.clearLog(!0),clear:()=>l.clearLog(),fullscreen:()=>this.toggleProperty("isFullscreen"),refresh:()=>this.refreshRoute.perform()}))return void d.endAsync(n)
try{i=(0,c.parseCommand)(e)}catch(b){return t&&this.logAndOutput(e,{type:"help"}),void d.endAsync(n)}const{method:r,flagArray:o,path:s,dataArray:p}=i,f=(0,c.extractFlagsFromStrings)(o,r),m=(0,c.extractDataFromStrings)(p),h=(0,c.formattedErrorFromInput)(s,r,f,p)
if(h)return this.logAndOutput(e,h),void d.endAsync(n)
try{const t=yield l[(0,a.camelize)(r)].call(l,s,m,f)
this.logAndOutput(e,(0,c.logFromResponse)(t,s,r,f))}catch(y){if(y instanceof u.default)return d.endAsync(n),this.logAndOutput(e,this.controlGroup.logFromError(y))
this.logAndOutput(e,(0,c.logFromError)(y,s,r))}d.endAsync(n)})),refreshRoute:(0,o.task)((function*(){const e=(0,i.getOwner)(this).lookup("router:main").currentRouteName
try{this.store.clearAllDatasets(),yield this.router.transitionTo(e),this.logAndOutput(null,{type:"success",content:"The current screen has been refreshed!"})}catch(t){this.logAndOutput(null,{type:"error",content:"The was a problem refreshing the current screen."})}})),routeToExplore:(0,o.task)((function*(e){const t=e.replace("api","").trim()
let n="Welcome to the Vault API explorer! \nYou can search for endpoints, see what parameters they accept, and even execute requests with your current token."
t&&(n=`Welcome to the Vault API explorer! \nWe've filtered the list of endpoints for '${t}'.`)
try{yield this.router.transitionTo("vault.cluster.tools.open-api-explorer",{queryParams:{filter:t}}),this.logAndOutput(null,{type:"success",content:n})}catch(l){"TransitionAborted"===l.message?this.logAndOutput(null,{type:"success",content:n}):this.logAndOutput(null,{type:"error",content:"There was a problem navigating to the api explorer."})}})),shiftCommandIndex(e){this.console.shiftCommandIndex(e,(e=>{this.set("inputValue",e)}))},scrollToBottom(){this.element.scrollTop=this.element.scrollHeight},actions:{closeConsole(){this.set("console.isOpen",!1)},toggleFullscreen(){this.toggleProperty("isFullscreen")},executeCommand(e){this.executeCommand.perform(e,!0)},shiftCommandIndex(e){this.shiftCommandIndex(e)}}})})),define("vault/components/control-group-inline-error",["exports","core/components/control-group-inline-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/control-group-success",["exports","@ember/service","@ember/component","ember-concurrency"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({router:(0,t.service)(),controlGroup:(0,t.service)(),store:(0,t.service)(),model:null,controlGroupResponse:null,error:null,unwrapData:null,unwrap:(0,l.task)((function*(e){const t=this.store.adapterFor("tools")
this.set("error",null)
try{const n=yield t.toolAction("unwrap",null,{clientToken:e})
this.set("unwrapData",n.auth||n.data),this.controlGroup.deleteControlGroupToken(this.model.id)}catch(n){this.set("error",`Token unwrap failed: ${n.errors[0]}`)}})).drop(),markAndNavigate:(0,l.task)((function*(){this.controlGroup.markTokenForUnwrap(this.model.id)
const{url:e}=this.controlGroupResponse.uiParams
yield this.router.transitionTo(e)})).drop()})})),define("vault/components/control-group",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object","ember-concurrency"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({tagName:"",auth:(0,t.service)(),controlGroup:(0,t.service)(),model:null,didReceiveAttrs(){this._super(...arguments)
const e=this.model.id,t=this.controlGroup.wrapInfoForAccessor(e)
this.set("controlGroupResponse",t)},currentUserEntityId:(0,n.alias)("auth.authData.entity_id"),currentUserIsRequesting:(0,i.computed)("currentUserEntityId","model.requestEntity.id",(function(){return!!this.model.requestEntity&&this.currentUserEntityId===this.model.requestEntity.id})),currentUserHasAuthorized:(0,i.computed)("currentUserEntityId","model.authorizations.@each.id",(function(){const e=this.model.authorizations||[]
return Boolean(e.find((e=>e.id===this.currentUserEntityId)))})),isSuccess:(0,n.or)("currentUserHasAuthorized","model.approved"),requestorName:(0,i.computed)("currentUserIsRequesting","model.requestEntity",(function(){const e=this.model.requestEntity
return this.currentUserIsRequesting?"You":e&&e.name?e.name:"Someone"})),bannerPrefix:(0,i.computed)("model.approved","currentUserHasAuthorized",(function(){return this.currentUserHasAuthorized?"Thanks!":this.model.approved?"Success!":"Locked"})),bannerText:(0,i.computed)("model.approved","currentUserIsRequesting","currentUserHasAuthorized",(function(){const e=this.model.approved,{currentUserHasAuthorized:t,currentUserIsRequesting:n}=this
return t?"You have given authorization":n&&e?"You have been given authorization":e?"This Control Group has been authorized":n?"The path you requested is locked by a Control Group":"Someone is requesting access to a path locked by a Control Group"})),refresh:(0,r.task)((function*(){try{yield this.model.reload()}catch(e){this.set("errors",e)}})).drop(),authorize:(0,r.task)((function*(){try{yield this.model.save(),yield this.refresh.perform()}catch(e){this.set("errors",e)}})).drop()})})),define("vault/components/copy-secret-dropdown",["exports","core/components/copy-secret-dropdown"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/dashboard/client-count-card",["exports","@ember/component","@glimmer/component","core/utils/timestamp","ember-concurrency","@ember/test-waiters","@glimmer/tracking","@ember/service","core/utils/date-formatters","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u){var c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,u.createTemplateFactory)({id:"lKX1+6jN",block:'[[[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"is-flex-between"],[12],[1,"\\n    "],[10,"h2"],[14,0,"title is-4 has-bottom-margin-xxs"],[12],[1,"\\n      Client count\\n    "],[13],[1,"\\n\\n    "],[8,[39,1],null,[["@route"],["vault.cluster.clients"]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n  "],[13],[1,"\\n\\n  "],[10,"hr"],[14,0,"has-background-gray-100"],[12],[13],[1,"\\n\\n"],[41,[30,0,["fetchClientActivity","isRunning"]],[[[1,"    "],[8,[39,3],null,null,null],[1,"\\n"]],[]],[[[41,[30,0,["activityData"]],[[[1,"      "],[10,0],[14,0,"is-grid grid-2-columns grid-gap-2 has-top-margin-m grid-align-items-start is-flex-v-centered"],[12],[1,"\\n        "],[8,[39,4],null,[["@label","@value","@size","@subText"],["Total",[30,0,["activityData","total","clients"]],"l",[30,0,["statSubText","total"]]]],null],[1,"\\n        "],[8,[39,4],null,[["@label","@value","@size","@subText"],["New",[30,0,["currentMonthActivityTotalCount"]],"l",[30,0,["statSubText","new"]]]],null],[1,"\\n      "],[13],[1,"\\n\\n      "],[10,0],[14,0,"has-top-margin-l is-flex-center"],[12],[1,"\\n        "],[8,[39,5],[[16,"disabled",[30,0,["fetchClientActivity","isRunning"]]],[24,0,"has-padding-xxs"],[4,[38,6],["click",[28,[37,7],[[30,0,["fetchClientActivity"]]],null]],null]],[["@text","@isIconOnly","@color","@icon"],["Refresh",true,"tertiary","sync"]],null],[1,"\\n        "],[10,"small"],[14,0,"has-left-margin-xs has-text-grey"],[12],[1,"\\n          Updated\\n          "],[1,[28,[35,8],[[30,0,["updatedAt"]],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[8,[39,9],null,[["@config"],[[30,0,["activityConfig"]]]],null],[1,"\\n"]],[]]]],[]]]],[]]]]]],[],false,["hds/card/container","link-to","if","vault-logo-spinner","stat-text","hds/button","on","perform","date-format","clients/no-data"]]',moduleName:"vault/components/dashboard/client-count-card.hbs",isStrictMode:!1})
let v=e.default=(c=class extends n.default{constructor(){super(...arguments),h(this,"store",d,this),h(this,"activityData",p,this),h(this,"activityConfig",f,this),h(this,"updatedAt",m,this),this.fetchClientActivity.perform()}get currentMonthActivityTotalCount(){return this.activityData?.byMonth?.lastObject?.new_clients.clients}get statSubText(){const e=e=>(0,s.parseAPITimestamp)(e,"MMM yyyy"),{startTime:t,endTime:n}=this.activityData
return t&&n?{total:`The number of clients in this billing period (${e(t)} - ${e(n)}).`,new:"The number of clients new to Vault in the current month."}:{total:"No total client data available.",new:"No new client data available."}}*fetchClientActivity(e){e&&e.preventDefault(),this.updatedAt=l.default.now().toISOString()
try{this.activityData=yield this.store.findRecord("clients/activity","clients/activity")}catch(t){this.activityConfig=yield this.store.queryRecord("clients/config",{}).catch((()=>null)),this.error=t}}},d=b(c.prototype,"store",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(c.prototype,"activityData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=b(c.prototype,"activityConfig",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=b(c.prototype,"updatedAt",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b(c.prototype,"fetchClientActivity",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"fetchClientActivity"),c.prototype),c);(0,t.setComponentTemplate)(y,v)})),define("vault/components/dashboard/learn-more-card",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"SFqcGPOl",block:'[[[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,"h2"],[14,0,"title is-4 has-bottom-margin-xxs"],[12],[1,"Learn more"],[13],[1,"\\n  "],[10,0],[14,0,"sub-text"],[12],[1,"\\n    Explore the features of Vault and learn advance practices with the following tutorials and documentation.\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n"],[42,[28,[37,2],[[28,[37,2],[[30,0,["learnMoreLinks"]]],null]],null],null,[[[41,[28,[37,4],[[28,[37,5],[[30,1,["requiredFeature"]],[30,2],[28,[37,6],[[30,1,["requiredFeature"]]],null]],null],[28,[37,7],[[30,1,["requiredFeature"]]],null]],null],[[[1,"        "],[8,[39,8],[[24,0,"is-size-8 has-font-weight-normal is-block has-bottom-margin-xxs"]],[["@path"],[[30,1,["link"]]]],[["default"],[[[[1,"\\n          "],[8,[39,9],null,[["@name"],[[30,1,["icon"]]]],null],[1,"\\n          "],[1,[30,1,["title"]]],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"]],[1]],null],[1,"  "],[13],[1,"\\n"]],[]]]]]],["learnMoreLink","@isEnterprise"],false,["hds/card/container","each","-track-array","if","or","and","has-feature","not","doc-link","icon"]]',moduleName:"vault/components/dashboard/learn-more-card.hbs",isStrictMode:!1})
class r extends n.default{get learnMoreLinks(){return[{link:"/vault/tutorials/secrets-management",icon:"docs-link",title:"Secrets Management"},{link:"/vault/tutorials/monitoring",icon:"docs-link",title:"Monitor & Troubleshooting"},{link:"/vault/tutorials/adp/transform",icon:"learn-link",title:"Advanced Data Protection: Transform engine",requiredFeature:"Transform Secrets Engine"},{link:"/vault/tutorials/secrets-management/pki-engine",icon:"learn-link",title:"Build your own Certificate Authority (CA)"}]}}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/dashboard/overview",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"UFKpi74+",block:'[[[8,[39,0],null,[["@version"],[[30,1]]],null],[1,"\\n\\n"],[10,0],[14,0,"has-bottom-margin-xl"],[12],[1,"\\n  "],[10,0],[14,0,"is-flex-row gap-24"],[12],[1,"\\n"],[41,[28,[37,2],[[30,1,["isEnterprise"]],[30,2]],null],[[[1,"      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n"],[41,[28,[37,3],["clients"],[["routeParams"],["activity"]]],[[[1,"          "],[8,[39,4],null,null,null],[1,"\\n"]],[]],null],[41,[28,[37,2],[[28,[37,3],["status"],[["routeParams"],["replication"]]],[28,[37,5],[[28,[37,6],[[30,3]],null]],null]],null],[[[1,"          "],[8,[39,7],null,[["@replication","@version","@refresh","@updatedAt"],[[30,3],[30,1],[30,4],[30,5]]],null],[1,"\\n"]],[]],null],[1,"        "],[8,[39,8],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n      "],[13],[1,"\\n\\n      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n        "],[8,[39,9],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n"],[41,[30,7],[[[1,"          "],[8,[39,10],null,[["@vaultConfiguration"],[[30,7]]],null],[1,"\\n"]],[]],null],[1,"        "],[10,0],[12],[1,"\\n          "],[8,[39,11],null,[["@isEnterprise"],[[30,1,["isEnterprise"]]]],null],[1,"\\n          "],[8,[39,12],null,null,null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n\\n"]],[]],[[[1,"      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n        "],[8,[39,8],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[8,[39,11],null,[["@isEnterprise"],[[30,1,["isEnterprise"]]]],null],[1,"\\n          "],[8,[39,12],null,null,null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n        "],[8,[39,9],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n"],[41,[30,7],[[[1,"          "],[8,[39,10],null,[["@vaultConfiguration"],[[30,7]]],null],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"],[13]],["@version","@isRootNamespace","@replication","@refreshModel","@replicationUpdatedAt","@secretsEngines","@vaultConfiguration"],false,["dashboard/vault-version-title","if","and","has-permission","dashboard/client-count-card","not","is-empty-value","dashboard/replication-card","dashboard/secrets-engines-card","dashboard/quick-actions-card","dashboard/vault-configuration-details-card","dashboard/learn-more-card","dashboard/survey-link-text"]]',moduleName:"vault/components/dashboard/overview.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/dashboard/quick-actions-card",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","kv/utils/kv-breadcrumbs","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"M6azggES",block:'[[[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,"h2"],[14,0,"title is-4"],[12],[1,"Quick actions"],[13],[1,"\\n"],[41,[30,0,["filteredSecretEngines"]],[[[1,"    "],[10,0],[14,0,"has-top-margin-m has-bottom-margin-m"],[12],[1,"\\n      "],[10,"h3"],[14,0,"title is-marginless is-6"],[12],[1,"Secrets engines"],[13],[1,"\\n      "],[10,2],[14,0,"is-size-8 has-top-margin-xxs has-bottom-margin-s has-text-grey"],[12],[1,"Supported engines include databases, KV\\n        version 2, and PKI."],[13],[1,"\\n      "],[8,[39,2],[[24,0,"is-marginless"]],[["@id","@options","@selectLimit","@disallowNewItems","@fallbackComponent","@onChange","@placeholder","@displayInherit","@shouldRenderName","@passObject","@objectKeys"],["secrets-engines-select",[30,0,["mountOptions"]],"1",true,"input-search",[30,0,["handleSearchEngineSelect"]],"Type to select a mount",true,true,true,[28,[37,3],["type","version"],null]]],null],[1,"\\n    "],[13],[1,"\\n\\n"],[41,[30,0,["selectedEngine"]],[[[1,"      "],[10,"h3"],[14,1,"action-select-title"],[14,0,"title is-6"],[12],[1,"Action"],[13],[1,"\\n      "],[8,[39,4],null,[["@name","@options","@isFullwidth","@selectedValue","@onChange","@noDefault","@ariaLabel"],["action-select",[30,0,["actionOptions"]],true,[30,0,["selectedAction"]],[30,0,["setSelectedAction"]],true,"Action"]],null],[1,"\\n\\n"],[41,[30,0,["searchSelectParams","model"]],[[[41,[28,[37,5],[[30,0,["selectedEngine","type"]],"kv"],null],[[[1,"          "],[8,[39,6],null,[["@label","@value","@mountPath","@onChange"],["Secret Path",[30,0,["paramValue"]],[30,0,["selectedEngine","id"]],[28,[37,7],[[28,[37,8],[[30,0,["paramValue"]]],null]],null]]],null],[1,"\\n"]],[]],[[[1,"          "],[10,"h3"],[14,0,"title is-6"],[12],[1,[30,0,["searchSelectParams","title"]]],[13],[1,"\\n\\n          "],[8,[39,2],[[24,0,"is-flex-grow-1"]],[["@ariaLabel","@selectLimit","@models","@placeholder","@disallowNewItems","@onChange","@fallbackComponent","@disabled","@nameKey","@queryObject","@objectKeys","@passObject","@shouldRenderName"],[[30,0,["searchSelectParams","title"]],"1",[28,[37,3],[[30,0,["searchSelectParams","model"]]],null],[30,0,["searchSelectParams","placeholder"]],true,[30,0,["handleActionSelect"]],"input-search",[28,[37,9],[[30,0,["searchSelectParams","model"]]],null],[30,0,["searchSelectParams","nameKey"]],[30,0,["searchSelectParams","queryObject"]],[30,0,["searchSelectParams","objectKeys"]],true,[30,0,["searchSelectParams","nameKey"]]]],null],[1,"\\n"]],[]]],[1,"        "],[10,0],[12],[1,"\\n          "],[8,[39,10],[[24,0,"has-top-margin-m"],[16,"disabled",[28,[37,9],[[28,[37,11],[[30,0,["selectedAction"]],[30,0,["selectedEngine"]],[30,0,["paramValue"]]],null]],null]],[4,[38,12],["click",[30,0,["navigateToPage"]]],null]],[["@text"],[[30,0,["searchSelectParams","buttonText"]]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],null]],[]],[[[1,"      "],[8,[39,13],null,[["@title","@message"],["No mount selected","Select a mount above to get started."]],null],[1,"\\n"]],[]]]],[]],[[[1,"\\n    "],[8,[39,13],null,[["@title","@message"],["Welcome to quick actions","Access secret engine actions easily. Enable a compatible secret engine (such as database, KV version 2, or PKI) to get started."]],[["default"],[[[[1,"\\n      "],[8,[39,14],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Enable a secrets engine","vault.cluster.settings.mount-secret-backend"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]]]],[],false,["hds/card/container","if","search-select","array","select","eq","kv-suggestion-input","fn","mut","not","hds/button","and","on","empty-state","hds/link/standalone"]]',moduleName:"vault/components/dashboard/quick-actions-card.hbs",isStrictMode:!1}),b=["pki","database"]
let y=e.default=(s=class extends n.default{constructor(...e){super(...e),f(this,"router",u,this),f(this,"selectedEngine",c,this),f(this,"selectedAction",d,this),f(this,"paramValue",p,this)}get actionOptions(){switch(this.selectedEngine.type){case"kv":return["Find KV secrets"]
case"database":return["Generate credentials for database"]
case"pki":return["Issue certificate","View certificate","View issuer"]
default:return[]}}get searchSelectParams(){switch(this.selectedAction){case"Find KV secrets":return{title:"Secret path",subText:"Path of the secret you want to read.",buttonText:"Read secrets",model:"kv/metadata",route:"vault.cluster.secrets.backend.kv.secret.index",nameKey:"path",queryObject:{pathToSecret:"",backend:this.selectedEngine.id},objectKeys:["path","id"]}
case"Generate credentials for database":return{title:"Role to use",buttonText:"Generate credentials",model:"database/role",route:"vault.cluster.secrets.backend.credentials",queryObject:{backend:this.selectedEngine.id}}
case"Issue certificate":return{title:"Role to use",placeholder:"Type to find a role",buttonText:"Issue leaf certificate",model:"pki/role",route:"vault.cluster.secrets.backend.pki.roles.role.generate",queryObject:{backend:this.selectedEngine.id}}
case"View certificate":return{title:"Certificate serial number",placeholder:"33:a3:...",buttonText:"View certificate",model:"pki/certificate/base",route:"vault.cluster.secrets.backend.pki.certificates.certificate.details",queryObject:{backend:this.selectedEngine.id}}
case"View issuer":return{title:"Issuer",placeholder:"Type issuer name or ID",buttonText:"View issuer",model:"pki/issuer",route:"vault.cluster.secrets.backend.pki.issuers.issuer.details",nameKey:"issuerName",queryObject:{backend:this.selectedEngine.id},objectKeys:["id","issuerName"]}
default:return{placeholder:"Please select an action above",buttonText:"Select an action",model:""}}}get filteredSecretEngines(){return this.args.secretsEngines?.filter((e=>"kv"===e.type&&2==e.version||b.includes(e.type)))}get mountOptions(){return this.filteredSecretEngines?.map((e=>{const{id:t,type:n}=e
return{name:t,type:n,id:t}}))}handleSearchEngineSelect([e]){this.selectedEngine=e,this.selectedAction=null,this.paramValue=null}setSelectedAction(e){this.selectedAction=e,this.paramValue=null}handleActionSelect(e){Array.isArray(e)?this.paramValue=e[0]:this.paramValue=e}navigateToPage(){let e=this.searchSelectParams.route,t=this.paramValue.id||this.paramValue
if("kv"===this.selectedEngine.type){const n=this.paramValue.path||this.paramValue
e=(0,a.pathIsDirectory)(n)?"vault.cluster.secrets.backend.kv.list-directory":"vault.cluster.secrets.backend.kv.secret.index",t=n}this.router.transitionTo(e,this.selectedEngine.id,t)}},u=m(s.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"selectedEngine",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"selectedAction",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"paramValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(s.prototype,"handleSearchEngineSelect",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSearchEngineSelect"),s.prototype),m(s.prototype,"setSelectedAction",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"setSelectedAction"),s.prototype),m(s.prototype,"handleActionSelect",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"handleActionSelect"),s.prototype),m(s.prototype,"navigateToPage",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"navigateToPage"),s.prototype),s);(0,t.setComponentTemplate)(h,y)})),define("vault/components/dashboard/replication-card",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"5+P9HtmA",block:'[[[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n\\n  "],[10,0],[14,0,"is-flex-between"],[12],[1,"\\n    "],[10,"h3"],[14,0,"title is-4 has-bottom-margin-xxs"],[12],[1,"\\n      Replication\\n    "],[13],[1,"\\n\\n"],[41,[28,[37,2],[[30,1,["dr","clusterId"]],[30,1,["performance","clusterId"]]],null],[[[1,"      "],[8,[39,3],null,[["@route"],["vault.cluster.replication.index"]],[["default"],[[[[1,"\\n        Details\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n\\n"],[41,[28,[37,2],[[30,1,["dr","clusterId"]],[30,1,["performance","clusterId"]]],null],[[[1,"    "],[10,"hr"],[14,0,"has-background-gray-100"],[12],[13],[1,"\\n"],[41,[28,[37,4],[[30,2,["hasPerfReplication"]],[30,2,["hasDRReplication"]]],null],[[[1,"      "],[10,0],[14,0,"is-grid grid-2-columns grid-gap-2 has-top-margin-m has-bottom-margin-xs grid-align-items-start"],[12],[1,"\\n        "],[8,[39,5],null,[["@title","@name","@state","@clusterStates"],["DR primary","dr",[30,1,["dr","state"]],[28,[37,6],[[30,1,["dr","state"]]],null]]],null],[1,"\\n        "],[8,[39,5],null,[["@title","@name","@state","@clusterStates"],[[29,["Performance ",[52,[30,1,["performance","isPrimary"]],"primary","secondary"]]],"performance",[52,[30,1,["performance","clusterId"]],[30,1,["performance","state"]],"not set up"],[52,[30,1,["performance","clusterId"]],[28,[37,6],[[30,1,["performance","state"]]],null]]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[41,[30,2,["hasDRReplication"]],[[[1,"      "],[8,[39,3],[[24,0,"title is-5 has-text-weight-semibold is-marginless"]],[["@route","@model"],["vault.cluster.replication.mode.index","dr"]],[["default"],[[[[1,"\\n        DR Primary\\n      "]],[]]]]],[1,"\\n\\n      "],[10,0],[14,0,"is-grid grid-2-columns grid-gap-2 has-top-margin-m has-bottom-margin-m grid-align-items-start"],[12],[1,"\\n        "],[8,[39,5],null,[["@title","@state","@clusterStates","@subText"],["state",[30,1,["dr","state"]],[28,[37,6],[[30,1,["dr","state"]]],null],"The current operating state of the cluster."]],null],[1,"\\n        "],[8,[39,7],null,[["@label","@value","@size","@subText"],["known secondaries",[30,1,["dr","knownSecondaries","length"]],"l","Number of secondaries connected to this primary."]],null],[1,"\\n      "],[13],[1,"\\n    "]],[]],null]],[]]],[1,"    "],[10,0],[14,0,"has-top-margin-s is-flex-center"],[12],[1,"\\n      "],[8,[39,8],[[24,0,"has-padding-xxs"],[4,[38,9],["click",[30,3]],null]],[["@text","@isIconOnly","@color","@icon"],["Refresh",true,"tertiary","sync"]],null],[1,"\\n      "],[10,"small"],[14,0,"has-left-margin-xs has-text-grey"],[12],[1,"\\n        Updated\\n        "],[1,[28,[35,10],[[30,4],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[8,[39,11],[[24,0,"has-top-margin-m"]],[["@title","@message"],["Replication not set up","Data will be listed here. Enable a primary replication cluster to get started."]],[["default"],[[[[1,"\\n      "],[8,[39,12],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Enable replication","vault.cluster.replication"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]]]],["@replication","@version","@refresh","@updatedAt"],false,["hds/card/container","if","or","link-to","and","dashboard/replication-state-text","cluster-states","stat-text","hds/button","on","date-format","empty-state","hds/link/standalone"]]',moduleName:"vault/components/dashboard/replication-card.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())}))
define("vault/components/dashboard/replication-state-text",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"Q2cCp1Wl",block:'[[[10,0],[12],[1,"\\n  "],[10,"h2"],[14,0,"is-size-5 has-text-weight-semibold has-bottom-margin-xs"],[12],[1,"\\n    "],[1,[30,1]],[1,"\\n  "],[13],[1,"\\n\\n"],[41,[30,2],[[[1,"    "],[10,0],[14,0,"title is-8 has-font-weight-normal has-text-grey-dark"],[12],[1,"\\n      "],[1,[30,2]],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[1,"\\n  "],[8,[39,1],null,[["@verticalPosition","@horizontalPosition"],["above","center"]],[["default"],[[[[1,"\\n    "],[8,[30,3,["Trigger"]],[[24,"tabindex","-1"],[24,0,"title is-4 has-text-weight-semibold has-top-margin-xxs has-bottom-margin-xxs"]],null,[["default"],[[[[1,"\\n      "],[1,[28,[35,2],[[30,4],"not set up"],null]],[1,"\\n\\n      "],[8,[39,3],[[16,0,[52,[30,5,["isOk"]],"has-text-success","has-text-danger"]]],[["@name"],[[28,[37,2],[[30,5,["glyph"]],"x-circle"],null]]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,3,["Content"]],null,[["@defaultClass"],["tool-tip smaller-font"]],[["default"],[[[[1,"\\n      "],[10,0],[14,0,"box"],[12],[1,"\\n        The cluster\'s current operating state\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[3]]]]],[1,"\\n"],[13]],["@title","@subText","T","@state","@clusterStates"],false,["if","tool-tip","or","flight-icon"]]',moduleName:"vault/components/dashboard/replication-state-text.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/dashboard/secrets-engines-card",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"Y8zSG8Dq",block:'[[[8,[39,0],[[16,0,[29,["has-padding-l ",[52,[30,0,["filteredSecretsEngines"]],"secrets-engines-card"]]]]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"is-flex-between"],[12],[1,"\\n    "],[10,"h2"],[14,0,"title is-4 has-left-margin-xxs"],[12],[1,"Secrets engines"],[13],[1,"\\n\\n"],[41,[30,0,["filteredSecretsEngines"]],[[[1,"      "],[8,[39,2],[[24,0,"has-right-margin-xxs"]],[["@route"],["vault.cluster.secrets.backends"]],[["default"],[[[[1,"\\n        Details\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n\\n"],[41,[30,0,["filteredSecretsEngines"]],[[[1,"    "],[8,[39,3],[[24,0,"is-border-spacing-revert"]],[["@caption"],["Five secrets engines"]],[["body"],[[[[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,0,["firstFiveSecretsEngines"]]],null]],null],null,[[[1,"          "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,1,["Td"]],[[24,0,"is-flex-between is-flex-center gap-16"]],null,[["default"],[[[[1,"\\n              "],[10,0],[12],[1,"\\n                "],[10,0],[14,0,"is-flex-center"],[12],[1,"\\n"],[41,[30,2,["icon"]],[[[1,"                    "],[8,[39,6],[[16,"title",[28,[37,7],[[30,2,["engineType"]],[30,2,["path"]]],null]],[16,0,[52,[51,[30,2,["isSupportedBackend"]]],"has-text-grey"]]],[["@name","@title"],[[30,2,["icon"]],[29,[[28,[37,7],[[30,2,["engineType"]],[30,2,["path"]]],null]," type backend"]]]],null],[1,"\\n"]],[]],null],[41,[30,2,["path"]],[[[41,[30,2,["isSupportedBackend"]],[[[1,"                      "],[8,[39,2],[[24,0,"has-text-black has-text-weight-semibold"]],[["@route","@model"],[[30,2,["backendLink"]],[30,2,["id"]]]],[["default"],[[[[1,"\\n                        "],[1,[30,2,["path"]]],[1,"\\n                      "]],[]]]]],[1,"\\n"]],[]],[[[1,"                      "],[10,1],[14,0,"has-text-grey"],[12],[1,[30,2,["path"]]],[13],[1,"\\n"]],[]]]],[]],null],[1,"                "],[13],[1,"\\n"],[41,[30,2,["accessor"]],[[[1,"                  "],[10,"code"],[14,0,"has-text-grey is-size-8"],[12],[1,"\\n                    "],[1,[30,2,["accessor"]]],[1,"\\n                  "],[13],[1,"\\n"]],[]],null],[41,[30,2,["description"]],[[[1,"                  "],[10,0],[14,0,"truncate-first-line"],[12],[1,"\\n                    "],[1,[30,2,["description"]]],[1,"\\n                  "],[13],[1,"\\n"]],[]],null],[1,"              "],[13],[1,"\\n"],[41,[30,2,["isSupportedBackend"]],[[[1,"                "],[8,[39,2],[[24,0,"has-text-weight-semibold"]],[["@route","@model"],[[30,2,["backendLink"]],[30,2,["id"]]]],[["default"],[[[[1,"\\n                  View\\n                "]],[]]]]],[1,"\\n"]],[]],null],[1,"            "]],[]]]]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[2]],null],[1,"      "]],[1]]]]],[1,"\\n\\n"],[41,[28,[37,9],[[30,0,["filteredSecretsEngines","length"]],5],null],[[[1,"      "],[10,2],[14,0,"is-size-9 has-top-margin-xs has-text-grey"],[12],[1,"\\n        Showing 5 out of\\n        "],[1,[30,0,["filteredSecretsEngines","length"]]],[1,"\\n        secret engines. Navigate to\\n        "],[8,[39,10],null,[["@route"],["vault.cluster.secrets.backends"]],[["default"],[[[[1,"details"]],[]]]]],[1,"\\n        to view more.\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n"]],[]],[[[1,"    "],[8,[39,11],[[24,0,"has-top-margin-m"]],[["@title","@message"],["No secrets engines enabled","Secret engines will be listed here. Enable a secret engine to get started."]],[["default"],[[[[1,"\\n      "],[8,[39,12],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Enable a secrets engine","vault.cluster.settings.mount-secret-backend"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]]]],["B","backend"],false,["hds/card/container","if","link-to","hds/table","each","-track-array","icon","or","unless","gt","hds/link/inline","empty-state","hds/link/standalone"]]',moduleName:"vault/components/dashboard/secrets-engines-card.hbs",isStrictMode:!1})
class r extends n.default{get filteredSecretsEngines(){return this.args.secretsEngines?.filter((e=>e.shouldIncludeInList))}get firstFiveSecretsEngines(){return this.filteredSecretsEngines?.slice(0,5)}}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/dashboard/survey-link-text",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"XPw2ZPS1",block:'[[[10,0],[14,0,"has-top-padding-xs has-bottom-padding-xs has-top-margin-m"],[12],[1,"\\n  "],[10,"small"],[12],[1,"\\n    Don\'t see what you\'re looking for on this page? Let us know via our\\n    "],[8,[39,0],null,[["@icon","@href"],["external-link","https://hashicorp.sjc1.qualtrics.com/jfe/form/SV_1SNUsZLdWHpfw0e"]],[["default"],[[[[1,"\\n      feedback form\\n    "]],[]]]]],[1,"\\n    .\\n  "],[13],[1,"\\n"],[13]],[],false,["hds/link/inline"]]',moduleName:"vault/components/dashboard/survey-link-text.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/dashboard/vault-configuration-details-card",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"EicJ5bxe",block:'[[[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,"h3"],[14,0,"title is-4"],[12],[1,"Configuration details"],[13],[1,"\\n\\n  "],[8,[39,1],[[24,0,"is-border-spacing-revert"]],[["@caption"],["Vault configuration details"]],[["body"],[[[[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"API_ADDR"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,2],[[30,2,["api_addr"]],"None"],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Default lease TTL"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,3],[[30,2,["default_lease_ttl"]]],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Max lease TTL"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,3],[[30,2,["max_lease_ttl"]]],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"TLS"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[30,0,["tls"]]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Log format"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,2],[[30,2,["log_format"]],"None"],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Log level"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[30,2,["log_level"]]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Storage type"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[30,2,["storage","type"]]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[1]]]]],[1,"\\n"]],[]]]]]],["B","@vaultConfiguration"],false,["hds/card/container","hds/table","or","format-duration"]]',moduleName:"vault/components/dashboard/vault-configuration-details-card.hbs",isStrictMode:!1})
class r extends n.default{get tls(){const e=this.args.vaultConfiguration?.listeners.find((e=>{const{tls_disable:t,tls_cert_file:n,tls_key_file:l}=e.config||{}
return!t&&n&&l}))
return e?"Enabled":"Disabled"}}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/dashboard/vault-version-title",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,l,i){var r,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,i.createTemplateFactory)({id:"Hx427BwU",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Vault\\n      "],[1,[30,2,["versionDisplay"]]],[1,"\\n"],[41,[30,2,["isEnterprise"]],[[[1,"        "],[8,[39,2],null,[["@text","@icon"],[[30,0,["namespace","currentNamespace"]],"org"]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[10,"hr"],[14,0,"has-top-margin-xxs has-bottom-margin-l has-background-gray-200"],[12],[13]],["p","@version"],false,["page-header","if","hds/badge"]]',moduleName:"vault/components/dashboard/vault-version-title.hbs",isStrictMode:!1})
let s=e.default=(r=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="namespace",i=this,(l=a)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}},u=r.prototype,c="namespace",d=[l.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,r)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/database-connection",["exports","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","@ember/test-waiters","ember-concurrency"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y="vault.cluster.secrets.backend.show",v=e=>{let t=e?.join(". ")||"Something went wrong. Check the Vault logs for more information."
return t.indexOf("failed to verify")>=0&&(t="There was a verification error for this connection. Check the Vault logs for more information."),t}
e.default=(s=class extends n.default{constructor(...e){super(...e),m(this,"store",u,this),m(this,"router",c,this),m(this,"flashMessages",d,this),m(this,"showPasswordField",p,this),m(this,"showSaveModal",f,this),h(this,"handleCreateConnection",(0,t.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(e){e.preventDefault()
try{const e=this.args.model
yield e.save(),this.showSaveModal=!0}catch(t){const e=v(t.errors)
this.flashMessages.danger(e)}}))})),null,"handleCreateConnection",null)),h(this,"continueWithRotate",(0,t.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(){const{backend:e,name:t}=this.args.model
try{yield this.rotateCredentials(e,t),this.flashMessages.success(`Successfully rotated root credentials for connection "${t}"`),this.transitionToRoute(y,t)}catch(n){this.flashMessages.danger(`Error rotating root credentials: ${n.errors}`),this.transitionToRoute(y,t)}finally{this.showSaveModal=!1}}))})),null,"continueWithRotate",null))}rotateCredentials(e,t){return this.store.adapterFor("database/connection").rotateRootCredentials(e,t)}transitionToRoute(){return this.router.transitionTo(...arguments)}updateShowPassword(e){this.showPasswordField=e,e||(this.args.model.password=void 0)}updatePassword(e,t){const n=t.target.value
this.args.model[e]=n}continueWithoutRotate(){if(this.continueWithRotate.isRunning)return
this.showSaveModal=!1
const{name:e}=this.args.model
this.transitionToRoute(y,e)}handleUpdateConnection(e){e.preventDefault()
const t=this.args.model,n=t.name
t.save().then((()=>{this.transitionToRoute(y,n)})).catch((e=>{const t=v(e.errors)
this.flashMessages.danger(t)}))}delete(e){e.preventDefault()
const t=this.args.model,n=t.backend
t.destroyRecord().then((()=>{this.transitionToRoute("vault.cluster.secrets.backend.list-root",n)}))}reset(){const{name:e,backend:t}=this.args.model
this.store.adapterFor("database/connection").resetConnection(t,e).then((()=>{this.flashMessages.success("Successfully reset connection")})).catch((e=>{const t=v(e.errors)
this.flashMessages.danger(t)}))}rotate(){const{name:e,backend:t}=this.args.model
this.rotateCredentials(t,e).then((()=>{this.flashMessages.success("Successfully rotated credentials")})).catch((e=>{const t=v(e.errors)
this.flashMessages.danger(t)}))}},u=b(s.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(s.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(s.prototype,"showPasswordField",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=b(s.prototype,"showSaveModal",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),b(s.prototype,"updateShowPassword",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"updateShowPassword"),s.prototype),b(s.prototype,"updatePassword",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"updatePassword"),s.prototype),b(s.prototype,"continueWithoutRotate",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"continueWithoutRotate"),s.prototype),b(s.prototype,"handleUpdateConnection",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"handleUpdateConnection"),s.prototype),b(s.prototype,"delete",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"delete"),s.prototype),b(s.prototype,"reset",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"reset"),s.prototype),b(s.prototype,"rotate",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"rotate"),s.prototype),s)})),define("vault/components/database-role-edit",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,i){var r,a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(){super(...arguments),c(this,"router",a,this),c(this,"flashMessages",o,this),c(this,"store",s,this),c(this,"loading",u,this),this.args.initialKey&&(this.args.model.database=[this.args.initialKey])}get warningMessages(){const e={}
return("dynamic"===this.args.model.type&&!1===this.args.model.canCreateDynamic||"static"===this.args.model.type&&!1===this.args.model.canCreateStatic)&&(e.type="You don't have permissions to create this type of role."),e}get databaseType(){const e=this.args.model?.backend,t=this.args.model?.database||[]
return e&&0!==t.length?this.store.queryRecord("database/connection",{id:t[0],backend:e}).then((e=>e.plugin_name)).catch((()=>null)):null}generateCreds(e,t=""){this.router.transitionTo("vault.cluster.secrets.backend.credentials",e,{queryParams:{roleType:t}})}delete(){const e=this.args.model,t=e.backend
return e.destroyRecord().then((()=>{try{this.router.transitionTo("vault.cluster.secrets.backend.list-root",t,{queryParams:{tab:"role"}})}catch(e){console.debug(e)}})).catch((e=>{this.flashMessages.danger(e.errors?.join(". "))}))}handleCreateEditRole(e){e.preventDefault(),this.loading=!0
const t=this.args.mode,n=this.args.model,l=n.name
if("create"===t){n.set("id",l)
const e="static"===n.type?"static-roles":"roles"
n.set("path",e)}return n.save().then((()=>{try{this.router.transitionTo("vault.cluster.secrets.backend.show",`role/${l}`)}catch(e){console.debug(e)}})).catch((e=>{const t=e.errors?.join(". ")||e.message
this.flashMessages.danger(t||"Could not save the role. Please check Vault logs for more information."),this.loading=!1}))}rotateRoleCred(e){const t=this.args.model?.backend
return this.store.adapterFor("database/credential").rotateRoleCredentials(t,e).then((()=>{this.flashMessages.success(`Success: Credentials for ${e} role were rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},a=d(r.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=d(r.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(r.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(r.prototype,"loading",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),d(r.prototype,"generateCreds",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"generateCreds"),r.prototype),d(r.prototype,"delete",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"delete"),r.prototype),d(r.prototype,"handleCreateEditRole",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"handleCreateEditRole"),r.prototype),d(r.prototype,"rotateRoleCred",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"rotateRoleCred"),r.prototype),r)})),define("vault/components/database-role-setting-form",["exports","@glimmer/component","vault/utils/database-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{get settingFields(){if(!this.args.roleType)return null
const e=(0,n.getRoleFields)(this.args.roleType)
return this.args.attrs.filter((t=>e.includes(t.name)))}get statementFields(){const e=this.args.roleType,t=this.args.dbType
if(!e)return null
const l=(0,n.getStatementFields)(e,t)
return this.args.attrs.filter((e=>l.includes(e.name)))}}e.default=l})),define("vault/components/doc-link",["exports","core/components/doc-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo",["exports","@docfy/ember/components/docfy-demo"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/description",["exports","@docfy/ember/components/docfy-demo/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/example",["exports","@docfy/ember/components/docfy-demo/example"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/snippet",["exports","@docfy/ember/components/docfy-demo/snippet"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/snippets",["exports","@docfy/ember/components/docfy-demo/snippets"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-link",["exports","@docfy/ember/components/docfy-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-output",["exports","@docfy/ember/components/docfy-output"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-previous-and-next-page",["exports","@docfy/ember/components/docfy-previous-and-next-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/download-button",["exports","core/components/download-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/edit-form",["exports","core/components/edit-form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog-positioned-container",["exports","ember-modal-dialog/components/positioned-container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-basic-dialog",["exports","ember-modal-dialog/components/basic-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-in-place-dialog",["exports","ember-modal-dialog/components/in-place-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-liquid-dialog",["exports","ember-modal-dialog/components/liquid-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-liquid-tether-dialog",["exports","ember-modal-dialog/components/liquid-tether-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-tether-dialog",["exports","ember-modal-dialog/components/tether-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/overlay",["exports","ember-modal-dialog/components/overlay"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-tether",["exports","ember-tether/components/ember-tether"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-wormhole",["exports","ember-wormhole/components/ember-wormhole"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/empty-state",["exports","core/components/empty-state"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/enable-input",["exports","core/components/enable-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/external-link",["exports","core/components/external-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/field-group-show",["exports","core/components/field-group-show"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/file-to-array-buffer",["exports","@glimmer/component","@glimmer/tracking","@ember/object","filesize"],(function(e,t,n,l,i){var r,a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){super(...e),u(this,"filename",a,this),u(this,"fileSize",o,this),u(this,"fileLastModified",s,this)}readFile(e){const t=new FileReader
t.onload=()=>{this.isDestroyed||this.isDestroying||this.fileChange(t.result,e)},t.readAsArrayBuffer(e)}pickedFile(e){const{files:t}=e.target
if(t.length)for(let n=0,l=t.length;n<l;n++)this.readFile(t[n])}fileChange(e,t){const{name:n,size:l,lastModifiedDate:r}=t||{}
this.filename=n,this.fileSize=l?(0,i.default)(l):null,this.fileLastModified=r,this.args.onChange(e,n)}},a=c(r.prototype,"filename",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),o=c(r.prototype,"fileSize",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),s=c(r.prototype,"fileLastModified",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c(r.prototype,"pickedFile",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"pickedFile"),r.prototype),c(r.prototype,"fileChange",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"fileChange"),r.prototype),r)})),define("vault/components/filter-input-explicit",["exports","core/components/filter-input-explicit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/filter-input",["exports","core/components/filter-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/flash-message",["exports","ember-cli-flash/components/flash-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get alertType(){return`is-${this.args.flash.type||""}`}}e.default=n})),define("vault/components/flash-toast",["exports","@ember/component","@ember/string","@glimmer/component","@ember/template-factory"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"2nuXYb8S",block:'[[[8,[39,0],[[24,0,"has-bottom-margin-m"]],[["@color","@onDismiss"],[[30,0,["color"]],[30,1]]],[["default"],[[[[1,"\\n  "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,[30,0,["title"]]]],[]]]]],[1,"\\n  "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n    "],[10,2],[14,0,"is-word-break"],[12],[1,[30,3,["message"]]],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]]]]]],["@close","T","@flash"],false,["hds/toast"]]',moduleName:"vault/components/flash-toast.hbs",isStrictMode:!1})
class a extends l.default{get color(){switch(this.args.flash.type){case"info":return"highlight"
case"danger":return"critical"
case"warning":case"success":return this.args.flash.type
default:return"neutral"}}get title(){return this.args.title?this.args.title:"danger"===this.args.flash.type?"Error":(0,n.capitalize)(this.args.flash.type)}}e.default=a,(0,t.setComponentTemplate)(r,a)})),define("vault/components/flight-icon",["exports","@hashicorp/ember-flight-icons/components/flight-icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-error",["exports","core/components/form-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-groups-loop",["exports","core/components/form-field-groups-loop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-groups",["exports","core/components/form-field-groups"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-label",["exports","core/components/form-field-label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field",["exports","core/components/form-field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-save-buttons",["exports","core/components/form-save-buttons"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/generate-credentials-database",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{get errorTitle(){return this.args.model.errorTitle||"Something went wrong"}redirectPreviousPage(){window.history.back()}},i=l.prototype,r="redirectPreviousPage",a=[n.action],o=Object.getOwnPropertyDescriptor(l.prototype,"redirectPreviousPage"),s=l.prototype,u={},Object.keys(o).forEach((function(e){u[e]=o[e]})),u.enumerable=!!u.enumerable,u.configurable=!!u.configurable,("value"in u||u.initializer)&&(u.writable=!0),u=a.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),u),s&&void 0!==u.initializer&&(u.value=u.initializer?u.initializer.call(s):void 0,u.initializer=void 0),void 0===u.initializer&&Object.defineProperty(i,r,u),l)
var i,r,a,o,s,u})),define("vault/components/generate-credentials",["exports","@ember/component","@ember/service","@ember/object","@glimmer/component","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p,f
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,a.createTemplateFactory)({id:"3d1TTt/A",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,2],"vault.cluster.secrets.backend",[30,2]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],["Credentials","vault.cluster.secrets.backend",[30,2]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,3],"vault.cluster.secrets.backend.show",[30,3]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],[[30,0,["options","title"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[30,0,["options","title"]]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["hasGenerated"]],[[[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n    "],[8,[39,4],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n"],[41,[51,[30,0,["model","isError"]]],[[[1,"      "],[8,[39,6],[[24,0,"has-top-bottom-margin"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n        "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,"\\n          You will not be able to access this information later, so please copy the information below.\\n        "]],[]]]]],[1,"\\n      "]],[4]]]]],[1,"\\n"]],[]],null],[42,[28,[37,8],[[28,[37,8],[[30,0,["displayFields"]]],null]],null],null,[[[44,[[28,[37,10],[[30,0,["model","allByKey"]],[30,5]],null]],[[[41,[28,[37,11],[[30,6,["type"]],"object"],null],[[[1,"          "],[8,[39,12],null,[["@label","@value"],[[28,[37,13],[[28,[37,14],[[30,6,["options","label"]],[28,[37,15],[[28,[37,16],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,17],[[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[30,6,["options","masked"]],[[[41,[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null],[[[1,"              "],[8,[39,12],null,[["@label","@value"],[[28,[37,13],[[28,[37,14],[[30,6,["options","label"]],[28,[37,15],[[28,[37,16],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null]]],[["default"],[[[[1,"\\n                "],[8,[39,18],null,[["@value","@name","@displayOnly","@allowCopy"],[[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null],[30,6,["name"]],true,true]],null],[1,"\\n              "]],[]]]]],[1,"\\n"]],[]],null]],[]],[[[41,[28,[37,19],[[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null],[28,[37,14],[[28,[37,11],[[30,6,["name"]],"issueDate"],null],[28,[37,11],[[30,6,["name"]],"expiryDate"],null]],null]],null],[[[1,"            "],[8,[39,12],null,[["@label","@value"],[[28,[37,13],[[28,[37,14],[[30,6,["options","label"]],[28,[37,15],[[28,[37,16],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,20],[[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null],"MMM dd, yyyy hh:mm:ss a"],null]]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,12],null,[["@label","@value"],[[28,[37,13],[[28,[37,14],[[30,6,["options","label"]],[28,[37,15],[[28,[37,16],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,10],[[30,0,["model"]],[30,6,["name"]]],null]]],null],[1,"\\n          "]],[]]]],[]]]],[]]]],[6]]]],[5]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,21],[[24,0,"primary"]],[["@text","@textToCopy","@onError"],["Copy credentials",[30,0,["model","toCreds"]],[28,[37,22],[[28,[37,23],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["model","leaseId"]],[[[1,"      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,21],[[24,0,"secondary"]],[["@text","@textToCopy","@onError"],["Copy Lease ID",[30,0,["model","leaseId"]],[28,[37,22],[[28,[37,23],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,0],[14,0,"control"],[12],[1,"\\n"],[41,[30,0,["options","backIsListLink"]],[[[1,"        "],[8,[39,24],null,[["@text","@color","@route","@model"],["Back","secondary","vault.cluster.secrets.backend.list-root",[30,2]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,24],[[4,[38,25],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Back","secondary"]],null],[1,"\\n"]],[]]],[1,"    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,25],["submit",[30,0,["create"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless no-padding-top is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,26],null,[["@mode","@noun"],["generate","credential"]],null],[1,"\\n      "],[8,[39,4],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n"],[41,[30,0,["helpText"]],[[[1,"        "],[10,2],[14,0,"is-hint"],[12],[1,[30,0,["helpText"]]],[13],[1,"\\n"]],[]],null],[42,[28,[37,8],[[28,[37,8],[[30,0,["formFields"]]],null]],null],null,[[[1,"        "],[8,[39,27],null,[["@attr","@model"],[[28,[37,10],[[30,0,["model","allByKey"]],[30,7]],null],[30,0,["model"]]]],null],[1,"\\n"]],[7]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,28],null,null,[["default"],[[[[1,"\\n        "],[8,[39,24],[[16,"disabled",[30,0,["loading"]]],[24,4,"submit"]],[["@text","@icon"],["Generate",[52,[30,0,["loading"]],"loading"]]],null],[1,"\\n        "],[8,[39,24],null,[["@text","@route","@color","@model"],["Cancel","vault.cluster.secrets.backend.list-root","secondary",[30,2]]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p","@backendPath","@roleName","A","key","attr","key"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","if","message-error","unless","hds/alert","each","-track-array","let","get","eq","info-table-row","capitalize","or","humanize","dasherize","stringify","masked-input","and","date-format","hds/copy/button","fn","set-flash-message","hds/button","on","namespace-reminder","form-field","hds/button-set"]]',moduleName:"vault/components/generate-credentials.hbs",isStrictMode:!1}),v={ssh:{model:"ssh-otp-credential",title:"Generate SSH Credentials",formFields:["username","ip"],displayFields:["username","ip","key","keyType","port"]},aws:{model:"aws-credential",title:"Generate AWS Credentials",backIsListLink:!0,displayFields:["accessKey","secretKey","securityToken","leaseId","renewable","leaseDuration"],formFields:e=>({iam_user:["credentialType"],assumed_role:["credentialType","ttl","roleArn"],federation_token:["credentialType","ttl"],session_token:["credentialType","ttl"]}[e.credentialType])}}
let g=e.default=(o=class extends i.default{constructor(){super(...arguments),m(this,"controlGroup",s,this),m(this,"store",u,this),m(this,"router",c,this),m(this,"model",d,this),m(this,"loading",p,this),m(this,"hasGenerated",f,this),h(this,"emptyData","{\n}")
const e=this.modelForType()
this.model=this.generateNewModel(e)}willDestroy(){!(this.store&&!this.store.isDestroying)||this.model.isDestroyed||this.model.isDestroying||this.model.unloadRecord(),super.willDestroy()}modelForType(){const e=this.options
if(e)return e.model
this.router.transitionTo("vault.cluster.secrets.backend.list-root",this.args.backendPath)}get helpText(){return"aws-credential"===this.options?.model?"For Vault roles of credential type iam_user, there are no inputs, just submit the form. Choose a type to change the input options.":""}get options(){return v[this.args.backendType]}get formFields(){const e=this.options
return"function"==typeof e.formFields?e.formFields(this.model):e.formFields}get displayFields(){return this.options.displayFields}generateNewModel(e){if(!e)return
const{roleName:t,backendPath:n,awsRoleType:l}=this.args,i={role:{backend:n,name:t},id:`${n}-${t}`}
return l&&(i.credentialType=l),this.store.createRecord(e,i)}replaceModel(){const e=this.modelForType()
e&&(this.model&&this.model.unloadRecord(),this.model=this.generateNewModel(e))}create(e){e.preventDefault(),this.loading=!0,this.model.save().then((()=>{this.hasGenerated=!0})).catch((e=>{if("Control Group encountered"===e.message){this.controlGroup.saveTokenFromError(e)
const t=this.controlGroup.logFromError(e)
e.errors=[t.content]}throw e})).finally((()=>{this.loading=!1}))}codemirrorUpdated(e,t,n){n.performLint()
n.state.lint.marked.length>0||(this.model[e]=JSON.parse(t))}reset(){this.hasGenerated=!1,this.replaceModel()}},s=b(o.prototype,"controlGroup",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=b(o.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(o.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(o.prototype,"model",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(o.prototype,"loading",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=b(o.prototype,"hasGenerated",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),b(o.prototype,"create",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"create"),o.prototype),b(o.prototype,"codemirrorUpdated",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"codemirrorUpdated"),o.prototype),b(o.prototype,"reset",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"reset"),o.prototype),o);(0,t.setComponentTemplate)(y,g)})),define("vault/components/generated-item-list",["exports","@ember/service","@glimmer/component","@ember/object","@ember/owner","@glimmer/tracking"],(function(e,t,n,l,i,r){var a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends n.default{constructor(...e){super(...e),c(this,"router",o,this),c(this,"store",s,this),c(this,"itemToDelete",u,this)}refreshItemList(){const e=(0,i.getOwner)(this).lookup(`route:${this.router.currentRouteName}`)
this.store.clearAllDatasets(),e.refresh()}},o=d(a.prototype,"router",[t.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(a.prototype,"store",[t.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(a.prototype,"itemToDelete",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d(a.prototype,"refreshItemList",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"refreshItemList"),a.prototype),a)})),define("vault/components/generated-item",["exports","@ember-data/adapter/error","@ember/service","@ember/component","@ember/object","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({model:null,itemType:null,flashMessages:(0,n.service)(),router:(0,n.service)(),modelValidations:null,isFormInvalid:!1,props:(0,i.computed)("model",(function(){return this.model.serialize()})),validateForm(){if(this.model.validate&&this.model.isNew){const{isValid:e,state:t}=this.model.validate()
return this.setProperties({modelValidations:t,isFormInvalid:!e}),e}return this.set("isFormInvalid",!1),!0},saveModel:(0,r.task)((0,a.waitFor)((function*(){if(this.validateForm()){try{yield this.model.save()}catch(e){if(e instanceof t.default==!1)throw e
return}this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success(`Successfully saved ${this.itemType} ${this.model.id}.`)}}))),init(){this._super(...arguments),"edit"===this.mode&&this.model.fieldGroups.forEach((e=>{e.default&&e.default.forEach((e=>{const t=e.options&&e.options.fieldValue
t&&(this.model[e.name]=this.model[t])}))}))},actions:{onKeyUp(e,t){this.model.set(e,t)},deleteItem(){this.model.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success(`Successfully deleted ${this.itemType} ${this.model.id}.`)}))}}})})),define("vault/components/get-credentials-card",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"1NMV6eri",block:'[[[8,[39,0],[[24,0,"has-padding-l"],[17,1]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n  "],[11,"form"],[4,[38,1],["submit",[30,0,["transitionToCredential"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"is-flex-between is-fullwidth"],[12],[1,"\\n      "],[10,"h3"],[14,0,"title is-5"],[12],[1,[30,2]],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,2],[14,0,"has-top-margin-s has-bottom-margin-xs has-text-weight-semibold"],[12],[1,[30,3]],[13],[1,"\\n    "],[8,[39,2],null,[["@id","@models","@selectLimit","@backend","@fallbackComponent","@onChange","@placeholder"],["search-input-role",[30,4],"1",[30,5],"input-search",[30,0,["handleInput"]],[30,6]]],null],[1,"\\n    "],[8,[39,3],[[16,"disabled",[28,[37,4],[[30,0,["role"]]],null]],[24,4,"submit"]],[["@text","@color"],["Get credentials","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["&attrs","@title","@searchLabel","@models","@backend","@placeholder"],false,["hds/card/container","on","search-select","hds/button","not"]]',moduleName:"vault/components/get-credentials-card.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(...e){super(...e),c(this,"router",s,this),c(this,"role",u,this)}transitionToCredential(e){e.preventDefault()
const t=this.role
t&&this.router.transitionTo("vault.cluster.secrets.backend.credentials",t)}handleInput(e){Array.isArray(e)?this.role=e[0]:this.role=e}},s=d(o.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"role",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d(o.prototype,"transitionToCredential",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"transitionToCredential"),o.prototype),d(o.prototype,"handleInput",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"handleInput"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/hds/accordion/index",["exports","@hashicorp/design-system-components/components/hds/accordion/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/accordion/item/button",["exports","@hashicorp/design-system-components/components/hds/accordion/item/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/accordion/item/index",["exports","@hashicorp/design-system-components/components/hds/accordion/item/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/description",["exports","@hashicorp/design-system-components/components/hds/alert/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/index",["exports","@hashicorp/design-system-components/components/hds/alert/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/title",["exports","@hashicorp/design-system-components/components/hds/alert/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/copyright",["exports","@hashicorp/design-system-components/components/hds/app-footer/copyright"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/index",["exports","@hashicorp/design-system-components/components/hds/app-footer/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/item",["exports","@hashicorp/design-system-components/components/hds/app-footer/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/legal-links",["exports","@hashicorp/design-system-components/components/hds/app-footer/legal-links"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/link",["exports","@hashicorp/design-system-components/components/hds/app-footer/link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/app-footer/status-link",["exports","@hashicorp/design-system-components/components/hds/app-footer/status-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/index",["exports","@hashicorp/design-system-components/components/hds/app-frame/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/footer",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/header",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/main",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/main"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/modals",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/modals"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/sidebar",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/sidebar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/body",["exports","@hashicorp/design-system-components/components/hds/application-state/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/footer",["exports","@hashicorp/design-system-components/components/hds/application-state/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/header",["exports","@hashicorp/design-system-components/components/hds/application-state/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/index",["exports","@hashicorp/design-system-components/components/hds/application-state/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/badge-count/index",["exports","@hashicorp/design-system-components/components/hds/badge-count/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/badge/index",["exports","@hashicorp/design-system-components/components/hds/badge/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/index",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/item",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/truncation",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/truncation"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/button-set/index",["exports","@hashicorp/design-system-components/components/hds/button-set/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/button/index",["exports","@hashicorp/design-system-components/components/hds/button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/card/container",["exports","@hashicorp/design-system-components/components/hds/card/container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/copy-button",["exports","@hashicorp/design-system-components/components/hds/code-block/copy-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/description",["exports","@hashicorp/design-system-components/components/hds/code-block/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/index",["exports","@hashicorp/design-system-components/components/hds/code-block/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/title",["exports","@hashicorp/design-system-components/components/hds/code-block/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/copy/button/index",["exports","@hashicorp/design-system-components/components/hds/copy/button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/copy/snippet/index",["exports","@hashicorp/design-system-components/components/hds/copy/snippet/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/body",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/description",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/footer",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/header",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/overlay",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/overlay"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/dialog-primitive/wrapper",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/wrapper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/disclosure-primitive/index",["exports","@hashicorp/design-system-components/components/hds/disclosure-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dismiss-button/index",["exports","@hashicorp/design-system-components/components/hds/dismiss-button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/footer",["exports","@hashicorp/design-system-components/components/hds/dropdown/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/header",["exports","@hashicorp/design-system-components/components/hds/dropdown/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/index",["exports","@hashicorp/design-system-components/components/hds/dropdown/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/checkbox",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/checkbox"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/checkmark",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/checkmark"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/copy-item",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/copy-item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/description",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/generic",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/generic"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/interactive",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/interactive"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/radio",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/radio"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/separator",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/separator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/title",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/button",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/chevron",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/chevron"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/icon",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/body",["exports","@hashicorp/design-system-components/components/hds/flyout/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/description",["exports","@hashicorp/design-system-components/components/hds/flyout/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/footer",["exports","@hashicorp/design-system-components/components/hds/flyout/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/header",["exports","@hashicorp/design-system-components/components/hds/flyout/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/index",["exports","@hashicorp/design-system-components/components/hds/flyout/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/character-count/index",["exports","@hashicorp/design-system-components/components/hds/form/character-count/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/base",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/field",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/group",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/error/index",["exports","@hashicorp/design-system-components/components/hds/form/error/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/error/message",["exports","@hashicorp/design-system-components/components/hds/form/error/message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/field/index",["exports","@hashicorp/design-system-components/components/hds/form/field/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/form/fieldset/index",["exports","@hashicorp/design-system-components/components/hds/form/fieldset/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/file-input/base",["exports","@hashicorp/design-system-components/components/hds/form/file-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/file-input/field",["exports","@hashicorp/design-system-components/components/hds/form/file-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/helper-text/index",["exports","@hashicorp/design-system-components/components/hds/form/helper-text/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/indicator/index",["exports","@hashicorp/design-system-components/components/hds/form/indicator/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/label/index",["exports","@hashicorp/design-system-components/components/hds/form/label/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/legend/index",["exports","@hashicorp/design-system-components/components/hds/form/legend/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/masked-input/base",["exports","@hashicorp/design-system-components/components/hds/form/masked-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/masked-input/field",["exports","@hashicorp/design-system-components/components/hds/form/masked-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/description",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/group",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/index",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/label",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/base",["exports","@hashicorp/design-system-components/components/hds/form/radio/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/field",["exports","@hashicorp/design-system-components/components/hds/form/radio/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/group",["exports","@hashicorp/design-system-components/components/hds/form/radio/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/select/base",["exports","@hashicorp/design-system-components/components/hds/form/select/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/select/field",["exports","@hashicorp/design-system-components/components/hds/form/select/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/after-options",["exports","@hashicorp/design-system-components/components/hds/form/super-select/after-options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/multiple/base",["exports","@hashicorp/design-system-components/components/hds/form/super-select/multiple/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/multiple/field",["exports","@hashicorp/design-system-components/components/hds/form/super-select/multiple/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/option-group",["exports","@hashicorp/design-system-components/components/hds/form/super-select/option-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/placeholder",["exports","@hashicorp/design-system-components/components/hds/form/super-select/placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/single/base",["exports","@hashicorp/design-system-components/components/hds/form/super-select/single/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/single/field",["exports","@hashicorp/design-system-components/components/hds/form/super-select/single/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/text-input/base",["exports","@hashicorp/design-system-components/components/hds/form/text-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/text-input/field",["exports","@hashicorp/design-system-components/components/hds/form/text-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/textarea/base",["exports","@hashicorp/design-system-components/components/hds/form/textarea/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/textarea/field",["exports","@hashicorp/design-system-components/components/hds/form/textarea/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/base",["exports","@hashicorp/design-system-components/components/hds/form/toggle/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/form/toggle/field",["exports","@hashicorp/design-system-components/components/hds/form/toggle/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/group",["exports","@hashicorp/design-system-components/components/hds/form/toggle/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/visibility-toggle/index",["exports","@hashicorp/design-system-components/components/hds/form/visibility-toggle/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/icon-tile/index",["exports","@hashicorp/design-system-components/components/hds/icon-tile/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/interactive/index",["exports","@hashicorp/design-system-components/components/hds/interactive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/link/inline",["exports","@hashicorp/design-system-components/components/hds/link/inline"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/link/standalone",["exports","@hashicorp/design-system-components/components/hds/link/standalone"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/menu-primitive/index",["exports","@hashicorp/design-system-components/components/hds/menu-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/body",["exports","@hashicorp/design-system-components/components/hds/modal/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/footer",["exports","@hashicorp/design-system-components/components/hds/modal/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/header",["exports","@hashicorp/design-system-components/components/hds/modal/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/index",["exports","@hashicorp/design-system-components/components/hds/modal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/actions",["exports","@hashicorp/design-system-components/components/hds/page-header/actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/badges",["exports","@hashicorp/design-system-components/components/hds/page-header/badges"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/description",["exports","@hashicorp/design-system-components/components/hds/page-header/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/index",["exports","@hashicorp/design-system-components/components/hds/page-header/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/subtitle",["exports","@hashicorp/design-system-components/components/hds/page-header/subtitle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/title",["exports","@hashicorp/design-system-components/components/hds/page-header/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/compact/index",["exports","@hashicorp/design-system-components/components/hds/pagination/compact/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/info/index",["exports","@hashicorp/design-system-components/components/hds/pagination/info/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/arrow",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/arrow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/ellipsis",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/ellipsis"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/number",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/number"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/numbered/index",["exports","@hashicorp/design-system-components/components/hds/pagination/numbered/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/size-selector/index",["exports","@hashicorp/design-system-components/components/hds/pagination/size-selector/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/popover-primitive/index",["exports","@hashicorp/design-system-components/components/hds/popover-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/reveal/index",["exports","@hashicorp/design-system-components/components/hds/reveal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/reveal/toggle/button",["exports","@hashicorp/design-system-components/components/hds/reveal/toggle/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/rich-tooltip/bubble",["exports","@hashicorp/design-system-components/components/hds/rich-tooltip/bubble"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/rich-tooltip/index",["exports","@hashicorp/design-system-components/components/hds/rich-tooltip/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/rich-tooltip/toggle",["exports","@hashicorp/design-system-components/components/hds/rich-tooltip/toggle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/segmented-group/index",["exports","@hashicorp/design-system-components/components/hds/segmented-group/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/separator/index",["exports","@hashicorp/design-system-components/components/hds/separator/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/base",["exports","@hashicorp/design-system-components/components/hds/side-nav/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/home-link",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/home-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/icon-button",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/icon-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/back-link",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/back-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/item",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/link",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/title",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/portal/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/portal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/portal/target",["exports","@hashicorp/design-system-components/components/hds/side-nav/portal/target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/toggle-button",["exports","@hashicorp/design-system-components/components/hds/side-nav/toggle-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/step/indicator",["exports","@hashicorp/design-system-components/components/hds/stepper/step/indicator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/task/indicator",["exports","@hashicorp/design-system-components/components/hds/stepper/task/indicator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/index",["exports","@hashicorp/design-system-components/components/hds/table/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/td",["exports","@hashicorp/design-system-components/components/hds/table/td"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-button-sort",["exports","@hashicorp/design-system-components/components/hds/table/th-button-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-button-tooltip",["exports","@hashicorp/design-system-components/components/hds/table/th-button-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-selectable",["exports","@hashicorp/design-system-components/components/hds/table/th-selectable"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-sort",["exports","@hashicorp/design-system-components/components/hds/table/th-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th",["exports","@hashicorp/design-system-components/components/hds/table/th"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/tr",["exports","@hashicorp/design-system-components/components/hds/table/tr"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/index",["exports","@hashicorp/design-system-components/components/hds/tabs/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/panel",["exports","@hashicorp/design-system-components/components/hds/tabs/panel"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/tab",["exports","@hashicorp/design-system-components/components/hds/tabs/tab"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tag/index",["exports","@hashicorp/design-system-components/components/hds/tag/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/text/body",["exports","@hashicorp/design-system-components/components/hds/text/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/text/code",["exports","@hashicorp/design-system-components/components/hds/text/code"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/text/display",["exports","@hashicorp/design-system-components/components/hds/text/display"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/text/index",["exports","@hashicorp/design-system-components/components/hds/text/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/toast/index",["exports","@hashicorp/design-system-components/components/hds/toast/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tooltip-button/index",["exports","@hashicorp/design-system-components/components/hds/tooltip-button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/yield/index",["exports","@hashicorp/design-system-components/components/hds/yield/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/icon",["exports","core/components/icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/identity/edit-form",["exports","@ember/service","@ember/component","@ember/object","ember-concurrency","vault/helpers/humanize","@ember/test-waiters"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({flashMessages:(0,t.service)(),store:(0,t.service)(),"data-test-component":"identity-edit-form",attributeBindings:["data-test-component"],model:null,mode:"create",onSave:()=>{},cancelLink:(0,l.computed)("mode","model.identityType",(function(){const{model:e,mode:t}=this
return{"create-entity":"vault.cluster.access.identity","edit-entity":"vault.cluster.access.identity.show","merge-entity-merge":"vault.cluster.access.identity","create-entity-alias":"vault.cluster.access.identity.aliases","edit-entity-alias":"vault.cluster.access.identity.aliases.show","create-group":"vault.cluster.access.identity","edit-group":"vault.cluster.access.identity.show","create-group-alias":"vault.cluster.access.identity.aliases","edit-group-alias":"vault.cluster.access.identity.aliases.show"}[e?`${t}-${e.identityType}`:"merge-entity-alias"]})),getMessage(e,t=!1){const n=this.mode,l=(0,r.humanize)([e.identityType]),i=t?"deleted":"saved"
return"merge"===n?"Successfully merged entities":e.id?`Successfully ${i} ${l} ${e.id}.`:`Successfully ${i} ${l}.`},save:(0,i.task)((0,a.waitFor)((function*(){const e=this.model,t=this.getMessage(e)
try{yield e.save()}catch(n){return}this.flashMessages.success(t),yield this.onSave({saveType:"save",model:e})}))).drop(),willDestroy(){const e=this.store&&!this.store.isDestroying,t=this.model
e&&t&&t.isDirty&&!t.isDestroyed&&!t.isDestroying&&t.rollbackAttributes(),this._super(...arguments)},actions:{deleteItem(e){const t=this.getMessage(e,!0),n=this.flashMessages
e.destroyRecord().then((()=>(n.success(t),this.onSave({saveType:"delete",model:e}))))}}})})),define("vault/components/identity/entity-nav",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/components/identity/item-details",["exports","@ember/service","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({flashMessages:(0,t.service)(),actions:{enable(e){e.set("disabled",!1),e.save().then((()=>{this.flashMessages.success(`Successfully enabled entity: ${e.id}`)})).catch((t=>{this.flashMessages.success(`There was a problem enabling the entity: ${e.id} - ${t.errors.join(" ")||t.message}`)}))}}})})),define("vault/components/identity/lookup-input",["exports","@ember/service","@ember/component","ember-concurrency","vault/helpers/underscore"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({store:(0,t.service)(),flashMessages:(0,t.service)(),router:(0,t.service)(),type:"entity",param:"alias name",paramValue:null,aliasMountAccessor:null,authMethods:null,init(){this._super(...arguments),this.store.findAll("auth-method").then((e=>{this.set("authMethods",e),this.set("aliasMountAccessor",e[0].accessor)}))},adapter(){const e=this.type
return this.store.adapterFor(`identity/${e}`)},data(){const{param:e,paramValue:t,aliasMountAccessor:n}=this,l={}
return l[(0,i.underscore)([e])]=t,"alias name"===e&&(l.alias_mount_accessor=n),l},lookup:(0,l.task)((function*(){const e=this.flashMessages,t=this.type,n=this.store,{param:l,paramValue:i}=this
let r
try{r=yield this.adapter().lookup(n,this.data())}catch(a){return void e.danger(`We encountered an error attempting the ${t} lookup: ${a.message||a.errors.join("")}.`)}if(r)return this.router.transitionTo("vault.cluster.access.identity.show",r.id,"details")
e.danger(`We were unable to find an identity ${t} with a "${l}" of "${i}".`)}))})})),define("vault/components/identity/popup-alias",["exports","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","vault/utils/error-message"],(function(e,t,n,l,i,r){var a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),u(this,"flashMessages",o,this),u(this,"showConfirmModal",s,this)}onSuccess(e,t){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully deleted ${e}: ${t}`)}onError(e,t,n){this.args.onError&&this.args.onError()
const l=(0,r.default)(e)
this.flashMessages.danger(`There was a problem deleting ${t}: ${n} - ${l}`)}async deleteAlias(){const{identityType:e,id:t}=this.args.item
try{await this.args.item.destroyRecord(),this.onSuccess(e,t)}catch(n){this.onError(n,e,t)}}},o=c(a.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(a.prototype,"showConfirmModal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(a.prototype,"deleteAlias",[i.action],Object.getOwnPropertyDescriptor(a.prototype,"deleteAlias"),a.prototype),a)})),define("vault/components/identity/popup-members",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","vault/utils/error-message"],(function(e,t,n,l,i,r){var a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),u(this,"flashMessages",o,this),u(this,"showConfirmModal",s,this)}onSuccess(e){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully removed '${e}' from the group`)}onError(e,t){this.args.onError&&this.args.onError()
const n=(0,r.default)(e)
this.flashMessages.danger(`There was a problem removing '${t}' from the group - ${n}`)}transaction(){const e=this.args.model[this.args.groupArray]
return this.args.model[this.args.groupArray]=e.without(this.args.memberId),this.args.model.save()}async removeGroup(){const e=this.args.memberId
try{await this.transaction(),this.onSuccess(e)}catch(t){this.onError(t,e)}}},o=c(a.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(a.prototype,"showConfirmModal",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(a.prototype,"removeGroup",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"removeGroup"),a.prototype),a)})),define("vault/components/identity/popup-metadata",["exports","@ember/object","@ember/service","@glimmer/component","@glimmer/tracking","vault/utils/error-message"],(function(e,t,n,l,i,r){var a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends l.default{constructor(...e){super(...e),u(this,"flashMessages",o,this),u(this,"showConfirmModal",s,this)}onSuccess(e){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully removed '${e}' from metadata`)}onError(e,t){this.args.onError&&this.args.onError()
const n=(0,r.default)(e)
this.flashMessages.danger(`There was a problem removing '${t}' from the metadata - ${n}`)}transaction(){const e=this.args.model.metadata
return delete e[this.args.key],this.args.model.metadata={...e},this.args.model.save()}async removeMetadata(){const e=this.args.key
try{await this.transaction(),this.onSuccess(e)}catch(t){this.onError(t,e)}}},o=c(a.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(a.prototype,"showConfirmModal",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(a.prototype,"removeMetadata",[t.action],Object.getOwnPropertyDescriptor(a.prototype,"removeMetadata"),a.prototype),a)})),define("vault/components/identity/popup-policy",["exports","@glimmer/component","@ember/object","@ember/service","vault/utils/error-message","@glimmer/tracking"],(function(e,t,n,l,i,r){var a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),u(this,"flashMessages",o,this),u(this,"showConfirmModal",s,this)}onSuccess(e,t){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully removed '${e}' policy from ${t}`)}onError(e,t){this.args.onError&&this.args.onError()
const n=(0,i.default)(e)
this.flashMessages.danger(`There was a problem removing '${t}' policy - ${n}`)}transaction(){const e=this.args.model.policies
return this.args.model.policies=e.without(this.args.policyName),this.args.model.save()}async removePolicy(){const{policyName:e,model:{id:t}}=this.args
try{await this.transaction(),this.onSuccess(e,t)}catch(n){this.onError(n,e)}}},o=c(a.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(a.prototype,"showConfirmModal",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(a.prototype,"removePolicy",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"removePolicy"),a.prototype),a)})),define("vault/components/info-table-item-array",["exports","core/components/info-table-item-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-table-row",["exports","core/components/info-table-row"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-tooltip",["exports","core/components/info-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/input-search",["exports","core/components/input-search"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/json-editor",["exports","core/components/json-editor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/key-value-header",["exports","core/components/key-value-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/key-version-select",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({tagName:""})})),define("vault/components/keymgmt/distribute",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","vault/models/keymgmt/key","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let _=(u=P((s=class{constructor(){x(this,"key",u,this),x(this,"provider",c,this),x(this,"operations",d,this),x(this,"protection",p,this)}}).prototype,"key",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=P(s.prototype,"provider",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=P(s.prototype,"operations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=P(s.prototype,"protection",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s)
const T={gcpckms:["aes256-gcm96","rsa-2048","rsa-3072","rsa-4096","ecdsa-p256","ecdsa-p384","ecdsa-p521"],awskms:["aes256-gcm96"],azurekeyvault:["rsa-2048","rsa-3072","rsa-4096"]}
e.default=(f=class extends t.default{constructor(){super(...arguments),x(this,"store",m,this),x(this,"flashMessages",h,this),x(this,"router",b,this),x(this,"keyModel",y,this),x(this,"isNewKey",v,this),x(this,"providerType",g,this),x(this,"formData",w,this),x(this,"formErrors",k,this),this.formData=new _,this.formData.key=this.args.key||"",this.formData.provider=this.args.provider||"",this.args.provider&&this.getProviderType(this.args.provider),this.args.key&&this.getKeyInfo(this.args.key),this.formData.operations=[]}get keyTypes(){return r.KEY_TYPES}get validMatchError(){if(!this.providerType||!this.keyModel?.type)return null
const e=T[this.providerType]?.includes(this.keyModel.type)
if(e)return null
if(this.args.provider)return{key:`This key type is incompatible with the ${this.providerType} provider. To distribute to this provider, change the key type or choose another key.`}
const t=`This provider is incompatible with the ${this.keyModel.type} key type. Please choose another provider`
return{provider:this.args.key?`${t}.`:`${t} or change the key type.`}}get operations(){const e=this.providerType
if("awskms"===e)return["encrypt","decrypt"]
if("gcpckms"===e){switch(this.keyModel?.type||""){case"aes256-gcm96":return["encrypt","decrypt"]
case"rsa-2048":case"rsa-3072":case"rsa-4096":return["decrypt","sign"]
case"ecdsa-p256":case"ecdsa-p384":return["sign"]
default:return["encrypt","decrypt","sign","verify","wrap","unwrap"]}}return["encrypt","decrypt","sign","verify","wrap","unwrap"]}get disableOperations(){return this.validMatchError||!this.formData.provider||!this.formData.key||this.isNewKey&&!this.keyModel.type}async getKeyInfo(e,t=!1){let n
t?(this.isNewKey=!0,n=this.store.createRecord("keymgmt/key",{backend:this.args.backend,id:e,name:e})):n=await this.store.queryRecord("keymgmt/key",{backend:this.args.backend,id:e,recordOnly:!0}).catch((()=>{})),this.keyModel=n}async getProviderType(e){if(!e)return void(this.providerType="")
const t=await this.store.queryRecord("keymgmt/provider",{backend:this.args.backend,id:e}).catch((()=>{}))
this.providerType=t?.provider}destroyKey(){this.isNewKey&&this.keyModel.destroyRecord().finally((()=>{this.keyModel=null})),this.isNewKey=!1,this.keyModel=null}formatData(e){const{key:t,provider:n,operations:l,protection:i}=e
return t&&n&&l&&0!==l.length?{key:t,provider:n,purpose:l.join(","),protection:i}:null}distributeKey(e,t){const n=this.store.adapterFor("keymgmt/key"),{key:l,provider:i,purpose:r,protection:a}=t
return n.distribute(e,i,l,{purpose:r,protection:a}).then((()=>{this.flashMessages.success(`Successfully distributed key ${l} to ${i}`),this.store.clearDataset("keymgmt/key")
const e=this.store.peekRecord("keymgmt/provider",i)
e.fetchKeys(e.keys?.meta?.currentPage||1),this.args.onClose()})).catch((e=>{this.formErrors=`${e.errors}`}))}handleProvider(e){let t=e[0]
"string"==typeof e&&(t=e),this.formData.provider=t,t&&this.getProviderType(t)}handleKeyType(e){this.keyModel.set("type",e.target.value)}handleOperation(e){const t=[...this.formData.operations]
if(e.target.checked)t.push(e.target.id)
else{const n=t.indexOf(e.target.id)
t.splice(n,1)}this.formData.operations=t}async handleKeySelect(e){const t=e[0]||null
return t?(this.formData.key=t.id,this.getKeyInfo(t.id,t.isNew)):(this.formData.key=null,this.destroyKey())}*createDistribution(e){e.preventDefault()
const{backend:t}=this.args,n=this.formatData(this.formData)
if(n){if(this.isNewKey)try{yield this.keyModel.save(),this.flashMessages.success(`Successfully created key ${this.keyModel.name}`)}catch(l){return void this.flashMessages.danger(`Error creating new key ${this.keyModel.name}: ${l.errors}`)}yield this.distributeKey(t,n),yield this.store.queryRecord("keymgmt/key",{backend:this.args.backend,id:this.keyModel.name})}else this.flashMessages.danger("Key, provider, and operations are all required")}},m=P(f.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=P(f.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=P(f.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=P(f.prototype,"keyModel",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=P(f.prototype,"isNewKey",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),g=P(f.prototype,"providerType",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=P(f.prototype,"formData",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=P(f.prototype,"formErrors",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P(f.prototype,"handleProvider",[n.action],Object.getOwnPropertyDescriptor(f.prototype,"handleProvider"),f.prototype),P(f.prototype,"handleKeyType",[n.action],Object.getOwnPropertyDescriptor(f.prototype,"handleKeyType"),f.prototype),P(f.prototype,"handleOperation",[n.action],Object.getOwnPropertyDescriptor(f.prototype,"handleOperation"),f.prototype),P(f.prototype,"handleKeySelect",[n.action],Object.getOwnPropertyDescriptor(f.prototype,"handleKeySelect"),f.prototype),P(f.prototype,"createDistribution",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(f.prototype,"createDistribution"),f.prototype),f)})),define("vault/components/keymgmt/key-edit",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,i,r,a){var o,s,u,c,d
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m="vault.cluster.secrets.backend.show"
e.default=(o=class extends t.default{constructor(...e){super(...e),p(this,"store",s,this),p(this,"router",u,this),p(this,"flashMessages",c,this),p(this,"isDeleteModalOpen",d,this)}get mode(){return this.args.mode||"show"}get keyAdapter(){return this.store.adapterFor("keymgmt/key")}get isMutable(){return["create","edit"].includes(this.args.mode)}get isCreating(){return"create"===this.args.mode}*saveKey(e){e.preventDefault()
const{model:t}=this.args
try{yield t.save(),this.router.transitionTo(m,t.name)}catch(n){let e=n
n.errors&&(e=n.errors.join(". ")),this.flashMessages.danger(e),n.errors||this.router.transitionTo(m,t.name)}}*removeKey(){try{yield this.keyAdapter.removeFromProvider(this.args.model),yield this.args.model.reload(),this.flashMessages.success("Key has been successfully removed from provider")}catch(e){this.flashMessages.danger(e.errors?.join(". "))}}deleteKey(){const e=this.args.model,t=e.backend
e.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.secrets.backend.list-root",t)})).catch((e=>{this.flashMessages.danger(e.errors?.join(". "))}))}*rotateKey(){const e=this.args.model.name,t=this.args.model.backend,n=this.keyAdapter
yield n.rotateKey(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},s=f(o.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(o.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(o.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(o.prototype,"isDeleteModalOpen",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f(o.prototype,"saveKey",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"saveKey"),o.prototype),f(o.prototype,"removeKey",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"removeKey"),o.prototype),f(o.prototype,"deleteKey",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"deleteKey"),o.prototype),f(o.prototype,"rotateKey",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"rotateKey"),o.prototype),o)})),define("vault/components/keymgmt/provider-edit",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency","@ember/test-waiters","vault/helpers/remove-from-array"],(function(e,t,n,l,i,r,a,o){var s,u,c,d
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(s=class extends t.default{constructor(){super(...arguments),p(this,"router",u,this),p(this,"flashMessages",c,this),p(this,"modelValidations",d,this),"show"===this.args.mode&&this.fetchKeys.perform()}get isShowing(){return"show"===this.args.mode}get isCreating(){return"create"===this.args.mode}get viewingKeys(){return"keys"===this.args.tab}*saveTask(){const{model:e}=this.args
try{yield e.save(),this.router.transitionTo("vault.cluster.secrets.backend.show",e.id,{queryParams:{itemType:"provider"}})}catch(t){this.flashMessages.danger(t.errors.join(". "))}}*fetchKeys(e){try{yield this.args.model.fetchKeys(e)}catch(t){this.flashMessages.danger(t.errors.join(". "))}}async onSave(e){e.preventDefault()
const{isValid:t,state:n}=await this.args.model.validate()
t?(this.modelValidations=null,this.saveTask.perform()):this.modelValidations=n}async onDelete(){try{const{model:e,root:t}=this.args
await e.destroyRecord(),this.router.transitionTo(t.path,t.model,{queryParams:{tab:"provider"}})}catch(e){this.flashMessages.danger(e.errors.join(". "))}}async onDeleteKey(e){try{const t=(0,o.removeFromArray)(this.args.model.keys,e)
await e.destroyRecord(),this.args.model.keys=t}catch(t){this.flashMessages.danger(t.errors.join(". "))}}},u=f(s.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(s.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(s.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f(s.prototype,"saveTask",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(s.prototype,"saveTask"),s.prototype),f(s.prototype,"fetchKeys",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(s.prototype,"fetchKeys"),s.prototype),f(s.prototype,"onSave",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onSave"),s.prototype),f(s.prototype,"onDelete",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onDelete"),s.prototype),f(s.prototype,"onDeleteKey",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onDeleteKey"),s.prototype),s)})),define("vault/components/kv-object-editor",["exports","core/components/kv-object-editor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/kv-suggestion-input",["exports","core/components/kv-suggestion-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/layout-loading",["exports","core/components/layout-loading"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/license-banners",["exports","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","date-fns/isAfter","date-fns/differenceInDays","vault/lib/local-storage","core/utils/timestamp"],(function(e,t,n,l,i,r,a,o,s){var u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(u=class extends t.default{constructor(){super(...arguments),f(this,"version",c,this),f(this,"warningDismissed",d,this),f(this,"expiredDismissed",p,this)
const e=o.default.getItem(this.dismissedBannerKey)
this.updateDismissType(e)}get currentVersion(){return this.version.version}get dismissedBannerKey(){return`dismiss-license-banner-${this.currentVersion}-${this.args.expiry}`}get licenseExpired(){return!!this.args.expiry&&(0,r.default)(s.default.now(),new Date(this.args.expiry))}get licenseExpiringInDays(){return this.args.expiry?(0,a.default)(new Date(this.args.expiry),s.default.now()):99}dismissBanner(e){o.default.cleanupStorage("dismiss-license-banner",this.dismissedBannerKey),o.default.setItem(this.dismissedBannerKey,e),this.updateDismissType(e)}updateDismissType(e){"warning"===e?this.warningDismissed=!0:"expired"===e&&(this.expiredDismissed=!0)}},c=m(u.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(u.prototype,"warningDismissed",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(u.prototype,"expiredDismissed",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(u.prototype,"dismissBanner",[n.action],Object.getOwnPropertyDescriptor(u.prototype,"dismissBanner"),u.prototype),u)}))
define("vault/components/license-info",["exports","@ember/component","@glimmer/component","vault/helpers/all-features","@ember/template-factory"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)(
/*
    {{!
    Copyright (c) HashiCorp, Inc.
    SPDX-License-Identifier: BUSL-1.1
  ~}}
  
  <PageHeader as |p|>
    <p.levelLeft>
      <h1 class="title is-3">License</h1>
    </p.levelLeft>
  </PageHeader>
  
  <section class="box is-sideless is-marginless is-shadowless is-fullwidth">
    <span class="title is-5">Details</span>
    <div class="field box is-fullwidth is-shadowless is-paddingless is-marginless">
      <InfoTableRow @label="License ID" @value={{@licenseId}} data-test-detail-row />
      <InfoTableRow @label="Valid from" @value={{@startTime}} data-test-detail-row>
        {{date-format @startTime "MMM dd, yyyy hh:mm:ss a"}}
        to
        {{date-format @expirationTime "MMM dd, yyyy hh:mm:ss a"}}
      </InfoTableRow>
      <InfoTableRow @label="License state" @value={{"Autoloaded"}} data-test-detail-row />
    </div>
  </section>
  
  <section class="box is-sideless is-marginless is-shadowless is-fullwidth">
    <span class="title is-5">Features</span>
    <div class="field box is-fullwidth is-shadowless is-paddingless is-marginless">
      {{#each this.featuresInfo as |info|}}
        <InfoTableRow @label={{info.name}} @value={{if info.active "Active" "Not Active"}} data-test-feature-row>
          {{#if info.active}}
            <Icon @name="check-circle" class="icon-true" />
            <span data-test-feature-status>
              Active
              {{#if info.count}}&mdash; {{info.count}} standby nodes allotted{{/if}}
            </span>
          {{else}}
            <Icon @name="x-circle" class="icon-false" />
            <span data-test-feature-status>Not Active</span>
          {{/if}}
        </InfoTableRow>
      {{/each}}
    </div>
  </section>
  */
{id:"4GZArJyg",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"License"],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[10,"section"],[14,0,"box is-sideless is-marginless is-shadowless is-fullwidth"],[12],[1,"\\n  "],[10,1],[14,0,"title is-5"],[12],[1,"Details"],[13],[1,"\\n  "],[10,0],[14,0,"field box is-fullwidth is-shadowless is-paddingless is-marginless"],[12],[1,"\\n    "],[8,[39,1],null,[["@label","@value"],["License ID",[30,2]]],null],[1,"\\n    "],[8,[39,1],null,[["@label","@value"],["Valid from",[30,3]]],[["default"],[[[[1,"\\n      "],[1,[28,[35,2],[[30,3],"MMM dd, yyyy hh:mm:ss a"],null]],[1,"\\n      to\\n      "],[1,[28,[35,2],[[30,4],"MMM dd, yyyy hh:mm:ss a"],null]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,1],null,[["@label","@value"],["License state","Autoloaded"]],null],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[10,"section"],[14,0,"box is-sideless is-marginless is-shadowless is-fullwidth"],[12],[1,"\\n  "],[10,1],[14,0,"title is-5"],[12],[1,"Features"],[13],[1,"\\n  "],[10,0],[14,0,"field box is-fullwidth is-shadowless is-paddingless is-marginless"],[12],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,0,["featuresInfo"]]],null]],null],null,[[[1,"      "],[8,[39,1],null,[["@label","@value"],[[30,5,["name"]],[52,[30,5,["active"]],"Active","Not Active"]]],[["default"],[[[[1,"\\n"],[41,[30,5,["active"]],[[[1,"          "],[8,[39,6],[[24,0,"icon-true"]],[["@name"],["check-circle"]],null],[1,"\\n          "],[10,1],[12],[1,"\\n            Active\\n            "],[41,[30,5,["count"]],[[[1,"— "],[1,[30,5,["count"]]],[1," standby nodes allotted"]],[]],null],[1,"\\n          "],[13],[1,"\\n"]],[]],[[[1,"          "],[8,[39,6],[[24,0,"icon-false"]],[["@name"],["x-circle"]],null],[1,"\\n          "],[10,1],[12],[1,"Not Active"],[13],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n"]],[5]],null],[1,"  "],[13],[1,"\\n"],[13]],["p","@licenseId","@startTime","@expirationTime","info"],false,["page-header","info-table-row","date-format","each","-track-array","if","icon"]]',moduleName:"vault/components/license-info.hbs",isStrictMode:!1})

;/**
   * @module LicenseInfo
   *
   * @example
   * ```js
   * <LicenseInfo
   *   @startTime="2020-03-12T23:20:50.52Z"
   *   @expirationTime="2021-05-12T23:20:50.52Z"
   *   @licenseId="some-license-id"
   *   @features={{array 'Namespaces' 'DR Replication'}}
   *   @autoloaded={{true}}
   *   @performanceStandbyCount=1
   * />
   *
   * @param {string} startTime - RFC3339 formatted timestamp of when the license became active
   * @param {string} expirationTime - RFC3339 formatted timestamp of when the license will expire
   * @param {string} licenseId - unique ID of the license
   * @param {Array<string>} features - Array of feature names active on license
   * @param {boolean} autoloaded - Whether the license is autoloaded
   * @param {number} performanceStandbyCount - Number of performance standbys active
   */class a extends n.default{get featuresInfo(){const e=this.args.features.filter((e=>!(0,l.allFeatures)().includes(e)))
return[...(0,l.allFeatures)(),...e].map((e=>{const t=this.args.features.includes(e)
if(t&&"Performance Standby"===e){const n=this.args.performanceStandbyCount
return{name:e,active:!!n&&t,count:n}}return{name:e,active:t}}))}}e.default=a,(0,t.setComponentTemplate)(r,a)})),define("vault/components/lineal/arc/index",["exports","@lineal-viz/lineal/components/lineal/arc/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/arcs/index",["exports","@lineal-viz/lineal/components/lineal/arcs/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/area/index",["exports","@lineal-viz/lineal/components/lineal/area/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/axis/index",["exports","@lineal-viz/lineal/components/lineal/axis/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/bars/index",["exports","@lineal-viz/lineal/components/lineal/bars/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/fluid/index",["exports","@lineal-viz/lineal/components/lineal/fluid/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/gridlines/index",["exports","@lineal-viz/lineal/components/lineal/gridlines/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/h-bars/index",["exports","@lineal-viz/lineal/components/lineal/h-bars/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/line/index",["exports","@lineal-viz/lineal/components/lineal/line/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/points/index",["exports","@lineal-viz/lineal/components/lineal/points/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/v-bars/index",["exports","@lineal-viz/lineal/components/lineal/v-bars/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/link-status",["exports","@glimmer/component","@ember/service"],(function(e,t,n){var l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="version",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}get state(){return this.args.status?"connected"===this.args.status?this.args.status:this.args.status.split(" ",1).toString():null}get timestamp(){try{return"connected"!==this.state?this.args.status.split("since")[1].split(";")[0].trim():null}catch{return null}}get error(){const e=this.args.status
return e&&"connected"!==e?e.split("error:")[1]:null}},r=l.prototype,a="version",o=[n.service],s={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/components/link-to-external",["exports","ember-engines/components/link-to-external"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/linked-block",["exports","core/components/linked-block"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item",["exports","core/components/list-item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item/content",["exports","core/components/list-item/content"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item/popup-menu",["exports","core/components/list-item/popup-menu"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-view",["exports","core/components/list-view"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/loading-dropdown-option",["exports","core/components/loading-dropdown-option"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/logo-edition",["exports","@ember/component","@ember/service","@ember/template-factory"],(function(e,t,n,l){var i,r
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,l.createTemplateFactory)({id:"N0p/Sw/d",block:'[[[10,"svg"],[14,"width","146"],[14,"height","51"],[14,"viewBox","0 0 146 51"],[14,"xmlns","http://www.w3.org/2000/svg","http://www.w3.org/2000/xmlns/"],[12],[1,"\\n  "],[10,"g"],[14,1,"vault-logo-v"],[14,"fill-rule","nonzero"],[12],[1,"\\n    "],[10,"path"],[14,"d","M0,0 L25.4070312,51 L51,0 L0,0 Z M28.5,10.5 L31.5,10.5 L31.5,13.5 L28.5,13.5 L28.5,10.5 Z M22.5,22.5 L19.5,22.5 L19.5,19.5 L22.5,19.5 L22.5,22.5 Z M22.5,18 L19.5,18 L19.5,15 L22.5,15 L22.5,18 Z M22.5,13.5 L19.5,13.5 L19.5,10.5 L22.5,10.5 L22.5,13.5 Z M26.991018,27 L24,27 L24,24 L27,24 L26.991018,27 Z M26.991018,22.5 L24,22.5 L24,19.5 L27,19.5 L26.991018,22.5 Z M26.991018,18 L24,18 L24,15 L27,15 L26.991018,18 Z M26.991018,13.5 L24,13.5 L24,10.5 L27,10.5 L26.991018,13.5 Z M28.5,15 L31.5,15 L31.5,18 L28.5089552,18 L28.5,15 Z M28.5,22.5 L28.5,19.5 L31.5,19.5 L31.5,22.4601182 L28.5,22.5 Z"],[12],[13],[1,"\\n  "],[13],[1,"\\n\\n  "],[10,"path"],[14,1,"vault-logo-name"],[14,"d","M69.7218638,30.2482468 L63.2587814,8.45301543 L58,8.45301543 L65.9885305,34.6072931 L73.4551971,34.6072931 L81.4437276,8.45301543 L76.1849462,8.45301543 L69.7218638,30.2482468 Z M97.6329749,22.0014025 C97.6329749,17.2103787 95.8265233,15.0897616 89.6845878,15.0897616 C87.5168459,15.0897616 84.8272401,15.4431978 82.9806452,15.9929874 L83.5827957,19.6451613 C85.3089606,19.2917251 87.2358423,19.056101 89.0021505,19.056101 C92.1333333,19.056101 92.7354839,19.802244 92.7354839,21.9228612 L92.7354839,23.9256662 L88.0387097,23.9256662 C84.0645161,23.9256662 82.3383513,25.4179523 82.3383513,29.3057504 C82.3383513,32.6044881 83.8637993,35 87.4365591,35 C89.4035842,35 91.4910394,34.4502104 93.2573477,33.3113604 L93.618638,34.6072931 L97.6329749,34.6072931 L97.6329749,22.0014025 Z M92.7354839,30.2089762 C91.8121864,30.7194951 90.4874552,31.1907433 89.0422939,31.1907433 C87.5168459,31.1907433 87.0752688,30.601683 87.0752688,29.2664797 C87.0752688,27.8134642 87.5168459,27.3814867 89.1225806,27.3814867 L92.7354839,27.3814867 L92.7354839,30.2089762 Z M102.421505,15.4824684 L102.421505,29.345021 C102.421505,32.7615708 103.585663,35 106.837276,35 C109.125448,35 112.216487,34.1753156 114.665233,32.997195 L115.146953,34.6072931 L118.880287,34.6072931 L118.880287,15.4824684 L113.982796,15.4824684 L113.982796,28.7559607 C112.216487,29.6591865 110.088889,30.3660589 108.884588,30.3660589 C107.760573,30.3660589 107.318996,29.85554 107.318996,28.8345021 L107.318996,15.4824684 L102.421505,15.4824684 Z M129.168459,34.6072931 L129.168459,7 L124.270968,7.66760168 L124.270968,34.6072931 L129.168459,34.6072931 Z M144.394265,30.601683 C143.551254,30.8373072 142.6681,30.9943899 141.94552,30.9943899 C140.660932,30.9943899 140.179211,30.3267882 140.179211,29.3057504 L140.179211,19.2917251 L144.875986,19.2917251 L145.197133,15.4824684 L140.179211,15.4824684 L140.179211,10.0631136 L135.28172,10.7307153 L135.28172,15.4824684 L132.351254,15.4824684 L132.351254,19.2917251 L135.28172,19.2917251 L135.28172,29.9340813 C135.28172,33.3506311 137.088172,35 140.660932,35 C141.905376,35 143.912545,34.6858345 144.956272,34.2538569 L144.394265,30.601683 Z"],[12],[13],[1,"\\n\\n"],[41,[30,0,["version","isEnterprise"]],[[[1,"    "],[10,"g"],[14,1,"vault-logo-edition-enterprise"],[14,"transform","translate(65.000000, 40.000000)"],[14,"fill-rule","nonzero"],[12],[1,"\\n      "],[10,"polygon"],[14,"points","0.435816733 0.579322709 4.39438247 0.579322709 4.39438247 1.35454183 1.30175299 1.35454183 1.30175299 3.46577689 4.17171315 3.46577689 4.17171315 4.24099602 1.30175299 4.24099602 1.30175299 6.52541833 4.40262948 6.52541833 4.40262948 7.30063745 0.435816733 7.30063745"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","7.3138247 1.58545817 7.3138247 7.31713147 6.48912351 7.31713147 6.48912351 0.579322709 7.68494024 0.579322709 10.6126295 6.35223108 10.6126295 0.579322709 11.4373307 0.579322709 11.4373307 7.31713147 10.249761 7.31713147"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","15.107251 1.36278884 13.1032271 1.36278884 13.1032271 0.587569721 17.9937052 0.587569721 17.9937052 1.36278884 15.9814343 1.36278884 15.9814343 7.31713147 15.107251 7.31713147"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","19.6513546 0.579322709 23.6099203 0.579322709 23.6099203 1.35454183 20.5172908 1.35454183 20.5172908 3.46577689 23.387251 3.46577689 23.387251 4.24099602 20.5172908 4.24099602 20.5172908 6.52541833 23.6181673 6.52541833 23.6181673 7.30063745 19.6431076 7.30063745"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M28.22,4.87601594 L26.5705976,4.87601594 L26.5705976,7.35011952 L25.7046614,7.35011952 L25.7046614,0.579322709 L28.2694821,0.579322709 C29.7127092,0.579322709 30.2240239,1.20609562 30.2240239,2.2287251 L30.2240239,3.20187251 C30.3204128,3.92160892 29.8576792,4.59791178 29.1519124,4.76880478 L30.9002789,7.30888446 L29.9023904,7.30888446 L28.22,4.87601594 Z M28.22,1.35454183 L26.5705976,1.35454183 L26.5705976,4.10079681 L28.22,4.10079681 C29.0447012,4.10079681 29.3333466,3.86988048 29.3333466,3.21011952 L29.3333466,2.25346614 C29.3580876,1.58545817 29.0694422,1.36278884 28.244741,1.36278884 L28.22,1.35454183 Z"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M32.6898805,0.579322709 L35.1639841,0.579322709 C36.6072112,0.579322709 37.1185259,1.20609562 37.1185259,2.2287251 L37.1185259,3.22661355 C37.1185259,4.26573705 36.6154582,4.87601594 35.1639841,4.87601594 L33.5970518,4.87601594 L33.5970518,7.31713147 L32.7311155,7.31713147 L32.6898805,0.579322709 Z M35.098008,1.35454183 L33.5640637,1.35454183 L33.5640637,4.12553785 L35.098008,4.12553785 C35.9227092,4.12553785 36.2113546,3.89462151 36.2113546,3.23486056 L36.2113546,2.24521912 C36.2113546,1.58545817 35.9309562,1.36278884 35.098008,1.36278884 L35.098008,1.35454183 Z"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M41.4399602,4.87601594 L39.7905578,4.87601594 L39.7905578,7.35011952 L38.9246215,7.35011952 L38.9246215,0.579322709 L41.4894422,0.579322709 C42.9326693,0.579322709 43.4439841,1.20609562 43.4439841,2.2287251 L43.4439841,3.20187251 C43.5403729,3.92160892 43.0776394,4.59791178 42.3718725,4.76880478 L44.120239,7.30888446 L43.1223506,7.30888446 L41.4399602,4.87601594 Z M41.4399602,1.35454183 L39.7905578,1.35454183 L39.7905578,4.10079681 L41.4399602,4.10079681 C42.2646614,4.10079681 42.5533068,3.86988048 42.5533068,3.21011952 L42.5533068,2.25346614 C42.5698008,1.58545817 42.2894024,1.36278884 41.4564542,1.36278884 L41.4399602,1.35454183 Z"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","46.8087649 7.31713147 45.9840637 7.31713147 45.9840637 0.579322709 46.8087649 0.579322709"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M50.9322709,7.41609562 C50.2485334,7.41749872 49.5699834,7.29742608 48.928247,7.0614741 L49.0684462,6.35223108 C49.6711823,6.54568134 50.2993133,6.64851694 50.9322709,6.65737052 C52.0126295,6.65737052 52.2352988,6.37697211 52.2352988,5.61 C52.2352988,4.70282869 52.2352988,4.62035857 50.8415538,4.30697211 C49.1921514,3.94410359 49.0189641,3.63071713 49.0189641,2.23697211 C49.0189641,1.06589641 49.5055378,0.49685259 51.1714343,0.49685259 C51.7856888,0.497823804 52.3976026,0.572582499 52.9940239,0.719521912 L52.9198008,1.45350598 C52.3508265,1.32930718 51.7702971,1.26572539 51.1879283,1.2638247 C50.0828287,1.2638247 49.8849004,1.48649402 49.8849004,2.26171315 C49.8849004,3.1936255 49.8849004,3.23486056 51.2209163,3.56474104 C53.0105179,4.01007968 53.1012351,4.27398406 53.1012351,5.58525896 C53.1342231,6.74808765 52.7878486,7.41609562 50.9322709,7.41609562 Z"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","55.2454582 0.579322709 59.1792829 0.579322709 59.1792829 1.35454183 56.0866534 1.35454183 56.0866534 3.46577689 58.9566135 3.46577689 58.9566135 4.24099602 56.0866534 4.24099602 56.0866534 6.52541833 59.1875299 6.52541833 59.1875299 7.30063745 55.2124701 7.30063745"],[12],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[13]],[],false,["if"]]',moduleName:"vault/components/logo-edition.hbs",isStrictMode:!1})
let o=e.default=(i=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="version",i=this,(l=r)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}},s=i.prototype,u="version",c=[n.service],d={configurable:!0,enumerable:!0,writable:!0,initializer:null},f={},Object.keys(d).forEach((function(e){f[e]=d[e]})),f.enumerable=!!f.enumerable,f.configurable=!!f.configurable,("value"in f||f.initializer)&&(f.writable=!0),f=c.slice().reverse().reduce((function(e,t){return t(s,u,e)||e}),f),p&&void 0!==f.initializer&&(f.value=f.initializer?f.initializer.call(p):void 0,f.initializer=void 0),r=void 0===f.initializer?(Object.defineProperty(s,u,f),null):f,i)
var s,u,c,d,p,f;(0,t.setComponentTemplate)(a,o)})),define("vault/components/masked-input",["exports","core/components/masked-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/message-error",["exports","core/components/message-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/mfa/method-form",["exports","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","ember-concurrency"],(function(e,t,n,l,i,r){var a,o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),d(this,"store",o,this),d(this,"flashMessages",s,this),d(this,"editValidations",u,this),d(this,"isEditModalActive",c,this)}*save(){try{yield this.args.model.save(),this.args.onSave()}catch(e){this.flashMessages.danger(e.errors?.join(". ")||e.message)}}async initSave(e){e.preventDefault()
const{isValid:t,state:n}=await this.args.model.validate()
t?this.isEditModalActive=!0:this.editValidations=n}cancel(){this.args.model.rollbackAttributes(),this.args.onClose()}},o=p(a.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(a.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(a.prototype,"editValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(a.prototype,"isEditModalActive",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(a.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(a.prototype,"save"),a.prototype),p(a.prototype,"initSave",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"initSave"),a.prototype),p(a.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"cancel"),a.prototype),a)})),define("vault/components/mfa/mfa-form",["exports","ember","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","ember-concurrency","vault/helpers/number-to-word"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.TOTP_VALIDATION_ERROR=void 0
const h=e.TOTP_VALIDATION_ERROR="The passcode failed to validate. If you entered the correct passcode, contact your administrator."
e.default=(s=class extends n.default{constructor(){super(...arguments),f(this,"auth",u,this),f(this,"countdown",c,this),f(this,"error",d,this),f(this,"codeDelayMessage",p,this)
this.constraints.filter((e=>e.methods.length>1||e.methods.find((e=>e.uses_passcode)))).length||this.validate.perform()}get constraints(){return this.args.authData.mfa_requirement.mfa_constraints}get multiConstraint(){return this.constraints.length>1}get singleConstraintMultiMethod(){return!this.isMultiConstraint&&this.constraints[0].methods.length>1}get singlePasscode(){return!this.isMultiConstraint&&1===this.constraints[0].methods.length&&this.constraints[0].methods[0].uses_passcode}get description(){let e="Multi-factor authentication is enabled for your account."
if(this.singlePasscode&&(e+=" Enter your authentication code to log in."),this.singleConstraintMultiMethod&&(e+=" Select the MFA method you wish to use."),this.multiConstraint){const t=this.constraints.length
e+=` ${(0,o.numberToWord)(t,!0)} methods are required for successful authentication.`}return e}*validate(){try{this.error=null
const e=yield this.auth.totpValidate({clusterId:this.args.clusterId,...this.args.authData})
this.args.onSuccess(e)}catch(e){const t=e.errors||[],n=t.find((e=>e.includes("code already used"))),l=t.find((e=>e.includes("maximum TOTP validation attempts"))),i=n||l
if(i){const e=n?"This code has already been used":"Maximum validation attempts exceeded"
this.codeDelayMessage=`${e}. Please wait until a new code is available.`,this.newCodeDelay.perform(i)}else this.singlePasscode?this.error=h:this.args.onError(this.auth.handleError(e))}}*newCodeDelay(e){let n
const l=e.match(/(\d+\w seconds)/)
if(n=l&&l.length?l[0].split(" ")[0]:30,this.countdown=parseInt(n),!t.default.testing)for(;this.countdown>0;)yield(0,a.timeout)(1e3),this.countdown--}onSelect(e,t){(0,r.set)(e,"selectedId",t),(0,r.set)(e,"selectedMethod",e.methods.find((e=>e.id===t)))}submit(e){e.preventDefault(),this.validate.perform()}},u=m(s.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"countdown",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),d=m(s.prototype,"error",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"codeDelayMessage",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(s.prototype,"validate",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"validate"),s.prototype),m(s.prototype,"newCodeDelay",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"newCodeDelay"),s.prototype),m(s.prototype,"onSelect",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"onSelect"),s.prototype),m(s.prototype,"submit",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"submit"),s.prototype),s)})),define("vault/components/mfa/mfa-login-enforcement-form",["exports","@glimmer/component","@glimmer/tracking","@ember/object","@ember/service","ember-concurrency","vault/helpers/add-to-array","vault/helpers/remove-from-array"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function w(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(s=class extends t.default{constructor(){super(...arguments),v(this,"store",u,this),v(this,"flashMessages",c,this),g(this,"targetTypes",[{label:"Authentication mount",type:"accessor",key:"auth_method_accessors"},{label:"Authentication method",type:"method",key:"auth_method_types"},{label:"Group",type:"identity/group",key:"identity_groups"},{label:"Entity",type:"identity/entity",key:"identity_entities"}]),g(this,"searchSelectOptions",null),v(this,"name",d,this),v(this,"targets",p,this),v(this,"selectedTargetType",f,this),v(this,"selectedTargetValue",m,this),v(this,"searchSelect",h,this),v(this,"authMethods",b,this),v(this,"modelErrors",y,this),this.flattenTargets(),this.resetTargetState(),this.fetchAuthMethods()}async flattenTargets(){for(const{label:e,key:t}of this.targetTypes){const n=(await this.args.model[t]).map((n=>({label:e,key:t,value:n})))
this.targets=(0,a.addManyToArray)(this.targets,n)}}async resetTargetState(){this.selectedTargetValue=null
const e=this.searchSelectOptions||{}
if(!this.searchSelectOptions){const n=["identity/group","identity/entity"]
for(const l of n)try{e[l]=await this.store.query(l,{})}catch(t){e[l]=[]}this.searchSelectOptions=e}this.selectedTargetType.includes("identity")&&(this.searchSelect={selected:[],options:[...e[this.selectedTargetType]]})}async fetchAuthMethods(){const e=await this.store.findAll("auth-method")
this.authMethods=e.map((e=>e.type))}get selectedTarget(){return this.targetTypes.find((e=>e.type===this.selectedTargetType))}get errors(){return this.args.modelErrors||this.modelErrors}updateModelForKey(e){const t=this.targets.filter((t=>t.key===e)).map((e=>e.value))
this.args.model[e]=t}*save(){this.modelErrors={}
const{isValid:e,state:t}=this.args.model.validate()
if(e)try{yield this.args.model.save(),this.args.onSave()}catch(n){const e=n.errors?n.errors.join(". "):n.message
this.flashMessages.danger(e)}else this.modelErrors=t}async onMethodChange(e){const t=(await this.args.model.mfa_methods).filter((t=>e.includes(t.id))),n=t.map((e=>e.id)),l=e.filter((e=>!n.includes(e))).map((e=>this.store.peekRecord("mfa-method",e)))
this.args.model.mfa_methods=(0,a.addManyToArray)(t,l)}onTargetSelect(e){this.selectedTargetType=e,this.resetTargetState()}setTargetValue(e){const{type:t}=this.selectedTarget
t.includes("identity")?this.selectedTargetValue=this.store.peekRecord(t,e[0]):this.selectedTargetValue=e}addTarget(){const{label:e,key:t}=this.selectedTarget,n=this.selectedTargetValue
this.targets=(0,a.addToArray)(this.targets,{label:e,value:n,key:t}),this.updateModelForKey(t),this.selectedTargetValue=null,this.resetTargetState()}removeTarget(e){this.targets=(0,o.removeFromArray)(this.targets,e),this.updateModelForKey(e.key)}cancel(){this.args.model.rollbackAttributes(),this.args.onClose()}},u=w(s.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=w(s.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=w(s.prototype,"name",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=w(s.prototype,"targets",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),f=w(s.prototype,"selectedTargetType",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"accessor"}}),m=w(s.prototype,"selectedTargetValue",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=w(s.prototype,"searchSelect",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{options:[],selected:[]}}}),b=w(s.prototype,"authMethods",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),y=w(s.prototype,"modelErrors",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w(s.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),w(s.prototype,"onMethodChange",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onMethodChange"),s.prototype),w(s.prototype,"onTargetSelect",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onTargetSelect"),s.prototype),w(s.prototype,"setTargetValue",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"setTargetValue"),s.prototype),w(s.prototype,"addTarget",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"addTarget"),s.prototype),w(s.prototype,"removeTarget",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"removeTarget"),s.prototype),w(s.prototype,"cancel",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),s)})),define("vault/components/mfa/mfa-login-enforcement-header",["exports","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object"],(function(e,t,n,l,i){var r,a,o
function s(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function u(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(){super(...arguments),s(this,"store",a,this),s(this,"enforcements",o,this),this.args.isInline&&this.fetchEnforcements()}async fetchEnforcements(){try{this._enforcements=await this.store.query("mfa-login-enforcement",{}),this.enforcements=[...this._enforcements]}catch(e){this.enforcements=[]}}onEnforcementSelect([e]){this.args.onEnforcementSelect(this._enforcements.find((t=>t.name===e)))}},a=u(r.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=u(r.prototype,"enforcements",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),u(r.prototype,"onEnforcementSelect",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"onEnforcementSelect"),r.prototype),r)})),define("vault/components/mfa/mfa-setup-step-one",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,i){var r,a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){super(...e),c(this,"store",a,this),c(this,"error",o,this),c(this,"warning",s,this),c(this,"qrCode",u,this)}redirectPreviousPage(){this.args.restartFlow(),window.history.back()}async verifyUUID(e){e.preventDefault()
const t=await this.postCurrentTokenGenerate()
"stop_progress"===t?this.args.isUUIDVerified(!1):"reset_method"===t?this.args.showWarning(this.warning):this.args.isUUIDVerified(!0)}async postCurrentTokenGenerate(){this.error="",this.warning=""
const e=this.store.adapterFor("mfa-setup")
let t
try{t=await e.currentTokenGenerate({method_id:this.UUID}),this.args.saveUUIDandQrCode(this.UUID,t.data?.url)
const n=t.warnings||[]
if(n.length>0){this.UUID=""
return n.find((e=>e.includes("Entity already has a secret for MFA method")))?(this.warning="A QR code has already been generated, scanned, and MFA set up for this entity. If a new code is required, contact your administrator.","reset_method"):(this.warning=n,"reset_method")}}catch(n){return this.UUID="",this.error=n.errors,"stop_progress"}return t}},a=d(r.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=d(r.prototype,"error",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),s=d(r.prototype,"warning",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),u=d(r.prototype,"qrCode",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d(r.prototype,"redirectPreviousPage",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"redirectPreviousPage"),r.prototype),d(r.prototype,"verifyUUID",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"verifyUUID"),r.prototype),r)})),define("vault/components/mfa/mfa-setup-step-two",["exports","@glimmer/component","@ember/service","@ember/object"],(function(e,t,n,l){var i,r
function a(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="store",i=this,(l=r)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}redirectPreviousPage(){this.args.restartFlow(),window.history.back()}async restartSetup(){this.error=null
const e=this.store.adapterFor("mfa-setup")
try{await e.adminDestroy({entity_id:this.args.entityId,method_id:this.args.uuid})}catch(t){return this.error=t.errors,"stop_progress"}this.args.restartFlow()}},r=a(i.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a(i.prototype,"redirectPreviousPage",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"redirectPreviousPage"),i.prototype),a(i.prototype,"restartSetup",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"restartSetup"),i.prototype),i)})),define("vault/components/modal-dialog",["exports","ember-modal-dialog/components/modal-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/modal-form/oidc-assignment-template",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"KQxxdMLY",block:'[[[8,[39,0],null,[["@onSave","@model","@onCancel"],[[30,0,["onSave"]],[30,0,["assignment"]],[30,1]]],null]],["@onCancel"],false,["oidc/assignment-form"]]',moduleName:"vault/components/modal-form/oidc-assignment-template.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(){super(...arguments),c(this,"store",s,this),c(this,"assignment",u,this),this.assignment=this.store.createRecord("oidc/assignment",{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.assignment=null}},s=d(o.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"assignment",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d(o.prototype,"onSave",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/modal-form/oidc-key-template",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"RHglzjly",block:'[[[8,[39,0],null,[["@onSave","@model","@onCancel","@isModalForm"],[[30,0,["onSave"]],[30,0,["key"]],[30,1],true]],null]],["@onCancel"],false,["oidc/key-form"]]',moduleName:"vault/components/modal-form/oidc-key-template.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(){super(...arguments),c(this,"store",s,this),c(this,"key",u,this),this.key=this.store.createRecord("oidc/key",{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.key=null}},s=d(o.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"key",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d(o.prototype,"onSave",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/modal-form/policy-template",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"+eKWtEpN",block:'[[[41,[30,0,["policy","policyType"]],[[[1,"  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n    "],[8,[30,1,["Tab"]],null,null,[["default"],[[[[1,"\\n      Your Policy\\n    "]],[]]]]],[1,"\\n    "],[8,[30,1,["Tab"]],[[24,"Tab",""]],null,[["default"],[[[[1,"\\n      Example Policy\\n    "]],[]]]]],[1,"\\n\\n    "],[8,[30,1,["Panel"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@onSave","@model","@onCancel"],[[30,0,["onSave"]],[30,0,["policy"]],[30,2]]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,1,["Panel"]],[[24,0,"has-top-padding-m"]],null,[["default"],[[[[1,"\\n      "],[8,[39,3],null,[["@policyType","@container"],[[30,0,["policy","policyType"]],"#search-select-modal"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,4],null,[["@name","@label","@options","@isFullwidth","@selectedValue","@onChange","@noDefault"],["policyType","Type",[30,0,["policyOptions"]],true,[30,0,["policy","policyType"]],[30,0,["setPolicyType"]],true]],null],[1,"\\n  "],[8,[39,5],null,[["@title","@message"],["No policy type selected","Select a policy type to continue creating."]],null],[1,"\\n"]],[]]]],["T","@onCancel"],false,["if","hds/tabs","policy-form","policy-example","select","empty-state"]]',moduleName:"vault/components/modal-form/policy-template.hbs",isStrictMode:!1})
let m=e.default=(o=class extends n.default{constructor(...e){super(...e),d(this,"store",s,this),d(this,"version",u,this),d(this,"policy",c,this)}get policyOptions(){return[{label:"ACL Policy",value:"acl",isDisabled:!1},{label:"Role Governing Policy",value:"rgp",isDisabled:!this.version.hasSentinel}]}setPolicyType(e){this.policy&&this.policy.unloadRecord(),this.policy=this.store.createRecord(`policy/${e}`,{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.policy=null}},s=p(o.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"policy",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p(o.prototype,"setPolicyType",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"setPolicyType"),o.prototype),p(o.prototype,"onSave",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/mount-accessor-select",["exports","@glimmer/component","@ember/service","ember-concurrency","@ember/object"],(function(e,t,n,l,i){var r,a
function o(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{get filterToken(){return this.args.filterToken||!1}get noDefault(){return this.args.noDefault||!1}constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),this.authMethods.perform()}*authMethods(){const e=yield this.store.findAll("auth-method")
if(!this.args.value&&!this.args.noDefault){const t=e[0].accessor
this.args.onChange(t)}return e}change(e){this.args.onChange(e.target.value)}},a=o(r.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o(r.prototype,"authMethods",[l.task],Object.getOwnPropertyDescriptor(r.prototype,"authMethods"),r.prototype),o(r.prototype,"change",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"change"),r.prototype),r)})),define("vault/components/mount-backend-form",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object","ember-concurrency","@ember/test-waiters","vault/helpers/mountable-auth-methods","vault/helpers/mountable-secret-engines","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u,c){var d,p,f,m,h,b
function y(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function v(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,c.createTemplateFactory)({id:"pP0pd3k1",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3 title-with-icon"],[12],[1,"\\n"],[41,[30,0,["showEnable"]],[[[44,[[28,[37,3],["type",[30,2,["type"]],[30,3]],null]],[[[1,"          "],[8,[39,4],[[24,0,"has-text-grey-light"]],[["@name","@size"],[[30,4,["glyph"]],"24"]],null],[1,"\\n"],[41,[28,[37,5],[[30,5],"secret"],null],[[[1,"            "],[1,[28,[35,6],["Enable ",[30,4,["displayName"]]," Secrets Engine"],null]],[1,"\\n"]],[]],[[[1,"            "],[1,[28,[35,6],["Enable ",[30,4,["displayName"]]," Authentication Method"],null]],[1,"\\n"]],[]]]],[4]]]],[]],[[[41,[28,[37,5],[[30,5],"secret"],null],[[[1,"        Enable a Secrets Engine\\n"]],[]],[[[1,"        Enable an Authentication Method\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[10,0],[14,0,"box is-sideless is-bottomless is-fullwidth is-marginless"],[12],[1,"\\n  "],[8,[39,7],null,[["@mode","@noun"],["enable",[52,[28,[37,5],[[30,5],"secret"],null],"Secret Engine","Auth Method"]]],null],[1,"\\n  "],[8,[39,8],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"],[41,[30,2,["type"]],[[[1,"    "],[11,"form"],[4,[38,9],["submit",[28,[37,10],[[30,0,["mountBackend"]]],null]],null],[12],[1,"\\n      "],[8,[39,11],null,[["@model","@renderGroup","@modelValidations","@onKeyUp"],[[30,2],"default",[30,0,["modelValidations"]],[30,0,["onKeyUp"]]]],null],[1,"\\n\\n      "],[8,[39,11],null,[["@model","@renderGroup"],[[30,2],"Method Options"]],[["identityTokenKey"],[[[[1,"\\n          "],[8,[39,12],null,[["@id","@fallbackComponent","@inputValue","@onChange","@models","@selectLimit","@modalFormTemplate","@placeholder","@fallbackComponentPlaceholder","@modalSubtext"],["key","input-search",[30,2,["config","identityTokenKey"]],[30,0,["handleIdentityTokenKeyChange"]],[28,[37,13],["oidc/key"],null],"1","modal-form/oidc-key-template","Search for an existing OIDC key, or type a new key name to create it.","Input a key name","This key will be created in the OIDC key path."]],null],[1,"\\n        "]],[]]]]],[1,"\\n\\n      "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,14],[[16,"disabled",[30,0,["mountBackend","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[28,[37,5],[[30,5],"secret"],null],"Enable engine","Enable method"],[52,[30,0,["mountBackend","isRunning"]],"loading"]]],null],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,14],[[4,[38,9],["click",[28,[37,15],[[30,0,["setMountType"]],""],null]],null]],[["@text","@color"],["Back","secondary"]],null],[1,"\\n        "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"          "],[10,0],[14,0,"control"],[12],[1,"\\n            "],[8,[39,16],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n          "],[13],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[8,[39,17],null,[["@setMountType","@mountType"],[[30,0,["setMountType"]],[30,5]]],null],[1,"\\n"]],[]]],[13]],["p","@mountModel","@mountTypes","typeInfo","@mountType"],false,["page-header","if","let","find-by","icon","eq","concat","namespace-reminder","message-error","on","perform","form-field-groups","search-select-with-modal","array","hds/button","fn","alert-inline","mount-backend/type-form"]]',moduleName:"vault/components/mount-backend-form.hbs",isStrictMode:!1})
let w=e.default=(d=class extends n.default{constructor(...e){super(...e),y(this,"store",p,this),y(this,"flashMessages",f,this),y(this,"modelValidations",m,this),y(this,"invalidFormAlert",h,this),y(this,"errorMessage",b,this)}willDestroy(){this.store&&!this.store.isDestroying&&this.args?.mountModel?.isNew&&this.args.mountModel.unloadRecord(),super.willDestroy()}checkPathChange(e){if(!e)return
const t=this.args.mountModel,n=t.path,l="secret"===this.args.mountType?(0,u.allEngines)().map((e=>e.type)):(0,s.methods)().map((e=>e.type))
n&&!l.includes(n)||(t.path=e)}typeChangeSideEffect(e){"secret"===this.args.mountType&&(this.args.mountModel.config.maxLeaseTtl="pki"===e?"3650d":0)}checkModelValidity(e){const{isValid:t,state:n,invalidFormMessage:l}=e.validate()
return this.modelValidations=n,this.invalidFormAlert=l,t}checkModelWarnings(){const{state:e}=this.args.mountModel.validate()
for(const t in e)e[t].errors=[]
this.modelValidations=e,this.invalidFormAlert=null}async showWarningsForKvv2(){try{const e=await this.store.findRecord("capabilities",`${this.args.mountModel.path}/config`)
e?.canUpdate||(this.flashMessages.warning("You do not have access to the config endpoint. The secret engine was mounted, but the configuration settings were not saved."),[this.args.mountModel.maxVersions,this.args.mountModel.casRequired,this.args.mountModel.deleteVersionAfter]=[0,!1,0])}catch(e){this.flashMessages.warning("You may not have access to the config endpoint. The secret engine was mounted, but the configuration settings may not be saved.")}}*mountBackend(e){e.preventDefault()
const t=this.args.mountModel,{type:n,path:l}=t
if(!this.checkModelValidity(t))return
const i=Object.keys(t.changedAttributes()),r=i.includes("casRequired")||i.includes("deleteVersionAfter")||i.includes("maxVersions")
try{yield t.save()}catch(o){if(403===o.httpStatus)return void this.flashMessages.danger("You do not have access to the sys/mounts endpoint. The secret engine was not mounted.")
if(o.errors){const e=o.errors.map((e=>"object"==typeof e?e.title||e.message||JSON.stringify(e):e))
this.errorMessage=e}else o.message?this.errorMessage=o.message:this.errorMessage="An error occurred, check the vault logs."
return}t.isV2KV&&r&&(yield this.showWarningsForKvv2()),this.flashMessages.success(`Successfully mounted the ${n} ${"secret"===this.args.mountType?"secrets engine":"auth method"} at ${l}.`)
const a=(0,u.isAddonEngine)(t.engineType,t.version)
yield this.args.onMountSuccess(n,l,a)}onKeyUp(e,t){this.args.mountModel[e]=t,this.checkModelWarnings()}setMountType(e){this.args.mountModel.type=e,this.typeChangeSideEffect(e),this.checkPathChange(e)}handleIdentityTokenKeyChange(e){this.args.mountModel.config.identityTokenKey=Array.isArray(e)?e[0]:e}},p=v(d.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(d.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(d.prototype,"modelValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=v(d.prototype,"invalidFormAlert",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=v(d.prototype,"errorMessage",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),v(d.prototype,"mountBackend",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(d.prototype,"mountBackend"),d.prototype),v(d.prototype,"onKeyUp",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"onKeyUp"),d.prototype),v(d.prototype,"setMountType",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"setMountType"),d.prototype),v(d.prototype,"handleIdentityTokenKeyChange",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"handleIdentityTokenKeyChange"),d.prototype),d);(0,t.setComponentTemplate)(g,w)})),define("vault/components/mount-backend/type-form",["exports","@ember/component","@glimmer/component","@ember/service","vault/helpers/mountable-auth-methods","vault/helpers/mountable-secret-engines","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,a.createTemplateFactory)({id:"89wAvg44",block:'[[[42,[28,[37,1],[[28,[37,1],[[28,[37,2],["generic","cloud","infra"],null]],null]],null],null,[[[1,"  "],[8,[39,3],[[24,0,"has-top-padding-m has-bottom-padding-s"],[24,"size","400"]],[["@tag"],["h2"]],[["default"],[[[[1,"\\n    "],[1,[28,[35,4],[[30,1]],null]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[10,0],[14,0,"flex row-wrap row-gap-8 column-gap-16 has-bottom-padding-m"],[12],[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[28,[37,5],["category",[30,1],[30,0,["mountTypes"]]],null]],null]],null],null,[[[1,"      "],[8,[39,6],[[16,1,[30,2,["type"]]],[24,0,"has-top-padding-l has-text-centered small-card"]],[["@onClick","@disabled"],[[28,[37,7],[[30,3],[30,2,["type"]]],null],[52,[30,2,["requiredFeature"]],[28,[37,9],[[28,[37,10],[[30,2,["requiredFeature"]]],null]],null],false]]],[["default"],[[[[1,"\\n        "],[8,[39,11],[[24,0,"has-bottom-margin-xs"]],[["@name","@size"],[[30,2,["glyph"]],"24"]],null],[1,"\\n        "],[8,[39,12],null,[["@tag","@size"],["h3","300"]],[["default"],[[[[1,"\\n          "],[1,[30,2,["displayName"]]],[1,"\\n        "]],[]]]]],[1,"\\n"],[41,[28,[37,13],[[30,2,["requiredFeature"]],[28,[37,9],[[28,[37,10],[[30,2,["requiredFeature"]]],null]],null]],null],[[[1,"          "],[8,[39,14],null,[["@text","@icon","@size"],["Enterprise","enterprise","small"]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n"]],[2]],null],[1,"  "],[13],[1,"\\n"]],[1]],null],[1,"\\n"],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[8,[39,15],null,[["@text","@color","@route"],["Cancel","secondary",[52,[28,[37,16],[[30,4],"secret"],null],"vault.cluster.secrets.backends","vault.cluster.access.methods"]]],null],[1,"\\n"],[13]],["category","type","@setMountType","@mountType"],false,["each","-track-array","array","hds/text/display","capitalize","filter-by","selectable-card","fn","if","not","has-feature","icon","hds/text/body","and","hds/badge","hds/button","eq"]]',moduleName:"vault/components/mount-backend/type-form.hbs",isStrictMode:!1})
let c=e.default=(o=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="version",i=this,(l=s)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get secretEngines(){return this.version.isEnterprise?(0,r.allEngines)():(0,r.mountableEngines)()}get authMethods(){return this.version.isEnterprise?(0,i.allMethods)():(0,i.methods)()}get mountTypes(){return"secret"===this.args.mountType?this.secretEngines:this.authMethods}},d=o.prototype,p="version",f=[l.service],m={configurable:!0,enumerable:!0,writable:!0,initializer:null},b={},Object.keys(m).forEach((function(e){b[e]=m[e]})),b.enumerable=!!b.enumerable,b.configurable=!!b.configurable,("value"in b||b.initializer)&&(b.writable=!0),b=f.slice().reverse().reduce((function(e,t){return t(d,p,e)||e}),b),h&&void 0!==b.initializer&&(b.value=b.initializer?b.initializer.call(h):void 0,b.initializer=void 0),s=void 0===b.initializer?(Object.defineProperty(d,p,b),null):b,o)
var d,p,f,m,h,b;(0,t.setComponentTemplate)(u,c)})),define("vault/components/namespace-link",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({namespaceService:(0,t.service)("namespace"),currentNamespace:(0,n.alias)("namespaceService.path"),tagName:"",targetNamespace:null,showLastSegment:!1,unparsed:!1,normalizedNamespace:(0,i.computed)("targetNamespace","unparsed",(function(){const e=this.targetNamespace||""
return this.unparsed?e:e.replace(/\.+/g,"/").replace(/☃/g,".")})),namespaceDisplay:(0,i.computed)("normalizedNamespace","showLastSegment",(function(){const e=this.normalizedNamespace
if(!e)return"root"
const t=this.showLastSegment,n=e?.split("/")
return t?n[n.length-1]:e})),isCurrentNamespace:(0,i.computed)("targetNamespace","currentNamespace",(function(){return this.currentNamespace===this.targetNamespace})),get namespaceLink(){const e=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"")
return this.normalizedNamespace?`${e}/ui/vault/dashboard?namespace=${encodeURIComponent(this.normalizedNamespace)}`:`${e}/ui/vault/dashboard`}})})),define("vault/components/namespace-picker",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object","ember-concurrency","vault/lib/path-to-tree","core/utils/key-utils"],(function(e,t,n,l,i,r,a,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({tagName:"",namespaceService:(0,t.service)("namespace"),auth:(0,t.service)(),store:(0,t.service)(),namespace:null,listCapability:null,canList:!1,init(){this._super(...arguments),this.namespaceService?.findNamespacesForUser.perform()},didReceiveAttrs(){this._super(...arguments)
const e=this.namespace,t=this.oldNamespace
t&&e===t||(this.setForAnimation.perform(),this.fetchListCapability.perform()),this.set("oldNamespace",e)},fetchListCapability:(0,r.task)((function*(){try{const e=yield this.store.findRecord("capabilities","sys/namespaces/")
this.set("listCapability",e),this.set("canList",!0)}catch(e){this.set("canList",!1)}})),setForAnimation:(0,r.task)((function*(){const e=this.menuLeaves,t=this.lastMenuLeaves
if(!t)return this.set("lastMenuLeaves",e),void(yield(0,r.timeout)(0))
const n=e.length>t.length,l=n?e:t,[i]=l.slice(-1)
if(this.set("isAdding",n),this.set("changedLeaf",i),n)return this.set("lastMenuLeaves",e),void(yield(0,r.timeout)(0))
yield(0,r.timeout)(250),this.set("lastMenuLeaves",e)})).drop(),isAnimating:(0,n.alias)("setForAnimation.isRunning"),namespacePath:(0,n.alias)("namespaceService.path"),accessibleNamespaces:(0,n.alias)("namespaceService.accessibleNamespaces"),inRootNamespace:(0,n.alias)("namespaceService.inRootNamespace"),namespaceTree:(0,i.computed)("accessibleNamespaces",(function(){const e=this.accessibleNamespaces
return e?(0,a.default)(e):[]})),maybeAddRoot(e){return""===this.auth.authData.userRootNamespace&&e.unshift(""),e.uniq()},pathToLeaf:e=>e.replace(/\/$/,"").replace(/\.+/g,"☃").replace(/\/+/g,"."),menuLeaves:(0,i.computed)("namespacePath","namespaceTree","pathToLeaf",(function(){let e=this.namespacePath
e=(e||"").replace(/^\//,"")
let t=(0,o.ancestorKeysForKey)(e)
return t.push(e),t=this.maybeAddRoot(t),t=t.map(this.pathToLeaf),t})),rootLeaves:(0,i.computed)("namespaceTree",(function(){const e=this.namespaceTree
return Object.keys(e)})),currentLeaf:(0,n.alias)("lastMenuLeaves.lastObject"),canAccessMultipleNamespaces:(0,n.gt)("accessibleNamespaces.length",1),isUserRootNamespace:(0,i.computed)("auth.authData.userRootNamespace","namespacePath",(function(){return this.auth.authData.userRootNamespace===this.namespacePath})),namespaceDisplay:(0,i.computed)("namespacePath","accessibleNamespaces","accessibleNamespaces.[]",(function(){const e=this.namespacePath
if(!e)return"root"
const t=e?.split("/")
return t[t.length-1]})),actions:{refreshNamespaceList(){this.namespaceService.findNamespacesForUser.perform()}}})})),define("vault/components/namespace-reminder",["exports","core/components/namespace-reminder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/navigate-input",["exports","core/components/navigate-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/navigation-narrator",["exports","ember-a11y-refocus/components/navigation-narrator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/not-found",["exports","@ember/component","@ember/service","@glimmer/component","@ember/template-factory"],(function(e,t,n,l,i){var r,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,i.createTemplateFactory)({id:"uLChGYqD",block:'[[[10,0],[14,0,"box is-shadowless"],[12],[1,"\\n  "],[8,[39,0],null,null,[["default"],[[[[1,"\\n    "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n      "],[10,"h1"],[14,0,"title is-3 has-text-grey"],[12],[1,"\\n        404 Not Found\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n  "],[10,0],[14,0,"box is-sideless has-background-white-bis has-text-grey has-text-centered"],[12],[1,"\\n    "],[10,2],[12],[1,"Sorry, we were unable to find any content at "],[10,"code"],[12],[1,[28,[35,1],[[30,2,["path"]],[30,0,["path"]]],null]],[13],[1,"."],[13],[1,"\\n    "],[10,2],[12],[1,"\\n      Double check the url or\\n      "],[8,[39,2],null,[["@href","@sameTab"],["/",true]],[["default"],[[[[1,"go back home"]],[]]]]],[1,".\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["p","@model"],false,["page-header","or","external-link"]]',moduleName:"vault/components/not-found.hbs",isStrictMode:!1})
let s=e.default=(r=class extends l.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="router",i=this,(l=a)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get path(){return this.router.currentURL}},u=r.prototype,c="router",d=[n.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,r)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/object-list-input",["exports","core/components/object-list-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/oidc-consent-block",["exports","ember","@glimmer/component","@ember/object","@glimmer/tracking"],(function(e,t,n,l,i){var r,a
function o(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=["code","state"]
e.default=(r=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="didCancel",i=this,(l=a)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get win(){return this.window||window}buildUrl(e,t){try{const n=new URL(e)
return Object.keys(t).forEach((e=>{t[e]&&s.includes(e)&&n.searchParams.append(e,t[e])})),n}catch(n){throw console.debug("DEBUG: parsing url failed for",e),new Error("Invalid URL")}}handleSubmit(e){e.preventDefault()
const{redirect:n,...l}=this.args,i=this.buildUrl(n,l)
t.default.testing?this.args.testRedirect(i.toString()):this.win.location.replace(i)}handleCancel(e){e.preventDefault(),this.didCancel=!0}},a=o(r.prototype,"didCancel",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),o(r.prototype,"handleSubmit",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"handleSubmit"),r.prototype),o(r.prototype,"handleCancel",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"handleCancel"),r.prototype),r)})),define("vault/components/oidc/assignment-form",["exports","@glimmer/component","@ember/object","@ember/service","ember-concurrency","@glimmer/tracking"],(function(e,t,n,l,i,r){var a,o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),d(this,"store",o,this),d(this,"flashMessages",s,this),d(this,"modelValidations",u,this),d(this,"errorBanner",c,this)}*save(e){e.preventDefault()
try{const{isValid:e,state:t}=this.args.model.validate()
if(this.modelValidations=e?null:t,e){const{isNew:e,name:t}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the assignment ${t}.`),this.args.onSave(this.args.model)}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e}}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}handleOperation({target:e}){this.args.model.name=e.value}onEntitiesSelect(e){this.args.model.entityIds=e}onGroupsSelect(e){this.args.model.groupIds=e}},o=p(a.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(a.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(a.prototype,"modelValidations",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(a.prototype,"errorBanner",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(a.prototype,"save",[i.task],Object.getOwnPropertyDescriptor(a.prototype,"save"),a.prototype),p(a.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"cancel"),a.prototype),p(a.prototype,"handleOperation",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"handleOperation"),a.prototype),p(a.prototype,"onEntitiesSelect",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"onEntitiesSelect"),a.prototype),p(a.prototype,"onGroupsSelect",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"onGroupsSelect"),a.prototype),a)})),define("vault/components/oidc/client-form",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency"],(function(e,t,n,l,i,r){var a,o,s,u,c,d
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),p(this,"flashMessages",o,this),p(this,"modelValidations",s,this),p(this,"errorBanner",u,this),p(this,"invalidFormAlert",c,this),p(this,"radioCardGroupValue",d,this)}get modelAssignments(){const{assignments:e}=this.args.model
return e.includes("allow_all")&&1===e.length?[]:e}handleAssignmentSelection(e){Array.isArray(e)?this.args.model.assignments=e:(this.radioCardGroupValue=e,this.args.model.assignments=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){"allow_all"===this.radioCardGroupValue&&(this.args.model.assignments=["allow_all"])
const{idTokenTtl:e,accessTokenTtl:t}=this.args.model
0===Number(e)&&(this.args.model.idTokenTtl="24h"),0===Number(t)&&(this.args.model.accessTokenTtl="24h")
const{isNew:n,name:l}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${n?"created":"updated"} the application ${l}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},o=f(a.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=f(a.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(a.prototype,"errorBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(a.prototype,"invalidFormAlert",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(a.prototype,"radioCardGroupValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.assignments||this.args.model.assignments.includes("allow_all")?"allow_all":"limited"}}),f(a.prototype,"handleAssignmentSelection",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"handleAssignmentSelection"),a.prototype),f(a.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"cancel"),a.prototype),f(a.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(a.prototype,"save"),a.prototype),a)})),define("vault/components/oidc/key-form",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency"],(function(e,t,n,l,i,r){var a,o,s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),f(this,"store",o,this),f(this,"flashMessages",s,this),f(this,"errorBanner",u,this),f(this,"invalidFormAlert",c,this),f(this,"modelValidations",d,this),f(this,"radioCardGroupValue",p,this)}get filterDropdownOptions(){return{paramKey:"key",filterFor:[this.args.model.name]}}handleClientSelection(e){Array.isArray(e)?this.args.model.allowedClientIds=e.map((e=>e.clientId)):(this.radioCardGroupValue=e,this.args.model.allowedClientIds=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
"allow_all"===this.radioCardGroupValue&&(this.args.model.allowedClientIds=["*"])
const{rotationPeriod:n,verificationTtl:l}=this.args.model
0===Number(n)&&(this.args.model.rotationPeriod="24h"),0===Number(l)&&(this.args.model.verificationTtl="24h"),yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the key\n          ${t}.`),this.args.onSave(this.args.model)}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},o=m(a.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=m(a.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=m(a.prototype,"errorBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(a.prototype,"invalidFormAlert",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(a.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(a.prototype,"radioCardGroupValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.allowedClientIds||this.args.model.allowedClientIds.includes("*")?"allow_all":"limited"}}),m(a.prototype,"handleClientSelection",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"handleClientSelection"),a.prototype),m(a.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"cancel"),a.prototype),m(a.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(a.prototype,"save"),a.prototype),a)})),define("vault/components/oidc/provider-form",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","core/utils/parse-url"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p,f
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(o=class extends t.default{constructor(...e){super(...e),m(this,"store",s,this),m(this,"flashMessages",u,this),m(this,"modelValidations",c,this),m(this,"errorBanner",d,this),m(this,"invalidFormAlert",p,this),m(this,"radioCardGroupValue",f,this)}renderInfoTooltip(e,t){return!!!t.find((t=>t.clientId===e))&&"The application associated with this client_id no longer exists"}setIssuer(e,[t]){t.issuer=t.isNew?"":(0,a.default)(t.issuer).origin}handleClientSelection(e){Array.isArray(e)?this.args.model.allowedClientIds=e.map((e=>e.clientId)):(this.radioCardGroupValue=e,this.args.model.allowedClientIds=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
"allow_all"===this.radioCardGroupValue&&(this.args.model.allowedClientIds=["*"]),yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the OIDC provider\n          ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},s=h(o.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=h(o.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(o.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(o.prototype,"errorBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(o.prototype,"invalidFormAlert",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h(o.prototype,"radioCardGroupValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.allowedClientIds||this.args.model.allowedClientIds.includes("*")?"allow_all":"limited"}}),h(o.prototype,"setIssuer",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"setIssuer"),o.prototype),h(o.prototype,"handleClientSelection",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"handleClientSelection"),o.prototype),h(o.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"cancel"),o.prototype),h(o.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(o.prototype,"save"),o.prototype),o)})),define("vault/components/oidc/scope-form",["exports","@glimmer/component","@glimmer/tracking","@ember/object","ember-concurrency","@ember/service"],(function(e,t,n,l,i,r){var a,o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),d(this,"flashMessages",o,this),d(this,"errorBanner",s,this),d(this,"invalidFormAlert",u,this),d(this,"modelValidations",c,this),p(this,"exampleTemplate",'{\n  "username": {{identity.entity.aliases.$MOUNT_ACCESSOR.name}},\n  "contact": {\n    "email": {{identity.entity.metadata.email}},\n    "phone_number": {{identity.entity.metadata.phone_number}}\n  },\n  "groups": {{identity.entity.groups.names}}\n}')}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the scope ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}},o=f(a.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=f(a.prototype,"errorBanner",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(a.prototype,"invalidFormAlert",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(a.prototype,"modelValidations",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f(a.prototype,"save",[i.task],Object.getOwnPropertyDescriptor(a.prototype,"save"),a.prototype),f(a.prototype,"cancel",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"cancel"),a.prototype),a)})),define("vault/components/outer-html",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({tagName:""})})),define("vault/components/overview-card",["exports","core/components/overview-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page-header-level",["exports","core/components/page-header-level"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page-header",["exports","core/components/page-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/breadcrumbs",["exports","core/components/page/breadcrumbs"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/error",["exports","core/components/page/error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/userpass-reset-password",["exports","@ember/component","@ember/service","@glimmer/component","@glimmer/tracking","ember-concurrency","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"zgc+og0S",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Reset password\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[11,"form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["updatePassword"]]],null]],[["on"],["submit"]]],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,3],[[24,0,"has-bottom-margin-m"]],[["@type"],["inline"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Current user"]],[]]]]],[1,"\\n      "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"You are updating the password for\\n        "],[10,"strong"],[12],[1,[30,3]],[13],[1,"\\n        on the\\n        "],[10,"strong"],[12],[1,[30,4]],[13],[1,"\\n        auth mount."]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n    "],[8,[39,4],[[24,"for","reset-password"]],[["@label"],["New password"]],null],[1,"\\n    "],[8,[39,5],[[24,1,"reset-password"]],[["@name","@value","@onChange"],["reset-password",[30,0,["newPassword"]],[28,[37,6],[[28,[37,7],[[30,0,["newPassword"]]],null]],null]]],null],[1,"\\n  "],[13],[1,"\\n\\n  "],[8,[39,8],[[24,0,"has-top-margin-m"]],null,[["default"],[[[[1,"\\n    "],[8,[39,9],[[16,"disabled",[30,0,["updatePassword","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["updatePassword","isRunning"]],"loading"]]],null],[1,"\\n"],[41,[30,0,["error"]],[[[1,"      "],[8,[39,3],[[24,0,"has-left-margin-s"]],[["@type","@color"],["compact","critical"]],[["default"],[[[[1,"\\n        "],[8,[30,5,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n        "],[8,[30,5,["Description"]],null,null,[["default"],[[[[1,"\\n          "],[1,[30,0,["error"]]],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[5]]]]],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"],[13]],["p","A","@username","@backend","A"],false,["page-header","on","perform","hds/alert","form-field-label","masked-input","fn","mut","hds/button-set","hds/button","if"]]',moduleName:"vault/components/page/userpass-reset-password.hbs",isStrictMode:!1})
let b=e.default=(s=class extends l.default{constructor(...e){super(...e),f(this,"store",u,this),f(this,"flashMessages",c,this),f(this,"newPassword",d,this),f(this,"error",p,this)}onSuccess(){this.error="",this.newPassword="",this.flashMessages.success("Successfully reset password")}*updatePassword(e){e.preventDefault(),this.error=""
const t=this.store.adapterFor("auth-method"),{backend:n,username:l}=this.args
if(n&&l)if(this.newPassword)try{yield t.resetPassword(n,l,this.newPassword),this.onSuccess()}catch(i){this.error=(0,a.default)(i,"Check Vault logs for details")}else this.error="Please provide a new password."}},u=m(s.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"newPassword",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=m(s.prototype,"error",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m(s.prototype,"updatePassword",[r.task],Object.getOwnPropertyDescriptor(s.prototype,"updatePassword"),s.prototype),s);(0,t.setComponentTemplate)(h,b)})),define("vault/components/pgp-file",["exports","@ember/component","@ember/object","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/gi
e.default=t.default.extend({"data-test-pgp-file":!0,attributeBindings:["data-test-pgp-file"],classNames:["box","is-fullwidth","is-marginless","is-shadowless"],key:null,index:null,onChange:()=>{},label:null,fileHelpText:null,textareaHelpText:null,readFile(e){const t=new FileReader
t.onload=()=>this.setPGPKey.perform(t.result,e.name),t.readAsDataURL(e)},setPGPKey:(0,l.task)((0,i.waitFor)((function*(e,t){const n=e.split(",")[1].trim(),l=atob(n).trim(),i=l.match(r)?l:n
yield this.onChange(this.index,{value:i,filename:t})}))),actions:{pickedFile(e){const{files:t}=e.target
if(t.length)for(let n=0,l=t.length;n<l;n++)this.readFile(t[n])},updateData(e){const t=this.key;(0,n.set)(t,"value",e.target.value),this.onChange(this.index,this.key)},clearKey(){this.onChange(this.index,{value:""})}}})})),define("vault/components/pgp-list",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({onDataUpdate:()=>{},listLength:0,listData:null,init(){this._super(...arguments)
let e=this.listLength
e&&(e=parseInt(e,10))
const t=this.newList(e)
this.set("listData",t)},didReceiveAttrs(){let e
this._super(...arguments),this.listLength?this.listData.length!==this.listLength&&(this.listLength<this.listData.length?e=this.listData.slice(0,this.listLength):this.listLength>this.listData.length&&(e=[...this.listData,...this.newList(this.listLength-this.listData.length)]),this.set("listData",e||this.listData),this.onDataUpdate((e||this.listData).compact().map((e=>e.value)))):this.set("listData",[])},newList:e=>Array(e||0).fill(null).map((()=>({value:""}))),actions:{setKey(e,t){const{listData:n}=this
n.splice(e,1,t),this.onDataUpdate(n.compact().map((e=>e.value)))}}})})),define("vault/components/policy-example",["exports","core/components/policy-example"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/policy-form",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","ember-concurrency","vault/utils/trim-right","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s){var u,c,d,p,f
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,s.createTemplateFactory)({id:"zPwl+Gla",block:'[[[11,"form"],[4,[38,0],["submit",[28,[37,1],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-shadowless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,2],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n    "],[8,[39,3],null,[["@mode","@noun"],[[52,[30,1,["isNew"]],"create","edit"],"policy"]],null],[1,"\\n"],[41,[30,1,["isNew"]],[[[1,"      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","policy-name"],[14,0,"is-label"],[12],[1,"Name"],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,5],[[24,1,"policy-name"],[24,0,"input"],[4,[38,0],["input",[30,0,["setModelName"]]],null]],[["@type","@value"],["text",[28,[37,6],[[30,1,["name"]]],null]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[8,[39,7],[[16,"aria-label",[29,["toolbar for managing ",[28,[37,8],[[30,1,["name"]],"new"],null]," policy"]]]],null,[["default"],[[[[1,"\\n        "],[10,"label"],[14,0,"has-text-weight-bold has-right-margin-xxs"],[12],[1,"Policy"],[13],[1,"\\n"],[41,[30,2],[[[1,"          "],[8,[39,9],[[16,"aria-label",[29,["help tools for managing ",[28,[37,8],[[30,1,["name"]],"new"],null]," policy"]]]],null,[["default"],[[[[1,"\\n            "],[8,[39,10],[[4,[38,0],["click",[28,[37,11],[[28,[37,12],[[30,0,["showTemplateModal"]]],null]],null]],null]],[["@text","@icon","@size","@color"],["How to write a policy","bulb","small","tertiary"]],null],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"        "],[8,[39,13],[[16,"aria-label",[29,["actions for managing ",[28,[37,8],[[30,1,["name"]],"new"],null]," policy"]]]],null,[["default"],[[[[1,"\\n          "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"],[41,[30,1,["isNew"]],[[[1,"            "],[10,0],[14,0,"control is-flex"],[12],[1,"\\n              "],[8,[39,5],[[24,1,"fileUploadToggle"],[24,3,"fileUploadToggle"],[24,0,"toggle is-success is-small"],[4,[38,0],["change",[28,[37,11],[[28,[37,12],[[30,0,["showFileUpload"]]],null],[28,[37,14],[[30,0,["showFileUpload"]]],null]],null]],null]],[["@type","@checked"],["checkbox",[30,0,["showFileUpload"]]]],null],[1,"\\n              "],[10,"label"],[14,"for","fileUploadToggle"],[14,0,"has-text-weight-bold is-size-8"],[12],[1,"Upload file"],[13],[1,"\\n            "],[13],[1,"\\n"]],[]],[[[1,"            "],[8,[39,15],[[24,0,"transparent"]],[["@text","@isIconOnly","@textToCopy","@onError"],["Copy",true,[30,1,["policy"]],[28,[37,11],[[28,[37,16],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n"]],[]]],[1,"        "]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n"],[41,[30,0,["showFileUpload"]],[[[1,"        "],[8,[39,17],null,[["@uploadOnly","@onChange"],[true,[30,0,["setPolicyFromFile"]]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,18],null,[["@title","@showToolbar","@value","@valueUpdated","@mode","@extraKeys"],["Policy",false,[30,1,["policy"]],[28,[37,19],[[30,0],[28,[37,12],[[30,1,["policy"]]],null]],null],"ruby",[28,[37,20],null,[["Shift-Enter"],[[28,[37,1],[[30,0,["save"]]],null]]]]]],null],[1,"\\n"]],[]]],[1,"      "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n        "],[10,1],[14,0,"is-size-9 has-text-grey has-bottom-margin-l"],[12],[1,"\\n          You can use Alt+Tab (Option+Tab on MacOS) in the code editor to skip to the next field.\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"],[42,[28,[37,22],[[28,[37,22],[[30,1,["additionalAttrs"]]],null]],null],null,[[[1,"      "],[8,[39,23],null,[["@attr","@model"],[[30,3],[30,1]]],null],[1,"\\n"]],[3]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,24],null,null,[["default"],[[[[1,"\\n      "],[8,[39,10],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,1,["isNew"]],"Create policy","Save"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,10],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,0],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["showTemplateModal"]],[[[1,"  "],[8,[39,25],[[24,1,"policy-example-modal"]],[["@size","@onClose"],["large",[28,[37,11],[[28,[37,12],[[30,0,["showTemplateModal"]]],null],false],null]]],[["default"],[[[[1,"\\n    "],[8,[30,4,["Header"]],null,null,[["default"],[[[[1,"\\n      Example\\n      "],[1,[28,[35,26],[[30,1,["policyType"]]],null]],[1,"\\n      Policy\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,27],null,[["@policyType","@container"],[[30,1,["policyType"]],"#policy-example-modal"]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,10],[[4,[38,0],["click",[30,5,["close"]]],null]],[["@text"],["Close"]],null],[1,"\\n    "]],[5]]]]],[1,"\\n  "]],[4]]]]],[1,"\\n"]],[]],null]],["@model","@renderPolicyExampleModal","attr","M","F"],false,["on","perform","message-error","namespace-reminder","if","input","lowercase","toolbar","or","toolbar-filters","hds/button","fn","mut","toolbar-actions","not","hds/copy/button","set-flash-message","text-file","json-editor","action","hash","each","-track-array","form-field","hds/button-set","hds/modal","uppercase","policy-example"]]',moduleName:"vault/components/policy-form.hbs",isStrictMode:!1})
let y=e.default=(u=class extends n.default{constructor(...e){super(...e),m(this,"flashMessages",c,this),m(this,"errorBanner",d,this),m(this,"showFileUpload",p,this),m(this,"showTemplateModal",f,this)}*save(e){e.preventDefault()
try{const{name:e,policyType:t,isNew:n}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`${t.toUpperCase()} policy "${e}" was successfully ${n?"created":"updated"}.`),this.args.onSave(this.args.model)}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e}}setModelName({target:e}){this.args.model.name=e.value.toLowerCase()}setPolicyFromFile(e){const{value:t,filename:n}=e
if(this.args.model.policy=t,!this.args.model.name){const e=(0,a.default)(n,[".json",".txt",".hcl",".policy"])
this.args.model.name=e.toLowerCase()}this.showFileUpload=!1}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}},c=h(u.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(u.prototype,"errorBanner",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=h(u.prototype,"showFileUpload",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=h(u.prototype,"showTemplateModal",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),h(u.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(u.prototype,"save"),u.prototype),h(u.prototype,"setModelName",[l.action],Object.getOwnPropertyDescriptor(u.prototype,"setModelName"),u.prototype),h(u.prototype,"setPolicyFromFile",[l.action],Object.getOwnPropertyDescriptor(u.prototype,"setPolicyFromFile"),u.prototype),h(u.prototype,"cancel",[l.action],Object.getOwnPropertyDescriptor(u.prototype,"cancel"),u.prototype),u);(0,t.setComponentTemplate)(b,y)}))
define("vault/components/portal-target",["exports","ember-stargate/components/portal-target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/portal",["exports","ember-stargate/components/portal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple",["exports","ember-power-select/components/power-select-multiple"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple/input",["exports","ember-power-select/components/power-select-multiple/input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple/trigger",["exports","ember-power-select/components/power-select-multiple/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select",["exports","ember-power-select/components/power-select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/before-options",["exports","ember-power-select/components/power-select/before-options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/label",["exports","ember-power-select/components/power-select/label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/no-matches-message",["exports","ember-power-select/components/power-select/no-matches-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/options",["exports","ember-power-select/components/power-select/options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/placeholder",["exports","ember-power-select/components/power-select/placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/power-select-group",["exports","ember-power-select/components/power-select/power-select-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/search-message",["exports","ember-power-select/components/power-select/search-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/trigger",["exports","ember-power-select/components/power-select/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/qr-code",["exports","ember-qrcode-shim/components/qr-code"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/radial-progress",["exports","@ember/component","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({"data-test-radial-progress":!0,tagName:"svg",classNames:"radial-progress",attributeBindings:["size:width","size:height","viewBox","data-test-radial-progress"],progressDecimal:null,size:20,strokeWidth:1,viewBox:(0,n.computed)("size",(function(){const e=this.size
return`0 0 ${e} ${e}`})),centerValue:(0,n.computed)("size",(function(){return this.size/2})),r:(0,n.computed)("size","strokeWidth",(function(){return(this.size-this.strokeWidth)/2})),c:(0,n.computed)("r",(function(){return 2*Math.PI*this.r})),dashArrayOffset:(0,n.computed)("c","progressDecimal",(function(){return this.c*(1-this.progressDecimal)}))})})),define("vault/components/radio-button",["exports","core/components/radio-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/radio-card",["exports","core/components/radio-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/raft-join",["exports","@ember/service","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({classNames:"raft-join",store:(0,t.service)(),onDismiss(){},preference:"join",showJoinForm:!1,actions:{advanceFirstScreen(e){e.preventDefault(),"join"===this.preference?this.set("showJoinForm",!0):this.onDismiss()},newModel(){return this.store.createRecord("raft-join")}}})})),define("vault/components/raft-storage-overview",["exports","@ember/component","@ember/owner","vault/config/environment","@ember/service"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({flashMessages:(0,i.service)(),auth:(0,i.service)(),useServiceWorker:null,async init(){if(this._super(...arguments),!1!==this.useServiceWorker&&"serviceWorker"in navigator){await navigator.serviceWorker.getRegistration(l.default.serviceWorkerScope)&&(navigator.serviceWorker.addEventListener("message",this.serviceWorkerGetToken.bind(this)),this.set("useServiceWorker",!0))}},willDestroy(){this.useServiceWorker&&navigator.serviceWorker.removeEventListener("message",this.serviceWorkerGetToken),this._super(...arguments)},serviceWorkerGetToken(e){const{action:t}=e.data,[n]=e.ports
"getToken"===t?n.postMessage({token:this.auth.currentToken}):(console.error("Unknown event",e),n.postMessage({error:"Unknown request"}))},actions:{async removePeer(e){const{nodeId:t}=e
try{await e.destroyRecord()}catch(n){const e=n.errors?n.errors.join(" "):n.message||n
return void this.flashMessages.danger(`There was an issue removing the peer ${t}: ${e}`)}this.flashMessages.success(`Successfully removed the peer: ${t}.`)},downloadViaServiceWorker(){this.flashMessages.success("The snapshot download will begin shortly.")},async downloadSnapshot(){const e=(0,n.getOwner)(this).lookup("adapter:application")
let t,l
this.flashMessages.success("The snapshot download has begun.")
try{t=await e.rawRequest("/v1/sys/storage/raft/snapshot","GET"),l=await t.blob()}catch(s){const e=s.errors?s.errors.join(" "):s.message||s
this.flashMessages.danger(`There was an error trying to download the snapshot: ${e}`)}const i="snapshot.gz",r=new Blob([l],{type:"application/x-gzip"})
if(r.name=i,"msSaveOrOpenBlob"in navigator)return void navigator.msSaveOrOpenBlob(r,i)
const a=document.createElement("a"),o=window.URL.createObjectURL(r)
a.href=o,a.download=i,document.body.appendChild(a),a.click(),a.remove(),window.URL.revokeObjectURL(o)}}})})),define("vault/components/raft-storage-restore",["exports","@ember/component","ember-concurrency","@ember/owner","@ember/service","@ember/object/computed"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({file:null,errors:null,forceRestore:!1,flashMessages:(0,i.service)(),isUploading:(0,r.alias)("restore.isRunning"),abortController:null,restore:(0,n.task)((function*(){this.set("errors",null)
const e=(0,l.getOwner)(this).lookup("adapter:application")
try{let t="/v1/sys/storage/raft/snapshot"
this.forceRestore&&(t=`${t}-force`)
const n=new Blob([this.file],{type:"application/gzip"}),l=new AbortController
this.set("abortController",l),yield e.rawRequest(t,"POST",{body:n,signal:l.signal}),this.flashMessages.success("The snapshot was successfully uploaded!")}catch(t){if("AbortError"===t.name)return
let e
t.json&&(e=yield t.json())
const n=e?e.errors:[t]
this.set("errors",n)}})),actions:{cancelUpload(){this.abortController.abort()}}})})),define("vault/components/read-more",["exports","core/components/read-more"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/readonly-form-field",["exports","core/components/readonly-form-field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/regex-validator",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/template-factory"],(function(e,t,n,l,i,r){var a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,r.createTemplateFactory)({id:"wzspKEgi",block:'[[[41,[30,1],[[[1,"  "],[10,0],[14,0,"field"],[12],[1,"\\n    "],[10,0],[14,0,"regex-label-wrapper"],[12],[1,"\\n      "],[10,0],[14,0,"regex-label"],[12],[1,"\\n        "],[10,"label"],[15,"for",[30,1,["name"]]],[14,0,"is-label"],[12],[1,"\\n          "],[1,[30,2]],[1,"\\n"],[41,[30,1,["options","helpText"]],[[[1,"            "],[8,[39,1],null,null,[["default"],[[[[1,"\\n              "],[10,1],[12],[1,"\\n                "],[1,[30,1,["options","helpText"]]],[1,"\\n              "],[13],[1,"\\n            "]],[]]]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n"],[41,[30,1,["options","subText"]],[[[1,"          "],[10,2],[14,0,"sub-text"],[12],[1,"\\n            "],[1,[30,1,["options","subText"]]],[1,"\\n"],[41,[30,1,["options","docLink"]],[[[1,"              "],[8,[39,2],null,[["@path"],[[30,1,["options","docLink"]]]],[["default"],[[[[1,"\\n                See our documentation\\n              "]],[]]]]],[1,"\\n              for help.\\n"]],[]],null],[1,"          "],[13],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,3],null,[["@name","@checked","@onChange"],[[28,[37,4],[[30,1,["name"]],"-validation-toggle"],null],[30,0,["showTestValue"]],[30,0,["toggleTestValue"]]]],[["default"],[[[[1,"\\n          "],[10,1],[14,0,"has-text-grey"],[12],[1,"Validation"],[13],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[11,"input"],[16,1,[30,1,["name"]]],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,3]],[24,0,"input"],[4,[38,5],["change",[30,4]],null],[12],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[41,[30,0,["showTestValue"]],[[[1,"  "],[10,0],[12],[1,"\\n    "],[10,"label"],[14,"for","regex-test-val"],[14,0,"is-label"],[12],[1,"\\n      "],[1,[30,0,["testInputLabel"]]],[1,"\\n    "],[13],[1,"\\n"],[41,[30,5],[[[1,"      "],[10,2],[14,0,"sub-text"],[12],[1,[30,5]],[13],[1,"\\n"]],[]],null],[1,"    "],[11,"input"],[24,1,"regex-test-val"],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,0,["testValue"]]],[16,0,[29,["input ",[52,[30,0,["regexError"]],"has-error"]]]],[4,[38,5],["change",[30,0,["updateTestValue"]]],null],[12],[13],[1,"\\n\\n"],[41,[30,0,["testValue"]],[[[1,"      "],[10,0],[12],[1,"\\n"],[41,[28,[37,6],[[30,3]],null],[[[1,"          "],[8,[39,7],null,[["@type","@message"],["warning",[28,[37,4],["A pattern has not been entered. Enter a pattern to check this ",[28,[37,8],[[30,0,["testInputLabel"]]],null]," against it."],null]]],null],[1,"\\n"]],[]],[[[41,[30,0,["regexError"]],[[[1,"          "],[8,[39,7],null,[["@type","@message"],["danger","This test string does not match the pattern regex."]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,7],null,[["@type","@message"],["success","This test string matches the pattern regex."]],null],[1,"\\n        "]],[]]]],[]]],[1,"      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"]],[]],null],[41,[30,6],[[[1,"  "],[10,0],[14,0,"has-top-margin-l"],[12],[1,"\\n    "],[10,"label"],[14,0,"is-label"],[12],[1,"Groups"],[13],[1,"\\n"],[41,[28,[37,9],[[30,3],[30,0,["testValue"]],[28,[37,6],[[30,0,["regexError"]]],null]],null],[[[1,"      "],[10,0],[14,0,"regex-group"],[12],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,0,["captureGroups"]]],null]],null],null,[[[1,"          "],[10,1],[14,0,"regex-group-position"],[12],[1,"\\n            "],[10,1],[12],[1,[30,7,["position"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,1],[14,0,"regex-group-value"],[12],[1,"\\n            "],[1,[30,7,["value"]]],[1,"\\n          "],[13],[1,"\\n"]],[7]],null],[1,"      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,2],[14,0,"sub-text"],[12],[1,"\\n        Enter pattern and test string to show groupings.\\n      "],[13],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"]],[]],null]],["@attr","@labelString","@value","@onChange","@testInputSubText","@showGroups","group"],false,["if","info-tooltip","doc-link","toggle","concat","on","not","alert-inline","lowercase","and","each","-track-array"]]',moduleName:"vault/components/regex-validator.hbs",isStrictMode:!1})
let p=e.default=(a=class extends n.default{constructor(){super(...arguments),u(this,"testValue",o,this),u(this,"showTestValue",s,this),this.showTestValue=!this.args.attr}get testInputLabel(){return this.args.testInputLabel||"Test string"}get regex(){return new RegExp(this.args.value,"g")}get regexError(){const e=this.testValue
if(!e||!this.args.value)return!1
const t=e.toString().match(this.regex)
return this.args.onValidate&&this.args.onValidate(this.testValue,this.captureGroups),e!==t?.join("")}get captureGroups(){const e=this.regex.exec(this.testValue)
if(e){const[t,...n]=e,l=n.map(((e,t)=>({position:`$${t+1}`,value:e})))
if(e.groups)for(const i in e.groups)l.push({position:`$${i}`,value:e.groups[i]})
return l}return[]}updateTestValue(e){this.testValue=e.target.value}toggleTestValue(){this.showTestValue=!this.showTestValue}},o=c(a.prototype,"testValue",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),s=c(a.prototype,"showTestValue",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(a.prototype,"updateTestValue",[i.action],Object.getOwnPropertyDescriptor(a.prototype,"updateTestValue"),a.prototype),c(a.prototype,"toggleTestValue",[i.action],Object.getOwnPropertyDescriptor(a.prototype,"toggleTestValue"),a.prototype),a);(0,t.setComponentTemplate)(d,p)})),define("vault/components/replication-action-demote",["exports","core/components/replication-action-demote"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-disable",["exports","core/components/replication-action-disable"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-generate-token",["exports","core/components/replication-action-generate-token"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-promote",["exports","core/components/replication-action-promote"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-recover",["exports","core/components/replication-action-recover"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-reindex",["exports","core/components/replication-action-reindex"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/replication-action-update-primary",["exports","core/components/replication-action-update-primary"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-actions-single",["exports","core/components/replication-actions-single"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-actions",["exports","core/components/replication-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-dashboard",["exports","core/components/replication-dashboard"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-header",["exports","core/components/replication-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-mode-summary",["exports","core/components/replication-mode-summary"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-page",["exports","core/components/replication-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-secondary-card",["exports","core/components/replication-secondary-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-summary-card",["exports","core/components/replication-summary-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-table-rows",["exports","core/components/replication-table-rows"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/resultant-acl-banner",["exports","@ember/component","@ember/service","@glimmer/component","@glimmer/tracking","vault/services/permissions","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"YUQgQgcS",block:'[[[41,[51,[30,0,["hideBanner"]]],[[[1,"  "],[8,[39,1],null,[["@type","@color","@onDismiss"],["inline","critical",[28,[37,2],[[28,[37,3],[[30,0,["hideBanner"]]],null],true],null]]],[["default"],[[[[1,"\\n    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,[30,0,["title"]]]],[]]]]],[1,"\\n    "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n      "],[1,[30,0,["message"]]],[1,"\\n    "]],[]]]]],[1,"\\n"],[41,[30,2],[[[1,"      "],[8,[30,1,["LinkStandalone"]],null,[["@icon","@iconPosition","@text","@route","@query"],["arrow-right","trailing",[28,[37,5],["Log into ",[30,0,["ns"]]," namespace"],null],"vault.cluster.logout",[30,0,["queryParams"]]]],null],[1,"\\n"]],[]],null],[1,"  "]],[1]]]]],[1,"\\n"]],[]],null]],["A","@isEnterprise"],false,["unless","hds/alert","fn","mut","if","concat"]]',moduleName:"vault/components/resultant-acl-banner.hbs",isStrictMode:!1})
let m=e.default=(o=class extends l.default{constructor(...e){super(...e),d(this,"namespace",s,this),d(this,"router",u,this),d(this,"hideBanner",c,this)}get ns(){return this.namespace.path||"root"}get queryParams(){return{redirect_to:this.router.currentURL}}get title(){return this.args.failType===r.PERMISSIONS_BANNER_STATES.noAccess?"You do not have access to this namespace":"Resultant ACL check failed"}get message(){return this.args.failType===r.PERMISSIONS_BANNER_STATES.noAccess?"Log into the namespace directly, or contact your administrator if you think you should have access.":"Links might be shown that you don't have access to. Contact your administrator to update your policy."}},s=p(o.prototype,"namespace",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"hideBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/role-aws-edit",["exports","@ember/utils","@ember/object","vault/components/role-edit"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({actions:{createOrUpdate(e,l){l.preventDefault()
const i=this.model.id||this.model.name
if("create"!==e||!(0,t.isBlank)(i)){var r=this.model.credential_type
"iam_user"==r&&(0,n.set)(this,"model.role_arns",[]),"assumed_role"==r&&(0,n.set)(this,"model.policy_arns",[]),"federation_token"==r&&((0,n.set)(this,"model.role_arns",[]),(0,n.set)(this,"model.policy_arns",[])),"{}"==this.model.policy_document&&(0,n.set)(this,"model.policy_document",""),this.persist("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",i)}))}},codemirrorUpdated(e,t,l){l.performLint()
l.state.lint.marked.length>0||(0,n.set)(this.model,e,t)}}})})),define("vault/components/role-edit",["exports","@ember/service","@ember/object/computed","@ember/utils","ember-concurrency","@ember/component","@ember/object","vault/mixins/focus-on-insert","core/utils/key-codes"],(function(e,t,n,l,i,r,a,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u="vault.cluster.secrets.backend.list-root"
e.default=r.default.extend(o.default,{router:(0,t.service)(),mode:null,emptyData:"{\n}",onDataChange(){},onRefresh(){},model:null,requestInFlight:(0,n.or)("model.isLoading","model.isReloading","model.isSaving"),willDestroyElement(){this.model&&this.model.isError&&!this.model.isDestroyed&&!this.model.isDestroying&&this.model.rollbackAttributes(),this._super(...arguments)},waitForKeyUp:(0,i.task)((function*(){for(;;){const e=yield(0,i.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute(){this.router.transitionTo(...arguments)},onEscape(e){e.keyCode===s.default.ESC&&"show"===this.mode&&this.transitionToRoute(u)},hasDataChanges(){this.onDataChange(this.model.hasDirtyAttributes)},persist(e,t){const n=this.model
return n[e]().then((()=>{n.isError||t(n)}))},actions:{createOrUpdate(e,t){t.preventDefault()
const n=this.model.id||this.model.name
"create"===e&&(0,l.isBlank)(n)||this.persist("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}))},setValue(e,t){(0,a.set)(this.model,e,t.target.checked)},refresh(){this.onRefresh()},delete(){this.persist("destroyRecord",(()=>{this.hasDataChanges(),this.transitionToRoute(u)}))},codemirrorUpdated(e,t,n){n.performLint()
n.state.lint.marked.length>0||(0,a.set)(this.model,e,JSON.parse(t))}}})})),define("vault/components/role-ssh-edit",["exports","vault/components/role-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({init(){this._super(...arguments),this.set("backendType","ssh")},actions:{updateTtl(e,t){const n=this.model,l=!0===t.enabled?`${t.seconds}s`:void 0
n.set(e,l)}}})})),define("vault/components/seal-action",["exports","@ember/component","@ember/object","@glimmer/component","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s
function u(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,a.createTemplateFactory)({id:"SU26t6mX",block:'[[[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n"],[41,[30,0,["error"]],[[[1,"    "],[8,[39,1],[[24,0,"has-bottom-margin-m"]],[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n      "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n      "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n        "],[1,[30,0,["error"]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[1]]]]],[1,"\\n"]],[]],null],[1,"  "],[10,2],[12],[1,"\\n    Sealing a vault tells the Vault server to stop responding to any access operations until it is unsealed again. A sealed\\n    vault throws away its root key to unlock the data, so it physically is blocked from responding to operations again until\\n    the Vault is unsealed again with the \\"unseal\\" command or via the API.\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[8,[39,2],null,[["@buttonText","@confirmTitle","@confirmMessage","@onConfirmAction"],["Seal","Seal this cluster?","You will not be able to read or write any data until the cluster is unsealed again.",[30,0,["handleSeal"]]]],null],[1,"\\n"],[13]],["A"],false,["if","hds/alert","confirm-action"]]',moduleName:"vault/components/seal-action.hbs",isStrictMode:!1})
let d=e.default=(o=class extends l.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="error",i=this,(l=s)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}async handleSeal(){try{await this.args.onSeal()}catch(e){this.error=(0,r.default)(e,"Seal attempt failed. Check Vault logs for details.")}}},s=u(o.prototype,"error",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(o.prototype,"handleSeal",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"handleSeal"),o.prototype),o);(0,t.setComponentTemplate)(c,d)})),define("vault/components/search-select-placeholder",["exports","core/components/search-select-placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/search-select-with-modal",["exports","core/components/search-select-with-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/search-select",["exports","core/components/search-select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-create-or-update",["exports","@glimmer/component","vault/lib/control-group-error","ember","core/utils/key-codes","@ember/object","@ember/service","@glimmer/tracking","@ember/utils","ember-concurrency","vault/utils/validators"],(function(e,t,n,l,i,r,a,o,s,u,c){var d,p,f,m,h,b,y,v,g,w,k,x,P
function _(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function T(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function O(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(d=(0,u.task)((function*(e,t){for(this.checkValidation(e,t);;){const e=yield(0,u.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),p=class extends t.default{constructor(...e){super(...e),_(this,"codemirrorString",f,this),_(this,"error",m,this),_(this,"secretPaths",h,this),_(this,"pathWhiteSpaceWarning",b,this),_(this,"validationErrorCount",y,this),_(this,"validationMessages",v,this),_(this,"controlGroup",g,this),_(this,"flashMessages",w,this),_(this,"router",k,this),_(this,"store",x,this),T(this,"whitespaceWarning",(0,c.WHITESPACE_WARNING)("path")),_(this,"waitForKeyUp",P,this)}setup(e,[t,n]){this.codemirrorString=t.toJSONString(),this.validationMessages={path:""},l.default.testing&&(this.secretPaths=["beep","bop","boop"]),this.checkRows(),"edit"===n&&this.addRow()}checkRows(){0===this.args.secretData.length&&this.addRow()}checkValidation(e,t){"path"===e&&(this.pathHasWhiteSpace(t),t?(0,r.set)(this.validationMessages,e,""):(0,r.set)(this.validationMessages,e,`${e} can't be blank.`))
const n=Object.values(this.validationMessages)
this.validationErrorCount=n.filter(Boolean).length}onEscape(e){if(e.keyCode!==i.default.ESC||"show"!==this.args.mode)return
const t=this.args.model.parentKey
t?this.transitionToRoute("vault.cluster.secrets.backend.list",t):this.transitionToRoute("vault.cluster.secrets.backend.list-root")}pathHasWhiteSpace(e){const t=new RegExp("\\s","g")
this.pathWhiteSpaceWarning=t.test(e)}persistKey(e){const t=this.args.model,l=this.args.modelForData
let i=l?.path||t.id
return i.startsWith("/")&&(i=i.replace(/^\/+/g,""),l.set(l.pathAttr,i)),l.save().then((()=>{l.isError||this.saveComplete(e,i)})).catch((e=>{if(e instanceof n.default){const t=this.controlGroup.logFromError(e)
this.error=t.content,this.controlGroup.saveTokenFromError(e)}throw e}))}saveComplete(e,t){e(t)}transitionToRoute(){return this.router.transitionTo(...arguments)}addRow(){const e=this.args.secretData;(0,s.isNone)(e.find((e=>""===e.name)))&&(e.pushObject({name:"",value:""}),this.handleChange()),this.checkRows()}codemirrorUpdated(e,t){this.error=null,t.performLint()
if(0===t.state.lint.marked.length)try{this.args.secretData.fromJSONString(e),(0,r.set)(this.args.modelForData,"secretData",this.args.secretData.toJSON())}catch(n){this.error=n.message}this.codemirrorString=e}createOrUpdateKey(e,t){if(t.preventDefault(),"create"===e&&(0,s.isBlank)(this.args.modelForData.path||this.args.modelForData.id))return void this.checkValidation("path","")
const n="create"===e?this.args.modelForData.path:this.args.model.id
this.persistKey((()=>{this.flashMessages.success(`Secret ${n} ${"create"===e?"created":"updated"} successfully.`),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}))}deleteRow(e){const t=this.args.secretData,n=t.find((t=>t.name===e));(0,s.isBlank)(n.name)||(t.removeObject(n),this.checkRows(),this.handleChange())}formatJSON(){this.codemirrorString=this.args.secretData.toJSONString(!0)}handleMaskedInputChange(e,t,n){const l={...e,value:n};(0,r.set)(this.args.secretData,t,l),this.handleChange()}handleChange(){this.codemirrorString=this.args.secretData.toJSONString(!0),(0,r.set)(this.args.modelForData,"secretData",this.args.secretData.toJSON())}updateValidationErrorCount(e){this.validationErrorCount=e}},f=O(p.prototype,"codemirrorString",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=O(p.prototype,"error",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=O(p.prototype,"secretPaths",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=O(p.prototype,"pathWhiteSpaceWarning",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),y=O(p.prototype,"validationErrorCount",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),v=O(p.prototype,"validationMessages",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),g=O(p.prototype,"controlGroup",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=O(p.prototype,"flashMessages",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=O(p.prototype,"router",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=O(p.prototype,"store",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O(p.prototype,"setup",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"setup"),p.prototype),P=O(p.prototype,"waitForKeyUp",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O(p.prototype,"addRow",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"addRow"),p.prototype),O(p.prototype,"codemirrorUpdated",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"codemirrorUpdated"),p.prototype),O(p.prototype,"createOrUpdateKey",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"createOrUpdateKey"),p.prototype),O(p.prototype,"deleteRow",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"deleteRow"),p.prototype),O(p.prototype,"formatJSON",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"formatJSON"),p.prototype),O(p.prototype,"handleMaskedInputChange",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"handleMaskedInputChange"),p.prototype),O(p.prototype,"handleChange",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"handleChange"),p.prototype),O(p.prototype,"updateValidationErrorCount",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"updateValidationErrorCount"),p.prototype),p)})),define("vault/components/secret-edit-toolbar",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,i,r,a){var o,s,u,c,d
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(o=class extends t.default{constructor(...e){super(...e),p(this,"store",s,this),p(this,"router",u,this),p(this,"flashMessages",c,this),p(this,"wrappedData",d,this)}clearWrappedData(){this.wrappedData=null}handleDelete(){this.args.model.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.secrets.backend.list-root")}))}*wrapSecret(){const{id:e}=this.args.modelForData,{backend:t}=this.args.model,n={wrapTTL:1800}
try{const l=yield this.store.adapterFor("secret").queryRecord(null,null,{backend:t,id:e,...n})
this.wrappedData=l.wrap_info.token,this.flashMessages.success("Secret successfully wrapped!")}catch(l){this.flashMessages.danger("Could not wrap secret.")}}},s=f(o.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(o.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(o.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(o.prototype,"wrappedData",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f(o.prototype,"clearWrappedData",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"clearWrappedData"),o.prototype),f(o.prototype,"handleDelete",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"handleDelete"),o.prototype),f(o.prototype,"wrapSecret",[r.task,a.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"wrapSecret"),o.prototype),o)})),define("vault/components/secret-edit",["exports","@ember/service","@glimmer/component","@ember/object","@glimmer/tracking","vault/lib/kv-object","vault/macros/maybe-query-record","@ember/object/computed"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(s=(0,a.maybeQueryRecord)("capabilities",(e=>{if(!e.args.model||"create"===e.args.mode)return
return{id:`${e.args.model.backend}/${e.args.model.id}`}}),"model","model.id","mode"),u=(0,o.alias)("checkSecretCapabilities.canUpdate"),c=(0,o.alias)("checkSecretCapabilities.canRead"),d=(0,o.or)("model.isLoading","model.isReloading","model.isSaving"),p=(0,o.or)("requestInFlight","model.isFolder","model.flagsIsInvalid"),f=class extends n.default{constructor(...e){super(...e),x(this,"store",m,this),x(this,"secretData",h,this),x(this,"codemirrorString",b,this),x(this,"checkSecretCapabilities",y,this),x(this,"canUpdateSecret",v,this),x(this,"canReadSecret",g,this),x(this,"requestInFlight",w,this),x(this,"buttonDisabled",k,this)}createKvData(e,[t]){this.secretData=r.default.create({content:[]}).fromJSON(t.secretData),this.codemirrorString=this.secretData.toJSONString()}get modelForData(){const{model:e}=this.args
return e||null}get basicModeDisabled(){return this.secretDataIsAdvanced||!1===this.showAdvancedMode}get secretDataAsJSON(){return this.secretData.toJSON()}get secretDataIsAdvanced(){return this.secretData.isAdvanced()}get showAdvancedMode(){return this.secretDataIsAdvanced||this.args.preferAdvancedEdit}get isWriteWithoutRead(){return!!this.args.model&&!!this.args.model.failedServerRead}refresh(){this.args.onRefresh()}toggleAdvanced(e){this.args.onToggleAdvancedEdit(e)}},m=P(f.prototype,"store",[t.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=P(f.prototype,"secretData",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=P(f.prototype,"codemirrorString",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),P(f.prototype,"createKvData",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"createKvData"),f.prototype),y=P(f.prototype,"checkSecretCapabilities",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=P(f.prototype,"canUpdateSecret",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=P(f.prototype,"canReadSecret",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=P(f.prototype,"requestInFlight",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=P(f.prototype,"buttonDisabled",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P(f.prototype,"refresh",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"refresh"),f.prototype),P(f.prototype,"toggleAdvanced",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"toggleAdvanced"),f.prototype),f)})),define("vault/components/secret-engine/configuration-details",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"RStzVbs4",block:'[[[41,[30,1,["length"]],[[[42,[28,[37,2],[[28,[37,2],[[30,1]],null]],null],null,[[[42,[28,[37,2],[[28,[37,2],[[30,2,["attrs"]]],null]],null],null,[[[41,[28,[37,3],[[30,3,["options","sensitive"]],[28,[37,4],[[30,3,["name"]],"publicKey"],null]],null],[[[1,"        "],[8,[39,5],[[16,"alwaysRender",[28,[37,6],[[28,[37,7],[[28,[37,8],[[30,2],[30,3,["name"]]],null]],null]],null]]],[["@label","@value"],[[28,[37,3],[[30,3,["options","label"]],[28,[37,9],[[30,3,["name"]]],null]],null],[28,[37,8],[[30,2],[28,[37,3],[[30,3,["options","fieldValue"]],[30,3,["name"]]],null]],null]]],[["default"],[[[[1,"\\n"],[41,[28,[37,3],[[30,3,["options","sensitive"]],[28,[37,4],[[30,3,["name"]],"publicKey"],null]],null],[[[1,"            "],[8,[39,10],null,[["@value","@name","@displayOnly","@allowCopy"],[[28,[37,8],[[30,2],[30,3,["name"]]],null],[30,3,["name"]],true,true]],null],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n"]],[]],[[[1,"        "],[8,[39,5],null,[["@alwaysRender","@label","@value"],[[28,[37,6],[[28,[37,7],[[28,[37,8],[[30,4],[30,3,["name"]]],null]],null]],null],[28,[37,3],[[30,3,["options","label"]],[28,[37,9],[[30,3,["name"]]],null]],null],[28,[37,8],[[30,2],[28,[37,3],[[30,3,["options","fieldValue"]],[30,3,["name"]]],null]],null]]],null],[1,"\\n"]],[]]]],[3]],null]],[2]],null]],[]],[[[1,"  "],[8,[39,11],null,[["@title","@message"],[[29,[[30,5]," not configured"]],[29,["Get started by configuring your ",[30,5]," engine."]]]],[["default"],[[[[1,"\\n    "],[8,[39,12],null,[["@icon","@iconPosition","@text","@route","@model"],["chevron-right","trailing",[29,["Configure ",[30,5]]],"vault.cluster.secrets.backend.configuration.edit",[30,6]]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]],["@configModels","configModel","attr","@model","@typeDisplay","@id"],false,["if","each","-track-array","or","eq","info-table-row","not","is-empty-value","get","to-label","masked-input","empty-state","hds/link/standalone"]]',moduleName:"vault/components/secret-engine/configuration-details.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/secret-engine/configure-aws",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/object","ember-concurrency","@ember/test-waiters","@ember/service","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u,c){var d,p,f,m,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function _(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const T=(0,c.createTemplateFactory)({id:"K5X4jawD",block:'[[[11,"form"],[24,"aria-label","save aws creds"],[4,[38,0],["submit",[28,[37,1],[[30,0,["submitForm"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-fullwidth is-shadowless is-marginless"],[12],[1,"\\n    "],[8,[39,2],null,[["@mode","@noun"],["save","configuration"]],null],[1,"\\n    "],[8,[39,3],null,[["@errorMessage"],[[30,0,["errorMessageRoot"]]]],null],[1,"\\n    "],[10,2],[14,0,"has-text-grey-dark"],[12],[1,"\\n      Note: the client uses the official AWS SDK and will use the specified credentials, environment credentials, shared file\\n      credentials, or IAM role/ECS task credentials in that order.\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[1,"  "],[10,"h2"],[14,0,"title is-5 has-bottom-padding-s has-top-margin-l"],[12],[1,"\\n    Access to AWS\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"box is-fullwidth is-sideless"],[12],[1,"\\n"],[41,[30,0,["version","isEnterprise"]],[[[1,"      "],[10,"fieldset"],[14,0,"field form-fieldset"],[14,1,"protection"],[12],[1,"\\n        "],[10,"legend"],[14,0,"is-label"],[12],[1,"Access Type"],[13],[1,"\\n        "],[10,2],[14,0,"sub-text"],[12],[1,"\\n"],[41,[30,0,["disableAccessType"]],[[[1,"            You cannot edit Access Type if you have already saved access credentials.\\n"]],[]],[[[1,"            Choose the way to configure access to AWS. Access can be configured either with IAM access keys, or using Plugin\\n            Workload Identity Federation (WIF)."]],[]]],[13],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[8,[39,5],[[24,1,"access-type-iam"],[24,3,"iam"],[24,0,"radio"]],[["@value","@groupValue","@onChange","@disabled"],["iam",[30,0,["accessType"]],[28,[37,6],[[30,0,["onChangeAccessType"]],"iam"],null],[30,0,["disableAccessType"]]]],null],[1,"\\n          "],[10,"label"],[14,"for","access-type-iam"],[12],[1,"IAM Credentials"],[13],[1,"\\n\\n          "],[8,[39,5],[[24,1,"access-type-wif"],[24,3,"wif"],[24,0,"radio has-left-margin-m"]],[["@value","@groupValue","@onChange","@disabled"],["wif",[30,0,["accessType"]],[28,[37,6],[[30,0,["onChangeAccessType"]],"wif"],null],[30,0,["disableAccessType"]]]],null],[1,"\\n          "],[10,"label"],[14,"for","access-type-wif"],[12],[1,"Workload Identity Federation"],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[41,[28,[37,7],[[30,0,["accessType"]],"wif"],null],[[[42,[28,[37,9],[[28,[37,9],[[30,1,["attrs"]]],null]],null],null,[[[1,"        "],[8,[39,10],null,[["@attr","@model"],[[30,2],[30,1]]],null],[1,"\\n"]],[2]],null],[1,"      "],[8,[39,11],null,[["@model","@mode","@modelValidations","@groupName"],[[30,3],[52,[30,3,["isNew"]],"create","edit"],[30,0,["modelValidationsRoot"]],"fieldGroupsWif"]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,11],null,[["@model","@mode","@modelValidations","@useEnableInput","@groupName"],[[30,3],[52,[30,3,["isNew"]],"create","edit"],[30,0,["modelValidationsRoot"]],true,"fieldGroupsIam"]],null],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n\\n"],[1,"  "],[10,"h2"],[14,0,"title is-5 has-bottom-padding-s has-top-margin-l"],[12],[1,"\\n    Leases\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"box is-fullwidth is-sideless is-bottomless"],[12],[1,"\\n"],[42,[28,[37,9],[[28,[37,9],[[30,4,["attrs"]]],null]],null],null,[[[1,"      "],[8,[39,10],null,[["@attr","@model","@modelValidations"],[[30,5],[30,4],[30,0,["modelValidationsLease"]]]],null],[1,"\\n"]],[5]],null],[1,"  "],[13],[1,"\\n\\n  "],[10,0],[14,0,"box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,12],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,12],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,0],["click",[30,0,["onCancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"      "],[8,[39,13],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["saveIssuerWarning"]],[[[1,"  "],[8,[39,14],null,[["@color","@onClose"],["warning",[28,[37,15],[[30,0],[28,[37,16],[[30,0,["saveIssuerWarning"]]],null],""],null]]],[["default"],[[[[1,"\\n    "],[8,[30,6,["Header"]],null,[["@icon"],["alert-circle"]],[["default"],[[[[1,"\\n      Are you sure?\\n    "]],[]]]]],[1,"\\n    "],[8,[30,6,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n        "],[1,[30,0,["saveIssuerWarning"]]],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,6,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,17],null,null,[["default"],[[[[1,"\\n        "],[8,[39,12],[[4,[38,0],["click",[30,0,["continueSubmitForm"]]],null]],[["@text"],["Continue"]],null],[1,"\\n        "],[8,[39,12],[[4,[38,0],["click",[30,7,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[7]]]]],[1,"\\n  "]],[6]]]]],[1,"\\n"]],[]],null]],["@issuerConfig","attr","@rootConfig","@leaseConfig","attr","M","F"],false,["on","perform","namespace-reminder","message-error","if","radio-button","fn","eq","each","-track-array","form-field","form-field-groups","hds/button","alert-inline","hds/modal","action","mut","hds/button-set"]]',moduleName:"vault/components/secret-engine/configure-aws.hbs",isStrictMode:!1})
let O=e.default=(d=class extends l.default{constructor(e,t){if(super(e,t),x(this,"router",p,this),x(this,"store",f,this),x(this,"version",m,this),x(this,"flashMessages",h,this),x(this,"errorMessageRoot",b,this),x(this,"errorMessageLease",y,this),x(this,"invalidFormAlert",v,this),x(this,"modelValidationsLease",g,this),x(this,"accessType",w,this),x(this,"saveIssuerWarning",k,this),P(this,"disableAccessType",!1),P(this,"submitForm",(0,n.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(e){e?.preventDefault(),this.resetErrors()
const{leaseConfig:t,issuerConfig:n}=this.args
this.validate(t)&&(n?.hasDirtyAttributes?this.saveIssuerWarning=`You are updating the global issuer config. This will overwrite Vault's current issuer ${n.queryIssuerError?"if it exists ":""}and may affect other configurations using this value. Continue?`:yield this.save.perform())}))})),null,"submitForm",null)),P(this,"save",(0,n.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(){const{leaseConfig:e,rootConfig:t,issuerConfig:n}=this.args,l=Object.keys(e?.changedAttributes()).some((e=>"backend"!==e)),i=Object.keys(t?.changedAttributes()).some((e=>"backend"!==e)),r=n?.hasDirtyAttributes
if(!l&&!i&&!r)return this.flashMessages.info("No changes detected."),void this.transition()
const a=!!i&&(yield this.saveRoot()),o=!!l&&(yield this.saveLease()),s=!!r&&(yield this.updateIssuer());(a||o||s)&&this.transition()}))})),null,"save",null)),this.version.isCommunity||this.args.rootConfig.isNew)return
const{roleArn:l,identityTokenAudience:i,identityTokenTtl:r,accessKey:o}=this.args.rootConfig,s=!!l||!!i||!!r,u=!!o
this.accessType=s?"wif":"iam",this.disableAccessType=s||u}continueSubmitForm(){this.saveIssuerWarning="",this.save.perform()}async updateIssuer(){try{return await this.args.issuerConfig.save(),this.flashMessages.success("Issuer saved successfully"),!0}catch(e){return this.flashMessages.danger(`Issuer was not saved: ${(0,u.default)(e,"Check Vault logs for details.")}`),!1}}async saveRoot(){const{backendPath:e,rootConfig:t}=this.args
try{return await t.save(),this.flashMessages.success(`Successfully saved ${e}'s root configuration.`),!0}catch(n){return this.errorMessageRoot=(0,u.default)(n),this.invalidFormAlert="There was an error submitting this form.",!1}}async saveLease(){const{backendPath:e,leaseConfig:t}=this.args
try{return await t.save(),this.flashMessages.success(`Successfully saved ${e}'s lease configuration.`),!0}catch(n){return this.errorMessageRoot?(this.errorMessageLease=(0,u.default)(n),this.flashMessages.danger(`Configuration not saved: ${(0,u.default)(n)}. ${this.errorMessageRoot}`),!1):(this.flashMessages.danger(`Lease configuration was not saved: ${(0,u.default)(n)}`,{sticky:!0}),!0)}}resetErrors(){this.flashMessages.clearMessages(),this.errorMessageRoot=null,this.invalidFormAlert=null}transition(){this.router.transitionTo("vault.cluster.secrets.backend.configuration",this.args.backendPath)}validate(e){const{isValid:t,state:n,invalidFormMessage:l}=e.validate()
return this.modelValidationsLease=t?null:n,this.invalidFormAlert=t?"":l,t}unloadModels(){this.args.rootConfig.unloadRecord(),this.args.leaseConfig.unloadRecord()}onChangeAccessType(e){this.accessType=e
const{rootConfig:t}=this.args
"iam"===e&&(t.roleArn=t.identityTokenAudience=t.identityTokenTtl=void 0,this.args.issuerConfig.rollbackAttributes()),"wif"===e&&(t.accessKey=t.secretKey=void 0)}onCancel(){this.resetErrors(),this.unloadModels(),this.transition()}},p=_(d.prototype,"router",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=_(d.prototype,"store",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=_(d.prototype,"version",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=_(d.prototype,"flashMessages",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=_(d.prototype,"errorMessageRoot",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),y=_(d.prototype,"errorMessageLease",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v=_(d.prototype,"invalidFormAlert",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),g=_(d.prototype,"modelValidationsLease",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),w=_(d.prototype,"accessType",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"iam"}}),k=_(d.prototype,"saveIssuerWarning",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),_(d.prototype,"continueSubmitForm",[i.action],Object.getOwnPropertyDescriptor(d.prototype,"continueSubmitForm"),d.prototype),_(d.prototype,"onChangeAccessType",[i.action],Object.getOwnPropertyDescriptor(d.prototype,"onChangeAccessType"),d.prototype),_(d.prototype,"onCancel",[i.action],Object.getOwnPropertyDescriptor(d.prototype,"onCancel"),d.prototype),d);(0,t.setComponentTemplate)(T,O)})),define("vault/components/secret-engine/configure-ssh",["exports","@ember/component","@glimmer/component","@ember/object","ember-concurrency","@ember/test-waiters","@ember/service","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u){var c,d,p,f,m,h,b
function y(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function v(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,u.createTemplateFactory)({id:"xt9WDGmC",block:'[[[11,"form"],[24,"aria-label","save ssh creds"],[24,0,"has-top-padding-m"],[4,[38,0],["submit",[28,[37,1],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[8,[39,2],null,[["@mode","@noun"],["save","configuration"]],null],[1,"\\n  "],[8,[39,3],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"],[41,[30,1,["isNew"]],[[[42,[28,[37,6],[[28,[37,6],[[30,1,["formFields"]]],null]],null],null,[[[1,"      "],[8,[39,7],null,[["@attr","@model","@modelValidations"],[[30,2],[30,1],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[2]],null],[1,"    "],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n    "],[8,[39,8],null,null,[["default"],[[[[1,"\\n      "],[8,[39,9],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,9],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,0],["click",[30,0,["onCancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"      "],[8,[39,10],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n"]],[]],null]],[]],[[[1,"    "],[10,2],[14,0,"has-text-grey-dark has-top-bottom-margin"],[12],[1,"\\n      NOTE: You must delete your existing certificate and key before saving new values.\\n    "],[13],[1,"\\n\\n    "],[10,0],[14,0,"box is-fullwidth is-sideless"],[12],[1,"\\n      "],[10,"label"],[14,"for","publicKey"],[14,0,"is-label"],[12],[1,"\\n        Public key\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,11],null,[["@name","@id","@value","@displayOnly","@allowCopy"],["publickey","publicKey",[30,1,["publicKey"]],true,true]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,8],null,null,[["default"],[[[[1,"\\n      "],[8,[39,12],[[24,0,"primary"]],[["@text","@textToCopy","@onError"],["Copy",[30,1,["publicKey"]],[28,[37,13],[[28,[37,14],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n      "],[8,[39,15],null,[["@buttonText","@buttonColor","@confirmMessage","@onConfirmAction"],["Delete","secondary","Confirming will remove the CA certificate information.",[30,0,["deleteCaConfig"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]],[13]],["@model","attr"],false,["on","perform","namespace-reminder","message-error","if","each","-track-array","form-field","hds/button-set","hds/button","alert-inline","masked-input","hds/copy/button","fn","set-flash-message","confirm-action"]]',moduleName:"vault/components/secret-engine/configure-ssh.hbs",isStrictMode:!1})
let w=e.default=(c=class extends n.default{constructor(...e){super(...e),y(this,"router",d,this),y(this,"store",p,this),y(this,"flashMessages",f,this),y(this,"errorMessage",m,this),y(this,"invalidFormAlert",h,this),y(this,"modelValidations",b,this)}*save(e){e.preventDefault(),this.resetErrors()
const{id:t,model:n}=this.args
if(!this.validate(n))return
Object.keys(n.changedAttributes()).length>0||(this.flashMessages.info("No changes detected."),this.transition())
try{yield n.save(),this.transition(),this.flashMessages.success(`Successfully saved ${t}'s root configuration.`)}catch(l){this.errorMessage=(0,s.default)(l),this.invalidFormAlert="There was an error submitting this form."}}resetErrors(){this.flashMessages.clearMessages(),this.errorMessage=null,this.invalidFormAlert=null}transition(e=!1){const{id:t}=this.args
e?this.router.transitionTo("vault.cluster.secrets.backend.configuration.edit",t):this.router.transitionTo("vault.cluster.secrets.backend.configuration",t)}validate(e){const{isValid:t,state:n,invalidFormMessage:l}=e.validate()
return this.modelValidations=t?null:n,this.invalidFormAlert=t?"":l,t}onCancel(){this.resetErrors(),this.transition()}async deleteCaConfig(){const{model:e}=this.args
try{await e.destroyRecord(),this.transition(!0),this.flashMessages.success("CA information deleted successfully.")}catch(t){e.rollbackAttributes(),this.flashMessages.danger((0,s.default)(t))}}},d=v(c.prototype,"router",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=v(c.prototype,"store",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(c.prototype,"flashMessages",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(c.prototype,"errorMessage",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=v(c.prototype,"invalidFormAlert",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=v(c.prototype,"modelValidations",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v(c.prototype,"save",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"save"),c.prototype),v(c.prototype,"onCancel",[l.action],Object.getOwnPropertyDescriptor(c.prototype,"onCancel"),c.prototype),v(c.prototype,"deleteCaConfig",[l.action],Object.getOwnPropertyDescriptor(c.prototype,"deleteCaConfig"),c.prototype),c);(0,t.setComponentTemplate)(g,w)})),define("vault/components/secret-link",["exports","@ember/component","@glimmer/component","@ember/object","vault/utils/path-encoding-helpers","@ember/debug","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,a.createTemplateFactory)({id:"bLrGrCxV",block:'[[[8,[39,0],[[17,1]],[["@route","@models","@query","@disabled"],[[30,0,["link","route"]],[30,0,["link","models"]],[30,0,["query"]],[30,2]]],[["default"],[[[[1,"\\n  "],[18,3,null],[1,"\\n"]],[]]]]]],["&attrs","@disabled","&default"],false,["link-to","yield"]]',moduleName:"vault/components/secret-link.hbs",isStrictMode:!1})
let u=e.default=(o=class extends n.default{get link(){const{mode:e,secret:t,backend:n}=this.args
n||(0,r.debug)(`Arg "backend" missing from secret-link with mode: ${e} secret: ${t}`)
const l=`vault.cluster.secrets.backend.${e}`,a=n?[(0,i.encodePath)(n)]:[]
return"versions"!==e&&!t||" "===t?{route:`${l}-root`,models:a}:(a.push((0,i.encodePath)(t)),{route:l,models:a})}get query(){const e=this.args.queryParams||{}
return e.isQueryParams?e.values:e}onLinkClick(){this.args.onLinkClick&&this.args.onLinkClick(...arguments)}},c=o.prototype,d="onLinkClick",p=[l.action],f=Object.getOwnPropertyDescriptor(o.prototype,"onLinkClick"),m=o.prototype,h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),void 0===h.initializer&&Object.defineProperty(c,d,h),o)
var c,d,p,f,m,h;(0,t.setComponentTemplate)(s,u)})),define("vault/components/secret-list-header-tab",["exports","core/components/secret-list-header-tab"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-list-header",["exports","core/components/secret-list-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-list/aws-role-item",["exports","@glimmer/component","@glimmer/tracking"],(function(e,t,n){var l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="showConfirmModal",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="showConfirmModal",o=[n.tracked],s={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/components/secret-list/database-list-item",["exports","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object"],(function(e,t,n,l,i){var r,a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){super(...e),c(this,"roleType",a,this),c(this,"actionRunning",o,this),c(this,"store",s,this),c(this,"flashMessages",u,this)}get keyTypeValue(){const e=this.args.item
return"roles"===e.path?"dynamic":"static-roles"===e.path?"static":""}resetConnection(e){const{backend:t}=this.args.item,n=this.store.adapterFor("database/connection")
this.actionRunning="reset",n.resetConnection(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was reset`)})).catch((e=>{this.flashMessages.danger(e.errors)})).finally((()=>this.actionRunning=null))}rotateRootCred(e){const{backend:t}=this.args.item,n=this.store.adapterFor("database/connection")
this.actionRunning="rotateRoot",n.rotateRootCredentials(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)})).finally((()=>this.actionRunning=null))}rotateRoleCred(e){const{backend:t}=this.args.item,n=this.store.adapterFor("database/credential")
this.actionRunning="rotateRole",n.rotateRoleCredentials(t,e).then((()=>{this.flashMessages.success(`Success: Credentials for ${e} role were rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)})).finally((()=>this.actionRunning=null))}},a=d(r.prototype,"roleType",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),o=d(r.prototype,"actionRunning",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),s=d(r.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(r.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d(r.prototype,"resetConnection",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"resetConnection"),r.prototype),d(r.prototype,"rotateRootCred",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"rotateRootCred"),r.prototype),d(r.prototype,"rotateRoleCred",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"rotateRoleCred"),r.prototype),r)})),define("vault/components/secret-list/item",["exports","@glimmer/component","@glimmer/tracking"],(function(e,t,n){var l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="showConfirmModal",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="showConfirmModal",o=[n.tracked],s={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c}))
define("vault/components/secret-list/ssh-role-item",["exports","@glimmer/component","@glimmer/tracking"],(function(e,t,n){var l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="showConfirmModal",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="showConfirmModal",o=[n.tracked],s={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/components/secret-list/transform-list-item",["exports","@ember/object","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({item:null,itemPath:"",itemType:"",isBuiltin:(0,t.computed)("item","itemType",(function(){const e=this.item
return("alphabet"===this.itemType||"template"===this.itemType)&&e.id.startsWith("builtin/")})),backendType:"transform"})})),define("vault/components/secrets-engine-mount-config",["exports","core/components/secrets-engine-mount-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/section-tabs",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"/Cv+DYV5",block:'[[[44,[[28,[37,1],[[30,1],[30,0,["tabType"]],[30,2]],null]],[[[41,[30,3,["length"]],[[[1,"    "],[10,0],[14,0,"tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[12],[1,"\\n      "],[10,"nav"],[14,0,"tabs"],[15,"aria-label",[29,["navigation to manage ",[30,1,["type"]]]]],[12],[1,"\\n        "],[10,"ul"],[12],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,3]],null]],null],null,[[[1,"            "],[10,"li"],[12],[1,"\\n              "],[8,[39,5],null,[["@route","@models"],[[30,4,["route"]],[30,4,["routeParams"]]]],[["default"],[[[[1,"\\n                "],[1,[30,4,["label"]]],[1,"\\n              "]],[]]]]],[1,"\\n            "],[13],[1,"\\n"]],[4]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],null]],[3]]]],["@model","@paths","tabs","tab"],false,["let","tabs-for-auth-section","if","each","-track-array","link-to"]]',moduleName:"vault/components/section-tabs.hbs",isStrictMode:!1})
class r extends n.default{get tabType(){return this.args.tabType||"authSettings"}}e.default=r,(0,t.setComponentTemplate)(i,r)})),define("vault/components/select",["exports","core/components/select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/selectable-card",["exports","core/components/selectable-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/shamir-progress",["exports","@ember/component","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({threshold:null,progress:null,classNames:["shamir-progress"],progressDecimal:(0,n.computed)("threshold","progress",(function(){const{threshold:e,progress:t}=this
return e&&t?t/e:0}))})})),define("vault/components/shamir/dr-token-flow",["exports","core/components/shamir/dr-token-flow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/shamir/flow",["exports","core/components/shamir/flow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/shamir/form",["exports","core/components/shamir/form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/sidebar/frame",["exports","@ember/component","@glimmer/component","@ember/service","@ember/controller","@ember/template-factory"],(function(e,t,n,l,i,r){var a,o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,r.createTemplateFactory)({id:"V4fJWNxy",block:'[[[8,[39,0],null,[["@hasSidebar","@hasHeader","@hasFooter"],[[30,1],false,false]],[["default"],[[[[1,"\\n  "],[8,[30,2,["Sidebar"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@isResponsive","@hasA11yRefocus","@a11yRefocusSkipTo"],[true,true,"app-main-content"]],[["header","body","footer"],[[[[1,"\\n        "],[8,[39,2],null,null,[["logo","actions"],[[[[1,"\\n            "],[8,[39,3],null,[["@icon","@route","@model","@ariaLabel"],["vault","vault.cluster.dashboard",[30,0,["currentCluster","cluster","name"]],"Vault home"]],null],[1,"\\n          "]],[]],[[[1,"\\n            "],[8,[39,4],[[4,[38,5],["click",[28,[37,6],[[28,[37,7],[[30,0,["console","isOpen"]]],null],[28,[37,8],[[30,0,["console","isOpen"]]],null]],null]],null]],[["@icon","@ariaLabel"],["terminal-screen","Console toggle"]],null],[1,"\\n            "],[8,[39,9],null,null,null],[1,"\\n          "]],[]]]]],[1,"\\n      "]],[]],[[[1,"\\n        "],[8,[39,10],null,null,null],[1,"\\n      "]],[]],[[[1,"\\n"],[41,[28,[37,12],["Namespaces"],null],[[[1,"          "],[8,[39,13],[[24,0,"hds-side-nav-hide-when-minimized"]],[["@namespace"],[[30,0,["clusterController","namespaceQueryParam"]]]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,2,["Main"]],[[24,1,"app-main-content"],[16,0,[52,[30,0,["console","isOpen"]],"main--console-open"]]],null,[["default"],[[[[1,"\\n"],[1,"    "],[8,[39,14],null,[["@status"],[[30,0,["currentCluster","cluster","hcpLinkStatus"]]]],null],[1,"\\n    "],[18,3,null],[1,"\\n    "],[10,0],[15,0,[52,[30,0,["console","isOpen"]],"panel-open"]],[12],[1,"\\n"],[41,[30,0,["console","isOpen"]],[[[1,"        "],[8,[39,16],[[4,[38,17],null,[["focusTrapOptions"],[[28,[37,18],null,[["initialFocus","clickOutsideDeactivates","onDeactivate"],["#console-input",true,[30,0,["closeConsole"]]]]]]]]],[["@isFullscreen"],[[30,0,["consoleFullscreen"]]]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]]]]]],["@showSidebar","Frame","&default"],false,["hds/app-frame","hds/side-nav","hds/side-nav/header","hds/side-nav/header/home-link","hds/side-nav/header/icon-button","on","fn","mut","not","sidebar/user-menu","hds/side-nav/portal/target","if","has-feature","namespace-picker","link-status","yield","console/ui-panel","focus-trap","hash"]]',moduleName:"vault/components/sidebar/frame.hbs",isStrictMode:!1})
let m=e.default=(a=(0,i.inject)("vault.cluster"),o=class extends n.default{constructor(...e){super(...e),d(this,"currentCluster",s,this),d(this,"console",u,this),d(this,"clusterController",c,this)}},s=p(o.prototype,"currentCluster",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"console",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"clusterController",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/sidebar/nav/access",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"K40BzJay",block:'[[[8,[39,0],null,[["@ariaLabel"],["Access Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n"],[41,[28,[37,2],["access"],[["routeParams"],[[28,[37,3],["methods","mfa","oidc"],null]]]],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Authentication"]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["methods"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.access.methods","vault.cluster.access.methods vault.cluster.access.method vault.cluster.settings.auth","Authentication Methods"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["mfa"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.access.mfa.methods","vault.cluster.access.mfa.methods vault.cluster.access.mfa.enforcements vault.cluster.access.mfa.index","Multi-Factor Authentication"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["oidc"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.access.oidc","OIDC Provider"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,4],[[28,[37,5],["Control Groups"],null],[28,[37,2],["access"],[["routeParams"],["control-groups"]]]],null],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Access Control"]],[]]]]],[1,"\\n    "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.access.control-groups","vault.cluster.access.control-groups vault.cluster.access.control-group-accessor vault.cluster.access.control-groups-configure","Control Groups"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,2],["access"],[["routeParams"],[[28,[37,3],["namespaces","groups","entities"],null]]]],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Organization"]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,4],[[28,[37,5],["Namespaces"],null],[28,[37,2],["access"],[["routeParams"],["namespaces"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.access.namespaces","Namespaces"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["groups"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.access.identity","groups","Groups"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["entities"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.access.identity","entities","Entities"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,2],["access"],[["routeParams"],["leases"]]],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Administration"]],[]]]]],[1,"\\n    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.access.leases","Leases"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav"],false,["hds/side-nav/portal","if","has-permission","array","and","has-feature"]]',moduleName:"vault/components/sidebar/nav/access.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/sidebar/nav/clients",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"RDLIeiNa",block:'[[[8,[39,0],null,[["@ariaLabel"],["Client Count Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Client Count"]],[]]]]],[1,"\\n\\n  "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.clients.counts.overview","vault.cluster.clients.counts","Vault Usage Metrics"]],null],[1,"\\n"],[41,[30,2],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text","@current-when"],["vault.cluster.clients.config","Configuration","vault.cluster.clients.config vault.cluster.clients.edit"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav","@canReadConfig"],false,["hds/side-nav/portal","if"]]',moduleName:"vault/components/sidebar/nav/clients.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/sidebar/nav/cluster",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,l,i){var r,a,o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,i.createTemplateFactory)({id:"nIrcds4E",block:'[[[8,[39,0],null,[["@ariaLabel"],["Cluster Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Vault"]],[]]]]],[1,"\\n\\n  "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.dashboard","Dashboard"]],null],[1,"\\n  "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.secrets","vault.cluster.secrets vault.cluster.settings.mount-secret-backend vault.cluster.secrets.backend.configuration.edit","Secrets Engines"]],null],[1,"\\n"],[41,[30,0,["flags","showSecretsSync"]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text","@badge"],["vault.cluster.sync","Secrets Sync",[52,[30,0,["flags","isHvdManaged"]],"Plus",""]]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@models","@current-when","@text","@hasSubItems"],[[28,[37,3],[[28,[37,4],["access"],null],"route"],null],[28,[37,3],[[28,[37,4],["access"],null],"models"],null],"vault.cluster.access vault.cluster.settings.auth","Access",true]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["policies"],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@models","@text","@hasSubItems"],["vault.cluster.policies",[28,[37,3],[[28,[37,4],["policies"],null],"models"],null],"Policies",true]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["tools"],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@models","@text","@hasSubItems"],["vault.cluster.tools.tool",[28,[37,3],[[28,[37,4],["tools"],null],"models"],null],"Tools",true]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,5],[[28,[37,6],[[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],[[28,[37,7],["replication","raft","license","seal"],null]]]]],null],[28,[37,6],[[28,[37,2],["clients"],[["routeParams"],["activity"]]],[28,[37,8],[[30,0,["hasChrootNamespace"]]],null]],null]],null],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Monitoring"]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,6],[[30,0,["version","isEnterprise"]],[30,0,["isRootNamespace"]],[28,[37,8],[[30,0,["cluster","replicationRedacted"]]],null],[28,[37,2],["status"],[["routeParams"],["replication"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text","@hasSubItems"],["vault.cluster.replication.index","Replication",true]],null],[1,"\\n"]],[]],null],[41,[28,[37,6],[[30,0,["cluster","usingRaft"]],[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["raft"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.storage",[30,0,["cluster","name"]],"Raft Storage"]],null],[1,"\\n"]],[]],null],[41,[28,[37,6],[[28,[37,2],["clients"],[["routeParams"],["activity"]]],[28,[37,8],[[30,0,["cluster","dr","isSecondary"]]],null],[28,[37,8],[[30,0,["hasChrootNamespace"]]],null]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text","@hasSubItems"],["vault.cluster.clients","Client Count",true]],null],[1,"\\n"]],[]],null],[41,[28,[37,6],[[30,0,["version","features"]],[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["license"]]],[28,[37,8],[[30,0,["cluster","dr","isSecondary"]]],null]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.license",[30,0,["cluster","name"]],"License"]],null],[1,"\\n"]],[]],null],[41,[28,[37,6],[[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["seal"]]],[28,[37,8],[[30,0,["cluster","dr","isSecondary"]]],null]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.settings.seal",[30,0,["cluster","name"]],"Seal Vault"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,6],[[30,0,["version","isEnterprise"]],[28,[37,2],["settings"],null]],null],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Settings"]],[]]]]],[1,"\\n    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.config-ui.messages","Custom Messages"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav"],false,["hds/side-nav/portal","if","has-permission","get","route-params-for","or","and","array","not"]]',moduleName:"vault/components/sidebar/nav/cluster.hbs",isStrictMode:!1})
let m=e.default=(r=class extends n.default{constructor(...e){super(...e),d(this,"currentCluster",a,this),d(this,"flags",o,this),d(this,"version",s,this),d(this,"auth",u,this),d(this,"namespace",c,this)}get cluster(){return this.currentCluster.cluster}get hasChrootNamespace(){return this.cluster?.hasChrootNamespace}get isRootNamespace(){return this.namespace.inRootNamespace&&!this.hasChrootNamespace}},a=p(r.prototype,"currentCluster",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=p(r.prototype,"flags",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"version",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(r.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(r.prototype,"namespace",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r);(0,t.setComponentTemplate)(f,m)})),define("vault/components/sidebar/nav/policies",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"d0Y4ZHuz",block:'[[[8,[39,0],null,[["@ariaLabel"],["Policies Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Policies"]],[]]]]],[1,"\\n\\n"],[41,[28,[37,2],["policies"],[["routeParams"],["acl"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@current-when","@text"],["vault.cluster.policies","acl","vault.cluster.policies vault.cluster.policy","ACL Policies"]],null],[1,"\\n"]],[]],null],[41,[28,[37,3],[[28,[37,4],["Sentinel"],null],[28,[37,2],["policies"],[["routeParams"],["rgp"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@current-when","@text"],["vault.cluster.policies","rgp","vault.cluster.policies vault.cluster.policy","Role-Governing Policies"]],null],[1,"\\n"]],[]],null],[41,[28,[37,3],[[28,[37,4],["Sentinel"],null],[28,[37,2],["policies"],[["routeParams"],["egp"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@current-when","@text"],["vault.cluster.policies","egp","vault.cluster.policies vault.cluster.policy","Endpoint Governing Policies"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav"],false,["hds/side-nav/portal","if","has-permission","and","has-feature"]]',moduleName:"vault/components/sidebar/nav/policies.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/sidebar/nav/tools",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"/GY1/a+I",block:'[[[8,[39,0],null,[["@ariaLabel"],["Tools Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Tools"]],[]]]]],[1,"\\n\\n"],[42,[28,[37,2],[[28,[37,2],[[28,[37,3],null,null]],null]],null],null,[[[41,[28,[37,5],["tools"],[["routeParams"],[[30,2]]]],[[[1,"      "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.tools.tool",[30,2],[28,[37,6],[[30,2]],null]]],null],[1,"\\n"]],[]],null]],[2]],null],[1,"  "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.tools.open-api-explorer","API Explorer"]],null],[1,"\\n"]],[1]]]]]],["Nav","supportedAction"],false,["hds/side-nav/portal","each","-track-array","tools-actions","if","has-permission","capitalize"]]',moduleName:"vault/components/sidebar/nav/tools.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/sidebar/user-menu",["exports","@ember/component","@glimmer/component","@ember/service","@ember/runloop","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"MLQJXGAn",block:'[[[8,[39,0],[[24,0,"sidebar-user-menu"]],[["@horizontalPosition","@verticalPosition","@renderInPlace"],["right","below",true]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Trigger"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@icon","@ariaLabel"],["user","User menu"]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["Content"]],null,null,[["default"],[[[[1,"\\n    "],[10,0],[14,0,"popup-menu-content"],[12],[1,"\\n      "],[10,0],[14,0,"box"],[12],[1,"\\n        "],[10,0],[14,0,"menu-label overflow-wrap"],[12],[1,"\\n          "],[1,[28,[35,2],[[30,0,["auth","authData","displayName"]]],null]],[1,"\\n        "],[13],[1,"\\n        "],[10,"nav"],[14,0,"menu"],[12],[1,"\\n          "],[10,"ul"],[14,0,"menu-list"],[12],[1,"\\n"],[41,[30,0,["auth","allowExpiration"]],[[[1,"              "],[10,"li"],[14,0,"token-alert is-flex"],[12],[1,"\\n                "],[10,1],[12],[8,[39,4],[[24,0,"has-text-highlight"]],[["@name"],["alert-triangle-fill"]],null],[13],[1,"\\n                "],[10,1],[14,0,"is-size-8 has-text-semibold"],[12],[1,"\\n                  We\'ve stopped auto-renewing your token due to inactivity. It will expire on\\n                  "],[1,[28,[35,5],[[30,0,["auth","tokenExpirationDate"]],"MMMM do yyyy, h:mm:ss a"],null]],[1,".\\n                "],[13],[1,"\\n              "],[13],[1,"\\n"]],[]],null],[41,[30,0,["hasEntityId"]],[[[1,"              "],[10,"li"],[12],[1,"\\n                "],[8,[39,6],null,[["@route"],["vault.cluster.mfa-setup"]],[["default"],[[[[1,"\\n                  Multi-factor authentication\\n                "]],[]]]]],[1,"\\n              "],[13],[1,"\\n"]],[]],null],[41,[30,0,["isUserpass"]],[[[1,"              "],[10,"li"],[12],[1,"\\n                "],[8,[39,6],null,[["@route"],["vault.cluster.access.reset-password"]],[["default"],[[[[1,"\\n                  Reset password\\n                "]],[]]]]],[1,"\\n              "],[13],[1,"\\n"]],[]],null],[1,"            "],[10,"li"],[14,1,"container"],[12],[1,"\\n"],[1,"              "],[8,[39,7],[[24,0,"in-dropdown link is-flex-start"]],[["@text","@textToCopy","@isFullWidth","@container","@onSuccess","@onError"],["Copy token",[30,0,["auth","currentToken"]],true,"#container",[28,[37,8],[[28,[37,9],["Token copied!"],null]],null],[28,[37,8],[[28,[37,9],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n            "],[13],[1,"\\n"],[41,[28,[37,10],[[28,[37,11],null,[["interval"],[1000]]],[30,0,["auth","tokenExpirationDate"]]],null],[[[41,[30,0,["auth","authData","renewable"]],[[[1,"                "],[10,"li"],[12],[1,"\\n"],[1,"                  "],[11,"button"],[16,0,[29,["link button ",[52,[30,0,["isRenewing"]],"is-loading"]]]],[24,4,"button"],[4,[38,12],["click",[30,0,["renewToken"]]],null],[12],[1,"\\n                    Renew token\\n                  "],[13],[1,"\\n                "],[13],[1,"\\n"]],[]],null],[1,"              "],[8,[39,13],null,[["@isInDropdown","@confirmTitle","@onConfirmAction","@buttonText","@confirmMessage"],[true,[29,["Revoke ",[28,[37,14],[[30,0,["auth"]],"authData.displayName"],null],"?"]],[28,[37,15],[[30,0],"revokeToken"],null],"Revoke token","You will not be able to log in again with this token."]],null],[1,"\\n"]],[]],null],[1,"            "],[10,"li"],[12],[1,"\\n              "],[8,[39,6],[[24,1,"logout"]],[["@route","@model"],["vault.cluster.logout",[30,0,["currentCluster","cluster","name"]]]],[["default"],[[[[1,"\\n                Log out\\n              "]],[]]]]],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]]],["Dropdown"],false,["basic-dropdown","hds/side-nav/header/icon-button","capitalize","if","icon","date-format","link-to","hds/copy/button","fn","set-flash-message","is-before","now","on","confirm-action","get","action"]]',moduleName:"vault/components/sidebar/user-menu.hbs",isStrictMode:!1})
let b=e.default=(s=class extends n.default{constructor(...e){super(...e),f(this,"auth",u,this),f(this,"currentCluster",c,this),f(this,"router",d,this),f(this,"fakeRenew",p,this)}get hasEntityId(){return!!this.auth.authData?.entity_id}get isUserpass(){return"userpass"===this.auth.authData?.backend?.type}get isRenewing(){return this.fakeRenew||this.auth.isRenewing}transitionToRoute(){this.router.transitionTo(...arguments)}renewToken(){this.fakeRenew=!0,(0,i.later)((()=>{this.auth.renew().then((()=>{this.fakeRenew=this.auth.isRenewing}))}),200)}revokeToken(){this.auth.revokeCurrentToken().then((()=>{this.transitionToRoute("vault.cluster.logout")}))}},u=m(s.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"currentCluster",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"fakeRenew",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),m(s.prototype,"renewToken",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"renewToken"),s.prototype),m(s.prototype,"revokeToken",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"revokeToken"),s.prototype),s);(0,t.setComponentTemplate)(h,b)})),define("vault/components/splash-page",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,l.createTemplateFactory)({id:"muidB9RC",block:'[[[10,0],[14,0,"splash-page-container section is-flex-v-centered-tablet is-flex-grow-1 is-fullwidth"],[12],[1,"\\n  "],[10,0],[14,0,"columns is-centered is-gapless is-fullwidth"],[12],[1,"\\n    "],[10,0],[14,0,"column is-4-desktop is-6-tablet"],[12],[1,"\\n      "],[10,0],[14,0,"splash-page-header"],[12],[1,"\\n        "],[18,1,null],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"splash-page-sub-header"],[12],[1,"\\n        "],[18,2,null],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"login-form box is-paddingless is-relative"],[12],[1,"\\n        "],[18,3,null],[1,"\\n      "],[13],[1,"\\n      "],[18,4,null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["&header","&subHeader","&content","&footer"],false,["yield"]]',moduleName:"vault/components/splash-page.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,(0,n.default)())})),define("vault/components/stat-text",["exports","core/components/stat-text"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/string-list",["exports","core/components/string-list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/sync-status-badge",["exports","core/components/sync-status-badge"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/text-file",["exports","core/components/text-file"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toggle-button",["exports","core/components/toggle-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toggle",["exports","core/components/toggle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/token-expire-warning",["exports","@ember/component","@glimmer/component","@ember/service","@glimmer/tracking","@ember/runloop","ember-concurrency","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,o.createTemplateFactory)({id:"qMrzQHtW",block:'[[[41,[28,[37,1],[[30,0,["showWarning"]],[28,[37,2],[[28,[37,3],null,[["interval"],[1000]]],[30,1]],null]],null],[[[1,"  "],[8,[39,4],null,[["@type","@color"],["page","critical"]],[["default"],[[[[1,"\\n    "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n    "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n      Your auth token expired on\\n      "],[1,[28,[35,5],[[30,1],"MMMM do yyyy, h:mm:ss a"],null]],[1,". You will need to re-authenticate.\\n    "]],[]]]]],[1,"\\n    "],[8,[30,2,["LinkStandalone"]],null,[["@icon","@iconPosition","@text","@route","@query"],["arrow-right","trailing","Reauthenticate","vault.cluster.logout",[30,0,["queryParams"]]]],null],[1,"\\n  "]],[2]]]]],[1,"\\n"]],[]],[[[1,"  "],[10,"section"],[14,0,"section"],[12],[1,"\\n    "],[10,0],[14,0,"container is-widescreen"],[12],[1,"\\n"],[41,[28,[37,1],[[30,0,["showWarning"]],[30,3],[30,0,["canDismiss"]]],null],[[[1,"        "],[8,[39,4],[[24,0,"has-top-margin-s"]],[["@type","@color","@onDismiss"],["inline","warning",[28,[37,6],[[28,[37,7],[[30,0,["canDismiss"]]],null],false],null]]],[["default"],[[[[1,"\\n          "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"Session will expire"]],[]]]]],[1,"\\n          "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,"\\n            We\'ve stopped auto-renewing your token due to inactivity. It will expire in\\n            "],[1,[28,[35,8],[[30,1]],null]],[1,"\\n            on\\n            "],[1,[28,[35,5],[[30,1],"MMMM do yyyy, h:mm:ss a O"],null]],[1,".\\n          "]],[]]]]],[1,"\\n          "],[8,[30,4,["Button"]],[[16,"disabled",[30,0,["renewToken","isRunning"]]],[4,[38,9],["click",[28,[37,10],[[30,0,["renewToken"]]],null]],null]],[["@text","@color","@icon","@iconPosition"],["Renew token","secondary",[52,[30,0,["renewToken","isRunning"]],"loading","reload"],"trailing"]],null],[1,"\\n          "],[8,[30,4,["LinkStandalone"]],null,[["@icon","@iconPosition","@color","@text","@route"],["arrow-right","trailing","secondary","Log out","vault.cluster.logout"]],null],[1,"\\n        "]],[4]]]]],[1,"\\n"]],[]],null],[1,"      "],[18,5,null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["@expirationDate","A","@allowingExpiration","A","&default"],false,["if","and","is-after","now","hds/alert","date-format","fn","mut","date-from-now","on","perform","yield"]]',moduleName:"vault/components/token-expire-warning.hbs",isStrictMode:!1})
let h=e.default=(s=class extends n.default{constructor(...e){super(...e),p(this,"auth",u,this),p(this,"router",c,this),p(this,"canDismiss",d,this)}handleRenew(){return new Promise((e=>{(0,r.later)((()=>{this.auth.renew().then((()=>{this.auth.setLastFetch(Date.now())})).finally((()=>{e()}))}),200)}))}*renewToken(){yield this.handleRenew()}get queryParams(){return{redirect_to:this.router.currentURL}}get showWarning(){return"vault.cluster.oidc-provider"!==this.router.currentRouteName&&!!this.args.expirationDate}},u=f(s.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(s.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(s.prototype,"canDismiss",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!0}}),f(s.prototype,"renewToken",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"renewToken"),s.prototype),s);(0,t.setComponentTemplate)(m,h)})),define("vault/components/tool-tip",["exports","core/components/tool-tip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-actions",["exports","core/components/toolbar-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-filters",["exports","core/components/toolbar-filters"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-link",["exports","core/components/toolbar-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-secret-link",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get glyph(){return"add"===this.args.type?"plus":"chevron-right"}}e.default=n}))
define("vault/components/toolbar",["exports","core/components/toolbar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/tools/hash",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v=(0,o.createTemplateFactory)({id:"FHzf1gya",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Hash Data\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["sum"]],[[[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[10,"label"],[14,"for","sum"],[14,0,"is-input"],[12],[1,"Sum"],[13],[1,"\\n      "],[8,[39,2],null,[["@textToCopy","@color","@onError"],[[30,0,["sum"]],"secondary",[28,[37,3],[[28,[37,4],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,5],[[4,[38,6],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Done","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,6],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,7],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","hash-input"],[14,0,"is-label"],[12],[1,"\\n          Input\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[11,"textarea"],[24,1,"hash-input"],[24,3,"hashData"],[16,2,[30,0,["hashData"]]],[24,0,"textarea"],[4,[38,6],["input",[30,0,["handleEvent"]]],null],[12],[13],[1,"\\n          "],[8,[39,8],null,[["@value","@isInput"],[[30,0,["hashData"]],false]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"field is-horizontal"],[12],[1,"\\n        "],[10,0],[14,0,"field-body"],[12],[1,"\\n          "],[10,0],[14,0,"field"],[12],[1,"\\n            "],[10,"label"],[14,"for","algorithm"],[14,0,"is-label"],[12],[1,"Algorithm"],[13],[1,"\\n            "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n              "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n                "],[11,"select"],[24,3,"algorithm"],[24,1,"algorithm"],[4,[38,6],["change",[30,0,["handleEvent"]]],null],[12],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[28,[37,11],null,null]],null]],null],null,[[[1,"                    "],[10,"option"],[15,"selected",[28,[37,12],[[30,0,["algorithm"]],[30,2]],null]],[15,2,[30,2]],[12],[1,"\\n                      "],[1,[30,2]],[1,"\\n                    "],[13],[1,"\\n"]],[2]],null],[1,"                "],[13],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"field"],[12],[1,"\\n            "],[10,"label"],[14,"for","format"],[14,0,"is-label"],[12],[1," Output format "],[13],[1,"\\n            "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n              "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n                "],[11,"select"],[24,3,"format"],[24,1,"format"],[4,[38,6],["change",[30,0,["handleEvent"]]],null],[12],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[28,[37,13],["base64","hex"],null]],null]],null],null,[[[1,"                    "],[10,"option"],[15,"selected",[28,[37,12],[[30,0,["format"]],[30,3]],null]],[15,2,[30,3]],[12],[1,"\\n                      "],[1,[30,3]],[1,"\\n                    "],[13],[1,"\\n"]],[3]],null],[1,"                "],[13],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,5],[[24,4,"submit"]],[["@text"],["Hash"]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p","algo","formatOption"],false,["page-header","if","hds/copy/snippet","fn","set-flash-message","hds/button","on","message-error","b64-toggle","each","-track-array","sha2-digest-sizes","eq","array"]]',moduleName:"vault/components/tools/hash.hbs",isStrictMode:!1})
let g=e.default=(s=class extends n.default{constructor(...e){super(...e),b(this,"store",u,this),b(this,"flashMessages",c,this),b(this,"algorithm",d,this),b(this,"format",p,this),b(this,"hashData",f,this),b(this,"sum",m,this),b(this,"errorMessage",h,this)}reset(){this.algorithm="sha2-256",this.format="base64",this.hashData="",this.sum=null,this.errorMessage=""}handleEvent(e){const{name:t,value:n}=e.target
this[t]=n}async handleSubmit(e){e.preventDefault()
const t={input:this.hashData,format:this.format,algorithm:this.algorithm}
try{const e=await this.store.adapterFor("tools").toolAction("hash",t)
this.sum=e.data.sum,this.flashMessages.success("Hash was successful.")}catch(n){this.errorMessage=(0,a.default)(n)}}},u=y(s.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=y(s.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(s.prototype,"algorithm",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"sha2-256"}}),p=y(s.prototype,"format",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"base64"}}),f=y(s.prototype,"hashData",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m=y(s.prototype,"sum",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=y(s.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(s.prototype,"reset",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"reset"),s.prototype),y(s.prototype,"handleEvent",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"handleEvent"),s.prototype),y(s.prototype,"handleSubmit",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSubmit"),s.prototype),s);(0,t.setComponentTemplate)(v,g)})),define("vault/components/tools/lookup",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","vault/utils/error-message","date-fns","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s){var u,c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,s.createTemplateFactory)({id:"kqr2UXGk",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Lookup Token\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["lookupData"]],[[[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n"],[42,[28,[37,3],[[30,0,["lookupData"]]],null],null,[[[44,[[52,[28,[37,5],[[30,3],"creation_ttl"],null],"Creation TTL",[28,[37,6],[[30,3]],null]]],[[[1,"        "],[8,[39,7],null,[["@label","@value"],[[30,4],[30,2]]],null],[1,"\\n"]],[4]]]],[2,3]],null],[41,[30,0,["expirationDate"]],[[[1,"      "],[8,[39,7],null,[["@label","@value"],["Expiration date",[30,0,["expirationDate"]]]],null],[1,"\\n      "],[8,[39,7],null,[["@label","@value"],["Expires in",[28,[37,8],[[30,0,["expirationDate"]]],null]]],null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,9],[[4,[38,10],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Done","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,10],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,11],null,[["@mode","@noun"],["perform","lookup"]],null],[1,"\\n      "],[8,[39,12],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","token"],[14,0,"is-label"],[12],[1,"Wrapped token"],[13],[1,"\\n        "],[10,0],[14,0,"has-text-grey is-size-8 has-bottom-margin-xs"],[12],[1,"\\n          Enter your wrapped token here to display its information.\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,13],[[24,0,"input"],[24,1,"token"],[24,3,"token"]],[["@value"],[[30,0,["token"]]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,9],[[24,4,"submit"]],[["@text"],["Lookup token"]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p","value","key","label"],false,["page-header","if","each","-each-in","let","eq","to-label","info-table-row","date-from-now","hds/button","on","namespace-reminder","message-error","input"]]',moduleName:"vault/components/tools/lookup.hbs",isStrictMode:!1})
let v=e.default=(u=class extends n.default{constructor(...e){super(...e),h(this,"store",c,this),h(this,"flashMessages",d,this),h(this,"token",p,this),h(this,"lookupData",f,this),h(this,"errorMessage",m,this)}reset(){this.token="",this.lookupData=null,this.errorMessage=""}get expirationDate(){const{creation_time:e,creation_ttl:t}=this.lookupData
return e&&t?(0,o.addSeconds)((0,o.parseISO)(e),t):null}async handleSubmit(e){e.preventDefault()
const t={token:this.token.trim()}
try{const e=await this.store.adapterFor("tools").toolAction("lookup",t)
this.lookupData=e.data,this.flashMessages.success("Lookup was successful.")}catch(n){this.errorMessage=(0,a.default)(n)}}},c=b(u.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(u.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(u.prototype,"token",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=b(u.prototype,"lookupData",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=b(u.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),b(u.prototype,"reset",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"reset"),u.prototype),b(u.prototype,"handleSubmit",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"handleSubmit"),u.prototype),u);(0,t.setComponentTemplate)(y,v)})),define("vault/components/tools/random",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,o.createTemplateFactory)({id:"CtxBUzTq",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Random Bytes\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["randomBytes"]],[[[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[10,"label"],[14,"for","rand"],[14,0,"is-label"],[12],[1,"Random bytes"],[13],[1,"\\n    "],[8,[39,2],null,[["@textToCopy","@color","@onError"],[[30,0,["randomBytes"]],"secondary",[28,[37,3],[[28,[37,4],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,5],[[4,[38,6],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Done","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,6],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,7],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[10,0],[14,0,"field is-horizontal"],[12],[1,"\\n        "],[10,0],[14,0,"field-body"],[12],[1,"\\n          "],[10,0],[14,0,"field"],[12],[1,"\\n            "],[10,"label"],[14,"for","bytes"],[14,0,"is-label"],[12],[1,"\\n              Number of bytes\\n            "],[13],[1,"\\n            "],[10,0],[14,0,"control"],[12],[1,"\\n              "],[8,[39,8],[[24,1,"bytes"],[24,0,"input"]],[["@value","@type"],[[30,0,["bytes"]],"number"]],null],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"field"],[12],[1,"\\n            "],[10,"label"],[14,"for","format"],[14,0,"is-label"],[12],[1,"\\n              Output format\\n            "],[13],[1,"\\n            "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n              "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n                "],[11,"select"],[24,3,"format"],[24,1,"format"],[4,[38,6],["input",[30,0,["handleSelect"]]],null],[12],[1,"\\n"],[42,[28,[37,10],[[28,[37,10],[[28,[37,11],["base64","hex"],null]],null]],null],null,[[[1,"                    "],[10,"option"],[15,"selected",[28,[37,12],[[30,0,["format"]],[30,2]],null]],[15,2,[30,2]],[12],[1,"\\n                      "],[1,[30,2]],[1,"\\n                    "],[13],[1,"\\n"]],[2]],null],[1,"                "],[13],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,5],[[24,4,"submit"]],[["@text"],["Generate"]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p","formatOption"],false,["page-header","if","hds/copy/snippet","fn","set-flash-message","hds/button","on","message-error","input","each","-track-array","array","eq"]]',moduleName:"vault/components/tools/random.hbs",isStrictMode:!1})
let v=e.default=(s=class extends n.default{constructor(...e){super(...e),h(this,"store",u,this),h(this,"flashMessages",c,this),h(this,"bytes",d,this),h(this,"format",p,this),h(this,"randomBytes",f,this),h(this,"errorMessage",m,this)}reset(){this.bytes=32,this.format="base64",this.randomBytes=null,this.errorMessage=""}handleSelect(e){const{value:t}=e.target
this.format=t}async handleSubmit(e){e.preventDefault()
const t={bytes:Number(this.bytes),format:this.format}
try{const e=await this.store.adapterFor("tools").toolAction("random",t)
this.randomBytes=e.data.random_bytes,this.flashMessages.success("Generated random bytes successfully.")}catch(n){this.errorMessage=(0,a.default)(n)}}},u=b(s.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(s.prototype,"bytes",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 32}}),p=b(s.prototype,"format",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"base64"}}),f=b(s.prototype,"randomBytes",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=b(s.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),b(s.prototype,"reset",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"reset"),s.prototype),b(s.prototype,"handleSelect",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSelect"),s.prototype),b(s.prototype,"handleSubmit",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSubmit"),s.prototype),s);(0,t.setComponentTemplate)(y,v)})),define("vault/components/tools/rewrap",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,o.createTemplateFactory)({id:"6o9I1/6U",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Rewrap Token\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["rewrappedToken"]],[[[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[10,"label"],[14,0,"is-label"],[12],[1,"Rewrapped token"],[13],[1,"\\n      "],[8,[39,2],null,[["@textToCopy","@color","@onError"],[[30,0,["rewrappedToken"]],"secondary",[28,[37,3],[[28,[37,4],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,5],[[4,[38,6],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Done","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,6],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,7],null,[["@mode","@noun"],["perform","rewrap"]],null],[1,"\\n      "],[8,[39,8],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","token"],[14,0,"is-label"],[12],[1,"Wrapped token"],[13],[1,"\\n        "],[10,0],[14,0,"has-text-grey is-size-8 has-bottom-margin-xs"],[12],[1,"\\n          Enter your wrapped token here to rewrap it and refresh its TTL.\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,9],[[24,0,"input"],[24,1,"token"],[24,3,"token"]],[["@value"],[[30,0,["originalToken"]]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,5],[[24,4,"submit"]],[["@text"],["Rewrap token"]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p"],false,["page-header","if","hds/copy/snippet","fn","set-flash-message","hds/button","on","namespace-reminder","message-error","input"]]',moduleName:"vault/components/tools/rewrap.hbs",isStrictMode:!1})
let y=e.default=(s=class extends n.default{constructor(...e){super(...e),m(this,"store",u,this),m(this,"flashMessages",c,this),m(this,"originalToken",d,this),m(this,"rewrappedToken",p,this),m(this,"errorMessage",f,this)}reset(){this.originalToken="",this.rewrappedToken="",this.errorMessage=""}async handleSubmit(e){e.preventDefault()
const t={token:this.originalToken.trim()}
try{const e=await this.store.adapterFor("tools").toolAction("rewrap",t)
this.rewrappedToken=e.wrap_info.token,this.flashMessages.success("Rewrap was successful.")}catch(n){this.errorMessage=(0,a.default)(n)}}},u=h(s.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(s.prototype,"originalToken",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=h(s.prototype,"rewrappedToken",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=h(s.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h(s.prototype,"reset",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"reset"),s.prototype),h(s.prototype,"handleSubmit",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSubmit"),s.prototype),s);(0,t.setComponentTemplate)(b,y)})),define("vault/components/tools/unwrap",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,o.createTemplateFactory)({id:"HG96NQtO",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Unwrap Data\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["unwrapData"]],[[[1,"  "],[8,[39,2],null,null,[["default"],[[[[1,"\\n    "],[8,[30,2,["Tab"]],null,null,[["default"],[[[[1,"Data"]],[]]]]],[1,"\\n    "],[8,[30,2,["Tab"]],null,null,[["default"],[[[[1,"Wrap Details"]],[]]]]],[1,"\\n    "],[8,[30,2,["Panel"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,3],[[24,0,"has-top-padding-m"]],[["@title","@value","@readOnly","@container"],["Unwrapped Data",[28,[37,4],[[30,0,["unwrapData"]]],null],true,".toolbar-actions"]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,2,["Panel"]],null,null,[["default"],[[[[1,"\\n      "],[10,0],[14,0,"has-top-padding-m"],[12],[1,"\\n"],[42,[28,[37,6],[[30,0,["unwrapDetails"]]],null],null,[[[1,"          "],[8,[39,7],null,[["@label","@value"],[[30,4],[30,3]]],null],[1,"\\n"]],[3,4]],null],[1,"      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[2]]]]],[1,"\\n  "],[8,[39,8],[[24,0,"has-top-padding-m"]],null,[["default"],[[[[1,"\\n    "],[8,[39,9],[[24,0,"primary"]],[["@text","@textToCopy","@onError"],["Copy unwrapped data",[28,[37,4],[[30,0,["unwrapData"]]],null],[28,[37,10],[[28,[37,11],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[8,[39,12],[[4,[38,13],["click",[30,0,["reset"]]],null]],[["@color","@text"],["secondary","Done"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,13],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,14],null,[["@mode","@noun"],["perform","unwrap"]],null],[1,"\\n      "],[8,[39,15],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","token"],[14,0,"is-label"],[12],[1,"Wrapped token"],[13],[1,"\\n        "],[10,0],[14,0,"has-text-grey is-size-8 has-bottom-margin-xs"],[12],[1,"\\n          Enter your wrapped token here to unwrap it and return its original value.\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,16],[[24,0,"input"],[24,1,"token"],[24,3,"token"],[24,"autocomplete","off"],[24,"spellcheck","false"]],[["@value"],[[30,0,["token"]]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,12],[[24,4,"submit"]],[["@text"],["Unwrap data"]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p","T","detail","key"],false,["page-header","if","hds/tabs","json-editor","stringify","each","-each-in","info-table-row","hds/button-set","hds/copy/button","fn","set-flash-message","hds/button","on","namespace-reminder","message-error","input"]]',moduleName:"vault/components/tools/unwrap.hbs",isStrictMode:!1})
let v=e.default=(s=class extends n.default{constructor(...e){super(...e),h(this,"store",u,this),h(this,"flashMessages",c,this),h(this,"token",d,this),h(this,"unwrapData",p,this),h(this,"unwrapDetails",f,this),h(this,"errorMessage",m,this)}reset(){this.token="",this.unwrapData="",this.unwrapDetails={},this.errorMessage=""}async handleSubmit(e){e.preventDefault()
const t={token:this.token.trim()}
try{const e=await this.store.adapterFor("tools").toolAction("unwrap",t)
this.unwrapData=e&&e.data||e.auth,this.unwrapDetails={"Request ID":e.request_id,"Lease ID":e.lease_id||"None",Renewable:e.renewable,"Lease Duration":e.lease_duration||"None"},this.flashMessages.success("Unwrap was successful.")}catch(n){this.errorMessage=(0,a.default)(n)}}},u=b(s.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(s.prototype,"token",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=b(s.prototype,"unwrapData",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=b(s.prototype,"unwrapDetails",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{}}}),m=b(s.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),b(s.prototype,"reset",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"reset"),s.prototype),b(s.prototype,"handleSubmit",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSubmit"),s.prototype),s);(0,t.setComponentTemplate)(y,v)})),define("vault/components/tools/wrap",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v=(0,o.createTemplateFactory)({id:"IZYzMFug",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Wrap Data\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["token"]],[[[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[10,"label"],[14,"for","wrap-info"],[14,0,"is-label"],[12],[1,"Wrapped token"],[13],[1,"\\n      "],[8,[39,2],null,[["@textToCopy","@color","@onError"],[[30,0,["token"]],"secondary",[28,[37,3],[[28,[37,4],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,5],null,null,[["default"],[[[[1,"\\n      "],[8,[39,6],[[4,[38,7],["click",[28,[37,3],[[30,0,["reset"]],false],null]],null]],[["@icon","@text","@color"],["arrow-left","Back","tertiary"]],null],[1,"\\n      "],[8,[39,6],[[4,[38,7],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Done","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,7],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,8],null,[["@mode","@noun"],["perform","wrap"]],null],[1,"\\n      "],[8,[39,9],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,10],null,[["@title","@subTitle","@value","@valueUpdated"],["Data to wrap","json-formatted",[30,0,["wrapData"]],[30,0,["codemirrorUpdated"]]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[8,[39,11],null,[["@label","@initialValue","@onChange","@helperTextDisabled","@helperTextEnabled","@changeOnInit"],["Wrap TTL","30m",[30,0,["updateTtl"]],"Vault will use the default (30m)","Wrap will expire after",true]],null],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,6],[[16,"disabled",[30,0,["buttonDisabled"]]],[24,4,"submit"]],[["@text"],["Wrap data"]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p"],false,["page-header","if","hds/copy/snippet","fn","set-flash-message","hds/button-set","hds/button","on","namespace-reminder","message-error","json-editor","ttl-picker"]]',moduleName:"vault/components/tools/wrap.hbs",isStrictMode:!1})
let g=e.default=(s=class extends n.default{constructor(...e){super(...e),b(this,"store",u,this),b(this,"flashMessages",c,this),b(this,"buttonDisabled",d,this),b(this,"token",p,this),b(this,"wrapTTL",f,this),b(this,"wrapData",m,this),b(this,"errorMessage",h,this)}reset(e=!0){this.token="",this.errorMessage="",this.wrapTTL=null,e&&(this.wrapData="{\n}")}updateTtl(e){e&&(this.wrapTTL=e.enabled?`${e.seconds}s`:"30m")}codemirrorUpdated(e,t){t.performLint()
const n=t?.state.lint.marked?.length>0
this.buttonDisabled=n,n||(this.wrapData=e)}async handleSubmit(e){e.preventDefault()
const t=JSON.parse(this.wrapData),n=this.wrapTTL||null
try{const e=await this.store.adapterFor("tools").toolAction("wrap",t,{wrapTTL:n})
this.token=e.wrap_info.token,this.flashMessages.success("Wrap was successful.")}catch(l){this.errorMessage=(0,a.default)(l)}}},u=y(s.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=y(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(s.prototype,"buttonDisabled",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p=y(s.prototype,"token",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=y(s.prototype,"wrapTTL",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=y(s.prototype,"wrapData",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"{\n}"}}),h=y(s.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(s.prototype,"reset",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"reset"),s.prototype),y(s.prototype,"updateTtl",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"updateTtl"),s.prototype),y(s.prototype,"codemirrorUpdated",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"codemirrorUpdated"),s.prototype),y(s.prototype,"handleSubmit",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSubmit"),s.prototype),s);(0,t.setComponentTemplate)(v,g)})),define("vault/components/transform-advanced-templating",["exports","@glimmer/component","@glimmer/tracking","@ember/object"],(function(e,t,n,l){var i,r
function a(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="inputOptions",i=this,(l=r)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}setInputOptions(e,t){t&&t.length?this.inputOptions=t.map((({position:e,value:t})=>({label:`${e}: ${t}`,value:e}))):this.inputOptions=[]}decodeFormatValueChange(e,t,n){(0,l.set)(e,"value",n),this.args.model.decodeFormats=t.toJSON()}},r=a(i.prototype,"inputOptions",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),a(i.prototype,"setInputOptions",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"setInputOptions"),i.prototype),a(i.prototype,"decodeFormatValueChange",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"decodeFormatValueChange"),i.prototype),i)})),define("vault/components/transform-create-form",["exports","vault/components/transformation-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/components/transform-edit-base",["exports","@ember/service","@ember/object/computed","@ember/utils","@ember/component","@ember/object","vault/mixins/focus-on-insert"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.removeFromList=e.default=e.addToList=void 0
e.addToList=(e,t)=>e&&Array.isArray(e)?(e.push(t),e.uniq()):e
e.removeFromList=(e,t)=>{if(!e)return e
const n=e.indexOf(t)
if(n<0)return e
return e.removeAt(n,1).uniq()}
e.default=i.default.extend(a.default,{store:(0,t.service)(),flashMessages:(0,t.service)(),router:(0,t.service)(),mode:null,onDataChange(){},onRefresh(){},model:null,requestInFlight:(0,n.or)("model.isLoading","model.isReloading","model.isSaving"),init(){this._super(...arguments),this.set("backendType","transform")},willDestroyElement(){this.model&&this.model.isError&&!this.model.isDestroyed&&!this.model.isDestroying&&this.model.rollbackAttributes(),this._super(...arguments)},transitionToRoute(){this.router.transitionTo(...arguments)},modelPrefixFromType(e){let t=""
return e&&e.startsWith("transform/")&&(t=`${e.replace("transform/","")}/`),t},listTabFromType(e){let t
return e&&e.startsWith("transform/")&&(t=`${e.replace("transform/","")}`),t},persist(e,t){const n=this.model
return n[e]().then((()=>{t(n)})).catch((e=>{throw n.set("displayErrors",e.errors),e}))},applyDelete(e=()=>{}){const t=this.listTabFromType(this.model.constructor.modelName)
this.persist("destroyRecord",(()=>{this.hasDataChanges(),e(),this.transitionToRoute("vault.cluster.secrets.backend.list-root",{queryParams:{tab:t}})}))},applyChanges(e,t=()=>{}){const n=this.model.id||this.model.name,i=this.modelPrefixFromType(this.model.constructor.modelName)
"create"===e&&(0,l.isBlank)(n)||this.persist("save",(()=>{this.hasDataChanges(),t(),this.transitionToRoute("vault.cluster.secrets.backend.show",`${i}${n}`)}))},hasDataChanges(){this.onDataChange(this.model?.hasDirtyAttributes)},actions:{createOrUpdate(e,t){t.preventDefault(),this.applyChanges(e)},setValue(e,t){(0,r.set)(this.model,e,t.target.checked)},refresh(){this.onRefresh()},delete(){this.applyDelete()}}})})),define("vault/components/transform-edit-form",["exports","vault/components/transformation-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/components/transform-role-edit",["exports","vault/components/transform-edit-base","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({flashMessages:(0,n.service)(),store:(0,n.service)(),initialTransformations:null,init(){this._super(...arguments),this.set("initialTransformations",this.model.transformations)},handleUpdateTransformations(e,n,l="update"){if(!e)return
const i=this.model.backend,r=e.map((e=>this.store.queryRecord("transform",{backend:i,id:e.id}).then((function(l){let r=l.allowed_roles
return"ADD"===e.action?r=(0,t.addToList)(r,n):"REMOVE"===e.action&&(r=(0,t.removeFromList)(r,n)),l.setProperties({backend:i,allowed_roles:r}),l.save().catch((t=>({errorStatus:t.httpStatus,...e})))}))))
Promise.all(r).then((e=>{if(e.find((e=>!!e.errorStatus))){const t=e.find((e=>403===e.errorStatus&&"ADD"===e.action)),n=e.find((e=>403===e.errorStatus&&"REMOVE"===e.action))
let i="The edits to this role were successful, but allowed_roles for its transformations was not edited due to a lack of permissions."
"create"===l?i="Transformations have been attached to this role, but the role was not added to those transformations’ allowed_roles due to a lack of permissions.":t&&n?i="This role was edited to both add and remove transformations; however, this role was not added or removed from those transformations’ allowed_roles due to a lack of permissions.":t?i="This role was edited to include new transformations, but this role was not added to those transformations’ allowed_roles due to a lack of permissions.":n&&(i="This role was edited to remove transformations, but this role was not removed from those transformations’ allowed_roles due to a lack of permissions."),this.flashMessages.info(i,{sticky:!0,priority:300})}}))},actions:{createOrUpdate(e,t){t.preventDefault(),this.applyChanges("save",(()=>{const t=this.model.id,n=this.model.transformations
if(!this.initialTransformations)return void this.handleUpdateTransformations(n.map((e=>({id:e,action:"ADD"}))),t,e)
const l=[...n,...this.initialTransformations].map((e=>this.initialTransformations.indexOf(e)<0?{id:e,action:"ADD"}:n.indexOf(e)<0?{id:e,action:"REMOVE"}:null)).filter((e=>!!e))
this.handleUpdateTransformations(l,t)}))},delete(){const e=this.model?.id,t=(this.model?.transformations||[]).map((e=>({id:e,action:"REMOVE"})))
this.handleUpdateTransformations(t,e),this.applyDelete()}}})})),define("vault/components/transform-show-transformation",["exports","vault/components/transform-edit-base","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({cliCommand:(0,n.computed)("model.{allowed_roles,type,tweak_source}",(function(){if(!this.model)return
const{type:e,allowed_roles:t,tweak_source:n,name:l}=this.model,i=t.find((e=>e.includes("*")))
let r="<choose a role>"
let a=""
return 1!==t.length||i||(r=t[0]),"fpe"===e&&"supplied"===n&&(a="tweak=<enter your tweak>"),`${r} value=<enter your value here> ${a} transformation=${l}`}))})})),define("vault/components/transform-template-edit",["exports","vault/components/transform-edit-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/components/transformation-edit",["exports","vault/components/transform-edit-base","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({flashMessages:(0,n.service)(),store:(0,n.service)(),initialRoles:null,init(){this._super(...arguments),this.model&&this.set("initialRoles",this.model.allowed_roles)},updateOrCreateRole(e,n,l){return this.store.queryRecord("transform/role",{backend:l,id:e.id}).then((i=>{let r=i.transformations
return"ADD"===e.action?r=(0,t.addToList)(r,n):"REMOVE"===e.action&&(r=(0,t.removeFromList)(r,n)),i.setProperties({backend:l,transformations:r}),i.save().catch((t=>({errorStatus:t.httpStatus,...e})))})).catch((t=>403!==t.httpStatus&&"ADD"===e.action?this.store.createRecord("transform/role",{id:e.id,name:e.id,transformations:[n],backend:l}).save().catch((t=>({errorStatus:t.httpStatus,...e,action:"CREATE"}))):{...e,errorStatus:t.httpStatus}))},handleUpdateRoles(e,t){if(!e)return
const n=this.model.backend,l=e.map((e=>this.updateOrCreateRole(e,t,n)))
Promise.all(l).then((e=>{if(e.find((e=>!!e.errorStatus))){let t="The edits to this transformation were successful, but transformations for its roles was not edited due to a lack of permissions."
e.find((e=>!!e.errorStatus&&403!==e.errorStatus))&&(t="You've edited the allowed_roles for this transformation. However, the corresponding edits to some roles' transformations were not made"),this.flashMessages.info(t,{sticky:!0,priority:300})}}))},isWildcard:e=>"string"==typeof e?e.indexOf("*")>=0:!(!e||!e.id)&&e.id.indexOf("*")>=0,actions:{createOrUpdate(e,t){t.preventDefault(),this.applyChanges("save",(()=>{const e=this.model.id||this.model.name,t=this.model.allowed_roles||[],n=this.initialRoles||[],l=[...t,...n].filter((e=>!this.isWildcard(e))).map((e=>n.indexOf(e)<0?{id:e,action:"ADD"}:t.indexOf(e)<0?{id:e,action:"REMOVE"}:null)).filter((e=>!!e))
this.handleUpdateRoles(l,e)}))}}})})),define("vault/components/transit-edit",["exports","@ember/service","@ember/object/computed","@ember/utils","@ember/component","ember-concurrency","@ember/object","vault/mixins/focus-on-insert","core/utils/key-codes"],(function(e,t,n,l,i,r,a,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u="vault.cluster.secrets.backend.list-root"
e.default=i.default.extend(o.default,{router:(0,t.service)(),mode:null,onDataChange(){},onRefresh(){},key:null,errorMessage:"",autoRotateInvalid:!1,requestInFlight:(0,n.or)("key.isLoading","key.isReloading","key.isSaving"),willDestroyElement(){this.key&&this.key.isError&&!this.key.isDestroyed&&!this.key.isDestroying&&this.key.rollbackAttributes(),this._super(...arguments)},get breadcrumbs(){const e=[{label:"Secrets",route:"vault.cluster.secrets"},{label:this.key.backend,route:"vault.cluster.secrets.backend.list-root",model:this.key.backend}]
return"show"===this.mode?[...e,{label:this.key.id}]:"edit"===this.mode?[...e,{label:this.key.id,route:"vault.cluster.secrets.backend.show",models:[this.key.backend,this.key.id],query:{tab:"details"}},{label:"Edit"}]:"create"===this.mode?[...e,{label:"Create"}]:e},waitForKeyUp:(0,r.task)((function*(){for(;;){const e=yield(0,r.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute(){this.router.transitionTo(...arguments)},onEscape(e){e.keyCode===s.default.ESC&&"show"===this.mode&&this.transitionToRoute(u)},hasDataChanges(){this.onDataChange(this.key.hasDirtyAttributes)},persistKey(e,t){const n=this.key
return n[e]().then((()=>{n.isError||t(n)}))},actions:{createOrUpdateKey(e,t){t.preventDefault(),(0,a.set)(this,"errorMessage","")
const n=this.key.id||this.key.name
"create"===e&&(0,l.isBlank)(n)?(0,a.set)(this,"errorMessage","Name is required."):this.persistKey("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",n,{queryParams:{tab:"details"}})}),"create"===e)},setValueOnKey(e,t){(0,a.set)(this.key,e,t.target.checked)},handleAutoRotateChange(e){e.enabled?((0,a.set)(this.key,"autoRotatePeriod",e.goSafeTimeString),this.set("autoRotateInvalid",e.seconds<3600)):(0,a.set)(this.key,"autoRotatePeriod",0)},derivedChange(e){this.key.setDerived(e)},convergentEncryptionChange(e){this.key.setConvergentEncryption(e)},refresh(){this.onRefresh()},deleteKey(){this.persistKey("destroyRecord",(()=>{this.hasDataChanges(),this.transitionToRoute(u)}))}}})})),define("vault/components/transit-form-show",["exports","@glimmer/component","@ember/service","@ember/object","@ember/test-waiters","vault/utils/error-message"],(function(e,t,n,l,i,r){var a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,i.buildWaiter)("transit-form-show")
e.default=(a=class extends t.default{constructor(...e){super(...e),c(this,"store",o,this),c(this,"router",s,this),c(this,"flashMessages",u,this)}async rotateKey(){const e=p.beginAsync(),{backend:t,id:n}=this.args.key
try{await this.store.adapterFor("transit-key").keyAction("rotate",{backend:t,id:n}),this.flashMessages.success("Key rotated."),await this.router.refresh()}catch(l){this.flashMessages.danger((0,r.default)(l))}finally{p.endAsync(e)}}},o=d(a.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(a.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(a.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d(a.prototype,"rotateKey",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"rotateKey"),a.prototype),a)})),define("vault/components/transit-key-action/export",["exports","@glimmer/component","@glimmer/tracking"],(function(e,t,n){var l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="exportVersion",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="exportVersion",o=[n.tracked],s={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/components/transit-key-actions",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@ember/debug","@glimmer/tracking","ember-concurrency","@ember/test-waiters","vault/utils/b64","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,l,i,r,a,o,s,u,c,d){var p,f,m,h,b,y,v
function g(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function w(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const k=(0,d.createTemplateFactory)({id:"JjA0u1kO",block:'[[[11,0],[4,[38,0],[[30,0,["updateProps"]],[30,1]],null],[12],[1,"\\n  "],[8,[39,1],null,[["@errorMessage"],[[30,0,["errors"]]]],null],[1,"\\n\\n"],[41,[28,[37,3],[[30,1],"encrypt"],null],[[[1,"    "],[8,[39,4],null,[["@key","@param","@context","@nonce","@bits","@key_version","@encodedBase64","@toggleEncodeBase64","@plaintext","@ciphertext","@doSubmit","@isModalActive"],[[30,2],[30,0,["props","param"]],[30,0,["props","context"]],[30,0,["props","nonce"]],[30,0,["props","bits"]],[30,0,["props","key_version"]],[30,0,["props","encodedBase64"]],[30,0,["toggleEncodeBase64"]],[30,0,["props","plaintext"]],[30,0,["props","ciphertext"]],[28,[37,5],[[30,0,["doSubmit"]]],null],[30,0,["isModalActive"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[30,1],"decrypt"],null],[[[1,"    "],[8,[39,6],null,[["@key","@ciphertext","@context","@nonce","@isModalActive","@plaintext","@doSubmit"],[[30,2],[30,0,["props","ciphertext"]],[30,0,["props","context"]],[30,0,["props","nonce"]],[30,0,["isModalActive"]],[30,0,["props","plaintext"]],[28,[37,5],[[30,0,["doSubmit"]]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[30,1],"datakey"],null],[[[1,"    "],[8,[39,7],null,[["@key","@param","@context","@nonce","@bits","@plaintext","@ciphertext","@doSubmit","@isModalActive"],[[30,2],[30,0,["props","param"]],[30,0,["props","context"]],[30,0,["props","nonce"]],[30,0,["props","bits"]],[30,0,["props","plaintext"]],[30,0,["props","ciphertext"]],[28,[37,5],[[30,0,["doSubmit"]]],null],[30,0,["isModalActive"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[30,1],"rewrap"],null],[[[1,"    "],[8,[39,8],null,[["@key","@param","@context","@nonce","@key_version","@ciphertext","@isModalActive","@doSubmit"],[[30,2],[30,0,["props","param"]],[30,0,["props","context"]],[30,0,["props","nonce"]],[30,0,["props","key_version"]],[30,0,["props","ciphertext"]],[30,0,["isModalActive"]],[28,[37,5],[[30,0,["doSubmit"]]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[30,1],"hmac"],null],[[[1,"    "],[8,[39,9],null,[["@key","@trackedInput","@algorithm","@key_version","@encodedBase64","@toggleEncodeBase64","@hmac","@isModalActive","@doSubmit"],[[30,2],[30,0,["props","input"]],[30,0,["props","algorithm"]],[30,0,["props","key_version"]],[30,0,["props","encodedBase64"]],[30,0,["toggleEncodeBase64"]],[30,0,["props","hmac"]],[30,0,["isModalActive"]],[28,[37,5],[[30,0,["doSubmit"]]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[30,1],"verify"],null],[[[1,"    "],[8,[39,10],null,[["@key","@trackedInput","@signature","@signature_algorithm","@hmac","@hash_algorithm","@context","@prehashed","@encodedBase64","@verification","@valid","@toggleEncodeBase64","@keyIsRSA","@isModalActive","@doSubmit","@submitIsRunning","@clearSpecificProps"],[[30,2],[30,0,["props","input"]],[30,0,["props","signature"]],[30,0,["props","signature_algorithm"]],[30,0,["props","hmac"]],[30,0,["props","hash_algorithm"]],[30,0,["props","context"]],[30,0,["props","prehashed"]],[30,0,["props","encodedBase64"]],[30,0,["props","verification"]],[30,0,["props","valid"]],[30,0,["toggleEncodeBase64"]],[30,0,["keyIsRSA"]],[30,0,["isModalActive"]],[28,[37,5],[[30,0,["doSubmit"]]],null],[30,0,["doSubmit","isRunning"]],[30,0,["clearSpecificProps"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[30,1],"sign"],null],[[[1,"    "],[8,[39,11],null,[["@key","@trackedInput","@hash_algorithm","@signature","@signature_algorithm","@key_version","@context","@prehashed","@encodedBase64","@toggleEncodeBase64","@isModalActive","@doSubmit","@submitIsRunning"],[[30,2],[30,0,["props","input"]],[30,0,["props","hash_algorithm"]],[30,0,["props","signature"]],[30,0,["props","signature_algorithm"]],[30,0,["props","key_version"]],[30,0,["props","context"]],[30,0,["props","prehashed"]],[30,0,["props","encodedBase64"]],[30,0,["toggleEncodeBase64"]],[30,0,["isModalActive"]],[28,[37,5],[[30,0,["doSubmit"]]],null],[30,0,["doSubmit","isRunning"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,12],[[28,[37,3],[[30,1],"export"],null],[28,[37,3],[[28,[37,13],[[30,2,["supportedActions"]],0],null],"export"],null]],null],[[[1,"    "],[8,[39,14],null,[["@key","@keys","@trackedInput","@hash_algorithm","@signature","@signature_algorithm","@key_version","@context","@prehashed","@encodedBase64","@exportKeyType","@exportKeyVersion","@wrappedToken","@wrappedTTL","@toggleEncodeBase64","@isModalActive","@doSubmit"],[[30,2],[30,0,["props","keys"]],[30,0,["props","input"]],[30,0,["props","hash_algorithm"]],[30,0,["props","signature"]],[30,0,["props","signature_algorithm"]],[30,0,["props","key_version"]],[30,0,["props","context"]],[30,0,["props","prehashed"]],[30,0,["props","encodedBase64"]],[30,0,["props","exportKeyType"]],[30,0,["props","exportKeyVersion"]],[30,0,["props","wrappedToken"]],[30,0,["props","wrappedTTL"]],[30,0,["toggleEncodeBase64"]],[30,0,["isModalActive"]],[28,[37,5],[[30,0,["doSubmit"]]],null]]],null],[1,"\\n  "]],[]],null]],[]]]],[]]]],[]]]],[]]]],[]]]],[]]]],[]]],[13]],["@selectedAction","@key"],false,["did-update","message-error","if","eq","transit-key-action/encrypt","perform","transit-key-action/decrypt","transit-key-action/datakey","transit-key-action/rewrap","transit-key-action/hmac","transit-key-action/verify","transit-key-action/sign","or","get","transit-key-action/export"]]',moduleName:"vault/components/transit-key-actions.hbs",isStrictMode:!1}),x={hash_algorithm:"sha2-256",algorithm:"sha2-256",signature_algorithm:"pss",bits:256,bytes:32,ciphertext:null,context:null,format:"base64",hmac:null,input:null,key_version:0,keys:null,nonce:null,param:"wrapped",prehashed:!1,plaintext:null,random_bytes:null,signature:null,sum:null,encodedBase64:!1,exportKeyType:null,exportKeyVersion:null,wrappedToken:null,wrappedTTL:"30m",valid:null,plaintextOriginal:null,didDecode:!1,verification:"Signature"},P={encrypt:["plaintext","context","nonce","key_version"],decrypt:["ciphertext","context","nonce"],sign:["input","hash_algorithm","key_version","prehashed","signature_algorithm"],verify:["input","hmac","signature","hash_algorithm","prehashed"],hmac:["input","algorithm","key_version"],rewrap:["ciphertext","context","nonce","key_version"],datakey:[]},_={sign:"Signed your data.",hmac:"Created your hash output.",encrypt:"Created a wrapped token for your data.",decrypt:"Decrypted the data from your token.",rewrap:"Created a new token for your data.",datakey:"Generated your key.",export:"Exported your key."}
let T=e.default=(p=class extends n.default{constructor(){super(...arguments),g(this,"store",f,this),g(this,"flashMessages",m,this),g(this,"router",h,this),g(this,"isModalActive",b,this),g(this,"errors",y,this),g(this,"props",v,this),"export"!==this.firstSupportedAction&&"export"!==this.args.selectedAction||(this.props.exportKeyType=this.args.key.exportKeyTypes[0],this.props.exportKeyVersion=this.args.key.validKeyVersions.lastObject)}get keyIsRSA(){const{type:e}=this.args.key
return"rsa-2048"===e||"rsa-3072"===e||"rsa-4096"===e}get firstSupportedAction(){return this.args.key.supportedActions[0]}handleSuccess(e,t,n){if(e&&e.data){if("export"===n&&e.data.keys){const{keys:t,type:n,name:l}=e.data
e.data.keys={keys:t,type:n,name:l}}this.props={...this.props,...e.data},"rewrap"!==n||this.args.key.supportsEncryption||(this.props.ciphertext=null)}t.wrapTTL&&(this.props={...this.props,wrappedToken:e.wrap_info.token}),this.isModalActive=!0,"verify"!==this.args.selectedAction&&this.flashMessages.success(_[n])}updateProps(){this.errors=null
const e=P[this.args.selectedAction]?.reduce(((e,t)=>({...e,[t]:this.props[t]})),{})
this.props={...x,...e}}compactData(e){return Object.keys(e).reduce(((t,n)=>"signature_algorithm"!==n||this.keyIsRSA?(e[n]&&(t[n]=e[n]),t):t),{})}toggleEncodeBase64(){this.props.encodedBase64=!this.props.encodedBase64}clearSpecificProps(e){e.forEach((e=>this.props[e]=null))}*doSubmit(e,t={},n){this.errors=null
const l="submit"===t.type?t:n
l&&l.preventDefault()
const{backend:i,id:r}=this.args.key,a=this.args.selectedAction||this.firstSupportedAction,{...o}=e||{}
this.props.encodedBase64||("encrypt"===a&&o.plaintext&&(o.plaintext=(0,u.encodeString)(o.plaintext)),"hmac"!==a&&"verify"!==a&&"sign"!==a||!o.input||(o.input=(0,u.encodeString)(o.input)))
const s=o?this.compactData(o):null
try{const e=yield this.store.adapterFor("transit-key").keyAction(a,{backend:i,id:r,payload:s},t)
this.handleSuccess(e,t,a)}catch(d){this.errors=(0,c.default)(d)}}},f=w(p.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=w(p.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=w(p.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=w(p.prototype,"isModalActive",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),y=w(p.prototype,"errors",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v=w(p.prototype,"props",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{...x}}}),w(p.prototype,"updateProps",[i.action],Object.getOwnPropertyDescriptor(p.prototype,"updateProps"),p.prototype),w(p.prototype,"toggleEncodeBase64",[i.action],Object.getOwnPropertyDescriptor(p.prototype,"toggleEncodeBase64"),p.prototype),w(p.prototype,"clearSpecificProps",[i.action],Object.getOwnPropertyDescriptor(p.prototype,"clearSpecificProps"),p.prototype),w(p.prototype,"doSubmit",[o.task,s.waitFor],Object.getOwnPropertyDescriptor(p.prototype,"doSubmit"),p.prototype),p);(0,t.setComponentTemplate)(k,T)})),define("vault/components/ttl-picker",["exports","core/components/ttl-picker"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/upgrade-page",["exports","core/components/upgrade-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/vault-logo-spinner",["exports","core/components/vault-logo-spinner"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/wrap-ttl",["exports","@ember/component","@ember/debug","@glimmer/component","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r,a){var o,s
function u(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,a.createTemplateFactory)({id:"IsdqWI96",block:'[[[10,0],[14,0,"field"],[12],[1,"\\n  "],[8,[39,0],null,[["@label","@helperTextDisabled","@helperTextEnabled","@initialEnabled","@initialValue","@onChange","@changeOnInit"],["Wrap response","Will not wrap response","Will wrap response with a lease of",true,"30m",[30,0,["changedValue"]],true]],null],[1,"\\n"],[13]],[],false,["ttl-picker"]]',moduleName:"vault/components/wrap-ttl.hbs",isStrictMode:!1})
let d=e.default=(o=class extends l.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="wrapResponse",l=this,(n=s)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get wrapTTL(){const{wrapResponse:e,ttl:t}=this
return e?t:null}changedValue(e){this.wrapResponse=e.enabled,this.ttl=e.goSafeTimeString,this.args.onChange(this.wrapTTL)}},s=u(o.prototype,"wrapResponse",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!0}}),u(o.prototype,"changedValue",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"changedValue"),o.prototype),o);(0,t.setComponentTemplate)(c,d)})),define("vault/components/z-docfy-filter",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,l,i,r){var a,o
function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,r.createTemplateFactory)({id:"Iq7NOj+O",block:'[[[8,[39,0],[[24,"placeholder","Filter components"],[4,[38,1],["input",[30,0,["filterComponents"]]],null]],[["@type"],["search"]],null],[1,"\\n\\n"],[8,[39,2],[[24,0,"docs-collapse-toggle has-top-padding-s"]],[["@text","@textWhenOpen","@isOpen"],["Expand component list","Collapse component list",true]],[["default"],[[[[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,0,["componentList"]]],null]],null],null,[[[1,"    "],[8,[39,5],[[24,0,"hds-side-nav__list-item-link docs-hover"]],[["@to"],[[30,1,["url"]]]],[["default"],[[[[1,"\\n      "],[1,[30,1,["title"]]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[1]],null]],[]]]]]],["component"],false,["hds/form/text-input/field","on","hds/reveal","each","-track-array","docfy-link"]]',moduleName:"vault/components/z-docfy-filter.hbs",isStrictMode:!1})
let c=e.default=(a=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="filterValue",i=this,(l=o)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}filterComponents({target:e}){this.filterValue=e.value}get componentList(){return this.filterValue?this.args.components.filter((e=>e.title.toLowerCase().includes(this.filterValue.toLowerCase()))):this.args.components}},o=s(a.prototype,"filterValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"filterComponents",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"filterComponents"),a.prototype),a);(0,t.setComponentTemplate)(u,c)})),define("vault/config/asset-manifest",["exports","require","vault/config/environment"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=n.default.modulePrefix,i=`${l}/config/asset-manifest`,r=`${l}/config/node-asset-manifest`
let a={}
try{if(t.default.has(r))a=(0,t.default)(r).default
else{const e=document.querySelector('meta[name="'+i+'"]').getAttribute("content")
a=JSON.parse(unescape(e))}}catch(o){throw new Error('Failed to load asset manifest. For browser environments, verify the meta tag with name "'+i+'" is present. For non-browser environments, verify that you included the node-asset-manifest module.')}e.default=a})),define("vault/container-debug-adapter",["exports","ember-resolver/container-debug-adapter"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/application",["exports","@ember/service","@ember/controller","vault/config/environment"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function u(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends n.default{constructor(...e){super(...e),o(this,"auth",r,this),o(this,"store",a,this),s(this,"env",l.default.environment)}},r=u(i.prototype,"auth",[t.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=u(i.prototype,"store",[t.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)})),define("vault/controllers/vault",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"queryParams",[{wrappedToken:"wrapped_token",redirectTo:"redirect_to"}]),n(this,"wrappedToken",""),n(this,"redirectTo","")}}e.default=l})),define("vault/controllers/vault/cluster",["exports","@ember/service","@ember/object/computed","@ember/controller","@ember/object"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({auth:(0,t.service)(),store:(0,t.service)(),media:(0,t.service)(),router:(0,t.service)(),permissions:(0,t.service)(),namespaceService:(0,t.service)("namespace"),flashMessages:(0,t.service)(),customMessages:(0,t.service)(),vaultVersion:(0,t.service)("version"),console:(0,t.service)(),queryParams:[{namespaceQueryParam:{scope:"controller",as:"namespace"}}],namespaceQueryParam:"",onQPChange:(0,i.observer)("namespaceQueryParam",(function(){this.namespaceService.setNamespace(this.namespaceQueryParam)})),consoleOpen:(0,n.alias)("console.isOpen"),activeCluster:(0,n.alias)("auth.activeCluster"),permissionBanner:(0,n.alias)("permissions.permissionsBanner"),actions:{toggleConsole(){this.toggleProperty("consoleOpen")}}})})),define("vault/controllers/vault/cluster/access/control-groups-configure",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({actions:{onSave({saveType:e}){"destroyRecord"===e&&this.send("reload")}}})}))
define("vault/controllers/vault/cluster/access/identity/aliases/add",["exports","vault/controllers/vault/cluster/access/identity/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({showRoute:"vault.cluster.access.identity.aliases.show"})})),define("vault/controllers/vault/cluster/access/identity/aliases/edit",["exports","vault/controllers/vault/cluster/access/identity/aliases/add"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/controllers/vault/cluster/access/identity/aliases/index",["exports","@ember/controller","core/mixins/list-controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(n.default,{get paginationQueryParams(){return e=>({page:e})},actions:{onDelete(){this.send("reload")}}})})),define("vault/controllers/vault/cluster/access/identity/create",["exports","@ember/controller","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),showRoute:"vault.cluster.access.identity.show",showTab:"details",actions:{navAfterSave({saveType:e,model:t}){const n="delete"===e,l=t.identityType
if(n){const e={"entity-alias":"vault.cluster.access.identity.aliases.index","group-alias":"vault.cluster.access.identity.aliases.index",group:"vault.cluster.access.identity.index",entity:"vault.cluster.access.identity.index"}[l]
this.router.transitionTo(e)}else this.router.transitionTo(this.showRoute,t.id,this.showTab)}}})})),define("vault/controllers/vault/cluster/access/identity/edit",["exports","vault/controllers/vault/cluster/access/identity/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/controllers/vault/cluster/access/identity/index",["exports","@ember/service","@ember/controller","core/mixins/list-controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend(l.default,{flashMessages:(0,t.service)(),entityToDisable:null,itemToDelete:null,get paginationQueryParams(){return e=>({page:e})},actions:{delete(e){const t=e.identityType,n=e.id
return e.destroyRecord().then((()=>{this.send("reload"),this.flashMessages.success(`Successfully deleted ${t}: ${n}`)})).catch((e=>{this.flashMessages.success(`There was a problem deleting ${t}: ${n} - ${e.errors.join(" ")||e.message}`)})).finally((()=>this.set("itemToDelete",null)))},toggleDisabled(e){const t=e.disabled?["enabled","enabling"]:["disabled","disabling"],n=e.identityType,l=e.id
e.toggleProperty("disabled"),e.save().then((()=>{this.flashMessages.success(`Successfully ${t[0]} ${n}: ${l}`)})).catch((e=>{this.flashMessages.success(`There was a problem ${t[1]} ${n}: ${l} - ${e.errors.join(" ")||e.message}`)})).finally((()=>this.set("entityToDisable",null)))},reloadRecord(e){e.reload()}}})})),define("vault/controllers/vault/cluster/access/identity/merge",["exports","vault/controllers/vault/cluster/access/identity/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/controllers/vault/cluster/access/leases/index",["exports","@ember/controller","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),actions:{lookupLease(e){this.router.transitionTo("vault.cluster.access.leases.show",e)}}})})),define("vault/controllers/vault/cluster/access/leases/list-root",["exports","vault/controllers/vault/cluster/access/leases/list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/access/leases/list",["exports","@ember/service","@ember/object","@ember/controller","core/mixins/list-controller","core/utils/key-utils"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend(i.default,{flashMessages:(0,t.service)(),router:(0,t.service)(),store:(0,t.service)(),clusterController:(0,l.inject)("vault.cluster"),get paginationQueryParams(){return e=>({page:e})},backendCrumb:(0,n.computed)("clusterController.model.name",(function(){return{label:"Leases",text:"Leases",path:"vault.cluster.access.leases.list-root",model:this.clusterController.model.name}})),isLoading:!1,filterIsFolder:(0,n.computed)("filter",(function(){return!!(0,r.keyIsFolder)(this.filter)})),emptyTitle:(0,n.computed)("baseKey.id","filter","filterIsFolder",(function(){const e=this.baseKey.id,t=this.filter
return""===e?"There are currently no leases.":this.filterIsFolder?t===e?`There are no leases under &quot;${t}&quot;.`:`We couldn't find a prefix matching &quot;${t}&quot;.`:""})),actions:{revokePrefix(e,t){const n=this.store.adapterFor("lease")
n[t?"forceRevokePrefix":"revokePrefix"].call(n,e).then((()=>this.router.transitionTo("vault.cluster.access.leases.list-root").then((()=>{this.flashMessages.success(`All of the leases under ${e} will be revoked.`)})))).catch((t=>{const n=t.errors.join(".")
this.flashMessages.danger(`There was an error attempting to revoke the prefix: ${e}. ${n}.`)}))}}})})),define("vault/controllers/vault/cluster/access/leases/show",["exports","@ember/runloop","@ember/service","@ember/object","@ember/controller"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({clusterController:(0,i.inject)("vault.cluster"),backendCrumb:(0,l.computed)("clusterController.model.name",(function(){return{label:"Leases",text:"Leases",path:"vault.cluster.access.leases.list-root",model:this.clusterController.model.name}})),flashMessages:(0,n.service)(),router:(0,n.service)(),actions:{revokeLease(e){return e.destroyRecord().then((()=>this.router.transitionTo("vault.cluster.access.leases.list-root")))},renewLease(e,n){const l=e.store.adapterFor("lease"),i=this.flashMessages
l.renew(e.id,n?.seconds).then((()=>{this.send("refreshModel"),(0,t.next)((()=>{i.success(`The lease ${e.id} was successfully renewed.`)}))})).catch((e=>{const t=e.errors.join(".")
i.danger(`There was an error renewing the lease: ${t}`)}))}}})})),define("vault/controllers/vault/cluster/access/method/item/list",["exports","@ember/controller","vault/mixins/list-controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(n.default,{})})),define("vault/controllers/vault/cluster/access/methods",["exports","@ember/controller","ember-concurrency","@ember/service","@ember/object","@glimmer/tracking","vault/utils/sort-objects"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function h(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(o=class extends t.default{constructor(...e){super(...e),f(this,"flashMessages",s,this),f(this,"authMethodOptions",u,this),f(this,"selectedAuthType",c,this),f(this,"selectedAuthName",d,this),f(this,"methodToDisable",p,this),m(this,"queryParams",["page, pageFilter"]),m(this,"page",1),m(this,"pageFilter",null),m(this,"filter",null),m(this,"sortMethods",(e=>(0,a.default)(e.slice(),"path")))}get authMethodList(){return this.selectedAuthType?this.selectedAuthName?this.model.filter((e=>this.selectedAuthName===e.id)):this.model.filter((e=>this.selectedAuthType===e.type)):this.selectedAuthName?this.model.filter((e=>this.selectedAuthName===e.id)):this.model}get authMethodArrayByType(){const e=this.authMethodList.map((e=>e.type))
return[...new Set(e)].map((e=>({name:e,id:e})))}get authMethodArrayByName(){return this.authMethodList.map((e=>({name:e.id,id:e.id})))}filterAuthType([e]){this.selectedAuthType=e}filterAuthName([e]){this.selectedAuthName=e}*disableMethod(e){const{type:t,path:n}=e
try{yield e.destroyRecord(),this.flashMessages.success(`The ${t} Auth Method at ${n} has been disabled.`)}catch(l){this.flashMessages.danger(`There was an error disabling Auth Method at ${n}: ${l.errors.join(" ")}.`)}finally{this.methodToDisable=null}}},s=h(o.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=h(o.prototype,"authMethodOptions",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),c=h(o.prototype,"selectedAuthType",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d=h(o.prototype,"selectedAuthName",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p=h(o.prototype,"methodToDisable",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h(o.prototype,"filterAuthType",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"filterAuthType"),o.prototype),h(o.prototype,"filterAuthName",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"filterAuthName"),o.prototype),h(o.prototype,"disableMethod",[n.dropTask],Object.getOwnPropertyDescriptor(o.prototype,"disableMethod"),o.prototype),o)})),define("vault/controllers/vault/cluster/access/mfa/enforcements/enforcement/index",["exports","@ember/controller","@glimmer/tracking","@ember/object","@ember/service"],(function(e,t,n,l,i){var r,a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){super(...e),c(this,"router",a,this),c(this,"flashMessages",o,this),d(this,"queryParams",["tab"]),d(this,"tab","targets"),c(this,"showDeleteConfirmation",s,this),c(this,"deleteError",u,this)}async delete(){try{await this.model.destroyRecord(),this.showDeleteConfirmation=!1,this.flashMessages.success("MFA login enforcement deleted successfully"),this.router.transitionTo("vault.cluster.access.mfa.enforcements")}catch(e){this.deleteError=e}}},a=p(r.prototype,"router",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=p(r.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"showDeleteConfirmation",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),u=p(r.prototype,"deleteError",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(r.prototype,"delete",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"delete"),r.prototype),r)})),define("vault/controllers/vault/cluster/access/mfa/enforcements/index",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"queryParams",["page"]),n(this,"page",1)}}e.default=l})),define("vault/controllers/vault/cluster/access/mfa/methods",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"queryParams",["page"]),n(this,"page",1)}}e.default=l})),define("vault/controllers/vault/cluster/access/mfa/methods/create",["exports","@ember/controller","@ember/service","@glimmer/tracking","@ember/object","@ember/string","ember-concurrency","vault/helpers/add-to-array"],(function(e,t,n,l,i,r,a,o){var s,u,c,d,p,f,m,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function w(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(s=class extends t.default{constructor(...e){super(...e),v(this,"store",u,this),v(this,"flashMessages",c,this),v(this,"router",d,this),g(this,"queryParams",["type"]),g(this,"methods",[{name:"TOTP",icon:"history"},{name:"Duo",icon:"duo"},{name:"Okta",icon:"okta-color"},{name:"PingID",icon:"pingid"}]),v(this,"type",p,this),v(this,"method",f,this),v(this,"enforcement",m,this),v(this,"enforcementPreference",h,this),v(this,"methodErrors",b,this),v(this,"enforcementErrors",y,this)}get description(){return"totp"===this.type?"Once set up, TOTP requires a passcode to be presented alongside a Vault token when invoking an API request.\n        The passcode will be validated against the TOTP key present in the identity of the caller in Vault.":`Once set up, the ${this.formattedType} MFA method will require a push confirmation on mobile before login.`}get formattedType(){return this.type?"totp"===this.type?this.type.toUpperCase():(0,r.capitalize)(this.type):""}get isTotp(){return"totp"===this.type}get showForms(){return this.type&&this.method}onTypeSelect(e){this.method=null,this.enforcement=null,this.methodErrors=null,this.enforcementErrors=null,this.enforcementPreference="new",this.type=e}createModels(){this.method&&this.method.unloadRecord(),this.enforcement&&this.enforcement.unloadRecord(),this.method=this.store.createRecord("mfa-method",{type:this.type}),this.enforcement=this.store.createRecord("mfa-login-enforcement")}onEnforcementPreferenceChange(e){"new"===e?this.enforcement=this.store.createRecord("mfa-login-enforcement"):this.enforcement&&(this.enforcement.unloadRecord(),this.enforcement=null),this.enforcementPreference=e}cancel(){this.method=null,this.enforcement=null,this.enforcementPreference=null,this.router.transitionTo("vault.cluster.access.mfa.methods")}*save(){if(this.checkValidityState())try{if(yield this.method.save(),this.enforcement){this.enforcement.mfa_methods=(0,o.addToArray)(this.enforcement.mfa_methods.slice(),this.method)
try{yield this.enforcement.save()}catch(e){this.handleError(e,"Error saving enforcement. You can still create an enforcement separately and add this method to it.")}}this.router.transitionTo("vault.cluster.access.mfa.methods.method",this.method.id)}catch(e){this.handleError(e,"Error saving method")}}checkValidityState(){let e=!0
const t=this.method.validate()
if(t.isValid||(this.methodErrors=t.state),"new"===this.enforcementPreference){const t=this.enforcement.validate(),{name:n,targets:l}=t.state
e=n.isValid&&l.isValid,t.isValid||(this.enforcementErrors=t.state)}return t.isValid&&e}handleError(e,t){const n=e?.errors?`${t}: ${e.errors.join(", ")}`:t
this.flashMessages.danger(n)}},u=w(s.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=w(s.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=w(s.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=w(s.prototype,"type",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=w(s.prototype,"method",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=w(s.prototype,"enforcement",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=w(s.prototype,"enforcementPreference",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"new"}}),b=w(s.prototype,"methodErrors",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=w(s.prototype,"enforcementErrors",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w(s.prototype,"onTypeSelect",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"onTypeSelect"),s.prototype),w(s.prototype,"createModels",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"createModels"),s.prototype),w(s.prototype,"onEnforcementPreferenceChange",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"onEnforcementPreferenceChange"),s.prototype),w(s.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),w(s.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),s)})),define("vault/controllers/vault/cluster/access/mfa/methods/method/index",["exports","@ember/controller","@ember/service","@ember/object"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function u(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){super(...e),o(this,"router",r,this),o(this,"flashMessages",a,this),s(this,"queryParams",["tab"]),s(this,"tab","config")}async deleteMethod(){try{await this.model.method.destroyRecord(),this.flashMessages.success("MFA method deleted successfully."),this.router.transitionTo("vault.cluster.access.mfa.methods")}catch(e){this.flashMessages.danger("There was an error deleting this MFA method.")}}},r=u(i.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=u(i.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(i.prototype,"deleteMethod",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"deleteMethod"),i.prototype),i)})),define("vault/controllers/vault/cluster/access/namespaces/create",["exports","@ember/service","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespaceService:(0,t.service)("namespace"),router:(0,t.service)(),actions:{onSave({saveType:e}){if("save"===e)return this.namespaceService.findNamespacesForUser.perform(),this.router.transitionTo("vault.cluster.access.namespaces.index")}}})})),define("vault/controllers/vault/cluster/access/namespaces/index",["exports","@ember/service","@ember/object/computed","@ember/controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({namespaceService:(0,t.service)("namespace"),accessibleNamespaces:(0,n.alias)("namespaceService.accessibleNamespaces"),currentNamespace:(0,n.alias)("namespaceService.path"),actions:{refreshNamespaceList(){this.namespaceService.findNamespacesForUser.perform(),this.send("reload")}}})})),define("vault/controllers/vault/cluster/access/oidc",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(){super(...arguments),o(this,"router",r,this),o(this,"header",a,this),this.router.on("routeDidChange",(e=>this.setHeader(e)))}setHeader(e){const t=e.to.name
if(t.includes("oidc.index"))this.header="cta"
else{const e=["clients","assignments","keys","scopes","providers"].find((e=>t.includes(`${e}.index`)))
this.header=e?"list":null}}get isCta(){return"cta"===this.header}},r=s(i.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"header",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),i)})),define("vault/controllers/vault/cluster/access/oidc/assignments/assignment/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){super(...e),o(this,"router",r,this),o(this,"flashMessages",a,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Assignment deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.assignments")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},r=s(i.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(i.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),i)})),define("vault/controllers/vault/cluster/access/oidc/clients/client",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(){super(...arguments),o(this,"router",r,this),o(this,"isEditRoute",a,this),this.router.on("routeDidChange",(({targetName:e})=>this.isEditRoute=!!e.includes("edit")))}get showHeader(){return!this.isEditRoute}},r=s(i.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"isEditRoute",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)})),define("vault/controllers/vault/cluster/access/oidc/clients/client/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){super(...e),o(this,"router",r,this),o(this,"flashMessages",a,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Application deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.clients")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},r=s(i.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(i.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),i)})),define("vault/controllers/vault/cluster/access/oidc/keys/key",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(){super(...arguments),o(this,"router",r,this),o(this,"isEditRoute",a,this),this.router.on("routeDidChange",(({targetName:e})=>this.isEditRoute=!!e.includes("edit")))}get showHeader(){return!this.isEditRoute}},r=s(i.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"isEditRoute",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)})),define("vault/controllers/vault/cluster/access/oidc/keys/key/details",["exports","@ember/controller","@ember/object","@ember/service","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,i,r){var a,o,s,u
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),c(this,"store",o,this),c(this,"router",s,this),c(this,"flashMessages",u,this)}*rotateKey(){const e=this.store.adapterFor("oidc/key")
yield e.rotate(this.model.name,this.model.verificationTtl).then((()=>{this.flashMessages.success(`Success: ${this.model.name} connection was rotated.`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Key deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.keys")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},o=d(a.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(a.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(a.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d(a.prototype,"rotateKey",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(a.prototype,"rotateKey"),a.prototype),d(a.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"delete"),a.prototype),a)})),define("vault/controllers/vault/cluster/access/oidc/providers/provider",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(){super(...arguments),o(this,"router",r,this),o(this,"isEditRoute",a,this),this.router.on("routeDidChange",(({targetName:e})=>this.isEditRoute=!!e.includes("edit")))}get showHeader(){return!this.isEditRoute}},r=s(i.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"isEditRoute",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)})),define("vault/controllers/vault/cluster/access/oidc/providers/provider/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){super(...e),o(this,"router",r,this),o(this,"flashMessages",a,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Provider deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.providers")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},r=s(i.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(i.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),i)})),define("vault/controllers/vault/cluster/access/oidc/scopes/scope/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){super(...e),o(this,"router",r,this),o(this,"flashMessages",a,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Scope deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.scopes")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},r=s(i.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(i.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),i)})),define("vault/controllers/vault/cluster/auth",["exports","@ember/service","@ember/object/computed","@ember/controller","ember-concurrency","core/utils/sanitize-path"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({vaultController:(0,l.inject)("vault"),clusterController:(0,l.inject)("vault.cluster"),flashMessages:(0,t.service)(),namespaceService:(0,t.service)("namespace"),flagsService:(0,t.service)("flags"),version:(0,t.service)(),auth:(0,t.service)(),router:(0,t.service)(),customMessages:(0,t.service)(),queryParams:[{authMethod:"with",oidcProvider:"o"}],namespaceQueryParam:(0,n.alias)("clusterController.namespaceQueryParam"),wrappedToken:(0,n.alias)("vaultController.wrappedToken"),redirectTo:(0,n.alias)("vaultController.redirectTo"),hvdManagedNamespaceRoot:(0,n.alias)("flagsService.hvdManagedNamespaceRoot"),authMethod:"",oidcProvider:"",fullNamespaceFromInput(e){const t=(0,r.sanitizePath)(e)
return this.hvdManagedNamespaceRoot?`${this.hvdManagedNamespaceRoot}/${t}`:t},updateNamespace:(0,i.task)((function*(e){yield(0,i.timeout)(500)
const t=this.fullNamespaceFromInput(e)
this.namespaceService.setNamespace(t,!0),this.customMessages.fetchMessages(t),this.set("namespaceQueryParam",t)})).restartable(),actions:{authSuccess({isRoot:e,namespace:t}){let n
this.version.fetchVersion(),this.redirectTo?(n=this.router.transitionTo(this.redirectTo),this.set("redirectTo","")):n=this.router.transitionTo("vault.cluster",{queryParams:{namespace:t}}),n.followRedirects().then((()=>{this.version.isEnterprise&&this.customMessages.fetchMessages(t),e&&(this.auth.set("isRootToken",!0),this.flashMessages.warning("You have logged in with a root token. As a security precaution, this root token will not be stored by your browser and you will need to re-authenticate after the window is closed or refreshed."))}))}}})}))
define("vault/controllers/vault/cluster/clients/counts",["exports","@ember/controller","@ember/object"],(function(e,t,n){var l
function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=["start_time","end_time","ns","mountPath"]
e.default=(l=class extends t.default{constructor(...e){super(...e),i(this,"queryParams",r),i(this,"start_time",void 0),i(this,"end_time",void 0),i(this,"ns",void 0),i(this,"mountPath",void 0)}updateQueryParams(e){e?Object.keys(e).forEach((t=>{if(r.includes(t)){const l=e[t];(0,n.set)(this,t,l)}})):this.queryParams.forEach((e=>this[e]=void 0))}},a=l.prototype,o="updateQueryParams",s=[n.action],u=Object.getOwnPropertyDescriptor(l.prototype,"updateQueryParams"),c=l.prototype,d={},Object.keys(u).forEach((function(e){d[e]=u[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=s.slice().reverse().reduce((function(e,t){return t(a,o,e)||e}),d),c&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(c):void 0,d.initializer=void 0),void 0===d.initializer&&Object.defineProperty(a,o,d),l)
var a,o,s,u,c,d})),define("vault/controllers/vault/cluster/clients/counts/acme",["exports","@ember/controller"],(function(e,t){var n,l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.inject)("vault.cluster.clients.counts"),l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="countsController",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="countsController",o=[n],s={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/controllers/vault/cluster/clients/counts/overview",["exports","@ember/controller"],(function(e,t){var n,l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.inject)("vault.cluster.clients.counts"),l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="countsController",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="countsController",o=[n],s={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/controllers/vault/cluster/clients/counts/sync",["exports","@ember/controller"],(function(e,t){var n,l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.inject)("vault.cluster.clients.counts"),l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="countsController",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="countsController",o=[n],s={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/controllers/vault/cluster/clients/counts/token",["exports","@ember/controller"],(function(e,t){var n,l,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.inject)("vault.cluster.clients.counts"),l=class extends t.default{constructor(...e){var t,n,l,r
super(...e),t=this,n="countsController",r=this,(l=i)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(r):void 0})}},r=l.prototype,a="countsController",o=[n],s={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(s).forEach((function(e){c[e]=s[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=o.slice().reverse().reduce((function(e,t){return t(r,a,e)||e}),c),u&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(u):void 0,c.initializer=void 0),i=void 0===c.initializer?(Object.defineProperty(r,a,c),null):c,l)
var r,a,o,s,u,c})),define("vault/controllers/vault/cluster/dashboard",["exports","@ember/controller","@ember/object","@glimmer/tracking","core/utils/timestamp"],(function(e,t,n,l,i){var r,a
function o(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="replicationUpdatedAt",i=this,(l=a)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}refreshModel(e){e&&e.preventDefault(),this.replicationUpdatedAt=i.default.now().toISOString(),this.send("refreshRoute")}},a=o(r.prototype,"replicationUpdatedAt",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return i.default.now().toISOString()}}),o(r.prototype,"refreshModel",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"refreshModel"),r.prototype),r)})),define("vault/controllers/vault/cluster/init",["exports","@ember/object","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l={keyData:null,secret_shares:null,secret_threshold:null,pgp_keys:null,use_pgp:!1,loading:!1}
e.default=n.default.extend(l,{reset(){this.setProperties(l)},initSuccess(e){this.set("loading",!1),this.set("keyData",e),this.model.reload()},initError(e){if(this.set("loading",!1),400!==e.httpStatus)throw e
this.set("errors",e.errors)},keyFilename:(0,t.computed)("model.name",(function(){return`vault-cluster-${this.model.name}`})),actions:{initCluster(e){const t=!!this.model.sealType&&"shamir"!==this.model.sealType
if(e.secret_shares){const n=parseInt(e.secret_shares,10)
e.secret_shares=n,t&&(e.stored_shares=1,e.recovery_shares=n,delete e.secret_shares)}if(e.secret_threshold){const n=parseInt(e.secret_threshold,10)
e.secret_threshold=n,t&&(e.recovery_threshold=n,delete e.secret_threshold)}e.use_pgp||delete e.pgp_keys,e.use_pgp&&t&&(e.recovery_pgp_keys=e.pgp_keys),e.use_pgp_for_root||delete e.root_token_pgp_key,delete e.use_pgp,delete e.use_pgp_for_root
const n=this.model.store
this.setProperties({loading:!0,errors:null}),n.adapterFor("cluster").initCluster(e).then((e=>this.initSuccess(e)),((...e)=>this.initError(...e)))},setKeys(e){this.set("pgp_keys",e)},setRootKey([e]){this.set("root_token_pgp_key",e)}}})})),define("vault/controllers/vault/cluster/mfa-setup",["exports","@ember/controller","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,i){var r,a,o,s,u,c
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=class extends t.default{constructor(...e){super(...e),d(this,"auth",a,this),d(this,"onStep",o,this),d(this,"warning",s,this),d(this,"uuid",u,this),d(this,"qrCode",c,this)}get entityId(){return this.auth.authData.entity_id}isUUIDVerified(e){this.warning="",e?this.onStep=2:this.restartFlow()}restartFlow(){this.onStep=1}saveUUIDandQrCode(e,t){this.uuid=e,this.qrCode=t}showWarning(e){this.warning=e,this.onStep=2}},a=p(r.prototype,"auth",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=p(r.prototype,"onStep",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 1}}),s=p(r.prototype,"warning",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),u=p(r.prototype,"uuid",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),c=p(r.prototype,"qrCode",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p(r.prototype,"isUUIDVerified",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"isUUIDVerified"),r.prototype),p(r.prototype,"restartFlow",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"restartFlow"),r.prototype),p(r.prototype,"saveUUIDandQrCode",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"saveUUIDandQrCode"),r.prototype),p(r.prototype,"showWarning",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"showWarning"),r.prototype),r)})),define("vault/controllers/vault/cluster/oidc-callback",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({queryParams:["state","code"],code:null,state:null})})),define("vault/controllers/vault/cluster/oidc-provider-ns",["exports","vault/controllers/vault/cluster/oidc-provider"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/controllers/vault/cluster/oidc-provider",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),n(this,"queryParams",["scope","response_type","client_id","redirect_uri","state","nonce","display","prompt","max_age","code_challenge","code_challenge_method","request","request_uri"]),n(this,"scope",null),n(this,"response_type",null),n(this,"client_id",null),n(this,"redirect_uri",null),n(this,"state",null),n(this,"nonce",null),n(this,"display",null),n(this,"prompt",null),n(this,"max_age",null),n(this,"code_challenge",null),n(this,"code_challenge_method",null),n(this,"request",null),n(this,"request_uri",null)}}e.default=l})),define("vault/controllers/vault/cluster/policies/index",["exports","@ember/service","@ember/object","@ember/controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({flashMessages:(0,t.service)(),queryParams:{page:"page",pageFilter:"pageFilter"},filter:null,page:1,pageFilter:null,filterFocused:!1,isLoading:!1,policyToDelete:null,get paginationQueryParams(){return e=>({page:e})},filterMatchesKey:(0,n.computed)("filter","model","model.[]",(function(){var e=this.filter,t=this.model
return!!(t&&t.length&&t.find((t=>t.id===e)))})),firstPartialMatch:(0,n.computed)("filter","model","model.[]","filterMatchesKey",(function(){var e=this.filter,t=this.model
if(t){var n=this.filterMatchesKey,l=new RegExp("^"+e)
return n?null:t.find((function(e){return l.test(e.id)}))}})),actions:{setFilter:function(e){this.set("filter",e)},setFilterFocus:function(e){this.set("filterFocused",e)},deletePolicy(e){const{policyType:t}=e,n=e.id,l=this.flashMessages
e.destroyRecord().then((()=>{this.send("reload"),l.success(`${t.toUpperCase()} policy "${n}" was successfully deleted.`)})).catch((e=>{const i=e.errors?e.errors.join(""):e.message
l.danger(`There was an error deleting the ${t.toUpperCase()} policy "${n}": ${i}.`)})).finally((()=>this.set("policyToDelete",null)))}}})})),define("vault/controllers/vault/cluster/policy/edit",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var i,r,a
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=class extends t.default{constructor(...e){super(...e),o(this,"router",r,this),o(this,"flashMessages",a,this)}async deletePolicy(){const{policyType:e,name:t}=this.model
try{await this.model.destroyRecord(),this.flashMessages.success(`${e.toUpperCase()} policy "${t}" was successfully deleted.`),this.router.transitionTo("vault.cluster.policies",e)}catch(n){this.model.rollbackAttributes()
const l=n.errors?n.errors.join(". "):n.message,i=`There was an error deleting the ${e.toUpperCase()} policy "${t}": ${l}.`
this.flashMessages.danger(i)}}},r=s(i.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a=s(i.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(i.prototype,"deletePolicy",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"deletePolicy"),i.prototype),i)})),define("vault/controllers/vault/cluster/replication-dr-promote/index",["exports","@ember/controller","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),queryParams:["action"],action:"",actions:{onPromote(){this.router.transitionTo("vault.cluster.replication.mode.index","dr")}}})})),define("vault/controllers/vault/cluster/secrets/backend",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({preferAdvancedEdit:!1})})),define("vault/controllers/vault/cluster/secrets/backend/actions-root",["exports","vault/controllers/vault/cluster/secrets/backend/actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/actions",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(n.default,{queryParams:{selectedAction:"action"},actions:{refresh:function(){this.send("refreshModel")}}})})),define("vault/controllers/vault/cluster/secrets/backend/configuration/edit",["exports","@ember/utils","@ember/service","@ember/controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i={configured:!1,iamEndpoint:null,stsEndpoint:null,accessKey:null,secretKey:null,region:""}
e.default=l.default.extend(i,{queryParams:["tab"],tab:"",flashMessages:(0,n.service)(),loading:!1,reset(){this.model.rollbackAttributes(),this.setProperties(i)},actions:{save(e,n){this.set("loading",!0)
Object.keys(n).some((e=>(0,t.isPresent)(n[e])))&&this.model.save({adapterOptions:{adapterMethod:e,data:n}}).then((()=>{this.reset(),this.flashMessages.success("The backend configuration saved successfully!")})).finally((()=>{this.set("loading",!1)}))}}})})),define("vault/controllers/vault/cluster/secrets/backend/create-root",["exports","vault/controllers/vault/cluster/secrets/backend/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/create",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(n.default,{backendController:(0,t.inject)("vault.cluster.secrets.backend"),queryParams:["initialKey","itemType"],initialKey:"",itemType:"",actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit(e){this.set("preferAdvancedEdit",e),this.backendController.set("preferAdvancedEdit",e)}}})})),define("vault/controllers/vault/cluster/secrets/backend/credentials-root",["exports","vault/controllers/vault/cluster/secrets/backend/credentials"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/credentials",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({queryParams:["roleType"],roleType:"",reset(){this.set("roleType","")}})})),define("vault/controllers/vault/cluster/secrets/backend/edit-root",["exports","vault/controllers/vault/cluster/secrets/backend/edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/edit",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(n.default,{backendController:(0,t.inject)("vault.cluster.secrets.backend"),queryParams:["version","itemType"],version:"",itemType:"",reset(){this.set("version",""),this.set("itemType","")},actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit(e){this.set("preferAdvancedEdit",e),this.backendController.set("preferAdvancedEdit",e)}}})})),define("vault/controllers/vault/cluster/secrets/backend/list-root",["exports","vault/controllers/vault/cluster/secrets/backend/list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/list",["exports","@ember/object/computed","@ember/object","@ember/service","@ember/controller","vault/mixins/backend-crumb","core/mixins/list-controller","core/utils/key-utils"],(function(e,t,n,l,i,r,a,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend(a.default,r.default,{flashMessages:(0,l.service)(),queryParams:["page","pageFilter","tab"],tab:"",get paginationQueryParams(){return e=>({page:e})},filterIsFolder:(0,n.computed)("filter",(function(){return!!(0,o.keyIsFolder)(this.filter)})),isConfigurableTab:(0,t.or)("isCertTab","isConfigure"),actions:{chooseAction(e){this.set("selectedAction",e)},toggleZeroAddress(e,t){e.toggleProperty("zeroAddress"),this.set("loading-"+e.id,!0),t.saveZeroAddressConfig().catch((t=>{e.set("zeroAddress",!1),this.flashMessages.danger(t.message)})).finally((()=>{this.set("loading-"+e.id,!1)}))},delete(e){const t=e.id
e.destroyRecord().then((()=>{this.flashMessages.success(`${t} was successfully deleted.`),this.send("reload")})).catch((e=>{const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}))}}})})),define("vault/controllers/vault/cluster/secrets/backend/show-root",["exports","vault/controllers/vault/cluster/secrets/backend/show"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/show",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(n.default,{backendController:(0,t.inject)("vault.cluster.secrets.backend"),queryParams:["tab","version","type","itemType","page"],version:"",tab:"",type:"",itemType:"",reset(){this.set("tab",""),this.set("version",""),this.set("type",""),this.set("itemType","")},actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit(e){this.set("preferAdvancedEdit",e),this.backendController.set("preferAdvancedEdit",e)}}})})),define("vault/controllers/vault/cluster/secrets/backend/sign-root",["exports","vault/controllers/vault/cluster/secrets/backend/sign"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/sign",["exports","@ember/service","@ember/controller","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({store:(0,t.service)(),loading:!1,emptyData:"{\n}",actions:{sign(){this.set("loading",!0),this.model.save().finally((()=>{this.set("loading",!1)}))},codemirrorUpdated(e,t,n){n.performLint()
n.state.lint.marked.length>0||(0,l.set)(this.model,e,JSON.parse(t))},updateTtl(e,t){const n=this.model,i=!0===t.enabled?`${t.seconds}s`:void 0;(0,l.set)(n,e,i)},newModel(){const e=this.model,t=e.role
e.unloadRecord()
const n=this.store.createRecord("ssh-sign",{role:t,id:`${t.backend}-${t.name}`})
this.set("model",n)}}})}))
define("vault/controllers/vault/cluster/secrets/backends",["exports","@ember/controller","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency"],(function(e,t,n,l,i,r){var a,o,s,u,c,d
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=class extends t.default{constructor(...e){super(...e),p(this,"flashMessages",o,this),p(this,"secretEngineOptions",s,this),p(this,"selectedEngineType",u,this),p(this,"selectedEngineName",c,this),p(this,"engineToDisable",d,this)}get displayableBackends(){return this.model.filter((e=>e.shouldIncludeInList))}get sortedDisplayableBackends(){const e=this.displayableBackends.sort(((e,t)=>t.isSupportedBackend-e.isSupportedBackend||e.id-t.id))
return this.selectedEngineType?this.selectedEngineName?e.filter((e=>this.selectedEngineName===e.id)):e.filter((e=>this.selectedEngineType===e.engineType)):this.selectedEngineName?e.filter((e=>this.selectedEngineName===e.id)):e}get secretEngineArrayByType(){const e=this.sortedDisplayableBackends.map((e=>e.engineType))
return[...new Set(e)].map((e=>({name:e,id:e})))}get secretEngineArrayByName(){return this.sortedDisplayableBackends.map((e=>({name:e.id,id:e.id})))}filterEngineType([e]){this.selectedEngineType=e}filterEngineName([e]){this.selectedEngineName=e}*disableEngine(e){const{engineType:t,path:n}=e
try{yield e.destroyRecord(),this.flashMessages.success(`The ${t} Secrets Engine at ${n} has been disabled.`)}catch(l){this.flashMessages.danger(`There was an error disabling the ${t} Secrets Engine at ${n}: ${l.errors.join(" ")}.`)}finally{this.engineToDisable=null}}},o=f(a.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=f(a.prototype,"secretEngineOptions",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),u=f(a.prototype,"selectedEngineType",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c=f(a.prototype,"selectedEngineName",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d=f(a.prototype,"engineToDisable",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f(a.prototype,"filterEngineType",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"filterEngineType"),a.prototype),f(a.prototype,"filterEngineName",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"filterEngineName"),a.prototype),f(a.prototype,"disableEngine",[r.dropTask],Object.getOwnPropertyDescriptor(a.prototype,"disableEngine"),a.prototype),a)})),define("vault/controllers/vault/cluster/settings",["exports","@ember/service","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespaceService:(0,t.service)("namespace")})})),define("vault/controllers/vault/cluster/settings/auth/enable",["exports","@ember/controller","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),actions:{onMountSuccess:function(e,t){return this.router.transitionTo("vault.cluster.settings.auth.configure",t).followRedirects()}}})})),define("vault/controllers/vault/cluster/settings/mount-secret-backend",["exports","@ember/service","@ember/controller","vault/helpers/supported-secret-backends","vault/helpers/mountable-secret-engines","@ember/object"],(function(e,t,n,l,i,r){var a,o
function s(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,l.supportedSecretBackends)()
e.default=(a=class extends n.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="router",i=this,(l=o)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}onMountSuccess(e,t,n=!1){let l
if(u.includes(e)){const r=(0,i.allEngines)().find((t=>t.type===e))
if(n)l=this.router.transitionTo(`vault.cluster.secrets.backend.${r.engineRoute}`,t)
else{const e=r?.routeQueryParams||{}
l=this.router.transitionTo("vault.cluster.secrets.backend.index",t,{queryParams:e})}}else l=this.router.transitionTo("vault.cluster.secrets.backends")
return l.followRedirects()}},o=s(a.prototype,"router",[t.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"onMountSuccess",[r.action],Object.getOwnPropertyDescriptor(a.prototype,"onMountSuccess"),a.prototype),a)})),define("vault/controllers/vault/cluster/settings/seal",["exports","@ember/service","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({auth:(0,t.service)(),router:(0,t.service)(),version:(0,t.service)(),store:(0,t.service)(),actions:{seal(){return this.model.cluster.store.adapterFor("cluster").seal().then((()=>(this.store.peekAll("cluster")[0].reload(),this.auth.deleteCurrentToken(),this.version.version=null,this.router.transitionTo("vault.cluster.unseal"))))}}})})),define("vault/controllers/vault/cluster/unseal",["exports","@ember/controller","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({router:(0,n.service)(),showLicenseError:!1,actions:{reloadCluster(){return this.model.reload()},isUnsealed:e=>!1===e.sealed,handleLicenseError(){this.set("showLicenseError",!0)}}})})),define("vault/data-adapter",["exports","@ember-data/debug"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/decorators/confirm-leave",["exports","core/decorators/confirm-leave"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"withConfirmLeave",{enumerable:!0,get:function(){return t.withConfirmLeave}})})),define("vault/decorators/model-expanded-attributes",["exports","vault/utils/field-to-attrs","@ember-data/model","@ember/debug"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.withExpandedAttributes=function(){return function(e){return Object.prototype.isPrototypeOf.call(n.default,e)?class extends e{constructor(...e){var t,n,l
super(...e),t=this,l=null,(n=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(n="_allByKey"))in t?Object.defineProperty(t,n,{value:l,enumerable:!0,configurable:!0,writable:!0}):t[n]=l}_expandGroups(e){if(!Array.isArray(e))throw new Error("_expandGroups expects an array of objects")
return e.map((e=>{const[t,n]=Object.entries(e)[0],i=n.map((e=>this.allByKey[e])).filter((e=>!!e))
return i.length!==n.length&&(0,l.debug)(`not all model fields found in allByKey for group "${t}"`),{[t]:i}}))}get allByKey(){if(!this._allByKey){const e={},n=[]
this.eachAttribute((function(e){n.push(e)}));(0,t.expandAttributeMeta)(this,n).forEach((t=>{e[t.name]=t})),this.eachRelationship((function(n,l){if("belongsTo"!==l.kind)return
const i=this[n],r=[]
i.eachAttribute((function(e){r.push(e)}));(0,t.expandAttributeMeta)(i,r).forEach((t=>{e[`${n}.${t.name}`]={...t,options:{...t.options,fieldValue:`${n}.${t.fieldValue||t.name}`}}}))}),this),this._allByKey=e}return this._allByKey}}:(console.error("withExpandedAttributes decorator must be used on instance of ember-data Model class. Decorator not applied to returned class"),e)}}})),define("vault/decorators/model-form-fields",["exports","vault/utils/field-to-attrs","@ember-data/model"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.withFormFields=function(e,l){return function(i){return Object.prototype.isPrototypeOf.call(n.default,i)?class extends i{constructor(){super(...arguments),e&&(this.formFields=(0,t.expandAttributeMeta)(this,e)),l&&(this.formFieldGroups=(0,t.default)(this,l))
const n=[]
this.eachAttribute((function(e){n.push(e)})),this.allFields=(0,t.expandAttributeMeta)(this,n)}}:(console.error("withFormFields decorator must be used on instance of ember-data Model class. Decorator not applied to returned class"),i)}}})),define("vault/decorators/model-validations",["exports","vault/utils/validators","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.withModelValidations=function(e){return function(l){var i,r,a,o
return i=class extends l{constructor(){if(super(...arguments),!e||"object"!=typeof e)throw new Error("Validations object must be provided to constructor for setup")
this._validations=e}validate(){let e=!0
const l={}
let i=0
for(const r in this._validations){const a=this._validations[r]
if(Array.isArray(a)){l[r]={errors:[],warnings:[]}
for(const i of a){const{type:a,options:o,level:s,message:u,validator:c}=i,d="function"==typeof c,p=d?c:t.default[a]
if(!p){console.error(a?`Validator type: "${a}" not found. Available validators: ${Object.keys(t.default).join(", ")}`:'Validator not found. Define either type or pass custom validator function under "validator" key in validations object')
continue}if(!(d?p(this):p((0,n.get)(this,r),o))){const t="function"==typeof u?u(this):u
"warn"===s?l[r].warnings.push(t):(l[r].errors.push(t),e&&(e=!1))}}i+=l[r].errors.length,l[r].isValid=!l[r].errors.length}else console.error(`Must provide validations as an array for property "${r}" on ${this.modelName} model`)}return{isValid:e,state:l,invalidFormMessage:this.generateErrorCountMessage(i)}}generateErrorCountMessage(e){if(e<1)return null
const t=e>1&&`are ${e} errors`
return`There ${t||"is an error"} with this form.`}},r=i,o=void 0,(a=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(a="_validations"))in r?Object.defineProperty(r,a,{value:o,enumerable:!0,configurable:!0,writable:!0}):r[a]=o,i}}})),define("vault/docfy-output",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={nested:{name:"/",label:"/",pages:[],children:[{name:"docs",label:"docs",pages:[{url:"/docs/",title:"Index",editUrl:"",relativeUrl:"",relativePath:"index.md",headings:[],frontmatter:{title:"Index",order:-1},pluginData:{},parentLabel:"docs"},{url:"/docs/how-to-docfy",title:"How to docfy",editUrl:"",relativeUrl:"how-to-docfy",relativePath:"how-to-docfy.md",headings:[{title:"docs/ markdown files",id:"docs-markdown-files",depth:2},{title:"generating component docs",id:"generating-component-docs",depth:2},{title:"Writing documentation for a component",id:"writing-documentation-for-a-component",depth:2,headings:[{title:"Syntax tips",id:"syntax-tips",depth:3},{title:"Config",id:"config",depth:3},{title:"More info",id:"more-info",depth:3}]}],frontmatter:{title:"How to docfy",order:1},pluginData:{},parentLabel:"docs"},{url:"/docs/building-components",title:"Building and consuming components",editUrl:"",relativeUrl:"building-components",relativePath:"building-components.md",headings:[{title:"Page components for every route",id:"page-components-for-every-route",depth:2},{title:"Conditional rendering",id:"conditional-rendering",depth:2},{title:"Reusable components",id:"reusable-components",depth:2}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/client-pagination",title:"Client-side pagination",editUrl:"",relativeUrl:"client-pagination",relativePath:"client-pagination.md",headings:[{title:"Using pagination",id:"using-pagination",depth:2,headings:[{title:"Before",id:"before",depth:3},{title:"After",id:"after",depth:3},{title:"Serializing",id:"serializing",depth:3}]},{title:"Gotchas",id:"gotchas",depth:2},{title:"How it works",id:"how-it-works",depth:2}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/css",title:"CSS/SCSS",editUrl:"",relativeUrl:"css",relativePath:"css.md",headings:[{title:"Guidelines",id:"guidelines",depth:2,headings:[{title:"Known issues",id:"known-issues",depth:3},{title:"Helper classes",id:"helper-classes",depth:3},{title:"Core class styles",id:"core-class-styles",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/ember-engines",title:"Ember Engines",editUrl:"",relativeUrl:"ember-engines",relativePath:"ember-engines.md",headings:[{title:"Create a new in-repo engine:",id:"create-a-new-in-repo-engine",depth:2},{title:"Engine’s package.json:",id:"engines-packagejson",depth:2},{title:"Configure your Engine",id:"configure-your-engine",depth:2,headings:[{title:"Service Dependencies:",id:"service-dependencies",depth:3,headings:[{title:"Notes:",id:"notes",depth:4}]},{title:"External Route Dependencies:",id:"external-route-dependencies",depth:3,headings:[{title:"Notes:",id:"notes-1",depth:4}]}]},{title:"Additional info about your engine's application.hbs:",id:"additional-info-about-your-engines-applicationhbs",depth:2},{title:"Register your engine with our main application:",id:"register-your-engine-with-our-main-application",depth:2},{title:"Add engine path to ember-addon section of main app package.json",id:"add-engine-path-to-ember-addon-section-of-main-app-packagejson",depth:2,headings:[{title:"Important Notes:",id:"important-notes",depth:3},{title:"Common blueprint commands:",id:"common-blueprint-commands",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/fetch-secrets-engine-config",title:"Fetch Secrets Engine Configuration Decorator",editUrl:"",relativeUrl:"fetch-secrets-engine-config",relativePath:"fetch-secrets-engine-config.md",headings:[{title:"API",id:"api",depth:2},{title:"Usage",id:"usage",depth:2,headings:[{title:"Configure route",id:"configure-route",depth:3},{title:"Configuration route",id:"configuration-route",depth:3},{title:"Other routes (overview etc.)",id:"other-routes-overview-etc",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/forms",title:"Forms",editUrl:"",relativeUrl:"forms",relativePath:"forms.md",headings:[{title:"Guidelines",id:"guidelines",depth:2}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/model-validations",title:"Model Validations Decorator",editUrl:"",relativeUrl:"model-validations",relativePath:"model-validations.md",headings:[{title:"API",id:"api",depth:2},{title:"Usage",id:"usage",depth:2},{title:"Examples",id:"examples",depth:2,headings:[{title:"Basic",id:"basic",depth:3},{title:"Custom validator",id:"custom-validator",depth:3},{title:"Adding class in template based on validation state",id:"adding-class-in-template-based-on-validation-state",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/models",title:"Models",editUrl:"",relativeUrl:"models",relativePath:"models.md",headings:[{title:"Capabilities",id:"capabilities",depth:2},{title:"Decorators",id:"decorators",depth:2,headings:[{title:"@withFormFields()",id:"withformfields",depth:3},{title:"@withModelValidations()",id:"withmodelvalidations",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/routing",title:"Routing",editUrl:"",relativeUrl:"routing",relativePath:"routing.md",headings:[{title:"Guidelines",id:"guidelines",depth:2},{title:"File structure",id:"file-structure",depth:2},{title:"Shared functionality",id:"shared-functionality",depth:2},{title:"Decorators",id:"decorators",depth:2,headings:[{title:"@withConfirmLeave()",id:"withconfirmleave",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/serializers-adapters",title:"Serializers & Adapters",editUrl:"",relativeUrl:"serializers-adapters",relativePath:"serializers-adapters.md",headings:[{title:"Guidelines",id:"guidelines",depth:2},{title:"Gotchas",id:"gotchas",depth:2}],frontmatter:{},pluginData:{},parentLabel:"docs"},{url:"/docs/tests",title:"Test Helpers Organization",editUrl:"",relativeUrl:"tests",relativePath:"tests.md",headings:[{title:"Folder organization",id:"folder-organization",depth:2,headings:[{title:"/acceptance",id:"acceptance",depth:3},{title:"/helpers",id:"helpers",depth:3},{title:"integration",id:"integration",depth:3},{title:"pages",id:"pages",depth:3},{title:"unit",id:"unit",depth:3}]}],frontmatter:{},pluginData:{},parentLabel:"docs"}],children:[]}]}}})),define("vault/flash/object",["exports","ember-cli-flash/flash/object"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/-date-base",["exports","@ember/runloop","@ember/component/helper","ember"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({disableInterval:!1,compute(e,{interval:n}){l.default.testing||this.disableInterval||(this.clearTimer(),n&&(this.intervalTimer=setTimeout((()=>{(0,t.run)((()=>this.recompute()))}),parseInt(n,10))))},clearTimer(){clearTimeout(this.intervalTimer)},destroy(){this.clearTimer(),this._super(...arguments)}})})),define("vault/helpers/add-to-array",["exports","@ember/component/helper","@ember/debug"],(function(e,t,n){function l(e){return e.filter(((t,n)=>e.indexOf(t)===n))}function i(e,t){return l([...e].concat(t))}function r(e,t){Array.isArray(e)
const n=[...e]
return n.push(t),l(n)}Object.defineProperty(e,"__esModule",{value:!0}),e.addManyToArray=i,e.addToArray=r,e.default=void 0
e.default=(0,t.helper)((function([e,t]){return Array.isArray(t)?i(e,t):r(e,t)}))})),define("vault/helpers/add",["exports","@ember/component/helper"],(function(e,t){function n(e){return e.reduce(((e,t)=>parseInt(t,0)+e),0)}Object.defineProperty(e,"__esModule",{value:!0}),e.add=n,e.default=void 0
e.default=(0,t.helper)(n)})),define("vault/helpers/all-features",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allFeatures=l,e.default=void 0
const n=["HSM","Performance Replication","DR Replication","MFA","Sentinel","Seal Wrapping","Control Groups","Performance Standby","Namespaces","KMIP","Entropy Augmentation","Transform Secrets Engine","Secrets Sync"]
function l(){return n}e.default=(0,t.helper)(l)})),define("vault/helpers/and",["exports","ember-truth-helpers/helpers/and"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"and",{enumerable:!0,get:function(){return t.and}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/append",["exports","ember-composable-helpers/helpers/append"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"append",{enumerable:!0,get:function(){return t.append}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/assign",["exports","ember-assign-helper/helpers/assign"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/await",["exports","core/helpers/await"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/aws-regions",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.regions=l
const n=["","us-east-1","us-east-2","us-west-1","us-west-2","ca-central-1","ap-south-1","ap-northeast-1","ap-northeast-2","ap-southeast-1","ap-southeast-2","eu-central-1","eu-west-1","eu-west-2","sa-east-1"]
function l(){return n.slice(0)}e.default=(0,t.helper)(l)})),define("vault/helpers/call",["exports","ember-composable-helpers/helpers/call"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"call",{enumerable:!0,get:function(){return t.call}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/camelize",["exports","ember-cli-string-helpers/helpers/camelize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"camelize",{enumerable:!0,get:function(){return t.camelize}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/cancel-all",["exports","ember-concurrency/helpers/cancel-all"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/capitalize",["exports","ember-cli-string-helpers/helpers/capitalize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"capitalize",{enumerable:!0,get:function(){return t.capitalize}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/changelog-url-for",["exports","core/helpers/changelog-url-for"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"changelogUrlFor",{enumerable:!0,get:function(){return t.changelogUrlFor}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/chunk",["exports","ember-composable-helpers/helpers/chunk"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"chunk",{enumerable:!0,get:function(){return t.chunk}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/classify",["exports","ember-cli-string-helpers/helpers/classify"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"classify",{enumerable:!0,get:function(){return t.classify}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/cluster-states",["exports","core/helpers/cluster-states"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"CLUSTER_STATES",{enumerable:!0,get:function(){return t.CLUSTER_STATES}}),Object.defineProperty(e,"clusterStates",{enumerable:!0,get:function(){return t.clusterStates}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/helpers/coerce-eq",["exports","@ember/component/helper"],(function(e,t){function n(e){return e[0]==e[1]}Object.defineProperty(e,"__esModule",{value:!0}),e.coerceEq=n,e.default=void 0
e.default=(0,t.helper)(n)})),define("vault/helpers/compact",["exports","ember-composable-helpers/helpers/compact"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/compute",["exports","ember-composable-helpers/helpers/compute"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"compute",{enumerable:!0,get:function(){return t.compute}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/css-range",["exports","@lineal-viz/lineal/helpers/css-range"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/dasherize",["exports","ember-cli-string-helpers/helpers/dasherize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"dasherize",{enumerable:!0,get:function(){return t.dasherize}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/date-format",["exports","core/helpers/date-format"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/date-from-now",["exports","core/helpers/date-from-now"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/dec",["exports","ember-composable-helpers/helpers/dec"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"dec",{enumerable:!0,get:function(){return t.dec}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/doc-link",["exports","core/helpers/doc-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/docfy-eq",["exports","@docfy/ember/helpers/docfy-eq"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"docfyEq",{enumerable:!0,get:function(){return t.docfyEq}})})),define("vault/helpers/drop",["exports","ember-composable-helpers/helpers/drop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/element",["exports","ember-element-helper/helpers/element"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ember-power-select-is-equal",["exports","ember-power-select/helpers/ember-power-select-is-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ember-power-select-is-group",["exports","ember-power-select/helpers/ember-power-select-is-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ember-power-select-is-selected-present",["exports","ember-power-select/helpers/ember-power-select-is-selected-present"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ensure-safe-component",["exports","@embroider/util"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.EnsureSafeComponentHelper}})})),define("vault/helpers/entries",["exports","ember-composable-helpers/helpers/entries"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"entries",{enumerable:!0,get:function(){return t.entries}})})),define("vault/helpers/eq",["exports","ember-truth-helpers/helpers/equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"equal",{enumerable:!0,get:function(){return t.equal}})})),define("vault/helpers/filter-by",["exports","ember-composable-helpers/helpers/filter-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/filter-wildcard",["exports","@ember/component/helper"],(function(e,t){function n([e,t]){if(!e||!t)return
!e.id&&e&&(e={id:e})
return(e=>t.filter((t=>new RegExp("^"+e.replace(/\*/g,".*")+"$").test(t))))(e.id).length}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.filterWildcard=n
e.default=(0,t.helper)(n)})),define("vault/helpers/filter",["exports","ember-composable-helpers/helpers/filter"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/find-by",["exports","ember-composable-helpers/helpers/find-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/flatten",["exports","ember-composable-helpers/helpers/flatten"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"flatten",{enumerable:!0,get:function(){return t.flatten}})})),define("vault/helpers/format-duration",["exports","core/helpers/format-duration"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"duration",{enumerable:!0,get:function(){return t.duration}})})),define("vault/helpers/format-number",["exports","core/helpers/format-number"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"formatNumber",{enumerable:!0,get:function(){return t.formatNumber}})})),define("vault/helpers/from-entries",["exports","ember-composable-helpers/helpers/from-entries"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"fromEntries",{enumerable:!0,get:function(){return t.fromEntries}})})),define("vault/helpers/group-by",["exports","ember-composable-helpers/helpers/group-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/gt",["exports","ember-truth-helpers/helpers/gt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"gt",{enumerable:!0,get:function(){return t.gt}})})),define("vault/helpers/gte",["exports","ember-truth-helpers/helpers/gte"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"gte",{enumerable:!0,get:function(){return t.gte}})})),define("vault/helpers/has-feature",["exports","core/helpers/has-feature"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/helpers/has-next",["exports","ember-composable-helpers/helpers/has-next"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"hasNext",{enumerable:!0,get:function(){return t.hasNext}})})),define("vault/helpers/has-permission",["exports","@ember/component/helper","@ember/service","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({permissions:(0,n.service)(),onPermissionsChange:(0,l.observer)("permissions.exactPaths","permissions.globPaths","permissions.canViewAll",(function(){this.recompute()})),compute([e],t){const{routeParams:n,requireAll:l}=t
return this.permissions.hasNavPermission(e,n,l)}})})),define("vault/helpers/has-previous",["exports","ember-composable-helpers/helpers/has-previous"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"hasPrevious",{enumerable:!0,get:function(){return t.hasPrevious}})})),define("vault/helpers/hds-link-to-models",["exports","@hashicorp/design-system-components/helpers/hds-link-to-models"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/hds-link-to-query",["exports","@hashicorp/design-system-components/helpers/hds-link-to-query"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/html-safe",["exports","ember-cli-string-helpers/helpers/html-safe"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"htmlSafe",{enumerable:!0,get:function(){return t.htmlSafe}})})),define("vault/helpers/humanize",["exports","ember-cli-string-helpers/helpers/humanize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"humanize",{enumerable:!0,get:function(){return t.humanize}})})),define("vault/helpers/if-key",["exports","ember-keyboard/helpers/if-key.js"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ignore-children",["exports","ember-modal-dialog/helpers/ignore-children"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/img-path",["exports","core/helpers/img-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/inc",["exports","ember-composable-helpers/helpers/inc"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"inc",{enumerable:!0,get:function(){return t.inc}})})),define("vault/helpers/includes",["exports","ember-composable-helpers/helpers/includes"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"includes",{enumerable:!0,get:function(){return t.includes}})})),define("vault/helpers/intersect",["exports","ember-composable-helpers/helpers/intersect"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/invoke",["exports","ember-composable-helpers/helpers/invoke"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"invoke",{enumerable:!0,get:function(){return t.invoke}})})),define("vault/helpers/is-active-route",["exports","core/helpers/is-active-route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/is-active",["exports","ember-router-helpers/helpers/is-active"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isActive",{enumerable:!0,get:function(){return t.isActive}})})),define("vault/helpers/is-after",["exports","vault/helpers/-date-base","date-fns"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({compute:function([e,t]){return this._super(...arguments),(0,n.isAfter)(e,t)}})})),define("vault/helpers/is-array",["exports","ember-truth-helpers/helpers/is-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isArray",{enumerable:!0,get:function(){return t.isArray}})})),define("vault/helpers/is-before",["exports","vault/helpers/-date-base","date-fns"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({compute:function([e,t]){return this._super(...arguments),(0,n.isBefore)(e,t)}})})),define("vault/helpers/is-empty-value",["exports","core/helpers/is-empty-value"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/is-empty",["exports","ember-truth-helpers/helpers/is-empty"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/is-equal",["exports","ember-truth-helpers/helpers/is-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isEqual",{enumerable:!0,get:function(){return t.isEqual}})})),define("vault/helpers/is-wildcard-string",["exports","@ember/component/helper"],(function(e,t){function n([e]){if(!e)return!1
if("object"==typeof e){if(Object.prototype.hasOwnProperty.call(e,"store"))return!1
e=Object.values(e).toString()}return e.includes("*")}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.isWildcardString=n
e.default=(0,t.helper)(n)})),define("vault/helpers/join",["exports","ember-composable-helpers/helpers/join"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/jsonify",["exports","core/helpers/jsonify"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"jsonify",{enumerable:!0,get:function(){return t.jsonify}})})),define("vault/helpers/keys",["exports","ember-composable-helpers/helpers/keys"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"keys",{enumerable:!0,get:function(){return t.keys}})})),define("vault/helpers/loose-equal",["exports","core/helpers/loose-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/lowercase",["exports","ember-cli-string-helpers/helpers/lowercase"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lowercase",{enumerable:!0,get:function(){return t.lowercase}})})),define("vault/helpers/lt",["exports","ember-truth-helpers/helpers/lt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lt",{enumerable:!0,get:function(){return t.lt}})})),define("vault/helpers/lte",["exports","ember-truth-helpers/helpers/lte"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lte",{enumerable:!0,get:function(){return t.lte}})}))
define("vault/helpers/map-by",["exports","ember-composable-helpers/helpers/map-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/map",["exports","ember-composable-helpers/helpers/map"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/media",["exports","ember-responsive/helpers/media"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/message-types",["exports","core/helpers/message-types"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"MESSAGE_TYPES",{enumerable:!0,get:function(){return t.MESSAGE_TYPES}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"messageTypes",{enumerable:!0,get:function(){return t.messageTypes}})})),define("vault/helpers/mountable-auth-methods",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allMethods=function(){return[...l,...n]},e.default=void 0,e.methods=i
const n=[{displayName:"SAML",value:"saml",type:"saml",category:"generic",glyph:"saml-color"}],l=[{displayName:"AliCloud",value:"alicloud",type:"alicloud",category:"cloud",glyph:"alibaba-color"},{displayName:"AppRole",value:"approle",type:"approle",category:"generic",glyph:"cpu"},{displayName:"AWS",value:"aws",type:"aws",category:"cloud",glyph:"aws-color"},{displayName:"Azure",value:"azure",type:"azure",category:"cloud",glyph:"azure-color"},{displayName:"Google Cloud",value:"gcp",type:"gcp",category:"cloud",glyph:"gcp-color"},{displayName:"GitHub",value:"github",type:"github",category:"cloud",glyph:"github-color"},{displayName:"JWT",value:"jwt",type:"jwt",glyph:"jwt",category:"generic"},{displayName:"OIDC",value:"oidc",type:"oidc",glyph:"openid-color",category:"generic"},{displayName:"Kubernetes",value:"kubernetes",type:"kubernetes",category:"infra",glyph:"kubernetes-color"},{displayName:"LDAP",value:"ldap",type:"ldap",glyph:"folder-users",category:"infra"},{displayName:"Okta",value:"okta",type:"okta",category:"infra",glyph:"okta-color"},{displayName:"RADIUS",value:"radius",type:"radius",glyph:"mainframe",category:"infra"},{displayName:"TLS Certificates",value:"cert",type:"cert",category:"generic",glyph:"certificate"},{displayName:"Username & Password",value:"userpass",type:"userpass",category:"generic",glyph:"users"}]
function i(){return l.slice()}e.default=(0,t.helper)(i)})),define("vault/helpers/mountable-secret-engines",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.WIF_ENGINES=e.CONFIGURABLE_SECRET_ENGINES=void 0,e.allEngines=a,e.configurableSecretEngines=function(){return l.slice()},e.default=void 0,e.isAddonEngine=function(e,t){if("kv"===e&&1===t)return!1
const n=a().find((t=>t.type===e))?.engineRoute
return!!n},e.mountableEngines=r,e.wifEngines=function(){return i.slice()}
const n=[{displayName:"KMIP",type:"kmip",glyph:"lock",engineRoute:"kmip.scopes.index",category:"generic",requiredFeature:"KMIP"},{displayName:"Transform",type:"transform",category:"generic",requiredFeature:"Transform Secrets Engine",glyph:"transform-data"},{displayName:"Key Management",type:"keymgmt",glyph:"key",category:"cloud",requiredFeature:"Key Management Secrets Engine",routeQueryParams:{tab:"provider"}}],l=[{displayName:"AliCloud",type:"alicloud",glyph:"alibaba-color",category:"cloud"},{displayName:"AWS",type:"aws",category:"cloud",glyph:"aws-color"},{displayName:"Azure",type:"azure",category:"cloud",glyph:"azure-color"},{displayName:"Consul",type:"consul",glyph:"consul-color",category:"infra"},{displayName:"Databases",type:"database",category:"infra",glyph:"database"},{displayName:"Google Cloud",type:"gcp",category:"cloud",glyph:"gcp-color"},{displayName:"Google Cloud KMS",type:"gcpkms",category:"cloud",glyph:"gcp-color"},{displayName:"KV",type:"kv",glyph:"key-values",engineRoute:"kv.list",category:"generic"},{displayName:"Nomad",type:"nomad",glyph:"nomad-color",category:"infra"},{displayName:"PKI Certificates",type:"pki",glyph:"certificate",engineRoute:"pki.overview",category:"generic"},{displayName:"RabbitMQ",type:"rabbitmq",glyph:"rabbitmq-color",category:"infra"},{displayName:"SSH",type:"ssh",glyph:"terminal-screen",category:"generic"},{displayName:"Transit",type:"transit",glyph:"swap-horizontal",category:"generic"},{displayName:"TOTP",type:"totp",glyph:"history",category:"generic"},{displayName:"LDAP",type:"ldap",engineRoute:"ldap.overview",category:"generic",glyph:"folder-users"},{displayName:"Kubernetes",type:"kubernetes",engineRoute:"kubernetes.overview",category:"generic",glyph:"kubernetes-color"}],i=e.WIF_ENGINES=["aws"]
e.CONFIGURABLE_SECRET_ENGINES=["aws","ssh"]
function r(){return l.slice()}function a(){return[...l,...n]}e.default=(0,t.helper)(r)})),define("vault/helpers/multi-line-join",["exports","@ember/component/helper"],(function(e,t){function n([e]){return e.join("\n")}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.multiLineJoin=n
e.default=(0,t.helper)(n)})),define("vault/helpers/nav-to-route",["exports","@ember/service","@ember/component/helper"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({router:(0,t.service)(),compute([e,...t],{replace:n=!1}){return()=>{const l=this.router
return(n?l.replaceWith:l.transitionTo).call(l,e,...t)}}})})),define("vault/helpers/new-line-split",["exports","core/helpers/new-line-split"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/next",["exports","ember-composable-helpers/helpers/next"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"next",{enumerable:!0,get:function(){return t.next}})})),define("vault/helpers/noop",["exports","ember-composable-helpers/helpers/noop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"noop",{enumerable:!0,get:function(){return t.noop}})})),define("vault/helpers/not-eq",["exports","ember-truth-helpers/helpers/not-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"notEqualHelper",{enumerable:!0,get:function(){return t.notEqualHelper}})})),define("vault/helpers/not",["exports","ember-truth-helpers/helpers/not"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"not",{enumerable:!0,get:function(){return t.not}})})),define("vault/helpers/now",["exports","vault/helpers/-date-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({compute(){return this._super(...arguments),Date.now()}})})),define("vault/helpers/number-to-word",["exports","@ember/component/helper"],(function(e,t){function n(e,t){const n={0:"zero",1:"one",2:"two",3:"three",4:"four",5:"five",6:"six",7:"seven",8:"eight",9:"nine"}[e]||e
return t&&"string"==typeof n?`${n.charAt(0).toUpperCase()}${n.slice(1)}`:n}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.numberToWord=n
e.default=(0,t.helper)((function([e],{capitalize:t}){return n(e,t)}))})),define("vault/helpers/object-at",["exports","ember-composable-helpers/helpers/object-at"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"objectAt",{enumerable:!0,get:function(){return t.objectAt}})})),define("vault/helpers/on-key",["exports","ember-keyboard/helpers/on-key.js"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/optional",["exports","ember-composable-helpers/helpers/optional"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"optional",{enumerable:!0,get:function(){return t.optional}})})),define("vault/helpers/options-for-backend",["exports","core/helpers/options-for-backend"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/or",["exports","ember-truth-helpers/helpers/or"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"or",{enumerable:!0,get:function(){return t.or}})})),define("vault/helpers/page-title",["exports","ember-page-title/helpers/page-title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/path-or-array",["exports","core/helpers/path-or-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/perform",["exports","ember-concurrency/helpers/perform"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/pick",["exports","ember-composable-helpers/helpers/pick"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"pick",{enumerable:!0,get:function(){return t.pick}})})),define("vault/helpers/pipe-action",["exports","ember-composable-helpers/helpers/pipe-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/pipe",["exports","ember-composable-helpers/helpers/pipe"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"pipe",{enumerable:!0,get:function(){return t.pipe}})})),define("vault/helpers/pluralize",["exports","ember-inflector/lib/helpers/pluralize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default})),define("vault/helpers/previous",["exports","ember-composable-helpers/helpers/previous"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"previous",{enumerable:!0,get:function(){return t.previous}})})),define("vault/helpers/queue",["exports","ember-composable-helpers/helpers/queue"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"queue",{enumerable:!0,get:function(){return t.queue}})})),define("vault/helpers/range",["exports","ember-composable-helpers/helpers/range"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"range",{enumerable:!0,get:function(){return t.range}})}))
define("vault/helpers/reduce",["exports","ember-composable-helpers/helpers/reduce"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/reject-by",["exports","ember-composable-helpers/helpers/reject-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/remove-from-array",["exports","@ember/component/helper","@ember/debug"],(function(e,t,n){function l(e,t){return[...e||[]].filter((e=>!t.includes(e)))}function i(e,t){const n=[...e],l=n.indexOf(t)
return l>=0&&n.splice(l,1),(i=n).filter(((e,t)=>i.indexOf(e)===t))
var i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.removeFromArray=i,e.removeManyFromArray=l
e.default=(0,t.helper)((function([e,t]){return Array.isArray(t)?l(e,t):i(e,t)}))})),define("vault/helpers/repeat",["exports","ember-composable-helpers/helpers/repeat"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"repeat",{enumerable:!0,get:function(){return t.repeat}})})),define("vault/helpers/replication-action-for-mode",["exports","core/helpers/replication-action-for-mode"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/replication-mode-description",["exports","core/helpers/replication-mode-description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/reverse",["exports","ember-composable-helpers/helpers/reverse"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/root-url",["exports","ember-router-helpers/helpers/root-url"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"rootUrl",{enumerable:!0,get:function(){return t.rootUrl}})})),define("vault/helpers/route-params-for",["exports","@ember/component/helper","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({permissions:(0,n.service)(),compute([e]){return this.permissions.navPathParams(e)}})})),define("vault/helpers/route-params",["exports","ember-router-helpers/helpers/route-params"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"routeParams",{enumerable:!0,get:function(){return t.routeParams}})})),define("vault/helpers/sanitized-html",["exports","core/helpers/sanitized-html"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-band",["exports","@lineal-viz/lineal/helpers/scale-band"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-diverging-log",["exports","@lineal-viz/lineal/helpers/scale-diverging-log"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-diverging-pow",["exports","@lineal-viz/lineal/helpers/scale-diverging-pow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-diverging-sqrt",["exports","@lineal-viz/lineal/helpers/scale-diverging-sqrt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-diverging-symlog",["exports","@lineal-viz/lineal/helpers/scale-diverging-symlog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-diverging",["exports","@lineal-viz/lineal/helpers/scale-diverging"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-fn-compute",["exports","@lineal-viz/lineal/helpers/scale-fn-compute"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-fn-derive",["exports","@lineal-viz/lineal/helpers/scale-fn-derive"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-identity",["exports","@lineal-viz/lineal/helpers/scale-identity"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-linear",["exports","@lineal-viz/lineal/helpers/scale-linear"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-log",["exports","@lineal-viz/lineal/helpers/scale-log"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-ordinal",["exports","@lineal-viz/lineal/helpers/scale-ordinal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-point",["exports","@lineal-viz/lineal/helpers/scale-point"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-pow",["exports","@lineal-viz/lineal/helpers/scale-pow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-quantile",["exports","@lineal-viz/lineal/helpers/scale-quantile"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-quantize",["exports","@lineal-viz/lineal/helpers/scale-quantize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-radial",["exports","@lineal-viz/lineal/helpers/scale-radial"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-sqrt",["exports","@lineal-viz/lineal/helpers/scale-sqrt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-symlog",["exports","@lineal-viz/lineal/helpers/scale-symlog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/helpers/scale-threshold",["exports","@lineal-viz/lineal/helpers/scale-threshold"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-time",["exports","@lineal-viz/lineal/helpers/scale-time"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/scale-utc",["exports","@lineal-viz/lineal/helpers/scale-utc"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/secret-query-params",["exports","@ember/component/helper"],(function(e,t){function n([e,t=""],{asQueryParams:n}){const l={transit:{tab:"actions"},database:{type:t},keymgmt:{itemType:"provider"===t?"provider":"key"}}[e]
return l&&n?{isQueryParams:!0,values:l}:l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.secretQueryParams=n
e.default=(0,t.helper)(n)})),define("vault/helpers/set-flash-message",["exports","core/helpers/set-flash-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/sha2-digest-sizes",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.sha2DigestSizes=l
const n=["sha2-224","sha2-256","sha2-384","sha2-512"]
function l(){return n}e.default=(0,t.helper)(l)})),define("vault/helpers/shuffle",["exports","ember-composable-helpers/helpers/shuffle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"shuffle",{enumerable:!0,get:function(){return t.shuffle}})})),define("vault/helpers/singularize",["exports","ember-inflector/lib/helpers/singularize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default})),define("vault/helpers/slice",["exports","ember-composable-helpers/helpers/slice"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/sort-by",["exports","ember-composable-helpers/helpers/sort-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/split-object",["exports","@ember/component/helper"],(function(e,t){function n(e,t){const n={},l={}
return Object.keys(e).forEach((i=>{t.includes(i)?n[i]=e[i]:l[i]=e[i]})),[n,l]}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.splitObject=n
e.default=(0,t.helper)(n)})),define("vault/helpers/stack-h",["exports","@lineal-viz/lineal/helpers/stack-h"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/stack-v",["exports","@lineal-viz/lineal/helpers/stack-v"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/stack",["exports","@lineal-viz/lineal/helpers/stack"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/stringify",["exports","core/helpers/stringify"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"stringify",{enumerable:!0,get:function(){return t.stringify}})})),define("vault/helpers/sub",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(0,t.helper)((function([e,...t]){return t.reduce(((e,t)=>e-parseInt(t,0)),e)}))})),define("vault/helpers/supported-auth-backends",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allSupportedAuthBackends=function(){return[...n,...l]},e.default=void 0,e.supportedAuthBackends=i
const n=[{type:"token",typeDisplay:"Token",description:"Token authentication.",tokenPath:"id",displayNamePath:"display_name",formAttributes:["token"]},{type:"userpass",typeDisplay:"Username",description:"A simple username and password backend.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"ldap",typeDisplay:"LDAP",description:"LDAP authentication.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"okta",typeDisplay:"Okta",description:"Authenticate with your Okta username and password.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"jwt",typeDisplay:"JWT",description:"Authenticate using JWT or OIDC provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role","jwt"]},{type:"oidc",typeDisplay:"OIDC",description:"Authenticate using JWT or OIDC provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role","jwt"]},{type:"radius",typeDisplay:"RADIUS",description:"Authenticate with your RADIUS username and password.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"github",typeDisplay:"GitHub",description:"GitHub authentication.",tokenPath:"client_token",displayNamePath:["metadata.org","metadata.username"],formAttributes:["token"]}],l=[{type:"saml",typeDisplay:"SAML",description:"Authenticate using SAML provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role"]}]
function i(){return[...n]}e.default=(0,t.helper)(i)})),define("vault/helpers/supported-managed-auth-backends",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.supportedManagedAuthBackends=l
const n=["cert","kubernetes","ldap","okta","radius","userpass"]
function l(){return n}e.default=(0,t.helper)(l)})),define("vault/helpers/supported-secret-backends",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.supportedSecretBackends=l
const n=["aws","database","cubbyhole","generic","kv","pki","ssh","transit","kmip","transform","keymgmt","kubernetes","ldap"]
function l(){return n}e.default=(0,t.helper)(l)})),define("vault/helpers/svg-jar",["exports","ember-svg-jar/helpers/svg-jar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"svgJar",{enumerable:!0,get:function(){return t.svgJar}})})),define("vault/helpers/sync-destinations",["exports","core/helpers/sync-destinations"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"destinationTypes",{enumerable:!0,get:function(){return t.destinationTypes}}),Object.defineProperty(e,"findDestination",{enumerable:!0,get:function(){return t.findDestination}}),Object.defineProperty(e,"syncDestinations",{enumerable:!0,get:function(){return t.syncDestinations}})})),define("vault/helpers/tabs-for-auth-section",["exports","@ember/component/helper","ember-inflector","@ember/string"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.tabsForAuthSection=a
const i={aws:[{label:"Client",route:"vault.cluster.settings.auth.configure.section",routeParams:["client"]},{label:"Identity Allow List Tidy",route:"vault.cluster.settings.auth.configure.section",routeParams:["identity-accesslist"]},{label:"Role Tag Deny List Tidy",route:"vault.cluster.settings.auth.configure.section",routeParams:["roletag-denylist"]}],azure:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],github:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],gcp:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],jwt:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],oidc:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],kubernetes:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],ldap:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],okta:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}],radius:[{label:"Configuration",route:"vault.cluster.settings.auth.configure.section",routeParams:["configuration"]}]},r={}
function a([e,t="authSettings",a]){let o
return"authSettings"===t?(o=(i[e.type]||[]).slice(),o.push({label:"Method Options",route:"vault.cluster.settings.auth.configure.section",routeParams:[e.id,"options"]}),o):(a||e.paths?(e.paths&&(a=e.paths.paths.filter((e=>e.navigation))),o=a.compact().map((e=>({label:(0,l.capitalize)((0,n.pluralize)(e.itemName)),route:"vault.cluster.access.method.item.list",routeParams:[e.itemType]})))):o=(r[e.type]||[]).slice(),o.push({label:"Configuration",route:"vault.cluster.access.method.section",routeParams:["configuration"]}),o.map((t=>({label:t.label,route:t.route,routeParams:[e.id,...t.routeParams]}))))}e.default=(0,t.helper)(a)})),define("vault/helpers/tabs-for-identity-show",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.TABS=void 0,e.tabsForIdentityShow=l
const n=e.TABS={entity:["details","aliases","policies","groups","metadata"],"entity-alias":["details","metadata"],group:["details","aliases","policies","members","parent-groups","metadata"],"group-internal":["details","policies","members","parent-groups","metadata"],"group-external":["details","aliases","policies","members","parent-groups","metadata"],"group-alias":["details"]}
function l([e,t]){let l=e
return t&&(l=`${l}-${t}`),n[l]}e.default=(0,t.helper)(l)})),define("vault/helpers/take",["exports","ember-composable-helpers/helpers/take"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/task",["exports","ember-concurrency/helpers/task"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/titleize",["exports","ember-cli-string-helpers/helpers/titleize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"titleize",{enumerable:!0,get:function(){return t.titleize}})})),define("vault/helpers/to-label",["exports","core/helpers/to-label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"toLabel",{enumerable:!0,get:function(){return t.toLabel}})})),define("vault/helpers/toggle-action",["exports","ember-composable-helpers/helpers/toggle-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/toggle",["exports","ember-composable-helpers/helpers/toggle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"toggle",{enumerable:!0,get:function(){return t.toggle}})})),define("vault/helpers/tools-actions",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.toolsActions=l
const n=["wrap","lookup","unwrap","rewrap","random","hash"]
function l(){return n}e.default=(0,t.helper)(l)}))
define("vault/helpers/transition-to",["exports","ember-router-helpers/helpers/transition-to"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"transitionTo",{enumerable:!0,get:function(){return t.transitionTo}})})),define("vault/helpers/trim",["exports","ember-cli-string-helpers/helpers/trim"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"trim",{enumerable:!0,get:function(){return t.trim}})})),define("vault/helpers/truncate",["exports","ember-cli-string-helpers/helpers/truncate"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"truncate",{enumerable:!0,get:function(){return t.truncate}})})),define("vault/helpers/underscore",["exports","ember-cli-string-helpers/helpers/underscore"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"underscore",{enumerable:!0,get:function(){return t.underscore}})})),define("vault/helpers/union",["exports","ember-composable-helpers/helpers/union"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/uppercase",["exports","ember-cli-string-helpers/helpers/uppercase"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"uppercase",{enumerable:!0,get:function(){return t.uppercase}})})),define("vault/helpers/url-for",["exports","ember-router-helpers/helpers/url-for"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"urlFor",{enumerable:!0,get:function(){return t.urlFor}})})),define("vault/helpers/values",["exports","ember-composable-helpers/helpers/values"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"values",{enumerable:!0,get:function(){return t.values}})})),define("vault/helpers/w",["exports","ember-cli-string-helpers/helpers/w"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"w",{enumerable:!0,get:function(){return t.w}})})),define("vault/helpers/without",["exports","ember-composable-helpers/helpers/without"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"without",{enumerable:!0,get:function(){return t.without}})})),define("vault/helpers/xor",["exports","ember-truth-helpers/helpers/xor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"xor",{enumerable:!0,get:function(){return t.xor}})})),define("vault/initializers/deprecation-filter",["exports","@ember/debug"],(function(e,t){function n(){(0,t.registerDeprecationHandler)(((e,t,n)=>{t?.until.includes("5.0")&&t?.id.startsWith("ember-data")||n(e,t)}))}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=n
e.default={initialize:n}})),define("vault/initializers/disable-ember-inspector",["exports","vault/config/environment"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={name:"ember-inspect-disable",initialize:function(){"production"===t.default.environment&&(window.NO_EMBER_DEBUG=!0)}}})),define("vault/initializers/ember-cli-mirage",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={name:"ember-cli-mirage",initialize(){}}})),define("vault/initializers/ember-data-data-adapter",["exports","@ember-data/debug/setup"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/initializers/ember-data-identifiers",["exports","@ember-data/store","@ember/string","uuid"],(function(e,t,n,l){function i(){(0,t.setIdentifierGenerationMethod)((e=>e.lid?e.lid:e.id?`@lid:${(0,n.dasherize)(e.type)}-${e.id}`:(0,l.v4)()))}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=i
e.default={name:"ember-data-identifiers",initialize:i}})),define("vault/initializers/ember-data",["exports","ember-data","ember-data/setup-container"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={name:"ember-data",initialize:n.default}})),define("vault/initializers/ember-responsive-breakpoints",["exports","ember-responsive/initializers/responsive"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default})),define("vault/initializers/enable-engines",["exports","vault/config/environment"],(function(e,t){function n(){t.default.addRootMounts=function(){this.mount("replication")}}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=n
e.default={initialize:n}})),define("vault/initializers/engines",["exports","ember-engines/initializers/engines"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"initialize",{enumerable:!0,get:function(){return t.initialize}})})),define("vault/instance-initializers/add-modals-container",["exports","ember-modal-dialog/instance-initializers/add-modals-container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={name:"add-modals-container",initialize:t.default}})),define("vault/instance-initializers/ember-data",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={name:"ember-data",initialize(){}}})),define("vault/instance-initializers/load-asset-manifest",["exports","vault/config/asset-manifest"],(function(e,t){function n(e){e.lookup("service:asset-loader").pushManifest(t.default)}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=n
e.default={name:"load-asset-manifest",initialize:n}})),define("vault/instance-initializers/load-sprite",["exports","@hashicorp/ember-flight-icons/instance-initializers/load-sprite"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/instance-initializers/track-csp-event",["exports"],(function(e){function t(e){e.lookup("service:csp-event").attach()}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=t
e.default={name:"track-csp-event",initialize:t}})),define("vault/lib/arg-tokenizer",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){if(Array.isArray(e))return e
e=e.trim()
for(var t=0,n=null,l=null,i=null,r=[],a=0;a<e.length;a++)n=l," "!==(l=e.charAt(a))||i?(l===i?(r[t]||(r[t]=""),i=null):"'"!==l&&'"'!==l||i||(i=l),r[t]||(r[t]=""),r[t]+=l):" "!==n&&t++
return r}})),define("vault/lib/console-helpers",["exports","core/utils/key-codes","shell-quote","vault/lib/arg-tokenizer"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.executeUICommand=function(e,t,n){const l=e.startsWith("api")?"api":e,i=r.includes(l)
i&&t(e)
const a=n[l]
a&&"function"==typeof a&&a()
return i},e.extractDataFromStrings=function(e){return e?e.reduce(((e,t)=>{const[n="",l=""]=t.split(/=(.+)?/)
if(!n)return e
const i=e[n]
return i?(e[n]=Array.isArray(i)?[...i,l]:[i,l],e):(e[n]=l,e)}),{}):{}},e.extractFlagsFromStrings=function(e,t){return e?e.reduce(((e,n)=>{const[l,i]=n.split(/=(.+)?/)
if(!l)return e
let r=l.replace(/^-/,"")
return"wrap-ttl"===r?r="wrapTTL":"write"===t&&("f"!==r&&"-force"!==r||(r="force")),e[r]=i||!0,e}),{}):{}},e.formattedErrorFromInput=function(e,t,n,l){if(void 0===e)return{type:"error",content:"A path is required to make a request."}
if("write"===t&&!n.force&&0===l.length)return{type:"error",content:"Must supply data or use -force"}
return},e.logFromError=function(e,t,n){let l
const{httpStatus:i,path:r}=e
l=`Error ${{read:"reading from","kv-get":"reading secret",write:"writing to",list:"listing",delete:"deleting at"}[n]}: ${t}.\nURL: ${r}\nCode: ${i}`,"string"==typeof e.errors[0]&&(l=`${l}\nErrors:\n  ${e.errors.join("\n  ")}`)
return{type:"error",content:l}},e.logFromResponse=function(e,t,n,l){const{format:i,field:r}=l,a=e&&(e.auth||e.data||e.wrap_info),o=a||e
if(!a){if("write"===n)return{type:"success",content:`Success! Data written to: ${t}`}
if("delete"===n)return{type:"success",content:`Success! Data deleted (if it existed) at: ${t}`}}if(r){const e=o[r]
let t
if(e){if(i&&"json"===i)return{type:"json",content:e}
t="string"==typeof e?{type:"text",content:e}:"number"==typeof e||"boolean"==typeof e||Array.isArray(e)?{type:"text",content:JSON.stringify(e)}:{type:"object",content:e}}else t={type:"error",content:`Field "${r}" not present in secret`}
return t}if(i&&"json"===i)return{type:"json",content:e}
if("list"===n)return{type:"list",content:o}
return{type:"object",content:o}},e.parseCommand=function(e){const t=(0,l.default)((0,n.parse)(e))
"vault"===t[0]&&t.shift()
const[r="",...a]=t
let o=""
const s=[],u=[]
if(a.forEach((e=>{if(e.startsWith("-"))s.push(e)
else if(o){const t=e.split(/=(.+)/).filter((e=>""!==e)).join("=")
u.push(t)}else o=e})),!i.includes(r))throw new Error("invalid command")
return{method:r,flagArray:s,path:o,dataArray:u}},e.shiftCommandIndex=function(e,n,l){let i
const r=n.length
if(!r)return[]
e===t.default.UP?(l-=1)<0&&(l=r-1):((l+=1)===r&&(i=""),l>r&&(l-=1))
if(""!==i){const e=n[l]
i=e?.content}return[l,i]}
const i=["read","write","list","delete","kv-get"],r=["api","clearall","clear","fullscreen","refresh"]})),define("vault/lib/control-group-error",["exports","@ember-data/adapter/error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(e){const{accessor:t,creation_path:n,creation_time:l,token:i,ttl:r}=e
super(),this.message="Control Group encountered",this.token=i,this.accessor=t,this.creation_path=n,this.creation_time=l,this.ttl=r}}e.default=n})),define("vault/lib/kv-object",["exports","@ember/array/proxy","@ember/utils","@ember/object/internals"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({fromJSON(e){if(e&&"object"!==(0,n.typeOf)(e))throw new Error("Vault expects data to be formatted as an JSON object.")
const t=Object.keys(e||[]).map((t=>{const n={name:t,value:e[t]}
return(0,l.guidFor)(n),n}))
return this.setObjects(t.sort(((e,t)=>""===e.name?1:""===t.name?-1:e.name.localeCompare(t.name)))),this},fromJSONString(e){return this.fromJSON(JSON.parse(e))},toJSON(e=!1){return this.reduce(((t,n)=>{if(!e&&""===n.value&&""===n.name)return t
const l=void 0===n.value?"":n.value
return t[n.name||""]=l,t}),{})},toJSONString(e){return JSON.stringify(this.toJSON(e),null,2)},isAdvanced(){return this.any((e=>"string"!=typeof e.value))}})})),define("vault/lib/local-storage",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={isLocalStorageSupported(){try{const e="__storage__test"
return window.localStorage.setItem(e,null),window.localStorage.removeItem(e),!0}catch(e){throw e.errors=["This is likely due to your browser's cookie settings."],e}},getItem(e){const t=window.localStorage.getItem(e)
return t&&JSON.parse(t)},setItem(e,t){window.localStorage.setItem(e,JSON.stringify(t))},removeItem:e=>window.localStorage.removeItem(e),keys:()=>Object.keys(window.localStorage),cleanupStorage(e,t){if(!e)return
const n=this.keys().filter((t=>t.startsWith(e)))
n?.forEach((e=>{e!==t&&localStorage.removeItem(e)}))}}}))
define("vault/lib/memory-storage",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const t={}
e.default={getItem(e){var n=t[e]
return n&&JSON.parse(n)},setItem(e,n){t[e]=JSON.stringify(n)},removeItem(e){delete t[e]},keys:()=>Object.keys(t)}})),define("vault/lib/path-to-tree",["exports","flat","deepmerge"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){let i=e.slice(0).sort(((e,t)=>t.length-e.length||t.localeCompare(e))).reduce(((e,t)=>{const n=e.find((e=>e.startsWith(t)))
return n&&"/"===n.charAt(t.length)||e.push(t),e}),[])
return i=i.sort(((e,t)=>e.localeCompare(t))),n.default.all(i.map((e=>(e=e.replace(/\.+/g,l),(0,t.unflatten)({[e]:null},{delimiter:"/",object:!0})))))}
const l="☃"})),define("vault/lib/route-paths",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.UNSEAL=e.REDIRECT=e.OIDC_PROVIDER=e.OIDC_CALLBACK=e.NS_OIDC_PROVIDER=e.LOGOUT=e.INIT=e.EXCLUDED_REDIRECT_URLS=e.DR_REPLICATION_SECONDARY_DETAILS=e.DR_REPLICATION_SECONDARY=e.CLUSTER_INDEX=e.CLUSTER=e.AUTH=void 0
e.INIT="vault.cluster.init",e.UNSEAL="vault.cluster.unseal",e.AUTH="vault.cluster.auth",e.LOGOUT="vault.cluster.logout",e.REDIRECT="vault.cluster.redirect",e.CLUSTER="vault.cluster",e.CLUSTER_INDEX="vault.cluster.index",e.OIDC_CALLBACK="vault.cluster.oidc-callback",e.OIDC_PROVIDER="vault.cluster.oidc-provider",e.NS_OIDC_PROVIDER="vault.cluster.oidc-provider-ns",e.DR_REPLICATION_SECONDARY="vault.cluster.replication-dr-promote",e.DR_REPLICATION_SECONDARY_DETAILS="vault.cluster.replication-dr-promote.details",e.EXCLUDED_REDIRECT_URLS=["/vault/logout"]})),define("vault/lib/token-storage",["exports","vault/lib/local-storage","vault/lib/memory-storage"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){if("memory"===e)return n.default
let l
try{window.localStorage.getItem("test"),l=t.default}catch(i){l=n.default}return l}})),define("vault/macros/identity-capabilities",["exports","vault/macros/lazy-capabilities"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(){return(0,t.default)(t.apiPath`identity/${"identityType"}/id/${"id"}`,"id","identityType")}})),define("vault/macros/lazy-capabilities",["exports","vault/macros/maybe-query-record"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.apiPath=function(e,...t){return function(n){const l=n||{},i=[e[0]]
return t.forEach(((t,n)=>{i.push(l[t],e[n+1])})),i.join("")}},e.default=function(){const[e,...n]=arguments
return(0,t.maybeQueryRecord)("capabilities",(t=>{const l=t.getProperties(...n),i=Object.keys(l).reduce(((e,t)=>(null!=l[t]&&(e[t]=l[t]),e)),{})
if(Object.keys(i).length===n.length)return{id:e(i)}}),...n)}})),define("vault/macros/maybe-query-record",["exports","@ember/object","@ember/object/proxy","@ember/object/promise-proxy-mixin","rsvp","@ember/test-waiters"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.maybeQueryRecord=function(e,r={},...o){return(0,t.computed)(...o,"store",{get(){const t=a.beginAsync(),o="function"==typeof r?r(this):r
return n.default.extend(l.default).create({promise:o?this.store.queryRecord(e,o).finally((()=>a.endAsync(t))):(0,i.resolve)({}).finally((()=>a.endAsync(t)))})}})},n.default.reopen({unknownProperty(e){if(!(this.isDestroying||this.isDestroyed||this.content&&(this.content.isDestroying||this.content.isDestroyed)))return this._super(e)}})
const a=(0,r.buildWaiter)("capabilities")})),define("vault/mixins/backend-crumb",["exports","@ember/object","@ember/object/mixin"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.create({backendCrumb:(0,t.computed)("backend",(function(){const e=this.backend
if(void 0===e)throw new Error("backend-crumb mixin requires backend to be set")
return{label:e,text:e,path:"vault.cluster.secrets.backend.list-root",model:e}}))})})),define("vault/mixins/cluster-route",["exports","@ember/service","@ember/object/mixin","rsvp","vault/lib/route-paths"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.create({auth:(0,t.service)(),store:(0,t.service)(),router:(0,t.service)(),transitionToTargetRoute(e={}){const t=this.targetRouteName(e)
if(t&&t!==this.routeName&&t!==e.targetName&&t!==this.router.currentRouteName){const n=i.EXCLUDED_REDIRECT_URLS.find((e=>this.router.currentURL?.includes(e)))
return t!==i.AUTH||e.targetName===i.CLUSTER_INDEX||n?this.router.transitionTo(t):this.router.transitionTo(t,{queryParams:{redirect_to:this.router.currentURL}})}return l.default.resolve()},beforeModel(e){return this.transitionToTargetRoute(e)},clusterModel(){return this.modelFor(i.CLUSTER)||this.store.peekRecord("cluster","vault")},authToken(){return this.auth.currentToken},hasKeyData(){return!!this.controllerFor(i.INIT).keyData},targetRouteName(e){const t=this.clusterModel(),n=this.authToken()
return t.needsInit||this.hasKeyData()&&this.routeName!==i.UNSEAL&&this.routeName!==i.AUTH?i.INIT:t.sealed?i.UNSEAL:t?.dr?.isSecondary?e&&e.targetName===i.DR_REPLICATION_SECONDARY_DETAILS||this.router.currentRouteName===i.DR_REPLICATION_SECONDARY_DETAILS?i.DR_REPLICATION_SECONDARY_DETAILS:i.DR_REPLICATION_SECONDARY:n?!t.needsInit&&this.routeName===i.INIT||!t.sealed&&this.routeName===i.UNSEAL||!t?.dr?.isSecondary&&this.routeName===i.DR_REPLICATION_SECONDARY?i.CLUSTER:n&&this.routeName===i.AUTH?i.REDIRECT:null:e&&e.targetName===i.OIDC_PROVIDER||this.routeName===i.OIDC_PROVIDER?i.OIDC_PROVIDER:e&&e.targetName===i.NS_OIDC_PROVIDER||this.routeName===i.NS_OIDC_PROVIDER?i.NS_OIDC_PROVIDER:e&&e.targetName===i.OIDC_CALLBACK||this.routeName===i.OIDC_CALLBACK?i.OIDC_CALLBACK:i.AUTH}})})),define("vault/mixins/focus-on-insert",["exports","@ember/runloop","@ember/object/evented","@ember/object/mixin"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.create({focusOnInsertSelector:null,shouldFocus:!0,focusOnInsert:(0,n.on)("didInsertElement",(function(){(0,t.schedule)("afterRender",this,"focusOnInsertFocus")})),focusOnInsertFocus(){!1!==this.shouldFocus&&this.forceFocus()},forceFocus(){var e=this.element.querySelectorAll(this.focusOnInsertSelector||'input[type="text"]')[0]
e&&e!==document.activeElement&&e.focus()}})})),define("vault/mixins/key-mixin",["exports","@ember/object","@ember/object/mixin","core/utils/key-utils"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.create({pathAttr:"path",flags:null,initialParentKey:null,isCreating:(0,t.computed)("initialParentKey",(function(){return null!=this.initialParentKey})),pathVal(){return this[this.pathAttr]||this.id},isFolder:(0,t.computed)("id","path",(function(){return(0,l.keyIsFolder)(this.pathVal())})),keyParts:(0,t.computed)("id","path",(function(){return(0,l.keyPartsForKey)(this.pathVal())})),parentKey:(0,t.computed)("id","path","isCreating",{get:function(){return this.isCreating?this.initialParentKey:(0,l.parentKeyForKey)(this.pathVal())},set:function(e,t){return t}}),keyWithoutParent:(0,t.computed)("id","path","parentKey",{get:function(){var e=this.pathVal()
return e?e.replace(this.parentKey,""):null},set:function(e,t){return t&&t.trim()?this.set(this.pathAttr,this.parentKey+t):this.set(this.pathAttr,null),t}})})})),define("vault/mixins/list-controller",["exports","core/mixins/list-controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/mixins/list-route",["exports","core/mixins/list-route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/mixins/model-boundary-route",["exports","@ember/routing/route","@ember/utils","@ember/debug","@ember/object/evented","@ember/object/mixin"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=r.default.create({modelType:null,modelTypes:null,verifyProps:(0,i.on)("init",(function(){this.modelType,this.modelTypes})),clearModelCache:(0,i.on)("deactivate",(function(){var e=this.modelType,t=this.modelTypes;(e||t)&&(this.store.isDestroyed||this.store.isDestroying||(e&&this.store.unloadAll(e),t&&t.forEach((e=>{this.store.unloadAll(e)}))))}))})})),define("vault/mixins/replication-actions",["exports","core/mixins/replication-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/mixins/unload-model-route",["exports","@ember/object/mixin","vault/utils/remove-record"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.create({modelPath:"model",unloadModel(){const{modelPath:e}=this,t=this.controller.get(e)
t&&t.unloadRecord&&!t.isSaving&&((0,n.default)(this.store,t),this.controller.set(e,null))},actions:{willTransition(){return this.unloadModel(),!0}}})})),define("vault/mixins/unsaved-model-route",["exports","@ember/object/mixin","ember"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.create({actions:{willTransition(e){const t=this.controller.get("model")
return!t||(!t.hasDirtyAttributes||(n.default.testing||window.confirm("You have unsaved changes. Navigating away will discard these changes. Are you sure you want to discard your changes?")?(t.rollbackAttributes(),!0):(e.abort(),!1)))}}})})),define("vault/models/auth-config",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({backend:(0,t.belongsTo)("auth-method",{inverse:"authConfigs",readOnly:!0,async:!1})})})),define("vault/models/auth-config/approle",["exports","vault/models/auth-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/models/auth-config/aws/client",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({secretKey:(0,t.attr)("string"),accessKey:(0,t.attr)("string"),endpoint:(0,t.attr)("string",{label:"EC2 Endpoint"}),iamEndpoint:(0,t.attr)("string",{label:"IAM Endpoint"}),stsEndpoint:(0,t.attr)("string",{label:"STS Endpoint"}),iamServerIdHeaderValue:(0,t.attr)("string",{label:"IAM Server ID Header Value"}),fieldGroups:(0,n.computed)((function(){return(0,i.default)(this,[{default:["accessKey","secretKey"]},{"AWS Options":["endpoint","iamEndpoint","stsEndpoint","iamServerIdHeaderValue"]}])}))})})),define("vault/models/auth-config/aws/identity-accesslist",["exports","vault/models/auth-config/aws/tidy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/models/auth-config/aws/roletag-denylist",["exports","vault/models/auth-config/aws/tidy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/models/auth-config/aws/tidy",["exports","@ember-data/model","@ember/object","vault/utils/field-to-attrs","vault/models/auth-config"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({safetyBuffer:(0,t.attr)({defaultValue:"72h",editType:"ttl"}),disablePeriodicTidy:(0,t.attr)("boolean",{defaultValue:!1}),attrs:(0,n.computed)((function(){return(0,l.expandAttributeMeta)(this,["safetyBuffer","disablePeriodicTidy"])}))})})),define("vault/models/auth-config/azure",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({tenantId:(0,t.attr)("string",{label:"Tenant ID",helpText:"The tenant ID for the Azure Active Directory organization"}),resource:(0,t.attr)("string",{helpText:"The configured URL for the application registered in Azure Active Directory"}),clientId:(0,t.attr)("string",{label:"Client ID",helpText:"The client ID for credentials to query the Azure APIs. Currently read permissions to query compute resources are required."}),clientSecret:(0,t.attr)("string",{helpText:"The client secret for credentials to query the Azure APIs"}),googleCertsEndpoint:(0,t.attr)("string"),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["tenantId","resource"]},{"Azure Options":["clientId","clientSecret"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,r.default)(this,e)}))})})),define("vault/models/auth-config/cert",["exports","vault/models/auth-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/models/auth-config/gcp",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({credentials:(0,t.attr)("string",{editType:"file"}),googleCertsEndpoint:(0,t.attr)("string"),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["credentials"]},{"Google Cloud Options":["googleCertsEndpoint"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,r.default)(this,e)}))})})),define("vault/models/auth-config/github",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({organization:(0,t.attr)("string"),baseUrl:(0,t.attr)("string",{label:"Base URL"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["organization"]},{"GitHub Options":["baseUrl"]}]
return this.newFields&&(e=(0,r.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})})),define("vault/models/auth-config/jwt",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({oidcDiscoveryUrl:(0,t.attr)("string",{label:"OIDC discovery URL",helpText:"The OIDC discovery URL, without any .well-known component (base path). Cannot be used with jwt_validation_pubkeys"}),oidcClientId:(0,t.attr)("string",{label:"OIDC client ID"}),oidcClientSecret:(0,t.attr)("string",{label:"OIDC client secret"}),oidcDiscoveryCaPem:(0,t.attr)("string",{label:"OIDC discovery CA PEM",editType:"file",helpText:"The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used"}),jwksCaPem:(0,t.attr)("string",{label:"JWKS CA PEM",editType:"file"}),jwksUrl:(0,t.attr)("string",{label:"JWKS URL"}),jwksPairs:(0,t.attr)({label:"JWKS pairs"}),oidcResponseMode:(0,t.attr)("string",{label:"OIDC response mode"}),oidcResponseTypes:(0,t.attr)("string",{label:"OIDC response types"}),jwtValidationPubkeys:(0,t.attr)({label:"JWT validation public keys",editType:"stringArray"}),jwtSupportedAlgs:(0,t.attr)({label:"JWT supported algorithms"}),boundIssuer:(0,t.attr)("string",{helpText:"The value against which to match the iss claim in a JWT"}),fieldGroups:(0,n.computed)("constructor.modelName","newFields",(function(){const e=this.constructor.modelName.split("/")[1].toUpperCase()
let t=[{default:["oidcDiscoveryUrl","defaultRole","jwksCaPem","jwksUrl","oidcResponseMode","oidcResponseTypes"]},{[`${e} Options`]:["oidcClientId","oidcClientSecret","oidcDiscoveryCaPem","jwtValidationPubkeys","jwtSupportedAlgs","boundIssuer"]}]
return this.newFields&&(t=(0,r.combineFieldGroups)(t,this.newFields,[])),(0,i.default)(this,t)}))})})),define("vault/models/auth-config/kubernetes",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({kubernetesHost:(0,t.attr)("string",{helpText:"Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server."}),kubernetesCaCert:(0,t.attr)("string",{editType:"file",helpText:"Optional PEM encoded CA cert for use by the TLS client used to talk with the Kubernetes API. If it is not set and disable_local_ca_jwt is true, the system's trusted CA certificate pool will be used."}),tokenReviewerJwt:(0,t.attr)("string",{helpText:"A service account JWT used to access the TokenReview API to validate other JWTs during login. If not set the JWT used for login will be used to access the API"}),useAnnotationsAsAliasMetadata:(0,t.attr)("boolean"),pemKeys:(0,t.attr)({editType:"stringArray"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["kubernetesHost","kubernetesCaCert"]},{"Kubernetes Options":["tokenReviewerJwt","pemKeys","useAnnotationsAsAliasMetadata"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,r.default)(this,e)}))})})),define("vault/models/auth-config/ldap",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({certificate:(0,t.attr)({label:"Certificate",editType:"file"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["url"]},{"LDAP Options":["starttls","insecureTls","discoverdn","denyNullBind","tlsMinVersion","tlsMaxVersion","certificate","clientTlsCert","clientTlsKey","userattr","upndomain","anonymousGroupSearch"]},{"Customize User Search":["binddn","userdn","bindpass","userfilter"]},{"Customize Group Membership Search":["groupfilter","groupattr","groupdn","useTokenGroups"]}]
return this.newFields&&(e=(0,r.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})}))
define("vault/models/auth-config/oidc",["exports","vault/models/auth-config/jwt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/models/auth-config/okta",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({orgName:(0,t.attr)("string",{helpText:"Name of the organization to be used in the Okta API"}),apiToken:(0,t.attr)("string",{helpText:"Okta API token. This is required to query Okta for user group membership. If this is not supplied only locally configured groups will be enabled."}),baseUrl:(0,t.attr)("string",{helpText:"If set, will be used as the base domain for API requests. Examples are okta.com, oktapreview.com, and okta-emea.com"}),bypassOktaMfa:(0,t.attr)("boolean",{defaultValue:!1,helpText:"Useful if using Vault's built-in MFA mechanisms. Will also cause certain other statuses to be ignored, such as PASSWORD_EXPIRED"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["orgName"]},{Options:["apiToken","baseUrl","bypassOktaMfa"]}]
return this.newFields&&(e=(0,r.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})})),define("vault/models/auth-config/radius",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({host:(0,t.attr)("string"),secret:(0,t.attr)("string"),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["host","secret"]},{"RADIUS Options":["port","nasPort","nasIdentifier","dialTimeout","unregisteredUserPolicies"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,r.default)(this,e)}))})})),define("vault/models/auth-config/userpass",["exports","vault/models/auth-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/models/auth-method",["exports","@ember-data/model","@ember/service","vault/utils/field-to-attrs","vault/utils/api-path","vault/decorators/model-validations","vault/helpers/mountable-auth-methods","vault/macros/lazy-capabilities","@ember/object","@ember/string","vault/utils/validators"],(function(e,t,n,l,i,r,a,o,s,u,c){var d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I
function L(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function U(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function V(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const q={path:[{type:"presence",message:"Path can't be blank."},{type:"containsWhiteSpace",message:(0,c.WHITESPACE_WARNING)("path"),level:"warn"}]}
e.default=(d=(0,r.withModelValidations)(q),p=(0,t.belongsTo)("mount-config",{async:!1,inverse:null}),f=(0,t.hasMany)("auth-config",{polymorphic:!0,inverse:"backend",async:!1}),m=(0,t.attr)("string"),h=(0,t.attr)("string"),b=(0,t.attr)("string"),y=(0,t.attr)("string"),v=(0,t.attr)("string",{editType:"textarea"}),g=(0,t.attr)("boolean",{helpText:"When Replication is enabled, a local mount will not be replicated across clusters. This can only be specified at mount time."}),w=(0,t.attr)("boolean",{helpText:"When enabled - if a seal supporting seal wrapping is specified in the configuration, all critical security parameters (CSPs) in this backend will be seal wrapped. (For KV mounts, all values will be seal wrapped.) This can only be specified at mount time."}),k=(0,o.default)(i.default`sys/auth/${"id"}`,"id"),x=(0,o.default)(i.default`auth/${"id"}/config`,"id"),P=(0,o.default)(i.default`auth/${"id"}/config/client`,"id"),d((T=class extends t.default{constructor(...e){super(...e),L(this,"store",O,this),L(this,"config",j,this),L(this,"authConfigs",z,this),L(this,"path",M,this),L(this,"accessor",S,this),L(this,"name",C,this),L(this,"type",A,this),L(this,"description",E,this),L(this,"local",R,this),L(this,"sealWrap",D,this),U(this,"userLockoutConfig",{modelAttrs:["config.lockoutThreshold","config.lockoutDuration","config.lockoutCounterReset","config.lockoutDisable"],apiParams:["lockout_threshold","lockout_duration","lockout_counter_reset","lockout_disable"]}),L(this,"deletePath",N,this),L(this,"configPath",F,this),L(this,"awsConfigPath",I,this)}get methodType(){return this.type.replace(/^ns_/,"")}get icon(){const e=(0,a.allMethods)().find((e=>e.type===this.methodType))
return e?.glyph||"users"}get apiPath(){return`auth/${this.path}`}get localDisplay(){return this.local?"local":"replicated"}get supportsUserLockoutConfig(){return["approle","ldap","userpass"].includes(this.methodType)}get tuneAttrs(){const e=["listingVisibility","defaultLeaseTtl","maxLeaseTtl",..."token"===this.methodType?[]:["tokenType"],"auditNonHmacRequestKeys","auditNonHmacResponseKeys","passthroughRequestHeaders","allowedResponseHeaders","pluginVersion",...this.supportsUserLockoutConfig?this.userLockoutConfig.apiParams.map((e=>(0,u.camelize)(e))):[]]
return(0,l.expandAttributeMeta)(this,["description",`config.{${e.join(",")}}`])}get formFields(){return["type","path","description","accessor","local","sealWrap","config.{listingVisibility,defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders,allowedResponseHeaders,pluginVersion}"]}get formFieldGroups(){return[{default:["path"]},{"Method Options":["description","config.listingVisibility","local","sealWrap","config.{defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders,allowedResponseHeaders,pluginVersion}"]}]}get attrs(){return(0,l.expandAttributeMeta)(this,this.formFields)}get fieldGroups(){return(0,l.default)(this,this.formFieldGroups)}get canDisable(){return!1!==this.deletePath.get("canDelete")}get canEdit(){return!1!==this.configPath.get("canUpdate")}get canEditAws(){return!1!==this.awsConfigPath.get("canUpdate")}tune(e){return this.store.adapterFor("auth-method").tune(this.path,e)}},O=V(T.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=V(T.prototype,"config",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=V(T.prototype,"authConfigs",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=V(T.prototype,"path",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=V(T.prototype,"accessor",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=V(T.prototype,"name",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=V(T.prototype,"type",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=V(T.prototype,"description",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=V(T.prototype,"local",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=V(T.prototype,"sealWrap",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=V(T.prototype,"deletePath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=V(T.prototype,"configPath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=V(T.prototype,"awsConfigPath",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V(T.prototype,"tune",[s.action],Object.getOwnPropertyDescriptor(T.prototype,"tune"),T.prototype),_=T))||_)})),define("vault/models/aws-credential",["exports","@ember-data/model","vault/decorators/model-expanded-attributes"],(function(e,t,n){var l,i,r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T
function O(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function j(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=(0,n.withExpandedAttributes)(),i=(0,t.attr)("object",{readOnly:!0}),r=(0,t.attr)("string",{defaultValue:"iam_user",possibleValues:[{value:"iam_user",displayName:"IAM User"},{value:"assumed_role",displayName:"Assumed Role"},{value:"federation_token",displayName:"Federation Token"},{value:"session_token",displayName:"Session Token"}],readOnly:!0}),a=(0,t.attr)("string",{label:"Role ARN",helpText:"The ARN of the role to assume if credential_type on the Vault role is assumed_role. Optional if the role has a single role ARN; required otherwise."}),o=(0,t.attr)({editType:"ttl",defaultValue:"3600s",setDefault:!0,ttlOffValue:"",label:"TTL",helpText:"Specifies the TTL for the use of the STS token. Valid only when credential_type is assumed_role, federation_token, or session_token."}),s=(0,t.attr)("string"),u=(0,t.attr)("boolean"),c=(0,t.attr)("number"),d=(0,t.attr)("string"),p=(0,t.attr)("string",{masked:!0}),f=(0,t.attr)("string",{masked:!0}),l((h=class extends t.default{constructor(...e){super(...e),O(this,"role",b,this),O(this,"credentialType",y,this),O(this,"roleArn",v,this),O(this,"ttl",g,this),O(this,"leaseId",w,this),O(this,"renewable",k,this),O(this,"leaseDuration",x,this),O(this,"accessKey",P,this),O(this,"secretKey",_,this),O(this,"securityToken",T,this)}get toCreds(){const e={accessKey:this.accessKey,secretKey:this.secretKey,securityToken:this.securityToken,leaseId:this.leaseId},t=Object.keys(e).reduce(((t,n)=>e[n]?(t[n]=e[n],t):t),{})
return JSON.stringify(t,null,2)}},b=j(h.prototype,"role",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=j(h.prototype,"credentialType",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=j(h.prototype,"roleArn",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=j(h.prototype,"ttl",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=j(h.prototype,"leaseId",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=j(h.prototype,"renewable",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=j(h.prototype,"leaseDuration",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=j(h.prototype,"accessKey",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=j(h.prototype,"secretKey",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=j(h.prototype,"securityToken",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=h))||m)})),define("vault/models/aws/lease-config",["exports","@ember-data/model","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l){var i,r,a,o,s,u,c,d,p
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h={lease:[{validator(e){const{lease:t,leaseMax:n}=e
return!!(t&&n||!t&&!n)},message:"Lease TTL and Max Lease TTL are both required if one of them is set."}]}
e.default=(i=(0,l.withModelValidations)(h),r=(0,t.attr)("string"),a=(0,t.attr)({label:"Max Lease TTL",editType:"ttl"}),o=(0,t.attr)({label:"Default Lease TTL",editType:"ttl"}),i((u=class extends t.default{constructor(...e){super(...e),f(this,"backend",c,this),f(this,"leaseMax",d,this),f(this,"lease",p,this)}get attrs(){return(0,n.expandAttributeMeta)(this,["lease","leaseMax"])}},c=m(u.prototype,"backend",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(u.prototype,"leaseMax",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(u.prototype,"lease",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=u))||s)})),define("vault/models/aws/root-config",["exports","@ember-data/model","vault/utils/field-to-attrs","vault/helpers/aws-regions"],(function(e,t,n,l){var i,r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_
function T(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function O(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=(0,t.attr)("string"),r=(0,t.attr)("string"),a=(0,t.attr)("string",{sensitive:!0}),o=(0,t.attr)("string",{label:"Role ARN",subText:"Role ARN to assume for plugin workload identity federation."}),s=(0,t.attr)("string",{subText:"The audience claim value for plugin identity tokens. Must match an allowed audience configured for the target IAM OIDC identity provider."}),u=(0,t.attr)({label:"Identity token TTL",helperTextDisabled:"The TTL of generated tokens. Defaults to 1 hour, turn on the toggle to specify a different value.",helperTextEnabled:"The TTL of generated tokens.",subText:"",editType:"ttl"}),c=(0,t.attr)("string",{possibleValues:(0,l.regions)(),subText:"Specifies the AWS region. If not set it will use the AWS_REGION env var, AWS_DEFAULT_REGION env var, or us-east-1 in that order."}),d=(0,t.attr)("string",{label:"IAM endpoint"}),p=(0,t.attr)("string",{label:"STS endpoint"}),f=(0,t.attr)("number",{label:"Maximum retries",subText:"Number of max retries the client should use for recoverable errors. Default is -1."}),m=class extends t.default{constructor(...e){super(...e),T(this,"backend",h,this),T(this,"accessKey",b,this),T(this,"secretKey",y,this),T(this,"roleArn",v,this),T(this,"identityTokenAudience",g,this),T(this,"identityTokenTtl",w,this),T(this,"region",k,this),T(this,"iamEndpoint",x,this),T(this,"stsEndpoint",P,this),T(this,"maxRetries",_,this)}get attrs(){return(0,n.expandAttributeMeta)(this,["roleArn","identityTokenAudience","identityTokenTtl","accessKey","region","iamEndpoint","stsEndpoint","maxRetries"])}get fieldGroupsWif(){return(0,n.default)(this,this.formFieldGroups("wif"))}get fieldGroupsIam(){return(0,n.default)(this,this.formFieldGroups("iam"))}formFieldGroups(e="iam"){const t=[]
return"wif"===e&&t.push({default:["roleArn","identityTokenAudience","identityTokenTtl"]}),"iam"===e&&t.push({default:["accessKey","secretKey"]}),t.push({"Root config options":["region","iamEndpoint","stsEndpoint","maxRetries"]}),t}},h=O(m.prototype,"backend",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=O(m.prototype,"accessKey",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=O(m.prototype,"secretKey",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=O(m.prototype,"roleArn",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=O(m.prototype,"identityTokenAudience",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=O(m.prototype,"identityTokenTtl",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=O(m.prototype,"region",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=O(m.prototype,"iamEndpoint",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=O(m.prototype,"stsEndpoint",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=O(m.prototype,"maxRetries",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m)})),define("vault/models/capabilities",["exports","@ember-data/model","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.SUDO_PATH_PREFIXES=e.SUDO_PATHS=void 0
const l=e.SUDO_PATHS=["sys/seal","sys/replication/performance/primary/secondary-token","sys/replication/dr/primary/secondary-token","sys/replication/reindex","sys/leases/lookup/"],i=e.SUDO_PATH_PREFIXES=["sys/leases/revoke-prefix","sys/leases/revoke-force"],r=function(e){return(0,n.computed)("path","capabilities","capabilities.[]",(function(){const t=this.capabilities,n=this.path
return!!t&&(!!t.includes("root")||!t.includes("deny")&&(l.includes(n)||i.find((e=>n.startsWith(e)))?t.includes("sudo")&&t.includes(e):t.includes(e)))}))}
e.default=t.default.extend({path:(0,t.attr)("string"),capabilities:(0,t.attr)("array"),allowedParameters:(0,t.attr)(),deniedParameters:(0,t.attr)(),canCreate:r("create"),canDelete:r("delete"),canList:r("list"),canPatch:r("patch"),canRead:r("read"),canSudo:r("sudo"),canUpdate:r("update")})})),define("vault/models/clients/activity",["exports","@ember-data/model"],(function(e,t){var n,l,i,r,a,o,s,u,c,d,p,f,m
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.attr)("array"),l=(0,t.attr)("array"),i=(0,t.attr)("object"),r=(0,t.attr)("string"),a=(0,t.attr)("string"),o=(0,t.attr)("string"),s=class extends t.default{constructor(...e){super(...e),h(this,"byMonth",u,this),h(this,"byNamespace",c,this),h(this,"total",d,this),h(this,"startTime",p,this),h(this,"endTime",f,this),h(this,"responseTimestamp",m,this)}},u=b(s.prototype,"byMonth",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(s.prototype,"byNamespace",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(s.prototype,"total",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(s.prototype,"startTime",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(s.prototype,"endTime",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=b(s.prototype,"responseTimestamp",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s)})),define("vault/models/clients/config",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x
function P(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function _(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const T={retentionMonths:[{validator:e=>parseInt(e.retentionMonths)>=e.minimumRetentionMonths,message:e=>`Retention period must be greater than or equal to ${e.minimumRetentionMonths}.`},{validator:e=>parseInt(e.retentionMonths)<=60,message:"Retention period must be less than or equal to 60."}]}
e.default=(r=(0,i.withModelValidations)(T),a=(0,l.withFormFields)(["enabled","retentionMonths"]),o=(0,t.attr)("boolean"),s=(0,t.attr)("number",{label:"Retention period",subText:"The number of months of activity logs to maintain for client tracking."}),u=(0,t.attr)("number"),c=(0,t.attr)("string"),d=(0,t.attr)("boolean"),p=(0,t.attr)("date"),f=(0,n.default)(n.apiPath`sys/internal/counters/config`),r(m=a((h=class extends t.default{constructor(...e){super(...e),P(this,"queriesAvailable",b,this),P(this,"retentionMonths",y,this),P(this,"minimumRetentionMonths",v,this),P(this,"enabled",g,this),P(this,"reportingEnabled",w,this),P(this,"billingStartTimestamp",k,this),P(this,"configPath",x,this)}get canRead(){return!1!==this.configPath.get("canRead")}get canEdit(){return!1!==this.configPath.get("canUpdate")}},b=_(h.prototype,"queriesAvailable",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=_(h.prototype,"retentionMonths",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=_(h.prototype,"minimumRetentionMonths",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=_(h.prototype,"enabled",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=_(h.prototype,"reportingEnabled",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=_(h.prototype,"billingStartTimestamp",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=_(h.prototype,"configPath",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=h))||m)||m)})),define("vault/models/clients/version-history",["exports","@ember-data/model"],(function(e,t){var n,l,i,r,a,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.attr)("string"),l=(0,t.attr)("string"),i=(0,t.attr)("string"),r=class extends t.default{constructor(...e){super(...e),u(this,"version",a,this),u(this,"previousVersion",o,this),u(this,"timestampInstalled",s,this)}},a=c(r.prototype,"version",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=c(r.prototype,"previousVersion",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(r.prototype,"timestampInstalled",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r)})),define("vault/models/cluster",["exports","@ember-data/model","@ember/service","@ember/object"],(function(e,t,n,l){var i,r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M
function S(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function C(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=(0,t.hasMany)("nodes",{async:!1,inverse:null}),r=(0,t.attr)("string"),a=(0,t.attr)("string"),o=(0,t.attr)("boolean"),s=(0,t.attr)("string"),u=(0,t.attr)("object"),c=(0,t.attr)("boolean"),d=(0,t.attr)("boolean"),p=(0,t.attr)("string"),f=(0,t.belongsTo)("replication-attributes",{async:!1,inverse:null}),m=(0,t.belongsTo)("replication-attributes",{async:!1,inverse:null}),h=(0,n.service)("replication-mode"),b=class extends t.default{constructor(...e){super(...e),S(this,"version",y,this),S(this,"nodes",v,this),S(this,"name",g,this),S(this,"status",w,this),S(this,"standby",k,this),S(this,"type",x,this),S(this,"license",P,this),S(this,"hasChrootNamespace",_,this),S(this,"replicationRedacted",T,this),S(this,"mode",O,this),S(this,"dr",j,this),S(this,"performance",z,this),S(this,"rm",M,this)}get licenseExpiry(){return this.license?.expiry_time}get licenseState(){return this.license?.state}get needsInit(){return this.nodes.every((e=>!1===e.initialized))}get unsealed(){return!!this.nodes.find((e=>!1===e.sealed))}get sealed(){return!this.unsealed}get leaderNode(){const e=this.nodes
return 1===e.length?e[0]:e.find((e=>!0===e.isLeader))}get sealThreshold(){return this.leaderNode?.sealThreshold}get sealProgress(){return this.leaderNode?.progress}get sealType(){return this.leaderNode?.type}get storageType(){return this.leaderNode?.storageType}get hcpLinkStatus(){return this.leaderNode?.hcpLinkStatus}get hasProgress(){return this.sealProgress>=1}get usingRaft(){return"raft"===this.storageType}get allReplicationDisabled(){return this.dr?.replicationDisabled&&this.performance?.replicationDisabled}get anyReplicationEnabled(){return this.dr?.replicationEnabled||this.performance?.replicationEnabled}get drMode(){return this.dr.mode}get replicationMode(){return this.rm.mode}get replicationModeForDisplay(){return"dr"===this.replicationMode?"Disaster Recovery":"Performance"}get replicationIsInitializing(){return!this.dr?.mode||!this.performance?.mode}get replicationAttrs(){const e=this.replicationMode
return e?(0,l.get)(this,e):null}},y=C(b.prototype,"version",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=C(b.prototype,"nodes",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=C(b.prototype,"name",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=C(b.prototype,"status",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=C(b.prototype,"standby",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=C(b.prototype,"type",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=C(b.prototype,"license",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=C(b.prototype,"hasChrootNamespace",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=C(b.prototype,"replicationRedacted",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=C(b.prototype,"mode",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=C(b.prototype,"dr",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=C(b.prototype,"performance",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=C(b.prototype,"rm",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b)})),define("vault/models/config-ui/message",["exports","@ember-data/model","vault/macros/lazy-capabilities","date-fns","vault/decorators/model-validations","vault/decorators/model-form-fields"],(function(e,t,n,l,i,r){var a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M
function S(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function C(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const A={title:[{type:"presence",message:"Title is required."}],message:[{type:"presence",message:"Message is required."}],link:[{validator(e){if(!e?.link)return!0
const[t]=Object.keys(e.link),[n]=Object.values(e.link)
return!t&&!n||!(!t||!n)},message:"Link title and url are required."}],startTime:[{validator(e){if(!e.endTime)return!0
const t=new Date(e.startTime),n=new Date(e.endTime)
return(0,l.isBefore)(t,n)},message:"Start time is after end time."}],endTime:[{validator(e){if(!e.endTime)return!0
const t=new Date(e.startTime),n=new Date(e.endTime)
return(0,l.isAfter)(n,t)},message:"End time is before start time."}]}
e.default=(a=(0,i.withModelValidations)(A),o=(0,r.withFormFields)(["authenticated","type","title","message","link","startTime","endTime"]),s=(0,t.attr)("boolean"),u=(0,t.attr)("string",{label:"Type",editType:"radio",possibleValues:[{label:"Alert message",subText:"A banner that appears on the top of every page to display brief but high-signal messages like an update or system alert.",value:"banner"},{label:"Modal",subText:"A pop-up window used to bring immediate attention for important notifications or actions.",value:"modal"}],defaultValue:"banner"}),c=(0,t.attr)({label:"Where should we display this message?",editType:"radio",fieldValue:"authenticatedString",possibleValues:[{label:"After the user logs in",subText:"Display to users after they have successfully logged in to Vault.",value:"authenticated"},{label:"On the login page",subText:"Display to users on the login page before they have authenticated.",value:"unauthenticated"}],defaultValue:!0}),d=(0,t.attr)("string"),p=(0,t.attr)("string",{editType:"textarea"}),f=(0,t.attr)("dateTimeLocal",{editType:"dateTimeLocal",label:"Message starts",subText:"Defaults to 12:00 a.m. the following day (local timezone).",defaultValue:(0,l.addDays)((0,l.startOfDay)(new Date),1).toISOString()}),m=(0,t.attr)("dateTimeLocal",{editType:"yield",label:"Message expires"}),h=(0,t.attr)("object",{editType:"kv",keyPlaceholder:"Display text (e.g. Learn more)",valuePlaceholder:"Link URL (e.g. https://www.hashicorp.com/)",label:"Link (optional)",isSingleRow:!0,allowWhiteSpace:!0}),b=(0,n.default)(n.apiPath`sys/config/ui/custom-messages`),y=(0,n.default)(n.apiPath`sys/config/ui/custom-messages/${"id"}`,"id"),a(v=o((g=class extends t.default{constructor(...e){super(...e),S(this,"active",w,this),S(this,"type",k,this),S(this,"authenticated",x,this),S(this,"title",P,this),S(this,"message",_,this),S(this,"startTime",T,this),S(this,"endTime",O,this),S(this,"link",j,this),S(this,"customMessagesPath",z,this),S(this,"customMessagePath",M,this)}get authenticatedString(){return this.authenticated?"authenticated":"unauthenticated"}set authenticatedString(e){this.authenticated="authenticated"===e}get isStartTimeAfterToday(){return(0,l.isAfter)((0,l.parseISO)(this.startTime),new Date)}get canCreateCustomMessages(){return!1!==this.customMessagesPath.get("canCreate")}get canReadCustomMessages(){return!1!==this.customMessagePath.get("canRead")}get canEditCustomMessages(){return!1!==this.customMessagePath.get("canUpdate")}get canDeleteCustomMessages(){return!1!==this.customMessagePath.get("canDelete")}},w=C(g.prototype,"active",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=C(g.prototype,"type",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=C(g.prototype,"authenticated",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=C(g.prototype,"title",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=C(g.prototype,"message",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=C(g.prototype,"startTime",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=C(g.prototype,"endTime",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=C(g.prototype,"link",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=C(g.prototype,"customMessagesPath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=C(g.prototype,"customMessagePath",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=g))||v)||v)})),define("vault/models/control-group-config",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({fields:(0,l.computed)((function(){return(0,r.expandAttributeMeta)(this,["maxTtl"])})),configurePath:(0,i.default)(i.apiPath`sys/config/control-group`),canDelete:(0,n.alias)("configurePath.canDelete"),maxTtl:(0,t.attr)({defaultValue:0,editType:"ttl",label:"Maximum TTL"})})})),define("vault/models/control-group",["exports","@ember-data/model","@ember/object/computed","vault/macros/lazy-capabilities"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({approved:(0,t.attr)("boolean"),requestPath:(0,t.attr)("string"),requestEntity:(0,t.belongsTo)("identity/entity",{async:!1,inverse:null}),authorizations:(0,t.hasMany)("identity/entity",{async:!1,inverse:null}),authorizePath:(0,l.default)(l.apiPath`sys/control-group/authorize`),canAuthorize:(0,n.alias)("authorizePath.canUpdate"),configurePath:(0,l.default)(l.apiPath`sys/config/control-group`),canConfigure:(0,n.alias)("configurePath.canUpdate")})})),define("vault/models/database/connection",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/utils/database-helpers","@ember/service"],(function(e,t,n,l,i,r,a,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({version:(0,o.service)(),backend:(0,t.attr)("string",{readOnly:!0}),name:(0,t.attr)("string",{label:"Connection name"}),plugin_name:(0,t.attr)("string",{label:"Database plugin",possibleValues:a.AVAILABLE_PLUGIN_TYPES,noDefault:!0}),verify_connection:(0,t.attr)("boolean",{label:"Connection will be verified",defaultValue:!0}),allowed_roles:(0,t.attr)("array"),password_policy:(0,t.attr)("string",{label:"Use custom password policy",editType:"optionalText",subText:"Specify the name of an existing password policy.",defaultSubText:"Unless a custom policy is specified, Vault will use a default: 20 characters with at least 1 uppercase, 1 lowercase, 1 number, and 1 dash character.",defaultShown:"Default",docLink:"/vault/docs/concepts/password-policies"}),connection_url:(0,t.attr)("string",{label:"Connection URL",subText:"The connection string used to connect to the database. This allows for simple templating of username and password of the root user in the {{field_name}} format."}),url:(0,t.attr)("string",{label:"URL",subText:'The URL for Elasticsearch\'s API ("https://localhost:9200").'}),username:(0,t.attr)("string",{subText:'The name of the user to use as the "root" user when connecting to the database.'}),password:(0,t.attr)("string",{subText:"The password to use when connecting with the above username.",editType:"password"}),disable_escaping:(0,t.attr)("boolean",{defaultValue:!1,subText:"Turns off the escaping of special characters inside of the username and password fields.",docLink:"https://developer.hashicorp.com/vault/docs/secrets/databases#disable-character-escaping"}),ca_cert:(0,t.attr)("string",{label:"CA certificate",subText:"The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity."}),ca_path:(0,t.attr)("string",{label:"CA path",subText:"The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity."}),client_cert:(0,t.attr)("string",{label:"Client certificate",subText:"The path to the certificate for the Elasticsearch client to present for communication."}),client_key:(0,t.attr)("string",{subText:"The path to the key for the Elasticsearch client to use for communication."}),hosts:(0,t.attr)("string",{}),host:(0,t.attr)("string",{}),port:(0,t.attr)("string",{}),write_concern:(0,t.attr)("string",{subText:"Optional. Must be in JSON. See our documentation for help.",allowReset:!0,editType:"json",theme:"hashi short",defaultShown:"Default"}),username_template:(0,t.attr)("string",{editType:"optionalText",subText:"Enter the custom username template to use.",defaultSubText:"Template describing how dynamic usernames are generated. Vault will use the default for this plugin.",docLink:"/vault/docs/concepts/username-templating",defaultShown:"Default"}),max_open_connections:(0,t.attr)("number",{defaultValue:4}),max_idle_connections:(0,t.attr)("number",{defaultValue:0}),max_connection_lifetime:(0,t.attr)("string",{defaultValue:"0s"}),insecure:(0,t.attr)("boolean",{label:"Disable SSL verification",defaultValue:!1}),password_authentication:(0,t.attr)("string",{defaultValue:"password",editType:"radio",subText:'The default is "password."',possibleValues:[{value:"password",helpText:"Passwords will be sent to PostgreSQL in plaintext format and may appear in PostgreSQL logs as-is."},{value:"scram-sha-256",helpText:'When set to "scram-sha-256", passwords will be hashed by Vault and stored as-is by PostgreSQL. Using "scram-sha-256" requires a minimum version of PostgreSQL 10.'}],docLink:"https://developer.hashicorp.com/vault/api-docs/secret/databases/postgresql#password_authentication"}),auth_type:(0,t.attr)("string",{subText:'If set to "gcp_iam", will enable IAM authentication to a Google CloudSQL instance.',docLink:"https://developer.hashicorp.com/vault/api-docs/secret/databases/postgresql#auth_type"}),service_account_json:(0,t.attr)("string",{label:"Service account JSON",subText:'JSON encoded credentials for a GCP Service Account to use for IAM authentication. Requires "auth_type" to be "gcp_iam".',editType:"file"}),use_private_ip:(0,t.attr)("boolean",{label:"Use private IP",subText:'Enables the option to connect to CloudSQL Instances with Private IP. Requires auth_type to be "gcp_iam".',defaultValue:!1}),private_key:(0,t.attr)("string",{helpText:"The secret key used for the x509 client certificate. Must be PEM encoded.",editType:"file"}),tls:(0,t.attr)("string",{label:"TLS Certificate Key",helpText:"x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.",editType:"file"}),tls_certificate:(0,t.attr)("string",{label:"TLS Certificate Key",helpText:"The x509 certificate for connecting to the database. Must be PEM encoded.",editType:"file"}),tls_ca:(0,t.attr)("string",{label:"TLS CA",helpText:"x509 CA file for validating the certificate presented by the database server. Must be PEM encoded.",editType:"file"}),tls_server_name:(0,t.attr)("string",{label:"TLS server name",subText:"If set, this name is used to set the SNI host when connecting via 1TLS."}),root_rotation_statements:(0,t.attr)({subText:"The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",editType:"stringArray",defaultShown:"Default"}),self_managed:(0,t.attr)("boolean",{subText:"Allows onboarding static roles with a rootless connection configuration. Mutually exclusive with username and password. If true, will force verify_connection to be false.",defaultValue:!1}),isAvailablePlugin:(0,n.computed)("plugin_name",(function(){return!!a.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name))})),showAttrs:(0,n.computed)("plugin_name",(function(){const e=this._filterFields((e=>!1!==e.show)).map((e=>e.attr))
return e.push("allowed_roles"),(0,r.expandAttributeMeta)(this,e)})),fieldAttrs:(0,n.computed)("plugin_name",(function(){let e=["plugin_name","name","connection_url","verify_connection","password_policy"]
return this.plugin_name&&(e=this._filterFields((e=>!e.group)).map((e=>e.attr))),(0,r.expandAttributeMeta)(this,e)})),pluginFieldGroups:(0,n.computed)("plugin_name",(function(){if(!this.plugin_name)return null
const e=function(e,t="subgroup"){const n=[],l=e.reduce((function(e,n){return(e[n[t]]=e[n[t]]||[]).push(n),e}),{})
return Object.keys(l).forEach((e=>{const t=l[e].map((e=>e.attr)),i="undefined"===e?"default":e
n.push({[i]:t})})),n}(this._filterFields((e=>"pluginConfig"===e.group)),"subgroup")
return(0,r.default)(this,e)})),statementFields:(0,n.computed)("plugin_name",(function(){if(!this.plugin_name)return(0,r.expandAttributeMeta)(this,["root_rotation_statements"])
const e=this._filterFields((e=>"statements"===e.group)).map((e=>e.attr))
return(0,r.expandAttributeMeta)(this,e)})),_filterFields(e){return a.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name)).fields.filter((t=>!(t?.isEnterprise&&!this.version.isEnterprise)&&e(t)))},editConnectionPath:(0,i.default)(i.apiPath`${"backend"}/config/${"id"}`,"backend","id"),canEdit:(0,l.alias)("editConnectionPath.canUpdate"),canDelete:(0,l.alias)("editConnectionPath.canDelete"),resetConnectionPath:(0,i.default)(i.apiPath`${"backend"}/reset/${"id"}`,"backend","id"),canReset:(0,l.or)("resetConnectionPath.canUpdate","resetConnectionPath.canCreate"),rotateRootPath:(0,i.default)(i.apiPath`${"backend"}/rotate-root/${"id"}`,"backend","id"),canRotateRoot:(0,l.or)("rotateRootPath.canUpdate","rotateRootPath.canCreate"),rolePath:(0,i.default)(i.apiPath`${"backend"}/role/*`,"backend"),staticRolePath:(0,i.default)(i.apiPath`${"backend"}/static-role/*`,"backend"),canAddRole:(0,l.or)("rolePath.canCreate","staticRolePath.canCreate")})})),define("vault/models/database/credential",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({username:(0,t.attr)("string"),password:(0,t.attr)("string"),leaseId:(0,t.attr)("string"),leaseDuration:(0,t.attr)("string"),lastVaultRotation:(0,t.attr)("string"),rotationPeriod:(0,t.attr)("number"),ttl:(0,t.attr)("number"),roleType:(0,t.attr)("string")})})),define("vault/models/database/role",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/utils/database-helpers"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({idPrefix:"role/",backend:(0,t.attr)("string",{readOnly:!0}),name:(0,t.attr)("string",{label:"Role name"}),database:(0,t.attr)("array",{label:"Connection name",editType:"searchSelect",fallbackComponent:"string-list",models:["database/connection"],selectLimit:1,onlyAllowExisting:!0,subText:"The database connection for which credentials will be generated."}),type:(0,t.attr)("string",{label:"Type of role",noDefault:!0,possibleValues:["static","dynamic"]}),default_ttl:(0,t.attr)({editType:"ttl",defaultValue:"1h",label:"Generated credentials’s Time-to-Live (TTL)",helperTextDisabled:"Vault will use a TTL of 1 hour.",defaultShown:"Engine default"}),max_ttl:(0,t.attr)({editType:"ttl",defaultValue:"24h",label:"Generated credentials’s maximum Time-to-Live (Max TTL)",helperTextDisabled:"Vault will use a TTL of 24 hours.",defaultShown:"Engine default"}),username:(0,t.attr)("string",{subText:"The database username that this Vault role corresponds to."}),rotation_period:(0,t.attr)({editType:"ttl",defaultValue:"24h",helperTextDisabled:"Specifies the amount of time Vault should wait before rotating the password. The minimum is 5 seconds. Default is 24 hours.",helperTextEnabled:"Vault will rotate password after"}),creation_statements:(0,t.attr)("array",{editType:"stringArray"}),revocation_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),rotation_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),rollback_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),renew_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),creation_statement:(0,t.attr)("string",{editType:"json",allowReset:!0,theme:"hashi short",defaultShown:"Default"}),revocation_statement:(0,t.attr)("string",{editType:"json",allowReset:!0,theme:"hashi short",defaultShown:"Default"}),get fieldAttrs(){return(0,r.expandAttributeMeta)(this,["name","database","type"])},get showFields(){let e=["name","database","type"]
return e=e.concat((0,a.getRoleFields)(this.type)).concat(["creation_statements"]),"elasticsearch"!==this.database[0]&&(e=e.concat(["revocation_statements"])),(0,r.expandAttributeMeta)(this,e)},roleSettingAttrs:(0,n.computed)((function(){return(0,r.expandAttributeMeta)(this,["default_ttl","max_ttl","username","rotation_period","creation_statements","creation_statement","revocation_statements","revocation_statement","rotation_statements","rollback_statements","renew_statements"])})),path:(0,t.attr)("string",{readOnly:!0}),secretPath:(0,i.default)(i.apiPath`${"backend"}/${"path"}/${"id"}`,"backend","path","id"),canEditRole:(0,l.alias)("secretPath.canUpdate"),canDelete:(0,l.alias)("secretPath.canDelete"),dynamicPath:(0,i.default)(i.apiPath`${"backend"}/roles/+`,"backend"),canCreateDynamic:(0,l.alias)("dynamicPath.canCreate"),staticPath:(0,i.default)(i.apiPath`${"backend"}/static-roles/+`,"backend"),canCreateStatic:(0,l.alias)("staticPath.canCreate"),credentialPath:(0,i.default)(i.apiPath`${"backend"}/creds/${"id"}`,"backend","id"),staticCredentialPath:(0,i.default)(i.apiPath`${"backend"}/static-creds/${"id"}`,"backend","id"),canGenerateCredentials:(0,l.alias)("credentialPath.canRead"),canGetCredentials:(0,l.alias)("staticCredentialPath.canRead"),databasePath:(0,i.default)(i.apiPath`${"backend"}/config/${"database[0]"}`,"backend","database"),canUpdateDb:(0,l.alias)("databasePath.canUpdate"),rotateRolePath:(0,i.default)(i.apiPath`${"backend"}/rotate-role/${"id"}`,"backend","id"),canRotateRoleCredentials:(0,l.alias)("rotateRolePath.canUpdate")})})),define("vault/models/identity/_base",["exports","@ember-data/model","@ember/debug","@ember/object","vault/utils/field-to-attrs"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({formFields:(0,l.computed)((function(){return(0,n.assert)("formFields should be overridden",!1)})),fields:(0,l.computed)("formFields","formFields.[]",(function(){return(0,i.expandAttributeMeta)(this,this.formFields)})),identityType:(0,l.computed)("constructor.modelName",(function(){return this.constructor.modelName.split("/")[1]}))})})),define("vault/models/identity/entity-alias",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/models/identity/_base","vault/macros/identity-capabilities"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({parentType:"entity",formFields:(0,n.computed)((function(){return["name","mountAccessor"]})),entity:(0,t.belongsTo)("identity/entity",{readOnly:!0,async:!1,inverse:"aliases"}),name:(0,t.attr)("string"),canonicalId:(0,t.attr)("string"),mountAccessor:(0,t.attr)("string",{label:"Auth Backend",editType:"mountAccessor"}),metadata:(0,t.attr)({editType:"kv",isSectionHeader:!0}),mountPath:(0,t.attr)("string",{readOnly:!0}),mountType:(0,t.attr)("string",{readOnly:!0}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),mergedFromCanonicalIds:(0,t.attr)(),updatePath:(0,r.default)(),canDelete:(0,l.alias)("updatePath.canDelete"),canEdit:(0,l.alias)("updatePath.canUpdate")})})),define("vault/models/identity/entity-merge",["exports","@ember-data/model","@ember/object","vault/models/identity/_base"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=l.default.extend({formFields:(0,n.computed)((function(){return["toEntityId","fromEntityIds","force"]})),toEntityId:(0,t.attr)("string",{label:"Entity to merge to"}),fromEntityIds:(0,t.attr)({label:"Entities to merge from",editType:"stringArray"}),force:(0,t.attr)("boolean",{label:'Keep MFA secrets from the "to" entity if there are merge conflicts',defaultValue:!1})})})),define("vault/models/identity/entity",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/models/identity/_base","vault/utils/api-path","vault/macros/lazy-capabilities"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({formFields:(0,n.computed)((function(){return["name","disabled","policies","metadata"]})),name:(0,t.attr)("string"),disabled:(0,t.attr)("boolean",{defaultValue:!1,label:"Disable entity",helpText:"All associated tokens cannot be used, but are not revoked."}),mergedEntityIds:(0,t.attr)(),metadata:(0,t.attr)({editType:"kv",isSectionHeader:!0}),policies:(0,t.attr)({editType:"yield",isSectionHeader:!0}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),aliases:(0,t.hasMany)("identity/entity-alias",{async:!1,readOnly:!0,inverse:"entity"}),groupIds:(0,t.attr)({readOnly:!0}),directGroupIds:(0,t.attr)({readOnly:!0}),inheritedGroupIds:(0,t.attr)({readOnly:!0}),updatePath:(0,a.default)(r.default`identity/entity/id/${"id"}`,"id"),canDelete:(0,l.alias)("updatePath.canDelete"),canEdit:(0,l.alias)("updatePath.canUpdate"),canRead:(0,l.alias)("updatePath.canRead"),aliasPath:(0,a.default)(r.default`identity/entity-alias`),canAddAlias:(0,l.alias)("aliasPath.canCreate"),policyPath:(0,a.default)(r.default`sys/policies`),canCreatePolicies:(0,l.alias)("policyPath.canCreate")})})),define("vault/models/identity/group-alias",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/models/identity/_base","vault/macros/identity-capabilities"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({parentType:"group",formFields:(0,n.computed)((function(){return["name","mountAccessor"]})),group:(0,t.belongsTo)("identity/group",{readOnly:!0,async:!1,inverse:"alias"}),name:(0,t.attr)("string"),canonicalId:(0,t.attr)("string"),mountPath:(0,t.attr)("string",{readOnly:!0}),mountType:(0,t.attr)("string",{readOnly:!0}),mountAccessor:(0,t.attr)("string",{label:"Auth Backend",editType:"mountAccessor"}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),updatePath:(0,r.default)(),canDelete:(0,l.alias)("updatePath.canDelete"),canEdit:(0,l.alias)("updatePath.canUpdate")})})),define("vault/models/identity/group",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/models/identity/_base","vault/macros/lazy-capabilities","vault/macros/identity-capabilities"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({formFields:(0,l.computed)("type",(function(){const e=["name","type","policies","metadata"]
return"internal"===this.type?e.concat(["memberGroupIds","memberEntityIds"]):e})),name:(0,t.attr)("string"),type:(0,t.attr)("string",{defaultValue:"internal",possibleValues:["internal","external"]}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),numMemberEntities:(0,t.attr)("number",{readOnly:!0}),numParentGroups:(0,t.attr)("number",{readOnly:!0}),metadata:(0,t.attr)("object",{editType:"kv",isSectionHeader:!0}),policies:(0,t.attr)({editType:"yield",isSectionHeader:!0}),memberGroupIds:(0,t.attr)({label:"Member Group IDs",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",models:["identity/group"]}),parentGroupIds:(0,t.attr)({label:"Parent Group IDs",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",models:["identity/group"]}),memberEntityIds:(0,t.attr)({label:"Member Entity IDs",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",models:["identity/entity"]}),hasMembers:(0,l.computed)("memberEntityIds","memberEntityIds.[]","memberGroupIds","memberGroupIds.[]",(function(){const{memberEntityIds:e,memberGroupIds:t}=this
return(e&&e.length||0)+(t&&t.length||0)>0})),policyPath:(0,r.default)(r.apiPath`sys/policies`),canCreatePolicies:(0,n.alias)("policyPath.canCreate"),alias:(0,t.belongsTo)("identity/group-alias",{async:!1,readOnly:!0,inverse:"group"}),updatePath:(0,a.default)(),canDelete:(0,n.alias)("updatePath.canDelete"),canEdit:(0,n.alias)("updatePath.canUpdate"),aliasPath:(0,r.default)(r.apiPath`identity/group-alias`),canAddAlias:(0,n.alias)("aliasPath.canCreate")})})),define("vault/models/identity/oidc/config",["exports","@ember-data/model","vault/utils/field-to-attrs"],(function(e,t,n){var l,i,r
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=(0,t.attr)("string",{label:"Issuer",subText:"The Issuer URL to be used in configuring Vault as an identity provider in AWS. If not set, Vault's default issuer will be used",docLink:"/vault/api-docs/secret/identity/tokens#configure-the-identity-tokens-backend",placeholder:"https://vault-test.com"}),i=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="issuer",i=this,(l=r)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get attrs(){return(0,n.expandAttributeMeta)(this,["issuer"])}},a=i.prototype,o="issuer",s=[l],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},d={},Object.keys(u).forEach((function(e){d[e]=u[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=s.slice().reverse().reduce((function(e,t){return t(a,o,e)||e}),d),c&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(c):void 0,d.initializer=void 0),r=void 0===d.initializer?(Object.defineProperty(a,o,d),null):d,i)
var a,o,s,u,c,d})),define("vault/models/keymgmt/key",["exports","@ember-data/model","vault/utils/field-to-attrs","vault/macros/lazy-capabilities"],(function(e,t,n,l){var i,r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A
function E(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function R(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function D(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.KEY_TYPES=void 0
const N=e.KEY_TYPES=["aes256-gcm96","rsa-2048","rsa-3072","rsa-4096","ecdsa-p256","ecdsa-p384","ecdsa-p521"]
e.default=(i=(0,t.attr)("string",{label:"Key name",subText:"This is the name of the key that shows in Vault."}),r=(0,t.attr)("string"),a=(0,t.attr)("string",{subText:"The type of cryptographic key that will be created.",possibleValues:N,defaultValue:"rsa-2048"}),o=(0,t.attr)("boolean",{label:"Allow deletion",defaultValue:!1}),s=(0,t.attr)("number",{label:"Current version"}),u=(0,t.attr)("number",{defaultValue:0,defaultShown:"All versions enabled"}),c=(0,t.attr)("array"),d=(0,t.attr)("date"),p=(0,t.attr)("date",{defaultShown:"Not yet rotated"}),f=(0,t.attr)(),m=(0,t.attr)(),h=(0,l.default)(l.apiPath`${"backend"}/key/${"id"}`,"backend","id"),b=(0,l.default)(l.apiPath`${"backend"}/key`,"backend"),y=(0,l.default)(l.apiPath`${"backend"}/key/${"id"}/kms`,"backend","id"),v=class extends t.default{constructor(...e){super(...e),E(this,"name",g,this),E(this,"backend",w,this),E(this,"type",k,this),E(this,"deletionAllowed",x,this),E(this,"latestVersion",P,this),E(this,"minEnabledVersion",_,this),E(this,"versions",T,this),E(this,"created",O,this),E(this,"lastRotated",j,this),E(this,"provider",z,this),E(this,"distribution",M,this),R(this,"icon","key"),E(this,"keyPath",S,this),E(this,"keysPath",C,this),E(this,"keyProvidersPath",A,this)}get hasVersions(){return this.versions.length>1}get createFields(){return(0,n.expandAttributeMeta)(this,["name","type","deletionAllowed"])}get updateFields(){return(0,n.expandAttributeMeta)(this,["minEnabledVersion","deletionAllowed"])}get showFields(){return(0,n.expandAttributeMeta)(this,["name","created","type","deletionAllowed","latestVersion","minEnabledVersion","lastRotated"])}get keyTypeOptions(){return(0,n.expandAttributeMeta)(this,["type"])[0]}get distFields(){return[{name:"name",type:"string",label:"Distributed name",subText:"The name given to the key by the provider."},{name:"purpose",type:"string",label:"Key Purpose"},{name:"protection",type:"string",subText:"Where cryptographic operations are performed."}]}get canCreate(){return this.keyPath.get("canCreate")}get canDelete(){return this.keyPath.get("canDelete")}get canEdit(){return this.keyPath.get("canUpdate")}get canRead(){return this.keyPath.get("canRead")}get canList(){return this.keysPath.get("canList")}get canListProviders(){return this.keyProvidersPath.get("canList")}},g=D(v.prototype,"name",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=D(v.prototype,"backend",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=D(v.prototype,"type",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=D(v.prototype,"deletionAllowed",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=D(v.prototype,"latestVersion",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=D(v.prototype,"minEnabledVersion",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=D(v.prototype,"versions",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=D(v.prototype,"created",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=D(v.prototype,"lastRotated",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=D(v.prototype,"provider",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=D(v.prototype,"distribution",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=D(v.prototype,"keyPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=D(v.prototype,"keysPath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=D(v.prototype,"keyProvidersPath",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v)})),define("vault/models/keymgmt/provider",["exports","@ember-data/model","@glimmer/tracking","vault/utils/field-to-attrs","vault/decorators/model-validations","vault/macros/lazy-capabilities","@ember/service"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O
function j(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function z(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function M(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const S={azurekeyvault:["client_id","client_secret","tenant_id"],awskms:["access_key","secret_key","session_token","endpoint"],gcpckms:["service_account_file"]},C=["session_token","endpoint"],A={name:[{type:"presence",message:"Provider name is required"}],keyCollection:[{type:"presence",message:"Key Vault instance name"}],...Object.keys(S).reduce(((e,t)=>(S[t].forEach((t=>{C.includes(t)||(e[`credentials.${t}`]=[{message:`${t} is required`,validator:e=>!e.credentialProps.includes(t)||e.credentials[t]}])})),e)),{})}
e.default=(o=(0,i.withModelValidations)(A),s=(0,t.attr)("string"),u=(0,t.attr)("string",{label:"Provider name",subText:"This is the name of the provider that will be displayed in Vault. This cannot be edited later."}),c=(0,t.attr)("string",{label:"Type",subText:"Choose the provider type.",possibleValues:["azurekeyvault","awskms","gcpckms"],noDefault:!0}),d=(0,t.attr)("string",{label:"Key Vault instance name",subText:"The name of a Key Vault instance must be supplied. This cannot be edited later."}),p=(0,r.default)(r.apiPath`${"backend"}/kms/${"id"}`,"backend","id"),f=(0,r.default)(r.apiPath`${"backend"}/kms`,"backend"),m=(0,r.default)(r.apiPath`${"backend"}/kms/${"id"}/key`,"backend","id"),o((b=class extends t.default{constructor(...e){super(...e),j(this,"store",y,this),j(this,"backend",v,this),j(this,"name",g,this),j(this,"provider",w,this),j(this,"keyCollection",k,this),z(this,"idPrefix","provider/"),z(this,"type","provider"),j(this,"keys",x,this),j(this,"credentials",P,this),j(this,"providerPath",_,this),j(this,"providersPath",T,this),j(this,"providerKeysPath",O,this)}get icon(){return{azurekeyvault:"azure-color",awskms:"aws-color",gcpckms:"gcp-color"}[this.provider]}get typeName(){return{azurekeyvault:"Azure Key Vault",awskms:"AWS Key Management Service",gcpckms:"Google Cloud Key Management Service"}[this.provider]}get showFields(){const e=(0,l.expandAttributeMeta)(this,["name","keyCollection"])
e.splice(1,0,{hasBlock:!0,label:"Type",value:this.typeName,icon:this.icon})
const t=this.keys.length,n=t?`${t} ${t>1?"keys":"key"}`:this.canListKeys?"None":"You do not have permission to list keys"
return e.push({hasBlock:!0,isLink:t,label:"Keys",value:n}),e}get credentialProps(){return this.provider?S[this.provider]:[]}get credentialFields(){const[e,t]=this.credentialProps.reduce((([e,t],n)=>{e[n]=null
const l={name:`credentials.${n}`,type:"string",options:{label:n}}
return"service_account_file"===n&&(l.options.subText="The path to a Google service account key file, not the file itself."),t.push(l),[e,t]}),[{},[]])
return this.credentials=e,t}get createFields(){return(0,l.expandAttributeMeta)(this,["provider","name","keyCollection"])}async fetchKeys(e){if(!1===this.canListKeys)this.keys=[]
else try{this.keys=await this.store.lazyPaginatedQuery("keymgmt/key",{backend:this.backend,provider:this.name,responsePath:"data.keys",page:Number(e)||1})}catch(t){if(this.keys=[],404!==t.httpStatus)throw t}}get canCreate(){return this.providerPath.get("canCreate")}get canDelete(){return this.providerPath.get("canDelete")}get canEdit(){return this.providerPath.get("canUpdate")}get canRead(){return this.providerPath.get("canRead")}get canList(){return this.providersPath.get("canList")}get canListKeys(){return this.providerKeysPath.get("canList")}get canCreateKeys(){return this.providerKeysPath.get("canCreate")}},y=M(b.prototype,"store",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=M(b.prototype,"backend",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=M(b.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=M(b.prototype,"provider",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=M(b.prototype,"keyCollection",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=M(b.prototype,"keys",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),P=M(b.prototype,"credentials",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),_=M(b.prototype,"providerPath",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=M(b.prototype,"providersPath",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=M(b.prototype,"providerKeysPath",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=b))||h)})),define("vault/models/kmip/ca",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({config:(0,t.belongsTo)("kmip/config",{async:!1,inverse:"ca"}),caPem:(0,t.attr)("string",{label:"CA PEM"})})})),define("vault/models/kmip/config",["exports","@ember-data/model","@ember/object","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({ca:(0,t.belongsTo)("kmip/ca",{async:!1,inverse:"config"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["listenAddrs","connectionTimeout"]}]
return e=(0,l.combineFieldGroups)(e,this.newFields,[]),(0,i.default)(this,e)}))})}))
define("vault/models/kmip/credential",["exports","@ember-data/model","vault/utils/field-to-attrs","@ember/object","vault/utils/api-path","vault/macros/lazy-capabilities"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({backend:(0,t.attr)({readOnly:!0}),scope:(0,t.attr)({readOnly:!0}),role:(0,t.attr)({readOnly:!0}),certificate:(0,t.attr)("string",{readOnly:!0}),caChain:(0,t.attr)({readOnly:!0}),privateKey:(0,t.attr)("string",{readOnly:!0,sensitive:!0}),format:(0,t.attr)("string",{possibleValues:["pem","der","pem_bundle"],defaultValue:"pem",label:"Certificate format"}),fieldGroups:(0,l.computed)((function(){return(0,n.default)(this,[{default:["format"]}])})),deletePath:(0,r.default)(i.default`${"backend"}/scope/${"scope"}/role/${"role"}/credentials/revoke`,"backend","scope","role")})})),define("vault/models/kmip/role",["exports","@ember-data/model","@ember/object","vault/utils/field-to-attrs","vault/utils/api-path","vault/macros/lazy-capabilities","vault/helpers/remove-from-array"],(function(e,t,n,l,i,r,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o={operationFields:(0,n.computed)("newFields",(function(){return this.newFields.filter((e=>e.startsWith("operation")))})),operationFieldsWithoutSpecial:(0,n.computed)("operationFields",(function(){return(0,a.removeManyFromArray)(this.operationFields,["operationAll","operationNone"])})),tlsFields:(0,n.computed)((function(){return["tlsClientKeyBits","tlsClientKeyType","tlsClientTtl"]})),defaultFields:(0,n.computed)("newFields","operationFields","tlsFields",(function(){const e=["role"].concat(this.operationFields,this.tlsFields)
return(0,a.removeManyFromArray)(this.newFields,e)})),nonOperationFields:(0,n.computed)("newFields","operationFields",(function(){return(0,a.removeManyFromArray)(this.newFields,this.operationFields)}))}
e.default=t.default.extend(o,{backend:(0,t.attr)({readOnly:!0}),scope:(0,t.attr)({readOnly:!0}),name:(0,t.attr)({readOnly:!0}),fieldGroups:(0,n.computed)("fields","defaultFields.length","tlsFields",(function(){const e=[{TLS:this.tlsFields}]
this.defaultFields.length&&e.unshift({default:this.defaultFields})
return(0,l.default)(this,e)})),operationFormFields:(0,n.computed)("operationFieldsWithoutSpecial",(function(){const e=["operationCreate","operationActivate","operationGet","operationLocate","operationRekey","operationRevoke","operationDestroy"],t=["operationAddAttribute","operationGetAttributes"],n=["operationDiscoverVersions"],i=(0,a.removeManyFromArray)(this.operationFieldsWithoutSpecial,[...e,...t,...n]),r=[{"Managed Cryptographic Objects":e},{"Object Attributes":t},{Server:n}]
return i.length&&r.push({Other:i}),(0,l.default)(this,r)})),tlsFormFields:(0,n.computed)("tlsFields",(function(){return(0,l.expandAttributeMeta)(this,this.tlsFields)})),fields:(0,n.computed)("defaultFields",(function(){return(0,l.expandAttributeMeta)(this,this.defaultFields)})),updatePath:(0,r.default)(i.default`${"backend"}/scope/${"scope"}/role/${"id"}`,"backend","scope","id")})})),define("vault/models/kmip/scope",["exports","@ember-data/model","@ember/object","vault/utils/api-path","vault/utils/field-to-attrs","vault/macros/lazy-capabilities"],(function(e,t,n,l,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({name:(0,t.attr)("string"),backend:(0,t.attr)({readOnly:!0}),attrs:(0,n.computed)((function(){return(0,i.expandAttributeMeta)(this,["name"])})),updatePath:(0,r.default)(l.default`${"backend"}/scope/${"id"}`,"backend","id")})})),define("vault/models/kubernetes/config",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l){var i,r,a,o,s,u,c,d,p,f,m,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=(0,l.withModelValidations)({kubernetesHost:[{validator:e=>!(e.disableLocalCaJwt&&!e.kubernetesHost),message:"Kubernetes host is required"}]}),r=(0,n.withFormFields)(["kubernetesHost","serviceAccountJwt","kubernetesCaCert"]),a=(0,t.attr)("string"),o=(0,t.attr)("string",{label:"Kubernetes host",subText:"Kubernetes API URL to connect to."}),s=(0,t.attr)("string",{label:"Service account JWT",subText:"The JSON web token of the service account used by the secret engine to manage Kubernetes roles. Defaults to the local pod’s JWT if found."}),u=(0,t.attr)("string",{label:"Kubernetes CA Certificate",subText:"PEM-encoded CA certificate to use by the secret engine to verify the Kubernetes API server certificate. Defaults to the local pod’s CA if found.",editType:"textarea"}),c=(0,t.attr)("boolean",{defaultValue:!1}),i(d=r((p=class extends t.default{constructor(...e){super(...e),v(this,"backend",f,this),v(this,"kubernetesHost",m,this),v(this,"serviceAccountJwt",h,this),v(this,"kubernetesCaCert",b,this),v(this,"disableLocalCaJwt",y,this)}},f=g(p.prototype,"backend",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=g(p.prototype,"kubernetesHost",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=g(p.prototype,"serviceAccountJwt",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=g(p.prototype,"kubernetesCaCert",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=g(p.prototype,"disableLocalCaJwt",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p))||d)||d)})),define("vault/models/kubernetes/role",["exports","@ember-data/model","vault/decorators/model-validations","vault/decorators/model-form-fields","vault/macros/lazy-capabilities","@glimmer/tracking"],(function(e,t,n,l,i,r){var a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I
function L(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function U(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(a=(0,n.withModelValidations)({name:[{type:"presence",message:"Name is required"}]}),o=(0,l.withFormFields)(["name","serviceAccountName","kubernetesRoleType","kubernetesRoleName","allowedKubernetesNamespaces","tokenMaxTtl","tokenDefaultTtl","nameTemplate"]),s=(0,t.attr)("string"),u=(0,t.attr)("string",{label:"Role name",subText:"The role’s name in Vault."}),c=(0,t.attr)("string",{label:"Service account name",subText:"Vault will use the default template when generating service accounts, roles and role bindings."}),d=(0,t.attr)("string",{label:"Kubernetes role type",editType:"radio",possibleValues:["Role","ClusterRole"]}),p=(0,t.attr)("string",{label:"Kubernetes role name",subText:"Vault will use the default template when generating service accounts, roles and role bindings."}),f=(0,t.attr)("string",{label:"Allowed Kubernetes namespaces",subText:'A list of the valid Kubernetes namespaces in which this role can be used for creating service accounts. If set to "*" all namespaces are allowed.'}),m=(0,t.attr)({label:"Max Lease TTL",editType:"ttl"}),h=(0,t.attr)({label:"Default Lease TTL",editType:"ttl"}),b=(0,t.attr)("string",{label:"Name template",editType:"optionalText",defaultSubText:"Vault will use the default template when generating service accounts, roles and role bindings.",subText:"Vault will use the default template when generating service accounts, roles and role bindings."}),y=(0,t.attr)("string"),v=(0,i.default)(i.apiPath`${"backend"}/roles/${"name"}`,"backend","name"),g=(0,i.default)(i.apiPath`${"backend"}/creds/${"name"}`,"backend","name"),w=(0,i.default)(i.apiPath`${"backend"}/roles`,"backend"),a(k=o((x=class extends t.default{constructor(...e){super(...e),L(this,"backend",P,this),L(this,"name",_,this),L(this,"serviceAccountName",T,this),L(this,"kubernetesRoleType",O,this),L(this,"kubernetesRoleName",j,this),L(this,"allowedKubernetesNamespaces",z,this),L(this,"tokenMaxTtl",M,this),L(this,"tokenDefaultTtl",S,this),L(this,"nameTemplate",C,this),L(this,"extraAnnotations",A,this),L(this,"extraLabels",E,this),L(this,"generatedRoleRules",R,this),L(this,"_generationPreference",D,this),L(this,"rolePath",N,this),L(this,"credsPath",F,this),L(this,"rolesPath",I,this)}get generationPreference(){if(this._generationPreference)return this._generationPreference
let e=null
return this.serviceAccountName?e="basic":this.kubernetesRoleName?e="expanded":this.generatedRoleRules&&(e="full"),e}set generationPreference(e){({basic:["kubernetesRoleType","kubernetesRoleName","generatedRoleRules","nameTemplate"],expanded:["serviceAccountName","generatedRoleRules"],full:["serviceAccountName","kubernetesRoleName"]})[e].forEach((e=>this[e]=null)),this._generationPreference=e}get filteredFormFields(){const e={basic:[2,3,7],expanded:[1],full:[1,3]}[this.generationPreference]
return e?this.formFields.filter(((t,n)=>!e.includes(n))):null}get canCreate(){return this.rolePath.get("canCreate")}get canDelete(){return this.rolePath.get("canDelete")}get canEdit(){return this.rolePath.get("canUpdate")}get canRead(){return this.rolePath.get("canRead")}get canList(){return this.rolesPath.get("canList")}get canGenerateCreds(){return this.credsPath.get("canCreate")}},P=U(x.prototype,"backend",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=U(x.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=U(x.prototype,"serviceAccountName",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=U(x.prototype,"kubernetesRoleType",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=U(x.prototype,"kubernetesRoleName",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=U(x.prototype,"allowedKubernetesNamespaces",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=U(x.prototype,"tokenMaxTtl",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=U(x.prototype,"tokenDefaultTtl",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=U(x.prototype,"nameTemplate",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=U(x.prototype,"extraAnnotations",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=U(x.prototype,"extraLabels",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=U(x.prototype,"generatedRoleRules",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=U(x.prototype,"_generationPreference",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=U(x.prototype,"rolePath",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=U(x.prototype,"credsPath",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=U(x.prototype,"rolesPath",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=x))||k)||k)})),define("vault/models/kv/config",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","core/helpers/format-duration"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b
function y(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function v(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=(0,l.withFormFields)(["casRequired","deleteVersionAfter","maxVersions"]),a=(0,t.attr)("number",{label:"Maximum number of versions"}),o=(0,t.attr)("boolean",{label:"Require check and set"}),s=(0,t.attr)({label:"Automate secret deletion"}),u=(0,n.default)(n.apiPath`${"backend"}/config`,"backend"),r((d=class extends t.default{constructor(...e){super(...e),y(this,"backend",p,this),y(this,"maxVersions",f,this),y(this,"casRequired",m,this),y(this,"deleteVersionAfter",h,this),y(this,"configPath",b,this)}get canRead(){return!1!==this.configPath.get("canRead")}get displayFields(){return["casRequired","deleteVersionAfter","maxVersions"]}get displayDeleteTtl(){return"0s"===this.deleteVersionAfter?"Never delete":(0,i.duration)([this.deleteVersionAfter])}},p=v(d.prototype,"backend",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(d.prototype,"maxVersions",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(d.prototype,"casRequired",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=v(d.prototype,"deleteVersionAfter",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=v(d.prototype,"configPath",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=d))||c)})),define("vault/models/kv/data",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","vault/decorators/model-form-fields","kv/utils/kv-deleted","vault/utils/validators"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I,L,U,V,q
function $(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function K(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const B={path:[{type:"presence",message:"Path can't be blank."},{type:"endsInSlash",message:"Path can't end in forward slash '/'."},{type:"containsWhiteSpace",message:(0,a.WHITESPACE_WARNING)("path"),level:"warn"}],secretData:[{validator:e=>void 0===e.secretData||"object"==typeof e.secretData,message:"Vault expects data to be formatted as an JSON object."}]}
e.default=(o=(0,l.withModelValidations)(B),s=(0,i.withFormFields)(),u=(0,t.attr)("string"),c=(0,t.attr)("string",{label:"Path for this secret",subText:"Names with forward slashes define hierarchical path structures."}),d=(0,t.attr)("object"),p=(0,t.attr)("string"),f=(0,t.attr)("object"),m=(0,t.attr)("string"),h=(0,t.attr)("boolean"),b=(0,t.attr)("number"),y=(0,t.attr)("number"),v=(0,t.attr)("number"),g=(0,n.default)(n.apiPath`${"backend"}/data/${"path"}`,"backend","path"),w=(0,n.default)(n.apiPath`${"backend"}/metadata/${"path"}`,"backend","path"),k=(0,n.default)(n.apiPath`${"backend"}/delete/${"path"}`,"backend","path"),x=(0,n.default)(n.apiPath`${"backend"}/destroy/${"path"}`,"backend","path"),P=(0,n.default)(n.apiPath`${"backend"}/undelete/${"path"}`,"backend","path"),_=(0,n.default)(n.apiPath`${"backend"}/subkeys/${"path"}`,"backend","path"),o(T=s((O=class extends t.default{constructor(...e){super(...e),$(this,"backend",j,this),$(this,"path",z,this),$(this,"secretData",M,this),$(this,"createdTime",S,this),$(this,"customMetadata",C,this),$(this,"deletionTime",A,this),$(this,"destroyed",E,this),$(this,"version",R,this),$(this,"failReadErrorCode",D,this),$(this,"casVersion",N,this),$(this,"dataPath",F,this),$(this,"metadataPath",I,this),$(this,"deletePath",L,this),$(this,"destroyPath",U,this),$(this,"undeletePath",V,this),$(this,"subkeysPath",q,this)}get state(){return this.destroyed?"destroyed":this.isSecretDeleted?"deleted":this.createdTime?"created":""}get isSecretDeleted(){return(0,r.isDeleted)(this.deletionTime)}get canDeleteLatestVersion(){return!1!==this.dataPath.get("canDelete")}get canDeleteVersion(){return!1!==this.deletePath.get("canUpdate")}get canUndelete(){return!1!==this.undeletePath.get("canUpdate")}get canDestroyVersion(){return!1!==this.destroyPath.get("canUpdate")}get canEditData(){return!1!==this.dataPath.get("canUpdate")}get canReadData(){return!1!==this.dataPath.get("canRead")}get canReadMetadata(){return!1!==this.metadataPath.get("canRead")}get canUpdateMetadata(){return!1!==this.metadataPath.get("canUpdate")}get canListMetadata(){return!1!==this.metadataPath.get("canList")}get canDeleteMetadata(){return!1!==this.metadataPath.get("canDelete")}get canReadSubkeys(){return!1!==this.subkeysPath.get("canRead")}},j=K(O.prototype,"backend",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=K(O.prototype,"path",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=K(O.prototype,"secretData",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=K(O.prototype,"createdTime",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=K(O.prototype,"customMetadata",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=K(O.prototype,"deletionTime",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=K(O.prototype,"destroyed",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=K(O.prototype,"version",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=K(O.prototype,"failReadErrorCode",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=K(O.prototype,"casVersion",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=K(O.prototype,"dataPath",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=K(O.prototype,"metadataPath",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=K(O.prototype,"deletePath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=K(O.prototype,"destroyPath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V=K(O.prototype,"undeletePath",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),q=K(O.prototype,"subkeysPath",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=O))||T)||T)})),define("vault/models/kv/metadata",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","vault/decorators/model-form-fields","core/utils/key-utils","kv/utils/kv-deleted"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I
function L(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function U(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(o=(0,l.withModelValidations)({maxVersions:[{type:"number",message:"Maximum versions must be a number."},{type:"length",options:{min:1,max:16},message:"You cannot go over 16 characters."}]}),s=(0,i.withFormFields)(["customMetadata","maxVersions","casRequired","deleteVersionAfter"]),u=(0,t.attr)("string"),c=(0,t.attr)("string"),d=(0,t.attr)("string"),p=(0,t.attr)("number",{defaultValue:0,label:"Maximum number of versions",subText:"The number of versions to keep per key. Once the number of keys exceeds the maximum number set here, the oldest version will be permanently deleted."}),f=(0,t.attr)("boolean",{defaultValue:!1,label:"Require Check and Set",subText:"Writes will only be allowed if the key's current version matches the version specified in the cas parameter."}),m=(0,t.attr)("string",{defaultValue:"0s",editType:"ttl",label:"Automate secret deletion",helperTextDisabled:"A secret's version must be manually deleted.",helperTextEnabled:"Delete all new versions of this secret after:"}),h=(0,t.attr)("object",{editType:"kv",isSectionHeader:!0,subText:"An optional set of informational key-value pairs that will be stored with all secret versions."}),b=(0,t.attr)("string"),y=(0,t.attr)("number"),v=(0,t.attr)("number"),g=(0,t.attr)("string"),w=(0,t.attr)("object"),k=(0,n.default)(n.apiPath`${"backend"}/data/${"permissionsPath"}`,"backend","permissionsPath"),x=(0,n.default)(n.apiPath`${"backend"}/metadata/${"permissionsPath"}`,"backend","permissionsPath"),o(P=s((_=class extends t.default{constructor(...e){super(...e),L(this,"backend",T,this),L(this,"path",O,this),L(this,"fullSecretPath",j,this),L(this,"maxVersions",z,this),L(this,"casRequired",M,this),L(this,"deleteVersionAfter",S,this),L(this,"customMetadata",C,this),L(this,"createdTime",A,this),L(this,"currentVersion",E,this),L(this,"oldestVersion",R,this),L(this,"updatedTime",D,this),L(this,"versions",N,this),L(this,"dataPath",F,this),L(this,"metadataPath",I,this)}get pathIsDirectory(){return(0,r.keyIsFolder)(this.path)}get sortedVersions(){const e=[]
for(const t in this.versions)this.versions[t].isSecretDeleted=(0,a.isDeleted)(this.versions[t].deletion_time),e.push({version:t,...this.versions[t]})
return e.reverse()}get currentSecret(){if(!this.versions||!this.currentVersion)return!1
const e=this.versions[this.currentVersion],t=e.destroyed?"destroyed":(0,a.isDeleted)(e.deletion_time)?"deleted":"created"
return{state:t,isDeactivated:"created"!==t,deletionTime:e.deletion_time}}get permissionsPath(){return this.fullSecretPath||this.path}get canDeleteMetadata(){return!1!==this.metadataPath.get("canDelete")}get canReadMetadata(){return!1!==this.metadataPath.get("canRead")}get canUpdateMetadata(){return!1!==this.metadataPath.get("canUpdate")}get canCreateVersionData(){return!1!==this.dataPath.get("canUpdate")}},T=U(_.prototype,"backend",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=U(_.prototype,"path",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=U(_.prototype,"fullSecretPath",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=U(_.prototype,"maxVersions",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=U(_.prototype,"casRequired",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=U(_.prototype,"deleteVersionAfter",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=U(_.prototype,"customMetadata",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=U(_.prototype,"createdTime",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=U(_.prototype,"currentVersion",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=U(_.prototype,"oldestVersion",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=U(_.prototype,"updatedTime",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=U(_.prototype,"versions",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=U(_.prototype,"dataPath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=U(_.prototype,"metadataPath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=_))||P)||P)})),define("vault/models/ldap/config",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l){var i,r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I,L
function U(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function V(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=(0,l.withModelValidations)({binddn:[{type:"presence",message:"Administrator distinguished name is required."}],bindpass:[{type:"presence",message:"Administrator password is required."}]}),r=(0,n.withFormFields)(null,[{default:["binddn","bindpass","url","password_policy"]},{"TLS options":["starttls","insecure_tls","certificate","client_tls_cert","client_tls_key"]},{"More options":["userdn","userattr","upndomain","connection_timeout","request_timeout"]}]),a=(0,t.attr)("string"),o=(0,t.attr)("string",{label:"Administrator Distinguished Name",subText:"Distinguished name of the administrator to bind (Bind DN) when performing user and group search. Example: cn=vault,ou=Users,dc=example,dc=com."}),s=(0,t.attr)("string",{label:"Administrator Password",subText:"Password to use along with Bind DN when performing user search."}),u=(0,t.attr)("string",{label:"URL",subText:"The directory server to connect to."}),c=(0,t.attr)("string",{editType:"optionalText",label:"Use custom password policy",subText:"Specify the name of an existing password policy.",defaultSubText:"Unless a custom policy is specified, Vault will use a default.",defaultShown:"Default",docLink:"/vault/docs/concepts/password-policies"}),d=(0,t.attr)("string"),p=(0,t.attr)("boolean",{label:"Start TLS",subText:"If checked, or address contains “ldaps://”, creates an encrypted connection with LDAP."}),f=(0,t.attr)("boolean",{label:"Insecure TLS",subText:"If checked, skips LDAP server SSL certificate verification - insecure, use with caution!"}),m=(0,t.attr)("string",{editType:"file",label:"CA Certificate",helpText:"CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded."}),h=(0,t.attr)("string",{editType:"file",label:"Client TLS Certificate",helpText:"Client certificate to provide to the LDAP server, must be x509 PEM encoded."}),b=(0,t.attr)("string",{editType:"file",label:"Client TLS Key",helpText:"Client key to provide to the LDAP server, must be x509 PEM encoded."}),y=(0,t.attr)("string",{label:"Userdn",helpText:"The base DN under which to perform user search in library management and static roles."}),v=(0,t.attr)("string",{label:"Userattr",subText:"The attribute field name used to perform user search in library management and static roles."}),g=(0,t.attr)("string",{label:"Upndomain",subText:"The domain (userPrincipalDomain) used to construct a UPN string for authentication."}),w=(0,t.attr)("number",{editType:"optionalText",label:"Connection Timeout",subText:"Specify the connection timeout length in seconds.",defaultSubText:"Vault will use the default of 30 seconds.",defaultShown:"Default 30 seconds."}),k=(0,t.attr)("number",{editType:"optionalText",label:"Request Timeout",subText:"Specify the connection timeout length in seconds.",defaultSubText:"Vault will use the default of 90 seconds.",defaultShown:"Default 90 seconds."}),i(x=r((P=class extends t.default{constructor(...e){super(...e),U(this,"backend",_,this),U(this,"binddn",T,this),U(this,"bindpass",O,this),U(this,"url",j,this),U(this,"password_policy",z,this),U(this,"schema",M,this),U(this,"starttls",S,this),U(this,"insecure_tls",C,this),U(this,"certificate",A,this),U(this,"client_tls_cert",E,this),U(this,"client_tls_key",R,this),U(this,"userdn",D,this),U(this,"userattr",N,this),U(this,"upndomain",F,this),U(this,"connection_timeout",I,this),U(this,"request_timeout",L,this)}async rotateRoot(){return this.store.adapterFor("ldap/config").rotateRoot(this.backend)}},_=V(P.prototype,"backend",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=V(P.prototype,"binddn",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=V(P.prototype,"bindpass",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=V(P.prototype,"url",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=V(P.prototype,"password_policy",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=V(P.prototype,"schema",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=V(P.prototype,"starttls",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=V(P.prototype,"insecure_tls",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=V(P.prototype,"certificate",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=V(P.prototype,"client_tls_cert",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=V(P.prototype,"client_tls_key",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=V(P.prototype,"userdn",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=V(P.prototype,"userattr",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=V(P.prototype,"upndomain",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=V(P.prototype,"connection_timeout",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=V(P.prototype,"request_timeout",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=P))||x)||x)})),define("vault/models/ldap/library",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations","vault/macros/lazy-capabilities"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S
function C(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function A(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=(0,l.withModelValidations)({name:[{type:"presence",message:"Library name is required."}],service_account_names:[{type:"presence",message:"At least one service account is required."}]}),a=(0,n.withFormFields)(["name","service_account_names","ttl","max_ttl","disable_check_in_enforcement"]),o=(0,t.attr)("string"),s=(0,t.attr)("string"),u=(0,t.attr)("string",{label:"Library name",editDisabled:!0}),c=(0,t.attr)("string",{editType:"stringArray",label:"Accounts",subText:"The names of all the accounts that can be checked out from this set. These accounts must only be used by Vault, and may only be in one set."}),d=(0,t.attr)({editType:"ttl",label:"Default lease TTL",detailsLabel:"TTL",helperTextDisabled:"Vault will use the default lease duration.",defaultValue:"24h",defaultShown:"Engine default"}),p=(0,t.attr)({editType:"ttl",label:"Max lease TTL",detailsLabel:"Max TTL",helperTextDisabled:"Vault will use the default lease duration.",defaultValue:"24h",defaultShown:"Engine default"}),f=(0,t.attr)("string",{editType:"radio",label:"Check-in enforcement",subText:"When enabled, accounts must be checked in by the entity or client token that checked them out. If disabled, anyone with the right permission can check the account back in.",possibleValues:["Disabled","Enabled"],defaultValue:"Enabled"}),m=(0,i.default)(i.apiPath`${"backend"}/library/${"name"}`,"backend","name"),h=(0,i.default)(i.apiPath`${"backend"}/library/${"name"}/status`,"backend","name"),b=(0,i.default)(i.apiPath`${"backend"}/library/${"name"}/check-out`,"backend","name"),y=(0,i.default)(i.apiPath`${"backend"}/library/${"name"}/check-in`,"backend","name"),r(v=a((g=class extends t.default{constructor(...e){super(...e),C(this,"backend",w,this),C(this,"path_to_library",k,this),C(this,"name",x,this),C(this,"service_account_names",P,this),C(this,"ttl",_,this),C(this,"max_ttl",T,this),C(this,"disable_check_in_enforcement",O,this),C(this,"libraryPath",j,this),C(this,"statusPath",z,this),C(this,"checkOutPath",M,this),C(this,"checkInPath",S,this)}get completeLibraryName(){return this.path_to_library?this.path_to_library+this.name:this.name}get displayFields(){return this.formFields.filter((e=>"service_account_names"!==e.name))}get canCreate(){return!1!==this.libraryPath.get("canCreate")}get canDelete(){return!1!==this.libraryPath.get("canDelete")}get canEdit(){return!1!==this.libraryPath.get("canUpdate")}get canRead(){return!1!==this.libraryPath.get("canRead")}get canList(){return!1!==this.libraryPath.get("canList")}get canReadStatus(){return!1!==this.statusPath.get("canRead")}get canCheckOut(){return!1!==this.checkOutPath.get("canUpdate")}get canCheckIn(){return!1!==this.checkInPath.get("canUpdate")}fetchStatus(){return this.store.adapterFor("ldap/library").fetchStatus(this.backend,this.name)}checkOutAccount(e){return this.store.adapterFor("ldap/library").checkOutAccount(this.backend,this.name,e)}checkInAccount(e){return this.store.adapterFor("ldap/library").checkInAccount(this.backend,this.name,[e])}},w=A(g.prototype,"backend",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=A(g.prototype,"path_to_library",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=A(g.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=A(g.prototype,"service_account_names",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=A(g.prototype,"ttl",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=A(g.prototype,"max_ttl",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=A(g.prototype,"disable_check_in_enforcement",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=A(g.prototype,"libraryPath",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=A(g.prototype,"statusPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=A(g.prototype,"checkOutPath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=A(g.prototype,"checkInPath",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=g))||v)||v)})),define("vault/models/ldap/role",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations","vault/macros/lazy-capabilities"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I,L,U
function V(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function q(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.staticRoleFields=e.dynamicRoleFields=e.default=void 0
e.staticRoleFields=["username","dn","rotation_period"],e.dynamicRoleFields=["default_ttl","max_ttl","username_template","creation_ldif","deletion_ldif","rollback_ldif"]
e.default=(r=(0,l.withModelValidations)({name:[{type:"presence",message:"Name is required"}],username:[{validator:e=>!(e.isStatic&&!e.username),message:"Username is required."}],rotation_period:[{validator:e=>!(e.isStatic&&!e.rotation_period),message:"Rotation Period is required."}],creation_ldif:[{validator:e=>!(e.isDynamic&&!e.creation_ldif),message:"Creation LDIF is required."}],deletion_ldif:[{validator:e=>!(e.isDynamic&&!e.creation_ldif),message:"Deletion LDIF is required."}]}),a=(0,n.withFormFields)(),o=(0,t.attr)("string"),s=(0,t.attr)("string"),u=(0,t.attr)("string",{defaultValue:"static"}),c=(0,t.attr)("string",{label:"Role name",subText:"The name of the role that will be used in Vault.",editDisabled:!0}),d=(0,t.attr)("string",{label:"Distinguished name",subText:"Distinguished name (DN) of entry Vault should manage."}),p=(0,t.attr)("string",{label:"Username",subText:"The name of the user to be used when logging in. This is useful when DN isn't used for login purposes."}),f=(0,t.attr)({editType:"ttl",label:"Rotation period",helperTextEnabled:"Specifies the amount of time Vault should wait before rotating the password. The minimum is 5 seconds.",hideToggle:!0}),m=(0,t.attr)({editType:"ttl",label:"Generated credential’s time-to-live (TTL)",detailsLabel:"TTL",helperTextDisabled:"Vault will use the default of 1 hour.",defaultValue:"1h",defaultShown:"Engine default"}),h=(0,t.attr)({editType:"ttl",label:"Generated credential’s maximum time-to-live (Max TTL)",detailsLabel:"Max TTL",helperTextDisabled:"Vault will use the engine default of 24 hours.",defaultValue:"24h",defaultShown:"Engine default"}),b=(0,t.attr)("string",{editType:"optionalText",label:"Username template",subText:"Enter the custom username template to use.",defaultSubText:"Template describing how dynamic usernames are generated. Vault will use the default for this plugin.",docLink:"/vault/docs/concepts/username-templating",defaultShown:"Default"}),y=(0,t.attr)("string",{editType:"json",label:"Creation LDIF",helpText:"Specifies the LDIF statements executed to create a user. May optionally be base64 encoded.",example:"# The example below is treated as a comment and will not be submitted\n# dn: cn={{.Username}},ou=users,dc=learn,dc=example\n# objectClass: person\n# objectClass: top\n",mode:"ruby",sectionHeading:"LDIF Statements"}),v=(0,t.attr)("string",{editType:"json",label:"Deletion LDIF",helpText:"Specifies the LDIF statements executed to delete a user once its TTL has expired. May optionally be base64 encoded.",example:"# The example below is treated as a comment and will not be submitted\n# dn: cn={{.Username}},ou=users,dc=learn,dc=example\n# changetype: delete\n",mode:"ruby"}),g=(0,t.attr)("string",{editType:"json",label:"Rollback LDIF",helpText:"Specifies the LDIF statement to attempt to rollback any changes if the creation results in an error. May optionally be base64 encoded.",example:"# The example below is treated as a comment and will not be submitted\n# dn: cn={{.Username}},ou=users,dc=learn,dc=example\n# changetype: delete\n",mode:"ruby"}),w=(0,i.default)(i.apiPath`${"backend"}/${"roleUri"}/${"name"}`,"backend","roleUri","name"),k=(0,i.default)(i.apiPath`${"backend"}/${"credsUri"}/${"name"}`,"backend","credsUri","name"),x=(0,i.default)(i.apiPath`${"backend"}/rotate-role/${"name"}`,"backend","name"),r(P=a((_=class extends t.default{constructor(...e){super(...e),V(this,"backend",T,this),V(this,"path_to_role",O,this),V(this,"type",j,this),V(this,"name",z,this),V(this,"dn",M,this),V(this,"username",S,this),V(this,"rotation_period",C,this),V(this,"default_ttl",A,this),V(this,"max_ttl",E,this),V(this,"username_template",R,this),V(this,"creation_ldif",D,this),V(this,"deletion_ldif",N,this),V(this,"rollback_ldif",F,this),V(this,"rolePath",I,this),V(this,"credsPath",L,this),V(this,"staticRotateCredsPath",U,this)}get completeRoleName(){return this.path_to_role?this.path_to_role+this.name:this.name}get isStatic(){return"static"===this.type}get isDynamic(){return"dynamic"===this.type}get fieldsForType(){return this.isStatic?["username","dn","rotation_period"]:["default_ttl","max_ttl","username_template","creation_ldif","deletion_ldif","rollback_ldif"]}get formFields(){return this.allFields.filter((e=>"name"===e.name||this.fieldsForType.includes(e.name)))}get displayFields(){const[e,...t]=this.formFields
return[e,{name:"type",options:{label:"Role type"}},...t]}get roleUri(){return this.isStatic?"static-role":"role"}get credsUri(){return this.isStatic?"static-cred":"creds"}get canCreate(){return!1!==this.rolePath.get("canCreate")}get canDelete(){return!1!==this.rolePath.get("canDelete")}get canEdit(){return!1!==this.rolePath.get("canUpdate")}get canRead(){return!1!==this.rolePath.get("canRead")}get canList(){return!1!==this.rolePath.get("canList")}get canReadCreds(){return!1!==this.credsPath.get("canRead")}get canRotateStaticCreds(){return this.isStatic&&!1!==this.staticRotateCredsPath.get("canCreate")}fetchCredentials(){return this.store.adapterFor("ldap/role").fetchCredentials(this.backend,this.type,this.completeRoleName)}rotateStaticPassword(){return this.store.adapterFor("ldap/role").rotateStaticPassword(this.backend,this.completeRoleName)}},T=q(_.prototype,"backend",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=q(_.prototype,"path_to_role",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=q(_.prototype,"type",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=q(_.prototype,"name",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=q(_.prototype,"dn",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=q(_.prototype,"username",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=q(_.prototype,"rotation_period",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=q(_.prototype,"default_ttl",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=q(_.prototype,"max_ttl",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=q(_.prototype,"username_template",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=q(_.prototype,"creation_ldif",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=q(_.prototype,"deletion_ldif",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=q(_.prototype,"rollback_ldif",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=q(_.prototype,"rolePath",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=q(_.prototype,"credsPath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=q(_.prototype,"staticRotateCredsPath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=_))||P)||P)})),define("vault/models/lease",["exports","@ember-data/model","@ember/object/computed","vault/mixins/key-mixin"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend(l.default,{issueTime:(0,t.attr)("string"),expireTime:(0,t.attr)("string"),lastRenewal:(0,t.attr)("string"),renewable:(0,t.attr)("boolean"),ttl:(0,t.attr)("number"),isAuthLease:(0,n.match)("id",/^auth/)})})),define("vault/models/license",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({expirationTime:(0,t.attr)("string"),features:(0,t.attr)("array"),licenseId:(0,t.attr)("string"),startTime:(0,t.attr)("string"),performanceStandbyCount:(0,t.attr)("number"),autoloaded:(0,t.attr)("boolean")})})),define("vault/models/mfa-login-enforcement",["exports","@ember-data/model","@ember/array/proxy","@ember/object/promise-proxy-mixin","vault/helpers/mountable-auth-methods","vault/decorators/model-validations","@ember/utils","@ember/service","vault/helpers/add-to-array"],(function(e,t,n,l,i,r,a,o,s){var u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O
function j(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function z(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const M={name:[{type:"presence",message:"Name is required"}],mfa_methods:[{type:"presence",message:"At least one MFA method is required"}],targets:[{validator(e){const t=e.hasMany("identity_entities").ids(),n=e.hasMany("identity_groups").ids()
return(0,a.isPresent)(e.auth_method_accessors)||(0,a.isPresent)(e.auth_method_types)||(0,a.isPresent)(t)||(0,a.isPresent)(n)},message:"At least one target is required. If you've selected one, click 'Add' to make sure it's added to this enforcement."}]}
e.default=(u=(0,r.withModelValidations)(M),c=(0,t.attr)("string"),d=(0,t.hasMany)("mfa-method",{async:!0,inverse:null}),p=(0,t.attr)("string"),f=(0,t.attr)("array",{defaultValue:()=>[]}),m=(0,t.attr)("array",{defaultValue:()=>[]}),h=(0,t.hasMany)("identity/entity",{async:!0,inverse:null}),b=(0,t.hasMany)("identity/group",{async:!0,inverse:null}),u((v=class extends t.default{constructor(...e){super(...e),j(this,"store",g,this),j(this,"name",w,this),j(this,"mfa_methods",k,this),j(this,"namespace_id",x,this),j(this,"auth_method_accessors",P,this),j(this,"auth_method_types",_,this),j(this,"identity_entities",T,this),j(this,"identity_groups",O,this)}get targets(){return n.default.extend(l.default).create({promise:this.prepareTargets()})}async prepareTargets(){let e,t=[]
if(this.auth_method_accessors.length||this.auth_method_types.length)try{const{data:t}=await this.store.adapterFor("auth-method").findAll()
e=Object.keys(t).map((e=>({path:e,...t[e]})))}catch(n){}if(this.auth_method_accessors.length){const n=e.filter((e=>this.auth_method_accessors.includes(e.accessor)))
t=(0,s.addManyToArray)(t,n.map((e=>({icon:this.iconForMount(e.type),link:"vault.cluster.access.method",linkModels:[e.path.slice(0,-1)],title:e.path,subTitle:e.accessor}))))}this.auth_method_types.forEach((n=>{const l=this.iconForMount(n),i=e.filterBy("type",n).length
t=(0,s.addToArray)(t,{key:"auth_method_types",icon:l,title:n,subTitle:`All ${n} mounts (${i})`})}))
for(const l of["identity_entities","identity_groups"])(await this[l]).forEach((e=>{t=(0,s.addToArray)(t,{key:l,icon:"user",link:"vault.cluster.access.identity.show",linkModels:[l.split("_")[1],e.id,"details"],title:e.name,subTitle:e.id})}))
return t}iconForMount(e){const t=(0,i.methods)().find((t=>t.type===e))
return t?t.glyph||t.type:"token"}},g=z(v.prototype,"store",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=z(v.prototype,"name",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=z(v.prototype,"mfa_methods",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=z(v.prototype,"namespace_id",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=z(v.prototype,"auth_method_accessors",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=z(v.prototype,"auth_method_types",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=z(v.prototype,"identity_entities",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=z(v.prototype,"identity_groups",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=v))||y)})),define("vault/models/mfa-method",["exports","@ember-data/model","@ember/string","vault/utils/field-to-attrs","vault/decorators/model-validations","@ember/utils"],(function(e,t,n,l,i,r){var a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I,L,U,V,q,$,K,B,G,W,H,Q,Y,J,X,Z,ee,te,ne,le,ie,re,ae,oe,se
function ue(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function ce(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const de={common:[],duo:["username_format","secret_key","integration_key","api_hostname","push_info","use_passcode"],okta:["username_format","mount_accessor","org_name","api_token","base_url","primary_email"],totp:["issuer","period","key_size","qr_size","algorithm","digits","skew","max_validation_attempts"],pingid:["username_format","settings_file_base64","use_signature","idp_url","admin_url","authenticator_url","org_alias"]},pe={duo:["secret_key","integration_key","api_hostname"],okta:["org_name","api_token"],totp:["issuer"],pingid:["settings_file_base64"]},fe=Object.keys(pe).reduce(((e,t)=>(pe[t].forEach((n=>{e[`${n}`]=[{message:`${n.replace(/_/g," ")} is required`,validator:e=>e.type!==t||(0,r.isPresent)(e[n])}]})),e)),{})
e.default=(a=(0,i.withModelValidations)(fe),o=(0,t.attr)("string"),s=(0,t.attr)("string",{label:"Username format",subText:"How to map identity names to MFA method names. "}),u=(0,t.attr)("string",{label:"Namespace"}),c=(0,t.attr)("string"),d=(0,t.attr)("string",{label:"Settings file",subText:"A base-64 encoded third party setting file retrieved from the PingIDs configuration page."}),p=(0,t.attr)("boolean"),f=(0,t.attr)("string"),m=(0,t.attr)("string"),h=(0,t.attr)("string"),b=(0,t.attr)("string"),y=(0,t.attr)("string",{label:"Organization name",subText:"Name of the organization to be used in the Okta API."}),v=(0,t.attr)("string",{label:"Okta API key"}),g=(0,t.attr)("string",{label:"Base URL",subText:"If set, will be used as the base domain for API requests. Example are okta.com, oktapreview.com and okta-emea.com."}),w=(0,t.attr)("boolean"),k=(0,t.attr)("string",{label:"Duo secret key",sensitive:!0}),x=(0,t.attr)("string",{label:"Duo integration key",sensitive:!0}),P=(0,t.attr)("string",{label:"Duo API hostname"}),_=(0,t.attr)("string",{label:"Duo push information",subText:"Additional information displayed to the user when the push is presented to them."}),T=(0,t.attr)("boolean",{label:"Passcode reminder",subText:"If this is turned on, the user is reminded to use the passcode upon MFA validation."}),O=(0,t.attr)("string",{label:"Issuer",subText:"The human-readable name of the keys issuing organization."}),j=(0,t.attr)({label:"Period",editType:"ttl",helperTextEnabled:"How long each generated TOTP is valid.",hideToggle:!0,defaultValue:30}),z=(0,t.attr)("number",{label:"Key size",subText:"The size in bytes of the Vault generated key."}),M=(0,t.attr)("number",{label:"QR size",subText:"The pixel size of the generated square QR code."}),S=(0,t.attr)("string",{label:"Algorithm",editType:"radio",possibleValues:["SHA1","SHA256","SHA512"],subText:"The hashing algorithm used to generate the TOTP code."}),C=(0,t.attr)("number",{label:"Digits",editType:"radio",possibleValues:[6,8],subText:"The number digits in the generated TOTP code."}),A=(0,t.attr)("number",{label:"Skew",editType:"radio",possibleValues:[0,1],subText:"The number of delay periods allowed when validating a TOTP token."}),E=(0,t.attr)("number"),a((D=class extends t.default{constructor(...e){super(...e),ue(this,"type",N,this),ue(this,"username_format",F,this),ue(this,"namespace_id",I,this),ue(this,"mount_accessor",L,this),ue(this,"settings_file_base64",U,this),ue(this,"use_signature",V,this),ue(this,"idp_url",q,this),ue(this,"admin_url",$,this),ue(this,"authenticator_url",K,this),ue(this,"org_alias",B,this),ue(this,"org_name",G,this),ue(this,"api_token",W,this),ue(this,"base_url",H,this),ue(this,"primary_email",Q,this),ue(this,"secret_key",Y,this),ue(this,"integration_key",J,this),ue(this,"api_hostname",X,this),ue(this,"push_info",Z,this),ue(this,"use_passcode",ee,this),ue(this,"issuer",te,this),ue(this,"period",ne,this),ue(this,"key_size",le,this),ue(this,"qr_size",ie,this),ue(this,"algorithm",re,this),ue(this,"digits",ae,this),ue(this,"skew",oe,this),ue(this,"max_validation_attempts",se,this)}get name(){return"totp"===this.type?this.type.toUpperCase():(0,n.capitalize)(this.type)}get icon(){return"totp"===this.type?"history":this.type}get formFields(){return[...de.common,...de[this.type]]}get attrs(){return(0,l.expandAttributeMeta)(this,this.formFields)}},N=ce(D.prototype,"type",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=ce(D.prototype,"username_format",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=ce(D.prototype,"namespace_id",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=ce(D.prototype,"mount_accessor",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=ce(D.prototype,"settings_file_base64",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V=ce(D.prototype,"use_signature",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),q=ce(D.prototype,"idp_url",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),$=ce(D.prototype,"admin_url",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),K=ce(D.prototype,"authenticator_url",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),B=ce(D.prototype,"org_alias",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),G=ce(D.prototype,"org_name",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),W=ce(D.prototype,"api_token",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),H=ce(D.prototype,"base_url",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Q=ce(D.prototype,"primary_email",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Y=ce(D.prototype,"secret_key",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),J=ce(D.prototype,"integration_key",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),X=ce(D.prototype,"api_hostname",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Z=ce(D.prototype,"push_info",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ee=ce(D.prototype,"use_passcode",[T],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),te=ce(D.prototype,"issuer",[O],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ne=ce(D.prototype,"period",[j],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),le=ce(D.prototype,"key_size",[z],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ie=ce(D.prototype,"qr_size",[M],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),re=ce(D.prototype,"algorithm",[S],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ae=ce(D.prototype,"digits",[C],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),oe=ce(D.prototype,"skew",[A],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),se=ce(D.prototype,"max_validation_attempts",[E],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=D))||R)})),define("vault/models/mount-config",["exports","@ember-data/model"],(function(e,t){var n,l,i,r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A
function E(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function R(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(n=(0,t.attr)({label:"Default Lease TTL",editType:"ttl"}),l=(0,t.attr)({label:"Max Lease TTL",editType:"ttl"}),i=(0,t.attr)({label:"Request keys excluded from HMACing in audit",editType:"stringArray",helpText:"Keys that will not be HMAC'd by audit devices in the request data object."}),r=(0,t.attr)({label:"Response keys excluded from HMACing in audit",editType:"stringArray",helpText:"Keys that will not be HMAC'd by audit devices in the response data object."}),a=(0,t.attr)("mountVisibility",{editType:"boolean",label:"List method when unauthenticated",defaultValue:!1}),o=(0,t.attr)({label:"Allowed passthrough request headers",helpText:"Headers to allow and pass from the request to the backend",editType:"stringArray"}),s=(0,t.attr)({label:"Allowed response headers",helpText:"Headers to allow, allowing a plugin to include them in the response.",editType:"stringArray"}),u=(0,t.attr)("string",{label:"Token type",helpText:"The type of token that should be generated via this role. For `default-service` and `default-batch` service and batch tokens will be issued respectively, unless the auth method explicitly requests a different type.",possibleValues:["default-service","default-batch","batch","service"],noDefault:!0}),c=(0,t.attr)({editType:"stringArray"}),d=(0,t.attr)("string",{label:"Plugin version",subText:'Specifies the semantic version of the plugin to use, e.g. "v1.0.0". If unspecified, the server will select any matching un-versioned plugin that may have been registered, the latest versioned plugin registered, or a built-in plugin in that order of precedence.'}),p=(0,t.attr)({label:"Identity token key",subText:"A named key to sign tokens. If not provided, this will default to Vault's OIDC default key.",editType:"yield"}),f=(0,t.attr)("string",{label:"Lockout threshold",subText:"Specifies the number of failed login attempts after which the user is locked out, e.g. 15."}),m=(0,t.attr)({label:"Lockout duration",helperTextEnabled:'The duration for which a user will be locked out, e.g. "5s" or "30m".',editType:"ttl",helperTextDisabled:"No lockout duration configured."}),h=(0,t.attr)({label:"Lockout counter reset",helperTextEnabled:'The duration after which the lockout counter is reset with no failed login attempts, e.g. "5s" or "30m".',editType:"ttl",helperTextDisabled:"No reset duration configured."}),b=(0,t.attr)("boolean",{label:"Disable lockout for this mount",subText:"If checked, disables the user lockout feature for this mount."}),y=class extends t.default{constructor(...e){super(...e),E(this,"defaultLeaseTtl",v,this),E(this,"maxLeaseTtl",g,this),E(this,"auditNonHmacRequestKeys",w,this),E(this,"auditNonHmacResponseKeys",k,this),E(this,"listingVisibility",x,this),E(this,"passthroughRequestHeaders",P,this),E(this,"allowedResponseHeaders",_,this),E(this,"tokenType",T,this),E(this,"allowedManagedKeys",O,this),E(this,"pluginVersion",j,this),E(this,"identityTokenKey",z,this),E(this,"lockoutThreshold",M,this),E(this,"lockoutDuration",S,this),E(this,"lockoutCounterReset",C,this),E(this,"lockoutDisable",A,this)}},v=R(y.prototype,"defaultLeaseTtl",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=R(y.prototype,"maxLeaseTtl",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=R(y.prototype,"auditNonHmacRequestKeys",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=R(y.prototype,"auditNonHmacResponseKeys",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=R(y.prototype,"listingVisibility",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=R(y.prototype,"passthroughRequestHeaders",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=R(y.prototype,"allowedResponseHeaders",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=R(y.prototype,"tokenType",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=R(y.prototype,"allowedManagedKeys",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=R(y.prototype,"pluginVersion",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=R(y.prototype,"identityTokenKey",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=R(y.prototype,"lockoutThreshold",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=R(y.prototype,"lockoutDuration",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=R(y.prototype,"lockoutCounterReset",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=R(y.prototype,"lockoutDisable",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y)})),define("vault/models/namespace",["exports","@ember-data/model","vault/decorators/model-expanded-attributes","vault/decorators/model-validations"],(function(e,t,n,l){var i,r,a,o,s,u
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(i=(0,n.withExpandedAttributes)(),r=(0,l.withModelValidations)({path:[{type:"presence",message:"Path can't be blank."},{type:"endsInSlash",message:"Path can't end in forward slash '/'."},{type:"containsWhiteSpace",message:"Path can't contain whitespace."}]}),a=(0,t.attr)("string"),i(o=r((s=class extends t.default{constructor(...e){var t,n,l,i
super(...e),t=this,n="path",i=this,(l=u)&&Object.defineProperty(t,n,{enumerable:l.enumerable,configurable:l.configurable,writable:l.writable,value:l.initializer?l.initializer.call(i):void 0})}get fields(){return["path"].map((e=>this.allByKey[e]))}},c=s.prototype,d="path",p=[a],f={configurable:!0,enumerable:!0,writable:!0,initializer:null},h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),u=void 0===h.initializer?(Object.defineProperty(c,d,h),null):h,o=s))||o)||o)
var c,d,p,f,m,h})),define("vault/models/node",["exports","@ember-data/model","@ember/object/computed"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({name:(0,t.attr)("string"),standby:(0,t.attr)("boolean"),isActive:(0,n.equal)("standby",!1),clusterId:(0,t.attr)("string"),isLeader:(0,n.and)("initialized","isActive"),initialized:(0,t.attr)("boolean"),sealed:(0,t.attr)("boolean"),isSealed:(0,n.alias)("sealed"),t:(0,t.attr)("number"),n:(0,t.attr)("number"),progress:(0,t.attr)("number"),sealThreshold:(0,n.alias)("t"),sealNumShares:(0,n.alias)("n"),version:(0,t.attr)("string"),type:(0,t.attr)("string"),storageType:(0,t.attr)("string"),hcpLinkStatus:(0,t.attr)("string"),haEnabled:(0,t.attr)("boolean"),isSelf:(0,t.attr)("boolean"),leaderAddress:(0,t.attr)("string")})})),define("vault/models/oidc/assignment",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","@ember/utils"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v={name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}],targets:[{validator:e=>(0,i.isPresent)(e.entityIds)||(0,i.isPresent)(e.groupIds),message:"At least one entity or group is required."}]}
e.default=(r=(0,l.withModelValidations)(v),a=(0,t.attr)("string"),o=(0,t.attr)("array"),s=(0,t.attr)("array"),u=(0,n.default)(n.apiPath`identity/oidc/assignment/${"name"}`,"name"),r((d=class extends t.default{constructor(...e){super(...e),b(this,"name",p,this),b(this,"entityIds",f,this),b(this,"groupIds",m,this),b(this,"assignmentPath",h,this)}get canRead(){return this.assignmentPath.get("canRead")}get canEdit(){return this.assignmentPath.get("canUpdate")}get canDelete(){return this.assignmentPath.get("canDelete")}},p=y(d.prototype,"name",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=y(d.prototype,"entityIds",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(d.prototype,"groupIds",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=y(d.prototype,"assignmentPath",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=d))||c)})),define("vault/models/oidc/client",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j
function z(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function M(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function S(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=(0,i.withModelValidations)({name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}],key:[{type:"presence",message:"Key is required."}]}),a=(0,t.attr)("string",{label:"Application name",editDisabled:!0}),o=(0,t.attr)("string",{label:"Type",subText:"Specify whether the application type is confidential or public. The public type must use PKCE. This cannot be edited later.",editType:"radio",editDisabled:!0,defaultValue:"confidential",possibleValues:["confidential","public"]}),s=(0,t.attr)("array",{label:"Redirect URIs",subText:"One of these values must exactly match the redirect_uri parameter value used in each authentication request.",editType:"stringArray"}),u=(0,t.attr)("string",{label:"Signing key",subText:"Add a key to sign and verify the JSON web tokens (JWT). This cannot be edited later.",editType:"searchSelect",editDisabled:!0,onlyAllowExisting:!0,defaultValue:()=>["default"],fallbackComponent:"input-search",selectLimit:1,models:["oidc/key"]}),c=(0,t.attr)({label:"Access Token TTL",editType:"ttl",defaultValue:"24h"}),d=(0,t.attr)({label:"ID Token TTL",editType:"ttl",defaultValue:"24h"}),p=(0,t.attr)("array",{label:"Assign access"}),f=(0,t.attr)("string",{label:"Client ID"}),m=(0,t.attr)("string"),h=(0,n.default)(n.apiPath`identity/oidc/client/${"name"}`,"name"),r((y=class extends t.default{constructor(...e){super(...e),z(this,"name",v,this),z(this,"clientType",g,this),z(this,"redirectUris",w,this),z(this,"key",k,this),z(this,"accessTokenTtl",x,this),z(this,"idTokenTtl",P,this),z(this,"assignments",_,this),z(this,"clientId",T,this),z(this,"clientSecret",O,this),M(this,"_attributeMeta",null),M(this,"_fieldToAttrsGroups",null),z(this,"clientPath",j,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","clientType","redirectUris"])),this._attributeMeta}get fieldGroups(){return this._fieldToAttrsGroups||(this._fieldToAttrsGroups=(0,l.default)(this,[{"More options":["key","idTokenTtl","accessTokenTtl"]}])),this._fieldToAttrsGroups}get canRead(){return!1!==this.clientPath.get("canRead")}get canEdit(){return!1!==this.clientPath.get("canUpdate")}get canDelete(){return!1!==this.clientPath.get("canDelete")}},v=S(y.prototype,"name",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=S(y.prototype,"clientType",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=S(y.prototype,"redirectUris",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=S(y.prototype,"key",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=S(y.prototype,"accessTokenTtl",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=S(y.prototype,"idTokenTtl",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=S(y.prototype,"assignments",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=S(y.prototype,"clientId",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=S(y.prototype,"clientSecret",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=S(y.prototype,"clientPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=y))||b)})),define("vault/models/oidc/key",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function _(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=(0,i.withModelValidations)({name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}]}),a=(0,t.attr)("string",{editDisabled:!0}),o=(0,t.attr)("string",{defaultValue:"RS256",possibleValues:["RS256","RS384","RS512","ES256","ES384","ES512","EdDSA"]}),s=(0,t.attr)({editType:"ttl",defaultValue:"24h"}),u=(0,t.attr)({label:"Verification TTL",editType:"ttl",defaultValue:"24h"}),c=(0,t.attr)("array",{label:"Allowed applications"}),d=(0,n.default)(n.apiPath`identity/oidc/key/${"name"}`,"name"),p=(0,n.default)(n.apiPath`identity/oidc/key/${"name"}/rotate`,"name"),r((m=class extends t.default{constructor(...e){super(...e),x(this,"name",h,this),x(this,"algorithm",b,this),x(this,"rotationPeriod",y,this),x(this,"verificationTtl",v,this),x(this,"allowedClientIds",g,this),P(this,"_attributeMeta",null),x(this,"keyPath",w,this),x(this,"rotatePath",k,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","algorithm","rotationPeriod","verificationTtl"])),this._attributeMeta}get canRead(){return this.keyPath.get("canRead")}get canEdit(){return this.keyPath.get("canUpdate")}get canRotate(){return this.rotatePath.get("canUpdate")}get canDelete(){return this.keyPath.get("canDelete")}},h=_(m.prototype,"name",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=_(m.prototype,"algorithm",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=_(m.prototype,"rotationPeriod",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=_(m.prototype,"verificationTtl",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=_(m.prototype,"allowedClientIds",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=_(m.prototype,"keyPath",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=_(m.prototype,"rotatePath",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=m))||f)})),define("vault/models/oidc/provider",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function w(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=(0,i.withModelValidations)({name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}]}),a=(0,t.attr)("string",{editDisabled:!0}),o=(0,t.attr)("string",{subText:"The scheme, host, and optional port for your issuer. This will be used to build the URL that validates ID tokens.",placeholderText:"e.g. https://example.com:8200",docLink:"/vault/api-docs/secret/identity/oidc-provider#create-or-update-a-provider",helpText:"Optional. This defaults to a URL with Vault's api_addr"}),s=(0,t.attr)("array",{label:"Supported scopes",subText:"Scopes define information about a user and the OIDC service. Optional.",editType:"searchSelect",models:["oidc/scope"],fallbackComponent:"string-list",onlyAllowExisting:!0}),u=(0,t.attr)("array",{label:"Allowed applications"}),c=(0,n.default)(n.apiPath`identity/oidc/provider/${"name"}`,"name"),r((p=class extends t.default{constructor(...e){super(...e),v(this,"name",f,this),v(this,"issuer",m,this),v(this,"scopesSupported",h,this),v(this,"allowedClientIds",b,this),g(this,"_attributeMeta",null),v(this,"providerPath",y,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","issuer","scopesSupported"])),this._attributeMeta}get canRead(){return!1!==this.providerPath.get("canRead")}get canEdit(){return!1!==this.providerPath.get("canUpdate")}get canDelete(){return!1!==this.providerPath.get("canDelete")}},f=w(p.prototype,"name",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=w(p.prototype,"issuer",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=w(p.prototype,"scopesSupported",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=w(p.prototype,"allowedClientIds",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=w(p.prototype,"providerPath",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p))||d)})),define("vault/models/oidc/scope",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,i){var r,a,o,s,u,c,d,p,f,m,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var l=n.call(e,t||"default")
if("object"!=typeof l)return l
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function v(e,t,n,l,i){var r={}
return Object.keys(l).forEach((function(e){r[e]=l[e]})),r.enumerable=!!r.enumerable,r.configurable=!!r.configurable,("value"in r||r.initializer)&&(r.writable=!0),r=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),r),i&&void 0!==r.initializer&&(r.value=r.initializer?r.initializer.call(i):void 0,r.initializer=void 0),void 0===r.initializer?(Object.defineProperty(e,t,r),null):r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(r=(0,i.withModelValidations)({name:[{type:"presence",message:"Name is required."}]}),a=(0,t.attr)("string",{editDisabled:!0}),o=(0,t.attr)("string",{editType:"textarea"}),s=(0,t.attr)("string",{label:"JSON Template",editType:"json",mode:"ruby"}),u=(0,n.default)(n.apiPath`identity/oidc/scope/${"name"}`,"name"),r((d=class extends t.default{constructor(...e){super(...e),b(this,"name",p,this),b(this,"description",f,this),b(this,"template",m,this),y(this,"_attributeMeta",null),b(this,"scopePath",h,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","description","template"])),this._attributeMeta}get canRead(){return this.scopePath.get("canRead")}get canEdit(){return this.scopePath.get("canUpdate")}get canDelete(){return this.scopePath.get("canDelete")}},p=v(d.prototype,"name",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(d.prototype,"description",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(d.prototype,"template",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=v(d.prototype,"scopePath",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=d))||c)})),define("vault/models/path-filter-config",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({mode:(0,t.attr)("string"),paths:(0,t.attr)("array",{defaultValue:function(){return[]}})})})),define("vault/models/pki/action",["exports","@ember-data/model","@ember/service","@glimmer/tracking","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l,i,r,a){var o,s,u,c,d,p,f,m,h,b,y,v,g,w,k,x,P,_,T,O,j,z,M,S,C,A,E,R,D,N,F,I,L,U,V,q,$,K,B,G,W,H,Q,Y,J,X,Z,ee,te,ne,le,ie,re,ae,oe,se,ue,ce,de,pe,fe,me,he,be,ye,ve,ge,we,ke,xe,Pe,_e,Te,Oe,je,ze,Me,Se,Ce,Ae,Ee,Re,De,Ne,Fe,Ie,Le,Ue,Ve,qe,$e,Ke,Be,Ge,We,He,Qe,Ye
function Je(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,